import cvxpy as cp
import numpy as np

class Cost_Allocation(object):
    def __init__(self, env):
        self.env = env

    # Shapley Value
    def SV(self, J):

        beta_sv_1 = (J["\{1,2\}"] - J["\{2\}"] + J["\{1\}"] - J["empty_set"]) / 2
        beta_sv_2 = (J["\{1,2\}"] - J["\{1\}"] + J["\{2\}"] - J["empty_set"]) / 2

        return beta_sv_1, beta_sv_2

    # Average Participation
    # True
    def AP_tr(self, J, ba_sv_tr_1, ba_sv_tr_2):

        if ba_sv_tr_2 == 0:
            beta_ap_1 = (J["\{1,2\}"] - J["empty_set"]) / 3 + (J["\{1\}"] - J["empty_set"]) / 3
        else:
            beta_ap_1 = (J["\{1,2\}"] - J["empty_set"]) / 6 + (J["\{1\}"] - J["empty_set"]) / 3
        if ba_sv_tr_1 == 0:
            beta_ap_2 = (J["\{1,2\}"] - J["empty_set"]) / 3 + (J["\{2\}"] - J["empty_set"]) / 3
        else:
            beta_ap_2 = (J["\{1,2\}"] - J["empty_set"]) / 6 + (J["\{2\}"] - J["empty_set"]) / 3

        if ba_sv_tr_1 == 0:
            beta_ap_1 = 0
        if ba_sv_tr_2 == 0:
            beta_ap_2 = 0

        return beta_ap_1, beta_ap_2

    # Robust
    def AP_bc(self, J, ba_sv_bc_1, ba_sv_bc_2):

        if ba_sv_bc_1 == 0:
            beta_ap_1 = 0
        else:
            beta_ap_1 = (J["\{1,2\}"] - J["empty_set"]) / 6 + (J["\{1\}"] - J["empty_set"]) / 3
        if ba_sv_bc_2 == 0:
            beta_ap_2 = 0
        else:
            beta_ap_2 = (J["\{1,2\}"] - J["empty_set"]) / 6 + (J["\{2\}"] - J["empty_set"]) / 3

        return beta_ap_1, beta_ap_2

    # Banzhaf Index (identical to SV for two agents)
    def BI(self, J):

        beta_bi_1 = (J["\{1,2\}"] - J["\{2\}"] + J["\{1\}"] - J["empty_set"]) / 2
        beta_bi_2 = (J["\{1,2\}"] - J["\{1\}"] + J["\{2\}"] - J["empty_set"]) / 2

        return beta_bi_1, beta_bi_2

    # Marginal Contribution
    def MC(self, J):

        beta_mc_1 = J["\{1\}"] - J["empty_set"]
        beta_mc_2 = J["\{2\}"] - J["empty_set"]

        return beta_mc_1, beta_mc_2

    # Max-Efficient Rationality (assign max blame to agent A2)
    def MR(self, C_1, C_2, C_12):

        beta_mr = np.zeros(2)
        beta_mr[1] = max(0, C_2)
        beta_mr[0] = max(0, min(C_12 - C_2, C_1))

        return beta_mr