#!/usr/bin/env python3
"""
Configuration for network circular plots - easy to modify parameters.
"""

# Plot dimensions
FIGURE_SIZE = (16, 16)
PLOT_LIMITS = (-1.3, 1.3)  # x and y limits
CIRCLE_RADIUS = 1.0

# Threshold for showing edges (percentage)
DEFAULT_THRESHOLD = 3.0

# Font settings
LABEL_FONT_SIZE = 38  # Reduced from 42
EMOJI_FONT_SIZE = 105

# Logo settings
DEFAULT_LOGO_SIZE = 0.12
LOGO_ALPHA = 0.8

# Model logo file mapping
MODEL_LOGO_FILES = {
    'gpt-4.1': 'openai.png',
    'gpt-4.1-mini': 'openai.png', 
    'gpt-5': 'openai.png',
    'claude-sonnet-4': 'claude.png',
    'deepseek-v3': 'deepseek.png',
    'qwen3-325b': 'qwen.png',
    'qwen3-235b': 'qwen.png',
    'glm-4.5': 'zhipu.png',
    'grok-4': 'x.png',
    'kimi-k2': 'kimi.png',
    'gemini-2.5-flash': 'gemini.png',
}

# Individual logo sizes (zoom values)
MODEL_LOGO_SIZES = {
    'gpt-4.1': 0.48,          # GPT models: large
    'gpt-4.1-mini': 0.48,     # GPT models: large
    'gpt-5': 0.48,            # GPT models: large
    'claude-sonnet-4': 0.24,  # Claude: medium
    'deepseek-v3': 0.12,      # DeepSeek: base size
    'qwen3-325b': 0.045,      # Qwen: small
    'qwen3-235b': 0.045,      # Qwen: small
    'glm-4.5': 0.48,          # GLM: large
    'grok-4': 0.06,           # Grok: small
    'kimi-k2': 0.24,          # Kimi: medium
    'gemini-2.5-flash': 0.24, # Gemini: medium
}

# Emoji fallbacks for models without logos
MODEL_EMOJI_FALLBACKS = {
    'gpt-4.1': '🧠',
    'gpt-4.1-mini': '⚡',
    'claude-sonnet-4': '🎭',
    'deepseek-v3': '🌊',
    'qwen3-325b': '🏮',
    'qwen3-235b': '🏮',
    'glm-4.5': '⭐',
    'grok-4': '🚀',
    'kimi-k2': '🤖',
    'gemini-2.5-flash': '♊'
}

# Node positioning groups
MODELS_ABOVE = []  # Models with labels above
MODELS_RIGHT = ['gpt-4.1', 'gpt-5', 'gpt-4.1-mini']  # Labels to the right
MODELS_LEFT = ['claude-sonnet-4']  # Labels to the left
MODELS_BELOW_FAR = ['glm-4.5', 'qwen3-235b', 'deepseek-v3', 'kimi-k2']  # Labels far below
MODELS_RIGHT_DOWN = ['grok-4']  # Labels to the right and down

# Label positioning offsets
LABEL_OFFSET_STANDARD = 0.08
LABEL_OFFSET_FAR = 0.12
LABEL_OFFSET_RIGHT_EXTRA = 0.15  # Extra offset for GPT models to move them more to the right
LABEL_OFFSET_RIGHT_DOWN = 0.10   # Offset for grok (right and down)

# Edge appearance (FancyArrowPatch)
EDGE_COLOR = '#2E3440'  # Darker blue-gray (back to original dark color)
EDGE_ALPHA = 0.8  # Higher alpha for stronger appearance
EDGE_BASE_WIDTH = 0.8   # Much thinner minimum line width for dramatic contrast
EDGE_MAX_WIDTH_MULTIPLIER = 8.0  # Wider range for more differentiation
ARROW_MUTATION_SCALE = 30  # Bigger arrow head size
CURVE_RADIUS = 0.15  # Curvature radius for avoiding overlaps

# Circle background for emojis
EMOJI_CIRCLE_RADIUS = 0.05
EMOJI_CIRCLE_COLOR = 'white'
EMOJI_CIRCLE_ALPHA = 0.9

# Text label styling
LABEL_BBOX_STYLE = None  # Remove black boxes around text
LABEL_WEIGHT = 'normal'  # Remove bold formatting
LABEL_ALPHA = 0.9

# Model name mapping (full name -> short name)
NAME_MAPPING = {
    'openai/gpt-4.1': 'gpt-4.1',
    'openai/gpt-4.1-mini': 'gpt-4.1-mini',
    'openai/gpt-5': 'gpt-5',
    'anthropic/claude-sonnet-4': 'claude-sonnet-4',
    'deepseek/deepseek-chat-v3-0324': 'deepseek-v3',
    'google/gemini-2.5-flash': 'gemini-2.5-flash',
    'moonshotai/kimi-k2': 'kimi-k2',
    'z-ai/glm-4.5': 'glm-4.5',
    'x-ai/grok-4': 'grok-4',
    'qwen/qwen3-235b-a22b-2507': 'qwen3-235b'
}

# Node ordering (for circular layout)
# GPT models together, then others
GPT_MODELS = ['gpt-4.1', 'gpt-4.1-mini', 'gpt-5']

# Z-order settings (drawing order)
LOGO_Z_ORDER = 1
EDGE_Z_ORDER = 2
EMOJI_CIRCLE_Z_ORDER = 2
EMOJI_Z_ORDER = 3

# File paths
LOGOS_DIR = "results/logos"