#!/usr/bin/env python3
"""
Script to create a clean network graph without title, legend, or edge labels.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction file to analyze
    exact_model_file = "../results/predictions/predictions_exact_model.jsonl"
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    print("🕸️ Creating clean model prediction network graph...")
    print("   • No title, no legend, no edge labels")
    print("   • Pure visualization showing prediction patterns >3%")
    
    # Create clean network graph
    fig = visualizer.create_prediction_network_graph_clean(
        exact_model_file, 
        threshold=3.0,  # 3% threshold as requested
        save_path="../results/plots/prediction_network_clean.pdf"
    )
    
    if fig is not None:
        print("\n✅ Clean model prediction network graph created successfully!")
        print("   📄 Clean network graph: ../results/plots/prediction_network_clean.pdf")
        print("\n💡 Clean graph features:")
        print("   • Minimalist design with only essential elements")
        print("   • Nodes show model names")
        print("   • Arrow thickness indicates prediction strength")
        print("   • No visual clutter - perfect for presentations")
    else:
        print("\n❌ Failed to create clean network graph")

if __name__ == "__main__":
    main()