#!/usr/bin/env python3
"""
Script to create a confusion matrix for exact model predictions.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction file to analyze
    exact_model_file = "../results/predictions/predictions_exact_model.jsonl"
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    print("📊 Creating exact model confusion matrix...")
    
    # Create confusion matrix plot
    fig = visualizer.create_exact_model_confusion_matrix(
        exact_model_file, 
        save_path="../results/plots/exact_model_confusion_matrix.pdf"
    )
    
    if fig is not None:
        print("✅ Exact model confusion matrix created successfully!")
        print("   📄 Confusion matrix: ../results/plots/exact_model_confusion_matrix.pdf")
        print("\n💡 Matrix interpretation:")
        print("   • Rows = Evaluator models")
        print("   • Columns = Predicted models")
        print("   • Entry (i,j) = % of time evaluator i predicts model j")
        print("   • Diagonal values show self-prediction rates")
    else:
        print("❌ Failed to create confusion matrix - no data available")

if __name__ == "__main__":
    main()