#!/usr/bin/env python3
"""
Script to analyze empty predictions and create visualizations.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction files to analyze
    predictions_files = [
        "../results/predictions/predictions_binary_self.jsonl",
        "../results/predictions/predictions_exact_model.jsonl"
    ]
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    # Create empty text analysis plots (two separate plots)
    print("📊 Creating empty text analysis plots...")
    
    # Plot 1: Overall empty predictions by task type
    print("  Creating overall empty predictions plot...")
    fig1 = visualizer.create_empty_text_overall_plot(
        predictions_files, 
        save_path="../results/plots/empty_text_overall.pdf"
    )
    
    # Plot 2: Empty prediction rates by evaluator model
    print("  Creating empty predictions by model plot...")
    fig2 = visualizer.create_empty_text_by_model_plot(
        predictions_files, 
        save_path="../results/plots/empty_text_by_model.pdf"
    )
    
    if fig1 is not None and fig2 is not None:
        print("✅ Both empty text analysis plots created successfully!")
        print("   📄 Overall plot: ../results/plots/empty_text_overall.pdf")
        print("   📄 By model plot: ../results/plots/empty_text_by_model.pdf")
    elif fig1 is not None or fig2 is not None:
        print("⚠️ Only one plot was created successfully")
        if fig1 is not None:
            print("   ✅ Overall plot created: ../results/plots/empty_text_overall.pdf")
        if fig2 is not None:
            print("   ✅ By model plot created: ../results/plots/empty_text_by_model.pdf")
    else:
        print("❌ Failed to create plots - no data available")

if __name__ == "__main__":
    main()