#!/usr/bin/env python3
"""
Script to create a network graph showing model prediction patterns.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction file to analyze
    exact_model_file = "../results/predictions/predictions_exact_model.jsonl"
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    print("🕸️ Creating model prediction network graph...")
    print("   Threshold: Models predict each other >3% of the time")
    
    # Create network graph
    fig = visualizer.create_prediction_network_graph(
        exact_model_file, 
        threshold=3.0,  # 3% threshold as requested
        save_path="../results/plots/prediction_network.pdf"
    )
    
    if fig is not None:
        print("\n✅ Model prediction network graph created successfully!")
        print("   📄 Network graph: ../results/plots/prediction_network.pdf")
        print("\n💡 Graph interpretation:")
        print("   • Nodes (circles) = AI models")
        print("   • Directed edges (arrows) = A→B means A predicts B >3% of time")
        print("   • Edge thickness = Prediction frequency (thicker = more frequent)")
        print("   • Edge labels = Exact prediction percentages")
        print("   • Self-loops = Models predicting themselves")
    else:
        print("\n❌ Failed to create network graph")
        print("   This might happen if no prediction patterns exceed 3% threshold")

if __name__ == "__main__":
    main()