#!/usr/bin/env python3

import sys
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    viz = ResultsVisualizer()
    
    print("📊 Creating prediction bias analysis...")
    
    # Create prediction bias plot (how often models predict themselves)
    viz.create_exact_model_prediction_bias_plot(
        predictions_file='../results/predictions/predictions_exact_model.jsonl',
        save_path='../results/plots/exact_model_prediction_bias.pdf'
    )
    
    # Regenerate self-prediction plot with corrected label
    viz.create_exact_model_self_prediction_plot(
        predictions_file='../results/predictions/predictions_exact_model.jsonl',
        save_path='../results/plots/exact_model_self_prediction.pdf'
    )
    
    print("✅ Prediction bias analysis completed!")

if __name__ == "__main__":
    main()