#!/usr/bin/env python3
"""
Script to create network graph with real model logos downloaded from the internet.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction file to analyze
    exact_model_file = "../results/predictions/predictions_exact_model.jsonl"
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    # Check available logos
    logos_dir = Path("../results/logos")
    available_logos = list(logos_dir.glob("*"))
    print(f"📁 Available logos ({len(available_logos)}):")
    for logo in sorted(available_logos):
        print(f"   • {logo.name}")
    
    print(f"\n🌐 Creating network graph with real model logos...")
    print("   • Real logos will be used where available")
    print("   • Emoji fallbacks for missing logos")
    print("   • Larger graph size to accommodate logo details")
    
    # Create real logo network graph
    fig = visualizer.create_prediction_network_graph_with_logos(
        exact_model_file, 
        threshold=3.0,
        save_path="../results/plots/prediction_network_real_logos.pdf"
    )
    
    if fig is not None:
        print("\n✅ Real logo network graph created successfully!")
        print("   📄 Network with real logos: ../results/plots/prediction_network_real_logos.pdf")
        print("\n💡 Graph features:")
        print("   • Downloaded company logos for authentic branding")
        print("   • Larger figure size (16x16) for logo clarity") 
        print("   • Emoji fallbacks ensure all nodes are visible")
        print("   • White background labels for model names")
        print("   • Clean, professional appearance")
    else:
        print("\n❌ Failed to create real logo network graph")

if __name__ == "__main__":
    main()