#!/usr/bin/env python3
"""
Script to analyze self-prediction rates in exact model and binary self tasks.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction files to analyze
    exact_model_file = "../results/predictions/predictions_exact_model.jsonl"
    binary_self_file = "../results/predictions/predictions_binary_self.jsonl"
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    print("📊 Creating self-prediction analysis plots...")
    
    # Plot 1: Exact model self-prediction rates
    print("  Creating exact model self-prediction plot...")
    fig1 = visualizer.create_exact_model_self_prediction_plot(
        exact_model_file, 
        save_path="../results/plots/exact_model_self_prediction.pdf"
    )
    
    # Plot 2: Binary model yes-prediction rates
    print("  Creating binary model yes-prediction plot...")
    fig2 = visualizer.create_binary_model_yes_prediction_plot(
        binary_self_file, 
        save_path="../results/plots/binary_model_yes_prediction.pdf"
    )
    
    # Report results
    if fig1 is not None and fig2 is not None:
        print("✅ Both self-prediction analysis plots created successfully!")
        print("   📄 Exact model self-prediction: ../results/plots/exact_model_self_prediction.pdf")
        print("   📄 Binary model yes-prediction: ../results/plots/binary_model_yes_prediction.pdf")
    elif fig1 is not None or fig2 is not None:
        print("⚠️ Only one plot was created successfully")
        if fig1 is not None:
            print("   ✅ Exact model plot created: ../results/plots/exact_model_self_prediction.pdf")
        if fig2 is not None:
            print("   ✅ Binary model plot created: ../results/plots/binary_model_yes_prediction.pdf")
    else:
        print("❌ Failed to create plots - no data available")

if __name__ == "__main__":
    main()