#!/usr/bin/env python3
"""
Script to create updated network graphs with improved model names and logo version.
"""
import sys
from pathlib import Path
sys.path.append('../src')

from visualizer import ResultsVisualizer

def main():
    # Initialize visualizer
    visualizer = ResultsVisualizer()
    
    # Define prediction file to analyze
    exact_model_file = "../results/predictions/predictions_exact_model.jsonl"
    
    # Create plots directory
    plots_dir = Path("../results/plots")
    plots_dir.mkdir(parents=True, exist_ok=True)
    
    print("🕸️ Creating updated model prediction network graphs...")
    print("   • Fixed model names: deepseek-chat-v3-0324 → deepseek-v3")
    print("   • Fixed model names: qwen3-7b-chat-v325b → qwen3-325b")
    print("   • Generating both clean and logo versions")
    
    # Create updated clean network graph
    print("\n1. Creating clean network graph with improved names...")
    fig1 = visualizer.create_prediction_network_graph_clean(
        exact_model_file, 
        threshold=3.0,
        save_path="../results/plots/prediction_network_clean_v2.pdf"
    )
    
    # Create logo network graph
    print("\n2. Creating network graph with emoji logos...")
    fig2 = visualizer.create_prediction_network_graph_with_logos(
        exact_model_file, 
        threshold=3.0,
        save_path="../results/plots/prediction_network_logos.pdf"
    )
    
    # Report results
    if fig1 is not None and fig2 is not None:
        print("\n✅ Both updated network graphs created successfully!")
        print("\n📄 Generated files:")
        print("   🧹 Clean version (v2): ../results/plots/prediction_network_clean_v2.pdf")
        print("   🎨 Logo version: ../results/plots/prediction_network_logos.pdf")
        print("\n💡 Improvements:")
        print("   • Shortened model names for better readability")
        print("   • Logo version uses distinctive emojis for each model")
        print("   • Both versions have clean, publication-ready formatting")
    elif fig1 is not None or fig2 is not None:
        print("\n⚠️ One network graph created successfully")
        if fig1 is not None:
            print("   ✅ Clean version (v2) created")
        if fig2 is not None:
            print("   ✅ Logo version created")
    else:
        print("\n❌ Failed to create network graphs")

if __name__ == "__main__":
    main()