# import gym_recording_modified
import gym

# class MountainCarWrapper(gym.Wrapper):

#     def __init__(self, env):
#         super(MountainCarWrapper, self).__init__(env)

#     def step(self, action):
#         # self.env.step(action)
#         observation, reward, done, info = self.env.step(action)
#         if done:
#             reward += 2
#         else:
#             reward += 1
#         return observation, reward, done, info


class SparseMountainCarWrapper(gym.Wrapper):
    def __init__(self, env, steps_limit):
        self.step_count = 0
        self.steps_limit = steps_limit
        super(SparseMountainCarWrapper, self).__init__(env)
    def step(self, action):
        # self.env.step(action)
        self.step_count += 1
        observation, reward, done, info = self.env.step(action)
        if done:
            if self.steps_limit <= self.step_count:
                reward += 1
            else:
                reward += 2
            self.step_count = 0
        else:
            reward += 1
        return observation, reward, done, info


# class MountainCarRecordingWrapper(gym_recording_modified.wrappers.TraceRecordingWrapper):
#     """

#     A Wrapper that records Mountain Car rewards with +1

#     """
#     def __init__(self, env, directory=None, batch_size=None, only_reward=False, preprocess_obs=None, max_iter=200):
#         super(MountainCarRecordingWrapper, self).__init__(env, directory, batch_size, only_reward, preprocess_obs)
#         self.env._max_episode_steps = max_iter

#     def step(self, action):
#         observation, reward, done, info = self.env.step(action)
#         if done:
#             new_reward = reward+2
#             self.recording.add_step(action, self.preprocess_obs(observation), new_reward)
#         else:
#             new_reward = reward+1
#             self.recording.add_step(action, self.preprocess_obs(observation), new_reward)
#         # return observation, new_reward, done, info
#         return observation, new_reward, done, info


