import numpy as np

from sklearn.decomposition import IncrementalPCA
from typing import List, Any


def n_highest_return_configs(sum_df, columns, n, exploration_technique):
    """
    For a given exploration technique, return the n configurations that resulted in the 
    highest rewards
        sum_df : pandas dataframe
            dataframe with column "Total Return"
        columns : list
            non numerical columns of the dataframe
        n : int
            number of configurations to return
        exp_technique : str
            exploration technique
    """
    new_df = sum_df.groupby(columns).sum().reset_index()

    sum_df = new_df[new_df["Exploration Technique"]==exploration_technique].nlargest(n,"Total Return")
    
    sum_df = sum_df.set_index(columns)

    return sum_df.index.tolist()

def preprocess_init(data: List[Any]) -> List[Any]:
    """preprocess_init.

    :param data:
    :type data: List[Any]
    :rtype: List[Any]
    """
    return data[:-1]
    
def preprocess_deep_sea(data: List[List[Any]]) -> List[List[Any]]:
    """preprocess_deep_sea.

    :param data:
    :type data: List[List[Any]]
    :rtype: List[List[Any]]
    """
    for i, obs in enumerate(data):
        for j, arr in enumerate(obs):
            if not (isinstance(arr, int) or isinstance(arr, np.int64)):
                data[i][j] = arr.flatten().argmax()
    return data

def to_deep_sea_cooridinates(data: List[int], depth: int = 20) -> List[List[int]]:
    data = np.unravel_index(data, (depth,depth))
    return np.vstack([data[0], data[1]]).T

def merge_episodes_data(data: List[Any]) -> List[Any]:
    """merge_episodes_data.

    :param data:
    :type data: List[Any]
    :rtype: List[Any]
    """
    new_data = []
    for episode in data:
        new_data += episode
    return np.array(new_data)

def to_2D_space(data: List[List[int]]) -> List[List[int]]:
    """to_2D_space.

    :param data:
    :type data: List[List[int]]
    :rtype: List[List[int]]
    """
    ipca = IncrementalPCA(n_components=2, batch_size=100)
    ipca.fit(data)
    IncrementalPCA(batch_size=100, n_components=2)
    return ipca.transform(data)    
