import numpy as np
import matplotlib.pyplot as plt
import sys
sys.path.append('./')

import matplotlib
import matplotlib.pyplot as plt
import seaborn as sns


def set_plot(fontsize):
    #plt.rc('font', **{'family': 'serif', 'serif': ['Computer Modern']})
    #plt.rc('text', usetex=True)
    plt.axes().title.set_fontsize(fontsize)
    plt.axes().xaxis.label.set_fontsize(fontsize)
    plt.axes().yaxis.label.set_fontsize(fontsize)
    plt.rc('legend', fontsize=fontsize)
    plt.rc('xtick', labelsize=fontsize)
    plt.rc('ytick', labelsize=fontsize)
    plt.tight_layout()
    plt.switch_backend('agg')
    sns.set_palette('colorblind')
    plt.rcParams["font.size"] = fontsize 
set_plot(15)


dir_names  = ['experiments/DANN_homo/dann_cifar10_adv_mode0_sub10000.npy', 
             'experiments/DANN_homo/dann_cifar10_adv_mode0_sub1000.npy', 
             'experiments/DANN_homo/dann_cifar10_adv_mode0_sub100.npy']

label = ['10000', '1000', '100']
plt.figure()
plt.title('Effect of Target Size of DANN for CIFAR10 ' +r'$\rightarrow$' +' CIFAR10-adv' )
for idx, dir_name in enumerate(dir_names):
    acc = np.load(
        dir_name)[:100]
    print(acc)
    plt.plot(range(1,101), acc,label = label[idx] )
    plt.legend(loc = 'best')
    plt.xlabel('Epoch')
    plt.ylabel('Acc')
plt.savefig('./plot/figures/cifar10_tsize_plot.pdf', bbox_inches='tight')
