# Geometric GNNs Dojo

## Conda environment
Create a conda environment for the project via
```bash
conda create -n pyg python=3.8

# Install PyTorch (Check CUDA!)
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch

# Install PyG
conda install pyg -c pyg -c conda-forge

# Install other dependencies
conda install matplotlib pandas networkx
pip3 install ipdb e3nn ase
conda install jupyterlab -c conda-forge
```

## Directory Structure and Usage

```
.
├── README.md
├── notebooks                           # Synthetic experiments
│       ├── __init__.py                 
│       ├── incompleteness.ipynb        # Experiment on counterexamples from Pozdnyakov et al.
│       ├── kchains.ipynb               # Experiment on k-chains
│       ├── rotsym.ipynb                # Experiment on rotationally symmetric structures
│       ├── data_utils.py               # Dataset creation utilities
│       ├── plot_utils.py               # Visualisation utilities
│       └── train_utils.py              # Training and evaluation utilities
| 
└── src                                 # Geometric GNN models library
    ├── __init__.py                     
    ├── models.py                       # Models built using layers
    ├── gvp_layers.py                   # Layers for GVP-GNN
    ├── layers.py                       # Layers for TFN, E-GNN, MPNN
    └── modules                         # Layers for MACE
```

The following geometric GNN layers and models are available:
- Invariant GNNs: SchNet, DimeNet
- Equivariant GNNs using cartersian vectors: E-GNN, GVP-GNN
- Equivariant GNNs using spherical tensors: TFN, MACE
