import numpy as np
import math


class two_player_game():
	def __init__(self):
		self.reward_func = self.get_reward_func()
		self.transition_prob = self.get_next_s_prob()
		

	def get_reward_func(self):
		r1 = np.array([[[[[0]*2]*2]*2]*2]*2)
		r2 = np.array([[[[[0]*2]*2]*2]*2]*2)
		for state in range(2):
		    for agent1 in range(2):
		        for agent2 in range(2):
		            for adv1 in range(2):
		                for adv2 in range(2):
		                    if state == 0 and agent1 == agent2:
		                        r1[state][agent1][agent2][adv1][adv2] = 1
		                        r2[state][agent1][agent2][adv1][adv2] = 1
		                    if state == 1 and agent1 != agent2:
		                        r1[state][agent1][agent2][adv1][adv2] = 1
		                        r2[state][agent1][agent2][adv1][adv2] = 1
		return r1
	
	def get_next_s_prob(self):
		next_s = np.array([[[[[[0]*2]*2]*2]*2]*2]*2)
		for state in range(2):
		    for agent1 in range(2):
		        for agent2 in range(2):
		            for adv1 in range(2):
		                for adv2 in range(2):
		                    for next_state in range(2):
		                        if state==0 and agent1==agent2:
		                            next_s[state][agent1][agent2][adv1][adv2][1] = 1
		                            next_s[state][agent1][agent2][adv1][adv2][0] = 0
		                        if state==1 and agent1!=agent2:
		                            next_s[state][agent1][agent2][adv1][adv2][0] = 1
		                            next_s[state][agent1][agent2][adv1][adv2][1] = 0
		return next_s

if __name__ == "__main__":
	game_model = two_player_game()
	print(game_model.reward_func)
	print(game_model.transition_prob)