import os
import glob
import json
import numpy as np
import pdb

path = './'
json_path = './COIN.json'

with open(json_path, 'r') as load_f:
    load_dict = json.load(load_f)

database = load_dict["database"]
train_txt = []
test_txt = []
for video in database.keys():
    cls = str(database[video]["recipe_type"])
    feature = np.load(os.path.join(path, 'features', cls, video + '.npy'))
    label = np.zeros(feature.shape[0])
    annotation = database[video]["annotation"]
    for anttn in annotation:
        seg_id = anttn["id"]
        seg = anttn["segment"]
        label[int(seg[0]*10):int(seg[1]*10)] = float(seg_id)

    if database[video]["subset"] == "training":
        train_txt.append(os.path.join(cls, video))
    else:
        test_txt.append(os.path.join(cls, video))

    os.makedirs(os.path.join(path, 'labels', cls), exist_ok=True)
    np.save(os.path.join(path, 'labels', cls, video + '.npy'), label)
    print(feature.shape, label.shape)

with open(os.path.join(path, 'train.txt'), 'w') as f:
    for line in train_txt:
        f.write(line + "\n")

with open(os.path.join(path, 'test.txt'), 'w') as f:
    for line in test_txt:
        f.write(line + "\n")
