# Mitigating the Limitations of Multimodal VAEs with Coordination-Based Approach


## Requirements
- pytorch
- pixyz >= 0.3.3
- tqdm
- wandb

- multimodal_datasets (not shared)
- trained_classifiers (not shared)

## Experiments

- SVHNMNIST
```bash
python run_models.py --model CRMVAE --data SVHNMNIST --modality_id 0,1,2 --z_dim 32 --epochs=101 --beta 1.0
```

- PolyMNIST
```bash
python run_models.py --model CRMVAE  --data PolyMNIST --modality_id 0,1,2,3,4 --z_dim 512 --epoch 501 --beta 1.0
```

- Translated-PolyMNIST
```bash
python run_models.py --model CRMVAE  --data TranslatedPolyMNIST --modality_id 0,1,2,3,4 --z_dim 512 --epoch 501 --beta 0.1
```

- Bimodal CelebA    
```bash
python run_models.py --model CRMVAE --data CelebAText --modality_id 0,1 --z_dim=64 --epochs=201 --beta 1.0
```

- CUB
```bash
python run_models.py --model CRMVAE --data CUB --modality_id 0,1 --z_dim=64 --epochs=151 --beta 1.0
```

