import openai
import json
import os


with open("/home/ubuntu/zhanglichao/code/pengyao/chatgpt/openai.json", "r") as f:
    g_openai_config: dict = json.load(f)


class ChatGPT:
    def __init__(self, config: dict):
        self.api_key = None
        if "OPENAI_API_KEY" in os.environ:
            self.api_key: str = os.environ["OPENAI_API_KEY"]
        else:
            self.api_key: str = config["access_token"]
        openai.api_key = self.api_key
        self.model: str = config["model"]
        self.temperature = float(config["temperature"])
        self.top_p = float(config["top_p"])
        self.max_tokens = int(config["max_tokens"])
        self.messages: list = []

    def __call__(self, message):
        self.messages.append({"role": "user", "content": message})
        result: str = self.__execute()
        self.messages.append({"role": "assistant", "content": result})
        return result

    def __execute(self) -> str:
        try:
            completion = openai.ChatCompletion.create(
                model=self.model,
                messages=self.messages,
                temperature=self.temperature,
                max_tokens=self.max_tokens,
                frequency_penalty=0.0,
                presence_penalty=0.0,
                stream=True  # use SSE (Server-Sent Events)
            )
        except Exception as e:
            print(e)
            assert False, colors.RED + f"ERROR: {e}" + colors.ENDC
        result = []
        for chunk in completion:
            chunk: dict = json.loads(str(chunk["choices"][0]["delta"]))
            if "content" in chunk.keys():
                chunk = str(chunk["content"])
                result.append(chunk)
        return ''.join(result)

if __name__ == '__main__':
    
    chatbot = ChatGPT(g_openai_config)
    
    with open('Overcooked prompt ZLC.txt', 'r') as f:
        text= f.readlines()
    prompt = ''
    for t in text:
        prompt += t
    
    res = chatbot(prompt)
    
    # question = "Task: Make and serve a tomato soup. Description of Agent1: Intend to serve tomato soup."
    question = "If the instructions of the current human chef are: Please cooperate with me in cooking tomato soup. You are responsible for taking out the tomato soup from the pot and serving it to the delivery port. Please plan the work that you will be responsible for performing."
    res = chatbot(question)
    print('************************')
    print('Question: '+ question)
    print('Answer: '+ res)

    question = "I would like to rearrange the order of pot 3, pot 2, and pot 1, please."
    res = chatbot(question)
    print('************************')
    print('Question: '+ question)
    print('Answer: '+ res)