# HAPLAN
This is the code for our paper : `EFFICIENT HUMAN-AI COORDINATION VIA PREPARATORY LANGUAGE-BASED CONVENTION`.

# Algorithm projects
Please install PyTorch and its packages by using the following command:
```
conda create -n HAPLAN python=3.8
conda activate HAPLAN
pip install torch==1.8.0+cu111 torchvision==0.9.0+cu111 torchaudio==0.8.0 -f https://download.pytorch.org/whl/torch_stable.html
cd Env
pip install -e . 
pip install wandb icecream setproctitle gym seaborn tensorboardX slackweb psutil slackweb pyastar2d einops absl-py scipy pygame IPython ipywidgets scikit-learn flask tensorflow tensorboard_logger
```

# Overcooked
Our experiments are conducted in two layouts from [On the Utility of Learning about Humans for Human-AI Coordination](https://github.com/HumanCompatibleAI/human_aware_rl/tree/neurips2019), named *Asymmetric Advantages* and *Counter Circuit*,  and three layouts from [Learning Zero-Shot Cooperation with Humans,Assuming Humans Are Biased](https://github.com/samjia2000/HSP), named *Distant Tomato*, *Soup Coordination*, and *Many Orders*. These layouts are named "unident_s", "random3", "soup_coordination", "distant_tomato" and "many_orders" respectively in the code.  
Please follow the instructions below to install the library for your environment:
```
cd .../hsp/envs/overcooked
python setup.py develop  
```
```
cd .../hsp/envs/overcooked_new
pip install overcooked-ai
```
# Low-Level skill Learning

The codes for ``data collection`` and ``skill (imitation) learning`` are respectively in ``Data_Collection_Code`` and ``Skill_BC_Code``. 

# Human-AI Coordination Interface
Real human players cooperate with the baseline algorithm to execute:
```
python app_Baseline.py many_orders [baseline_model_path]
```

Real human players cooperate with the HAPLAN algorithm to execute:
```
python app_HAPLAN_Random3.py
python app_HAPLAN_Unident_S.py
python app_HAPLAN_SoupCoordination.py
python app_HAPLAN_Distant_Tomato.py
python app_HAPLAN_ManyOrders.py
```

## Note
The completion of this baseline algorithm is based on [HSP](https://github.com/samjia2000/HSP) which are open-sourced.

