# Training

## Environment creation

```
conda create -n dif_env python=3.11
conda activate dif_env
pip install -r requirements.txt

```

## Autoencoder training

For training the autoencoder, you need to specify the dataset and the number of latent dimensions.

See the example of the command below:

```
torchrun --nproc_per_node=1 train_encoder.py \
training=autoencoder \
dataset=wikipedia \
encoder.latent.num_latents=16 \
decoder.latent.num_latents=16
```

## Unconditional diffusion training

For training the diffusion model, you need to specify the autoencoder checkpoint path, the dataset, the number of latent dimensions, the noising schedule rate d.

See the example of the command below:

```
torchrun --nproc_per_node=1 train_diffusion.py \
training=diffusion \
autoencoder.model.load_checkpoint=autoencoder_checkpoint_path \
dataset=rocstories \
diffusion.dynamic.d=d \
diffusion/optimizer=adamw \
diffusion.diffusion.is_conditional=False \
project.name=project_name \
encoder.latent.num_latents=16 \
decoder.latent.num_latents=16 \
decoder.embedding.max_position_embeddings=128 \
encoder.embedding.max_position_embeddings=128
```                                                                 

## Conditional diffusion training

For training the conditional diffusion model, you need to specify the autoencoder checkpoint path and diffusion model checkpoint path, the dataset, the number of latent dimensions, noising schedule rate d.

See the example of the command below:

```
torchrun --nproc_per_node=1 train_diffusion.py \
training=diffusion \
autoencoder.model.load_checkpoint=autoencoder_checkpoint_path \
dataset=paradetox \
diffusion.dynamic.d=d \
diffusion/optimizer=adamw \
diffusion.diffusion.is_conditional=True \
project.name=project_name \
encoder.latent.num_latents=16 \                                                    
decoder.latent.num_latents=16 \
decoder.embedding.max_position_embeddings=128 \                                              
encoder.embedding.max_position_embeddings=128 \
diffusion.finetuning.is_finetuning=true \                                                                                                             
diffusion.finetuning.finetuning_checkpoint=pretrained_unconditional_path
```