
Installation
------------

pip install -r requirements.txt

Additional requirements for fairseq models:
fairseq==0.10.1
sacremoses==0.0.43
fastBPE==0.1.0

Additional requirements for data analysis:
scipy==1.6.0

Additional requirements for original WinoMT evaluation:
spacy==2.2.3
pymorphy2==0.9.1
python -m spacy download de
python -m spacy download fr
https://github.com/clab/fast_align


Example Usage
-------------

from pathlib import Path

import torch

from tasks.newstest import NewstestTask
from tasks.mucow_wmt19_source import MucowWMT19ContrastiveConditioningTask
from tasks.winomt_source import WinomtContrastiveConditioningTask
from translation_models.fairseq_models import FairseqTranslationModel, FairseqScoringModel

hub_interface = torch.hub.load(
    repo_or_dir='pytorch/fairseq',
    model=f'transformer.wmt19.en-de',
    checkpoint_file=f"model1.pt",
    tokenizer='moses',
    bpe='fastbpe',
)
evaluated_model = FairseqTranslationModel(
    name=f"transformer.wmt19.en-de.model1",
    model=hub_interface,
)
evaluator_model = FairseqScoringModel(
    name=f"transformer.wmt19.en-de.model1",
    model=hub_interface,
)

NewstestTask(target_language="de").evaluate(evaluated_model)

mucow_result = MucowWMT19ContrastiveConditioningTask(
    tgt_language="de",
    evaluator_model=evaluator_model,
    source_data_path=Path("data") / "mucow_wmt19" / "en-de.insertions.roberta-large.source_data.top10.jsonl",
).evaluate(evaluated_model)
print(mucow_result)

winomt_result = WinomtContrastiveConditioningTask(evaluator_model=evaluator_model).evaluate(evaluated_model)
print(winomt_result)
