import logging
from pathlib import Path
from typing import Optional

from translation_models import TranslationModel


class TaskResult:
    ...


class Task:

    def evaluate(self, translation_model: TranslationModel, **translation_kwargs) -> TaskResult:
        raise NotImplementedError

    @property
    def cache_dir(self):
        return Path(__file__).parent.parent / "data" / ".cached_translations"

    def _set_cache(self, filename: str, content: str) -> None:
        filepath = self.cache_dir / filename
        logging.info(f"Caching intermediary data at {filepath}")
        self.cache_dir.mkdir(exist_ok=True)
        with open(filepath, "w") as f:
            f.write(content)

    def _get_cache(self, filename: str) -> Optional[str]:
        filepath = self.cache_dir / filename
        if not filepath.exists():
            return None
        logging.info(f"Using cached data at {filepath}")
        with open(filepath) as f:
            return f.read()
