import subprocess
import tempfile
from pathlib import Path
from typing import List

from sacrebleu import get_source_file

from tasks import Task
from translation_models import TranslationModel


class NewstestTask(Task):

    def __init__(self,
                 target_language: str,
                 testsets: List[str] = None,
                 ):
        self.language_pair = f"en-{target_language}"
        self.testsets = testsets or ["wmt19", "wmt20"]

    def evaluate(self, translation_model: TranslationModel, **translation_kwargs):
        for testset in self.testsets:
            source_filepath = Path(get_source_file(testset, self.language_pair))
            with open(source_filepath) as f:
                source_sentences = [line.strip() for line in f]
            translations = translation_model.translate(source_sentences, **translation_kwargs)
            with tempfile.NamedTemporaryFile("w") as f:
                f.write("\n".join(translations))
                subprocess.call([
                    "sacrebleu",
                    "--test-set", testset,
                    "--language-pair", self.language_pair,
                    "--input", f.name,
                ])
