from tasks.winomt_classic_utils.language_predictors.gendered_article import GenderedArticlePredictor, get_german_determiners, \
    GERMAN_EXCEPTION
from tasks.winomt_classic_utils.language_predictors.hebrew import HebrewPredictor, ArabicPredictor
from tasks.winomt_classic_utils.language_predictors.pymorph_support import PymorphPredictor
from tasks.winomt_classic_utils.language_predictors.spacy_support import SpacyPredictor


class WinoMTLanguage:
    language_code = "xx"

    @classmethod
    def get_predictor(cls):
        raise NotImplementedError


class Arabic(WinoMTLanguage):
    language_code = "ar"

    @classmethod
    def get_predictor(cls):
        return ArabicPredictor()


class German(WinoMTLanguage):
    language_code = "de"

    @classmethod
    def get_predictor(cls):
        return GenderedArticlePredictor("de", get_german_determiners, GERMAN_EXCEPTION)


class Spanish(WinoMTLanguage):
    language_code = "es"

    @classmethod
    def get_predictor(cls):
        return SpacyPredictor("es")


class French(WinoMTLanguage):
    language_code = "fr"

    @classmethod
    def get_predictor(cls):
        return SpacyPredictor("fr")


class Hebrew(WinoMTLanguage):
    language_code = "he"

    @classmethod
    def get_predictor(cls):
        return HebrewPredictor()


class Italian(WinoMTLanguage):
    language_code = "it"

    @classmethod
    def get_predictor(cls):
        return SpacyPredictor("it")


class Ukrainian(WinoMTLanguage):
    language_code = "uk"

    @classmethod
    def get_predictor(cls):
        return PymorphPredictor("uk")


class Russian(WinoMTLanguage):
    language_code = "ru"

    @classmethod
    def get_predictor(cls):
        return PymorphPredictor("ru")
