Code accompanying the paper "The Union of Manifolds Hypothesis" submitted to ICLR 2023 by anonymous authors.

## Prerequisites
- Python 3.9
```bash
conda create -n uom python=3.9
conda activate uom
```
- PyTorch 1.10.1
```bash
conda install pytorch=1.10.1 torchvision=0.11.2 numpy=1.21.2 -c pytorch
```

- TensorboardX 2.8.0
```bash
pip install tensorboardX
```

- nflows 0.14
```bash
pip install nflows==0.14
```

- sk-learn 1.0
```bash
conda install scikit-learn=1.0
```

- pandas 1.3.5
```bash
conda install pandas=1.3.5
```

- h5py 3.6.0
```bash
conda install h5py=3.6.0
```

- pytorch_fid 0.2.1
```bash
pip install pytorch_fid==0.2.1
```

- matplotlib 3.5.0
```bash
conda install -c conda-forge matplotlib=3.5.0
```

- prdc 
```bash
pip install prdc
```

## Train a single DGM
- Example - NF on MNIST
```bash
./single_main.py --dataset mnist --model flow  --run-name runs/flow_svhn_run
```

- Available GAE models are vae, wae, nf and gan 
- Available image datasets are mnist, fashion-mnist, svhn, and cifar10
- Please see the ./config folder for hyperparamater configurations for all models

## Train a clustered DGM
- Example - C-NF (labels) on SVHN
```bash
./single_cluster_main.py --dataset svhn --model flow --run-name runs/flow_svhn_cluster_run/1
```

- Same models as the above are available

## Train a classifier on cifar-100
- Example
```bash
python classifier.py 
```

Please see ./classifier.py for arguments
