# Learn to Effectively Explore in Context-Based Meta-RL

This repository is the official implementation of [Learn to Effectively Explore in Context-Based Meta-RL]. 


## Requirements

To install requirements:

```setup
conda env create -n metacure -f  metacure.yaml
```

> This will create a new conda env called MetaCURE.

## Training

To train MetaCURE-Cur, run this command:

```train
python launch_experiment_metacure_cur.py ./configs/sparse-point-robot-metacure.json --gpu 0
```

To train MetaCURE-IG, run this command:

```train
python launch_experiment_metacure_ig.py ./configs/sparse-point-robot-metacure.json --gpu 0
```

To train PEARL as a baseline, run this command:

```train
python launch_experiment_pearl.py ./configs/sparse-point-robot-pearl.json --gpu 0
```

> You can also run additional experiments by specifying certain .json files in the 'configs' folder.

## Evaluation

Evaluation is automatically done after each step of training. 

Results are stored in the 'outputmetacure'and 'outputpearl'folders, respectively.

Visualization scripts for adaptation are avialable in the 'scripts'folder. You can also visualize learning curves with viskit: https://github.com/vitchyr/viskit.


## Results

Refer to the original paper and Appendix for results.