#ifndef CUFFTDX_FFT_1000_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_1000_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<739, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<17>;
.reg .f64 fd<669>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 16000, r2;
mov.u32 r4, %tid.x;
add.f64 fd41, %28, %44;
add.f64 fd42, %23, fd41;
add.f64 fd43, %33, %39;
add.f64 fd44, fd43, fd42;
add.f64 fd45, %30, %46;
add.f64 fd46, %24, fd45;
add.f64 fd47, %35, %40;
add.f64 fd48, fd47, fd46;
fma.rn.f64 fd49, fd41, 0d3FD3C6EF372FE950, %23;
mul.f64 fd50, fd43, 0d3FE9E3779B97F4A8;
sub.f64 fd51, fd49, fd50;
sub.f64 fd52, %30, %46;
mul.f64 fd53, fd52, 0d3FEE6F0E134454FF;
sub.f64 fd54, %35, %40;
fma.rn.f64 fd55, fd54, 0d3FE2CF2304755A5E, fd53;
sub.f64 fd56, fd51, fd55;
add.f64 fd57, fd55, fd51;
mul.f64 fd58, fd41, 0d3FE9E3779B97F4A8;
sub.f64 fd59, %23, fd58;
fma.rn.f64 fd60, fd43, 0d3FD3C6EF372FE950, fd59;
mul.f64 fd61, fd52, 0d3FE2CF2304755A5E;
mul.f64 fd62, fd54, 0d3FEE6F0E134454FF;
sub.f64 fd63, fd61, fd62;
sub.f64 fd64, fd60, fd63;
add.f64 fd65, fd63, fd60;
fma.rn.f64 fd66, fd45, 0d3FD3C6EF372FE950, %24;
mul.f64 fd67, fd47, 0d3FE9E3779B97F4A8;
sub.f64 fd68, fd66, fd67;
sub.f64 fd69, %28, %44;
mul.f64 fd70, fd69, 0d3FEE6F0E134454FF;
sub.f64 fd71, %33, %39;
fma.rn.f64 fd72, fd71, 0d3FE2CF2304755A5E, fd70;
add.f64 fd73, fd72, fd68;
sub.f64 fd74, fd68, fd72;
mul.f64 fd75, fd45, 0d3FE9E3779B97F4A8;
sub.f64 fd76, %24, fd75;
fma.rn.f64 fd77, fd47, 0d3FD3C6EF372FE950, fd76;
mul.f64 fd78, fd69, 0d3FE2CF2304755A5E;
mul.f64 fd79, fd71, 0d3FEE6F0E134454FF;
sub.f64 fd80, fd78, fd79;
add.f64 fd81, fd80, fd77;
sub.f64 fd82, fd77, fd80;
add.f64 fd83, %31, %47;
add.f64 fd84, %25, fd83;
add.f64 fd85, %36, %41;
add.f64 fd86, fd85, fd84;
add.f64 fd87, %32, %48;
add.f64 fd88, %27, fd87;
add.f64 fd89, %38, %43;
add.f64 fd90, fd89, fd88;
fma.rn.f64 fd91, fd83, 0d3FD3C6EF372FE950, %25;
mul.f64 fd92, fd85, 0d3FE9E3779B97F4A8;
sub.f64 fd93, fd91, fd92;
sub.f64 fd94, %32, %48;
mul.f64 fd95, fd94, 0d3FEE6F0E134454FF;
sub.f64 fd96, %38, %43;
fma.rn.f64 fd97, fd96, 0d3FE2CF2304755A5E, fd95;
sub.f64 fd98, fd93, fd97;
add.f64 fd99, fd97, fd93;
mul.f64 fd100, fd83, 0d3FE9E3779B97F4A8;
sub.f64 fd101, %25, fd100;
fma.rn.f64 fd102, fd85, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd103, fd94, 0d3FE2CF2304755A5E;
mul.f64 fd104, fd96, 0d3FEE6F0E134454FF;
sub.f64 fd105, fd103, fd104;
sub.f64 fd106, fd102, fd105;
add.f64 fd107, fd105, fd102;
fma.rn.f64 fd108, fd87, 0d3FD3C6EF372FE950, %27;
mul.f64 fd109, fd89, 0d3FE9E3779B97F4A8;
sub.f64 fd110, fd108, fd109;
sub.f64 fd111, %31, %47;
mul.f64 fd112, fd111, 0d3FEE6F0E134454FF;
sub.f64 fd113, %36, %41;
fma.rn.f64 fd114, fd113, 0d3FE2CF2304755A5E, fd112;
add.f64 fd115, fd114, fd110;
sub.f64 fd116, fd110, fd114;
mul.f64 fd117, fd87, 0d3FE9E3779B97F4A8;
sub.f64 fd118, %27, fd117;
fma.rn.f64 fd119, fd89, 0d3FD3C6EF372FE950, fd118;
mul.f64 fd120, fd111, 0d3FE2CF2304755A5E;
mul.f64 fd121, fd113, 0d3FEE6F0E134454FF;
sub.f64 fd122, fd120, fd121;
add.f64 fd123, fd122, fd119;
sub.f64 fd124, fd119, fd122;
mul.f64 fd125, fd98, 0d3FE9E3779B97F4A8;
mul.f64 fd126, fd115, 0d3FE2CF2304755A5E;
sub.f64 fd127, fd125, fd126;
mul.f64 fd128, fd115, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd129, fd98, 0d3FE2CF2304755A5E, fd128;
mul.f64 fd130, fd106, 0d3FD3C6EF372FE950;
mul.f64 fd131, fd123, 0d3FEE6F0E134454FF;
sub.f64 fd132, fd130, fd131;
mul.f64 fd133, fd123, 0d3FD3C6EF372FE950;
fma.rn.f64 fd134, fd106, 0d3FEE6F0E134454FF, fd133;
mul.f64 fd135, fd107, 0dBFD3C6EF372FE950;
mul.f64 fd136, fd124, 0d3FEE6F0E134454FF;
sub.f64 fd137, fd135, fd136;
mul.f64 fd138, fd124, 0dBFD3C6EF372FE950;
fma.rn.f64 fd139, fd107, 0d3FEE6F0E134454FF, fd138;
mul.f64 fd140, fd99, 0dBFE9E3779B97F4A8;
mul.f64 fd141, fd116, 0d3FE2CF2304755A5E;
sub.f64 fd142, fd140, fd141;
mul.f64 fd143, fd116, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd144, fd99, 0d3FE2CF2304755A5E, fd143;
sub.f64 fd145, fd44, fd86;
sub.f64 fd146, fd48, fd90;
add.f64 fd147, fd56, fd127;
add.f64 fd148, fd73, fd129;
sub.f64 fd149, fd56, fd127;
sub.f64 fd150, fd73, fd129;
add.f64 fd151, fd64, fd132;
add.f64 fd152, fd81, fd134;
sub.f64 fd153, fd64, fd132;
sub.f64 fd154, fd81, fd134;
add.f64 fd155, fd65, fd137;
add.f64 fd156, fd82, fd139;
sub.f64 fd157, fd65, fd137;
sub.f64 fd158, fd82, fd139;
add.f64 fd159, fd57, fd142;
add.f64 fd160, fd74, fd144;
sub.f64 fd161, fd57, fd142;
sub.f64 fd162, fd74, fd144;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 37;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 100;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 16000, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd163, fd164}, [rd6];
mul.f64 fd167, fd148, fd164;
mul.f64 fd168, fd147, fd164;
mul.f64 fd169, fd163, fd148;
mul.f64 fd170, fd163, fd163;
mul.f64 fd171, fd164, fd164;
sub.f64 fd172, fd170, fd171;
mul.f64 fd173, fd164, fd163;
fma.rn.f64 fd174, fd164, fd163, fd173;
mul.f64 fd175, fd152, fd174;
mul.f64 fd176, fd151, fd174;
mul.f64 fd177, fd172, fd152;
mul.f64 fd178, fd163, fd172;
mul.f64 fd179, fd164, fd174;
sub.f64 fd180, fd178, fd179;
mul.f64 fd181, fd163, fd174;
fma.rn.f64 fd182, fd164, fd172, fd181;
mul.f64 fd183, fd156, fd182;
mul.f64 fd184, fd155, fd182;
mul.f64 fd185, fd180, fd156;
mul.f64 fd186, fd163, fd180;
mul.f64 fd187, fd164, fd182;
sub.f64 fd188, fd186, fd187;
mul.f64 fd189, fd163, fd182;
fma.rn.f64 fd190, fd164, fd180, fd189;
mul.f64 fd191, fd160, fd190;
mul.f64 fd192, fd159, fd190;
mul.f64 fd193, fd188, fd160;
mul.f64 fd194, fd163, fd188;
mul.f64 fd195, fd164, fd190;
sub.f64 fd196, fd194, fd195;
mul.f64 fd197, fd163, fd190;
fma.rn.f64 fd198, fd164, fd188, fd197;
mul.f64 fd199, fd146, fd198;
mul.f64 fd200, fd145, fd198;
mul.f64 fd201, fd196, fd146;
ld.global.v2.f64 {fd202, fd203}, [rd6+1600];
mul.f64 fd206, fd150, fd203;
mul.f64 fd207, fd149, fd203;
mul.f64 fd208, fd202, fd150;
mul.f64 fd209, fd163, fd202;
mul.f64 fd210, fd164, fd203;
sub.f64 fd211, fd209, fd210;
mul.f64 fd212, fd163, fd203;
fma.rn.f64 fd213, fd164, fd202, fd212;
mul.f64 fd214, fd154, fd213;
mul.f64 fd215, fd153, fd213;
mul.f64 fd216, fd211, fd154;
mul.f64 fd217, fd163, fd211;
mul.f64 fd218, fd164, fd213;
sub.f64 fd219, fd217, fd218;
mul.f64 fd220, fd163, fd213;
fma.rn.f64 fd221, fd164, fd211, fd220;
mul.f64 fd222, fd158, fd221;
mul.f64 fd223, fd157, fd221;
mul.f64 fd224, fd219, fd158;
mul.f64 fd225, fd163, fd219;
mul.f64 fd226, fd164, fd221;
sub.f64 fd227, fd225, fd226;
mul.f64 fd228, fd163, fd221;
fma.rn.f64 fd229, fd164, fd219, fd228;
mul.f64 fd230, fd162, fd229;
mul.f64 fd231, fd161, fd229;
mul.f64 fd232, fd227, fd162;
barrier.sync 0;
mad.lo.s32 r9, r7, 160, r8;
add.f64 fd233, fd48, fd90;
add.f64 fd234, fd44, fd86;
st.shared.v2.f64 [r9], {fd234, fd233};
fma.rn.f64 fd235, fd163, fd147, fd167;
sub.f64 fd236, fd169, fd168;
st.shared.v2.f64 [r9+16], {fd235, fd236};
fma.rn.f64 fd237, fd172, fd151, fd175;
sub.f64 fd238, fd177, fd176;
st.shared.v2.f64 [r9+32], {fd237, fd238};
fma.rn.f64 fd239, fd180, fd155, fd183;
sub.f64 fd240, fd185, fd184;
st.shared.v2.f64 [r9+48], {fd239, fd240};
sub.f64 fd241, fd193, fd192;
fma.rn.f64 fd242, fd188, fd159, fd191;
st.shared.v2.f64 [r9+64], {fd242, fd241};
fma.rn.f64 fd243, fd196, fd145, fd199;
sub.f64 fd244, fd201, fd200;
st.shared.v2.f64 [r9+80], {fd243, fd244};
fma.rn.f64 fd245, fd202, fd149, fd206;
sub.f64 fd246, fd208, fd207;
st.shared.v2.f64 [r9+96], {fd245, fd246};
fma.rn.f64 fd247, fd211, fd153, fd214;
sub.f64 fd248, fd216, fd215;
st.shared.v2.f64 [r9+112], {fd247, fd248};
fma.rn.f64 fd249, fd219, fd157, fd222;
sub.f64 fd250, fd224, fd223;
st.shared.v2.f64 [r9+128], {fd249, fd250};
sub.f64 fd251, fd232, fd231;
fma.rn.f64 fd252, fd227, fd161, fd230;
st.shared.v2.f64 [r9+144], {fd252, fd251};
barrier.sync 0;
mad.lo.s32 r10, r7, -144, r9;
ld.shared.v2.f64 {fd253, fd254}, [r10];
ld.shared.v2.f64 {fd257, fd258}, [r10+1600];
ld.shared.v2.f64 {fd261, fd262}, [r10+3200];
ld.shared.v2.f64 {fd265, fd266}, [r10+4800];
ld.shared.v2.f64 {fd269, fd270}, [r10+6400];
ld.shared.v2.f64 {fd273, fd274}, [r10+8000];
ld.shared.v2.f64 {fd277, fd278}, [r10+9600];
ld.shared.v2.f64 {fd281, fd282}, [r10+11200];
ld.shared.v2.f64 {fd285, fd286}, [r10+12800];
ld.shared.v2.f64 {fd289, fd290}, [r10+14400];
add.f64 fd293, fd261, fd285;
add.f64 fd294, fd253, fd293;
add.f64 fd295, fd269, fd277;
add.f64 fd296, fd295, fd294;
add.f64 fd297, fd262, fd286;
add.f64 fd298, fd254, fd297;
add.f64 fd299, fd270, fd278;
add.f64 fd300, fd299, fd298;
fma.rn.f64 fd301, fd293, 0d3FD3C6EF372FE950, fd253;
mul.f64 fd302, fd295, 0d3FE9E3779B97F4A8;
sub.f64 fd303, fd301, fd302;
sub.f64 fd304, fd262, fd286;
mul.f64 fd305, fd304, 0d3FEE6F0E134454FF;
sub.f64 fd306, fd270, fd278;
fma.rn.f64 fd307, fd306, 0d3FE2CF2304755A5E, fd305;
sub.f64 fd308, fd303, fd307;
add.f64 fd309, fd307, fd303;
mul.f64 fd310, fd293, 0d3FE9E3779B97F4A8;
sub.f64 fd311, fd253, fd310;
fma.rn.f64 fd312, fd295, 0d3FD3C6EF372FE950, fd311;
mul.f64 fd313, fd304, 0d3FE2CF2304755A5E;
mul.f64 fd314, fd306, 0d3FEE6F0E134454FF;
sub.f64 fd315, fd313, fd314;
sub.f64 fd316, fd312, fd315;
add.f64 fd317, fd315, fd312;
fma.rn.f64 fd318, fd297, 0d3FD3C6EF372FE950, fd254;
mul.f64 fd319, fd299, 0d3FE9E3779B97F4A8;
sub.f64 fd320, fd318, fd319;
sub.f64 fd321, fd261, fd285;
mul.f64 fd322, fd321, 0d3FEE6F0E134454FF;
sub.f64 fd323, fd269, fd277;
fma.rn.f64 fd324, fd323, 0d3FE2CF2304755A5E, fd322;
add.f64 fd325, fd324, fd320;
sub.f64 fd326, fd320, fd324;
mul.f64 fd327, fd297, 0d3FE9E3779B97F4A8;
sub.f64 fd328, fd254, fd327;
fma.rn.f64 fd329, fd299, 0d3FD3C6EF372FE950, fd328;
mul.f64 fd330, fd321, 0d3FE2CF2304755A5E;
mul.f64 fd331, fd323, 0d3FEE6F0E134454FF;
sub.f64 fd332, fd330, fd331;
add.f64 fd333, fd332, fd329;
sub.f64 fd334, fd329, fd332;
add.f64 fd335, fd265, fd289;
add.f64 fd336, fd257, fd335;
add.f64 fd337, fd273, fd281;
add.f64 fd338, fd337, fd336;
add.f64 fd339, fd266, fd290;
add.f64 fd340, fd258, fd339;
add.f64 fd341, fd274, fd282;
add.f64 fd342, fd341, fd340;
fma.rn.f64 fd343, fd335, 0d3FD3C6EF372FE950, fd257;
mul.f64 fd344, fd337, 0d3FE9E3779B97F4A8;
sub.f64 fd345, fd343, fd344;
sub.f64 fd346, fd266, fd290;
mul.f64 fd347, fd346, 0d3FEE6F0E134454FF;
sub.f64 fd348, fd274, fd282;
fma.rn.f64 fd349, fd348, 0d3FE2CF2304755A5E, fd347;
sub.f64 fd350, fd345, fd349;
add.f64 fd351, fd349, fd345;
mul.f64 fd352, fd335, 0d3FE9E3779B97F4A8;
sub.f64 fd353, fd257, fd352;
fma.rn.f64 fd354, fd337, 0d3FD3C6EF372FE950, fd353;
mul.f64 fd355, fd346, 0d3FE2CF2304755A5E;
mul.f64 fd356, fd348, 0d3FEE6F0E134454FF;
sub.f64 fd357, fd355, fd356;
sub.f64 fd358, fd354, fd357;
add.f64 fd359, fd357, fd354;
fma.rn.f64 fd360, fd339, 0d3FD3C6EF372FE950, fd258;
mul.f64 fd361, fd341, 0d3FE9E3779B97F4A8;
sub.f64 fd362, fd360, fd361;
sub.f64 fd363, fd265, fd289;
mul.f64 fd364, fd363, 0d3FEE6F0E134454FF;
sub.f64 fd365, fd273, fd281;
fma.rn.f64 fd366, fd365, 0d3FE2CF2304755A5E, fd364;
add.f64 fd367, fd366, fd362;
sub.f64 fd368, fd362, fd366;
mul.f64 fd369, fd339, 0d3FE9E3779B97F4A8;
sub.f64 fd370, fd258, fd369;
fma.rn.f64 fd371, fd341, 0d3FD3C6EF372FE950, fd370;
mul.f64 fd372, fd363, 0d3FE2CF2304755A5E;
mul.f64 fd373, fd365, 0d3FEE6F0E134454FF;
sub.f64 fd374, fd372, fd373;
add.f64 fd375, fd374, fd371;
sub.f64 fd376, fd371, fd374;
mul.f64 fd377, fd350, 0d3FE9E3779B97F4A8;
mul.f64 fd378, fd367, 0d3FE2CF2304755A5E;
sub.f64 fd379, fd377, fd378;
mul.f64 fd380, fd367, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd381, fd350, 0d3FE2CF2304755A5E, fd380;
mul.f64 fd382, fd358, 0d3FD3C6EF372FE950;
mul.f64 fd383, fd375, 0d3FEE6F0E134454FF;
sub.f64 fd384, fd382, fd383;
mul.f64 fd385, fd375, 0d3FD3C6EF372FE950;
fma.rn.f64 fd386, fd358, 0d3FEE6F0E134454FF, fd385;
mul.f64 fd387, fd359, 0dBFD3C6EF372FE950;
mul.f64 fd388, fd376, 0d3FEE6F0E134454FF;
sub.f64 fd389, fd387, fd388;
mul.f64 fd390, fd376, 0dBFD3C6EF372FE950;
fma.rn.f64 fd391, fd359, 0d3FEE6F0E134454FF, fd390;
mul.f64 fd392, fd351, 0dBFE9E3779B97F4A8;
mul.f64 fd393, fd368, 0d3FE2CF2304755A5E;
sub.f64 fd394, fd392, fd393;
mul.f64 fd395, fd368, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd396, fd351, 0d3FE2CF2304755A5E, fd395;
sub.f64 fd397, fd296, fd338;
sub.f64 fd398, fd300, fd342;
add.f64 fd399, fd308, fd379;
add.f64 fd400, fd325, fd381;
sub.f64 fd401, fd308, fd379;
sub.f64 fd402, fd325, fd381;
add.f64 fd403, fd316, fd384;
add.f64 fd404, fd333, fd386;
sub.f64 fd405, fd316, fd384;
sub.f64 fd406, fd333, fd386;
add.f64 fd407, fd317, fd389;
add.f64 fd408, fd334, fd391;
sub.f64 fd409, fd317, fd389;
sub.f64 fd410, fd334, fd391;
add.f64 fd411, fd309, fd394;
add.f64 fd412, fd326, fd396;
sub.f64 fd413, fd309, fd394;
sub.f64 fd414, fd326, fd396;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 10;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 16;
mov.u64 rd10, %22;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd415, fd416}, [rd11];
mul.f64 fd419, fd400, fd416;
mul.f64 fd420, fd399, fd416;
mul.f64 fd421, fd415, fd400;
mul.f64 fd422, fd415, fd415;
mul.f64 fd423, fd416, fd416;
sub.f64 fd424, fd422, fd423;
mul.f64 fd425, fd416, fd415;
fma.rn.f64 fd426, fd416, fd415, fd425;
mul.f64 fd427, fd404, fd426;
mul.f64 fd428, fd403, fd426;
mul.f64 fd429, fd424, fd404;
mul.f64 fd430, fd415, fd424;
mul.f64 fd431, fd416, fd426;
sub.f64 fd432, fd430, fd431;
mul.f64 fd433, fd415, fd426;
fma.rn.f64 fd434, fd416, fd424, fd433;
mul.f64 fd435, fd408, fd434;
mul.f64 fd436, fd407, fd434;
mul.f64 fd437, fd432, fd408;
mul.f64 fd438, fd415, fd432;
mul.f64 fd439, fd416, fd434;
sub.f64 fd440, fd438, fd439;
mul.f64 fd441, fd415, fd434;
fma.rn.f64 fd442, fd416, fd432, fd441;
mul.f64 fd443, fd412, fd442;
mul.f64 fd444, fd411, fd442;
mul.f64 fd445, fd440, fd412;
mul.f64 fd446, fd415, fd440;
mul.f64 fd447, fd416, fd442;
sub.f64 fd448, fd446, fd447;
mul.f64 fd449, fd415, fd442;
fma.rn.f64 fd450, fd416, fd440, fd449;
mul.f64 fd451, fd398, fd450;
mul.f64 fd452, fd397, fd450;
mul.f64 fd453, fd448, fd398;
ld.global.v2.f64 {fd454, fd455}, [rd11+160];
mul.f64 fd458, fd402, fd455;
mul.f64 fd459, fd401, fd455;
mul.f64 fd460, fd454, fd402;
mul.f64 fd461, fd415, fd454;
mul.f64 fd462, fd416, fd455;
sub.f64 fd463, fd461, fd462;
mul.f64 fd464, fd415, fd455;
fma.rn.f64 fd465, fd416, fd454, fd464;
mul.f64 fd466, fd406, fd465;
mul.f64 fd467, fd405, fd465;
mul.f64 fd468, fd463, fd406;
mul.f64 fd469, fd415, fd463;
mul.f64 fd470, fd416, fd465;
sub.f64 fd471, fd469, fd470;
mul.f64 fd472, fd415, fd465;
fma.rn.f64 fd473, fd416, fd463, fd472;
mul.f64 fd474, fd410, fd473;
mul.f64 fd475, fd409, fd473;
mul.f64 fd476, fd471, fd410;
mul.f64 fd477, fd415, fd471;
mul.f64 fd478, fd416, fd473;
sub.f64 fd479, fd477, fd478;
mul.f64 fd480, fd415, fd473;
fma.rn.f64 fd481, fd416, fd471, fd480;
mul.f64 fd482, fd414, fd481;
mul.f64 fd483, fd413, fd481;
mul.f64 fd484, fd479, fd414;
shl.b32 r14, r13, 4;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 1600, r15;
add.f64 fd485, fd300, fd342;
add.f64 fd486, fd296, fd338;
st.shared.v2.f64 [r16], {fd486, fd485};
fma.rn.f64 fd487, fd415, fd399, fd419;
sub.f64 fd488, fd421, fd420;
st.shared.v2.f64 [r16+160], {fd487, fd488};
fma.rn.f64 fd489, fd424, fd403, fd427;
sub.f64 fd490, fd429, fd428;
st.shared.v2.f64 [r16+320], {fd489, fd490};
fma.rn.f64 fd491, fd432, fd407, fd435;
sub.f64 fd492, fd437, fd436;
st.shared.v2.f64 [r16+480], {fd491, fd492};
fma.rn.f64 fd493, fd440, fd411, fd443;
sub.f64 fd494, fd445, fd444;
st.shared.v2.f64 [r16+640], {fd493, fd494};
sub.f64 fd495, fd453, fd452;
fma.rn.f64 fd496, fd448, fd397, fd451;
st.shared.v2.f64 [r16+800], {fd496, fd495};
fma.rn.f64 fd497, fd454, fd401, fd458;
sub.f64 fd498, fd460, fd459;
st.shared.v2.f64 [r16+960], {fd497, fd498};
fma.rn.f64 fd499, fd463, fd405, fd466;
sub.f64 fd500, fd468, fd467;
st.shared.v2.f64 [r16+1120], {fd499, fd500};
fma.rn.f64 fd501, fd471, fd409, fd474;
sub.f64 fd502, fd476, fd475;
st.shared.v2.f64 [r16+1280], {fd501, fd502};
fma.rn.f64 fd503, fd479, fd413, fd482;
sub.f64 fd504, fd484, fd483;
st.shared.v2.f64 [r16+1440], {fd503, fd504};
barrier.sync 0;
ld.shared.v2.f64 {fd505, fd506}, [r10];
ld.shared.v2.f64 {fd509, fd510}, [r10+1600];
ld.shared.v2.f64 {fd513, fd514}, [r10+3200];
ld.shared.v2.f64 {fd517, fd518}, [r10+4800];
ld.shared.v2.f64 {fd521, fd522}, [r10+6400];
ld.shared.v2.f64 {fd525, fd526}, [r10+8000];
ld.shared.v2.f64 {fd529, fd530}, [r10+9600];
ld.shared.v2.f64 {fd533, fd534}, [r10+11200];
ld.shared.v2.f64 {fd537, fd538}, [r10+12800];
ld.shared.v2.f64 {fd541, fd542}, [r10+14400];
add.f64 fd545, fd513, fd537;
add.f64 fd546, fd505, fd545;
add.f64 fd547, fd521, fd529;
add.f64 fd548, fd547, fd546;
add.f64 fd549, fd514, fd538;
add.f64 fd550, fd506, fd549;
add.f64 fd551, fd522, fd530;
add.f64 fd552, fd551, fd550;
fma.rn.f64 fd553, fd545, 0d3FD3C6EF372FE950, fd505;
mul.f64 fd554, fd547, 0d3FE9E3779B97F4A8;
sub.f64 fd555, fd553, fd554;
sub.f64 fd556, fd514, fd538;
mul.f64 fd557, fd556, 0d3FEE6F0E134454FF;
sub.f64 fd558, fd522, fd530;
fma.rn.f64 fd559, fd558, 0d3FE2CF2304755A5E, fd557;
sub.f64 fd560, fd555, fd559;
add.f64 fd561, fd559, fd555;
mul.f64 fd562, fd545, 0d3FE9E3779B97F4A8;
sub.f64 fd563, fd505, fd562;
fma.rn.f64 fd564, fd547, 0d3FD3C6EF372FE950, fd563;
mul.f64 fd565, fd556, 0d3FE2CF2304755A5E;
mul.f64 fd566, fd558, 0d3FEE6F0E134454FF;
sub.f64 fd567, fd565, fd566;
sub.f64 fd568, fd564, fd567;
add.f64 fd569, fd567, fd564;
fma.rn.f64 fd570, fd549, 0d3FD3C6EF372FE950, fd506;
mul.f64 fd571, fd551, 0d3FE9E3779B97F4A8;
sub.f64 fd572, fd570, fd571;
sub.f64 fd573, fd513, fd537;
mul.f64 fd574, fd573, 0d3FEE6F0E134454FF;
sub.f64 fd575, fd521, fd529;
fma.rn.f64 fd576, fd575, 0d3FE2CF2304755A5E, fd574;
add.f64 fd577, fd576, fd572;
sub.f64 fd578, fd572, fd576;
mul.f64 fd579, fd549, 0d3FE9E3779B97F4A8;
sub.f64 fd580, fd506, fd579;
fma.rn.f64 fd581, fd551, 0d3FD3C6EF372FE950, fd580;
mul.f64 fd582, fd573, 0d3FE2CF2304755A5E;
mul.f64 fd583, fd575, 0d3FEE6F0E134454FF;
sub.f64 fd584, fd582, fd583;
add.f64 fd585, fd584, fd581;
sub.f64 fd586, fd581, fd584;
add.f64 fd587, fd517, fd541;
add.f64 fd588, fd509, fd587;
add.f64 fd589, fd525, fd533;
add.f64 fd590, fd589, fd588;
add.f64 fd591, fd518, fd542;
add.f64 fd592, fd510, fd591;
add.f64 fd593, fd526, fd534;
add.f64 fd594, fd593, fd592;
fma.rn.f64 fd595, fd587, 0d3FD3C6EF372FE950, fd509;
mul.f64 fd596, fd589, 0d3FE9E3779B97F4A8;
sub.f64 fd597, fd595, fd596;
sub.f64 fd598, fd518, fd542;
mul.f64 fd599, fd598, 0d3FEE6F0E134454FF;
sub.f64 fd600, fd526, fd534;
fma.rn.f64 fd601, fd600, 0d3FE2CF2304755A5E, fd599;
sub.f64 fd602, fd597, fd601;
add.f64 fd603, fd601, fd597;
mul.f64 fd604, fd587, 0d3FE9E3779B97F4A8;
sub.f64 fd605, fd509, fd604;
fma.rn.f64 fd606, fd589, 0d3FD3C6EF372FE950, fd605;
mul.f64 fd607, fd598, 0d3FE2CF2304755A5E;
mul.f64 fd608, fd600, 0d3FEE6F0E134454FF;
sub.f64 fd609, fd607, fd608;
sub.f64 fd610, fd606, fd609;
add.f64 fd611, fd609, fd606;
fma.rn.f64 fd612, fd591, 0d3FD3C6EF372FE950, fd510;
mul.f64 fd613, fd593, 0d3FE9E3779B97F4A8;
sub.f64 fd614, fd612, fd613;
sub.f64 fd615, fd517, fd541;
mul.f64 fd616, fd615, 0d3FEE6F0E134454FF;
sub.f64 fd617, fd525, fd533;
fma.rn.f64 fd618, fd617, 0d3FE2CF2304755A5E, fd616;
add.f64 fd619, fd618, fd614;
sub.f64 fd620, fd614, fd618;
mul.f64 fd621, fd591, 0d3FE9E3779B97F4A8;
sub.f64 fd622, fd510, fd621;
fma.rn.f64 fd623, fd593, 0d3FD3C6EF372FE950, fd622;
mul.f64 fd624, fd615, 0d3FE2CF2304755A5E;
mul.f64 fd625, fd617, 0d3FEE6F0E134454FF;
sub.f64 fd626, fd624, fd625;
add.f64 fd627, fd626, fd623;
sub.f64 fd628, fd623, fd626;
mul.f64 fd629, fd602, 0d3FE9E3779B97F4A8;
mul.f64 fd630, fd619, 0d3FE2CF2304755A5E;
sub.f64 fd631, fd629, fd630;
mul.f64 fd632, fd619, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd633, fd602, 0d3FE2CF2304755A5E, fd632;
mul.f64 fd634, fd610, 0d3FD3C6EF372FE950;
mul.f64 fd635, fd627, 0d3FEE6F0E134454FF;
sub.f64 fd636, fd634, fd635;
mul.f64 fd637, fd627, 0d3FD3C6EF372FE950;
fma.rn.f64 fd638, fd610, 0d3FEE6F0E134454FF, fd637;
mul.f64 fd639, fd611, 0dBFD3C6EF372FE950;
mul.f64 fd640, fd628, 0d3FEE6F0E134454FF;
sub.f64 fd641, fd639, fd640;
mul.f64 fd642, fd628, 0dBFD3C6EF372FE950;
fma.rn.f64 fd643, fd611, 0d3FEE6F0E134454FF, fd642;
mul.f64 fd644, fd603, 0dBFE9E3779B97F4A8;
mul.f64 fd645, fd620, 0d3FE2CF2304755A5E;
sub.f64 fd646, fd644, fd645;
mul.f64 fd647, fd620, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd648, fd603, 0d3FE2CF2304755A5E, fd647;
add.f64 %1, fd552, fd594;
add.f64 %0, fd548, fd590;
add.f64 %3, fd577, fd633;
add.f64 %2, fd560, fd631;
add.f64 %5, fd585, fd638;
add.f64 %4, fd568, fd636;
add.f64 %7, fd586, fd643;
add.f64 %6, fd569, fd641;
add.f64 %9, fd578, fd648;
add.f64 %8, fd561, fd646;
sub.f64 %11, fd552, fd594;
sub.f64 %10, fd548, fd590;
sub.f64 %13, fd577, fd633;
sub.f64 %12, fd560, fd631;
sub.f64 %15, fd585, fd638;
sub.f64 %14, fd568, fd636;
sub.f64 %17, fd586, fd643;
sub.f64 %16, fd569, fd641;
sub.f64 %19, fd578, fd648;
sub.f64 %18, fd561, fd646;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y): "r"(smem), "l"(lut_dp_10_1000), "l"(lut_dp_10_100), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<740, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<17>;
.reg .f64 fd<629>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 8000, r2;
mov.u32 r4, %tid.x;
add.f64 fd41, %28, %44;
add.f64 fd42, %23, fd41;
add.f64 fd43, %33, %39;
add.f64 fd44, fd43, fd42;
add.f64 fd45, %30, %46;
add.f64 fd46, %24, fd45;
add.f64 fd47, %35, %40;
add.f64 fd48, fd47, fd46;
fma.rn.f64 fd49, fd41, 0d3FD3C6EF372FE950, %23;
mul.f64 fd50, fd43, 0d3FE9E3779B97F4A8;
sub.f64 fd51, fd49, fd50;
sub.f64 fd52, %30, %46;
mul.f64 fd53, fd52, 0d3FEE6F0E134454FF;
sub.f64 fd54, %35, %40;
fma.rn.f64 fd55, fd54, 0d3FE2CF2304755A5E, fd53;
sub.f64 fd56, fd51, fd55;
add.f64 fd57, fd55, fd51;
mul.f64 fd58, fd41, 0d3FE9E3779B97F4A8;
sub.f64 fd59, %23, fd58;
fma.rn.f64 fd60, fd43, 0d3FD3C6EF372FE950, fd59;
mul.f64 fd61, fd52, 0d3FE2CF2304755A5E;
mul.f64 fd62, fd54, 0d3FEE6F0E134454FF;
sub.f64 fd63, fd61, fd62;
sub.f64 fd64, fd60, fd63;
add.f64 fd65, fd63, fd60;
fma.rn.f64 fd66, fd45, 0d3FD3C6EF372FE950, %24;
mul.f64 fd67, fd47, 0d3FE9E3779B97F4A8;
sub.f64 fd68, fd66, fd67;
sub.f64 fd69, %28, %44;
mul.f64 fd70, fd69, 0d3FEE6F0E134454FF;
sub.f64 fd71, %33, %39;
fma.rn.f64 fd72, fd71, 0d3FE2CF2304755A5E, fd70;
add.f64 fd73, fd72, fd68;
sub.f64 fd74, fd68, fd72;
mul.f64 fd75, fd45, 0d3FE9E3779B97F4A8;
sub.f64 fd76, %24, fd75;
fma.rn.f64 fd77, fd47, 0d3FD3C6EF372FE950, fd76;
mul.f64 fd78, fd69, 0d3FE2CF2304755A5E;
mul.f64 fd79, fd71, 0d3FEE6F0E134454FF;
sub.f64 fd80, fd78, fd79;
add.f64 fd81, fd80, fd77;
sub.f64 fd82, fd77, fd80;
add.f64 fd83, %31, %47;
add.f64 fd84, %25, fd83;
add.f64 fd85, %36, %41;
add.f64 fd86, fd85, fd84;
add.f64 fd87, %32, %48;
add.f64 fd88, %27, fd87;
add.f64 fd89, %38, %43;
add.f64 fd90, fd89, fd88;
fma.rn.f64 fd91, fd83, 0d3FD3C6EF372FE950, %25;
mul.f64 fd92, fd85, 0d3FE9E3779B97F4A8;
sub.f64 fd93, fd91, fd92;
sub.f64 fd94, %32, %48;
mul.f64 fd95, fd94, 0d3FEE6F0E134454FF;
sub.f64 fd96, %38, %43;
fma.rn.f64 fd97, fd96, 0d3FE2CF2304755A5E, fd95;
sub.f64 fd98, fd93, fd97;
add.f64 fd99, fd97, fd93;
mul.f64 fd100, fd83, 0d3FE9E3779B97F4A8;
sub.f64 fd101, %25, fd100;
fma.rn.f64 fd102, fd85, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd103, fd94, 0d3FE2CF2304755A5E;
mul.f64 fd104, fd96, 0d3FEE6F0E134454FF;
sub.f64 fd105, fd103, fd104;
sub.f64 fd106, fd102, fd105;
add.f64 fd107, fd105, fd102;
fma.rn.f64 fd108, fd87, 0d3FD3C6EF372FE950, %27;
mul.f64 fd109, fd89, 0d3FE9E3779B97F4A8;
sub.f64 fd110, fd108, fd109;
sub.f64 fd111, %31, %47;
mul.f64 fd112, fd111, 0d3FEE6F0E134454FF;
sub.f64 fd113, %36, %41;
fma.rn.f64 fd114, fd113, 0d3FE2CF2304755A5E, fd112;
add.f64 fd115, fd114, fd110;
sub.f64 fd116, fd110, fd114;
mul.f64 fd117, fd87, 0d3FE9E3779B97F4A8;
sub.f64 fd118, %27, fd117;
fma.rn.f64 fd119, fd89, 0d3FD3C6EF372FE950, fd118;
mul.f64 fd120, fd111, 0d3FE2CF2304755A5E;
mul.f64 fd121, fd113, 0d3FEE6F0E134454FF;
sub.f64 fd122, fd120, fd121;
add.f64 fd123, fd122, fd119;
sub.f64 fd124, fd119, fd122;
mul.f64 fd125, fd98, 0d3FE9E3779B97F4A8;
mul.f64 fd126, fd115, 0d3FE2CF2304755A5E;
sub.f64 fd127, fd125, fd126;
mul.f64 fd128, fd115, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd129, fd98, 0d3FE2CF2304755A5E, fd128;
mul.f64 fd130, fd106, 0d3FD3C6EF372FE950;
mul.f64 fd131, fd123, 0d3FEE6F0E134454FF;
sub.f64 fd132, fd130, fd131;
mul.f64 fd133, fd123, 0d3FD3C6EF372FE950;
fma.rn.f64 fd134, fd106, 0d3FEE6F0E134454FF, fd133;
mul.f64 fd135, fd107, 0dBFD3C6EF372FE950;
mul.f64 fd136, fd124, 0d3FEE6F0E134454FF;
sub.f64 fd137, fd135, fd136;
mul.f64 fd138, fd124, 0dBFD3C6EF372FE950;
fma.rn.f64 fd139, fd107, 0d3FEE6F0E134454FF, fd138;
mul.f64 fd140, fd99, 0dBFE9E3779B97F4A8;
mul.f64 fd141, fd116, 0d3FE2CF2304755A5E;
sub.f64 fd142, fd140, fd141;
mul.f64 fd143, fd116, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd144, fd99, 0d3FE2CF2304755A5E, fd143;
add.f64 fd145, fd44, fd86;
add.f64 fd146, fd48, fd90;
sub.f64 fd147, fd44, fd86;
sub.f64 fd148, fd48, fd90;
add.f64 fd149, fd56, fd127;
add.f64 fd150, fd73, fd129;
sub.f64 fd151, fd56, fd127;
sub.f64 fd152, fd73, fd129;
add.f64 fd153, fd64, fd132;
add.f64 fd154, fd81, fd134;
sub.f64 fd155, fd64, fd132;
sub.f64 fd156, fd81, fd134;
add.f64 fd157, fd65, fd137;
add.f64 fd158, fd82, fd139;
sub.f64 fd159, fd65, fd137;
sub.f64 fd160, fd82, fd139;
add.f64 fd161, fd57, fd142;
add.f64 fd162, fd74, fd144;
sub.f64 fd163, fd57, fd142;
sub.f64 fd164, fd74, fd144;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 37;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 100;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd165, fd166}, [rd6];
mul.f64 fd169, fd150, fd166;
fma.rn.f64 fd170, fd165, fd149, fd169;
mul.f64 fd171, fd149, fd166;
mul.f64 fd172, fd165, fd150;
sub.f64 fd173, fd172, fd171;
mul.f64 fd174, fd165, fd165;
mul.f64 fd175, fd166, fd166;
sub.f64 fd176, fd174, fd175;
mul.f64 fd177, fd166, fd165;
fma.rn.f64 fd178, fd166, fd165, fd177;
mul.f64 fd179, fd154, fd178;
fma.rn.f64 fd180, fd176, fd153, fd179;
mul.f64 fd181, fd153, fd178;
mul.f64 fd182, fd176, fd154;
sub.f64 fd183, fd182, fd181;
mul.f64 fd184, fd165, fd176;
mul.f64 fd185, fd166, fd178;
sub.f64 fd186, fd184, fd185;
mul.f64 fd187, fd165, fd178;
fma.rn.f64 fd188, fd166, fd176, fd187;
mul.f64 fd189, fd158, fd188;
fma.rn.f64 fd190, fd186, fd157, fd189;
mul.f64 fd191, fd157, fd188;
mul.f64 fd192, fd186, fd158;
sub.f64 fd193, fd192, fd191;
mul.f64 fd194, fd165, fd186;
mul.f64 fd195, fd166, fd188;
sub.f64 fd196, fd194, fd195;
mul.f64 fd197, fd165, fd188;
fma.rn.f64 fd198, fd166, fd186, fd197;
mul.f64 fd199, fd162, fd198;
fma.rn.f64 fd200, fd196, fd161, fd199;
mul.f64 fd201, fd161, fd198;
mul.f64 fd202, fd196, fd162;
sub.f64 fd203, fd202, fd201;
mul.f64 fd204, fd165, fd196;
mul.f64 fd205, fd166, fd198;
sub.f64 fd206, fd204, fd205;
mul.f64 fd207, fd165, fd198;
fma.rn.f64 fd208, fd166, fd196, fd207;
mul.f64 fd209, fd148, fd208;
fma.rn.f64 fd210, fd206, fd147, fd209;
mul.f64 fd211, fd147, fd208;
mul.f64 fd212, fd206, fd148;
sub.f64 fd213, fd212, fd211;
ld.global.v2.f64 {fd214, fd215}, [rd6+1600];
mul.f64 fd218, fd152, fd215;
fma.rn.f64 fd219, fd214, fd151, fd218;
mul.f64 fd220, fd151, fd215;
mul.f64 fd221, fd214, fd152;
sub.f64 fd222, fd221, fd220;
mul.f64 fd223, fd165, fd214;
mul.f64 fd224, fd166, fd215;
sub.f64 fd225, fd223, fd224;
mul.f64 fd226, fd165, fd215;
fma.rn.f64 fd227, fd166, fd214, fd226;
mul.f64 fd228, fd156, fd227;
fma.rn.f64 fd229, fd225, fd155, fd228;
mul.f64 fd230, fd155, fd227;
mul.f64 fd231, fd225, fd156;
sub.f64 fd232, fd231, fd230;
mul.f64 fd233, fd165, fd225;
mul.f64 fd234, fd166, fd227;
sub.f64 fd235, fd233, fd234;
mul.f64 fd236, fd165, fd227;
fma.rn.f64 fd237, fd166, fd225, fd236;
mul.f64 fd238, fd160, fd237;
fma.rn.f64 fd239, fd235, fd159, fd238;
mul.f64 fd240, fd159, fd237;
mul.f64 fd241, fd235, fd160;
sub.f64 fd242, fd241, fd240;
mul.f64 fd243, fd165, fd235;
mul.f64 fd244, fd166, fd237;
sub.f64 fd245, fd243, fd244;
mul.f64 fd246, fd165, fd237;
fma.rn.f64 fd247, fd166, fd235, fd246;
mul.f64 fd248, fd164, fd247;
fma.rn.f64 fd249, fd245, fd163, fd248;
mul.f64 fd250, fd163, fd247;
mul.f64 fd251, fd245, fd164;
sub.f64 fd252, fd251, fd250;
mad.lo.s32 r8, r5, 8000, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
st.shared.v2.f64 [r9], {fd145, fd170};
st.shared.v2.f64 [r9+16], {fd180, fd190};
st.shared.v2.f64 [r9+32], {fd200, fd210};
st.shared.v2.f64 [r9+48], {fd219, fd229};
st.shared.v2.f64 [r9+64], {fd239, fd249};
barrier.sync 0;
mad.lo.s32 r10, r7, -72, r9;
ld.shared.f64 fd253, [r10];
ld.shared.f64 fd254, [r10+800];
ld.shared.f64 fd255, [r10+1600];
ld.shared.f64 fd256, [r10+2400];
ld.shared.f64 fd257, [r10+3200];
ld.shared.f64 fd258, [r10+4000];
ld.shared.f64 fd259, [r10+4800];
ld.shared.f64 fd260, [r10+5600];
ld.shared.f64 fd261, [r10+6400];
ld.shared.f64 fd262, [r10+7200];
barrier.sync 0;
st.shared.v2.f64 [r9], {fd146, fd173};
st.shared.v2.f64 [r9+16], {fd183, fd193};
st.shared.v2.f64 [r9+32], {fd203, fd213};
st.shared.v2.f64 [r9+48], {fd222, fd232};
st.shared.v2.f64 [r9+64], {fd242, fd252};
barrier.sync 0;
ld.shared.f64 fd263, [r10];
ld.shared.f64 fd264, [r10+800];
ld.shared.f64 fd265, [r10+1600];
ld.shared.f64 fd266, [r10+2400];
ld.shared.f64 fd267, [r10+3200];
ld.shared.f64 fd268, [r10+4000];
ld.shared.f64 fd269, [r10+4800];
ld.shared.f64 fd270, [r10+5600];
ld.shared.f64 fd271, [r10+6400];
ld.shared.f64 fd272, [r10+7200];
add.f64 fd273, fd255, fd261;
add.f64 fd274, fd253, fd273;
add.f64 fd275, fd257, fd259;
add.f64 fd276, fd275, fd274;
add.f64 fd277, fd265, fd271;
add.f64 fd278, fd263, fd277;
add.f64 fd279, fd267, fd269;
add.f64 fd280, fd279, fd278;
fma.rn.f64 fd281, fd273, 0d3FD3C6EF372FE950, fd253;
mul.f64 fd282, fd275, 0d3FE9E3779B97F4A8;
sub.f64 fd283, fd281, fd282;
sub.f64 fd284, fd265, fd271;
mul.f64 fd285, fd284, 0d3FEE6F0E134454FF;
sub.f64 fd286, fd267, fd269;
fma.rn.f64 fd287, fd286, 0d3FE2CF2304755A5E, fd285;
sub.f64 fd288, fd283, fd287;
add.f64 fd289, fd287, fd283;
mul.f64 fd290, fd273, 0d3FE9E3779B97F4A8;
sub.f64 fd291, fd253, fd290;
fma.rn.f64 fd292, fd275, 0d3FD3C6EF372FE950, fd291;
mul.f64 fd293, fd284, 0d3FE2CF2304755A5E;
mul.f64 fd294, fd286, 0d3FEE6F0E134454FF;
sub.f64 fd295, fd293, fd294;
sub.f64 fd296, fd292, fd295;
add.f64 fd297, fd295, fd292;
fma.rn.f64 fd298, fd277, 0d3FD3C6EF372FE950, fd263;
mul.f64 fd299, fd279, 0d3FE9E3779B97F4A8;
sub.f64 fd300, fd298, fd299;
sub.f64 fd301, fd255, fd261;
mul.f64 fd302, fd301, 0d3FEE6F0E134454FF;
sub.f64 fd303, fd257, fd259;
fma.rn.f64 fd304, fd303, 0d3FE2CF2304755A5E, fd302;
add.f64 fd305, fd304, fd300;
sub.f64 fd306, fd300, fd304;
mul.f64 fd307, fd277, 0d3FE9E3779B97F4A8;
sub.f64 fd308, fd263, fd307;
fma.rn.f64 fd309, fd279, 0d3FD3C6EF372FE950, fd308;
mul.f64 fd310, fd301, 0d3FE2CF2304755A5E;
mul.f64 fd311, fd303, 0d3FEE6F0E134454FF;
sub.f64 fd312, fd310, fd311;
add.f64 fd313, fd312, fd309;
sub.f64 fd314, fd309, fd312;
add.f64 fd315, fd256, fd262;
add.f64 fd316, fd254, fd315;
add.f64 fd317, fd258, fd260;
add.f64 fd318, fd317, fd316;
add.f64 fd319, fd266, fd272;
add.f64 fd320, fd264, fd319;
add.f64 fd321, fd268, fd270;
add.f64 fd322, fd321, fd320;
fma.rn.f64 fd323, fd315, 0d3FD3C6EF372FE950, fd254;
mul.f64 fd324, fd317, 0d3FE9E3779B97F4A8;
sub.f64 fd325, fd323, fd324;
sub.f64 fd326, fd266, fd272;
mul.f64 fd327, fd326, 0d3FEE6F0E134454FF;
sub.f64 fd328, fd268, fd270;
fma.rn.f64 fd329, fd328, 0d3FE2CF2304755A5E, fd327;
sub.f64 fd330, fd325, fd329;
add.f64 fd331, fd329, fd325;
mul.f64 fd332, fd315, 0d3FE9E3779B97F4A8;
sub.f64 fd333, fd254, fd332;
fma.rn.f64 fd334, fd317, 0d3FD3C6EF372FE950, fd333;
mul.f64 fd335, fd326, 0d3FE2CF2304755A5E;
mul.f64 fd336, fd328, 0d3FEE6F0E134454FF;
sub.f64 fd337, fd335, fd336;
sub.f64 fd338, fd334, fd337;
add.f64 fd339, fd337, fd334;
fma.rn.f64 fd340, fd319, 0d3FD3C6EF372FE950, fd264;
mul.f64 fd341, fd321, 0d3FE9E3779B97F4A8;
sub.f64 fd342, fd340, fd341;
sub.f64 fd343, fd256, fd262;
mul.f64 fd344, fd343, 0d3FEE6F0E134454FF;
sub.f64 fd345, fd258, fd260;
fma.rn.f64 fd346, fd345, 0d3FE2CF2304755A5E, fd344;
add.f64 fd347, fd346, fd342;
sub.f64 fd348, fd342, fd346;
mul.f64 fd349, fd319, 0d3FE9E3779B97F4A8;
sub.f64 fd350, fd264, fd349;
fma.rn.f64 fd351, fd321, 0d3FD3C6EF372FE950, fd350;
mul.f64 fd352, fd343, 0d3FE2CF2304755A5E;
mul.f64 fd353, fd345, 0d3FEE6F0E134454FF;
sub.f64 fd354, fd352, fd353;
add.f64 fd355, fd354, fd351;
sub.f64 fd356, fd351, fd354;
mul.f64 fd357, fd330, 0d3FE9E3779B97F4A8;
mul.f64 fd358, fd347, 0d3FE2CF2304755A5E;
sub.f64 fd359, fd357, fd358;
mul.f64 fd360, fd347, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd361, fd330, 0d3FE2CF2304755A5E, fd360;
mul.f64 fd362, fd338, 0d3FD3C6EF372FE950;
mul.f64 fd363, fd355, 0d3FEE6F0E134454FF;
sub.f64 fd364, fd362, fd363;
mul.f64 fd365, fd355, 0d3FD3C6EF372FE950;
fma.rn.f64 fd366, fd338, 0d3FEE6F0E134454FF, fd365;
mul.f64 fd367, fd339, 0dBFD3C6EF372FE950;
mul.f64 fd368, fd356, 0d3FEE6F0E134454FF;
sub.f64 fd369, fd367, fd368;
mul.f64 fd370, fd356, 0dBFD3C6EF372FE950;
fma.rn.f64 fd371, fd339, 0d3FEE6F0E134454FF, fd370;
mul.f64 fd372, fd331, 0dBFE9E3779B97F4A8;
mul.f64 fd373, fd348, 0d3FE2CF2304755A5E;
sub.f64 fd374, fd372, fd373;
mul.f64 fd375, fd348, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd376, fd331, 0d3FE2CF2304755A5E, fd375;
add.f64 fd377, fd276, fd318;
add.f64 fd378, fd280, fd322;
sub.f64 fd379, fd276, fd318;
sub.f64 fd380, fd280, fd322;
add.f64 fd381, fd288, fd359;
add.f64 fd382, fd305, fd361;
sub.f64 fd383, fd288, fd359;
sub.f64 fd384, fd305, fd361;
add.f64 fd385, fd296, fd364;
add.f64 fd386, fd313, fd366;
sub.f64 fd387, fd296, fd364;
sub.f64 fd388, fd313, fd366;
add.f64 fd389, fd297, fd369;
add.f64 fd390, fd314, fd371;
sub.f64 fd391, fd297, fd369;
sub.f64 fd392, fd314, fd371;
add.f64 fd393, fd289, fd374;
add.f64 fd394, fd306, fd376;
sub.f64 fd395, fd289, fd374;
sub.f64 fd396, fd306, fd376;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 10;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 16;
mov.u64 rd10, %22;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd397, fd398}, [rd11];
mul.f64 fd401, fd382, fd398;
fma.rn.f64 fd402, fd397, fd381, fd401;
mul.f64 fd403, fd381, fd398;
mul.f64 fd404, fd397, fd382;
sub.f64 fd405, fd404, fd403;
mul.f64 fd406, fd397, fd397;
mul.f64 fd407, fd398, fd398;
sub.f64 fd408, fd406, fd407;
mul.f64 fd409, fd398, fd397;
fma.rn.f64 fd410, fd398, fd397, fd409;
mul.f64 fd411, fd386, fd410;
fma.rn.f64 fd412, fd408, fd385, fd411;
mul.f64 fd413, fd385, fd410;
mul.f64 fd414, fd408, fd386;
sub.f64 fd415, fd414, fd413;
mul.f64 fd416, fd397, fd408;
mul.f64 fd417, fd398, fd410;
sub.f64 fd418, fd416, fd417;
mul.f64 fd419, fd397, fd410;
fma.rn.f64 fd420, fd398, fd408, fd419;
mul.f64 fd421, fd390, fd420;
fma.rn.f64 fd422, fd418, fd389, fd421;
mul.f64 fd423, fd389, fd420;
mul.f64 fd424, fd418, fd390;
sub.f64 fd425, fd424, fd423;
mul.f64 fd426, fd397, fd418;
mul.f64 fd427, fd398, fd420;
sub.f64 fd428, fd426, fd427;
mul.f64 fd429, fd397, fd420;
fma.rn.f64 fd430, fd398, fd418, fd429;
mul.f64 fd431, fd394, fd430;
fma.rn.f64 fd432, fd428, fd393, fd431;
mul.f64 fd433, fd393, fd430;
mul.f64 fd434, fd428, fd394;
sub.f64 fd435, fd434, fd433;
mul.f64 fd436, fd397, fd428;
mul.f64 fd437, fd398, fd430;
sub.f64 fd438, fd436, fd437;
mul.f64 fd439, fd397, fd430;
fma.rn.f64 fd440, fd398, fd428, fd439;
mul.f64 fd441, fd380, fd440;
fma.rn.f64 fd442, fd438, fd379, fd441;
mul.f64 fd443, fd379, fd440;
mul.f64 fd444, fd438, fd380;
sub.f64 fd445, fd444, fd443;
ld.global.v2.f64 {fd446, fd447}, [rd11+160];
mul.f64 fd450, fd384, fd447;
fma.rn.f64 fd451, fd446, fd383, fd450;
mul.f64 fd452, fd383, fd447;
mul.f64 fd453, fd446, fd384;
sub.f64 fd454, fd453, fd452;
mul.f64 fd455, fd397, fd446;
mul.f64 fd456, fd398, fd447;
sub.f64 fd457, fd455, fd456;
mul.f64 fd458, fd397, fd447;
fma.rn.f64 fd459, fd398, fd446, fd458;
mul.f64 fd460, fd388, fd459;
fma.rn.f64 fd461, fd457, fd387, fd460;
mul.f64 fd462, fd387, fd459;
mul.f64 fd463, fd457, fd388;
sub.f64 fd464, fd463, fd462;
mul.f64 fd465, fd397, fd457;
mul.f64 fd466, fd398, fd459;
sub.f64 fd467, fd465, fd466;
mul.f64 fd468, fd397, fd459;
fma.rn.f64 fd469, fd398, fd457, fd468;
mul.f64 fd470, fd392, fd469;
fma.rn.f64 fd471, fd467, fd391, fd470;
mul.f64 fd472, fd391, fd469;
mul.f64 fd473, fd467, fd392;
sub.f64 fd474, fd473, fd472;
mul.f64 fd475, fd397, fd467;
mul.f64 fd476, fd398, fd469;
sub.f64 fd477, fd475, fd476;
mul.f64 fd478, fd397, fd469;
fma.rn.f64 fd479, fd398, fd467, fd478;
mul.f64 fd480, fd396, fd479;
fma.rn.f64 fd481, fd477, fd395, fd480;
mul.f64 fd482, fd395, fd479;
mul.f64 fd483, fd477, fd396;
sub.f64 fd484, fd483, fd482;
shl.b32 r14, r13, 3;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 800, r15;
st.shared.f64 [r16], fd377;
st.shared.f64 [r16+80], fd402;
st.shared.f64 [r16+160], fd412;
st.shared.f64 [r16+240], fd422;
st.shared.f64 [r16+320], fd432;
st.shared.f64 [r16+400], fd442;
st.shared.f64 [r16+480], fd451;
st.shared.f64 [r16+560], fd461;
st.shared.f64 [r16+640], fd471;
st.shared.f64 [r16+720], fd481;
barrier.sync 0;
ld.shared.f64 fd485, [r10];
ld.shared.f64 fd486, [r10+800];
ld.shared.f64 fd487, [r10+1600];
ld.shared.f64 fd488, [r10+2400];
ld.shared.f64 fd489, [r10+3200];
ld.shared.f64 fd490, [r10+4000];
ld.shared.f64 fd491, [r10+4800];
ld.shared.f64 fd492, [r10+5600];
ld.shared.f64 fd493, [r10+6400];
ld.shared.f64 fd494, [r10+7200];
barrier.sync 0;
st.shared.f64 [r16], fd378;
st.shared.f64 [r16+80], fd405;
st.shared.f64 [r16+160], fd415;
st.shared.f64 [r16+240], fd425;
st.shared.f64 [r16+320], fd435;
st.shared.f64 [r16+400], fd445;
st.shared.f64 [r16+480], fd454;
st.shared.f64 [r16+560], fd464;
st.shared.f64 [r16+640], fd474;
st.shared.f64 [r16+720], fd484;
barrier.sync 0;
ld.shared.f64 fd495, [r10];
ld.shared.f64 fd496, [r10+800];
ld.shared.f64 fd497, [r10+1600];
ld.shared.f64 fd498, [r10+2400];
ld.shared.f64 fd499, [r10+3200];
ld.shared.f64 fd500, [r10+4000];
ld.shared.f64 fd501, [r10+4800];
ld.shared.f64 fd502, [r10+5600];
ld.shared.f64 fd503, [r10+6400];
ld.shared.f64 fd504, [r10+7200];
add.f64 fd505, fd487, fd493;
add.f64 fd506, fd485, fd505;
add.f64 fd507, fd489, fd491;
add.f64 fd508, fd507, fd506;
add.f64 fd509, fd497, fd503;
add.f64 fd510, fd495, fd509;
add.f64 fd511, fd499, fd501;
add.f64 fd512, fd511, fd510;
fma.rn.f64 fd513, fd505, 0d3FD3C6EF372FE950, fd485;
mul.f64 fd514, fd507, 0d3FE9E3779B97F4A8;
sub.f64 fd515, fd513, fd514;
sub.f64 fd516, fd497, fd503;
mul.f64 fd517, fd516, 0d3FEE6F0E134454FF;
sub.f64 fd518, fd499, fd501;
fma.rn.f64 fd519, fd518, 0d3FE2CF2304755A5E, fd517;
sub.f64 fd520, fd515, fd519;
add.f64 fd521, fd519, fd515;
mul.f64 fd522, fd505, 0d3FE9E3779B97F4A8;
sub.f64 fd523, fd485, fd522;
fma.rn.f64 fd524, fd507, 0d3FD3C6EF372FE950, fd523;
mul.f64 fd525, fd516, 0d3FE2CF2304755A5E;
mul.f64 fd526, fd518, 0d3FEE6F0E134454FF;
sub.f64 fd527, fd525, fd526;
sub.f64 fd528, fd524, fd527;
add.f64 fd529, fd527, fd524;
fma.rn.f64 fd530, fd509, 0d3FD3C6EF372FE950, fd495;
mul.f64 fd531, fd511, 0d3FE9E3779B97F4A8;
sub.f64 fd532, fd530, fd531;
sub.f64 fd533, fd487, fd493;
mul.f64 fd534, fd533, 0d3FEE6F0E134454FF;
sub.f64 fd535, fd489, fd491;
fma.rn.f64 fd536, fd535, 0d3FE2CF2304755A5E, fd534;
add.f64 fd537, fd536, fd532;
sub.f64 fd538, fd532, fd536;
mul.f64 fd539, fd509, 0d3FE9E3779B97F4A8;
sub.f64 fd540, fd495, fd539;
fma.rn.f64 fd541, fd511, 0d3FD3C6EF372FE950, fd540;
mul.f64 fd542, fd533, 0d3FE2CF2304755A5E;
mul.f64 fd543, fd535, 0d3FEE6F0E134454FF;
sub.f64 fd544, fd542, fd543;
add.f64 fd545, fd544, fd541;
sub.f64 fd546, fd541, fd544;
add.f64 fd547, fd488, fd494;
add.f64 fd548, fd486, fd547;
add.f64 fd549, fd490, fd492;
add.f64 fd550, fd549, fd548;
add.f64 fd551, fd498, fd504;
add.f64 fd552, fd496, fd551;
add.f64 fd553, fd500, fd502;
add.f64 fd554, fd553, fd552;
fma.rn.f64 fd555, fd547, 0d3FD3C6EF372FE950, fd486;
mul.f64 fd556, fd549, 0d3FE9E3779B97F4A8;
sub.f64 fd557, fd555, fd556;
sub.f64 fd558, fd498, fd504;
mul.f64 fd559, fd558, 0d3FEE6F0E134454FF;
sub.f64 fd560, fd500, fd502;
fma.rn.f64 fd561, fd560, 0d3FE2CF2304755A5E, fd559;
sub.f64 fd562, fd557, fd561;
add.f64 fd563, fd561, fd557;
mul.f64 fd564, fd547, 0d3FE9E3779B97F4A8;
sub.f64 fd565, fd486, fd564;
fma.rn.f64 fd566, fd549, 0d3FD3C6EF372FE950, fd565;
mul.f64 fd567, fd558, 0d3FE2CF2304755A5E;
mul.f64 fd568, fd560, 0d3FEE6F0E134454FF;
sub.f64 fd569, fd567, fd568;
sub.f64 fd570, fd566, fd569;
add.f64 fd571, fd569, fd566;
fma.rn.f64 fd572, fd551, 0d3FD3C6EF372FE950, fd496;
mul.f64 fd573, fd553, 0d3FE9E3779B97F4A8;
sub.f64 fd574, fd572, fd573;
sub.f64 fd575, fd488, fd494;
mul.f64 fd576, fd575, 0d3FEE6F0E134454FF;
sub.f64 fd577, fd490, fd492;
fma.rn.f64 fd578, fd577, 0d3FE2CF2304755A5E, fd576;
add.f64 fd579, fd578, fd574;
sub.f64 fd580, fd574, fd578;
mul.f64 fd581, fd551, 0d3FE9E3779B97F4A8;
sub.f64 fd582, fd496, fd581;
fma.rn.f64 fd583, fd553, 0d3FD3C6EF372FE950, fd582;
mul.f64 fd584, fd575, 0d3FE2CF2304755A5E;
mul.f64 fd585, fd577, 0d3FEE6F0E134454FF;
sub.f64 fd586, fd584, fd585;
add.f64 fd587, fd586, fd583;
sub.f64 fd588, fd583, fd586;
mul.f64 fd589, fd562, 0d3FE9E3779B97F4A8;
mul.f64 fd590, fd579, 0d3FE2CF2304755A5E;
sub.f64 fd591, fd589, fd590;
mul.f64 fd592, fd579, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd593, fd562, 0d3FE2CF2304755A5E, fd592;
mul.f64 fd594, fd570, 0d3FD3C6EF372FE950;
mul.f64 fd595, fd587, 0d3FEE6F0E134454FF;
sub.f64 fd596, fd594, fd595;
mul.f64 fd597, fd587, 0d3FD3C6EF372FE950;
fma.rn.f64 fd598, fd570, 0d3FEE6F0E134454FF, fd597;
mul.f64 fd599, fd571, 0dBFD3C6EF372FE950;
mul.f64 fd600, fd588, 0d3FEE6F0E134454FF;
sub.f64 fd601, fd599, fd600;
mul.f64 fd602, fd588, 0dBFD3C6EF372FE950;
fma.rn.f64 fd603, fd571, 0d3FEE6F0E134454FF, fd602;
mul.f64 fd604, fd563, 0dBFE9E3779B97F4A8;
mul.f64 fd605, fd580, 0d3FE2CF2304755A5E;
sub.f64 fd606, fd604, fd605;
mul.f64 fd607, fd580, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd608, fd563, 0d3FE2CF2304755A5E, fd607;
add.f64 %0, fd508, fd550;
add.f64 %1, fd512, fd554;
add.f64 %3, fd537, fd593;
add.f64 %2, fd520, fd591;
add.f64 %5, fd545, fd598;
add.f64 %4, fd528, fd596;
add.f64 %7, fd546, fd603;
add.f64 %6, fd529, fd601;
add.f64 %9, fd538, fd608;
add.f64 %8, fd521, fd606;
sub.f64 %10, fd508, fd550;
sub.f64 %11, fd512, fd554;
sub.f64 %13, fd537, fd593;
sub.f64 %12, fd520, fd591;
sub.f64 %15, fd545, fd598;
sub.f64 %14, fd528, fd596;
sub.f64 %17, fd546, fd603;
sub.f64 %16, fd529, fd601;
sub.f64 %19, fd538, fd608;
sub.f64 %18, fd521, fd606;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y): "r"(smem), "l"(lut_dp_10_1000), "l"(lut_dp_10_100), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y));
};


#endif
