#ifndef CUFFTDX_FFT_125_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_125_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<710, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<14>;
.reg .f64 fd<1368>;
.reg .b64 rd<9>;
mov.u32 r12, %tid.y;
mov.u32 r13, %50;
mad.lo.s32 r3, r12, 2000, r13;
add.f64 fd101, %62, %92;
add.f64 fd103, %72, %82;
add.f64 fd1367, %52, fd101;
add.f64 fd104, fd103, fd1367;
add.f64 fd105, %102, %104;
add.f64 fd107, %103, %83;
add.f64 fd1363, %53, fd105;
add.f64 fd108, fd107, fd1363;
mul.f64 fd110, fd103, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1362, fd101, 0d3FD3C6EF372FE950, %52;
sub.f64 fd111, fd1362, fd110;
sub.f64 fd112, %102, %104;
sub.f64 fd114, %103, %83;
mul.f64 fd1361, fd112, 0d3FEE6F0E134454FF;
fma.rn.f64 fd115, fd114, 0d3FE2CF2304755A5E, fd1361;
sub.f64 fd116, fd111, fd115;
add.f64 fd117, fd115, fd111;
mul.f64 fd118, fd101, 0d3FE9E3779B97F4A8;
sub.f64 fd119, %52, fd118;
fma.rn.f64 fd120, fd103, 0d3FD3C6EF372FE950, fd119;
mul.f64 fd121, fd112, 0d3FE2CF2304755A5E;
mul.f64 fd122, fd114, 0d3FEE6F0E134454FF;
sub.f64 fd123, fd121, fd122;
sub.f64 fd124, fd120, fd123;
add.f64 fd125, fd123, fd120;
mul.f64 fd127, fd107, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1360, fd105, 0d3FD3C6EF372FE950, %53;
sub.f64 fd128, fd1360, fd127;
sub.f64 fd129, %62, %92;
sub.f64 fd131, %72, %82;
mul.f64 fd1359, fd129, 0d3FEE6F0E134454FF;
fma.rn.f64 fd132, fd131, 0d3FE2CF2304755A5E, fd1359;
add.f64 fd133, fd132, fd128;
sub.f64 fd134, fd128, fd132;
mul.f64 fd135, fd105, 0d3FE9E3779B97F4A8;
sub.f64 fd136, %53, fd135;
fma.rn.f64 fd137, fd107, 0d3FD3C6EF372FE950, fd136;
mul.f64 fd138, fd129, 0d3FE2CF2304755A5E;
mul.f64 fd139, fd131, 0d3FEE6F0E134454FF;
sub.f64 fd140, fd138, fd139;
add.f64 fd141, fd140, fd137;
sub.f64 fd142, fd137, fd140;
add.f64 fd143, %64, %94;
add.f64 fd145, %74, %84;
add.f64 fd1358, %54, fd143;
add.f64 fd146, fd145, fd1358;
add.f64 fd147, %65, %95;
add.f64 fd149, %107, %105;
add.f64 fd1354, %106, fd147;
add.f64 fd150, fd149, fd1354;
fma.rn.f64 fd1352, fd143, 0d3FD3C6EF372FE950, %54;
mul.f64 fd1353, fd145, 0d3FE9E3779B97F4A8;
sub.f64 fd153, fd1352, fd1353;
sub.f64 fd154, %65, %95;
sub.f64 fd156, %107, %105;
mul.f64 fd1351, fd154, 0d3FEE6F0E134454FF;
fma.rn.f64 fd157, fd156, 0d3FE2CF2304755A5E, fd1351;
sub.f64 fd158, fd153, fd157;
add.f64 fd159, fd157, fd153;
mul.f64 fd160, fd143, 0d3FE9E3779B97F4A8;
sub.f64 fd161, %54, fd160;
fma.rn.f64 fd162, fd145, 0d3FD3C6EF372FE950, fd161;
mul.f64 fd163, fd154, 0d3FE2CF2304755A5E;
mul.f64 fd164, fd156, 0d3FEE6F0E134454FF;
sub.f64 fd165, fd163, fd164;
sub.f64 fd166, fd162, fd165;
add.f64 fd167, fd165, fd162;
mul.f64 fd169, fd149, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1350, fd147, 0d3FD3C6EF372FE950, %106;
sub.f64 fd170, fd1350, fd169;
sub.f64 fd171, %64, %94;
sub.f64 fd173, %74, %84;
mul.f64 fd1349, fd171, 0d3FEE6F0E134454FF;
fma.rn.f64 fd174, fd173, 0d3FE2CF2304755A5E, fd1349;
add.f64 fd175, fd174, fd170;
sub.f64 fd176, fd170, fd174;
mul.f64 fd177, fd147, 0d3FE9E3779B97F4A8;
sub.f64 fd178, %106, fd177;
fma.rn.f64 fd179, fd149, 0d3FD3C6EF372FE950, fd178;
mul.f64 fd180, fd171, 0d3FE2CF2304755A5E;
mul.f64 fd181, fd173, 0d3FEE6F0E134454FF;
sub.f64 fd182, fd180, fd181;
add.f64 fd183, fd182, fd179;
sub.f64 fd184, fd179, fd182;
add.f64 fd185, %66, %96;
add.f64 fd187, %76, %86;
add.f64 fd1348, %56, fd185;
add.f64 fd188, fd187, fd1348;
add.f64 fd189, %110, %109;
add.f64 fd191, %77, %111;
add.f64 fd1343, %108, fd189;
add.f64 fd192, fd191, fd1343;
fma.rn.f64 fd1341, fd185, 0d3FD3C6EF372FE950, %56;
mul.f64 fd1342, fd187, 0d3FE9E3779B97F4A8;
sub.f64 fd195, fd1341, fd1342;
sub.f64 fd196, %110, %109;
sub.f64 fd198, %77, %111;
mul.f64 fd1340, fd196, 0d3FEE6F0E134454FF;
fma.rn.f64 fd199, fd198, 0d3FE2CF2304755A5E, fd1340;
sub.f64 fd200, fd195, fd199;
add.f64 fd201, fd199, fd195;
mul.f64 fd202, fd185, 0d3FE9E3779B97F4A8;
sub.f64 fd203, %56, fd202;
fma.rn.f64 fd204, fd187, 0d3FD3C6EF372FE950, fd203;
mul.f64 fd205, fd196, 0d3FE2CF2304755A5E;
mul.f64 fd206, fd198, 0d3FEE6F0E134454FF;
sub.f64 fd207, fd205, fd206;
sub.f64 fd208, fd204, fd207;
add.f64 fd209, fd207, fd204;
fma.rn.f64 fd1338, fd189, 0d3FD3C6EF372FE950, %108;
mul.f64 fd1339, fd191, 0d3FE9E3779B97F4A8;
sub.f64 fd212, fd1338, fd1339;
sub.f64 fd213, %66, %96;
sub.f64 fd215, %76, %86;
mul.f64 fd1337, fd213, 0d3FEE6F0E134454FF;
fma.rn.f64 fd216, fd215, 0d3FE2CF2304755A5E, fd1337;
add.f64 fd217, fd216, fd212;
sub.f64 fd218, fd212, fd216;
mul.f64 fd219, fd189, 0d3FE9E3779B97F4A8;
sub.f64 fd220, %108, fd219;
fma.rn.f64 fd221, fd191, 0d3FD3C6EF372FE950, fd220;
mul.f64 fd222, fd213, 0d3FE2CF2304755A5E;
mul.f64 fd223, fd215, 0d3FEE6F0E134454FF;
sub.f64 fd224, fd222, fd223;
add.f64 fd225, fd224, fd221;
sub.f64 fd226, fd221, fd224;
add.f64 fd227, %68, %98;
add.f64 fd229, %78, %88;
add.f64 fd1336, %58, fd227;
add.f64 fd230, fd229, fd1336;
add.f64 fd231, %113, %112;
add.f64 fd233, %114, %89;
add.f64 fd1332, %59, fd231;
add.f64 fd234, fd233, fd1332;
mul.f64 fd236, fd229, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1331, fd227, 0d3FD3C6EF372FE950, %58;
sub.f64 fd237, fd1331, fd236;
sub.f64 fd238, %113, %112;
sub.f64 fd240, %114, %89;
mul.f64 fd1330, fd238, 0d3FEE6F0E134454FF;
fma.rn.f64 fd241, fd240, 0d3FE2CF2304755A5E, fd1330;
sub.f64 fd242, fd237, fd241;
add.f64 fd243, fd241, fd237;
mul.f64 fd244, fd227, 0d3FE9E3779B97F4A8;
sub.f64 fd245, %58, fd244;
fma.rn.f64 fd246, fd229, 0d3FD3C6EF372FE950, fd245;
mul.f64 fd247, fd238, 0d3FE2CF2304755A5E;
mul.f64 fd248, fd240, 0d3FEE6F0E134454FF;
sub.f64 fd249, fd247, fd248;
sub.f64 fd250, fd246, fd249;
add.f64 fd251, fd249, fd246;
mul.f64 fd253, fd233, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1329, fd231, 0d3FD3C6EF372FE950, %59;
sub.f64 fd254, fd1329, fd253;
sub.f64 fd255, %68, %98;
sub.f64 fd257, %78, %88;
mul.f64 fd1328, fd255, 0d3FEE6F0E134454FF;
fma.rn.f64 fd258, fd257, 0d3FE2CF2304755A5E, fd1328;
add.f64 fd259, fd258, fd254;
sub.f64 fd260, fd254, fd258;
mul.f64 fd261, fd231, 0d3FE9E3779B97F4A8;
sub.f64 fd262, %59, fd261;
fma.rn.f64 fd263, fd233, 0d3FD3C6EF372FE950, fd262;
mul.f64 fd264, fd255, 0d3FE2CF2304755A5E;
mul.f64 fd265, fd257, 0d3FEE6F0E134454FF;
sub.f64 fd266, fd264, fd265;
add.f64 fd267, fd266, fd263;
sub.f64 fd268, fd263, fd266;
add.f64 fd269, %70, %100;
add.f64 fd271, %80, %90;
add.f64 fd1327, %60, fd269;
add.f64 fd272, fd271, fd1327;
add.f64 fd273, %71, %101;
add.f64 fd275, %116, %117;
add.f64 fd1323, %115, fd273;
add.f64 fd276, fd275, fd1323;
mul.f64 fd278, fd271, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1322, fd269, 0d3FD3C6EF372FE950, %60;
sub.f64 fd279, fd1322, fd278;
sub.f64 fd280, %71, %101;
sub.f64 fd282, %116, %117;
mul.f64 fd1321, fd280, 0d3FEE6F0E134454FF;
fma.rn.f64 fd283, fd282, 0d3FE2CF2304755A5E, fd1321;
sub.f64 fd284, fd279, fd283;
add.f64 fd285, fd283, fd279;
mul.f64 fd286, fd269, 0d3FE9E3779B97F4A8;
sub.f64 fd287, %60, fd286;
fma.rn.f64 fd288, fd271, 0d3FD3C6EF372FE950, fd287;
mul.f64 fd289, fd280, 0d3FE2CF2304755A5E;
mul.f64 fd290, fd282, 0d3FEE6F0E134454FF;
sub.f64 fd291, fd289, fd290;
sub.f64 fd292, fd288, fd291;
add.f64 fd293, fd291, fd288;
mul.f64 fd295, fd275, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1320, fd273, 0d3FD3C6EF372FE950, %115;
sub.f64 fd296, fd1320, fd295;
sub.f64 fd297, %70, %100;
sub.f64 fd299, %80, %90;
mul.f64 fd1319, fd297, 0d3FEE6F0E134454FF;
fma.rn.f64 fd300, fd299, 0d3FE2CF2304755A5E, fd1319;
add.f64 fd301, fd300, fd296;
sub.f64 fd302, fd296, fd300;
mul.f64 fd303, fd273, 0d3FE9E3779B97F4A8;
sub.f64 fd304, %115, fd303;
fma.rn.f64 fd305, fd275, 0d3FD3C6EF372FE950, fd304;
mul.f64 fd306, fd297, 0d3FE2CF2304755A5E;
mul.f64 fd307, fd299, 0d3FEE6F0E134454FF;
sub.f64 fd308, fd306, fd307;
add.f64 fd309, fd308, fd305;
sub.f64 fd310, fd305, fd308;
mul.f64 fd1317, fd158, 0d3FEEFEA21D101EE0;
mul.f64 fd1318, fd175, 0d3FCFD511FA1C0796;
sub.f64 fd313, fd1317, fd1318;
mul.f64 fd314, fd175, 0d3FEEFEA21D101EE0;
fma.rn.f64 fd315, fd158, 0d3FCFD511FA1C0796, fd314;
mul.f64 fd1315, fd200, 0d3FEC0AB44E81C059;
mul.f64 fd1316, fd217, 0d3FDED50D5CBFA951;
sub.f64 fd318, fd1315, fd1316;
mul.f64 fd319, fd217, 0d3FEC0AB44E81C059;
fma.rn.f64 fd320, fd200, 0d3FDED50D5CBFA951, fd319;
mul.f64 fd322, fd259, 0d3FE5E7CF55112014;
mul.f64 fd1314, fd242, 0d3FE753B603D2B816;
sub.f64 fd323, fd1314, fd322;
mul.f64 fd324, fd259, 0d3FE753B603D2B816;
fma.rn.f64 fd325, fd242, 0d3FE5E7CF55112014, fd324;
mul.f64 fd327, fd301, 0d3FEB04BBFF642E86;
mul.f64 fd1313, fd284, 0d3FE1257E3C182B51;
sub.f64 fd328, fd1313, fd327;
mul.f64 fd329, fd301, 0d3FE1257E3C182B51;
fma.rn.f64 fd330, fd284, 0d3FEB04BBFF642E86, fd329;
mul.f64 fd332, fd183, 0d3FDED50D5CBFA951;
mul.f64 fd1312, fd166, 0d3FEC0AB44E81C059;
sub.f64 fd333, fd1312, fd332;
mul.f64 fd334, fd183, 0d3FEC0AB44E81C059;
fma.rn.f64 fd335, fd166, 0d3FDED50D5CBFA951, fd334;
mul.f64 fd337, fd225, 0d3FEB04BBFF642E86;
mul.f64 fd1311, fd208, 0d3FE1257E3C182B51;
sub.f64 fd338, fd1311, fd337;
mul.f64 fd339, fd225, 0d3FE1257E3C182B51;
fma.rn.f64 fd340, fd208, 0d3FEB04BBFF642E86, fd339;
mul.f64 fd342, fd267, 0d3FEFEFD5BFE443FE;
mul.f64 fd1310, fd250, 0d3FB0130A1BE09379;
sub.f64 fd343, fd1310, fd342;
mul.f64 fd344, fd267, 0d3FB0130A1BE09379;
fma.rn.f64 fd345, fd250, 0d3FEFEFD5BFE443FE, fd344;
mul.f64 fd1308, fd292, 0dBFDB3FF7C925819C;
mul.f64 fd1309, fd309, 0d3FECF457DCDC158C;
sub.f64 fd348, fd1308, fd1309;
mul.f64 fd349, fd309, 0dBFDB3FF7C925819C;
fma.rn.f64 fd350, fd292, 0d3FECF457DCDC158C, fd349;
mul.f64 fd1306, fd167, 0d3FE753B603D2B816;
mul.f64 fd1307, fd184, 0d3FE5E7CF55112014;
sub.f64 fd353, fd1306, fd1307;
mul.f64 fd354, fd184, 0d3FE753B603D2B816;
fma.rn.f64 fd355, fd167, 0d3FE5E7CF55112014, fd354;
mul.f64 fd1304, fd209, 0d3FB0130A1BE09379;
mul.f64 fd1305, fd226, 0d3FEFEFD5BFE443FE;
sub.f64 fd358, fd1304, fd1305;
mul.f64 fd359, fd226, 0d3FB0130A1BE09379;
fma.rn.f64 fd360, fd209, 0d3FEFEFD5BFE443FE, fd359;
mul.f64 fd1302, fd251, 0dBFE465C6FEB501BC;
mul.f64 fd1303, fd268, 0d3FE8A80B635B6BEA;
sub.f64 fd363, fd1302, fd1303;
mul.f64 fd364, fd268, 0dBFE465C6FEB501BC;
fma.rn.f64 fd365, fd251, 0d3FE8A80B635B6BEA, fd364;
mul.f64 fd367, fd310, 0d3FC00AEB5DA15BE0;
mul.f64 fd1301, fd293, 0dBFEFBF675480D903;
sub.f64 fd368, fd1301, fd367;
mul.f64 fd369, fd310, 0dBFEFBF675480D903;
fma.rn.f64 fd370, fd293, 0d3FC00AEB5DA15BE0, fd369;
mul.f64 fd372, fd176, 0d3FEB04BBFF642E86;
mul.f64 fd1300, fd159, 0d3FE1257E3C182B51;
sub.f64 fd373, fd1300, fd372;
mul.f64 fd374, fd176, 0d3FE1257E3C182B51;
fma.rn.f64 fd375, fd159, 0d3FEB04BBFF642E86, fd374;
mul.f64 fd377, fd218, 0d3FECF457DCDC158C;
mul.f64 fd1299, fd201, 0dBFDB3FF7C925819C;
sub.f64 fd378, fd1299, fd377;
mul.f64 fd379, fd218, 0dBFDB3FF7C925819C;
fma.rn.f64 fd380, fd201, 0d3FECF457DCDC158C, fd379;
mul.f64 fd382, fd260, 0d3FC00AEB5DA15BE0;
mul.f64 fd1298, fd243, 0dBFEFBF675480D903;
sub.f64 fd383, fd1298, fd382;
mul.f64 fd384, fd260, 0dBFEFBF675480D903;
fma.rn.f64 fd385, fd243, 0d3FC00AEB5DA15BE0, fd384;
mul.f64 fd387, fd302, 0dBFE8A80B635B6BEA;
mul.f64 fd1297, fd285, 0dBFE465C6FEB501BC;
sub.f64 fd388, fd1297, fd387;
mul.f64 fd389, fd302, 0dBFE465C6FEB501BC;
fma.rn.f64 fd390, fd285, 0dBFE8A80B635B6BEA, fd389;
add.f64 fd391, fd146, fd272;
add.f64 fd393, fd188, fd230;
mul.f64 fd398, fd393, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1296, fd391, 0d3FD3C6EF372FE950, fd104;
sub.f64 fd399, fd1296, fd398;
add.f64 fd1295, fd150, fd276;
sub.f64 fd400, fd150, fd276;
add.f64 fd1294, fd192, fd234;
sub.f64 fd402, fd192, fd234;
mul.f64 fd1293, fd400, 0d3FEE6F0E134454FF;
fma.rn.f64 fd403, fd402, 0d3FE2CF2304755A5E, fd1293;
sub.f64 fd404, fd399, fd403;
add.f64 fd405, fd403, fd399;
add.f64 fd1292, fd104, fd391;
mul.f64 fd406, fd391, 0d3FE9E3779B97F4A8;
sub.f64 fd407, fd104, fd406;
fma.rn.f64 fd408, fd393, 0d3FD3C6EF372FE950, fd407;
mul.f64 fd409, fd400, 0d3FE2CF2304755A5E;
mul.f64 fd410, fd402, 0d3FEE6F0E134454FF;
sub.f64 fd411, fd409, fd410;
sub.f64 fd412, fd408, fd411;
add.f64 fd413, fd411, fd408;
mul.f64 fd415, fd1294, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1291, fd1295, 0d3FD3C6EF372FE950, fd108;
sub.f64 fd416, fd1291, fd415;
sub.f64 fd417, fd146, fd272;
sub.f64 fd419, fd188, fd230;
mul.f64 fd1290, fd417, 0d3FEE6F0E134454FF;
fma.rn.f64 fd420, fd419, 0d3FE2CF2304755A5E, fd1290;
add.f64 fd421, fd420, fd416;
sub.f64 fd422, fd416, fd420;
add.f64 fd1289, fd108, fd1295;
mul.f64 fd423, fd1295, 0d3FE9E3779B97F4A8;
sub.f64 fd424, fd108, fd423;
fma.rn.f64 fd425, fd1294, 0d3FD3C6EF372FE950, fd424;
mul.f64 fd426, fd417, 0d3FE2CF2304755A5E;
mul.f64 fd427, fd419, 0d3FEE6F0E134454FF;
sub.f64 fd428, fd426, fd427;
add.f64 fd429, fd428, fd425;
sub.f64 fd430, fd425, fd428;
add.f64 fd431, fd313, fd328;
add.f64 fd433, fd318, fd323;
add.f64 fd1288, fd116, fd431;
add.f64 fd434, fd433, fd1288;
add.f64 fd435, fd315, fd330;
add.f64 fd437, fd320, fd325;
add.f64 fd1287, fd133, fd435;
add.f64 fd438, fd437, fd1287;
fma.rn.f64 fd1285, fd431, 0d3FD3C6EF372FE950, fd116;
mul.f64 fd1286, fd433, 0d3FE9E3779B97F4A8;
sub.f64 fd441, fd1285, fd1286;
sub.f64 fd442, fd315, fd330;
sub.f64 fd444, fd320, fd325;
mul.f64 fd1284, fd442, 0d3FEE6F0E134454FF;
fma.rn.f64 fd445, fd444, 0d3FE2CF2304755A5E, fd1284;
sub.f64 fd446, fd441, fd445;
add.f64 fd447, fd445, fd441;
mul.f64 fd448, fd431, 0d3FE9E3779B97F4A8;
sub.f64 fd449, fd116, fd448;
fma.rn.f64 fd450, fd433, 0d3FD3C6EF372FE950, fd449;
mul.f64 fd451, fd442, 0d3FE2CF2304755A5E;
mul.f64 fd452, fd444, 0d3FEE6F0E134454FF;
sub.f64 fd453, fd451, fd452;
sub.f64 fd454, fd450, fd453;
add.f64 fd455, fd453, fd450;
mul.f64 fd457, fd437, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1283, fd435, 0d3FD3C6EF372FE950, fd133;
sub.f64 fd458, fd1283, fd457;
sub.f64 fd459, fd313, fd328;
sub.f64 fd461, fd318, fd323;
mul.f64 fd1282, fd459, 0d3FEE6F0E134454FF;
fma.rn.f64 fd462, fd461, 0d3FE2CF2304755A5E, fd1282;
add.f64 fd463, fd462, fd458;
sub.f64 fd464, fd458, fd462;
mul.f64 fd465, fd435, 0d3FE9E3779B97F4A8;
sub.f64 fd466, fd133, fd465;
fma.rn.f64 fd467, fd437, 0d3FD3C6EF372FE950, fd466;
mul.f64 fd468, fd459, 0d3FE2CF2304755A5E;
mul.f64 fd469, fd461, 0d3FEE6F0E134454FF;
sub.f64 fd470, fd468, fd469;
add.f64 fd471, fd470, fd467;
sub.f64 fd472, fd467, fd470;
add.f64 fd473, fd333, fd348;
add.f64 fd475, fd338, fd343;
add.f64 fd1281, fd124, fd473;
add.f64 fd476, fd475, fd1281;
add.f64 fd477, fd335, fd350;
add.f64 fd479, fd340, fd345;
add.f64 fd1280, fd141, fd477;
add.f64 fd480, fd479, fd1280;
fma.rn.f64 fd1278, fd473, 0d3FD3C6EF372FE950, fd124;
mul.f64 fd1279, fd475, 0d3FE9E3779B97F4A8;
sub.f64 fd483, fd1278, fd1279;
sub.f64 fd484, fd335, fd350;
sub.f64 fd486, fd340, fd345;
mul.f64 fd1277, fd484, 0d3FEE6F0E134454FF;
fma.rn.f64 fd487, fd486, 0d3FE2CF2304755A5E, fd1277;
sub.f64 fd488, fd483, fd487;
add.f64 fd489, fd487, fd483;
mul.f64 fd490, fd473, 0d3FE9E3779B97F4A8;
sub.f64 fd491, fd124, fd490;
fma.rn.f64 fd492, fd475, 0d3FD3C6EF372FE950, fd491;
mul.f64 fd493, fd484, 0d3FE2CF2304755A5E;
mul.f64 fd494, fd486, 0d3FEE6F0E134454FF;
sub.f64 fd495, fd493, fd494;
sub.f64 fd496, fd492, fd495;
add.f64 fd497, fd495, fd492;
fma.rn.f64 fd1275, fd477, 0d3FD3C6EF372FE950, fd141;
mul.f64 fd1276, fd479, 0d3FE9E3779B97F4A8;
sub.f64 fd500, fd1275, fd1276;
sub.f64 fd501, fd333, fd348;
sub.f64 fd503, fd338, fd343;
mul.f64 fd1274, fd501, 0d3FEE6F0E134454FF;
fma.rn.f64 fd504, fd503, 0d3FE2CF2304755A5E, fd1274;
add.f64 fd505, fd504, fd500;
sub.f64 fd506, fd500, fd504;
mul.f64 fd507, fd477, 0d3FE9E3779B97F4A8;
sub.f64 fd508, fd141, fd507;
fma.rn.f64 fd509, fd479, 0d3FD3C6EF372FE950, fd508;
mul.f64 fd510, fd501, 0d3FE2CF2304755A5E;
mul.f64 fd511, fd503, 0d3FEE6F0E134454FF;
sub.f64 fd512, fd510, fd511;
add.f64 fd513, fd512, fd509;
sub.f64 fd514, fd509, fd512;
add.f64 fd515, fd353, fd368;
add.f64 fd517, fd358, fd363;
add.f64 fd1273, fd125, fd515;
add.f64 fd518, fd517, fd1273;
add.f64 fd519, fd355, fd370;
add.f64 fd521, fd360, fd365;
add.f64 fd1272, fd142, fd519;
add.f64 fd522, fd521, fd1272;
mul.f64 fd524, fd517, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1271, fd515, 0d3FD3C6EF372FE950, fd125;
sub.f64 fd525, fd1271, fd524;
sub.f64 fd526, fd355, fd370;
sub.f64 fd528, fd360, fd365;
mul.f64 fd1270, fd526, 0d3FEE6F0E134454FF;
fma.rn.f64 fd529, fd528, 0d3FE2CF2304755A5E, fd1270;
sub.f64 fd530, fd525, fd529;
add.f64 fd531, fd529, fd525;
mul.f64 fd532, fd515, 0d3FE9E3779B97F4A8;
sub.f64 fd533, fd125, fd532;
fma.rn.f64 fd534, fd517, 0d3FD3C6EF372FE950, fd533;
mul.f64 fd535, fd526, 0d3FE2CF2304755A5E;
mul.f64 fd536, fd528, 0d3FEE6F0E134454FF;
sub.f64 fd537, fd535, fd536;
sub.f64 fd538, fd534, fd537;
add.f64 fd539, fd537, fd534;
mul.f64 fd541, fd521, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1269, fd519, 0d3FD3C6EF372FE950, fd142;
sub.f64 fd542, fd1269, fd541;
sub.f64 fd543, fd353, fd368;
sub.f64 fd545, fd358, fd363;
mul.f64 fd1268, fd543, 0d3FEE6F0E134454FF;
fma.rn.f64 fd546, fd545, 0d3FE2CF2304755A5E, fd1268;
add.f64 fd547, fd546, fd542;
sub.f64 fd548, fd542, fd546;
mul.f64 fd549, fd519, 0d3FE9E3779B97F4A8;
sub.f64 fd550, fd142, fd549;
fma.rn.f64 fd551, fd521, 0d3FD3C6EF372FE950, fd550;
mul.f64 fd552, fd543, 0d3FE2CF2304755A5E;
mul.f64 fd553, fd545, 0d3FEE6F0E134454FF;
sub.f64 fd554, fd552, fd553;
add.f64 fd555, fd554, fd551;
sub.f64 fd556, fd551, fd554;
add.f64 fd557, fd373, fd388;
add.f64 fd559, fd378, fd383;
add.f64 fd1267, fd117, fd557;
add.f64 fd560, fd559, fd1267;
add.f64 fd561, fd375, fd390;
add.f64 fd563, fd380, fd385;
add.f64 fd1266, fd134, fd561;
add.f64 fd564, fd563, fd1266;
mul.f64 fd566, fd559, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1265, fd557, 0d3FD3C6EF372FE950, fd117;
sub.f64 fd567, fd1265, fd566;
sub.f64 fd568, fd375, fd390;
sub.f64 fd570, fd380, fd385;
mul.f64 fd1264, fd568, 0d3FEE6F0E134454FF;
fma.rn.f64 fd571, fd570, 0d3FE2CF2304755A5E, fd1264;
sub.f64 fd572, fd567, fd571;
add.f64 fd573, fd571, fd567;
mul.f64 fd574, fd557, 0d3FE9E3779B97F4A8;
sub.f64 fd575, fd117, fd574;
fma.rn.f64 fd576, fd559, 0d3FD3C6EF372FE950, fd575;
mul.f64 fd577, fd568, 0d3FE2CF2304755A5E;
mul.f64 fd578, fd570, 0d3FEE6F0E134454FF;
sub.f64 fd579, fd577, fd578;
sub.f64 fd580, fd576, fd579;
add.f64 fd581, fd579, fd576;
mul.f64 fd583, fd563, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1263, fd561, 0d3FD3C6EF372FE950, fd134;
sub.f64 fd584, fd1263, fd583;
sub.f64 fd585, fd373, fd388;
sub.f64 fd587, fd378, fd383;
mul.f64 fd1262, fd585, 0d3FEE6F0E134454FF;
fma.rn.f64 fd588, fd587, 0d3FE2CF2304755A5E, fd1262;
add.f64 fd589, fd588, fd584;
sub.f64 fd590, fd584, fd588;
mul.f64 fd591, fd561, 0d3FE9E3779B97F4A8;
sub.f64 fd592, fd134, fd591;
fma.rn.f64 fd593, fd563, 0d3FD3C6EF372FE950, fd592;
mul.f64 fd594, fd585, 0d3FE2CF2304755A5E;
mul.f64 fd595, fd587, 0d3FEE6F0E134454FF;
sub.f64 fd596, fd594, fd595;
add.f64 fd597, fd596, fd593;
sub.f64 fd598, fd593, fd596;
mov.u32 r11, %tid.x;
mul.wide.u32 rd2, r11, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r11, r6;
mad.lo.s32 r8, r5, 2000, r3;
mul.wide.u32 rd7, r7, 16;
mov.u64 rd8, %51;
add.s64 rd6, rd8, rd7;
ld.global.v2.f64 {fd599, fd600}, [rd6];
mul.f64 fd603, fd438, fd600;
mul.f64 fd605, fd599, fd438;
mul.f64 fd607, fd600, fd600;
mul.f64 fd1261, fd599, fd599;
sub.f64 fd608, fd1261, fd607;
mul.f64 fd609, fd600, fd599;
fma.rn.f64 fd610, fd600, fd599, fd609;
mul.f64 fd611, fd480, fd610;
mul.f64 fd613, fd608, fd480;
mul.f64 fd615, fd600, fd610;
mul.f64 fd1260, fd599, fd608;
sub.f64 fd616, fd1260, fd615;
mul.f64 fd1259, fd476, fd610;
mul.f64 fd617, fd599, fd610;
fma.rn.f64 fd618, fd600, fd608, fd617;
mul.f64 fd619, fd522, fd618;
mul.f64 fd621, fd616, fd522;
mul.f64 fd1257, fd599, fd616;
mul.f64 fd1258, fd600, fd618;
sub.f64 fd624, fd1257, fd1258;
mul.f64 fd1256, fd518, fd618;
mul.f64 fd625, fd599, fd618;
fma.rn.f64 fd626, fd600, fd616, fd625;
mul.f64 fd627, fd564, fd626;
mul.f64 fd629, fd624, fd564;
mul.f64 fd631, fd600, fd626;
mul.f64 fd1255, fd599, fd624;
sub.f64 fd632, fd1255, fd631;
mul.f64 fd1254, fd560, fd626;
mul.f64 fd633, fd599, fd626;
fma.rn.f64 fd634, fd600, fd624, fd633;
mul.f64 fd635, fd421, fd634;
mul.f64 fd637, fd632, fd421;
mul.f64 fd1252, fd599, fd632;
mul.f64 fd1253, fd600, fd634;
sub.f64 fd640, fd1252, fd1253;
mul.f64 fd1251, fd404, fd634;
mul.f64 fd641, fd599, fd634;
fma.rn.f64 fd642, fd600, fd632, fd641;
mul.f64 fd643, fd463, fd642;
mul.f64 fd645, fd640, fd463;
mul.f64 fd647, fd600, fd642;
mul.f64 fd1250, fd599, fd640;
sub.f64 fd648, fd1250, fd647;
mul.f64 fd1249, fd446, fd642;
mul.f64 fd649, fd599, fd642;
fma.rn.f64 fd650, fd600, fd640, fd649;
mul.f64 fd651, fd505, fd650;
mul.f64 fd653, fd648, fd505;
mul.f64 fd655, fd600, fd650;
mul.f64 fd1248, fd599, fd648;
sub.f64 fd656, fd1248, fd655;
mul.f64 fd1247, fd488, fd650;
mul.f64 fd657, fd599, fd650;
fma.rn.f64 fd658, fd600, fd648, fd657;
mul.f64 fd659, fd547, fd658;
mul.f64 fd661, fd656, fd547;
mul.f64 fd1245, fd599, fd656;
mul.f64 fd1246, fd600, fd658;
sub.f64 fd664, fd1245, fd1246;
mul.f64 fd1244, fd530, fd658;
mul.f64 fd665, fd599, fd658;
fma.rn.f64 fd666, fd600, fd656, fd665;
mul.f64 fd667, fd589, fd666;
mul.f64 fd669, fd664, fd589;
mul.f64 fd671, fd600, fd666;
mul.f64 fd1243, fd599, fd664;
sub.f64 fd672, fd1243, fd671;
mul.f64 fd1242, fd572, fd666;
mul.f64 fd673, fd599, fd666;
fma.rn.f64 fd674, fd600, fd664, fd673;
mul.f64 fd675, fd429, fd674;
mul.f64 fd677, fd672, fd429;
mul.f64 fd679, fd600, fd674;
mul.f64 fd1241, fd599, fd672;
sub.f64 fd680, fd1241, fd679;
mul.f64 fd1240, fd412, fd674;
mul.f64 fd681, fd599, fd674;
fma.rn.f64 fd682, fd600, fd672, fd681;
mul.f64 fd683, fd471, fd682;
mul.f64 fd685, fd680, fd471;
mul.f64 fd1238, fd599, fd680;
mul.f64 fd1239, fd600, fd682;
sub.f64 fd688, fd1238, fd1239;
mul.f64 fd1237, fd454, fd682;
mul.f64 fd689, fd599, fd682;
fma.rn.f64 fd690, fd600, fd680, fd689;
mul.f64 fd691, fd513, fd690;
mul.f64 fd692, fd496, fd690;
mul.f64 fd693, fd688, fd513;
ld.global.v2.f64 {fd694, fd695}, [rd6+80];
mul.f64 fd698, fd555, fd695;
mul.f64 fd700, fd694, fd555;
mul.f64 fd702, fd600, fd695;
mul.f64 fd1236, fd599, fd694;
sub.f64 fd703, fd1236, fd702;
mul.f64 fd1235, fd538, fd695;
mul.f64 fd704, fd599, fd695;
fma.rn.f64 fd705, fd600, fd694, fd704;
mul.f64 fd706, fd597, fd705;
mul.f64 fd708, fd703, fd597;
mul.f64 fd1233, fd599, fd703;
mul.f64 fd1234, fd600, fd705;
sub.f64 fd711, fd1233, fd1234;
mul.f64 fd1232, fd580, fd705;
mul.f64 fd712, fd599, fd705;
fma.rn.f64 fd713, fd600, fd703, fd712;
mul.f64 fd714, fd430, fd713;
mul.f64 fd716, fd711, fd430;
mul.f64 fd1230, fd599, fd711;
mul.f64 fd1231, fd600, fd713;
sub.f64 fd719, fd1230, fd1231;
mul.f64 fd1229, fd413, fd713;
mul.f64 fd720, fd599, fd713;
fma.rn.f64 fd721, fd600, fd711, fd720;
mul.f64 fd722, fd472, fd721;
mul.f64 fd724, fd719, fd472;
mul.f64 fd726, fd600, fd721;
mul.f64 fd1228, fd599, fd719;
sub.f64 fd727, fd1228, fd726;
mul.f64 fd1227, fd455, fd721;
mul.f64 fd728, fd599, fd721;
fma.rn.f64 fd729, fd600, fd719, fd728;
mul.f64 fd730, fd514, fd729;
mul.f64 fd732, fd727, fd514;
mul.f64 fd1225, fd599, fd727;
mul.f64 fd1226, fd600, fd729;
sub.f64 fd735, fd1225, fd1226;
mul.f64 fd1224, fd497, fd729;
mul.f64 fd736, fd599, fd729;
fma.rn.f64 fd737, fd600, fd727, fd736;
mul.f64 fd738, fd556, fd737;
mul.f64 fd740, fd735, fd556;
mul.f64 fd742, fd600, fd737;
mul.f64 fd1223, fd599, fd735;
sub.f64 fd743, fd1223, fd742;
mul.f64 fd1222, fd539, fd737;
mul.f64 fd744, fd599, fd737;
fma.rn.f64 fd745, fd600, fd735, fd744;
mul.f64 fd746, fd598, fd745;
mul.f64 fd748, fd743, fd598;
mul.f64 fd750, fd600, fd745;
mul.f64 fd1221, fd599, fd743;
sub.f64 fd751, fd1221, fd750;
mul.f64 fd1220, fd581, fd745;
mul.f64 fd752, fd599, fd745;
fma.rn.f64 fd753, fd600, fd743, fd752;
mul.f64 fd754, fd422, fd753;
mul.f64 fd756, fd751, fd422;
mul.f64 fd1218, fd599, fd751;
mul.f64 fd1219, fd600, fd753;
sub.f64 fd759, fd1218, fd1219;
mul.f64 fd1217, fd405, fd753;
mul.f64 fd760, fd599, fd753;
fma.rn.f64 fd761, fd600, fd751, fd760;
mul.f64 fd762, fd464, fd761;
mul.f64 fd764, fd759, fd464;
mul.f64 fd766, fd600, fd761;
mul.f64 fd1216, fd599, fd759;
sub.f64 fd767, fd1216, fd766;
mul.f64 fd1215, fd447, fd761;
mul.f64 fd768, fd599, fd761;
fma.rn.f64 fd769, fd600, fd759, fd768;
mul.f64 fd770, fd506, fd769;
mul.f64 fd772, fd767, fd506;
mul.f64 fd1213, fd599, fd767;
mul.f64 fd1214, fd600, fd769;
sub.f64 fd775, fd1213, fd1214;
mul.f64 fd1212, fd489, fd769;
mul.f64 fd776, fd599, fd769;
fma.rn.f64 fd777, fd600, fd767, fd776;
mul.f64 fd778, fd548, fd777;
mul.f64 fd780, fd775, fd548;
mul.f64 fd1210, fd599, fd775;
mul.f64 fd1211, fd600, fd777;
sub.f64 fd783, fd1210, fd1211;
mul.f64 fd1209, fd531, fd777;
mul.f64 fd784, fd599, fd777;
mul.f64 fd1208, fd434, fd600;
fma.rn.f64 fd785, fd600, fd775, fd784;
mul.f64 fd786, fd590, fd785;
mul.f64 fd787, fd573, fd785;
mul.f64 fd788, fd783, fd590;
barrier.sync 0;
mad.lo.s32 r9, r7, 400, r8;
add.f64 fd789, fd1294, fd1289;
add.f64 fd790, fd393, fd1292;
st.shared.v2.f64 [r9], {fd790, fd789};
fma.rn.f64 fd791, fd599, fd434, fd603;
sub.f64 fd792, fd605, fd1208;
st.shared.v2.f64 [r9+16], {fd791, fd792};
fma.rn.f64 fd793, fd608, fd476, fd611;
sub.f64 fd794, fd613, fd1259;
st.shared.v2.f64 [r9+32], {fd793, fd794};
fma.rn.f64 fd795, fd616, fd518, fd619;
sub.f64 fd796, fd621, fd1256;
st.shared.v2.f64 [r9+48], {fd795, fd796};
fma.rn.f64 fd797, fd624, fd560, fd627;
sub.f64 fd798, fd629, fd1254;
st.shared.v2.f64 [r9+64], {fd797, fd798};
sub.f64 fd799, fd637, fd1251;
fma.rn.f64 fd800, fd632, fd404, fd635;
st.shared.v2.f64 [r9+80], {fd800, fd799};
fma.rn.f64 fd801, fd640, fd446, fd643;
sub.f64 fd802, fd645, fd1249;
st.shared.v2.f64 [r9+96], {fd801, fd802};
sub.f64 fd803, fd653, fd1247;
fma.rn.f64 fd804, fd648, fd488, fd651;
st.shared.v2.f64 [r9+112], {fd804, fd803};
fma.rn.f64 fd805, fd656, fd530, fd659;
sub.f64 fd806, fd661, fd1244;
st.shared.v2.f64 [r9+128], {fd805, fd806};
fma.rn.f64 fd807, fd664, fd572, fd667;
sub.f64 fd808, fd669, fd1242;
st.shared.v2.f64 [r9+144], {fd807, fd808};
fma.rn.f64 fd809, fd672, fd412, fd675;
sub.f64 fd810, fd677, fd1240;
st.shared.v2.f64 [r9+160], {fd809, fd810};
fma.rn.f64 fd811, fd680, fd454, fd683;
sub.f64 fd812, fd685, fd1237;
st.shared.v2.f64 [r9+176], {fd811, fd812};
fma.rn.f64 fd813, fd688, fd496, fd691;
sub.f64 fd814, fd693, fd692;
st.shared.v2.f64 [r9+192], {fd813, fd814};
fma.rn.f64 fd815, fd694, fd538, fd698;
sub.f64 fd816, fd700, fd1235;
st.shared.v2.f64 [r9+208], {fd815, fd816};
fma.rn.f64 fd817, fd703, fd580, fd706;
sub.f64 fd818, fd708, fd1232;
st.shared.v2.f64 [r9+224], {fd817, fd818};
fma.rn.f64 fd819, fd711, fd413, fd714;
sub.f64 fd820, fd716, fd1229;
st.shared.v2.f64 [r9+240], {fd819, fd820};
fma.rn.f64 fd821, fd719, fd455, fd722;
sub.f64 fd822, fd724, fd1227;
st.shared.v2.f64 [r9+256], {fd821, fd822};
fma.rn.f64 fd823, fd727, fd497, fd730;
sub.f64 fd824, fd732, fd1224;
st.shared.v2.f64 [r9+272], {fd823, fd824};
fma.rn.f64 fd825, fd735, fd539, fd738;
sub.f64 fd826, fd740, fd1222;
st.shared.v2.f64 [r9+288], {fd825, fd826};
sub.f64 fd827, fd748, fd1220;
fma.rn.f64 fd828, fd743, fd581, fd746;
st.shared.v2.f64 [r9+304], {fd828, fd827};
fma.rn.f64 fd829, fd751, fd405, fd754;
sub.f64 fd830, fd756, fd1217;
st.shared.v2.f64 [r9+320], {fd829, fd830};
fma.rn.f64 fd831, fd759, fd447, fd762;
sub.f64 fd832, fd764, fd1215;
st.shared.v2.f64 [r9+336], {fd831, fd832};
fma.rn.f64 fd833, fd767, fd489, fd770;
sub.f64 fd834, fd772, fd1212;
st.shared.v2.f64 [r9+352], {fd833, fd834};
fma.rn.f64 fd835, fd775, fd531, fd778;
sub.f64 fd836, fd780, fd1209;
st.shared.v2.f64 [r9+368], {fd835, fd836};
fma.rn.f64 fd837, fd783, fd573, fd786;
sub.f64 fd838, fd788, fd787;
st.shared.v2.f64 [r9+384], {fd837, fd838};
barrier.sync 0;
mad.lo.s32 r10, r7, -384, r9;
ld.shared.v2.f64 {fd839, fd840}, [r10];
ld.shared.v2.f64 {fd843, fd844}, [r10+80];
ld.shared.v2.f64 {fd847, fd848}, [r10+160];
ld.shared.v2.f64 {fd851, fd852}, [r10+240];
ld.shared.v2.f64 {fd855, fd856}, [r10+320];
ld.shared.v2.f64 {fd859, fd860}, [r10+400];
ld.shared.v2.f64 {fd863, fd864}, [r10+480];
ld.shared.v2.f64 {fd867, fd868}, [r10+560];
ld.shared.v2.f64 {fd871, fd872}, [r10+640];
ld.shared.v2.f64 {fd875, fd876}, [r10+720];
ld.shared.v2.f64 {fd879, fd880}, [r10+800];
ld.shared.v2.f64 {fd883, fd884}, [r10+880];
ld.shared.v2.f64 {fd887, fd888}, [r10+960];
ld.shared.v2.f64 {fd891, fd892}, [r10+1040];
ld.shared.v2.f64 {fd895, fd896}, [r10+1120];
ld.shared.v2.f64 {fd899, fd900}, [r10+1200];
ld.shared.v2.f64 {fd903, fd904}, [r10+1280];
ld.shared.v2.f64 {fd907, fd908}, [r10+1360];
ld.shared.v2.f64 {fd911, fd912}, [r10+1440];
ld.shared.v2.f64 {fd915, fd916}, [r10+1520];
ld.shared.v2.f64 {fd919, fd920}, [r10+1600];
ld.shared.v2.f64 {fd923, fd924}, [r10+1680];
ld.shared.v2.f64 {fd927, fd928}, [r10+1760];
ld.shared.v2.f64 {fd931, fd932}, [r10+1840];
ld.shared.v2.f64 {fd935, fd936}, [r10+1920];
add.f64 fd939, fd859, fd919;
add.f64 fd941, fd879, fd899;
fma.rn.f64 fd1206, fd939, 0d3FD3C6EF372FE950, fd839;
mul.f64 fd1207, fd941, 0d3FE9E3779B97F4A8;
sub.f64 fd947, fd1206, fd1207;
add.f64 fd1205, fd860, fd920;
sub.f64 fd948, fd860, fd920;
add.f64 fd1204, fd880, fd900;
sub.f64 fd950, fd880, fd900;
mul.f64 fd1203, fd948, 0d3FEE6F0E134454FF;
fma.rn.f64 fd951, fd950, 0d3FE2CF2304755A5E, fd1203;
add.f64 fd1202, fd839, fd939;
mul.f64 fd952, fd939, 0d3FE9E3779B97F4A8;
sub.f64 fd953, fd839, fd952;
fma.rn.f64 fd954, fd941, 0d3FD3C6EF372FE950, fd953;
mul.f64 fd955, fd948, 0d3FE2CF2304755A5E;
mul.f64 fd956, fd950, 0d3FEE6F0E134454FF;
sub.f64 fd957, fd955, fd956;
mul.f64 fd959, fd1204, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1201, fd1205, 0d3FD3C6EF372FE950, fd840;
sub.f64 fd960, fd1201, fd959;
sub.f64 fd961, fd859, fd919;
sub.f64 fd963, fd879, fd899;
mul.f64 fd1200, fd961, 0d3FEE6F0E134454FF;
fma.rn.f64 fd964, fd963, 0d3FE2CF2304755A5E, fd1200;
add.f64 fd1199, fd840, fd1205;
mul.f64 fd965, fd1205, 0d3FE9E3779B97F4A8;
sub.f64 fd966, fd840, fd965;
fma.rn.f64 fd967, fd1204, 0d3FD3C6EF372FE950, fd966;
mul.f64 fd968, fd961, 0d3FE2CF2304755A5E;
mul.f64 fd969, fd963, 0d3FEE6F0E134454FF;
sub.f64 fd970, fd968, fd969;
add.f64 fd971, fd863, fd923;
add.f64 fd973, fd883, fd903;
mul.f64 fd978, fd973, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1198, fd971, 0d3FD3C6EF372FE950, fd843;
sub.f64 fd979, fd1198, fd978;
add.f64 fd1197, fd864, fd924;
sub.f64 fd980, fd864, fd924;
add.f64 fd1196, fd884, fd904;
sub.f64 fd982, fd884, fd904;
mul.f64 fd1195, fd980, 0d3FEE6F0E134454FF;
fma.rn.f64 fd983, fd982, 0d3FE2CF2304755A5E, fd1195;
add.f64 fd1194, fd843, fd971;
mul.f64 fd984, fd971, 0d3FE9E3779B97F4A8;
sub.f64 fd985, fd843, fd984;
fma.rn.f64 fd986, fd973, 0d3FD3C6EF372FE950, fd985;
mul.f64 fd987, fd980, 0d3FE2CF2304755A5E;
mul.f64 fd988, fd982, 0d3FEE6F0E134454FF;
sub.f64 fd989, fd987, fd988;
fma.rn.f64 fd1192, fd1197, 0d3FD3C6EF372FE950, fd844;
mul.f64 fd1193, fd1196, 0d3FE9E3779B97F4A8;
sub.f64 fd992, fd1192, fd1193;
sub.f64 fd993, fd863, fd923;
sub.f64 fd995, fd883, fd903;
mul.f64 fd1191, fd993, 0d3FEE6F0E134454FF;
fma.rn.f64 fd996, fd995, 0d3FE2CF2304755A5E, fd1191;
add.f64 fd1190, fd844, fd1197;
mul.f64 fd997, fd1197, 0d3FE9E3779B97F4A8;
sub.f64 fd998, fd844, fd997;
fma.rn.f64 fd999, fd1196, 0d3FD3C6EF372FE950, fd998;
mul.f64 fd1000, fd993, 0d3FE2CF2304755A5E;
mul.f64 fd1001, fd995, 0d3FEE6F0E134454FF;
sub.f64 fd1002, fd1000, fd1001;
add.f64 fd1003, fd867, fd927;
add.f64 fd1005, fd887, fd907;
fma.rn.f64 fd1188, fd1003, 0d3FD3C6EF372FE950, fd847;
mul.f64 fd1189, fd1005, 0d3FE9E3779B97F4A8;
sub.f64 fd1011, fd1188, fd1189;
add.f64 fd1187, fd868, fd928;
sub.f64 fd1012, fd868, fd928;
add.f64 fd1186, fd888, fd908;
sub.f64 fd1014, fd888, fd908;
mul.f64 fd1185, fd1012, 0d3FEE6F0E134454FF;
fma.rn.f64 fd1015, fd1014, 0d3FE2CF2304755A5E, fd1185;
add.f64 fd1184, fd847, fd1003;
mul.f64 fd1016, fd1003, 0d3FE9E3779B97F4A8;
sub.f64 fd1017, fd847, fd1016;
fma.rn.f64 fd1018, fd1005, 0d3FD3C6EF372FE950, fd1017;
mul.f64 fd1019, fd1012, 0d3FE2CF2304755A5E;
mul.f64 fd1020, fd1014, 0d3FEE6F0E134454FF;
sub.f64 fd1021, fd1019, fd1020;
mul.f64 fd1023, fd1186, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1183, fd1187, 0d3FD3C6EF372FE950, fd848;
sub.f64 fd1024, fd1183, fd1023;
sub.f64 fd1025, fd867, fd927;
sub.f64 fd1027, fd887, fd907;
mul.f64 fd1182, fd1025, 0d3FEE6F0E134454FF;
fma.rn.f64 fd1028, fd1027, 0d3FE2CF2304755A5E, fd1182;
add.f64 fd1181, fd848, fd1187;
mul.f64 fd1029, fd1187, 0d3FE9E3779B97F4A8;
sub.f64 fd1030, fd848, fd1029;
fma.rn.f64 fd1031, fd1186, 0d3FD3C6EF372FE950, fd1030;
mul.f64 fd1032, fd1025, 0d3FE2CF2304755A5E;
mul.f64 fd1033, fd1027, 0d3FEE6F0E134454FF;
sub.f64 fd1034, fd1032, fd1033;
add.f64 fd1035, fd871, fd931;
add.f64 fd1037, fd891, fd911;
mul.f64 fd1042, fd1037, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1180, fd1035, 0d3FD3C6EF372FE950, fd851;
sub.f64 fd1043, fd1180, fd1042;
add.f64 fd1179, fd872, fd932;
sub.f64 fd1044, fd872, fd932;
add.f64 fd1178, fd892, fd912;
sub.f64 fd1046, fd892, fd912;
mul.f64 fd1177, fd1044, 0d3FEE6F0E134454FF;
fma.rn.f64 fd1047, fd1046, 0d3FE2CF2304755A5E, fd1177;
add.f64 fd1176, fd851, fd1035;
mul.f64 fd1048, fd1035, 0d3FE9E3779B97F4A8;
sub.f64 fd1049, fd851, fd1048;
fma.rn.f64 fd1050, fd1037, 0d3FD3C6EF372FE950, fd1049;
mul.f64 fd1051, fd1044, 0d3FE2CF2304755A5E;
mul.f64 fd1052, fd1046, 0d3FEE6F0E134454FF;
sub.f64 fd1053, fd1051, fd1052;
fma.rn.f64 fd1174, fd1179, 0d3FD3C6EF372FE950, fd852;
mul.f64 fd1175, fd1178, 0d3FE9E3779B97F4A8;
sub.f64 fd1056, fd1174, fd1175;
sub.f64 fd1057, fd871, fd931;
sub.f64 fd1059, fd891, fd911;
mul.f64 fd1173, fd1057, 0d3FEE6F0E134454FF;
fma.rn.f64 fd1060, fd1059, 0d3FE2CF2304755A5E, fd1173;
add.f64 fd1172, fd852, fd1179;
mul.f64 fd1061, fd1179, 0d3FE9E3779B97F4A8;
sub.f64 fd1062, fd852, fd1061;
fma.rn.f64 fd1063, fd1178, 0d3FD3C6EF372FE950, fd1062;
mul.f64 fd1064, fd1057, 0d3FE2CF2304755A5E;
mul.f64 fd1065, fd1059, 0d3FEE6F0E134454FF;
sub.f64 fd1066, fd1064, fd1065;
add.f64 fd1067, fd875, fd935;
add.f64 fd1069, fd895, fd915;
fma.rn.f64 fd1170, fd1067, 0d3FD3C6EF372FE950, fd855;
mul.f64 fd1171, fd1069, 0d3FE9E3779B97F4A8;
sub.f64 fd1075, fd1170, fd1171;
add.f64 fd1169, fd876, fd936;
sub.f64 fd1076, fd876, fd936;
add.f64 fd1168, fd896, fd916;
sub.f64 fd1078, fd896, fd916;
mul.f64 fd1167, fd1076, 0d3FEE6F0E134454FF;
fma.rn.f64 fd1079, fd1078, 0d3FE2CF2304755A5E, fd1167;
add.f64 fd1166, fd855, fd1067;
mul.f64 fd1080, fd1067, 0d3FE9E3779B97F4A8;
sub.f64 fd1081, fd855, fd1080;
fma.rn.f64 fd1082, fd1069, 0d3FD3C6EF372FE950, fd1081;
mul.f64 fd1083, fd1076, 0d3FE2CF2304755A5E;
mul.f64 fd1084, fd1078, 0d3FEE6F0E134454FF;
sub.f64 fd1085, fd1083, fd1084;
mul.f64 fd1087, fd1168, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd1165, fd1169, 0d3FD3C6EF372FE950, fd856;
sub.f64 fd1088, fd1165, fd1087;
sub.f64 fd1089, fd875, fd935;
sub.f64 fd1091, fd895, fd915;
mul.f64 fd1164, fd1089, 0d3FEE6F0E134454FF;
fma.rn.f64 fd1092, fd1091, 0d3FE2CF2304755A5E, fd1164;
add.f64 fd1163, fd856, fd1169;
mul.f64 fd1093, fd1169, 0d3FE9E3779B97F4A8;
sub.f64 fd1094, fd856, fd1093;
fma.rn.f64 fd1095, fd1168, 0d3FD3C6EF372FE950, fd1094;
mul.f64 fd1096, fd1089, 0d3FE2CF2304755A5E;
mul.f64 fd1097, fd1091, 0d3FEE6F0E134454FF;
sub.f64 fd1098, fd1096, fd1097;
add.f64 %1, fd1204, fd1199;
add.f64 %0, fd941, fd1202;
add.f64 %3, fd1196, fd1190;
add.f64 %2, fd973, fd1194;
add.f64 %5, fd1186, fd1181;
add.f64 %4, fd1005, fd1184;
add.f64 %7, fd1178, fd1172;
add.f64 %6, fd1037, fd1176;
add.f64 %9, fd1168, fd1163;
add.f64 %8, fd1069, fd1166;
sub.f64 %10, fd947, fd951;
add.f64 %11, fd964, fd960;
sub.f64 %12, fd979, fd983;
add.f64 %13, fd996, fd992;
add.f64 %15, fd1028, fd1024;
sub.f64 %14, fd1011, fd1015;
add.f64 %17, fd1060, fd1056;
sub.f64 %16, fd1043, fd1047;
sub.f64 %18, fd1075, fd1079;
add.f64 %19, fd1092, fd1088;
sub.f64 %20, fd954, fd957;
add.f64 %21, fd970, fd967;
sub.f64 %22, fd986, fd989;
add.f64 %23, fd1002, fd999;
sub.f64 %24, fd1018, fd1021;
add.f64 %25, fd1034, fd1031;
add.f64 %27, fd1066, fd1063;
sub.f64 %26, fd1050, fd1053;
add.f64 %29, fd1098, fd1095;
sub.f64 %28, fd1082, fd1085;
sub.f64 %31, fd967, fd970;
add.f64 %30, fd957, fd954;
sub.f64 %33, fd999, fd1002;
add.f64 %32, fd989, fd986;
sub.f64 %35, fd1031, fd1034;
add.f64 %34, fd1021, fd1018;
sub.f64 %37, fd1063, fd1066;
add.f64 %36, fd1053, fd1050;
sub.f64 %39, fd1095, fd1098;
add.f64 %38, fd1085, fd1082;
sub.f64 %41, fd960, fd964;
add.f64 %40, fd951, fd947;
sub.f64 %43, fd992, fd996;
add.f64 %42, fd983, fd979;
sub.f64 %45, fd1024, fd1028;
add.f64 %44, fd1015, fd1011;
sub.f64 %47, fd1056, fd1060;
add.f64 %46, fd1047, fd1043;
sub.f64 %49, fd1088, fd1092;
add.f64 %48, fd1079, fd1075;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y), "=d"(rmem[16].x), "=d"(rmem[16].y), "=d"(rmem[17].x), "=d"(rmem[17].y), "=d"(rmem[18].x), "=d"(rmem[18].y), "=d"(rmem[19].x), "=d"(rmem[19].y), "=d"(rmem[20].x), "=d"(rmem[20].y), "=d"(rmem[21].x), "=d"(rmem[21].y), "=d"(rmem[22].x), "=d"(rmem[22].y), "=d"(rmem[23].x), "=d"(rmem[23].y), "=d"(rmem[24].x), "=d"(rmem[24].y): "r"(smem), "l"(lut_dp_25_125), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[16].x), "d"(rmem[16].y), "d"(rmem[17].x), "d"(rmem[17].y), "d"(rmem[18].x), "d"(rmem[18].y), "d"(rmem[19].x), "d"(rmem[19].y), "d"(rmem[20].x), "d"(rmem[20].y), "d"(rmem[21].x), "d"(rmem[21].y), "d"(rmem[22].x), "d"(rmem[22].y), "d"(rmem[23].x), "d"(rmem[23].y), "d"(rmem[24].x), "d"(rmem[24].y), "d"(rmem[5].y), "d"(rmem[10].y), "d"(rmem[20].y), "d"(rmem[16].y), "d"(rmem[1].y), "d"(rmem[11].y), "d"(rmem[2].y), "d"(rmem[22].y), "d"(rmem[7].y), "d"(rmem[17].y), "d"(rmem[23].y), "d"(rmem[8].y), "d"(rmem[13].y), "d"(rmem[4].y), "d"(rmem[14].y), "d"(rmem[19].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<708, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<18>;
.reg .f64 fd<243>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 1000, r2;
mov.u32 r4, %tid.x;
add.f64 fd21, %15, %23;
add.f64 fd22, %13, fd21;
add.f64 fd23, %18, %21;
add.f64 fd24, fd23, fd22;
add.f64 fd25, %17, %24;
add.f64 fd26, %14, fd25;
add.f64 fd27, %20, %22;
add.f64 fd28, fd27, fd26;
fma.rn.f64 fd29, fd21, 0d3FD3C6EF372FE950, %13;
mul.f64 fd30, fd23, 0d3FE9E3779B97F4A8;
sub.f64 fd31, fd29, fd30;
sub.f64 fd32, %17, %24;
mul.f64 fd33, fd32, 0d3FEE6F0E134454FF;
sub.f64 fd34, %20, %22;
fma.rn.f64 fd35, fd34, 0d3FE2CF2304755A5E, fd33;
sub.f64 fd36, fd31, fd35;
add.f64 fd37, fd35, fd31;
mul.f64 fd38, fd21, 0d3FE9E3779B97F4A8;
sub.f64 fd39, %13, fd38;
fma.rn.f64 fd40, fd23, 0d3FD3C6EF372FE950, fd39;
mul.f64 fd41, fd32, 0d3FE2CF2304755A5E;
mul.f64 fd42, fd34, 0d3FEE6F0E134454FF;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, fd40, fd43;
add.f64 fd45, fd43, fd40;
fma.rn.f64 fd46, fd25, 0d3FD3C6EF372FE950, %14;
mul.f64 fd47, fd27, 0d3FE9E3779B97F4A8;
sub.f64 fd48, fd46, fd47;
sub.f64 fd49, %15, %23;
mul.f64 fd50, fd49, 0d3FEE6F0E134454FF;
sub.f64 fd51, %18, %21;
fma.rn.f64 fd52, fd51, 0d3FE2CF2304755A5E, fd50;
add.f64 fd53, fd52, fd48;
sub.f64 fd54, fd48, fd52;
mul.f64 fd55, fd25, 0d3FE9E3779B97F4A8;
sub.f64 fd56, %14, fd55;
fma.rn.f64 fd57, fd27, 0d3FD3C6EF372FE950, fd56;
mul.f64 fd58, fd49, 0d3FE2CF2304755A5E;
mul.f64 fd59, fd51, 0d3FEE6F0E134454FF;
sub.f64 fd60, fd58, fd59;
add.f64 fd61, fd60, fd57;
sub.f64 fd62, fd57, fd60;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 25;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd63, fd64}, [rd6];
mul.f64 fd67, fd53, fd64;
fma.rn.f64 fd68, fd63, fd36, fd67;
mul.f64 fd69, fd36, fd64;
mul.f64 fd70, fd63, fd53;
sub.f64 fd71, fd70, fd69;
mul.f64 fd72, fd63, fd63;
mul.f64 fd73, fd64, fd64;
sub.f64 fd74, fd72, fd73;
mul.f64 fd75, fd64, fd63;
fma.rn.f64 fd76, fd64, fd63, fd75;
mul.f64 fd77, fd61, fd76;
fma.rn.f64 fd78, fd74, fd44, fd77;
mul.f64 fd79, fd44, fd76;
mul.f64 fd80, fd74, fd61;
sub.f64 fd81, fd80, fd79;
ld.global.v2.f64 {fd82, fd83}, [rd6+400];
mul.f64 fd86, fd62, fd83;
fma.rn.f64 fd87, fd82, fd45, fd86;
mul.f64 fd88, fd45, fd83;
mul.f64 fd89, fd82, fd62;
sub.f64 fd90, fd89, fd88;
mul.f64 fd91, fd63, fd82;
mul.f64 fd92, fd64, fd83;
sub.f64 fd93, fd91, fd92;
mul.f64 fd94, fd63, fd83;
fma.rn.f64 fd95, fd64, fd82, fd94;
mul.f64 fd96, fd54, fd95;
fma.rn.f64 fd97, fd93, fd37, fd96;
mul.f64 fd98, fd37, fd95;
mul.f64 fd99, fd93, fd54;
sub.f64 fd100, fd99, fd98;
mad.lo.s32 r8, r5, 1000, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
st.shared.f64 [r9], fd24;
st.shared.f64 [r9+8], fd68;
st.shared.f64 [r9+16], fd78;
st.shared.f64 [r9+24], fd87;
st.shared.f64 [r9+32], fd97;
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.f64 fd101, [r11];
ld.shared.f64 fd102, [r11+200];
ld.shared.f64 fd103, [r11+400];
ld.shared.f64 fd104, [r11+600];
ld.shared.f64 fd105, [r11+800];
barrier.sync 0;
st.shared.f64 [r9], fd28;
st.shared.f64 [r9+8], fd71;
st.shared.f64 [r9+16], fd81;
st.shared.f64 [r9+24], fd90;
st.shared.f64 [r9+32], fd100;
barrier.sync 0;
ld.shared.f64 fd106, [r11];
ld.shared.f64 fd107, [r11+200];
ld.shared.f64 fd108, [r11+400];
ld.shared.f64 fd109, [r11+600];
ld.shared.f64 fd110, [r11+800];
add.f64 fd111, fd102, fd105;
add.f64 fd112, fd101, fd111;
add.f64 fd113, fd103, fd104;
add.f64 fd114, fd113, fd112;
add.f64 fd115, fd107, fd110;
add.f64 fd116, fd106, fd115;
add.f64 fd117, fd108, fd109;
add.f64 fd118, fd117, fd116;
fma.rn.f64 fd119, fd111, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd120, fd113, 0d3FE9E3779B97F4A8;
sub.f64 fd121, fd119, fd120;
sub.f64 fd122, fd107, fd110;
mul.f64 fd123, fd122, 0d3FEE6F0E134454FF;
sub.f64 fd124, fd108, fd109;
fma.rn.f64 fd125, fd124, 0d3FE2CF2304755A5E, fd123;
sub.f64 fd126, fd121, fd125;
add.f64 fd127, fd125, fd121;
mul.f64 fd128, fd111, 0d3FE9E3779B97F4A8;
sub.f64 fd129, fd101, fd128;
fma.rn.f64 fd130, fd113, 0d3FD3C6EF372FE950, fd129;
mul.f64 fd131, fd122, 0d3FE2CF2304755A5E;
mul.f64 fd132, fd124, 0d3FEE6F0E134454FF;
sub.f64 fd133, fd131, fd132;
sub.f64 fd134, fd130, fd133;
add.f64 fd135, fd133, fd130;
fma.rn.f64 fd136, fd115, 0d3FD3C6EF372FE950, fd106;
mul.f64 fd137, fd117, 0d3FE9E3779B97F4A8;
sub.f64 fd138, fd136, fd137;
sub.f64 fd139, fd102, fd105;
mul.f64 fd140, fd139, 0d3FEE6F0E134454FF;
sub.f64 fd141, fd103, fd104;
fma.rn.f64 fd142, fd141, 0d3FE2CF2304755A5E, fd140;
add.f64 fd143, fd142, fd138;
sub.f64 fd144, fd138, fd142;
mul.f64 fd145, fd115, 0d3FE9E3779B97F4A8;
sub.f64 fd146, fd106, fd145;
fma.rn.f64 fd147, fd117, 0d3FD3C6EF372FE950, fd146;
mul.f64 fd148, fd139, 0d3FE2CF2304755A5E;
mul.f64 fd149, fd141, 0d3FEE6F0E134454FF;
sub.f64 fd150, fd148, fd149;
add.f64 fd151, fd150, fd147;
sub.f64 fd152, fd147, fd150;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd153, fd154}, [rd11];
mul.f64 fd157, fd143, fd154;
fma.rn.f64 fd158, fd153, fd126, fd157;
mul.f64 fd159, fd126, fd154;
mul.f64 fd160, fd153, fd143;
sub.f64 fd161, fd160, fd159;
mul.f64 fd162, fd153, fd153;
mul.f64 fd163, fd154, fd154;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, fd153;
fma.rn.f64 fd166, fd154, fd153, fd165;
mul.f64 fd167, fd151, fd166;
fma.rn.f64 fd168, fd164, fd134, fd167;
mul.f64 fd169, fd134, fd166;
mul.f64 fd170, fd164, fd151;
sub.f64 fd171, fd170, fd169;
ld.global.v2.f64 {fd172, fd173}, [rd11+80];
mul.f64 fd176, fd152, fd173;
fma.rn.f64 fd177, fd172, fd135, fd176;
mul.f64 fd178, fd135, fd173;
mul.f64 fd179, fd172, fd152;
sub.f64 fd180, fd179, fd178;
mul.f64 fd181, fd153, fd172;
mul.f64 fd182, fd154, fd173;
sub.f64 fd183, fd181, fd182;
mul.f64 fd184, fd153, fd173;
fma.rn.f64 fd185, fd154, fd172, fd184;
mul.f64 fd186, fd144, fd185;
fma.rn.f64 fd187, fd183, fd127, fd186;
mul.f64 fd188, fd127, fd185;
mul.f64 fd189, fd183, fd144;
sub.f64 fd190, fd189, fd188;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 200, r16;
st.shared.f64 [r17], fd114;
st.shared.f64 [r17+40], fd158;
st.shared.f64 [r17+80], fd168;
st.shared.f64 [r17+120], fd177;
st.shared.f64 [r17+160], fd187;
barrier.sync 0;
ld.shared.f64 fd191, [r11];
ld.shared.f64 fd192, [r11+200];
ld.shared.f64 fd193, [r11+400];
ld.shared.f64 fd194, [r11+600];
ld.shared.f64 fd195, [r11+800];
barrier.sync 0;
st.shared.f64 [r17], fd118;
st.shared.f64 [r17+40], fd161;
st.shared.f64 [r17+80], fd171;
st.shared.f64 [r17+120], fd180;
st.shared.f64 [r17+160], fd190;
barrier.sync 0;
ld.shared.f64 fd196, [r11];
ld.shared.f64 fd197, [r11+200];
ld.shared.f64 fd198, [r11+400];
ld.shared.f64 fd199, [r11+600];
ld.shared.f64 fd200, [r11+800];
add.f64 fd201, fd192, fd195;
add.f64 fd202, fd191, fd201;
add.f64 fd203, fd193, fd194;
add.f64 fd204, fd197, fd200;
add.f64 fd205, fd196, fd204;
add.f64 fd206, fd198, fd199;
fma.rn.f64 fd207, fd201, 0d3FD3C6EF372FE950, fd191;
mul.f64 fd208, fd203, 0d3FE9E3779B97F4A8;
sub.f64 fd209, fd207, fd208;
sub.f64 fd210, fd197, fd200;
mul.f64 fd211, fd210, 0d3FEE6F0E134454FF;
sub.f64 fd212, fd198, fd199;
fma.rn.f64 fd213, fd212, 0d3FE2CF2304755A5E, fd211;
mul.f64 fd214, fd201, 0d3FE9E3779B97F4A8;
sub.f64 fd215, fd191, fd214;
fma.rn.f64 fd216, fd203, 0d3FD3C6EF372FE950, fd215;
mul.f64 fd217, fd210, 0d3FE2CF2304755A5E;
mul.f64 fd218, fd212, 0d3FEE6F0E134454FF;
sub.f64 fd219, fd217, fd218;
fma.rn.f64 fd220, fd204, 0d3FD3C6EF372FE950, fd196;
mul.f64 fd221, fd206, 0d3FE9E3779B97F4A8;
sub.f64 fd222, fd220, fd221;
sub.f64 fd223, fd192, fd195;
mul.f64 fd224, fd223, 0d3FEE6F0E134454FF;
sub.f64 fd225, fd193, fd194;
fma.rn.f64 fd226, fd225, 0d3FE2CF2304755A5E, fd224;
mul.f64 fd227, fd204, 0d3FE9E3779B97F4A8;
sub.f64 fd228, fd196, fd227;
fma.rn.f64 fd229, fd206, 0d3FD3C6EF372FE950, fd228;
mul.f64 fd230, fd223, 0d3FE2CF2304755A5E;
mul.f64 fd231, fd225, 0d3FEE6F0E134454FF;
sub.f64 fd232, fd230, fd231;
add.f64 %0, fd203, fd202;
add.f64 %1, fd206, fd205;
add.f64 %3, fd226, fd222;
sub.f64 %2, fd209, fd213;
sub.f64 %4, fd216, fd219;
add.f64 %5, fd232, fd229;
add.f64 %6, fd219, fd216;
sub.f64 %7, fd229, fd232;
sub.f64 %9, fd222, fd226;
add.f64 %8, fd213, fd209;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y): "r"(smem), "l"(lut_dp_5_125), "l"(lut_dp_5_25), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<707, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<18>;
.reg .f64 fd<263>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 2000, r2;
mov.u32 r4, %tid.x;
add.f64 fd21, %15, %23;
add.f64 fd22, %13, fd21;
add.f64 fd23, %18, %21;
add.f64 fd24, %17, %24;
add.f64 fd25, %14, fd24;
add.f64 fd26, %20, %22;
fma.rn.f64 fd27, fd21, 0d3FD3C6EF372FE950, %13;
mul.f64 fd28, fd23, 0d3FE9E3779B97F4A8;
sub.f64 fd29, fd27, fd28;
sub.f64 fd30, %17, %24;
mul.f64 fd31, fd30, 0d3FEE6F0E134454FF;
sub.f64 fd32, %20, %22;
fma.rn.f64 fd33, fd32, 0d3FE2CF2304755A5E, fd31;
sub.f64 fd34, fd29, fd33;
add.f64 fd35, fd33, fd29;
mul.f64 fd36, fd21, 0d3FE9E3779B97F4A8;
sub.f64 fd37, %13, fd36;
fma.rn.f64 fd38, fd23, 0d3FD3C6EF372FE950, fd37;
mul.f64 fd39, fd30, 0d3FE2CF2304755A5E;
mul.f64 fd40, fd32, 0d3FEE6F0E134454FF;
sub.f64 fd41, fd39, fd40;
sub.f64 fd42, fd38, fd41;
add.f64 fd43, fd41, fd38;
fma.rn.f64 fd44, fd24, 0d3FD3C6EF372FE950, %14;
mul.f64 fd45, fd26, 0d3FE9E3779B97F4A8;
sub.f64 fd46, fd44, fd45;
sub.f64 fd47, %15, %23;
mul.f64 fd48, fd47, 0d3FEE6F0E134454FF;
sub.f64 fd49, %18, %21;
fma.rn.f64 fd50, fd49, 0d3FE2CF2304755A5E, fd48;
add.f64 fd51, fd50, fd46;
sub.f64 fd52, fd46, fd50;
mul.f64 fd53, fd24, 0d3FE9E3779B97F4A8;
sub.f64 fd54, %14, fd53;
fma.rn.f64 fd55, fd26, 0d3FD3C6EF372FE950, fd54;
mul.f64 fd56, fd47, 0d3FE2CF2304755A5E;
mul.f64 fd57, fd49, 0d3FEE6F0E134454FF;
sub.f64 fd58, fd56, fd57;
add.f64 fd59, fd58, fd55;
sub.f64 fd60, fd55, fd58;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 25;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 2000, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd61, fd62}, [rd6];
mul.f64 fd65, fd51, fd62;
mul.f64 fd66, fd34, fd62;
mul.f64 fd67, fd61, fd51;
mul.f64 fd68, fd61, fd61;
mul.f64 fd69, fd62, fd62;
sub.f64 fd70, fd68, fd69;
mul.f64 fd71, fd62, fd61;
fma.rn.f64 fd72, fd62, fd61, fd71;
mul.f64 fd73, fd59, fd72;
mul.f64 fd74, fd42, fd72;
mul.f64 fd75, fd70, fd59;
ld.global.v2.f64 {fd76, fd77}, [rd6+400];
mul.f64 fd80, fd60, fd77;
mul.f64 fd81, fd43, fd77;
mul.f64 fd82, fd76, fd60;
mul.f64 fd83, fd61, fd76;
mul.f64 fd84, fd62, fd77;
sub.f64 fd85, fd83, fd84;
mul.f64 fd86, fd61, fd77;
fma.rn.f64 fd87, fd62, fd76, fd86;
mul.f64 fd88, fd52, fd87;
mul.f64 fd89, fd35, fd87;
mul.f64 fd90, fd85, fd52;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
add.f64 fd91, fd26, fd25;
add.f64 fd92, fd23, fd22;
st.shared.v2.f64 [r9], {fd92, fd91};
fma.rn.f64 fd93, fd61, fd34, fd65;
sub.f64 fd94, fd67, fd66;
st.shared.v2.f64 [r9+16], {fd93, fd94};
fma.rn.f64 fd95, fd70, fd42, fd73;
sub.f64 fd96, fd75, fd74;
st.shared.v2.f64 [r9+32], {fd95, fd96};
fma.rn.f64 fd97, fd76, fd43, fd80;
sub.f64 fd98, fd82, fd81;
st.shared.v2.f64 [r9+48], {fd97, fd98};
fma.rn.f64 fd99, fd85, fd35, fd88;
sub.f64 fd100, fd90, fd89;
st.shared.v2.f64 [r9+64], {fd99, fd100};
barrier.sync 0;
shl.b32 r10, r7, 6;
sub.s32 r11, r9, r10;
ld.shared.v2.f64 {fd101, fd102}, [r11];
ld.shared.v2.f64 {fd105, fd106}, [r11+400];
ld.shared.v2.f64 {fd109, fd110}, [r11+800];
ld.shared.v2.f64 {fd113, fd114}, [r11+1200];
ld.shared.v2.f64 {fd117, fd118}, [r11+1600];
add.f64 fd121, fd105, fd117;
add.f64 fd122, fd101, fd121;
add.f64 fd123, fd109, fd113;
add.f64 fd124, fd106, fd118;
add.f64 fd125, fd102, fd124;
add.f64 fd126, fd110, fd114;
fma.rn.f64 fd127, fd121, 0d3FD3C6EF372FE950, fd101;
mul.f64 fd128, fd123, 0d3FE9E3779B97F4A8;
sub.f64 fd129, fd127, fd128;
sub.f64 fd130, fd106, fd118;
mul.f64 fd131, fd130, 0d3FEE6F0E134454FF;
sub.f64 fd132, fd110, fd114;
fma.rn.f64 fd133, fd132, 0d3FE2CF2304755A5E, fd131;
sub.f64 fd134, fd129, fd133;
add.f64 fd135, fd133, fd129;
mul.f64 fd136, fd121, 0d3FE9E3779B97F4A8;
sub.f64 fd137, fd101, fd136;
fma.rn.f64 fd138, fd123, 0d3FD3C6EF372FE950, fd137;
mul.f64 fd139, fd130, 0d3FE2CF2304755A5E;
mul.f64 fd140, fd132, 0d3FEE6F0E134454FF;
sub.f64 fd141, fd139, fd140;
sub.f64 fd142, fd138, fd141;
add.f64 fd143, fd141, fd138;
fma.rn.f64 fd144, fd124, 0d3FD3C6EF372FE950, fd102;
mul.f64 fd145, fd126, 0d3FE9E3779B97F4A8;
sub.f64 fd146, fd144, fd145;
sub.f64 fd147, fd105, fd117;
mul.f64 fd148, fd147, 0d3FEE6F0E134454FF;
sub.f64 fd149, fd109, fd113;
fma.rn.f64 fd150, fd149, 0d3FE2CF2304755A5E, fd148;
add.f64 fd151, fd150, fd146;
sub.f64 fd152, fd146, fd150;
mul.f64 fd153, fd124, 0d3FE9E3779B97F4A8;
sub.f64 fd154, fd102, fd153;
fma.rn.f64 fd155, fd126, 0d3FD3C6EF372FE950, fd154;
mul.f64 fd156, fd147, 0d3FE2CF2304755A5E;
mul.f64 fd157, fd149, 0d3FEE6F0E134454FF;
sub.f64 fd158, fd156, fd157;
add.f64 fd159, fd158, fd155;
sub.f64 fd160, fd155, fd158;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd161, fd162}, [rd11];
mul.f64 fd165, fd151, fd162;
mul.f64 fd166, fd134, fd162;
mul.f64 fd167, fd161, fd151;
mul.f64 fd168, fd161, fd161;
mul.f64 fd169, fd162, fd162;
sub.f64 fd170, fd168, fd169;
mul.f64 fd171, fd162, fd161;
fma.rn.f64 fd172, fd162, fd161, fd171;
mul.f64 fd173, fd159, fd172;
mul.f64 fd174, fd142, fd172;
mul.f64 fd175, fd170, fd159;
ld.global.v2.f64 {fd176, fd177}, [rd11+80];
mul.f64 fd180, fd160, fd177;
mul.f64 fd181, fd143, fd177;
mul.f64 fd182, fd176, fd160;
mul.f64 fd183, fd161, fd176;
mul.f64 fd184, fd162, fd177;
sub.f64 fd185, fd183, fd184;
mul.f64 fd186, fd161, fd177;
fma.rn.f64 fd187, fd162, fd176, fd186;
mul.f64 fd188, fd152, fd187;
mul.f64 fd189, fd135, fd187;
mul.f64 fd190, fd185, fd152;
shl.b32 r15, r14, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 400, r16;
add.f64 fd191, fd126, fd125;
add.f64 fd192, fd123, fd122;
st.shared.v2.f64 [r17], {fd192, fd191};
fma.rn.f64 fd193, fd161, fd134, fd165;
sub.f64 fd194, fd167, fd166;
st.shared.v2.f64 [r17+80], {fd193, fd194};
fma.rn.f64 fd195, fd170, fd142, fd173;
sub.f64 fd196, fd175, fd174;
st.shared.v2.f64 [r17+160], {fd195, fd196};
fma.rn.f64 fd197, fd176, fd143, fd180;
sub.f64 fd198, fd182, fd181;
st.shared.v2.f64 [r17+240], {fd197, fd198};
fma.rn.f64 fd199, fd185, fd135, fd188;
sub.f64 fd200, fd190, fd189;
st.shared.v2.f64 [r17+320], {fd199, fd200};
barrier.sync 0;
ld.shared.v2.f64 {fd201, fd202}, [r11];
ld.shared.v2.f64 {fd205, fd206}, [r11+400];
ld.shared.v2.f64 {fd209, fd210}, [r11+800];
ld.shared.v2.f64 {fd213, fd214}, [r11+1200];
ld.shared.v2.f64 {fd217, fd218}, [r11+1600];
add.f64 fd221, fd205, fd217;
add.f64 fd222, fd201, fd221;
add.f64 fd223, fd209, fd213;
add.f64 fd224, fd206, fd218;
add.f64 fd225, fd202, fd224;
add.f64 fd226, fd210, fd214;
fma.rn.f64 fd227, fd221, 0d3FD3C6EF372FE950, fd201;
mul.f64 fd228, fd223, 0d3FE9E3779B97F4A8;
sub.f64 fd229, fd227, fd228;
sub.f64 fd230, fd206, fd218;
mul.f64 fd231, fd230, 0d3FEE6F0E134454FF;
sub.f64 fd232, fd210, fd214;
fma.rn.f64 fd233, fd232, 0d3FE2CF2304755A5E, fd231;
mul.f64 fd234, fd221, 0d3FE9E3779B97F4A8;
sub.f64 fd235, fd201, fd234;
fma.rn.f64 fd236, fd223, 0d3FD3C6EF372FE950, fd235;
mul.f64 fd237, fd230, 0d3FE2CF2304755A5E;
mul.f64 fd238, fd232, 0d3FEE6F0E134454FF;
sub.f64 fd239, fd237, fd238;
fma.rn.f64 fd240, fd224, 0d3FD3C6EF372FE950, fd202;
mul.f64 fd241, fd226, 0d3FE9E3779B97F4A8;
sub.f64 fd242, fd240, fd241;
sub.f64 fd243, fd205, fd217;
mul.f64 fd244, fd243, 0d3FEE6F0E134454FF;
sub.f64 fd245, fd209, fd213;
fma.rn.f64 fd246, fd245, 0d3FE2CF2304755A5E, fd244;
mul.f64 fd247, fd224, 0d3FE9E3779B97F4A8;
sub.f64 fd248, fd202, fd247;
fma.rn.f64 fd249, fd226, 0d3FD3C6EF372FE950, fd248;
mul.f64 fd250, fd243, 0d3FE2CF2304755A5E;
mul.f64 fd251, fd245, 0d3FEE6F0E134454FF;
sub.f64 fd252, fd250, fd251;
add.f64 %1, fd226, fd225;
add.f64 %0, fd223, fd222;
add.f64 %3, fd246, fd242;
sub.f64 %2, fd229, fd233;
add.f64 %5, fd252, fd249;
sub.f64 %4, fd236, fd239;
sub.f64 %7, fd249, fd252;
add.f64 %6, fd239, fd236;
sub.f64 %9, fd242, fd246;
add.f64 %8, fd233, fd229;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y): "r"(smem), "l"(lut_dp_5_125), "l"(lut_dp_5_25), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<709, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<1099>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %50;
mad.lo.s32 r3, r1, 1000, r2;
add.f64 fd101, %65, %105;
add.f64 fd102, %52, fd101;
add.f64 fd103, %78, %92;
add.f64 fd104, fd103, fd102;
add.f64 fd105, %67, %107;
add.f64 fd106, %53, fd105;
add.f64 fd107, %80, %93;
add.f64 fd108, fd107, fd106;
fma.rn.f64 fd109, fd101, 0d3FD3C6EF372FE950, %52;
mul.f64 fd110, fd103, 0d3FE9E3779B97F4A8;
sub.f64 fd111, fd109, fd110;
sub.f64 fd112, %67, %107;
mul.f64 fd113, fd112, 0d3FEE6F0E134454FF;
sub.f64 fd114, %80, %93;
fma.rn.f64 fd115, fd114, 0d3FE2CF2304755A5E, fd113;
sub.f64 fd116, fd111, fd115;
add.f64 fd117, fd115, fd111;
mul.f64 fd118, fd101, 0d3FE9E3779B97F4A8;
sub.f64 fd119, %52, fd118;
fma.rn.f64 fd120, fd103, 0d3FD3C6EF372FE950, fd119;
mul.f64 fd121, fd112, 0d3FE2CF2304755A5E;
mul.f64 fd122, fd114, 0d3FEE6F0E134454FF;
sub.f64 fd123, fd121, fd122;
sub.f64 fd124, fd120, fd123;
add.f64 fd125, fd123, fd120;
fma.rn.f64 fd126, fd105, 0d3FD3C6EF372FE950, %53;
mul.f64 fd127, fd107, 0d3FE9E3779B97F4A8;
sub.f64 fd128, fd126, fd127;
sub.f64 fd129, %65, %105;
mul.f64 fd130, fd129, 0d3FEE6F0E134454FF;
sub.f64 fd131, %78, %92;
fma.rn.f64 fd132, fd131, 0d3FE2CF2304755A5E, fd130;
add.f64 fd133, fd132, fd128;
sub.f64 fd134, fd128, fd132;
mul.f64 fd135, fd105, 0d3FE9E3779B97F4A8;
sub.f64 fd136, %53, fd135;
fma.rn.f64 fd137, fd107, 0d3FD3C6EF372FE950, fd136;
mul.f64 fd138, fd129, 0d3FE2CF2304755A5E;
mul.f64 fd139, fd131, 0d3FEE6F0E134454FF;
sub.f64 fd140, fd138, fd139;
add.f64 fd141, fd140, fd137;
sub.f64 fd142, fd137, fd140;
add.f64 fd143, %68, %108;
add.f64 fd144, %54, fd143;
add.f64 fd145, %81, %94;
add.f64 fd146, fd145, fd144;
add.f64 fd147, %69, %109;
add.f64 fd148, %56, fd147;
add.f64 fd149, %83, %96;
add.f64 fd150, fd149, fd148;
fma.rn.f64 fd151, fd143, 0d3FD3C6EF372FE950, %54;
mul.f64 fd152, fd145, 0d3FE9E3779B97F4A8;
sub.f64 fd153, fd151, fd152;
sub.f64 fd154, %69, %109;
mul.f64 fd155, fd154, 0d3FEE6F0E134454FF;
sub.f64 fd156, %83, %96;
fma.rn.f64 fd157, fd156, 0d3FE2CF2304755A5E, fd155;
sub.f64 fd158, fd153, fd157;
add.f64 fd159, fd157, fd153;
mul.f64 fd160, fd143, 0d3FE9E3779B97F4A8;
sub.f64 fd161, %54, fd160;
fma.rn.f64 fd162, fd145, 0d3FD3C6EF372FE950, fd161;
mul.f64 fd163, fd154, 0d3FE2CF2304755A5E;
mul.f64 fd164, fd156, 0d3FEE6F0E134454FF;
sub.f64 fd165, fd163, fd164;
sub.f64 fd166, fd162, fd165;
add.f64 fd167, fd165, fd162;
fma.rn.f64 fd168, fd147, 0d3FD3C6EF372FE950, %56;
mul.f64 fd169, fd149, 0d3FE9E3779B97F4A8;
sub.f64 fd170, fd168, fd169;
sub.f64 fd171, %68, %108;
mul.f64 fd172, fd171, 0d3FEE6F0E134454FF;
sub.f64 fd173, %81, %94;
fma.rn.f64 fd174, fd173, 0d3FE2CF2304755A5E, fd172;
add.f64 fd175, fd174, fd170;
sub.f64 fd176, fd170, fd174;
mul.f64 fd177, fd147, 0d3FE9E3779B97F4A8;
sub.f64 fd178, %56, fd177;
fma.rn.f64 fd179, fd149, 0d3FD3C6EF372FE950, fd178;
mul.f64 fd180, fd171, 0d3FE2CF2304755A5E;
mul.f64 fd181, fd173, 0d3FEE6F0E134454FF;
sub.f64 fd182, fd180, fd181;
add.f64 fd183, fd182, fd179;
sub.f64 fd184, fd179, fd182;
add.f64 fd185, %70, %110;
add.f64 fd186, %57, fd185;
add.f64 fd187, %84, %97;
add.f64 fd188, fd187, fd186;
add.f64 fd189, %72, %112;
add.f64 fd190, %59, fd189;
add.f64 fd191, %85, %99;
add.f64 fd192, fd191, fd190;
fma.rn.f64 fd193, fd185, 0d3FD3C6EF372FE950, %57;
mul.f64 fd194, fd187, 0d3FE9E3779B97F4A8;
sub.f64 fd195, fd193, fd194;
sub.f64 fd196, %72, %112;
mul.f64 fd197, fd196, 0d3FEE6F0E134454FF;
sub.f64 fd198, %85, %99;
fma.rn.f64 fd199, fd198, 0d3FE2CF2304755A5E, fd197;
sub.f64 fd200, fd195, fd199;
add.f64 fd201, fd199, fd195;
mul.f64 fd202, fd185, 0d3FE9E3779B97F4A8;
sub.f64 fd203, %57, fd202;
fma.rn.f64 fd204, fd187, 0d3FD3C6EF372FE950, fd203;
mul.f64 fd205, fd196, 0d3FE2CF2304755A5E;
mul.f64 fd206, fd198, 0d3FEE6F0E134454FF;
sub.f64 fd207, fd205, fd206;
sub.f64 fd208, fd204, fd207;
add.f64 fd209, fd207, fd204;
fma.rn.f64 fd210, fd189, 0d3FD3C6EF372FE950, %59;
mul.f64 fd211, fd191, 0d3FE9E3779B97F4A8;
sub.f64 fd212, fd210, fd211;
sub.f64 fd213, %70, %110;
mul.f64 fd214, fd213, 0d3FEE6F0E134454FF;
sub.f64 fd215, %84, %97;
fma.rn.f64 fd216, fd215, 0d3FE2CF2304755A5E, fd214;
add.f64 fd217, fd216, fd212;
sub.f64 fd218, fd212, fd216;
mul.f64 fd219, fd189, 0d3FE9E3779B97F4A8;
sub.f64 fd220, %59, fd219;
fma.rn.f64 fd221, fd191, 0d3FD3C6EF372FE950, fd220;
mul.f64 fd222, fd213, 0d3FE2CF2304755A5E;
mul.f64 fd223, fd215, 0d3FEE6F0E134454FF;
sub.f64 fd224, fd222, fd223;
add.f64 fd225, fd224, fd221;
sub.f64 fd226, fd221, fd224;
add.f64 fd227, %73, %113;
add.f64 fd228, %60, fd227;
add.f64 fd229, %86, %100;
add.f64 fd230, fd229, fd228;
add.f64 fd231, %75, %115;
add.f64 fd232, %61, fd231;
add.f64 fd233, %88, %101;
add.f64 fd234, fd233, fd232;
fma.rn.f64 fd235, fd227, 0d3FD3C6EF372FE950, %60;
mul.f64 fd236, fd229, 0d3FE9E3779B97F4A8;
sub.f64 fd237, fd235, fd236;
sub.f64 fd238, %75, %115;
mul.f64 fd239, fd238, 0d3FEE6F0E134454FF;
sub.f64 fd240, %88, %101;
fma.rn.f64 fd241, fd240, 0d3FE2CF2304755A5E, fd239;
sub.f64 fd242, fd237, fd241;
add.f64 fd243, fd241, fd237;
mul.f64 fd244, fd227, 0d3FE9E3779B97F4A8;
sub.f64 fd245, %60, fd244;
fma.rn.f64 fd246, fd229, 0d3FD3C6EF372FE950, fd245;
mul.f64 fd247, fd238, 0d3FE2CF2304755A5E;
mul.f64 fd248, fd240, 0d3FEE6F0E134454FF;
sub.f64 fd249, fd247, fd248;
sub.f64 fd250, fd246, fd249;
add.f64 fd251, fd249, fd246;
fma.rn.f64 fd252, fd231, 0d3FD3C6EF372FE950, %61;
mul.f64 fd253, fd233, 0d3FE9E3779B97F4A8;
sub.f64 fd254, fd252, fd253;
sub.f64 fd255, %73, %113;
mul.f64 fd256, fd255, 0d3FEE6F0E134454FF;
sub.f64 fd257, %86, %100;
fma.rn.f64 fd258, fd257, 0d3FE2CF2304755A5E, fd256;
add.f64 fd259, fd258, fd254;
sub.f64 fd260, fd254, fd258;
mul.f64 fd261, fd231, 0d3FE9E3779B97F4A8;
sub.f64 fd262, %61, fd261;
fma.rn.f64 fd263, fd233, 0d3FD3C6EF372FE950, fd262;
mul.f64 fd264, fd255, 0d3FE2CF2304755A5E;
mul.f64 fd265, fd257, 0d3FEE6F0E134454FF;
sub.f64 fd266, fd264, fd265;
add.f64 fd267, fd266, fd263;
sub.f64 fd268, fd263, fd266;
add.f64 fd269, %76, %116;
add.f64 fd270, %62, fd269;
add.f64 fd271, %89, %102;
add.f64 fd272, fd271, fd270;
add.f64 fd273, %77, %117;
add.f64 fd274, %64, fd273;
add.f64 fd275, %91, %104;
add.f64 fd276, fd275, fd274;
fma.rn.f64 fd277, fd269, 0d3FD3C6EF372FE950, %62;
mul.f64 fd278, fd271, 0d3FE9E3779B97F4A8;
sub.f64 fd279, fd277, fd278;
sub.f64 fd280, %77, %117;
mul.f64 fd281, fd280, 0d3FEE6F0E134454FF;
sub.f64 fd282, %91, %104;
fma.rn.f64 fd283, fd282, 0d3FE2CF2304755A5E, fd281;
sub.f64 fd284, fd279, fd283;
add.f64 fd285, fd283, fd279;
mul.f64 fd286, fd269, 0d3FE9E3779B97F4A8;
sub.f64 fd287, %62, fd286;
fma.rn.f64 fd288, fd271, 0d3FD3C6EF372FE950, fd287;
mul.f64 fd289, fd280, 0d3FE2CF2304755A5E;
mul.f64 fd290, fd282, 0d3FEE6F0E134454FF;
sub.f64 fd291, fd289, fd290;
sub.f64 fd292, fd288, fd291;
add.f64 fd293, fd291, fd288;
fma.rn.f64 fd294, fd273, 0d3FD3C6EF372FE950, %64;
mul.f64 fd295, fd275, 0d3FE9E3779B97F4A8;
sub.f64 fd296, fd294, fd295;
sub.f64 fd297, %76, %116;
mul.f64 fd298, fd297, 0d3FEE6F0E134454FF;
sub.f64 fd299, %89, %102;
fma.rn.f64 fd300, fd299, 0d3FE2CF2304755A5E, fd298;
add.f64 fd301, fd300, fd296;
sub.f64 fd302, fd296, fd300;
mul.f64 fd303, fd273, 0d3FE9E3779B97F4A8;
sub.f64 fd304, %64, fd303;
fma.rn.f64 fd305, fd275, 0d3FD3C6EF372FE950, fd304;
mul.f64 fd306, fd297, 0d3FE2CF2304755A5E;
mul.f64 fd307, fd299, 0d3FEE6F0E134454FF;
sub.f64 fd308, fd306, fd307;
add.f64 fd309, fd308, fd305;
sub.f64 fd310, fd305, fd308;
mov.u32 r4, %tid.x;
mul.f64 fd311, fd158, 0d3FEEFEA21D101EE0;
mul.f64 fd312, fd175, 0d3FCFD511FA1C0796;
sub.f64 fd313, fd311, fd312;
mul.f64 fd314, fd175, 0d3FEEFEA21D101EE0;
fma.rn.f64 fd315, fd158, 0d3FCFD511FA1C0796, fd314;
mul.f64 fd316, fd200, 0d3FEC0AB44E81C059;
mul.f64 fd317, fd217, 0d3FDED50D5CBFA951;
sub.f64 fd318, fd316, fd317;
mul.f64 fd319, fd217, 0d3FEC0AB44E81C059;
fma.rn.f64 fd320, fd200, 0d3FDED50D5CBFA951, fd319;
mul.f64 fd321, fd242, 0d3FE753B603D2B816;
mul.f64 fd322, fd259, 0d3FE5E7CF55112014;
sub.f64 fd323, fd321, fd322;
mul.f64 fd324, fd259, 0d3FE753B603D2B816;
fma.rn.f64 fd325, fd242, 0d3FE5E7CF55112014, fd324;
mul.f64 fd326, fd284, 0d3FE1257E3C182B51;
mul.f64 fd327, fd301, 0d3FEB04BBFF642E86;
sub.f64 fd328, fd326, fd327;
mul.f64 fd329, fd301, 0d3FE1257E3C182B51;
fma.rn.f64 fd330, fd284, 0d3FEB04BBFF642E86, fd329;
mul.f64 fd331, fd166, 0d3FEC0AB44E81C059;
mul.f64 fd332, fd183, 0d3FDED50D5CBFA951;
sub.f64 fd333, fd331, fd332;
mul.f64 fd334, fd183, 0d3FEC0AB44E81C059;
fma.rn.f64 fd335, fd166, 0d3FDED50D5CBFA951, fd334;
mul.f64 fd336, fd208, 0d3FE1257E3C182B51;
mul.f64 fd337, fd225, 0d3FEB04BBFF642E86;
sub.f64 fd338, fd336, fd337;
mul.f64 fd339, fd225, 0d3FE1257E3C182B51;
fma.rn.f64 fd340, fd208, 0d3FEB04BBFF642E86, fd339;
mul.f64 fd341, fd250, 0d3FB0130A1BE09379;
mul.f64 fd342, fd267, 0d3FEFEFD5BFE443FE;
sub.f64 fd343, fd341, fd342;
mul.f64 fd344, fd267, 0d3FB0130A1BE09379;
fma.rn.f64 fd345, fd250, 0d3FEFEFD5BFE443FE, fd344;
mul.f64 fd346, fd292, 0dBFDB3FF7C925819C;
mul.f64 fd347, fd309, 0d3FECF457DCDC158C;
sub.f64 fd348, fd346, fd347;
mul.f64 fd349, fd309, 0dBFDB3FF7C925819C;
fma.rn.f64 fd350, fd292, 0d3FECF457DCDC158C, fd349;
mul.f64 fd351, fd167, 0d3FE753B603D2B816;
mul.f64 fd352, fd184, 0d3FE5E7CF55112014;
sub.f64 fd353, fd351, fd352;
mul.f64 fd354, fd184, 0d3FE753B603D2B816;
fma.rn.f64 fd355, fd167, 0d3FE5E7CF55112014, fd354;
mul.f64 fd356, fd209, 0d3FB0130A1BE09379;
mul.f64 fd357, fd226, 0d3FEFEFD5BFE443FE;
sub.f64 fd358, fd356, fd357;
mul.f64 fd359, fd226, 0d3FB0130A1BE09379;
fma.rn.f64 fd360, fd209, 0d3FEFEFD5BFE443FE, fd359;
mul.f64 fd361, fd251, 0dBFE465C6FEB501BC;
mul.f64 fd362, fd268, 0d3FE8A80B635B6BEA;
sub.f64 fd363, fd361, fd362;
mul.f64 fd364, fd268, 0dBFE465C6FEB501BC;
fma.rn.f64 fd365, fd251, 0d3FE8A80B635B6BEA, fd364;
mul.f64 fd366, fd293, 0dBFEFBF675480D903;
mul.f64 fd367, fd310, 0d3FC00AEB5DA15BE0;
sub.f64 fd368, fd366, fd367;
mul.f64 fd369, fd310, 0dBFEFBF675480D903;
fma.rn.f64 fd370, fd293, 0d3FC00AEB5DA15BE0, fd369;
mul.f64 fd371, fd159, 0d3FE1257E3C182B51;
mul.f64 fd372, fd176, 0d3FEB04BBFF642E86;
sub.f64 fd373, fd371, fd372;
mul.f64 fd374, fd176, 0d3FE1257E3C182B51;
fma.rn.f64 fd375, fd159, 0d3FEB04BBFF642E86, fd374;
mul.f64 fd376, fd201, 0dBFDB3FF7C925819C;
mul.f64 fd377, fd218, 0d3FECF457DCDC158C;
sub.f64 fd378, fd376, fd377;
mul.f64 fd379, fd218, 0dBFDB3FF7C925819C;
fma.rn.f64 fd380, fd201, 0d3FECF457DCDC158C, fd379;
mul.f64 fd381, fd243, 0dBFEFBF675480D903;
mul.f64 fd382, fd260, 0d3FC00AEB5DA15BE0;
sub.f64 fd383, fd381, fd382;
mul.f64 fd384, fd260, 0dBFEFBF675480D903;
fma.rn.f64 fd385, fd243, 0d3FC00AEB5DA15BE0, fd384;
mul.f64 fd386, fd285, 0dBFE465C6FEB501BC;
mul.f64 fd387, fd302, 0dBFE8A80B635B6BEA;
sub.f64 fd388, fd386, fd387;
mul.f64 fd389, fd302, 0dBFE465C6FEB501BC;
fma.rn.f64 fd390, fd285, 0dBFE8A80B635B6BEA, fd389;
add.f64 fd391, fd146, fd272;
add.f64 fd392, fd104, fd391;
add.f64 fd393, fd188, fd230;
add.f64 fd394, fd393, fd392;
add.f64 fd395, fd150, fd276;
add.f64 fd396, fd108, fd395;
add.f64 fd397, fd192, fd234;
add.f64 fd398, fd397, fd396;
fma.rn.f64 fd399, fd391, 0d3FD3C6EF372FE950, fd104;
mul.f64 fd400, fd393, 0d3FE9E3779B97F4A8;
sub.f64 fd401, fd399, fd400;
sub.f64 fd402, fd150, fd276;
mul.f64 fd403, fd402, 0d3FEE6F0E134454FF;
sub.f64 fd404, fd192, fd234;
fma.rn.f64 fd405, fd404, 0d3FE2CF2304755A5E, fd403;
sub.f64 fd406, fd401, fd405;
add.f64 fd407, fd405, fd401;
mul.f64 fd408, fd391, 0d3FE9E3779B97F4A8;
sub.f64 fd409, fd104, fd408;
fma.rn.f64 fd410, fd393, 0d3FD3C6EF372FE950, fd409;
mul.f64 fd411, fd402, 0d3FE2CF2304755A5E;
mul.f64 fd412, fd404, 0d3FEE6F0E134454FF;
sub.f64 fd413, fd411, fd412;
sub.f64 fd414, fd410, fd413;
add.f64 fd415, fd413, fd410;
fma.rn.f64 fd416, fd395, 0d3FD3C6EF372FE950, fd108;
mul.f64 fd417, fd397, 0d3FE9E3779B97F4A8;
sub.f64 fd418, fd416, fd417;
sub.f64 fd419, fd146, fd272;
mul.f64 fd420, fd419, 0d3FEE6F0E134454FF;
sub.f64 fd421, fd188, fd230;
fma.rn.f64 fd422, fd421, 0d3FE2CF2304755A5E, fd420;
add.f64 fd423, fd422, fd418;
sub.f64 fd424, fd418, fd422;
mul.f64 fd425, fd395, 0d3FE9E3779B97F4A8;
sub.f64 fd426, fd108, fd425;
fma.rn.f64 fd427, fd397, 0d3FD3C6EF372FE950, fd426;
mul.f64 fd428, fd419, 0d3FE2CF2304755A5E;
mul.f64 fd429, fd421, 0d3FEE6F0E134454FF;
sub.f64 fd430, fd428, fd429;
add.f64 fd431, fd430, fd427;
sub.f64 fd432, fd427, fd430;
add.f64 fd433, fd313, fd328;
add.f64 fd434, fd116, fd433;
add.f64 fd435, fd318, fd323;
add.f64 fd436, fd435, fd434;
add.f64 fd437, fd315, fd330;
add.f64 fd438, fd133, fd437;
add.f64 fd439, fd320, fd325;
add.f64 fd440, fd439, fd438;
fma.rn.f64 fd441, fd433, 0d3FD3C6EF372FE950, fd116;
mul.f64 fd442, fd435, 0d3FE9E3779B97F4A8;
sub.f64 fd443, fd441, fd442;
sub.f64 fd444, fd315, fd330;
mul.f64 fd445, fd444, 0d3FEE6F0E134454FF;
sub.f64 fd446, fd320, fd325;
fma.rn.f64 fd447, fd446, 0d3FE2CF2304755A5E, fd445;
sub.f64 fd448, fd443, fd447;
add.f64 fd449, fd447, fd443;
mul.f64 fd450, fd433, 0d3FE9E3779B97F4A8;
sub.f64 fd451, fd116, fd450;
fma.rn.f64 fd452, fd435, 0d3FD3C6EF372FE950, fd451;
mul.f64 fd453, fd444, 0d3FE2CF2304755A5E;
mul.f64 fd454, fd446, 0d3FEE6F0E134454FF;
sub.f64 fd455, fd453, fd454;
sub.f64 fd456, fd452, fd455;
add.f64 fd457, fd455, fd452;
fma.rn.f64 fd458, fd437, 0d3FD3C6EF372FE950, fd133;
mul.f64 fd459, fd439, 0d3FE9E3779B97F4A8;
sub.f64 fd460, fd458, fd459;
sub.f64 fd461, fd313, fd328;
mul.f64 fd462, fd461, 0d3FEE6F0E134454FF;
sub.f64 fd463, fd318, fd323;
fma.rn.f64 fd464, fd463, 0d3FE2CF2304755A5E, fd462;
add.f64 fd465, fd464, fd460;
sub.f64 fd466, fd460, fd464;
mul.f64 fd467, fd437, 0d3FE9E3779B97F4A8;
sub.f64 fd468, fd133, fd467;
fma.rn.f64 fd469, fd439, 0d3FD3C6EF372FE950, fd468;
mul.f64 fd470, fd461, 0d3FE2CF2304755A5E;
mul.f64 fd471, fd463, 0d3FEE6F0E134454FF;
sub.f64 fd472, fd470, fd471;
add.f64 fd473, fd472, fd469;
sub.f64 fd474, fd469, fd472;
add.f64 fd475, fd333, fd348;
add.f64 fd476, fd124, fd475;
add.f64 fd477, fd338, fd343;
add.f64 fd478, fd477, fd476;
add.f64 fd479, fd335, fd350;
add.f64 fd480, fd141, fd479;
add.f64 fd481, fd340, fd345;
add.f64 fd482, fd481, fd480;
fma.rn.f64 fd483, fd475, 0d3FD3C6EF372FE950, fd124;
mul.f64 fd484, fd477, 0d3FE9E3779B97F4A8;
sub.f64 fd485, fd483, fd484;
sub.f64 fd486, fd335, fd350;
mul.f64 fd487, fd486, 0d3FEE6F0E134454FF;
sub.f64 fd488, fd340, fd345;
fma.rn.f64 fd489, fd488, 0d3FE2CF2304755A5E, fd487;
sub.f64 fd490, fd485, fd489;
add.f64 fd491, fd489, fd485;
mul.f64 fd492, fd475, 0d3FE9E3779B97F4A8;
sub.f64 fd493, fd124, fd492;
fma.rn.f64 fd494, fd477, 0d3FD3C6EF372FE950, fd493;
mul.f64 fd495, fd486, 0d3FE2CF2304755A5E;
mul.f64 fd496, fd488, 0d3FEE6F0E134454FF;
sub.f64 fd497, fd495, fd496;
sub.f64 fd498, fd494, fd497;
add.f64 fd499, fd497, fd494;
fma.rn.f64 fd500, fd479, 0d3FD3C6EF372FE950, fd141;
mul.f64 fd501, fd481, 0d3FE9E3779B97F4A8;
sub.f64 fd502, fd500, fd501;
sub.f64 fd503, fd333, fd348;
mul.f64 fd504, fd503, 0d3FEE6F0E134454FF;
sub.f64 fd505, fd338, fd343;
fma.rn.f64 fd506, fd505, 0d3FE2CF2304755A5E, fd504;
add.f64 fd507, fd506, fd502;
sub.f64 fd508, fd502, fd506;
mul.f64 fd509, fd479, 0d3FE9E3779B97F4A8;
sub.f64 fd510, fd141, fd509;
fma.rn.f64 fd511, fd481, 0d3FD3C6EF372FE950, fd510;
mul.f64 fd512, fd503, 0d3FE2CF2304755A5E;
mul.f64 fd513, fd505, 0d3FEE6F0E134454FF;
sub.f64 fd514, fd512, fd513;
add.f64 fd515, fd514, fd511;
sub.f64 fd516, fd511, fd514;
add.f64 fd517, fd353, fd368;
add.f64 fd518, fd125, fd517;
add.f64 fd519, fd358, fd363;
add.f64 fd520, fd519, fd518;
add.f64 fd521, fd355, fd370;
add.f64 fd522, fd142, fd521;
add.f64 fd523, fd360, fd365;
add.f64 fd524, fd523, fd522;
fma.rn.f64 fd525, fd517, 0d3FD3C6EF372FE950, fd125;
mul.f64 fd526, fd519, 0d3FE9E3779B97F4A8;
sub.f64 fd527, fd525, fd526;
sub.f64 fd528, fd355, fd370;
mul.f64 fd529, fd528, 0d3FEE6F0E134454FF;
sub.f64 fd530, fd360, fd365;
fma.rn.f64 fd531, fd530, 0d3FE2CF2304755A5E, fd529;
sub.f64 fd532, fd527, fd531;
add.f64 fd533, fd531, fd527;
mul.f64 fd534, fd517, 0d3FE9E3779B97F4A8;
sub.f64 fd535, fd125, fd534;
fma.rn.f64 fd536, fd519, 0d3FD3C6EF372FE950, fd535;
mul.f64 fd537, fd528, 0d3FE2CF2304755A5E;
mul.f64 fd538, fd530, 0d3FEE6F0E134454FF;
sub.f64 fd539, fd537, fd538;
sub.f64 fd540, fd536, fd539;
add.f64 fd541, fd539, fd536;
fma.rn.f64 fd542, fd521, 0d3FD3C6EF372FE950, fd142;
mul.f64 fd543, fd523, 0d3FE9E3779B97F4A8;
sub.f64 fd544, fd542, fd543;
sub.f64 fd545, fd353, fd368;
mul.f64 fd546, fd545, 0d3FEE6F0E134454FF;
sub.f64 fd547, fd358, fd363;
fma.rn.f64 fd548, fd547, 0d3FE2CF2304755A5E, fd546;
add.f64 fd549, fd548, fd544;
sub.f64 fd550, fd544, fd548;
mul.f64 fd551, fd521, 0d3FE9E3779B97F4A8;
sub.f64 fd552, fd142, fd551;
fma.rn.f64 fd553, fd523, 0d3FD3C6EF372FE950, fd552;
mul.f64 fd554, fd545, 0d3FE2CF2304755A5E;
mul.f64 fd555, fd547, 0d3FEE6F0E134454FF;
sub.f64 fd556, fd554, fd555;
add.f64 fd557, fd556, fd553;
sub.f64 fd558, fd553, fd556;
add.f64 fd559, fd373, fd388;
add.f64 fd560, fd117, fd559;
add.f64 fd561, fd378, fd383;
add.f64 fd562, fd561, fd560;
add.f64 fd563, fd375, fd390;
add.f64 fd564, fd134, fd563;
add.f64 fd565, fd380, fd385;
add.f64 fd566, fd565, fd564;
fma.rn.f64 fd567, fd559, 0d3FD3C6EF372FE950, fd117;
mul.f64 fd568, fd561, 0d3FE9E3779B97F4A8;
sub.f64 fd569, fd567, fd568;
sub.f64 fd570, fd375, fd390;
mul.f64 fd571, fd570, 0d3FEE6F0E134454FF;
sub.f64 fd572, fd380, fd385;
fma.rn.f64 fd573, fd572, 0d3FE2CF2304755A5E, fd571;
sub.f64 fd574, fd569, fd573;
add.f64 fd575, fd573, fd569;
mul.f64 fd576, fd559, 0d3FE9E3779B97F4A8;
sub.f64 fd577, fd117, fd576;
fma.rn.f64 fd578, fd561, 0d3FD3C6EF372FE950, fd577;
mul.f64 fd579, fd570, 0d3FE2CF2304755A5E;
mul.f64 fd580, fd572, 0d3FEE6F0E134454FF;
sub.f64 fd581, fd579, fd580;
sub.f64 fd582, fd578, fd581;
add.f64 fd583, fd581, fd578;
fma.rn.f64 fd584, fd563, 0d3FD3C6EF372FE950, fd134;
mul.f64 fd585, fd565, 0d3FE9E3779B97F4A8;
sub.f64 fd586, fd584, fd585;
sub.f64 fd587, fd373, fd388;
mul.f64 fd588, fd587, 0d3FEE6F0E134454FF;
sub.f64 fd589, fd378, fd383;
fma.rn.f64 fd590, fd589, 0d3FE2CF2304755A5E, fd588;
add.f64 fd591, fd590, fd586;
sub.f64 fd592, fd586, fd590;
mul.f64 fd593, fd563, 0d3FE9E3779B97F4A8;
sub.f64 fd594, fd134, fd593;
fma.rn.f64 fd595, fd565, 0d3FD3C6EF372FE950, fd594;
mul.f64 fd596, fd587, 0d3FE2CF2304755A5E;
mul.f64 fd597, fd589, 0d3FEE6F0E134454FF;
sub.f64 fd598, fd596, fd597;
add.f64 fd599, fd598, fd595;
sub.f64 fd600, fd595, fd598;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %51;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd601, fd602}, [rd6];
mul.f64 fd605, fd440, fd602;
fma.rn.f64 fd606, fd601, fd436, fd605;
mul.f64 fd607, fd436, fd602;
mul.f64 fd608, fd601, fd440;
sub.f64 fd609, fd608, fd607;
mul.f64 fd610, fd601, fd601;
mul.f64 fd611, fd602, fd602;
sub.f64 fd612, fd610, fd611;
mul.f64 fd613, fd602, fd601;
fma.rn.f64 fd614, fd602, fd601, fd613;
mul.f64 fd615, fd482, fd614;
fma.rn.f64 fd616, fd612, fd478, fd615;
mul.f64 fd617, fd478, fd614;
mul.f64 fd618, fd612, fd482;
sub.f64 fd619, fd618, fd617;
mul.f64 fd620, fd601, fd612;
mul.f64 fd621, fd602, fd614;
sub.f64 fd622, fd620, fd621;
mul.f64 fd623, fd601, fd614;
fma.rn.f64 fd624, fd602, fd612, fd623;
mul.f64 fd625, fd524, fd624;
fma.rn.f64 fd626, fd622, fd520, fd625;
mul.f64 fd627, fd520, fd624;
mul.f64 fd628, fd622, fd524;
sub.f64 fd629, fd628, fd627;
mul.f64 fd630, fd601, fd622;
mul.f64 fd631, fd602, fd624;
sub.f64 fd632, fd630, fd631;
mul.f64 fd633, fd601, fd624;
fma.rn.f64 fd634, fd602, fd622, fd633;
mul.f64 fd635, fd566, fd634;
fma.rn.f64 fd636, fd632, fd562, fd635;
mul.f64 fd637, fd562, fd634;
mul.f64 fd638, fd632, fd566;
sub.f64 fd639, fd638, fd637;
mul.f64 fd640, fd601, fd632;
mul.f64 fd641, fd602, fd634;
sub.f64 fd642, fd640, fd641;
mul.f64 fd643, fd601, fd634;
fma.rn.f64 fd644, fd602, fd632, fd643;
mul.f64 fd645, fd423, fd644;
fma.rn.f64 fd646, fd642, fd406, fd645;
mul.f64 fd647, fd406, fd644;
mul.f64 fd648, fd642, fd423;
sub.f64 fd649, fd648, fd647;
mul.f64 fd650, fd601, fd642;
mul.f64 fd651, fd602, fd644;
sub.f64 fd652, fd650, fd651;
mul.f64 fd653, fd601, fd644;
fma.rn.f64 fd654, fd602, fd642, fd653;
mul.f64 fd655, fd465, fd654;
fma.rn.f64 fd656, fd652, fd448, fd655;
mul.f64 fd657, fd448, fd654;
mul.f64 fd658, fd652, fd465;
sub.f64 fd659, fd658, fd657;
mul.f64 fd660, fd601, fd652;
mul.f64 fd661, fd602, fd654;
sub.f64 fd662, fd660, fd661;
mul.f64 fd663, fd601, fd654;
fma.rn.f64 fd664, fd602, fd652, fd663;
mul.f64 fd665, fd507, fd664;
fma.rn.f64 fd666, fd662, fd490, fd665;
mul.f64 fd667, fd490, fd664;
mul.f64 fd668, fd662, fd507;
sub.f64 fd669, fd668, fd667;
mul.f64 fd670, fd601, fd662;
mul.f64 fd671, fd602, fd664;
sub.f64 fd672, fd670, fd671;
mul.f64 fd673, fd601, fd664;
fma.rn.f64 fd674, fd602, fd662, fd673;
mul.f64 fd675, fd549, fd674;
fma.rn.f64 fd676, fd672, fd532, fd675;
mul.f64 fd677, fd532, fd674;
mul.f64 fd678, fd672, fd549;
sub.f64 fd679, fd678, fd677;
mul.f64 fd680, fd601, fd672;
mul.f64 fd681, fd602, fd674;
sub.f64 fd682, fd680, fd681;
mul.f64 fd683, fd601, fd674;
fma.rn.f64 fd684, fd602, fd672, fd683;
mul.f64 fd685, fd591, fd684;
fma.rn.f64 fd686, fd682, fd574, fd685;
mul.f64 fd687, fd574, fd684;
mul.f64 fd688, fd682, fd591;
sub.f64 fd689, fd688, fd687;
mul.f64 fd690, fd601, fd682;
mul.f64 fd691, fd602, fd684;
sub.f64 fd692, fd690, fd691;
mul.f64 fd693, fd601, fd684;
fma.rn.f64 fd694, fd602, fd682, fd693;
mul.f64 fd695, fd431, fd694;
fma.rn.f64 fd696, fd692, fd414, fd695;
mul.f64 fd697, fd414, fd694;
mul.f64 fd698, fd692, fd431;
sub.f64 fd699, fd698, fd697;
mul.f64 fd700, fd601, fd692;
mul.f64 fd701, fd602, fd694;
sub.f64 fd702, fd700, fd701;
mul.f64 fd703, fd601, fd694;
fma.rn.f64 fd704, fd602, fd692, fd703;
mul.f64 fd705, fd473, fd704;
fma.rn.f64 fd706, fd702, fd456, fd705;
mul.f64 fd707, fd456, fd704;
mul.f64 fd708, fd702, fd473;
sub.f64 fd709, fd708, fd707;
mul.f64 fd710, fd601, fd702;
mul.f64 fd711, fd602, fd704;
sub.f64 fd712, fd710, fd711;
mul.f64 fd713, fd601, fd704;
fma.rn.f64 fd714, fd602, fd702, fd713;
mul.f64 fd715, fd515, fd714;
fma.rn.f64 fd716, fd712, fd498, fd715;
mul.f64 fd717, fd498, fd714;
mul.f64 fd718, fd712, fd515;
sub.f64 fd719, fd718, fd717;
ld.global.v2.f64 {fd720, fd721}, [rd6+80];
mul.f64 fd724, fd557, fd721;
fma.rn.f64 fd725, fd720, fd540, fd724;
mul.f64 fd726, fd540, fd721;
mul.f64 fd727, fd720, fd557;
sub.f64 fd728, fd727, fd726;
mul.f64 fd729, fd601, fd720;
mul.f64 fd730, fd602, fd721;
sub.f64 fd731, fd729, fd730;
mul.f64 fd732, fd601, fd721;
fma.rn.f64 fd733, fd602, fd720, fd732;
mul.f64 fd734, fd599, fd733;
fma.rn.f64 fd735, fd731, fd582, fd734;
mul.f64 fd736, fd582, fd733;
mul.f64 fd737, fd731, fd599;
sub.f64 fd738, fd737, fd736;
mul.f64 fd739, fd601, fd731;
mul.f64 fd740, fd602, fd733;
sub.f64 fd741, fd739, fd740;
mul.f64 fd742, fd601, fd733;
fma.rn.f64 fd743, fd602, fd731, fd742;
mul.f64 fd744, fd432, fd743;
fma.rn.f64 fd745, fd741, fd415, fd744;
mul.f64 fd746, fd415, fd743;
mul.f64 fd747, fd741, fd432;
sub.f64 fd748, fd747, fd746;
mul.f64 fd749, fd601, fd741;
mul.f64 fd750, fd602, fd743;
sub.f64 fd751, fd749, fd750;
mul.f64 fd752, fd601, fd743;
fma.rn.f64 fd753, fd602, fd741, fd752;
mul.f64 fd754, fd474, fd753;
fma.rn.f64 fd755, fd751, fd457, fd754;
mul.f64 fd756, fd457, fd753;
mul.f64 fd757, fd751, fd474;
sub.f64 fd758, fd757, fd756;
mul.f64 fd759, fd601, fd751;
mul.f64 fd760, fd602, fd753;
sub.f64 fd761, fd759, fd760;
mul.f64 fd762, fd601, fd753;
fma.rn.f64 fd763, fd602, fd751, fd762;
mul.f64 fd764, fd516, fd763;
fma.rn.f64 fd765, fd761, fd499, fd764;
mul.f64 fd766, fd499, fd763;
mul.f64 fd767, fd761, fd516;
sub.f64 fd768, fd767, fd766;
mul.f64 fd769, fd601, fd761;
mul.f64 fd770, fd602, fd763;
sub.f64 fd771, fd769, fd770;
mul.f64 fd772, fd601, fd763;
fma.rn.f64 fd773, fd602, fd761, fd772;
mul.f64 fd774, fd558, fd773;
fma.rn.f64 fd775, fd771, fd541, fd774;
mul.f64 fd776, fd541, fd773;
mul.f64 fd777, fd771, fd558;
sub.f64 fd778, fd777, fd776;
mul.f64 fd779, fd601, fd771;
mul.f64 fd780, fd602, fd773;
sub.f64 fd781, fd779, fd780;
mul.f64 fd782, fd601, fd773;
fma.rn.f64 fd783, fd602, fd771, fd782;
mul.f64 fd784, fd600, fd783;
fma.rn.f64 fd785, fd781, fd583, fd784;
mul.f64 fd786, fd583, fd783;
mul.f64 fd787, fd781, fd600;
sub.f64 fd788, fd787, fd786;
mul.f64 fd789, fd601, fd781;
mul.f64 fd790, fd602, fd783;
sub.f64 fd791, fd789, fd790;
mul.f64 fd792, fd601, fd783;
fma.rn.f64 fd793, fd602, fd781, fd792;
mul.f64 fd794, fd424, fd793;
fma.rn.f64 fd795, fd791, fd407, fd794;
mul.f64 fd796, fd407, fd793;
mul.f64 fd797, fd791, fd424;
sub.f64 fd798, fd797, fd796;
mul.f64 fd799, fd601, fd791;
mul.f64 fd800, fd602, fd793;
sub.f64 fd801, fd799, fd800;
mul.f64 fd802, fd601, fd793;
fma.rn.f64 fd803, fd602, fd791, fd802;
mul.f64 fd804, fd466, fd803;
fma.rn.f64 fd805, fd801, fd449, fd804;
mul.f64 fd806, fd449, fd803;
mul.f64 fd807, fd801, fd466;
sub.f64 fd808, fd807, fd806;
mul.f64 fd809, fd601, fd801;
mul.f64 fd810, fd602, fd803;
sub.f64 fd811, fd809, fd810;
mul.f64 fd812, fd601, fd803;
fma.rn.f64 fd813, fd602, fd801, fd812;
mul.f64 fd814, fd508, fd813;
fma.rn.f64 fd815, fd811, fd491, fd814;
mul.f64 fd816, fd491, fd813;
mul.f64 fd817, fd811, fd508;
sub.f64 fd818, fd817, fd816;
mul.f64 fd819, fd601, fd811;
mul.f64 fd820, fd602, fd813;
sub.f64 fd821, fd819, fd820;
mul.f64 fd822, fd601, fd813;
fma.rn.f64 fd823, fd602, fd811, fd822;
mul.f64 fd824, fd550, fd823;
fma.rn.f64 fd825, fd821, fd533, fd824;
mul.f64 fd826, fd533, fd823;
mul.f64 fd827, fd821, fd550;
sub.f64 fd828, fd827, fd826;
mul.f64 fd829, fd601, fd821;
mul.f64 fd830, fd602, fd823;
sub.f64 fd831, fd829, fd830;
mul.f64 fd832, fd601, fd823;
fma.rn.f64 fd833, fd602, fd821, fd832;
mul.f64 fd834, fd592, fd833;
fma.rn.f64 fd835, fd831, fd575, fd834;
mul.f64 fd836, fd575, fd833;
mul.f64 fd837, fd831, fd592;
sub.f64 fd838, fd837, fd836;
mad.lo.s32 r8, r5, 1000, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 200, r8;
st.shared.f64 [r9], fd394;
st.shared.f64 [r9+8], fd606;
st.shared.f64 [r9+16], fd616;
st.shared.f64 [r9+24], fd626;
st.shared.f64 [r9+32], fd636;
st.shared.f64 [r9+40], fd646;
st.shared.f64 [r9+48], fd656;
st.shared.f64 [r9+56], fd666;
st.shared.f64 [r9+64], fd676;
st.shared.f64 [r9+72], fd686;
st.shared.f64 [r9+80], fd696;
st.shared.f64 [r9+88], fd706;
st.shared.f64 [r9+96], fd716;
st.shared.f64 [r9+104], fd725;
st.shared.f64 [r9+112], fd735;
st.shared.f64 [r9+120], fd745;
st.shared.f64 [r9+128], fd755;
st.shared.f64 [r9+136], fd765;
st.shared.f64 [r9+144], fd775;
st.shared.f64 [r9+152], fd785;
st.shared.f64 [r9+160], fd795;
st.shared.f64 [r9+168], fd805;
st.shared.f64 [r9+176], fd815;
st.shared.f64 [r9+184], fd825;
st.shared.f64 [r9+192], fd835;
barrier.sync 0;
mad.lo.s32 r10, r7, -192, r9;
ld.shared.f64 fd839, [r10];
ld.shared.f64 fd840, [r10+40];
ld.shared.f64 fd841, [r10+80];
ld.shared.f64 fd842, [r10+120];
ld.shared.f64 fd843, [r10+160];
ld.shared.f64 fd844, [r10+200];
ld.shared.f64 fd845, [r10+240];
ld.shared.f64 fd846, [r10+280];
ld.shared.f64 fd847, [r10+320];
ld.shared.f64 fd848, [r10+360];
ld.shared.f64 fd849, [r10+400];
ld.shared.f64 fd850, [r10+440];
ld.shared.f64 fd851, [r10+480];
ld.shared.f64 fd852, [r10+520];
ld.shared.f64 fd853, [r10+560];
ld.shared.f64 fd854, [r10+600];
ld.shared.f64 fd855, [r10+640];
ld.shared.f64 fd856, [r10+680];
ld.shared.f64 fd857, [r10+720];
ld.shared.f64 fd858, [r10+760];
ld.shared.f64 fd859, [r10+800];
ld.shared.f64 fd860, [r10+840];
ld.shared.f64 fd861, [r10+880];
ld.shared.f64 fd862, [r10+920];
ld.shared.f64 fd863, [r10+960];
barrier.sync 0;
st.shared.f64 [r9], fd398;
st.shared.f64 [r9+8], fd609;
st.shared.f64 [r9+16], fd619;
st.shared.f64 [r9+24], fd629;
st.shared.f64 [r9+32], fd639;
st.shared.f64 [r9+40], fd649;
st.shared.f64 [r9+48], fd659;
st.shared.f64 [r9+56], fd669;
st.shared.f64 [r9+64], fd679;
st.shared.f64 [r9+72], fd689;
st.shared.f64 [r9+80], fd699;
st.shared.f64 [r9+88], fd709;
st.shared.f64 [r9+96], fd719;
st.shared.f64 [r9+104], fd728;
st.shared.f64 [r9+112], fd738;
st.shared.f64 [r9+120], fd748;
st.shared.f64 [r9+128], fd758;
st.shared.f64 [r9+136], fd768;
st.shared.f64 [r9+144], fd778;
st.shared.f64 [r9+152], fd788;
st.shared.f64 [r9+160], fd798;
st.shared.f64 [r9+168], fd808;
st.shared.f64 [r9+176], fd818;
st.shared.f64 [r9+184], fd828;
st.shared.f64 [r9+192], fd838;
barrier.sync 0;
ld.shared.f64 fd864, [r10];
ld.shared.f64 fd865, [r10+40];
ld.shared.f64 fd866, [r10+80];
ld.shared.f64 fd867, [r10+120];
ld.shared.f64 fd868, [r10+160];
ld.shared.f64 fd869, [r10+200];
ld.shared.f64 fd870, [r10+240];
ld.shared.f64 fd871, [r10+280];
ld.shared.f64 fd872, [r10+320];
ld.shared.f64 fd873, [r10+360];
ld.shared.f64 fd874, [r10+400];
ld.shared.f64 fd875, [r10+440];
ld.shared.f64 fd876, [r10+480];
ld.shared.f64 fd877, [r10+520];
ld.shared.f64 fd878, [r10+560];
ld.shared.f64 fd879, [r10+600];
ld.shared.f64 fd880, [r10+640];
ld.shared.f64 fd881, [r10+680];
ld.shared.f64 fd882, [r10+720];
ld.shared.f64 fd883, [r10+760];
ld.shared.f64 fd884, [r10+800];
ld.shared.f64 fd885, [r10+840];
ld.shared.f64 fd886, [r10+880];
ld.shared.f64 fd887, [r10+920];
ld.shared.f64 fd888, [r10+960];
add.f64 fd889, fd844, fd859;
add.f64 fd890, fd839, fd889;
add.f64 fd891, fd849, fd854;
add.f64 fd892, fd869, fd884;
add.f64 fd893, fd864, fd892;
add.f64 fd894, fd874, fd879;
fma.rn.f64 fd895, fd889, 0d3FD3C6EF372FE950, fd839;
mul.f64 fd896, fd891, 0d3FE9E3779B97F4A8;
sub.f64 fd897, fd895, fd896;
sub.f64 fd898, fd869, fd884;
mul.f64 fd899, fd898, 0d3FEE6F0E134454FF;
sub.f64 fd900, fd874, fd879;
fma.rn.f64 fd901, fd900, 0d3FE2CF2304755A5E, fd899;
mul.f64 fd902, fd889, 0d3FE9E3779B97F4A8;
sub.f64 fd903, fd839, fd902;
fma.rn.f64 fd904, fd891, 0d3FD3C6EF372FE950, fd903;
mul.f64 fd905, fd898, 0d3FE2CF2304755A5E;
mul.f64 fd906, fd900, 0d3FEE6F0E134454FF;
sub.f64 fd907, fd905, fd906;
fma.rn.f64 fd908, fd892, 0d3FD3C6EF372FE950, fd864;
mul.f64 fd909, fd894, 0d3FE9E3779B97F4A8;
sub.f64 fd910, fd908, fd909;
sub.f64 fd911, fd844, fd859;
mul.f64 fd912, fd911, 0d3FEE6F0E134454FF;
sub.f64 fd913, fd849, fd854;
fma.rn.f64 fd914, fd913, 0d3FE2CF2304755A5E, fd912;
mul.f64 fd915, fd892, 0d3FE9E3779B97F4A8;
sub.f64 fd916, fd864, fd915;
fma.rn.f64 fd917, fd894, 0d3FD3C6EF372FE950, fd916;
mul.f64 fd918, fd911, 0d3FE2CF2304755A5E;
mul.f64 fd919, fd913, 0d3FEE6F0E134454FF;
sub.f64 fd920, fd918, fd919;
add.f64 fd921, fd845, fd860;
add.f64 fd922, fd840, fd921;
add.f64 fd923, fd850, fd855;
add.f64 fd924, fd870, fd885;
add.f64 fd925, fd865, fd924;
add.f64 fd926, fd875, fd880;
fma.rn.f64 fd927, fd921, 0d3FD3C6EF372FE950, fd840;
mul.f64 fd928, fd923, 0d3FE9E3779B97F4A8;
sub.f64 fd929, fd927, fd928;
sub.f64 fd930, fd870, fd885;
mul.f64 fd931, fd930, 0d3FEE6F0E134454FF;
sub.f64 fd932, fd875, fd880;
fma.rn.f64 fd933, fd932, 0d3FE2CF2304755A5E, fd931;
mul.f64 fd934, fd921, 0d3FE9E3779B97F4A8;
sub.f64 fd935, fd840, fd934;
fma.rn.f64 fd936, fd923, 0d3FD3C6EF372FE950, fd935;
mul.f64 fd937, fd930, 0d3FE2CF2304755A5E;
mul.f64 fd938, fd932, 0d3FEE6F0E134454FF;
sub.f64 fd939, fd937, fd938;
fma.rn.f64 fd940, fd924, 0d3FD3C6EF372FE950, fd865;
mul.f64 fd941, fd926, 0d3FE9E3779B97F4A8;
sub.f64 fd942, fd940, fd941;
sub.f64 fd943, fd845, fd860;
mul.f64 fd944, fd943, 0d3FEE6F0E134454FF;
sub.f64 fd945, fd850, fd855;
fma.rn.f64 fd946, fd945, 0d3FE2CF2304755A5E, fd944;
mul.f64 fd947, fd924, 0d3FE9E3779B97F4A8;
sub.f64 fd948, fd865, fd947;
fma.rn.f64 fd949, fd926, 0d3FD3C6EF372FE950, fd948;
mul.f64 fd950, fd943, 0d3FE2CF2304755A5E;
mul.f64 fd951, fd945, 0d3FEE6F0E134454FF;
sub.f64 fd952, fd950, fd951;
add.f64 fd953, fd846, fd861;
add.f64 fd954, fd841, fd953;
add.f64 fd955, fd851, fd856;
add.f64 fd956, fd871, fd886;
add.f64 fd957, fd866, fd956;
add.f64 fd958, fd876, fd881;
fma.rn.f64 fd959, fd953, 0d3FD3C6EF372FE950, fd841;
mul.f64 fd960, fd955, 0d3FE9E3779B97F4A8;
sub.f64 fd961, fd959, fd960;
sub.f64 fd962, fd871, fd886;
mul.f64 fd963, fd962, 0d3FEE6F0E134454FF;
sub.f64 fd964, fd876, fd881;
fma.rn.f64 fd965, fd964, 0d3FE2CF2304755A5E, fd963;
mul.f64 fd966, fd953, 0d3FE9E3779B97F4A8;
sub.f64 fd967, fd841, fd966;
fma.rn.f64 fd968, fd955, 0d3FD3C6EF372FE950, fd967;
mul.f64 fd969, fd962, 0d3FE2CF2304755A5E;
mul.f64 fd970, fd964, 0d3FEE6F0E134454FF;
sub.f64 fd971, fd969, fd970;
fma.rn.f64 fd972, fd956, 0d3FD3C6EF372FE950, fd866;
mul.f64 fd973, fd958, 0d3FE9E3779B97F4A8;
sub.f64 fd974, fd972, fd973;
sub.f64 fd975, fd846, fd861;
mul.f64 fd976, fd975, 0d3FEE6F0E134454FF;
sub.f64 fd977, fd851, fd856;
fma.rn.f64 fd978, fd977, 0d3FE2CF2304755A5E, fd976;
mul.f64 fd979, fd956, 0d3FE9E3779B97F4A8;
sub.f64 fd980, fd866, fd979;
fma.rn.f64 fd981, fd958, 0d3FD3C6EF372FE950, fd980;
mul.f64 fd982, fd975, 0d3FE2CF2304755A5E;
mul.f64 fd983, fd977, 0d3FEE6F0E134454FF;
sub.f64 fd984, fd982, fd983;
add.f64 fd985, fd847, fd862;
add.f64 fd986, fd842, fd985;
add.f64 fd987, fd852, fd857;
add.f64 fd988, fd872, fd887;
add.f64 fd989, fd867, fd988;
add.f64 fd990, fd877, fd882;
fma.rn.f64 fd991, fd985, 0d3FD3C6EF372FE950, fd842;
mul.f64 fd992, fd987, 0d3FE9E3779B97F4A8;
sub.f64 fd993, fd991, fd992;
sub.f64 fd994, fd872, fd887;
mul.f64 fd995, fd994, 0d3FEE6F0E134454FF;
sub.f64 fd996, fd877, fd882;
fma.rn.f64 fd997, fd996, 0d3FE2CF2304755A5E, fd995;
mul.f64 fd998, fd985, 0d3FE9E3779B97F4A8;
sub.f64 fd999, fd842, fd998;
fma.rn.f64 fd1000, fd987, 0d3FD3C6EF372FE950, fd999;
mul.f64 fd1001, fd994, 0d3FE2CF2304755A5E;
mul.f64 fd1002, fd996, 0d3FEE6F0E134454FF;
sub.f64 fd1003, fd1001, fd1002;
fma.rn.f64 fd1004, fd988, 0d3FD3C6EF372FE950, fd867;
mul.f64 fd1005, fd990, 0d3FE9E3779B97F4A8;
sub.f64 fd1006, fd1004, fd1005;
sub.f64 fd1007, fd847, fd862;
mul.f64 fd1008, fd1007, 0d3FEE6F0E134454FF;
sub.f64 fd1009, fd852, fd857;
fma.rn.f64 fd1010, fd1009, 0d3FE2CF2304755A5E, fd1008;
mul.f64 fd1011, fd988, 0d3FE9E3779B97F4A8;
sub.f64 fd1012, fd867, fd1011;
fma.rn.f64 fd1013, fd990, 0d3FD3C6EF372FE950, fd1012;
mul.f64 fd1014, fd1007, 0d3FE2CF2304755A5E;
mul.f64 fd1015, fd1009, 0d3FEE6F0E134454FF;
sub.f64 fd1016, fd1014, fd1015;
add.f64 fd1017, fd848, fd863;
add.f64 fd1018, fd843, fd1017;
add.f64 fd1019, fd853, fd858;
add.f64 fd1020, fd873, fd888;
add.f64 fd1021, fd868, fd1020;
add.f64 fd1022, fd878, fd883;
fma.rn.f64 fd1023, fd1017, 0d3FD3C6EF372FE950, fd843;
mul.f64 fd1024, fd1019, 0d3FE9E3779B97F4A8;
sub.f64 fd1025, fd1023, fd1024;
sub.f64 fd1026, fd873, fd888;
mul.f64 fd1027, fd1026, 0d3FEE6F0E134454FF;
sub.f64 fd1028, fd878, fd883;
fma.rn.f64 fd1029, fd1028, 0d3FE2CF2304755A5E, fd1027;
mul.f64 fd1030, fd1017, 0d3FE9E3779B97F4A8;
sub.f64 fd1031, fd843, fd1030;
fma.rn.f64 fd1032, fd1019, 0d3FD3C6EF372FE950, fd1031;
mul.f64 fd1033, fd1026, 0d3FE2CF2304755A5E;
mul.f64 fd1034, fd1028, 0d3FEE6F0E134454FF;
sub.f64 fd1035, fd1033, fd1034;
fma.rn.f64 fd1036, fd1020, 0d3FD3C6EF372FE950, fd868;
mul.f64 fd1037, fd1022, 0d3FE9E3779B97F4A8;
sub.f64 fd1038, fd1036, fd1037;
sub.f64 fd1039, fd848, fd863;
mul.f64 fd1040, fd1039, 0d3FEE6F0E134454FF;
sub.f64 fd1041, fd853, fd858;
fma.rn.f64 fd1042, fd1041, 0d3FE2CF2304755A5E, fd1040;
mul.f64 fd1043, fd1020, 0d3FE9E3779B97F4A8;
sub.f64 fd1044, fd868, fd1043;
fma.rn.f64 fd1045, fd1022, 0d3FD3C6EF372FE950, fd1044;
mul.f64 fd1046, fd1039, 0d3FE2CF2304755A5E;
mul.f64 fd1047, fd1041, 0d3FEE6F0E134454FF;
sub.f64 fd1048, fd1046, fd1047;
add.f64 %0, fd891, fd890;
add.f64 %1, fd894, fd893;
add.f64 %2, fd923, fd922;
add.f64 %3, fd926, fd925;
add.f64 %4, fd955, fd954;
add.f64 %5, fd958, fd957;
add.f64 %6, fd987, fd986;
add.f64 %7, fd990, fd989;
add.f64 %8, fd1019, fd1018;
add.f64 %9, fd1022, fd1021;
add.f64 %11, fd914, fd910;
sub.f64 %10, fd897, fd901;
add.f64 %13, fd946, fd942;
sub.f64 %12, fd929, fd933;
add.f64 %15, fd978, fd974;
sub.f64 %14, fd961, fd965;
add.f64 %17, fd1010, fd1006;
sub.f64 %16, fd993, fd997;
add.f64 %19, fd1042, fd1038;
sub.f64 %18, fd1025, fd1029;
sub.f64 %20, fd904, fd907;
add.f64 %21, fd920, fd917;
sub.f64 %22, fd936, fd939;
add.f64 %23, fd952, fd949;
sub.f64 %24, fd968, fd971;
add.f64 %25, fd984, fd981;
sub.f64 %26, fd1000, fd1003;
add.f64 %27, fd1016, fd1013;
sub.f64 %28, fd1032, fd1035;
add.f64 %29, fd1048, fd1045;
add.f64 %30, fd907, fd904;
sub.f64 %31, fd917, fd920;
add.f64 %32, fd939, fd936;
sub.f64 %33, fd949, fd952;
add.f64 %34, fd971, fd968;
sub.f64 %35, fd981, fd984;
add.f64 %36, fd1003, fd1000;
sub.f64 %37, fd1013, fd1016;
add.f64 %38, fd1035, fd1032;
sub.f64 %39, fd1045, fd1048;
sub.f64 %41, fd910, fd914;
add.f64 %40, fd901, fd897;
sub.f64 %43, fd942, fd946;
add.f64 %42, fd933, fd929;
sub.f64 %45, fd974, fd978;
add.f64 %44, fd965, fd961;
sub.f64 %47, fd1006, fd1010;
add.f64 %46, fd997, fd993;
sub.f64 %49, fd1038, fd1042;
add.f64 %48, fd1029, fd1025;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y), "=d"(rmem[16].x), "=d"(rmem[16].y), "=d"(rmem[17].x), "=d"(rmem[17].y), "=d"(rmem[18].x), "=d"(rmem[18].y), "=d"(rmem[19].x), "=d"(rmem[19].y), "=d"(rmem[20].x), "=d"(rmem[20].y), "=d"(rmem[21].x), "=d"(rmem[21].y), "=d"(rmem[22].x), "=d"(rmem[22].y), "=d"(rmem[23].x), "=d"(rmem[23].y), "=d"(rmem[24].x), "=d"(rmem[24].y): "r"(smem), "l"(lut_dp_25_125), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[16].x), "d"(rmem[16].y), "d"(rmem[16].y), "d"(rmem[17].x), "d"(rmem[17].y), "d"(rmem[17].y), "d"(rmem[18].x), "d"(rmem[18].y), "d"(rmem[19].x), "d"(rmem[19].y), "d"(rmem[19].y), "d"(rmem[20].x), "d"(rmem[20].y), "d"(rmem[20].y), "d"(rmem[21].x), "d"(rmem[21].y), "d"(rmem[22].x), "d"(rmem[22].y), "d"(rmem[22].y), "d"(rmem[23].x), "d"(rmem[23].y), "d"(rmem[23].y), "d"(rmem[24].x), "d"(rmem[24].y));
};


#endif
