#ifndef CUFFTDX_FFT_15_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_15_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<204, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<307>;
.reg .b64 rd<2>;
add.f32 f61, %38, %62;
add.f32 f62, %30, f61;
add.f32 f63, %46, %54;
add.f32 f64, f63, f62;
add.f32 f65, %39, %63;
add.f32 f66, %31, f65;
add.f32 f67, %47, %55;
add.f32 f68, f67, f66;
fma.rn.f32 f69, f61, 0f3E9E377A, %30;
mul.f32 f70, f63, 0f3F4F1BBD;
sub.f32 f71, f69, f70;
sub.f32 f72, %39, %63;
mul.f32 f73, f72, 0f3F737871;
sub.f32 f74, %47, %55;
fma.rn.f32 f75, f74, 0f3F167918, f73;
sub.f32 f76, f71, f75;
add.f32 f77, f75, f71;
mul.f32 f78, f61, 0f3F4F1BBD;
sub.f32 f79, %30, f78;
fma.rn.f32 f80, f63, 0f3E9E377A, f79;
mul.f32 f81, f72, 0f3F167918;
mul.f32 f82, f74, 0f3F737871;
sub.f32 f83, f81, f82;
sub.f32 f84, f80, f83;
add.f32 f85, f83, f80;
fma.rn.f32 f86, f65, 0f3E9E377A, %31;
mul.f32 f87, f67, 0f3F4F1BBD;
sub.f32 f88, f86, f87;
sub.f32 f89, %38, %62;
mul.f32 f90, f89, 0f3F737871;
sub.f32 f91, %46, %54;
fma.rn.f32 f92, f91, 0f3F167918, f90;
add.f32 f93, f92, f88;
sub.f32 f94, f88, f92;
mul.f32 f95, f65, 0f3F4F1BBD;
sub.f32 f96, %31, f95;
fma.rn.f32 f97, f67, 0f3E9E377A, f96;
mul.f32 f98, f89, 0f3F167918;
mul.f32 f99, f91, 0f3F737871;
sub.f32 f100, f98, f99;
add.f32 f101, f100, f97;
sub.f32 f102, f97, f100;
add.f32 f103, %40, %64;
add.f32 f104, %32, f103;
add.f32 f105, %48, %56;
add.f32 f106, f105, f104;
add.f32 f107, %42, %66;
add.f32 f108, %34, f107;
add.f32 f109, %50, %58;
add.f32 f110, f109, f108;
fma.rn.f32 f111, f103, 0f3E9E377A, %32;
mul.f32 f112, f105, 0f3F4F1BBD;
sub.f32 f113, f111, f112;
sub.f32 f114, %42, %66;
mul.f32 f115, f114, 0f3F737871;
sub.f32 f116, %50, %58;
fma.rn.f32 f117, f116, 0f3F167918, f115;
sub.f32 f118, f113, f117;
add.f32 f119, f117, f113;
mul.f32 f120, f103, 0f3F4F1BBD;
sub.f32 f121, %32, f120;
fma.rn.f32 f122, f105, 0f3E9E377A, f121;
mul.f32 f123, f114, 0f3F167918;
mul.f32 f124, f116, 0f3F737871;
sub.f32 f125, f123, f124;
sub.f32 f126, f122, f125;
add.f32 f127, f125, f122;
fma.rn.f32 f128, f107, 0f3E9E377A, %34;
mul.f32 f129, f109, 0f3F4F1BBD;
sub.f32 f130, f128, f129;
sub.f32 f131, %40, %64;
mul.f32 f132, f131, 0f3F737871;
sub.f32 f133, %48, %56;
fma.rn.f32 f134, f133, 0f3F167918, f132;
add.f32 f135, f134, f130;
sub.f32 f136, f130, f134;
mul.f32 f137, f107, 0f3F4F1BBD;
sub.f32 f138, %34, f137;
fma.rn.f32 f139, f109, 0f3E9E377A, f138;
mul.f32 f140, f131, 0f3F167918;
mul.f32 f141, f133, 0f3F737871;
sub.f32 f142, f140, f141;
add.f32 f143, f142, f139;
sub.f32 f144, f139, f142;
add.f32 f145, %43, %67;
add.f32 f146, %35, f145;
add.f32 f147, %51, %59;
add.f32 f148, f147, f146;
add.f32 f149, %45, %68;
add.f32 f150, %37, f149;
add.f32 f151, %53, %61;
add.f32 f152, f151, f150;
fma.rn.f32 f153, f145, 0f3E9E377A, %35;
mul.f32 f154, f147, 0f3F4F1BBD;
sub.f32 f155, f153, f154;
sub.f32 f156, %45, %68;
mul.f32 f157, f156, 0f3F737871;
sub.f32 f158, %53, %61;
fma.rn.f32 f159, f158, 0f3F167918, f157;
sub.f32 f160, f155, f159;
add.f32 f161, f159, f155;
mul.f32 f162, f145, 0f3F4F1BBD;
sub.f32 f163, %35, f162;
fma.rn.f32 f164, f147, 0f3E9E377A, f163;
mul.f32 f165, f156, 0f3F167918;
mul.f32 f166, f158, 0f3F737871;
sub.f32 f167, f165, f166;
sub.f32 f168, f164, f167;
add.f32 f169, f167, f164;
fma.rn.f32 f170, f149, 0f3E9E377A, %37;
mul.f32 f171, f151, 0f3F4F1BBD;
sub.f32 f172, f170, f171;
sub.f32 f173, %43, %67;
mul.f32 f174, f173, 0f3F737871;
sub.f32 f175, %51, %59;
fma.rn.f32 f176, f175, 0f3F167918, f174;
add.f32 f177, f176, f172;
sub.f32 f178, f172, f176;
mul.f32 f179, f149, 0f3F4F1BBD;
sub.f32 f180, %37, f179;
fma.rn.f32 f181, f151, 0f3E9E377A, f180;
mul.f32 f182, f173, 0f3F167918;
mul.f32 f183, f175, 0f3F737871;
sub.f32 f184, f182, f183;
add.f32 f185, f184, f181;
sub.f32 f186, f181, f184;
mul.f32 f187, f118, 0f3F69DE1D;
mul.f32 f188, f135, 0f3ED03FC9;
sub.f32 f189, f187, f188;
mul.f32 f190, f135, 0f3F69DE1D;
fma.rn.f32 f191, f118, 0f3ED03FC9, f190;
mul.f32 f192, f160, 0f3F2B4C25;
mul.f32 f193, f177, 0f3F3E3EBD;
sub.f32 f194, f192, f193;
mul.f32 f195, f177, 0f3F2B4C25;
fma.rn.f32 f196, f160, 0f3F3E3EBD, f195;
mul.f32 f197, f126, 0f3F2B4C25;
mul.f32 f198, f143, 0f3F3E3EBD;
sub.f32 f199, f197, f198;
mul.f32 f200, f143, 0f3F2B4C25;
fma.rn.f32 f201, f126, 0f3F3E3EBD, f200;
mul.f32 f202, f168, 0fBDD61305;
mul.f32 f203, f185, 0f3F7E98FD;
sub.f32 f204, f202, f203;
mul.f32 f205, f185, 0fBDD61305;
fma.rn.f32 f206, f168, 0f3F7E98FD, f205;
mul.f32 f207, f127, 0f3E9E377A;
mul.f32 f208, f144, 0f3F737871;
sub.f32 f209, f207, f208;
mul.f32 f210, f144, 0f3E9E377A;
fma.rn.f32 f211, f127, 0f3F737871, f210;
mul.f32 f212, f169, 0fBF4F1BBD;
mul.f32 f213, f186, 0f3F167918;
sub.f32 f214, f212, f213;
mul.f32 f215, f186, 0fBF4F1BBD;
fma.rn.f32 f216, f169, 0f3F167918, f215;
mul.f32 f217, f119, 0fBDD61305;
mul.f32 f218, f136, 0f3F7E98FD;
sub.f32 f219, f217, f218;
mul.f32 f220, f136, 0fBDD61305;
fma.rn.f32 f221, f119, 0f3F7E98FD, f220;
mul.f32 f222, f161, 0fBF7A67E2;
mul.f32 f223, f178, 0fBE54E6CD;
sub.f32 f224, f222, f223;
mul.f32 f225, f178, 0fBF7A67E2;
fma.rn.f32 f226, f161, 0fBE54E6CD, f225;
add.f32 f227, f106, f148;
add.f32 f228, f110, f152;
mul.f32 f229, f227, 0f3F000000;
sub.f32 f230, f64, f229;
sub.f32 f231, f110, f152;
mul.f32 f232, f231, 0fBF5DB3D7;
mul.f32 f233, f228, 0f3F000000;
sub.f32 f234, f68, f233;
sub.f32 f235, f106, f148;
mul.f32 f236, f235, 0fBF5DB3D7;
add.f32 f237, f189, f194;
add.f32 f238, f191, f196;
mul.f32 f239, f237, 0f3F000000;
sub.f32 f240, f76, f239;
sub.f32 f241, f191, f196;
mul.f32 f242, f241, 0fBF5DB3D7;
mul.f32 f243, f238, 0f3F000000;
sub.f32 f244, f93, f243;
sub.f32 f245, f189, f194;
mul.f32 f246, f245, 0fBF5DB3D7;
add.f32 f247, f199, f204;
add.f32 f248, f201, f206;
mul.f32 f249, f247, 0f3F000000;
sub.f32 f250, f84, f249;
sub.f32 f251, f201, f206;
mul.f32 f252, f251, 0fBF5DB3D7;
mul.f32 f253, f248, 0f3F000000;
sub.f32 f254, f101, f253;
sub.f32 f255, f199, f204;
mul.f32 f256, f255, 0fBF5DB3D7;
add.f32 f257, f209, f214;
add.f32 f258, f211, f216;
mul.f32 f259, f257, 0f3F000000;
sub.f32 f260, f85, f259;
sub.f32 f261, f211, f216;
mul.f32 f262, f261, 0fBF5DB3D7;
mul.f32 f263, f258, 0f3F000000;
sub.f32 f264, f102, f263;
sub.f32 f265, f209, f214;
mul.f32 f266, f265, 0fBF5DB3D7;
add.f32 f267, f219, f224;
add.f32 f268, f221, f226;
mul.f32 f269, f267, 0f3F000000;
sub.f32 f270, f77, f269;
sub.f32 f271, f221, f226;
mul.f32 f272, f271, 0fBF5DB3D7;
mul.f32 f273, f268, 0f3F000000;
sub.f32 f274, f94, f273;
sub.f32 f275, f219, f224;
mul.f32 f276, f275, 0fBF5DB3D7;
add.f32 %1, f68, f228;
add.f32 %0, f64, f227;
add.f32 %3, f93, f238;
add.f32 %2, f76, f237;
add.f32 %5, f101, f248;
add.f32 %4, f84, f247;
add.f32 %7, f102, f258;
add.f32 %6, f85, f257;
add.f32 %9, f94, f268;
add.f32 %8, f77, f267;
sub.f32 %11, f234, f236;
add.f32 %10, f232, f230;
sub.f32 %13, f244, f246;
add.f32 %12, f242, f240;
sub.f32 %15, f254, f256;
add.f32 %14, f252, f250;
sub.f32 %17, f264, f266;
add.f32 %16, f262, f260;
sub.f32 %19, f274, f276;
add.f32 %18, f272, f270;
add.f32 %21, f236, f234;
sub.f32 %20, f230, f232;
add.f32 %23, f246, f244;
sub.f32 %22, f240, f242;
add.f32 %25, f256, f254;
sub.f32 %24, f250, f252;
add.f32 %27, f266, f264;
sub.f32 %26, f260, f262;
add.f32 %29, f276, f274;
sub.f32 %28, f270, f272;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y));
};


#endif
