#ifndef CUFFTDX_FFT_25_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_25_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<155, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<621>;
.reg .b64 rd<2>;
add.f32 f101, %63, %103;
add.f32 f102, %50, f101;
add.f32 f103, %76, %90;
add.f32 f104, f103, f102;
add.f32 f105, %65, %105;
add.f32 f106, %51, f105;
add.f32 f107, %78, %91;
add.f32 f108, f107, f106;
fma.rn.f32 f109, f101, 0f3E9E377A, %50;
mul.f32 f110, f103, 0f3F4F1BBD;
sub.f32 f111, f109, f110;
sub.f32 f112, %65, %105;
mul.f32 f113, f112, 0f3F737871;
sub.f32 f114, %78, %91;
mul.f32 f115, f114, 0fBF167918;
sub.f32 f116, f115, f113;
sub.f32 f117, f111, f116;
add.f32 f118, f116, f111;
mul.f32 f119, f101, 0f3F4F1BBD;
sub.f32 f120, %50, f119;
fma.rn.f32 f121, f103, 0f3E9E377A, f120;
mul.f32 f122, f112, 0f3F167918;
mul.f32 f123, f114, 0f3F737871;
sub.f32 f124, f123, f122;
sub.f32 f125, f121, f124;
add.f32 f126, f124, f121;
fma.rn.f32 f127, f105, 0f3E9E377A, %51;
mul.f32 f128, f107, 0f3F4F1BBD;
sub.f32 f129, f127, f128;
sub.f32 f130, %63, %103;
mul.f32 f131, f130, 0f3F737871;
sub.f32 f132, %76, %90;
mul.f32 f133, f132, 0fBF167918;
sub.f32 f134, f133, f131;
add.f32 f135, f134, f129;
sub.f32 f136, f129, f134;
mul.f32 f137, f105, 0f3F4F1BBD;
sub.f32 f138, %51, f137;
fma.rn.f32 f139, f107, 0f3E9E377A, f138;
mul.f32 f140, f130, 0f3F167918;
mul.f32 f141, f132, 0f3F737871;
sub.f32 f142, f141, f140;
add.f32 f143, f142, f139;
sub.f32 f144, f139, f142;
add.f32 f145, %66, %106;
add.f32 f146, %52, f145;
add.f32 f147, %79, %92;
add.f32 f148, f147, f146;
add.f32 f149, %67, %107;
add.f32 f150, %54, f149;
add.f32 f151, %81, %94;
add.f32 f152, f151, f150;
fma.rn.f32 f153, f145, 0f3E9E377A, %52;
mul.f32 f154, f147, 0f3F4F1BBD;
sub.f32 f155, f153, f154;
sub.f32 f156, %67, %107;
mul.f32 f157, f156, 0f3F737871;
sub.f32 f158, %81, %94;
mul.f32 f159, f158, 0fBF167918;
sub.f32 f160, f159, f157;
sub.f32 f161, f155, f160;
add.f32 f162, f160, f155;
mul.f32 f163, f145, 0f3F4F1BBD;
sub.f32 f164, %52, f163;
fma.rn.f32 f165, f147, 0f3E9E377A, f164;
mul.f32 f166, f156, 0f3F167918;
mul.f32 f167, f158, 0f3F737871;
sub.f32 f168, f167, f166;
sub.f32 f169, f165, f168;
add.f32 f170, f168, f165;
fma.rn.f32 f171, f149, 0f3E9E377A, %54;
mul.f32 f172, f151, 0f3F4F1BBD;
sub.f32 f173, f171, f172;
sub.f32 f174, %66, %106;
mul.f32 f175, f174, 0f3F737871;
sub.f32 f176, %79, %92;
mul.f32 f177, f176, 0fBF167918;
sub.f32 f178, f177, f175;
add.f32 f179, f178, f173;
sub.f32 f180, f173, f178;
mul.f32 f181, f149, 0f3F4F1BBD;
sub.f32 f182, %54, f181;
fma.rn.f32 f183, f151, 0f3E9E377A, f182;
mul.f32 f184, f174, 0f3F167918;
mul.f32 f185, f176, 0f3F737871;
sub.f32 f186, f185, f184;
add.f32 f187, f186, f183;
sub.f32 f188, f183, f186;
add.f32 f189, %68, %108;
add.f32 f190, %55, f189;
add.f32 f191, %82, %95;
add.f32 f192, f191, f190;
add.f32 f193, %70, %110;
add.f32 f194, %57, f193;
add.f32 f195, %83, %97;
add.f32 f196, f195, f194;
fma.rn.f32 f197, f189, 0f3E9E377A, %55;
mul.f32 f198, f191, 0f3F4F1BBD;
sub.f32 f199, f197, f198;
sub.f32 f200, %70, %110;
mul.f32 f201, f200, 0f3F737871;
sub.f32 f202, %83, %97;
mul.f32 f203, f202, 0fBF167918;
sub.f32 f204, f203, f201;
sub.f32 f205, f199, f204;
add.f32 f206, f204, f199;
mul.f32 f207, f189, 0f3F4F1BBD;
sub.f32 f208, %55, f207;
fma.rn.f32 f209, f191, 0f3E9E377A, f208;
mul.f32 f210, f200, 0f3F167918;
mul.f32 f211, f202, 0f3F737871;
sub.f32 f212, f211, f210;
sub.f32 f213, f209, f212;
add.f32 f214, f212, f209;
fma.rn.f32 f215, f193, 0f3E9E377A, %57;
mul.f32 f216, f195, 0f3F4F1BBD;
sub.f32 f217, f215, f216;
sub.f32 f218, %68, %108;
mul.f32 f219, f218, 0f3F737871;
sub.f32 f220, %82, %95;
mul.f32 f221, f220, 0fBF167918;
sub.f32 f222, f221, f219;
add.f32 f223, f222, f217;
sub.f32 f224, f217, f222;
mul.f32 f225, f193, 0f3F4F1BBD;
sub.f32 f226, %57, f225;
fma.rn.f32 f227, f195, 0f3E9E377A, f226;
mul.f32 f228, f218, 0f3F167918;
mul.f32 f229, f220, 0f3F737871;
sub.f32 f230, f229, f228;
add.f32 f231, f230, f227;
sub.f32 f232, f227, f230;
add.f32 f233, %71, %111;
add.f32 f234, %58, f233;
add.f32 f235, %84, %98;
add.f32 f236, f235, f234;
add.f32 f237, %73, %113;
add.f32 f238, %59, f237;
add.f32 f239, %86, %99;
add.f32 f240, f239, f238;
fma.rn.f32 f241, f233, 0f3E9E377A, %58;
mul.f32 f242, f235, 0f3F4F1BBD;
sub.f32 f243, f241, f242;
sub.f32 f244, %73, %113;
mul.f32 f245, f244, 0f3F737871;
sub.f32 f246, %86, %99;
mul.f32 f247, f246, 0fBF167918;
sub.f32 f248, f247, f245;
sub.f32 f249, f243, f248;
add.f32 f250, f248, f243;
mul.f32 f251, f233, 0f3F4F1BBD;
sub.f32 f252, %58, f251;
fma.rn.f32 f253, f235, 0f3E9E377A, f252;
mul.f32 f254, f244, 0f3F167918;
mul.f32 f255, f246, 0f3F737871;
sub.f32 f256, f255, f254;
sub.f32 f257, f253, f256;
add.f32 f258, f256, f253;
fma.rn.f32 f259, f237, 0f3E9E377A, %59;
mul.f32 f260, f239, 0f3F4F1BBD;
sub.f32 f261, f259, f260;
sub.f32 f262, %71, %111;
mul.f32 f263, f262, 0f3F737871;
sub.f32 f264, %84, %98;
mul.f32 f265, f264, 0fBF167918;
sub.f32 f266, f265, f263;
add.f32 f267, f266, f261;
sub.f32 f268, f261, f266;
mul.f32 f269, f237, 0f3F4F1BBD;
sub.f32 f270, %59, f269;
fma.rn.f32 f271, f239, 0f3E9E377A, f270;
mul.f32 f272, f262, 0f3F167918;
mul.f32 f273, f264, 0f3F737871;
sub.f32 f274, f273, f272;
add.f32 f275, f274, f271;
sub.f32 f276, f271, f274;
add.f32 f277, %74, %114;
add.f32 f278, %60, f277;
add.f32 f279, %87, %100;
add.f32 f280, f279, f278;
add.f32 f281, %75, %115;
add.f32 f282, %62, f281;
add.f32 f283, %89, %102;
add.f32 f284, f283, f282;
fma.rn.f32 f285, f277, 0f3E9E377A, %60;
mul.f32 f286, f279, 0f3F4F1BBD;
sub.f32 f287, f285, f286;
sub.f32 f288, %75, %115;
mul.f32 f289, f288, 0f3F737871;
sub.f32 f290, %89, %102;
mul.f32 f291, f290, 0fBF167918;
sub.f32 f292, f291, f289;
sub.f32 f293, f287, f292;
add.f32 f294, f292, f287;
mul.f32 f295, f277, 0f3F4F1BBD;
sub.f32 f296, %60, f295;
fma.rn.f32 f297, f279, 0f3E9E377A, f296;
mul.f32 f298, f288, 0f3F167918;
mul.f32 f299, f290, 0f3F737871;
sub.f32 f300, f299, f298;
sub.f32 f301, f297, f300;
add.f32 f302, f300, f297;
fma.rn.f32 f303, f281, 0f3E9E377A, %62;
mul.f32 f304, f283, 0f3F4F1BBD;
sub.f32 f305, f303, f304;
sub.f32 f306, %74, %114;
mul.f32 f307, f306, 0f3F737871;
sub.f32 f308, %87, %100;
mul.f32 f309, f308, 0fBF167918;
sub.f32 f310, f309, f307;
add.f32 f311, f310, f305;
sub.f32 f312, f305, f310;
mul.f32 f313, f281, 0f3F4F1BBD;
sub.f32 f314, %62, f313;
fma.rn.f32 f315, f283, 0f3E9E377A, f314;
mul.f32 f316, f306, 0f3F167918;
mul.f32 f317, f308, 0f3F737871;
sub.f32 f318, f317, f316;
add.f32 f319, f318, f315;
sub.f32 f320, f315, f318;
mul.f32 f321, f161, 0f3F77F511;
mul.f32 f322, f179, 0fBE7EA890;
sub.f32 f323, f321, f322;
mul.f32 f324, f179, 0f3F77F511;
fma.rn.f32 f325, f161, 0fBE7EA890, f324;
mul.f32 f326, f205, 0f3F6055A2;
mul.f32 f327, f223, 0fBEF6A86B;
sub.f32 f328, f326, f327;
mul.f32 f329, f223, 0f3F6055A2;
fma.rn.f32 f330, f205, 0fBEF6A86B, f329;
mul.f32 f331, f249, 0f3F3A9DB0;
mul.f32 f332, f267, 0fBF2F3E7B;
sub.f32 f333, f331, f332;
mul.f32 f334, f267, 0f3F3A9DB0;
fma.rn.f32 f335, f249, 0fBF2F3E7B, f334;
mul.f32 f336, f293, 0f3F092BF2;
mul.f32 f337, f311, 0fBF5825E0;
sub.f32 f338, f336, f337;
mul.f32 f339, f311, 0f3F092BF2;
fma.rn.f32 f340, f293, 0fBF5825E0, f339;
mul.f32 f341, f169, 0f3F6055A2;
mul.f32 f342, f187, 0fBEF6A86B;
sub.f32 f343, f341, f342;
mul.f32 f344, f187, 0f3F6055A2;
fma.rn.f32 f345, f169, 0fBEF6A86B, f344;
mul.f32 f346, f213, 0f3F092BF2;
mul.f32 f347, f231, 0fBF5825E0;
sub.f32 f348, f346, f347;
mul.f32 f349, f231, 0f3F092BF2;
fma.rn.f32 f350, f213, 0fBF5825E0, f349;
mul.f32 f351, f257, 0f3D809851;
mul.f32 f352, f275, 0fBF7F7EAE;
sub.f32 f353, f351, f352;
mul.f32 f354, f275, 0f3D809851;
fma.rn.f32 f355, f257, 0fBF7F7EAE, f354;
mul.f32 f356, f301, 0fBED9FFBE;
mul.f32 f357, f319, 0fBF67A2BF;
sub.f32 f358, f356, f357;
mul.f32 f359, f319, 0fBED9FFBE;
fma.rn.f32 f360, f301, 0fBF67A2BF, f359;
mul.f32 f361, f170, 0f3F3A9DB0;
mul.f32 f362, f188, 0fBF2F3E7B;
sub.f32 f363, f361, f362;
mul.f32 f364, f188, 0f3F3A9DB0;
fma.rn.f32 f365, f170, 0fBF2F3E7B, f364;
mul.f32 f366, f214, 0f3D809851;
mul.f32 f367, f232, 0fBF7F7EAE;
sub.f32 f368, f366, f367;
mul.f32 f369, f232, 0f3D809851;
fma.rn.f32 f370, f214, 0fBF7F7EAE, f369;
mul.f32 f371, f258, 0fBF232E38;
mul.f32 f372, f276, 0fBF45405B;
sub.f32 f373, f371, f372;
mul.f32 f374, f276, 0fBF232E38;
fma.rn.f32 f375, f258, 0fBF45405B, f374;
mul.f32 f376, f302, 0fBF7DFB3B;
mul.f32 f377, f320, 0fBE00575B;
sub.f32 f378, f376, f377;
mul.f32 f379, f320, 0fBF7DFB3B;
fma.rn.f32 f380, f302, 0fBE00575B, f379;
mul.f32 f381, f162, 0f3F092BF2;
mul.f32 f382, f180, 0fBF5825E0;
sub.f32 f383, f381, f382;
mul.f32 f384, f180, 0f3F092BF2;
fma.rn.f32 f385, f162, 0fBF5825E0, f384;
mul.f32 f386, f206, 0fBED9FFBE;
mul.f32 f387, f224, 0fBF67A2BF;
sub.f32 f388, f386, f387;
mul.f32 f389, f224, 0fBED9FFBE;
fma.rn.f32 f390, f206, 0fBF67A2BF, f389;
mul.f32 f391, f250, 0fBF7DFB3B;
mul.f32 f392, f268, 0fBE00575B;
sub.f32 f393, f391, f392;
mul.f32 f394, f268, 0fBF7DFB3B;
fma.rn.f32 f395, f250, 0fBE00575B, f394;
mul.f32 f396, f294, 0fBF232E38;
mul.f32 f397, f312, 0f3F45405B;
sub.f32 f398, f396, f397;
mul.f32 f399, f312, 0fBF232E38;
fma.rn.f32 f400, f294, 0f3F45405B, f399;
add.f32 f401, f148, f280;
add.f32 f402, f104, f401;
add.f32 f403, f192, f236;
add.f32 f404, f152, f284;
add.f32 f405, f108, f404;
add.f32 f406, f196, f240;
fma.rn.f32 f407, f401, 0f3E9E377A, f104;
mul.f32 f408, f403, 0f3F4F1BBD;
sub.f32 f409, f407, f408;
sub.f32 f410, f152, f284;
mul.f32 f411, f410, 0f3F737871;
sub.f32 f412, f196, f240;
mul.f32 f413, f412, 0fBF167918;
sub.f32 f414, f413, f411;
mul.f32 f415, f401, 0f3F4F1BBD;
sub.f32 f416, f104, f415;
fma.rn.f32 f417, f403, 0f3E9E377A, f416;
mul.f32 f418, f410, 0f3F167918;
mul.f32 f419, f412, 0f3F737871;
sub.f32 f420, f419, f418;
fma.rn.f32 f421, f404, 0f3E9E377A, f108;
mul.f32 f422, f406, 0f3F4F1BBD;
sub.f32 f423, f421, f422;
sub.f32 f424, f148, f280;
mul.f32 f425, f424, 0f3F737871;
sub.f32 f426, f192, f236;
mul.f32 f427, f426, 0fBF167918;
sub.f32 f428, f427, f425;
mul.f32 f429, f404, 0f3F4F1BBD;
sub.f32 f430, f108, f429;
fma.rn.f32 f431, f406, 0f3E9E377A, f430;
mul.f32 f432, f424, 0f3F167918;
mul.f32 f433, f426, 0f3F737871;
sub.f32 f434, f433, f432;
add.f32 f435, f323, f338;
add.f32 f436, f117, f435;
add.f32 f437, f328, f333;
add.f32 f438, f325, f340;
add.f32 f439, f135, f438;
add.f32 f440, f330, f335;
fma.rn.f32 f441, f435, 0f3E9E377A, f117;
mul.f32 f442, f437, 0f3F4F1BBD;
sub.f32 f443, f441, f442;
sub.f32 f444, f325, f340;
mul.f32 f445, f444, 0f3F737871;
sub.f32 f446, f330, f335;
mul.f32 f447, f446, 0fBF167918;
sub.f32 f448, f447, f445;
mul.f32 f449, f435, 0f3F4F1BBD;
sub.f32 f450, f117, f449;
fma.rn.f32 f451, f437, 0f3E9E377A, f450;
mul.f32 f452, f444, 0f3F167918;
mul.f32 f453, f446, 0f3F737871;
sub.f32 f454, f453, f452;
fma.rn.f32 f455, f438, 0f3E9E377A, f135;
mul.f32 f456, f440, 0f3F4F1BBD;
sub.f32 f457, f455, f456;
sub.f32 f458, f323, f338;
mul.f32 f459, f458, 0f3F737871;
sub.f32 f460, f328, f333;
mul.f32 f461, f460, 0fBF167918;
sub.f32 f462, f461, f459;
mul.f32 f463, f438, 0f3F4F1BBD;
sub.f32 f464, f135, f463;
fma.rn.f32 f465, f440, 0f3E9E377A, f464;
mul.f32 f466, f458, 0f3F167918;
mul.f32 f467, f460, 0f3F737871;
sub.f32 f468, f467, f466;
add.f32 f469, f343, f358;
add.f32 f470, f125, f469;
add.f32 f471, f348, f353;
add.f32 f472, f345, f360;
add.f32 f473, f143, f472;
add.f32 f474, f350, f355;
fma.rn.f32 f475, f469, 0f3E9E377A, f125;
mul.f32 f476, f471, 0f3F4F1BBD;
sub.f32 f477, f475, f476;
sub.f32 f478, f345, f360;
mul.f32 f479, f478, 0f3F737871;
sub.f32 f480, f350, f355;
mul.f32 f481, f480, 0fBF167918;
sub.f32 f482, f481, f479;
mul.f32 f483, f469, 0f3F4F1BBD;
sub.f32 f484, f125, f483;
fma.rn.f32 f485, f471, 0f3E9E377A, f484;
mul.f32 f486, f478, 0f3F167918;
mul.f32 f487, f480, 0f3F737871;
sub.f32 f488, f487, f486;
fma.rn.f32 f489, f472, 0f3E9E377A, f143;
mul.f32 f490, f474, 0f3F4F1BBD;
sub.f32 f491, f489, f490;
sub.f32 f492, f343, f358;
mul.f32 f493, f492, 0f3F737871;
sub.f32 f494, f348, f353;
mul.f32 f495, f494, 0fBF167918;
sub.f32 f496, f495, f493;
mul.f32 f497, f472, 0f3F4F1BBD;
sub.f32 f498, f143, f497;
fma.rn.f32 f499, f474, 0f3E9E377A, f498;
mul.f32 f500, f492, 0f3F167918;
mul.f32 f501, f494, 0f3F737871;
sub.f32 f502, f501, f500;
add.f32 f503, f363, f378;
add.f32 f504, f126, f503;
add.f32 f505, f368, f373;
add.f32 f506, f365, f380;
add.f32 f507, f144, f506;
add.f32 f508, f370, f375;
fma.rn.f32 f509, f503, 0f3E9E377A, f126;
mul.f32 f510, f505, 0f3F4F1BBD;
sub.f32 f511, f509, f510;
sub.f32 f512, f365, f380;
mul.f32 f513, f512, 0f3F737871;
sub.f32 f514, f370, f375;
mul.f32 f515, f514, 0fBF167918;
sub.f32 f516, f515, f513;
mul.f32 f517, f503, 0f3F4F1BBD;
sub.f32 f518, f126, f517;
fma.rn.f32 f519, f505, 0f3E9E377A, f518;
mul.f32 f520, f512, 0f3F167918;
mul.f32 f521, f514, 0f3F737871;
sub.f32 f522, f521, f520;
fma.rn.f32 f523, f506, 0f3E9E377A, f144;
mul.f32 f524, f508, 0f3F4F1BBD;
sub.f32 f525, f523, f524;
sub.f32 f526, f363, f378;
mul.f32 f527, f526, 0f3F737871;
sub.f32 f528, f368, f373;
mul.f32 f529, f528, 0fBF167918;
sub.f32 f530, f529, f527;
mul.f32 f531, f506, 0f3F4F1BBD;
sub.f32 f532, f144, f531;
fma.rn.f32 f533, f508, 0f3E9E377A, f532;
mul.f32 f534, f526, 0f3F167918;
mul.f32 f535, f528, 0f3F737871;
sub.f32 f536, f535, f534;
add.f32 f537, f383, f398;
add.f32 f538, f118, f537;
add.f32 f539, f388, f393;
add.f32 f540, f385, f400;
add.f32 f541, f136, f540;
add.f32 f542, f390, f395;
fma.rn.f32 f543, f537, 0f3E9E377A, f118;
mul.f32 f544, f539, 0f3F4F1BBD;
sub.f32 f545, f543, f544;
sub.f32 f546, f385, f400;
mul.f32 f547, f546, 0f3F737871;
sub.f32 f548, f390, f395;
mul.f32 f549, f548, 0fBF167918;
sub.f32 f550, f549, f547;
mul.f32 f551, f537, 0f3F4F1BBD;
sub.f32 f552, f118, f551;
fma.rn.f32 f553, f539, 0f3E9E377A, f552;
mul.f32 f554, f546, 0f3F167918;
mul.f32 f555, f548, 0f3F737871;
sub.f32 f556, f555, f554;
fma.rn.f32 f557, f540, 0f3E9E377A, f136;
mul.f32 f558, f542, 0f3F4F1BBD;
sub.f32 f559, f557, f558;
sub.f32 f560, f383, f398;
mul.f32 f561, f560, 0f3F737871;
sub.f32 f562, f388, f393;
mul.f32 f563, f562, 0fBF167918;
sub.f32 f564, f563, f561;
mul.f32 f565, f540, 0f3F4F1BBD;
sub.f32 f566, f136, f565;
fma.rn.f32 f567, f542, 0f3E9E377A, f566;
mul.f32 f568, f560, 0f3F167918;
mul.f32 f569, f562, 0f3F737871;
sub.f32 f570, f569, f568;
add.f32 %1, f406, f405;
add.f32 %0, f403, f402;
add.f32 %3, f440, f439;
add.f32 %2, f437, f436;
add.f32 %5, f474, f473;
add.f32 %4, f471, f470;
add.f32 %7, f508, f507;
add.f32 %6, f505, f504;
add.f32 %9, f542, f541;
add.f32 %8, f539, f538;
add.f32 %11, f428, f423;
sub.f32 %10, f409, f414;
add.f32 %13, f462, f457;
sub.f32 %12, f443, f448;
add.f32 %15, f496, f491;
sub.f32 %14, f477, f482;
add.f32 %17, f530, f525;
sub.f32 %16, f511, f516;
add.f32 %19, f564, f559;
sub.f32 %18, f545, f550;
add.f32 %21, f434, f431;
sub.f32 %20, f417, f420;
add.f32 %23, f468, f465;
sub.f32 %22, f451, f454;
add.f32 %25, f502, f499;
sub.f32 %24, f485, f488;
add.f32 %27, f536, f533;
sub.f32 %26, f519, f522;
add.f32 %29, f570, f567;
sub.f32 %28, f553, f556;
sub.f32 %31, f431, f434;
add.f32 %30, f420, f417;
sub.f32 %33, f465, f468;
add.f32 %32, f454, f451;
sub.f32 %35, f499, f502;
add.f32 %34, f488, f485;
sub.f32 %37, f533, f536;
add.f32 %36, f522, f519;
sub.f32 %39, f567, f570;
add.f32 %38, f556, f553;
sub.f32 %41, f423, f428;
add.f32 %40, f414, f409;
sub.f32 %43, f457, f462;
add.f32 %42, f448, f443;
sub.f32 %45, f491, f496;
add.f32 %44, f482, f477;
sub.f32 %47, f525, f530;
add.f32 %46, f516, f511;
sub.f32 %49, f559, f564;
add.f32 %48, f550, f545;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<156, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<168>;
.reg .b32 r<12>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 200, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %14, %22;
add.f32 f22, %12, f21;
add.f32 f23, %17, %20;
add.f32 f24, %16, %23;
add.f32 f25, %13, f24;
add.f32 f26, %19, %21;
fma.rn.f32 f27, f21, 0f3E9E377A, %12;
mul.f32 f28, f23, 0f3F4F1BBD;
sub.f32 f29, f27, f28;
sub.f32 f30, %16, %23;
mul.f32 f31, f30, 0f3F737871;
sub.f32 f32, %19, %21;
mul.f32 f33, f32, 0fBF167918;
sub.f32 f34, f33, f31;
sub.f32 f35, f29, f34;
add.f32 f36, f34, f29;
mul.f32 f37, f21, 0f3F4F1BBD;
sub.f32 f38, %12, f37;
fma.rn.f32 f39, f23, 0f3E9E377A, f38;
mul.f32 f40, f30, 0f3F167918;
mul.f32 f41, f32, 0f3F737871;
sub.f32 f42, f41, f40;
sub.f32 f43, f39, f42;
add.f32 f44, f42, f39;
fma.rn.f32 f45, f24, 0f3E9E377A, %13;
mul.f32 f46, f26, 0f3F4F1BBD;
sub.f32 f47, f45, f46;
sub.f32 f48, %14, %22;
mul.f32 f49, f48, 0f3F737871;
sub.f32 f50, %17, %20;
mul.f32 f51, f50, 0fBF167918;
sub.f32 f52, f51, f49;
add.f32 f53, f52, f47;
sub.f32 f54, f47, f52;
mul.f32 f55, f24, 0f3F4F1BBD;
sub.f32 f56, %13, f55;
fma.rn.f32 f57, f26, 0f3E9E377A, f56;
mul.f32 f58, f48, 0f3F167918;
mul.f32 f59, f50, 0f3F737871;
sub.f32 f60, f59, f58;
add.f32 f61, f60, f57;
sub.f32 f62, f57, f60;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 200, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f63, f64}, [rd6];
mul.f32 f67, f63, f35;
mul.f32 f68, f64, f53;
mul.f32 f69, f63, f53;
mul.f32 f70, f63, f63;
mul.f32 f71, f64, f64;
sub.f32 f72, f70, f71;
mul.f32 f73, f64, f63;
fma.rn.f32 f74, f64, f63, f73;
mul.f32 f75, f72, f43;
mul.f32 f76, f74, f61;
mul.f32 f77, f72, f61;
mul.f32 f78, f63, f72;
mul.f32 f79, f64, f74;
sub.f32 f80, f78, f79;
mul.f32 f81, f63, f74;
fma.rn.f32 f82, f64, f72, f81;
mul.f32 f83, f80, f44;
mul.f32 f84, f82, f62;
mul.f32 f85, f80, f62;
mul.f32 f86, f63, f80;
mul.f32 f87, f64, f82;
sub.f32 f88, f86, f87;
mul.f32 f89, f63, f82;
fma.rn.f32 f90, f64, f80, f89;
mul.f32 f91, f88, f36;
mul.f32 f92, f90, f54;
mul.f32 f93, f88, f54;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
add.f32 f94, f26, f25;
add.f32 f95, f23, f22;
st.shared.v2.f32 [r9], {f95, f94};
fma.rn.f32 f96, f64, f35, f69;
sub.f32 f97, f67, f68;
st.shared.v2.f32 [r9+8], {f97, f96};
fma.rn.f32 f98, f74, f43, f77;
sub.f32 f99, f75, f76;
st.shared.v2.f32 [r9+16], {f99, f98};
sub.f32 f100, f83, f84;
fma.rn.f32 f101, f82, f44, f85;
st.shared.v2.f32 [r9+24], {f100, f101};
fma.rn.f32 f102, f90, f36, f93;
sub.f32 f103, f91, f92;
st.shared.v2.f32 [r9+32], {f103, f102};
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.v2.f32 {f104, f105}, [r11];
ld.shared.v2.f32 {f108, f109}, [r11+40];
ld.shared.v2.f32 {f112, f113}, [r11+80];
ld.shared.v2.f32 {f116, f117}, [r11+120];
ld.shared.v2.f32 {f120, f121}, [r11+160];
add.f32 f124, f108, f120;
add.f32 f125, f104, f124;
add.f32 f126, f112, f116;
add.f32 f127, f109, f121;
add.f32 f128, f105, f127;
add.f32 f129, f113, f117;
fma.rn.f32 f130, f124, 0f3E9E377A, f104;
mul.f32 f131, f126, 0f3F4F1BBD;
sub.f32 f132, f130, f131;
sub.f32 f133, f109, f121;
mul.f32 f134, f133, 0f3F737871;
sub.f32 f135, f113, f117;
mul.f32 f136, f135, 0fBF167918;
sub.f32 f137, f136, f134;
mul.f32 f138, f124, 0f3F4F1BBD;
sub.f32 f139, f104, f138;
fma.rn.f32 f140, f126, 0f3E9E377A, f139;
mul.f32 f141, f133, 0f3F167918;
mul.f32 f142, f135, 0f3F737871;
sub.f32 f143, f142, f141;
fma.rn.f32 f144, f127, 0f3E9E377A, f105;
mul.f32 f145, f129, 0f3F4F1BBD;
sub.f32 f146, f144, f145;
sub.f32 f147, f108, f120;
mul.f32 f148, f147, 0f3F737871;
sub.f32 f149, f112, f116;
mul.f32 f150, f149, 0fBF167918;
sub.f32 f151, f150, f148;
mul.f32 f152, f127, 0f3F4F1BBD;
sub.f32 f153, f105, f152;
fma.rn.f32 f154, f129, 0f3E9E377A, f153;
mul.f32 f155, f147, 0f3F167918;
mul.f32 f156, f149, 0f3F737871;
sub.f32 f157, f156, f155;
add.f32 %1, f129, f128;
add.f32 %0, f126, f125;
add.f32 %3, f151, f146;
sub.f32 %2, f132, f137;
add.f32 %5, f157, f154;
sub.f32 %4, f140, f143;
sub.f32 %7, f154, f157;
add.f32 %6, f143, f140;
sub.f32 %9, f146, f151;
add.f32 %8, f137, f132;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<157, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<158>;
.reg .b32 r<12>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 100, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %14, %22;
add.f32 f22, %12, f21;
add.f32 f23, %17, %20;
add.f32 f24, f23, f22;
add.f32 f25, %16, %23;
add.f32 f26, %13, f25;
add.f32 f27, %19, %21;
add.f32 f28, f27, f26;
fma.rn.f32 f29, f21, 0f3E9E377A, %12;
mul.f32 f30, f23, 0f3F4F1BBD;
sub.f32 f31, f29, f30;
sub.f32 f32, %16, %23;
mul.f32 f33, f32, 0f3F737871;
sub.f32 f34, %19, %21;
mul.f32 f35, f34, 0fBF167918;
sub.f32 f36, f35, f33;
sub.f32 f37, f31, f36;
add.f32 f38, f36, f31;
mul.f32 f39, f21, 0f3F4F1BBD;
sub.f32 f40, %12, f39;
fma.rn.f32 f41, f23, 0f3E9E377A, f40;
mul.f32 f42, f32, 0f3F167918;
mul.f32 f43, f34, 0f3F737871;
sub.f32 f44, f43, f42;
sub.f32 f45, f41, f44;
add.f32 f46, f44, f41;
fma.rn.f32 f47, f25, 0f3E9E377A, %13;
mul.f32 f48, f27, 0f3F4F1BBD;
sub.f32 f49, f47, f48;
sub.f32 f50, %14, %22;
mul.f32 f51, f50, 0f3F737871;
sub.f32 f52, %17, %20;
mul.f32 f53, f52, 0fBF167918;
sub.f32 f54, f53, f51;
add.f32 f55, f54, f49;
sub.f32 f56, f49, f54;
mul.f32 f57, f25, 0f3F4F1BBD;
sub.f32 f58, %13, f57;
fma.rn.f32 f59, f27, 0f3E9E377A, f58;
mul.f32 f60, f50, 0f3F167918;
mul.f32 f61, f52, 0f3F737871;
sub.f32 f62, f61, f60;
add.f32 f63, f62, f59;
sub.f32 f64, f59, f62;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f65, f66}, [rd6];
mul.f32 f69, f65, f37;
mul.f32 f70, f66, f55;
sub.f32 f71, f69, f70;
mul.f32 f72, f65, f55;
fma.rn.f32 f73, f66, f37, f72;
mul.f32 f74, f65, f65;
mul.f32 f75, f66, f66;
sub.f32 f76, f74, f75;
mul.f32 f77, f66, f65;
fma.rn.f32 f78, f66, f65, f77;
mul.f32 f79, f76, f45;
mul.f32 f80, f78, f63;
sub.f32 f81, f79, f80;
mul.f32 f82, f76, f63;
fma.rn.f32 f83, f78, f45, f82;
mul.f32 f84, f65, f76;
mul.f32 f85, f66, f78;
sub.f32 f86, f84, f85;
mul.f32 f87, f65, f78;
fma.rn.f32 f88, f66, f76, f87;
mul.f32 f89, f86, f46;
mul.f32 f90, f88, f64;
sub.f32 f91, f89, f90;
mul.f32 f92, f86, f64;
fma.rn.f32 f93, f88, f46, f92;
mul.f32 f94, f65, f86;
mul.f32 f95, f66, f88;
sub.f32 f96, f94, f95;
mul.f32 f97, f65, f88;
fma.rn.f32 f98, f66, f86, f97;
mul.f32 f99, f96, f38;
mul.f32 f100, f98, f56;
sub.f32 f101, f99, f100;
mul.f32 f102, f96, f56;
fma.rn.f32 f103, f98, f38, f102;
mad.lo.s32 r8, r5, 100, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 20, r8;
st.shared.f32 [r9], f24;
st.shared.f32 [r9+4], f71;
st.shared.f32 [r9+8], f81;
st.shared.f32 [r9+12], f91;
st.shared.f32 [r9+16], f101;
barrier.sync 0;
shl.b32 r10, r7, 4;
sub.s32 r11, r9, r10;
ld.shared.f32 f104, [r11];
ld.shared.f32 f105, [r11+20];
ld.shared.f32 f106, [r11+40];
ld.shared.f32 f107, [r11+60];
ld.shared.f32 f108, [r11+80];
barrier.sync 0;
st.shared.f32 [r9], f28;
st.shared.f32 [r9+4], f73;
st.shared.f32 [r9+8], f83;
st.shared.f32 [r9+12], f93;
st.shared.f32 [r9+16], f103;
barrier.sync 0;
ld.shared.f32 f109, [r11];
ld.shared.f32 f110, [r11+20];
ld.shared.f32 f111, [r11+40];
ld.shared.f32 f112, [r11+60];
ld.shared.f32 f113, [r11+80];
add.f32 f114, f105, f108;
add.f32 f115, f104, f114;
add.f32 f116, f106, f107;
add.f32 f117, f110, f113;
add.f32 f118, f109, f117;
add.f32 f119, f111, f112;
fma.rn.f32 f120, f114, 0f3E9E377A, f104;
mul.f32 f121, f116, 0f3F4F1BBD;
sub.f32 f122, f120, f121;
sub.f32 f123, f110, f113;
mul.f32 f124, f123, 0f3F737871;
sub.f32 f125, f111, f112;
mul.f32 f126, f125, 0fBF167918;
sub.f32 f127, f126, f124;
mul.f32 f128, f114, 0f3F4F1BBD;
sub.f32 f129, f104, f128;
fma.rn.f32 f130, f116, 0f3E9E377A, f129;
mul.f32 f131, f123, 0f3F167918;
mul.f32 f132, f125, 0f3F737871;
sub.f32 f133, f132, f131;
fma.rn.f32 f134, f117, 0f3E9E377A, f109;
mul.f32 f135, f119, 0f3F4F1BBD;
sub.f32 f136, f134, f135;
sub.f32 f137, f105, f108;
mul.f32 f138, f137, 0f3F737871;
sub.f32 f139, f106, f107;
mul.f32 f140, f139, 0fBF167918;
sub.f32 f141, f140, f138;
mul.f32 f142, f117, 0f3F4F1BBD;
sub.f32 f143, f109, f142;
fma.rn.f32 f144, f119, 0f3E9E377A, f143;
mul.f32 f145, f137, 0f3F167918;
mul.f32 f146, f139, 0f3F737871;
sub.f32 f147, f146, f145;
add.f32 %0, f116, f115;
add.f32 %1, f119, f118;
add.f32 %3, f141, f136;
sub.f32 %2, f122, f127;
sub.f32 %4, f130, f133;
add.f32 %5, f147, f144;
add.f32 %6, f133, f130;
sub.f32 %7, f144, f147;
sub.f32 %9, f136, f141;
add.f32 %8, f127, f122;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};


#endif
