#ifndef CUFFTDX_FFT_26_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_26_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<213, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<734>;
.reg .b64 rd<7>;
add.f32 f105, %57, %101;
sub.f32 f107, %57, %101;
add.f32 f730, %105, %102;
sub.f32 f108, %105, %102;
add.f32 f109, %61, %97;
sub.f32 f111, %61, %97;
add.f32 f727, %106, %107;
sub.f32 f112, %106, %107;
add.f32 f113, %65, %93;
sub.f32 f115, %65, %93;
add.f32 f725, %66, %108;
sub.f32 f116, %66, %108;
add.f32 f117, %69, %89;
sub.f32 f119, %69, %89;
add.f32 f723, %109, %90;
sub.f32 f120, %109, %90;
add.f32 f121, %73, %85;
sub.f32 f123, %73, %85;
add.f32 f720, %110, %111;
sub.f32 f124, %110, %111;
add.f32 f125, %77, %81;
sub.f32 f127, %77, %81;
add.f32 f718, %78, %112;
sub.f32 f128, %78, %112;
add.f32 f129, %53, f105;
add.f32 f131, f129, f109;
add.f32 f717, %54, f730;
add.f32 f132, f717, f727;
add.f32 f133, f131, f113;
add.f32 f134, f132, f725;
add.f32 f135, f133, f117;
add.f32 f136, f134, f723;
add.f32 f137, f135, f121;
add.f32 f138, f136, f720;
add.f32 f139, f137, f125;
add.f32 f140, f138, f718;
fma.rn.f32 f141, f105, 0f3F62AD3F, %53;
fma.rn.f32 f145, f109, 0f3F116CB1, f141;
fma.rn.f32 f716, f108, 0f3EEDF032, 0f00000000;
fma.rn.f32 f146, f112, 0f3F52AF12, f716;
fma.rn.f32 f715, f730, 0f3F62AD3F, %54;
fma.rn.f32 f147, f727, 0f3F116CB1, f715;
fma.rn.f32 f714, f107, 0f3EEDF032, 0f00000000;
fma.rn.f32 f148, f111, 0f3F52AF12, f714;
fma.rn.f32 f149, f113, 0f3DF6DBEF, f145;
fma.rn.f32 f150, f116, 0f3F7E222B, f146;
fma.rn.f32 f151, f725, 0f3DF6DBEF, f147;
fma.rn.f32 f152, f115, 0f3F7E222B, f148;
fma.rn.f32 f153, f117, 0fBEB58EC6, f149;
fma.rn.f32 f154, f120, 0f3F6F5D39, f150;
fma.rn.f32 f155, f723, 0fBEB58EC6, f151;
fma.rn.f32 f156, f119, 0f3F6F5D39, f152;
fma.rn.f32 f157, f121, 0fBF3F9E67, f153;
fma.rn.f32 f158, f124, 0f3F29C268, f154;
fma.rn.f32 f159, f720, 0fBF3F9E67, f155;
fma.rn.f32 f160, f123, 0f3F29C268, f156;
fma.rn.f32 f161, f125, 0fBF788FA5, f157;
fma.rn.f32 f162, f128, 0f3E750F2A, f158;
fma.rn.f32 f163, f718, 0fBF788FA5, f159;
fma.rn.f32 f164, f127, 0f3E750F2A, f160;
sub.f32 f165, f161, f162;
add.f32 f167, f162, f161;
add.f32 f713, f164, f163;
sub.f32 f168, f163, f164;
fma.rn.f32 f169, f105, 0f3F116CB1, %53;
fma.rn.f32 f173, f109, 0fBEB58EC6, f169;
fma.rn.f32 f712, f108, 0f3F52AF12, 0f00000000;
fma.rn.f32 f174, f112, 0f3F6F5D39, f712;
fma.rn.f32 f711, f730, 0f3F116CB1, %54;
fma.rn.f32 f175, f727, 0fBEB58EC6, f711;
fma.rn.f32 f710, f107, 0f3F52AF12, 0f00000000;
fma.rn.f32 f176, f111, 0f3F6F5D39, f710;
fma.rn.f32 f177, f113, 0fBF788FA5, f173;
fma.rn.f32 f178, f116, 0f3E750F2A, f174;
fma.rn.f32 f179, f725, 0fBF788FA5, f175;
fma.rn.f32 f180, f115, 0f3E750F2A, f176;
fma.rn.f32 f181, f117, 0fBF3F9E67, f177;
fma.rn.f32 f182, f120, 0fBF29C268, f178;
fma.rn.f32 f183, f723, 0fBF3F9E67, f179;
fma.rn.f32 f184, f119, 0fBF29C268, f180;
fma.rn.f32 f185, f121, 0f3DF6DBEF, f181;
fma.rn.f32 f186, f124, 0fBF7E222B, f182;
fma.rn.f32 f187, f720, 0f3DF6DBEF, f183;
fma.rn.f32 f188, f123, 0fBF7E222B, f184;
fma.rn.f32 f189, f125, 0f3F62AD3F, f185;
fma.rn.f32 f190, f128, 0fBEEDF032, f186;
fma.rn.f32 f191, f718, 0f3F62AD3F, f187;
fma.rn.f32 f192, f127, 0fBEEDF032, f188;
sub.f32 f193, f189, f190;
add.f32 f195, f190, f189;
add.f32 f709, f192, f191;
sub.f32 f196, f191, f192;
fma.rn.f32 f197, f105, 0f3DF6DBEF, %53;
fma.rn.f32 f201, f109, 0fBF788FA5, f197;
fma.rn.f32 f708, f108, 0f3F7E222B, 0f00000000;
fma.rn.f32 f202, f112, 0f3E750F2A, f708;
fma.rn.f32 f707, f730, 0f3DF6DBEF, %54;
fma.rn.f32 f203, f727, 0fBF788FA5, f707;
fma.rn.f32 f706, f107, 0f3F7E222B, 0f00000000;
fma.rn.f32 f204, f111, 0f3E750F2A, f706;
fma.rn.f32 f205, f113, 0fBEB58EC6, f201;
fma.rn.f32 f206, f116, 0fBF6F5D39, f202;
fma.rn.f32 f207, f725, 0fBEB58EC6, f203;
fma.rn.f32 f208, f115, 0fBF6F5D39, f204;
fma.rn.f32 f209, f117, 0f3F62AD3F, f205;
fma.rn.f32 f210, f120, 0fBEEDF032, f206;
fma.rn.f32 f211, f723, 0f3F62AD3F, f207;
fma.rn.f32 f212, f119, 0fBEEDF032, f208;
fma.rn.f32 f213, f121, 0f3F116CB1, f209;
fma.rn.f32 f214, f124, 0f3F52AF12, f210;
fma.rn.f32 f215, f720, 0f3F116CB1, f211;
fma.rn.f32 f216, f123, 0f3F52AF12, f212;
fma.rn.f32 f217, f125, 0fBF3F9E67, f213;
fma.rn.f32 f218, f128, 0f3F29C268, f214;
fma.rn.f32 f219, f718, 0fBF3F9E67, f215;
fma.rn.f32 f220, f127, 0f3F29C268, f216;
sub.f32 f221, f217, f218;
add.f32 f223, f218, f217;
add.f32 f705, f220, f219;
sub.f32 f224, f219, f220;
fma.rn.f32 f225, f105, 0fBEB58EC6, %53;
fma.rn.f32 f229, f109, 0fBF3F9E67, f225;
fma.rn.f32 f704, f108, 0f3F6F5D39, 0f00000000;
fma.rn.f32 f230, f112, 0fBF29C268, f704;
fma.rn.f32 f703, f730, 0fBEB58EC6, %54;
fma.rn.f32 f231, f727, 0fBF3F9E67, f703;
fma.rn.f32 f702, f107, 0f3F6F5D39, 0f00000000;
fma.rn.f32 f232, f111, 0fBF29C268, f702;
fma.rn.f32 f233, f113, 0f3F62AD3F, f229;
fma.rn.f32 f234, f116, 0fBEEDF032, f230;
fma.rn.f32 f235, f725, 0f3F62AD3F, f231;
fma.rn.f32 f236, f115, 0fBEEDF032, f232;
fma.rn.f32 f237, f117, 0f3DF6DBEF, f233;
fma.rn.f32 f238, f120, 0f3F7E222B, f234;
fma.rn.f32 f239, f723, 0f3DF6DBEF, f235;
fma.rn.f32 f240, f119, 0f3F7E222B, f236;
fma.rn.f32 f241, f121, 0fBF788FA5, f237;
fma.rn.f32 f242, f124, 0fBE750F2A, f238;
fma.rn.f32 f243, f720, 0fBF788FA5, f239;
fma.rn.f32 f244, f123, 0fBE750F2A, f240;
fma.rn.f32 f245, f125, 0f3F116CB1, f241;
fma.rn.f32 f246, f128, 0fBF52AF12, f242;
fma.rn.f32 f247, f718, 0f3F116CB1, f243;
fma.rn.f32 f248, f127, 0fBF52AF12, f244;
sub.f32 f249, f245, f246;
add.f32 f251, f246, f245;
add.f32 f701, f248, f247;
sub.f32 f252, f247, f248;
fma.rn.f32 f253, f105, 0fBF3F9E67, %53;
fma.rn.f32 f257, f109, 0f3DF6DBEF, f253;
fma.rn.f32 f700, f108, 0f3F29C268, 0f00000000;
fma.rn.f32 f258, f112, 0fBF7E222B, f700;
fma.rn.f32 f699, f730, 0fBF3F9E67, %54;
fma.rn.f32 f259, f727, 0f3DF6DBEF, f699;
fma.rn.f32 f698, f107, 0f3F29C268, 0f00000000;
fma.rn.f32 f260, f111, 0fBF7E222B, f698;
fma.rn.f32 f261, f113, 0f3F116CB1, f257;
fma.rn.f32 f262, f116, 0f3F52AF12, f258;
fma.rn.f32 f263, f725, 0f3F116CB1, f259;
fma.rn.f32 f264, f115, 0f3F52AF12, f260;
fma.rn.f32 f265, f117, 0fBF788FA5, f261;
fma.rn.f32 f266, f120, 0fBE750F2A, f262;
fma.rn.f32 f267, f723, 0fBF788FA5, f263;
fma.rn.f32 f268, f119, 0fBE750F2A, f264;
fma.rn.f32 f269, f121, 0f3F62AD3F, f265;
fma.rn.f32 f270, f124, 0fBEEDF032, f266;
fma.rn.f32 f271, f720, 0f3F62AD3F, f267;
fma.rn.f32 f272, f123, 0fBEEDF032, f268;
fma.rn.f32 f273, f125, 0fBEB58EC6, f269;
fma.rn.f32 f274, f128, 0f3F6F5D39, f270;
fma.rn.f32 f275, f718, 0fBEB58EC6, f271;
fma.rn.f32 f276, f127, 0f3F6F5D39, f272;
sub.f32 f277, f273, f274;
add.f32 f279, f274, f273;
add.f32 f697, f276, f275;
sub.f32 f280, f275, f276;
fma.rn.f32 f281, f105, 0fBF788FA5, %53;
fma.rn.f32 f282, f108, 0f3E750F2A, 0f00000000;
fma.rn.f32 f283, f730, 0fBF788FA5, %54;
fma.rn.f32 f284, f107, 0f3E750F2A, 0f00000000;
fma.rn.f32 f285, f109, 0f3F62AD3F, f281;
fma.rn.f32 f286, f112, 0fBEEDF032, f282;
fma.rn.f32 f287, f727, 0f3F62AD3F, f283;
fma.rn.f32 f288, f111, 0fBEEDF032, f284;
fma.rn.f32 f289, f113, 0fBF3F9E67, f285;
fma.rn.f32 f290, f116, 0f3F29C268, f286;
fma.rn.f32 f291, f725, 0fBF3F9E67, f287;
fma.rn.f32 f292, f115, 0f3F29C268, f288;
fma.rn.f32 f293, f117, 0f3F116CB1, f289;
fma.rn.f32 f294, f120, 0fBF52AF12, f290;
fma.rn.f32 f295, f723, 0f3F116CB1, f291;
fma.rn.f32 f296, f119, 0fBF52AF12, f292;
fma.rn.f32 f297, f121, 0fBEB58EC6, f293;
fma.rn.f32 f298, f124, 0f3F6F5D39, f294;
fma.rn.f32 f299, f720, 0fBEB58EC6, f295;
fma.rn.f32 f300, f123, 0f3F6F5D39, f296;
fma.rn.f32 f301, f125, 0f3DF6DBEF, f297;
fma.rn.f32 f302, f128, 0fBF7E222B, f298;
fma.rn.f32 f303, f718, 0f3DF6DBEF, f299;
fma.rn.f32 f304, f127, 0fBF7E222B, f300;
sub.f32 f305, f301, f302;
add.f32 f307, f302, f301;
add.f32 f696, f304, f303;
sub.f32 f308, f303, f304;
add.f32 f309, %59, %103;
sub.f32 f311, %59, %103;
add.f32 f695, %60, %104;
sub.f32 f312, %60, %104;
add.f32 f313, %63, %99;
sub.f32 f315, %63, %99;
add.f32 f692, %114, %113;
sub.f32 f316, %114, %113;
add.f32 f317, %67, %95;
sub.f32 f319, %67, %95;
add.f32 f690, %115, %96;
sub.f32 f320, %115, %96;
add.f32 f321, %71, %91;
sub.f32 f323, %71, %91;
add.f32 f688, %72, %116;
sub.f32 f324, %72, %116;
add.f32 f325, %75, %87;
sub.f32 f327, %75, %87;
add.f32 f685, %117, %118;
sub.f32 f328, %117, %118;
add.f32 f329, %79, %83;
sub.f32 f331, %79, %83;
add.f32 f683, %119, %84;
sub.f32 f332, %119, %84;
add.f32 f333, %55, f309;
add.f32 f335, f333, f313;
add.f32 f681, %120, f695;
add.f32 f336, f681, f692;
add.f32 f337, f335, f317;
add.f32 f338, f336, f690;
add.f32 f339, f337, f321;
add.f32 f340, f338, f688;
add.f32 f341, f339, f325;
add.f32 f342, f340, f685;
add.f32 f343, f341, f329;
add.f32 f344, f342, f683;
fma.rn.f32 f345, f309, 0f3F62AD3F, %55;
fma.rn.f32 f349, f313, 0f3F116CB1, f345;
fma.rn.f32 f680, f312, 0f3EEDF032, 0f00000000;
fma.rn.f32 f350, f316, 0f3F52AF12, f680;
fma.rn.f32 f679, f695, 0f3F62AD3F, %120;
fma.rn.f32 f351, f692, 0f3F116CB1, f679;
fma.rn.f32 f678, f311, 0f3EEDF032, 0f00000000;
fma.rn.f32 f352, f315, 0f3F52AF12, f678;
fma.rn.f32 f353, f317, 0f3DF6DBEF, f349;
fma.rn.f32 f354, f320, 0f3F7E222B, f350;
fma.rn.f32 f355, f690, 0f3DF6DBEF, f351;
fma.rn.f32 f356, f319, 0f3F7E222B, f352;
fma.rn.f32 f357, f321, 0fBEB58EC6, f353;
fma.rn.f32 f358, f324, 0f3F6F5D39, f354;
fma.rn.f32 f359, f688, 0fBEB58EC6, f355;
fma.rn.f32 f360, f323, 0f3F6F5D39, f356;
fma.rn.f32 f361, f325, 0fBF3F9E67, f357;
fma.rn.f32 f362, f328, 0f3F29C268, f358;
fma.rn.f32 f363, f685, 0fBF3F9E67, f359;
fma.rn.f32 f364, f327, 0f3F29C268, f360;
fma.rn.f32 f365, f329, 0fBF788FA5, f361;
fma.rn.f32 f366, f332, 0f3E750F2A, f362;
fma.rn.f32 f367, f683, 0fBF788FA5, f363;
fma.rn.f32 f368, f331, 0f3E750F2A, f364;
sub.f32 f369, f365, f366;
add.f32 f371, f366, f365;
add.f32 f677, f368, f367;
sub.f32 f372, f367, f368;
fma.rn.f32 f373, f309, 0f3F116CB1, %55;
fma.rn.f32 f377, f313, 0fBEB58EC6, f373;
fma.rn.f32 f676, f312, 0f3F52AF12, 0f00000000;
fma.rn.f32 f378, f316, 0f3F6F5D39, f676;
fma.rn.f32 f675, f695, 0f3F116CB1, %120;
fma.rn.f32 f379, f692, 0fBEB58EC6, f675;
fma.rn.f32 f674, f311, 0f3F52AF12, 0f00000000;
fma.rn.f32 f380, f315, 0f3F6F5D39, f674;
fma.rn.f32 f381, f317, 0fBF788FA5, f377;
fma.rn.f32 f382, f320, 0f3E750F2A, f378;
fma.rn.f32 f383, f690, 0fBF788FA5, f379;
fma.rn.f32 f384, f319, 0f3E750F2A, f380;
fma.rn.f32 f385, f321, 0fBF3F9E67, f381;
fma.rn.f32 f386, f324, 0fBF29C268, f382;
fma.rn.f32 f387, f688, 0fBF3F9E67, f383;
fma.rn.f32 f388, f323, 0fBF29C268, f384;
fma.rn.f32 f389, f325, 0f3DF6DBEF, f385;
fma.rn.f32 f390, f328, 0fBF7E222B, f386;
fma.rn.f32 f391, f685, 0f3DF6DBEF, f387;
fma.rn.f32 f392, f327, 0fBF7E222B, f388;
fma.rn.f32 f393, f329, 0f3F62AD3F, f389;
fma.rn.f32 f394, f332, 0fBEEDF032, f390;
fma.rn.f32 f395, f683, 0f3F62AD3F, f391;
fma.rn.f32 f396, f331, 0fBEEDF032, f392;
sub.f32 f397, f393, f394;
add.f32 f399, f394, f393;
add.f32 f673, f396, f395;
sub.f32 f400, f395, f396;
fma.rn.f32 f401, f309, 0f3DF6DBEF, %55;
fma.rn.f32 f405, f313, 0fBF788FA5, f401;
fma.rn.f32 f672, f312, 0f3F7E222B, 0f00000000;
fma.rn.f32 f406, f316, 0f3E750F2A, f672;
fma.rn.f32 f671, f695, 0f3DF6DBEF, %120;
fma.rn.f32 f407, f692, 0fBF788FA5, f671;
fma.rn.f32 f670, f311, 0f3F7E222B, 0f00000000;
fma.rn.f32 f408, f315, 0f3E750F2A, f670;
fma.rn.f32 f409, f317, 0fBEB58EC6, f405;
fma.rn.f32 f410, f320, 0fBF6F5D39, f406;
fma.rn.f32 f411, f690, 0fBEB58EC6, f407;
fma.rn.f32 f412, f319, 0fBF6F5D39, f408;
fma.rn.f32 f413, f321, 0f3F62AD3F, f409;
fma.rn.f32 f414, f324, 0fBEEDF032, f410;
fma.rn.f32 f415, f688, 0f3F62AD3F, f411;
fma.rn.f32 f416, f323, 0fBEEDF032, f412;
fma.rn.f32 f417, f325, 0f3F116CB1, f413;
fma.rn.f32 f418, f328, 0f3F52AF12, f414;
fma.rn.f32 f419, f685, 0f3F116CB1, f415;
fma.rn.f32 f420, f327, 0f3F52AF12, f416;
fma.rn.f32 f421, f329, 0fBF3F9E67, f417;
fma.rn.f32 f422, f332, 0f3F29C268, f418;
fma.rn.f32 f423, f683, 0fBF3F9E67, f419;
fma.rn.f32 f424, f331, 0f3F29C268, f420;
sub.f32 f425, f421, f422;
add.f32 f427, f422, f421;
add.f32 f669, f424, f423;
sub.f32 f428, f423, f424;
fma.rn.f32 f429, f309, 0fBEB58EC6, %55;
fma.rn.f32 f433, f313, 0fBF3F9E67, f429;
fma.rn.f32 f668, f312, 0f3F6F5D39, 0f00000000;
fma.rn.f32 f434, f316, 0fBF29C268, f668;
fma.rn.f32 f667, f695, 0fBEB58EC6, %120;
fma.rn.f32 f435, f692, 0fBF3F9E67, f667;
fma.rn.f32 f666, f311, 0f3F6F5D39, 0f00000000;
fma.rn.f32 f436, f315, 0fBF29C268, f666;
fma.rn.f32 f437, f317, 0f3F62AD3F, f433;
fma.rn.f32 f438, f320, 0fBEEDF032, f434;
fma.rn.f32 f439, f690, 0f3F62AD3F, f435;
fma.rn.f32 f440, f319, 0fBEEDF032, f436;
fma.rn.f32 f441, f321, 0f3DF6DBEF, f437;
fma.rn.f32 f442, f324, 0f3F7E222B, f438;
fma.rn.f32 f443, f688, 0f3DF6DBEF, f439;
fma.rn.f32 f444, f323, 0f3F7E222B, f440;
fma.rn.f32 f445, f325, 0fBF788FA5, f441;
fma.rn.f32 f446, f328, 0fBE750F2A, f442;
fma.rn.f32 f447, f685, 0fBF788FA5, f443;
fma.rn.f32 f448, f327, 0fBE750F2A, f444;
fma.rn.f32 f449, f329, 0f3F116CB1, f445;
fma.rn.f32 f450, f332, 0fBF52AF12, f446;
fma.rn.f32 f451, f683, 0f3F116CB1, f447;
fma.rn.f32 f452, f331, 0fBF52AF12, f448;
sub.f32 f453, f449, f450;
add.f32 f455, f450, f449;
add.f32 f665, f452, f451;
sub.f32 f456, f451, f452;
fma.rn.f32 f457, f309, 0fBF3F9E67, %55;
fma.rn.f32 f461, f313, 0f3DF6DBEF, f457;
fma.rn.f32 f664, f312, 0f3F29C268, 0f00000000;
fma.rn.f32 f462, f316, 0fBF7E222B, f664;
fma.rn.f32 f663, f695, 0fBF3F9E67, %120;
fma.rn.f32 f463, f692, 0f3DF6DBEF, f663;
fma.rn.f32 f662, f311, 0f3F29C268, 0f00000000;
fma.rn.f32 f464, f315, 0fBF7E222B, f662;
fma.rn.f32 f465, f317, 0f3F116CB1, f461;
fma.rn.f32 f466, f320, 0f3F52AF12, f462;
fma.rn.f32 f467, f690, 0f3F116CB1, f463;
fma.rn.f32 f468, f319, 0f3F52AF12, f464;
fma.rn.f32 f469, f321, 0fBF788FA5, f465;
fma.rn.f32 f470, f324, 0fBE750F2A, f466;
fma.rn.f32 f471, f688, 0fBF788FA5, f467;
fma.rn.f32 f472, f323, 0fBE750F2A, f468;
fma.rn.f32 f473, f325, 0f3F62AD3F, f469;
fma.rn.f32 f474, f328, 0fBEEDF032, f470;
fma.rn.f32 f475, f685, 0f3F62AD3F, f471;
fma.rn.f32 f476, f327, 0fBEEDF032, f472;
fma.rn.f32 f477, f329, 0fBEB58EC6, f473;
fma.rn.f32 f478, f332, 0f3F6F5D39, f474;
fma.rn.f32 f479, f683, 0fBEB58EC6, f475;
fma.rn.f32 f480, f331, 0f3F6F5D39, f476;
sub.f32 f481, f477, f478;
add.f32 f483, f478, f477;
add.f32 f661, f480, f479;
sub.f32 f484, f479, f480;
fma.rn.f32 f485, f309, 0fBF788FA5, %55;
fma.rn.f32 f486, f312, 0f3E750F2A, 0f00000000;
fma.rn.f32 f487, f695, 0fBF788FA5, %52;
fma.rn.f32 f488, f311, 0f3E750F2A, 0f00000000;
fma.rn.f32 f489, f313, 0f3F62AD3F, f485;
fma.rn.f32 f490, f316, 0fBEEDF032, f486;
fma.rn.f32 f491, f692, 0f3F62AD3F, f487;
fma.rn.f32 f492, f315, 0fBEEDF032, f488;
fma.rn.f32 f493, f317, 0fBF3F9E67, f489;
fma.rn.f32 f494, f320, 0f3F29C268, f490;
fma.rn.f32 f495, f690, 0fBF3F9E67, f491;
fma.rn.f32 f496, f319, 0f3F29C268, f492;
fma.rn.f32 f497, f321, 0f3F116CB1, f493;
fma.rn.f32 f498, f324, 0fBF52AF12, f494;
fma.rn.f32 f499, f688, 0f3F116CB1, f495;
fma.rn.f32 f500, f323, 0fBF52AF12, f496;
fma.rn.f32 f501, f325, 0fBEB58EC6, f497;
fma.rn.f32 f502, f328, 0f3F6F5D39, f498;
fma.rn.f32 f503, f685, 0fBEB58EC6, f499;
fma.rn.f32 f504, f327, 0f3F6F5D39, f500;
fma.rn.f32 f505, f329, 0f3DF6DBEF, f501;
fma.rn.f32 f506, f332, 0fBF7E222B, f502;
fma.rn.f32 f507, f683, 0f3DF6DBEF, f503;
fma.rn.f32 f508, f331, 0fBF7E222B, f504;
sub.f32 f509, f505, f506;
add.f32 f511, f506, f505;
add.f32 f660, f508, f507;
sub.f32 f512, f507, f508;
mul.f32 f514, f677, 0f3E750F2A;
mul.f32 f659, f369, 0f3F788FA5;
sub.f32 f515, f659, f514;
mul.f32 f516, f677, 0f3F788FA5;
fma.rn.f32 f517, f369, 0f3E750F2A, f516;
mul.f32 f519, f673, 0f3EEDF032;
mul.f32 f658, f397, 0f3F62AD3F;
sub.f32 f520, f658, f519;
mul.f32 f521, f673, 0f3F62AD3F;
fma.rn.f32 f522, f397, 0f3EEDF032, f521;
mul.f32 f656, f425, 0f3F3F9E67;
mul.f32 f657, f669, 0f3F29C268;
sub.f32 f525, f656, f657;
mul.f32 f526, f669, 0f3F3F9E67;
fma.rn.f32 f527, f425, 0f3F29C268, f526;
mul.f32 f654, f453, 0f3F116CB1;
mul.f32 f655, f665, 0f3F52AF12;
sub.f32 f530, f654, f655;
mul.f32 f531, f665, 0f3F116CB1;
fma.rn.f32 f532, f453, 0f3F52AF12, f531;
mul.f32 f652, f481, 0f3EB58EC6;
mul.f32 f653, f661, 0f3F6F5D39;
sub.f32 f535, f652, f653;
mul.f32 f536, f661, 0f3EB58EC6;
fma.rn.f32 f537, f481, 0f3F6F5D39, f536;
mul.f32 f650, f509, 0f3DF6DBEF;
mul.f32 f651, f660, 0f3F7E222B;
sub.f32 f540, f650, f651;
mul.f32 f541, f660, 0f3DF6DBEF;
fma.rn.f32 f542, f509, 0f3F7E222B, f541;
mul.f32 f544, f512, 0f3F7E222B;
mul.f32 f649, f511, 0fBDF6DBEF;
sub.f32 f545, f649, f544;
mul.f32 f546, f512, 0fBDF6DBEF;
fma.rn.f32 f547, f511, 0f3F7E222B, f546;
mul.f32 f549, f484, 0f3F6F5D39;
mul.f32 f648, f483, 0fBEB58EC6;
sub.f32 f550, f648, f549;
mul.f32 f551, f484, 0fBEB58EC6;
fma.rn.f32 f552, f483, 0f3F6F5D39, f551;
mul.f32 f554, f456, 0f3F52AF12;
mul.f32 f647, f455, 0fBF116CB1;
sub.f32 f555, f647, f554;
mul.f32 f556, f456, 0fBF116CB1;
fma.rn.f32 f557, f455, 0f3F52AF12, f556;
mul.f32 f559, f428, 0f3F29C268;
mul.f32 f646, f427, 0fBF3F9E67;
sub.f32 f560, f646, f559;
mul.f32 f561, f428, 0fBF3F9E67;
fma.rn.f32 f562, f427, 0f3F29C268, f561;
mul.f32 f564, f400, 0f3EEDF032;
mul.f32 f645, f399, 0fBF62AD3F;
sub.f32 f565, f645, f564;
mul.f32 f566, f400, 0fBF62AD3F;
fma.rn.f32 f567, f399, 0f3EEDF032, f566;
mul.f32 f643, f371, 0fBF788FA5;
mul.f32 f644, f372, 0f3E750F2A;
sub.f32 f570, f643, f644;
mul.f32 f571, f372, 0fBF788FA5;
fma.rn.f32 f572, f371, 0f3E750F2A, f571;
add.f32 %1, f140, f344;
add.f32 %0, f139, f343;
add.f32 %2, f165, f515;
add.f32 %3, f713, f517;
add.f32 %4, f193, f520;
add.f32 %5, f709, f522;
add.f32 %6, f221, f525;
add.f32 %7, f705, f527;
add.f32 %8, f249, f530;
add.f32 %9, f701, f532;
add.f32 %11, f697, f537;
add.f32 %10, f277, f535;
add.f32 %13, f696, f542;
add.f32 %12, f305, f540;
add.f32 %15, f308, f547;
add.f32 %14, f307, f545;
add.f32 %16, f279, f550;
add.f32 %17, f280, f552;
add.f32 %18, f251, f555;
add.f32 %19, f252, f557;
add.f32 %20, f223, f560;
add.f32 %21, f224, f562;
add.f32 %22, f195, f565;
add.f32 %23, f196, f567;
add.f32 %25, f168, f572;
add.f32 %24, f167, f570;
sub.f32 %27, f140, f344;
sub.f32 %26, f139, f343;
sub.f32 %29, f713, f517;
sub.f32 %28, f165, f515;
sub.f32 %31, f709, f522;
sub.f32 %30, f193, f520;
sub.f32 %33, f705, f527;
sub.f32 %32, f221, f525;
sub.f32 %35, f701, f532;
sub.f32 %34, f249, f530;
sub.f32 %37, f697, f537;
sub.f32 %36, f277, f535;
sub.f32 %39, f696, f542;
sub.f32 %38, f305, f540;
sub.f32 %41, f308, f547;
sub.f32 %40, f307, f545;
sub.f32 %43, f280, f552;
sub.f32 %42, f279, f550;
sub.f32 %45, f252, f557;
sub.f32 %44, f251, f555;
sub.f32 %47, f224, f562;
sub.f32 %46, f223, f560;
sub.f32 %49, f196, f567;
sub.f32 %48, f195, f565;
sub.f32 %51, f168, f572;
sub.f32 %50, f167, f570;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y): "f"(rmem[1].y), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[2].y), "f"(rmem[4].y), "f"(rmem[22].y), "f"(rmem[20].y), "f"(rmem[8].y), "f"(rmem[10].y), "f"(rmem[16].y), "f"(rmem[14].y), "f"(rmem[23].y), "f"(rmem[5].y), "f"(rmem[7].y), "f"(rmem[19].y), "f"(rmem[11].y), "f"(rmem[17].y), "f"(rmem[13].y), "f"(rmem[1].y));
};


#endif
