#ifndef CUFFTDX_FFT_10000_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_10000_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<195, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<940>;
.reg .b32 r<23>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 80000, r2;
mov.u32 r4, %tid.x;
add.f32 f41, %29, %45;
add.f32 f42, %24, f41;
add.f32 f43, %34, %40;
add.f32 f44, f43, f42;
add.f32 f45, %31, %47;
add.f32 f46, %25, f45;
add.f32 f47, %36, %41;
add.f32 f48, f47, f46;
fma.rn.f32 f49, f41, 0f3E9E377A, %24;
mul.f32 f50, f43, 0f3F4F1BBD;
sub.f32 f51, f49, f50;
sub.f32 f52, %31, %47;
mul.f32 f53, f52, 0f3F737871;
sub.f32 f54, %36, %41;
mul.f32 f55, f54, 0fBF167918;
sub.f32 f56, f55, f53;
sub.f32 f57, f51, f56;
add.f32 f58, f56, f51;
mul.f32 f59, f41, 0f3F4F1BBD;
sub.f32 f60, %24, f59;
fma.rn.f32 f61, f43, 0f3E9E377A, f60;
mul.f32 f62, f52, 0f3F167918;
mul.f32 f63, f54, 0f3F737871;
sub.f32 f64, f63, f62;
sub.f32 f65, f61, f64;
add.f32 f66, f64, f61;
fma.rn.f32 f67, f45, 0f3E9E377A, %25;
mul.f32 f68, f47, 0f3F4F1BBD;
sub.f32 f69, f67, f68;
sub.f32 f70, %29, %45;
mul.f32 f71, f70, 0f3F737871;
sub.f32 f72, %34, %40;
mul.f32 f73, f72, 0fBF167918;
sub.f32 f74, f73, f71;
add.f32 f75, f74, f69;
sub.f32 f76, f69, f74;
mul.f32 f77, f45, 0f3F4F1BBD;
sub.f32 f78, %25, f77;
fma.rn.f32 f79, f47, 0f3E9E377A, f78;
mul.f32 f80, f70, 0f3F167918;
mul.f32 f81, f72, 0f3F737871;
sub.f32 f82, f81, f80;
add.f32 f83, f82, f79;
sub.f32 f84, f79, f82;
add.f32 f85, %32, %48;
add.f32 f86, %26, f85;
add.f32 f87, %37, %42;
add.f32 f88, f87, f86;
add.f32 f89, %33, %49;
add.f32 f90, %28, f89;
add.f32 f91, %39, %44;
add.f32 f92, f91, f90;
fma.rn.f32 f93, f85, 0f3E9E377A, %26;
mul.f32 f94, f87, 0f3F4F1BBD;
sub.f32 f95, f93, f94;
sub.f32 f96, %33, %49;
mul.f32 f97, f96, 0f3F737871;
sub.f32 f98, %39, %44;
mul.f32 f99, f98, 0fBF167918;
sub.f32 f100, f99, f97;
sub.f32 f101, f95, f100;
add.f32 f102, f100, f95;
mul.f32 f103, f85, 0f3F4F1BBD;
sub.f32 f104, %26, f103;
fma.rn.f32 f105, f87, 0f3E9E377A, f104;
mul.f32 f106, f96, 0f3F167918;
mul.f32 f107, f98, 0f3F737871;
sub.f32 f108, f107, f106;
sub.f32 f109, f105, f108;
add.f32 f110, f108, f105;
fma.rn.f32 f111, f89, 0f3E9E377A, %28;
mul.f32 f112, f91, 0f3F4F1BBD;
sub.f32 f113, f111, f112;
sub.f32 f114, %32, %48;
mul.f32 f115, f114, 0f3F737871;
sub.f32 f116, %37, %42;
mul.f32 f117, f116, 0fBF167918;
sub.f32 f118, f117, f115;
add.f32 f119, f118, f113;
sub.f32 f120, f113, f118;
mul.f32 f121, f89, 0f3F4F1BBD;
sub.f32 f122, %28, f121;
fma.rn.f32 f123, f91, 0f3E9E377A, f122;
mul.f32 f124, f114, 0f3F167918;
mul.f32 f125, f116, 0f3F737871;
sub.f32 f126, f125, f124;
add.f32 f127, f126, f123;
sub.f32 f128, f123, f126;
mul.f32 f129, f101, 0f3F4F1BBD;
mul.f32 f130, f119, 0fBF167918;
sub.f32 f131, f129, f130;
mul.f32 f132, f119, 0f3F4F1BBD;
fma.rn.f32 f133, f101, 0fBF167918, f132;
mul.f32 f134, f109, 0f3E9E377A;
mul.f32 f135, f127, 0fBF737871;
sub.f32 f136, f134, f135;
mul.f32 f137, f127, 0f3E9E377A;
fma.rn.f32 f138, f109, 0fBF737871, f137;
mul.f32 f139, f110, 0fBE9E377A;
mul.f32 f140, f128, 0fBF737871;
sub.f32 f141, f139, f140;
mul.f32 f142, f128, 0fBE9E377A;
fma.rn.f32 f143, f110, 0fBF737871, f142;
mul.f32 f144, f102, 0fBF4F1BBD;
mul.f32 f145, f120, 0fBF167918;
sub.f32 f146, f144, f145;
mul.f32 f147, f120, 0fBF4F1BBD;
fma.rn.f32 f148, f102, 0fBF167918, f147;
sub.f32 f149, f44, f88;
sub.f32 f150, f48, f92;
add.f32 f151, f57, f131;
add.f32 f152, f75, f133;
sub.f32 f153, f57, f131;
sub.f32 f154, f75, f133;
add.f32 f155, f65, f136;
add.f32 f156, f83, f138;
sub.f32 f157, f65, f136;
sub.f32 f158, f83, f138;
add.f32 f159, f66, f141;
add.f32 f160, f84, f143;
sub.f32 f161, f66, f141;
sub.f32 f162, f84, f143;
add.f32 f163, f58, f146;
add.f32 f164, f76, f148;
sub.f32 f165, f58, f146;
sub.f32 f166, f76, f148;
mul.wide.u32 rd2, r4, 274877907;
shr.u64 rd3, rd2, 38;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 1000;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 80000, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f167, f168}, [rd6];
mul.f32 f171, f167, f151;
mul.f32 f172, f168, f152;
mul.f32 f173, f167, f152;
mul.f32 f174, f167, f167;
mul.f32 f175, f168, f168;
sub.f32 f176, f174, f175;
mul.f32 f177, f168, f167;
fma.rn.f32 f178, f168, f167, f177;
mul.f32 f179, f176, f155;
mul.f32 f180, f178, f156;
mul.f32 f181, f176, f156;
mul.f32 f182, f167, f176;
mul.f32 f183, f168, f178;
sub.f32 f184, f182, f183;
mul.f32 f185, f167, f178;
fma.rn.f32 f186, f168, f176, f185;
mul.f32 f187, f184, f159;
mul.f32 f188, f186, f160;
mul.f32 f189, f184, f160;
mul.f32 f190, f167, f184;
mul.f32 f191, f168, f186;
sub.f32 f192, f190, f191;
mul.f32 f193, f167, f186;
fma.rn.f32 f194, f168, f184, f193;
mul.f32 f195, f192, f163;
mul.f32 f196, f194, f164;
mul.f32 f197, f192, f164;
mul.f32 f198, f167, f192;
mul.f32 f199, f168, f194;
sub.f32 f200, f198, f199;
mul.f32 f201, f167, f194;
fma.rn.f32 f202, f168, f192, f201;
mul.f32 f203, f200, f149;
mul.f32 f204, f202, f150;
mul.f32 f205, f200, f150;
mul.f32 f206, f167, f200;
mul.f32 f207, f168, f202;
sub.f32 f208, f206, f207;
mul.f32 f209, f167, f202;
fma.rn.f32 f210, f168, f200, f209;
mul.f32 f211, f208, f153;
mul.f32 f212, f210, f154;
mul.f32 f213, f208, f154;
mul.f32 f214, f167, f208;
mul.f32 f215, f168, f210;
sub.f32 f216, f214, f215;
mul.f32 f217, f167, f210;
fma.rn.f32 f218, f168, f208, f217;
mul.f32 f219, f216, f157;
mul.f32 f220, f218, f158;
mul.f32 f221, f216, f158;
mul.f32 f222, f167, f216;
mul.f32 f223, f168, f218;
sub.f32 f224, f222, f223;
mul.f32 f225, f167, f218;
fma.rn.f32 f226, f168, f216, f225;
mul.f32 f227, f224, f161;
mul.f32 f228, f226, f162;
mul.f32 f229, f224, f162;
mul.f32 f230, f167, f224;
mul.f32 f231, f168, f226;
sub.f32 f232, f230, f231;
mul.f32 f233, f167, f226;
fma.rn.f32 f234, f168, f224, f233;
mul.f32 f235, f232, f165;
mul.f32 f236, f234, f166;
mul.f32 f237, f232, f166;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
add.f32 f238, f48, f92;
add.f32 f239, f44, f88;
st.shared.v2.f32 [r9], {f239, f238};
fma.rn.f32 f240, f168, f151, f173;
sub.f32 f241, f171, f172;
st.shared.v2.f32 [r9+8], {f241, f240};
fma.rn.f32 f242, f178, f155, f181;
sub.f32 f243, f179, f180;
st.shared.v2.f32 [r9+16], {f243, f242};
fma.rn.f32 f244, f186, f159, f189;
sub.f32 f245, f187, f188;
st.shared.v2.f32 [r9+24], {f245, f244};
sub.f32 f246, f195, f196;
fma.rn.f32 f247, f194, f163, f197;
st.shared.v2.f32 [r9+32], {f246, f247};
fma.rn.f32 f248, f202, f149, f205;
sub.f32 f249, f203, f204;
st.shared.v2.f32 [r9+40], {f249, f248};
fma.rn.f32 f250, f210, f153, f213;
sub.f32 f251, f211, f212;
st.shared.v2.f32 [r9+48], {f251, f250};
fma.rn.f32 f252, f218, f157, f221;
sub.f32 f253, f219, f220;
st.shared.v2.f32 [r9+56], {f253, f252};
fma.rn.f32 f254, f226, f161, f229;
sub.f32 f255, f227, f228;
st.shared.v2.f32 [r9+64], {f255, f254};
fma.rn.f32 f256, f234, f165, f237;
sub.f32 f257, f235, f236;
st.shared.v2.f32 [r9+72], {f257, f256};
barrier.sync 0;
mad.lo.s32 r10, r7, -72, r9;
ld.shared.v2.f32 {f258, f259}, [r10];
ld.shared.v2.f32 {f262, f263}, [r10+8000];
ld.shared.v2.f32 {f266, f267}, [r10+16000];
ld.shared.v2.f32 {f270, f271}, [r10+24000];
ld.shared.v2.f32 {f274, f275}, [r10+32000];
ld.shared.v2.f32 {f278, f279}, [r10+40000];
ld.shared.v2.f32 {f282, f283}, [r10+48000];
ld.shared.v2.f32 {f286, f287}, [r10+56000];
ld.shared.v2.f32 {f290, f291}, [r10+64000];
ld.shared.v2.f32 {f294, f295}, [r10+72000];
add.f32 f298, f266, f290;
add.f32 f299, f258, f298;
add.f32 f300, f274, f282;
add.f32 f301, f300, f299;
add.f32 f302, f267, f291;
add.f32 f303, f259, f302;
add.f32 f304, f275, f283;
add.f32 f305, f304, f303;
fma.rn.f32 f306, f298, 0f3E9E377A, f258;
mul.f32 f307, f300, 0f3F4F1BBD;
sub.f32 f308, f306, f307;
sub.f32 f309, f267, f291;
mul.f32 f310, f309, 0f3F737871;
sub.f32 f311, f275, f283;
mul.f32 f312, f311, 0fBF167918;
sub.f32 f313, f312, f310;
sub.f32 f314, f308, f313;
add.f32 f315, f313, f308;
mul.f32 f316, f298, 0f3F4F1BBD;
sub.f32 f317, f258, f316;
fma.rn.f32 f318, f300, 0f3E9E377A, f317;
mul.f32 f319, f309, 0f3F167918;
mul.f32 f320, f311, 0f3F737871;
sub.f32 f321, f320, f319;
sub.f32 f322, f318, f321;
add.f32 f323, f321, f318;
fma.rn.f32 f324, f302, 0f3E9E377A, f259;
mul.f32 f325, f304, 0f3F4F1BBD;
sub.f32 f326, f324, f325;
sub.f32 f327, f266, f290;
mul.f32 f328, f327, 0f3F737871;
sub.f32 f329, f274, f282;
mul.f32 f330, f329, 0fBF167918;
sub.f32 f331, f330, f328;
add.f32 f332, f331, f326;
sub.f32 f333, f326, f331;
mul.f32 f334, f302, 0f3F4F1BBD;
sub.f32 f335, f259, f334;
fma.rn.f32 f336, f304, 0f3E9E377A, f335;
mul.f32 f337, f327, 0f3F167918;
mul.f32 f338, f329, 0f3F737871;
sub.f32 f339, f338, f337;
add.f32 f340, f339, f336;
sub.f32 f341, f336, f339;
add.f32 f342, f270, f294;
add.f32 f343, f262, f342;
add.f32 f344, f278, f286;
add.f32 f345, f344, f343;
add.f32 f346, f271, f295;
add.f32 f347, f263, f346;
add.f32 f348, f279, f287;
add.f32 f349, f348, f347;
fma.rn.f32 f350, f342, 0f3E9E377A, f262;
mul.f32 f351, f344, 0f3F4F1BBD;
sub.f32 f352, f350, f351;
sub.f32 f353, f271, f295;
mul.f32 f354, f353, 0f3F737871;
sub.f32 f355, f279, f287;
mul.f32 f356, f355, 0fBF167918;
sub.f32 f357, f356, f354;
sub.f32 f358, f352, f357;
add.f32 f359, f357, f352;
mul.f32 f360, f342, 0f3F4F1BBD;
sub.f32 f361, f262, f360;
fma.rn.f32 f362, f344, 0f3E9E377A, f361;
mul.f32 f363, f353, 0f3F167918;
mul.f32 f364, f355, 0f3F737871;
sub.f32 f365, f364, f363;
sub.f32 f366, f362, f365;
add.f32 f367, f365, f362;
fma.rn.f32 f368, f346, 0f3E9E377A, f263;
mul.f32 f369, f348, 0f3F4F1BBD;
sub.f32 f370, f368, f369;
sub.f32 f371, f270, f294;
mul.f32 f372, f371, 0f3F737871;
sub.f32 f373, f278, f286;
mul.f32 f374, f373, 0fBF167918;
sub.f32 f375, f374, f372;
add.f32 f376, f375, f370;
sub.f32 f377, f370, f375;
mul.f32 f378, f346, 0f3F4F1BBD;
sub.f32 f379, f263, f378;
fma.rn.f32 f380, f348, 0f3E9E377A, f379;
mul.f32 f381, f371, 0f3F167918;
mul.f32 f382, f373, 0f3F737871;
sub.f32 f383, f382, f381;
add.f32 f384, f383, f380;
sub.f32 f385, f380, f383;
mul.f32 f386, f358, 0f3F4F1BBD;
mul.f32 f387, f376, 0fBF167918;
sub.f32 f388, f386, f387;
mul.f32 f389, f376, 0f3F4F1BBD;
fma.rn.f32 f390, f358, 0fBF167918, f389;
mul.f32 f391, f366, 0f3E9E377A;
mul.f32 f392, f384, 0fBF737871;
sub.f32 f393, f391, f392;
mul.f32 f394, f384, 0f3E9E377A;
fma.rn.f32 f395, f366, 0fBF737871, f394;
mul.f32 f396, f367, 0fBE9E377A;
mul.f32 f397, f385, 0fBF737871;
sub.f32 f398, f396, f397;
mul.f32 f399, f385, 0fBE9E377A;
fma.rn.f32 f400, f367, 0fBF737871, f399;
mul.f32 f401, f359, 0fBF4F1BBD;
mul.f32 f402, f377, 0fBF167918;
sub.f32 f403, f401, f402;
mul.f32 f404, f377, 0fBF4F1BBD;
fma.rn.f32 f405, f359, 0fBF167918, f404;
sub.f32 f406, f301, f345;
sub.f32 f407, f305, f349;
add.f32 f408, f314, f388;
add.f32 f409, f332, f390;
sub.f32 f410, f314, f388;
sub.f32 f411, f332, f390;
add.f32 f412, f322, f393;
add.f32 f413, f340, f395;
sub.f32 f414, f322, f393;
sub.f32 f415, f340, f395;
add.f32 f416, f323, f398;
add.f32 f417, f341, f400;
sub.f32 f418, f323, f398;
sub.f32 f419, f341, f400;
add.f32 f420, f315, f403;
add.f32 f421, f333, f405;
sub.f32 f422, f315, f403;
sub.f32 f423, f333, f405;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 10;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 8;
mov.u64 rd10, %22;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f424, f425}, [rd11];
mul.f32 f428, f424, f408;
mul.f32 f429, f425, f409;
mul.f32 f430, f424, f409;
mul.f32 f431, f424, f424;
mul.f32 f432, f425, f425;
sub.f32 f433, f431, f432;
mul.f32 f434, f425, f424;
fma.rn.f32 f435, f425, f424, f434;
mul.f32 f436, f433, f412;
mul.f32 f437, f435, f413;
mul.f32 f438, f433, f413;
mul.f32 f439, f424, f433;
mul.f32 f440, f425, f435;
sub.f32 f441, f439, f440;
mul.f32 f442, f424, f435;
fma.rn.f32 f443, f425, f433, f442;
mul.f32 f444, f441, f416;
mul.f32 f445, f443, f417;
mul.f32 f446, f441, f417;
mul.f32 f447, f424, f441;
mul.f32 f448, f425, f443;
sub.f32 f449, f447, f448;
mul.f32 f450, f424, f443;
fma.rn.f32 f451, f425, f441, f450;
mul.f32 f452, f449, f420;
mul.f32 f453, f451, f421;
mul.f32 f454, f449, f421;
mul.f32 f455, f424, f449;
mul.f32 f456, f425, f451;
sub.f32 f457, f455, f456;
mul.f32 f458, f424, f451;
fma.rn.f32 f459, f425, f449, f458;
mul.f32 f460, f457, f406;
mul.f32 f461, f459, f407;
mul.f32 f462, f457, f407;
mul.f32 f463, f424, f457;
mul.f32 f464, f425, f459;
sub.f32 f465, f463, f464;
mul.f32 f466, f424, f459;
fma.rn.f32 f467, f425, f457, f466;
mul.f32 f468, f465, f410;
mul.f32 f469, f467, f411;
mul.f32 f470, f465, f411;
mul.f32 f471, f424, f465;
mul.f32 f472, f425, f467;
sub.f32 f473, f471, f472;
mul.f32 f474, f424, f467;
fma.rn.f32 f475, f425, f465, f474;
mul.f32 f476, f473, f414;
mul.f32 f477, f475, f415;
mul.f32 f478, f473, f415;
mul.f32 f479, f424, f473;
mul.f32 f480, f425, f475;
sub.f32 f481, f479, f480;
mul.f32 f482, f424, f475;
fma.rn.f32 f483, f425, f473, f482;
mul.f32 f484, f481, f418;
mul.f32 f485, f483, f419;
mul.f32 f486, f481, f419;
mul.f32 f487, f424, f481;
mul.f32 f488, f425, f483;
sub.f32 f489, f487, f488;
mul.f32 f490, f424, f483;
fma.rn.f32 f491, f425, f481, f490;
mul.f32 f492, f489, f422;
mul.f32 f493, f491, f423;
mul.f32 f494, f489, f423;
shl.b32 r14, r13, 3;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 800, r15;
add.f32 f495, f305, f349;
add.f32 f496, f301, f345;
st.shared.v2.f32 [r16], {f496, f495};
fma.rn.f32 f497, f425, f408, f430;
sub.f32 f498, f428, f429;
st.shared.v2.f32 [r16+80], {f498, f497};
fma.rn.f32 f499, f435, f412, f438;
sub.f32 f500, f436, f437;
st.shared.v2.f32 [r16+160], {f500, f499};
fma.rn.f32 f501, f443, f416, f446;
sub.f32 f502, f444, f445;
st.shared.v2.f32 [r16+240], {f502, f501};
fma.rn.f32 f503, f451, f420, f454;
sub.f32 f504, f452, f453;
st.shared.v2.f32 [r16+320], {f504, f503};
sub.f32 f505, f460, f461;
fma.rn.f32 f506, f459, f406, f462;
st.shared.v2.f32 [r16+400], {f505, f506};
sub.f32 f507, f468, f469;
fma.rn.f32 f508, f467, f410, f470;
st.shared.v2.f32 [r16+480], {f507, f508};
fma.rn.f32 f509, f475, f414, f478;
sub.f32 f510, f476, f477;
st.shared.v2.f32 [r16+560], {f510, f509};
fma.rn.f32 f511, f483, f418, f486;
sub.f32 f512, f484, f485;
st.shared.v2.f32 [r16+640], {f512, f511};
fma.rn.f32 f513, f491, f422, f494;
sub.f32 f514, f492, f493;
st.shared.v2.f32 [r16+720], {f514, f513};
barrier.sync 0;
ld.shared.v2.f32 {f515, f516}, [r10];
ld.shared.v2.f32 {f519, f520}, [r10+8000];
ld.shared.v2.f32 {f523, f524}, [r10+16000];
ld.shared.v2.f32 {f527, f528}, [r10+24000];
ld.shared.v2.f32 {f531, f532}, [r10+32000];
ld.shared.v2.f32 {f535, f536}, [r10+40000];
ld.shared.v2.f32 {f539, f540}, [r10+48000];
ld.shared.v2.f32 {f543, f544}, [r10+56000];
ld.shared.v2.f32 {f547, f548}, [r10+64000];
ld.shared.v2.f32 {f551, f552}, [r10+72000];
add.f32 f555, f523, f547;
add.f32 f556, f515, f555;
add.f32 f557, f531, f539;
add.f32 f558, f557, f556;
add.f32 f559, f524, f548;
add.f32 f560, f516, f559;
add.f32 f561, f532, f540;
add.f32 f562, f561, f560;
fma.rn.f32 f563, f555, 0f3E9E377A, f515;
mul.f32 f564, f557, 0f3F4F1BBD;
sub.f32 f565, f563, f564;
sub.f32 f566, f524, f548;
mul.f32 f567, f566, 0f3F737871;
sub.f32 f568, f532, f540;
mul.f32 f569, f568, 0fBF167918;
sub.f32 f570, f569, f567;
sub.f32 f571, f565, f570;
add.f32 f572, f570, f565;
mul.f32 f573, f555, 0f3F4F1BBD;
sub.f32 f574, f515, f573;
fma.rn.f32 f575, f557, 0f3E9E377A, f574;
mul.f32 f576, f566, 0f3F167918;
mul.f32 f577, f568, 0f3F737871;
sub.f32 f578, f577, f576;
sub.f32 f579, f575, f578;
add.f32 f580, f578, f575;
fma.rn.f32 f581, f559, 0f3E9E377A, f516;
mul.f32 f582, f561, 0f3F4F1BBD;
sub.f32 f583, f581, f582;
sub.f32 f584, f523, f547;
mul.f32 f585, f584, 0f3F737871;
sub.f32 f586, f531, f539;
mul.f32 f587, f586, 0fBF167918;
sub.f32 f588, f587, f585;
add.f32 f589, f588, f583;
sub.f32 f590, f583, f588;
mul.f32 f591, f559, 0f3F4F1BBD;
sub.f32 f592, f516, f591;
fma.rn.f32 f593, f561, 0f3E9E377A, f592;
mul.f32 f594, f584, 0f3F167918;
mul.f32 f595, f586, 0f3F737871;
sub.f32 f596, f595, f594;
add.f32 f597, f596, f593;
sub.f32 f598, f593, f596;
add.f32 f599, f527, f551;
add.f32 f600, f519, f599;
add.f32 f601, f535, f543;
add.f32 f602, f601, f600;
add.f32 f603, f528, f552;
add.f32 f604, f520, f603;
add.f32 f605, f536, f544;
add.f32 f606, f605, f604;
fma.rn.f32 f607, f599, 0f3E9E377A, f519;
mul.f32 f608, f601, 0f3F4F1BBD;
sub.f32 f609, f607, f608;
sub.f32 f610, f528, f552;
mul.f32 f611, f610, 0f3F737871;
sub.f32 f612, f536, f544;
mul.f32 f613, f612, 0fBF167918;
sub.f32 f614, f613, f611;
sub.f32 f615, f609, f614;
add.f32 f616, f614, f609;
mul.f32 f617, f599, 0f3F4F1BBD;
sub.f32 f618, f519, f617;
fma.rn.f32 f619, f601, 0f3E9E377A, f618;
mul.f32 f620, f610, 0f3F167918;
mul.f32 f621, f612, 0f3F737871;
sub.f32 f622, f621, f620;
sub.f32 f623, f619, f622;
add.f32 f624, f622, f619;
fma.rn.f32 f625, f603, 0f3E9E377A, f520;
mul.f32 f626, f605, 0f3F4F1BBD;
sub.f32 f627, f625, f626;
sub.f32 f628, f527, f551;
mul.f32 f629, f628, 0f3F737871;
sub.f32 f630, f535, f543;
mul.f32 f631, f630, 0fBF167918;
sub.f32 f632, f631, f629;
add.f32 f633, f632, f627;
sub.f32 f634, f627, f632;
mul.f32 f635, f603, 0f3F4F1BBD;
sub.f32 f636, f520, f635;
fma.rn.f32 f637, f605, 0f3E9E377A, f636;
mul.f32 f638, f628, 0f3F167918;
mul.f32 f639, f630, 0f3F737871;
sub.f32 f640, f639, f638;
add.f32 f641, f640, f637;
sub.f32 f642, f637, f640;
mul.f32 f643, f615, 0f3F4F1BBD;
mul.f32 f644, f633, 0fBF167918;
sub.f32 f645, f643, f644;
mul.f32 f646, f633, 0f3F4F1BBD;
fma.rn.f32 f647, f615, 0fBF167918, f646;
mul.f32 f648, f623, 0f3E9E377A;
mul.f32 f649, f641, 0fBF737871;
sub.f32 f650, f648, f649;
mul.f32 f651, f641, 0f3E9E377A;
fma.rn.f32 f652, f623, 0fBF737871, f651;
mul.f32 f653, f624, 0fBE9E377A;
mul.f32 f654, f642, 0fBF737871;
sub.f32 f655, f653, f654;
mul.f32 f656, f642, 0fBE9E377A;
fma.rn.f32 f657, f624, 0fBF737871, f656;
mul.f32 f658, f616, 0fBF4F1BBD;
mul.f32 f659, f634, 0fBF167918;
sub.f32 f660, f658, f659;
mul.f32 f661, f634, 0fBF4F1BBD;
fma.rn.f32 f662, f616, 0fBF167918, f661;
sub.f32 f663, f558, f602;
sub.f32 f664, f562, f606;
add.f32 f665, f571, f645;
add.f32 f666, f589, f647;
sub.f32 f667, f571, f645;
sub.f32 f668, f589, f647;
add.f32 f669, f579, f650;
add.f32 f670, f597, f652;
sub.f32 f671, f579, f650;
sub.f32 f672, f597, f652;
add.f32 f673, f580, f655;
add.f32 f674, f598, f657;
sub.f32 f675, f580, f655;
sub.f32 f676, f598, f657;
add.f32 f677, f572, f660;
add.f32 f678, f590, f662;
sub.f32 f679, f572, f660;
sub.f32 f680, f590, f662;
mul.wide.u32 rd12, r7, 1374389535;
shr.u64 rd13, rd12, 37;
cvt.u32.u64 r17, rd13;
mul.lo.s32 r18, r17, 100;
sub.s32 r19, r7, r18;
mul.wide.u32 rd14, r17, 8;
mov.u64 rd15, %23;
add.s64 rd16, rd15, rd14;
ld.global.v2.f32 {f681, f682}, [rd16];
mul.f32 f685, f681, f665;
mul.f32 f686, f682, f666;
mul.f32 f687, f681, f666;
mul.f32 f688, f681, f681;
mul.f32 f689, f682, f682;
sub.f32 f690, f688, f689;
mul.f32 f691, f682, f681;
fma.rn.f32 f692, f682, f681, f691;
mul.f32 f693, f690, f669;
mul.f32 f694, f692, f670;
mul.f32 f695, f690, f670;
mul.f32 f696, f681, f690;
mul.f32 f697, f682, f692;
sub.f32 f698, f696, f697;
mul.f32 f699, f681, f692;
fma.rn.f32 f700, f682, f690, f699;
mul.f32 f701, f698, f673;
mul.f32 f702, f700, f674;
mul.f32 f703, f698, f674;
mul.f32 f704, f681, f698;
mul.f32 f705, f682, f700;
sub.f32 f706, f704, f705;
mul.f32 f707, f681, f700;
fma.rn.f32 f708, f682, f698, f707;
mul.f32 f709, f706, f677;
mul.f32 f710, f708, f678;
mul.f32 f711, f706, f678;
mul.f32 f712, f681, f706;
mul.f32 f713, f682, f708;
sub.f32 f714, f712, f713;
mul.f32 f715, f681, f708;
fma.rn.f32 f716, f682, f706, f715;
mul.f32 f717, f714, f663;
mul.f32 f718, f716, f664;
mul.f32 f719, f714, f664;
mul.f32 f720, f681, f714;
mul.f32 f721, f682, f716;
sub.f32 f722, f720, f721;
mul.f32 f723, f681, f716;
fma.rn.f32 f724, f682, f714, f723;
mul.f32 f725, f722, f667;
mul.f32 f726, f724, f668;
mul.f32 f727, f722, f668;
mul.f32 f728, f681, f722;
mul.f32 f729, f682, f724;
sub.f32 f730, f728, f729;
mul.f32 f731, f681, f724;
fma.rn.f32 f732, f682, f722, f731;
mul.f32 f733, f730, f671;
mul.f32 f734, f732, f672;
mul.f32 f735, f730, f672;
mul.f32 f736, f681, f730;
mul.f32 f737, f682, f732;
sub.f32 f738, f736, f737;
mul.f32 f739, f681, f732;
fma.rn.f32 f740, f682, f730, f739;
mul.f32 f741, f738, f675;
mul.f32 f742, f740, f676;
mul.f32 f743, f738, f676;
mul.f32 f744, f681, f738;
mul.f32 f745, f682, f740;
sub.f32 f746, f744, f745;
mul.f32 f747, f681, f740;
fma.rn.f32 f748, f682, f738, f747;
mul.f32 f749, f746, f679;
mul.f32 f750, f748, f680;
mul.f32 f751, f746, f680;
shl.b32 r20, r19, 3;
add.s32 r21, r8, r20;
barrier.sync 0;
mad.lo.s32 r22, r17, 8000, r21;
add.f32 f752, f562, f606;
add.f32 f753, f558, f602;
st.shared.v2.f32 [r22], {f753, f752};
fma.rn.f32 f754, f682, f665, f687;
sub.f32 f755, f685, f686;
st.shared.v2.f32 [r22+800], {f755, f754};
fma.rn.f32 f756, f692, f669, f695;
sub.f32 f757, f693, f694;
st.shared.v2.f32 [r22+1600], {f757, f756};
fma.rn.f32 f758, f700, f673, f703;
sub.f32 f759, f701, f702;
st.shared.v2.f32 [r22+2400], {f759, f758};
fma.rn.f32 f760, f708, f677, f711;
sub.f32 f761, f709, f710;
st.shared.v2.f32 [r22+3200], {f761, f760};
sub.f32 f762, f717, f718;
fma.rn.f32 f763, f716, f663, f719;
st.shared.v2.f32 [r22+4000], {f762, f763};
sub.f32 f764, f725, f726;
fma.rn.f32 f765, f724, f667, f727;
st.shared.v2.f32 [r22+4800], {f764, f765};
fma.rn.f32 f766, f732, f671, f735;
sub.f32 f767, f733, f734;
st.shared.v2.f32 [r22+5600], {f767, f766};
fma.rn.f32 f768, f740, f675, f743;
sub.f32 f769, f741, f742;
st.shared.v2.f32 [r22+6400], {f769, f768};
fma.rn.f32 f770, f748, f679, f751;
sub.f32 f771, f749, f750;
st.shared.v2.f32 [r22+7200], {f771, f770};
barrier.sync 0;
ld.shared.v2.f32 {f772, f773}, [r10];
ld.shared.v2.f32 {f776, f777}, [r10+8000];
ld.shared.v2.f32 {f780, f781}, [r10+16000];
ld.shared.v2.f32 {f784, f785}, [r10+24000];
ld.shared.v2.f32 {f788, f789}, [r10+32000];
ld.shared.v2.f32 {f792, f793}, [r10+40000];
ld.shared.v2.f32 {f796, f797}, [r10+48000];
ld.shared.v2.f32 {f800, f801}, [r10+56000];
ld.shared.v2.f32 {f804, f805}, [r10+64000];
ld.shared.v2.f32 {f808, f809}, [r10+72000];
add.f32 f812, f780, f804;
add.f32 f813, f772, f812;
add.f32 f814, f788, f796;
add.f32 f815, f814, f813;
add.f32 f816, f781, f805;
add.f32 f817, f773, f816;
add.f32 f818, f789, f797;
add.f32 f819, f818, f817;
fma.rn.f32 f820, f812, 0f3E9E377A, f772;
mul.f32 f821, f814, 0f3F4F1BBD;
sub.f32 f822, f820, f821;
sub.f32 f823, f781, f805;
mul.f32 f824, f823, 0f3F737871;
sub.f32 f825, f789, f797;
mul.f32 f826, f825, 0fBF167918;
sub.f32 f827, f826, f824;
sub.f32 f828, f822, f827;
add.f32 f829, f827, f822;
mul.f32 f830, f812, 0f3F4F1BBD;
sub.f32 f831, f772, f830;
fma.rn.f32 f832, f814, 0f3E9E377A, f831;
mul.f32 f833, f823, 0f3F167918;
mul.f32 f834, f825, 0f3F737871;
sub.f32 f835, f834, f833;
sub.f32 f836, f832, f835;
add.f32 f837, f835, f832;
fma.rn.f32 f838, f816, 0f3E9E377A, f773;
mul.f32 f839, f818, 0f3F4F1BBD;
sub.f32 f840, f838, f839;
sub.f32 f841, f780, f804;
mul.f32 f842, f841, 0f3F737871;
sub.f32 f843, f788, f796;
mul.f32 f844, f843, 0fBF167918;
sub.f32 f845, f844, f842;
add.f32 f846, f845, f840;
sub.f32 f847, f840, f845;
mul.f32 f848, f816, 0f3F4F1BBD;
sub.f32 f849, f773, f848;
fma.rn.f32 f850, f818, 0f3E9E377A, f849;
mul.f32 f851, f841, 0f3F167918;
mul.f32 f852, f843, 0f3F737871;
sub.f32 f853, f852, f851;
add.f32 f854, f853, f850;
sub.f32 f855, f850, f853;
add.f32 f856, f784, f808;
add.f32 f857, f776, f856;
add.f32 f858, f792, f800;
add.f32 f859, f858, f857;
add.f32 f860, f785, f809;
add.f32 f861, f777, f860;
add.f32 f862, f793, f801;
add.f32 f863, f862, f861;
fma.rn.f32 f864, f856, 0f3E9E377A, f776;
mul.f32 f865, f858, 0f3F4F1BBD;
sub.f32 f866, f864, f865;
sub.f32 f867, f785, f809;
mul.f32 f868, f867, 0f3F737871;
sub.f32 f869, f793, f801;
mul.f32 f870, f869, 0fBF167918;
sub.f32 f871, f870, f868;
sub.f32 f872, f866, f871;
add.f32 f873, f871, f866;
mul.f32 f874, f856, 0f3F4F1BBD;
sub.f32 f875, f776, f874;
fma.rn.f32 f876, f858, 0f3E9E377A, f875;
mul.f32 f877, f867, 0f3F167918;
mul.f32 f878, f869, 0f3F737871;
sub.f32 f879, f878, f877;
sub.f32 f880, f876, f879;
add.f32 f881, f879, f876;
fma.rn.f32 f882, f860, 0f3E9E377A, f777;
mul.f32 f883, f862, 0f3F4F1BBD;
sub.f32 f884, f882, f883;
sub.f32 f885, f784, f808;
mul.f32 f886, f885, 0f3F737871;
sub.f32 f887, f792, f800;
mul.f32 f888, f887, 0fBF167918;
sub.f32 f889, f888, f886;
add.f32 f890, f889, f884;
sub.f32 f891, f884, f889;
mul.f32 f892, f860, 0f3F4F1BBD;
sub.f32 f893, f777, f892;
fma.rn.f32 f894, f862, 0f3E9E377A, f893;
mul.f32 f895, f885, 0f3F167918;
mul.f32 f896, f887, 0f3F737871;
sub.f32 f897, f896, f895;
add.f32 f898, f897, f894;
sub.f32 f899, f894, f897;
mul.f32 f900, f872, 0f3F4F1BBD;
mul.f32 f901, f890, 0fBF167918;
sub.f32 f902, f900, f901;
mul.f32 f903, f890, 0f3F4F1BBD;
fma.rn.f32 f904, f872, 0fBF167918, f903;
mul.f32 f905, f880, 0f3E9E377A;
mul.f32 f906, f898, 0fBF737871;
sub.f32 f907, f905, f906;
mul.f32 f908, f898, 0f3E9E377A;
fma.rn.f32 f909, f880, 0fBF737871, f908;
mul.f32 f910, f881, 0fBE9E377A;
mul.f32 f911, f899, 0fBF737871;
sub.f32 f912, f910, f911;
mul.f32 f913, f899, 0fBE9E377A;
fma.rn.f32 f914, f881, 0fBF737871, f913;
mul.f32 f915, f873, 0fBF4F1BBD;
mul.f32 f916, f891, 0fBF167918;
sub.f32 f917, f915, f916;
mul.f32 f918, f891, 0fBF4F1BBD;
fma.rn.f32 f919, f873, 0fBF167918, f918;
add.f32 %1, f819, f863;
add.f32 %0, f815, f859;
add.f32 %3, f846, f904;
add.f32 %2, f828, f902;
add.f32 %5, f854, f909;
add.f32 %4, f836, f907;
add.f32 %7, f855, f914;
add.f32 %6, f837, f912;
add.f32 %9, f847, f919;
add.f32 %8, f829, f917;
sub.f32 %11, f819, f863;
sub.f32 %10, f815, f859;
sub.f32 %13, f846, f904;
sub.f32 %12, f828, f902;
sub.f32 %15, f854, f909;
sub.f32 %14, f836, f907;
sub.f32 %17, f855, f914;
sub.f32 %16, f837, f912;
sub.f32 %19, f847, f919;
sub.f32 %18, f829, f917;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y): "r"(smem), "l"(lut_sp_10_10000), "l"(lut_sp_10_1000), "l"(lut_sp_10_100), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<196, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<880>;
.reg .b32 r<23>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 40000, r2;
mov.u32 r4, %tid.x;
add.f32 f41, %29, %45;
add.f32 f42, %24, f41;
add.f32 f43, %34, %40;
add.f32 f44, f43, f42;
add.f32 f45, %31, %47;
add.f32 f46, %25, f45;
add.f32 f47, %36, %41;
add.f32 f48, f47, f46;
fma.rn.f32 f49, f41, 0f3E9E377A, %24;
mul.f32 f50, f43, 0f3F4F1BBD;
sub.f32 f51, f49, f50;
sub.f32 f52, %31, %47;
mul.f32 f53, f52, 0f3F737871;
sub.f32 f54, %36, %41;
mul.f32 f55, f54, 0fBF167918;
sub.f32 f56, f55, f53;
sub.f32 f57, f51, f56;
add.f32 f58, f56, f51;
mul.f32 f59, f41, 0f3F4F1BBD;
sub.f32 f60, %24, f59;
fma.rn.f32 f61, f43, 0f3E9E377A, f60;
mul.f32 f62, f52, 0f3F167918;
mul.f32 f63, f54, 0f3F737871;
sub.f32 f64, f63, f62;
sub.f32 f65, f61, f64;
add.f32 f66, f64, f61;
fma.rn.f32 f67, f45, 0f3E9E377A, %25;
mul.f32 f68, f47, 0f3F4F1BBD;
sub.f32 f69, f67, f68;
sub.f32 f70, %29, %45;
mul.f32 f71, f70, 0f3F737871;
sub.f32 f72, %34, %40;
mul.f32 f73, f72, 0fBF167918;
sub.f32 f74, f73, f71;
add.f32 f75, f74, f69;
sub.f32 f76, f69, f74;
mul.f32 f77, f45, 0f3F4F1BBD;
sub.f32 f78, %25, f77;
fma.rn.f32 f79, f47, 0f3E9E377A, f78;
mul.f32 f80, f70, 0f3F167918;
mul.f32 f81, f72, 0f3F737871;
sub.f32 f82, f81, f80;
add.f32 f83, f82, f79;
sub.f32 f84, f79, f82;
add.f32 f85, %32, %48;
add.f32 f86, %26, f85;
add.f32 f87, %37, %42;
add.f32 f88, f87, f86;
add.f32 f89, %33, %49;
add.f32 f90, %28, f89;
add.f32 f91, %39, %44;
add.f32 f92, f91, f90;
fma.rn.f32 f93, f85, 0f3E9E377A, %26;
mul.f32 f94, f87, 0f3F4F1BBD;
sub.f32 f95, f93, f94;
sub.f32 f96, %33, %49;
mul.f32 f97, f96, 0f3F737871;
sub.f32 f98, %39, %44;
mul.f32 f99, f98, 0fBF167918;
sub.f32 f100, f99, f97;
sub.f32 f101, f95, f100;
add.f32 f102, f100, f95;
mul.f32 f103, f85, 0f3F4F1BBD;
sub.f32 f104, %26, f103;
fma.rn.f32 f105, f87, 0f3E9E377A, f104;
mul.f32 f106, f96, 0f3F167918;
mul.f32 f107, f98, 0f3F737871;
sub.f32 f108, f107, f106;
sub.f32 f109, f105, f108;
add.f32 f110, f108, f105;
fma.rn.f32 f111, f89, 0f3E9E377A, %28;
mul.f32 f112, f91, 0f3F4F1BBD;
sub.f32 f113, f111, f112;
sub.f32 f114, %32, %48;
mul.f32 f115, f114, 0f3F737871;
sub.f32 f116, %37, %42;
mul.f32 f117, f116, 0fBF167918;
sub.f32 f118, f117, f115;
add.f32 f119, f118, f113;
sub.f32 f120, f113, f118;
mul.f32 f121, f89, 0f3F4F1BBD;
sub.f32 f122, %28, f121;
fma.rn.f32 f123, f91, 0f3E9E377A, f122;
mul.f32 f124, f114, 0f3F167918;
mul.f32 f125, f116, 0f3F737871;
sub.f32 f126, f125, f124;
add.f32 f127, f126, f123;
sub.f32 f128, f123, f126;
mul.f32 f129, f101, 0f3F4F1BBD;
mul.f32 f130, f119, 0fBF167918;
sub.f32 f131, f129, f130;
mul.f32 f132, f119, 0f3F4F1BBD;
fma.rn.f32 f133, f101, 0fBF167918, f132;
mul.f32 f134, f109, 0f3E9E377A;
mul.f32 f135, f127, 0fBF737871;
sub.f32 f136, f134, f135;
mul.f32 f137, f127, 0f3E9E377A;
fma.rn.f32 f138, f109, 0fBF737871, f137;
mul.f32 f139, f110, 0fBE9E377A;
mul.f32 f140, f128, 0fBF737871;
sub.f32 f141, f139, f140;
mul.f32 f142, f128, 0fBE9E377A;
fma.rn.f32 f143, f110, 0fBF737871, f142;
mul.f32 f144, f102, 0fBF4F1BBD;
mul.f32 f145, f120, 0fBF167918;
sub.f32 f146, f144, f145;
mul.f32 f147, f120, 0fBF4F1BBD;
fma.rn.f32 f148, f102, 0fBF167918, f147;
add.f32 f149, f44, f88;
add.f32 f150, f48, f92;
sub.f32 f151, f44, f88;
sub.f32 f152, f48, f92;
add.f32 f153, f57, f131;
add.f32 f154, f75, f133;
sub.f32 f155, f57, f131;
sub.f32 f156, f75, f133;
add.f32 f157, f65, f136;
add.f32 f158, f83, f138;
sub.f32 f159, f65, f136;
sub.f32 f160, f83, f138;
add.f32 f161, f66, f141;
add.f32 f162, f84, f143;
sub.f32 f163, f66, f141;
sub.f32 f164, f84, f143;
add.f32 f165, f58, f146;
add.f32 f166, f76, f148;
sub.f32 f167, f58, f146;
sub.f32 f168, f76, f148;
mul.wide.u32 rd2, r4, 274877907;
shr.u64 rd3, rd2, 38;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 1000;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f169, f170}, [rd6];
mul.f32 f173, f169, f153;
mul.f32 f174, f170, f154;
sub.f32 f175, f173, f174;
mul.f32 f176, f169, f154;
fma.rn.f32 f177, f170, f153, f176;
mul.f32 f178, f169, f169;
mul.f32 f179, f170, f170;
sub.f32 f180, f178, f179;
mul.f32 f181, f170, f169;
fma.rn.f32 f182, f170, f169, f181;
mul.f32 f183, f180, f157;
mul.f32 f184, f182, f158;
sub.f32 f185, f183, f184;
mul.f32 f186, f180, f158;
fma.rn.f32 f187, f182, f157, f186;
mul.f32 f188, f169, f180;
mul.f32 f189, f170, f182;
sub.f32 f190, f188, f189;
mul.f32 f191, f169, f182;
fma.rn.f32 f192, f170, f180, f191;
mul.f32 f193, f190, f161;
mul.f32 f194, f192, f162;
sub.f32 f195, f193, f194;
mul.f32 f196, f190, f162;
fma.rn.f32 f197, f192, f161, f196;
mul.f32 f198, f169, f190;
mul.f32 f199, f170, f192;
sub.f32 f200, f198, f199;
mul.f32 f201, f169, f192;
fma.rn.f32 f202, f170, f190, f201;
mul.f32 f203, f200, f165;
mul.f32 f204, f202, f166;
sub.f32 f205, f203, f204;
mul.f32 f206, f200, f166;
fma.rn.f32 f207, f202, f165, f206;
mul.f32 f208, f169, f200;
mul.f32 f209, f170, f202;
sub.f32 f210, f208, f209;
mul.f32 f211, f169, f202;
fma.rn.f32 f212, f170, f200, f211;
mul.f32 f213, f210, f151;
mul.f32 f214, f212, f152;
sub.f32 f215, f213, f214;
mul.f32 f216, f210, f152;
fma.rn.f32 f217, f212, f151, f216;
mul.f32 f218, f169, f210;
mul.f32 f219, f170, f212;
sub.f32 f220, f218, f219;
mul.f32 f221, f169, f212;
fma.rn.f32 f222, f170, f210, f221;
mul.f32 f223, f220, f155;
mul.f32 f224, f222, f156;
sub.f32 f225, f223, f224;
mul.f32 f226, f220, f156;
fma.rn.f32 f227, f222, f155, f226;
mul.f32 f228, f169, f220;
mul.f32 f229, f170, f222;
sub.f32 f230, f228, f229;
mul.f32 f231, f169, f222;
fma.rn.f32 f232, f170, f220, f231;
mul.f32 f233, f230, f159;
mul.f32 f234, f232, f160;
sub.f32 f235, f233, f234;
mul.f32 f236, f230, f160;
fma.rn.f32 f237, f232, f159, f236;
mul.f32 f238, f169, f230;
mul.f32 f239, f170, f232;
sub.f32 f240, f238, f239;
mul.f32 f241, f169, f232;
fma.rn.f32 f242, f170, f230, f241;
mul.f32 f243, f240, f163;
mul.f32 f244, f242, f164;
sub.f32 f245, f243, f244;
mul.f32 f246, f240, f164;
fma.rn.f32 f247, f242, f163, f246;
mul.f32 f248, f169, f240;
mul.f32 f249, f170, f242;
sub.f32 f250, f248, f249;
mul.f32 f251, f169, f242;
fma.rn.f32 f252, f170, f240, f251;
mul.f32 f253, f250, f167;
mul.f32 f254, f252, f168;
sub.f32 f255, f253, f254;
mul.f32 f256, f250, f168;
fma.rn.f32 f257, f252, f167, f256;
mad.lo.s32 r8, r5, 40000, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
st.shared.v2.f32 [r9], {f149, f175};
st.shared.v2.f32 [r9+8], {f185, f195};
st.shared.v2.f32 [r9+16], {f205, f215};
st.shared.v2.f32 [r9+24], {f225, f235};
st.shared.v2.f32 [r9+32], {f245, f255};
barrier.sync 0;
mad.lo.s32 r10, r7, -36, r9;
ld.shared.f32 f258, [r10];
ld.shared.f32 f259, [r10+4000];
ld.shared.f32 f260, [r10+8000];
ld.shared.f32 f261, [r10+12000];
ld.shared.f32 f262, [r10+16000];
ld.shared.f32 f263, [r10+20000];
ld.shared.f32 f264, [r10+24000];
ld.shared.f32 f265, [r10+28000];
ld.shared.f32 f266, [r10+32000];
ld.shared.f32 f267, [r10+36000];
barrier.sync 0;
st.shared.v2.f32 [r9], {f150, f177};
st.shared.v2.f32 [r9+8], {f187, f197};
st.shared.v2.f32 [r9+16], {f207, f217};
st.shared.v2.f32 [r9+24], {f227, f237};
st.shared.v2.f32 [r9+32], {f247, f257};
barrier.sync 0;
ld.shared.f32 f268, [r10];
ld.shared.f32 f269, [r10+4000];
ld.shared.f32 f270, [r10+8000];
ld.shared.f32 f271, [r10+12000];
ld.shared.f32 f272, [r10+16000];
ld.shared.f32 f273, [r10+20000];
ld.shared.f32 f274, [r10+24000];
ld.shared.f32 f275, [r10+28000];
ld.shared.f32 f276, [r10+32000];
ld.shared.f32 f277, [r10+36000];
add.f32 f278, f260, f266;
add.f32 f279, f258, f278;
add.f32 f280, f262, f264;
add.f32 f281, f280, f279;
add.f32 f282, f270, f276;
add.f32 f283, f268, f282;
add.f32 f284, f272, f274;
add.f32 f285, f284, f283;
fma.rn.f32 f286, f278, 0f3E9E377A, f258;
mul.f32 f287, f280, 0f3F4F1BBD;
sub.f32 f288, f286, f287;
sub.f32 f289, f270, f276;
mul.f32 f290, f289, 0f3F737871;
sub.f32 f291, f272, f274;
mul.f32 f292, f291, 0fBF167918;
sub.f32 f293, f292, f290;
sub.f32 f294, f288, f293;
add.f32 f295, f293, f288;
mul.f32 f296, f278, 0f3F4F1BBD;
sub.f32 f297, f258, f296;
fma.rn.f32 f298, f280, 0f3E9E377A, f297;
mul.f32 f299, f289, 0f3F167918;
mul.f32 f300, f291, 0f3F737871;
sub.f32 f301, f300, f299;
sub.f32 f302, f298, f301;
add.f32 f303, f301, f298;
fma.rn.f32 f304, f282, 0f3E9E377A, f268;
mul.f32 f305, f284, 0f3F4F1BBD;
sub.f32 f306, f304, f305;
sub.f32 f307, f260, f266;
mul.f32 f308, f307, 0f3F737871;
sub.f32 f309, f262, f264;
mul.f32 f310, f309, 0fBF167918;
sub.f32 f311, f310, f308;
add.f32 f312, f311, f306;
sub.f32 f313, f306, f311;
mul.f32 f314, f282, 0f3F4F1BBD;
sub.f32 f315, f268, f314;
fma.rn.f32 f316, f284, 0f3E9E377A, f315;
mul.f32 f317, f307, 0f3F167918;
mul.f32 f318, f309, 0f3F737871;
sub.f32 f319, f318, f317;
add.f32 f320, f319, f316;
sub.f32 f321, f316, f319;
add.f32 f322, f261, f267;
add.f32 f323, f259, f322;
add.f32 f324, f263, f265;
add.f32 f325, f324, f323;
add.f32 f326, f271, f277;
add.f32 f327, f269, f326;
add.f32 f328, f273, f275;
add.f32 f329, f328, f327;
fma.rn.f32 f330, f322, 0f3E9E377A, f259;
mul.f32 f331, f324, 0f3F4F1BBD;
sub.f32 f332, f330, f331;
sub.f32 f333, f271, f277;
mul.f32 f334, f333, 0f3F737871;
sub.f32 f335, f273, f275;
mul.f32 f336, f335, 0fBF167918;
sub.f32 f337, f336, f334;
sub.f32 f338, f332, f337;
add.f32 f339, f337, f332;
mul.f32 f340, f322, 0f3F4F1BBD;
sub.f32 f341, f259, f340;
fma.rn.f32 f342, f324, 0f3E9E377A, f341;
mul.f32 f343, f333, 0f3F167918;
mul.f32 f344, f335, 0f3F737871;
sub.f32 f345, f344, f343;
sub.f32 f346, f342, f345;
add.f32 f347, f345, f342;
fma.rn.f32 f348, f326, 0f3E9E377A, f269;
mul.f32 f349, f328, 0f3F4F1BBD;
sub.f32 f350, f348, f349;
sub.f32 f351, f261, f267;
mul.f32 f352, f351, 0f3F737871;
sub.f32 f353, f263, f265;
mul.f32 f354, f353, 0fBF167918;
sub.f32 f355, f354, f352;
add.f32 f356, f355, f350;
sub.f32 f357, f350, f355;
mul.f32 f358, f326, 0f3F4F1BBD;
sub.f32 f359, f269, f358;
fma.rn.f32 f360, f328, 0f3E9E377A, f359;
mul.f32 f361, f351, 0f3F167918;
mul.f32 f362, f353, 0f3F737871;
sub.f32 f363, f362, f361;
add.f32 f364, f363, f360;
sub.f32 f365, f360, f363;
mul.f32 f366, f338, 0f3F4F1BBD;
mul.f32 f367, f356, 0fBF167918;
sub.f32 f368, f366, f367;
mul.f32 f369, f356, 0f3F4F1BBD;
fma.rn.f32 f370, f338, 0fBF167918, f369;
mul.f32 f371, f346, 0f3E9E377A;
mul.f32 f372, f364, 0fBF737871;
sub.f32 f373, f371, f372;
mul.f32 f374, f364, 0f3E9E377A;
fma.rn.f32 f375, f346, 0fBF737871, f374;
mul.f32 f376, f347, 0fBE9E377A;
mul.f32 f377, f365, 0fBF737871;
sub.f32 f378, f376, f377;
mul.f32 f379, f365, 0fBE9E377A;
fma.rn.f32 f380, f347, 0fBF737871, f379;
mul.f32 f381, f339, 0fBF4F1BBD;
mul.f32 f382, f357, 0fBF167918;
sub.f32 f383, f381, f382;
mul.f32 f384, f357, 0fBF4F1BBD;
fma.rn.f32 f385, f339, 0fBF167918, f384;
add.f32 f386, f281, f325;
add.f32 f387, f285, f329;
sub.f32 f388, f281, f325;
sub.f32 f389, f285, f329;
add.f32 f390, f294, f368;
add.f32 f391, f312, f370;
sub.f32 f392, f294, f368;
sub.f32 f393, f312, f370;
add.f32 f394, f302, f373;
add.f32 f395, f320, f375;
sub.f32 f396, f302, f373;
sub.f32 f397, f320, f375;
add.f32 f398, f303, f378;
add.f32 f399, f321, f380;
sub.f32 f400, f303, f378;
sub.f32 f401, f321, f380;
add.f32 f402, f295, f383;
add.f32 f403, f313, f385;
sub.f32 f404, f295, f383;
sub.f32 f405, f313, f385;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 10;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 8;
mov.u64 rd10, %22;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f406, f407}, [rd11];
mul.f32 f410, f406, f390;
mul.f32 f411, f407, f391;
sub.f32 f412, f410, f411;
mul.f32 f413, f406, f391;
fma.rn.f32 f414, f407, f390, f413;
mul.f32 f415, f406, f406;
mul.f32 f416, f407, f407;
sub.f32 f417, f415, f416;
mul.f32 f418, f407, f406;
fma.rn.f32 f419, f407, f406, f418;
mul.f32 f420, f417, f394;
mul.f32 f421, f419, f395;
sub.f32 f422, f420, f421;
mul.f32 f423, f417, f395;
fma.rn.f32 f424, f419, f394, f423;
mul.f32 f425, f406, f417;
mul.f32 f426, f407, f419;
sub.f32 f427, f425, f426;
mul.f32 f428, f406, f419;
fma.rn.f32 f429, f407, f417, f428;
mul.f32 f430, f427, f398;
mul.f32 f431, f429, f399;
sub.f32 f432, f430, f431;
mul.f32 f433, f427, f399;
fma.rn.f32 f434, f429, f398, f433;
mul.f32 f435, f406, f427;
mul.f32 f436, f407, f429;
sub.f32 f437, f435, f436;
mul.f32 f438, f406, f429;
fma.rn.f32 f439, f407, f427, f438;
mul.f32 f440, f437, f402;
mul.f32 f441, f439, f403;
sub.f32 f442, f440, f441;
mul.f32 f443, f437, f403;
fma.rn.f32 f444, f439, f402, f443;
mul.f32 f445, f406, f437;
mul.f32 f446, f407, f439;
sub.f32 f447, f445, f446;
mul.f32 f448, f406, f439;
fma.rn.f32 f449, f407, f437, f448;
mul.f32 f450, f447, f388;
mul.f32 f451, f449, f389;
sub.f32 f452, f450, f451;
mul.f32 f453, f447, f389;
fma.rn.f32 f454, f449, f388, f453;
mul.f32 f455, f406, f447;
mul.f32 f456, f407, f449;
sub.f32 f457, f455, f456;
mul.f32 f458, f406, f449;
fma.rn.f32 f459, f407, f447, f458;
mul.f32 f460, f457, f392;
mul.f32 f461, f459, f393;
sub.f32 f462, f460, f461;
mul.f32 f463, f457, f393;
fma.rn.f32 f464, f459, f392, f463;
mul.f32 f465, f406, f457;
mul.f32 f466, f407, f459;
sub.f32 f467, f465, f466;
mul.f32 f468, f406, f459;
fma.rn.f32 f469, f407, f457, f468;
mul.f32 f470, f467, f396;
mul.f32 f471, f469, f397;
sub.f32 f472, f470, f471;
mul.f32 f473, f467, f397;
fma.rn.f32 f474, f469, f396, f473;
mul.f32 f475, f406, f467;
mul.f32 f476, f407, f469;
sub.f32 f477, f475, f476;
mul.f32 f478, f406, f469;
fma.rn.f32 f479, f407, f467, f478;
mul.f32 f480, f477, f400;
mul.f32 f481, f479, f401;
sub.f32 f482, f480, f481;
mul.f32 f483, f477, f401;
fma.rn.f32 f484, f479, f400, f483;
mul.f32 f485, f406, f477;
mul.f32 f486, f407, f479;
sub.f32 f487, f485, f486;
mul.f32 f488, f406, f479;
fma.rn.f32 f489, f407, f477, f488;
mul.f32 f490, f487, f404;
mul.f32 f491, f489, f405;
sub.f32 f492, f490, f491;
mul.f32 f493, f487, f405;
fma.rn.f32 f494, f489, f404, f493;
shl.b32 r14, r13, 2;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 400, r15;
st.shared.f32 [r16], f386;
st.shared.f32 [r16+40], f412;
st.shared.f32 [r16+80], f422;
st.shared.f32 [r16+120], f432;
st.shared.f32 [r16+160], f442;
st.shared.f32 [r16+200], f452;
st.shared.f32 [r16+240], f462;
st.shared.f32 [r16+280], f472;
st.shared.f32 [r16+320], f482;
st.shared.f32 [r16+360], f492;
barrier.sync 0;
ld.shared.f32 f495, [r10];
ld.shared.f32 f496, [r10+4000];
ld.shared.f32 f497, [r10+8000];
ld.shared.f32 f498, [r10+12000];
ld.shared.f32 f499, [r10+16000];
ld.shared.f32 f500, [r10+20000];
ld.shared.f32 f501, [r10+24000];
ld.shared.f32 f502, [r10+28000];
ld.shared.f32 f503, [r10+32000];
ld.shared.f32 f504, [r10+36000];
barrier.sync 0;
st.shared.f32 [r16], f387;
st.shared.f32 [r16+40], f414;
st.shared.f32 [r16+80], f424;
st.shared.f32 [r16+120], f434;
st.shared.f32 [r16+160], f444;
st.shared.f32 [r16+200], f454;
st.shared.f32 [r16+240], f464;
st.shared.f32 [r16+280], f474;
st.shared.f32 [r16+320], f484;
st.shared.f32 [r16+360], f494;
barrier.sync 0;
ld.shared.f32 f505, [r10];
ld.shared.f32 f506, [r10+4000];
ld.shared.f32 f507, [r10+8000];
ld.shared.f32 f508, [r10+12000];
ld.shared.f32 f509, [r10+16000];
ld.shared.f32 f510, [r10+20000];
ld.shared.f32 f511, [r10+24000];
ld.shared.f32 f512, [r10+28000];
ld.shared.f32 f513, [r10+32000];
ld.shared.f32 f514, [r10+36000];
add.f32 f515, f497, f503;
add.f32 f516, f495, f515;
add.f32 f517, f499, f501;
add.f32 f518, f517, f516;
add.f32 f519, f507, f513;
add.f32 f520, f505, f519;
add.f32 f521, f509, f511;
add.f32 f522, f521, f520;
fma.rn.f32 f523, f515, 0f3E9E377A, f495;
mul.f32 f524, f517, 0f3F4F1BBD;
sub.f32 f525, f523, f524;
sub.f32 f526, f507, f513;
mul.f32 f527, f526, 0f3F737871;
sub.f32 f528, f509, f511;
mul.f32 f529, f528, 0fBF167918;
sub.f32 f530, f529, f527;
sub.f32 f531, f525, f530;
add.f32 f532, f530, f525;
mul.f32 f533, f515, 0f3F4F1BBD;
sub.f32 f534, f495, f533;
fma.rn.f32 f535, f517, 0f3E9E377A, f534;
mul.f32 f536, f526, 0f3F167918;
mul.f32 f537, f528, 0f3F737871;
sub.f32 f538, f537, f536;
sub.f32 f539, f535, f538;
add.f32 f540, f538, f535;
fma.rn.f32 f541, f519, 0f3E9E377A, f505;
mul.f32 f542, f521, 0f3F4F1BBD;
sub.f32 f543, f541, f542;
sub.f32 f544, f497, f503;
mul.f32 f545, f544, 0f3F737871;
sub.f32 f546, f499, f501;
mul.f32 f547, f546, 0fBF167918;
sub.f32 f548, f547, f545;
add.f32 f549, f548, f543;
sub.f32 f550, f543, f548;
mul.f32 f551, f519, 0f3F4F1BBD;
sub.f32 f552, f505, f551;
fma.rn.f32 f553, f521, 0f3E9E377A, f552;
mul.f32 f554, f544, 0f3F167918;
mul.f32 f555, f546, 0f3F737871;
sub.f32 f556, f555, f554;
add.f32 f557, f556, f553;
sub.f32 f558, f553, f556;
add.f32 f559, f498, f504;
add.f32 f560, f496, f559;
add.f32 f561, f500, f502;
add.f32 f562, f561, f560;
add.f32 f563, f508, f514;
add.f32 f564, f506, f563;
add.f32 f565, f510, f512;
add.f32 f566, f565, f564;
fma.rn.f32 f567, f559, 0f3E9E377A, f496;
mul.f32 f568, f561, 0f3F4F1BBD;
sub.f32 f569, f567, f568;
sub.f32 f570, f508, f514;
mul.f32 f571, f570, 0f3F737871;
sub.f32 f572, f510, f512;
mul.f32 f573, f572, 0fBF167918;
sub.f32 f574, f573, f571;
sub.f32 f575, f569, f574;
add.f32 f576, f574, f569;
mul.f32 f577, f559, 0f3F4F1BBD;
sub.f32 f578, f496, f577;
fma.rn.f32 f579, f561, 0f3E9E377A, f578;
mul.f32 f580, f570, 0f3F167918;
mul.f32 f581, f572, 0f3F737871;
sub.f32 f582, f581, f580;
sub.f32 f583, f579, f582;
add.f32 f584, f582, f579;
fma.rn.f32 f585, f563, 0f3E9E377A, f506;
mul.f32 f586, f565, 0f3F4F1BBD;
sub.f32 f587, f585, f586;
sub.f32 f588, f498, f504;
mul.f32 f589, f588, 0f3F737871;
sub.f32 f590, f500, f502;
mul.f32 f591, f590, 0fBF167918;
sub.f32 f592, f591, f589;
add.f32 f593, f592, f587;
sub.f32 f594, f587, f592;
mul.f32 f595, f563, 0f3F4F1BBD;
sub.f32 f596, f506, f595;
fma.rn.f32 f597, f565, 0f3E9E377A, f596;
mul.f32 f598, f588, 0f3F167918;
mul.f32 f599, f590, 0f3F737871;
sub.f32 f600, f599, f598;
add.f32 f601, f600, f597;
sub.f32 f602, f597, f600;
mul.f32 f603, f575, 0f3F4F1BBD;
mul.f32 f604, f593, 0fBF167918;
sub.f32 f605, f603, f604;
mul.f32 f606, f593, 0f3F4F1BBD;
fma.rn.f32 f607, f575, 0fBF167918, f606;
mul.f32 f608, f583, 0f3E9E377A;
mul.f32 f609, f601, 0fBF737871;
sub.f32 f610, f608, f609;
mul.f32 f611, f601, 0f3E9E377A;
fma.rn.f32 f612, f583, 0fBF737871, f611;
mul.f32 f613, f584, 0fBE9E377A;
mul.f32 f614, f602, 0fBF737871;
sub.f32 f615, f613, f614;
mul.f32 f616, f602, 0fBE9E377A;
fma.rn.f32 f617, f584, 0fBF737871, f616;
mul.f32 f618, f576, 0fBF4F1BBD;
mul.f32 f619, f594, 0fBF167918;
sub.f32 f620, f618, f619;
mul.f32 f621, f594, 0fBF4F1BBD;
fma.rn.f32 f622, f576, 0fBF167918, f621;
add.f32 f623, f518, f562;
add.f32 f624, f522, f566;
sub.f32 f625, f518, f562;
sub.f32 f626, f522, f566;
add.f32 f627, f531, f605;
add.f32 f628, f549, f607;
sub.f32 f629, f531, f605;
sub.f32 f630, f549, f607;
add.f32 f631, f539, f610;
add.f32 f632, f557, f612;
sub.f32 f633, f539, f610;
sub.f32 f634, f557, f612;
add.f32 f635, f540, f615;
add.f32 f636, f558, f617;
sub.f32 f637, f540, f615;
sub.f32 f638, f558, f617;
add.f32 f639, f532, f620;
add.f32 f640, f550, f622;
sub.f32 f641, f532, f620;
sub.f32 f642, f550, f622;
mul.wide.u32 rd12, r7, 1374389535;
shr.u64 rd13, rd12, 37;
cvt.u32.u64 r17, rd13;
mul.lo.s32 r18, r17, 100;
sub.s32 r19, r7, r18;
mul.wide.u32 rd14, r17, 8;
mov.u64 rd15, %23;
add.s64 rd16, rd15, rd14;
ld.global.v2.f32 {f643, f644}, [rd16];
mul.f32 f647, f643, f627;
mul.f32 f648, f644, f628;
sub.f32 f649, f647, f648;
mul.f32 f650, f643, f628;
fma.rn.f32 f651, f644, f627, f650;
mul.f32 f652, f643, f643;
mul.f32 f653, f644, f644;
sub.f32 f654, f652, f653;
mul.f32 f655, f644, f643;
fma.rn.f32 f656, f644, f643, f655;
mul.f32 f657, f654, f631;
mul.f32 f658, f656, f632;
sub.f32 f659, f657, f658;
mul.f32 f660, f654, f632;
fma.rn.f32 f661, f656, f631, f660;
mul.f32 f662, f643, f654;
mul.f32 f663, f644, f656;
sub.f32 f664, f662, f663;
mul.f32 f665, f643, f656;
fma.rn.f32 f666, f644, f654, f665;
mul.f32 f667, f664, f635;
mul.f32 f668, f666, f636;
sub.f32 f669, f667, f668;
mul.f32 f670, f664, f636;
fma.rn.f32 f671, f666, f635, f670;
mul.f32 f672, f643, f664;
mul.f32 f673, f644, f666;
sub.f32 f674, f672, f673;
mul.f32 f675, f643, f666;
fma.rn.f32 f676, f644, f664, f675;
mul.f32 f677, f674, f639;
mul.f32 f678, f676, f640;
sub.f32 f679, f677, f678;
mul.f32 f680, f674, f640;
fma.rn.f32 f681, f676, f639, f680;
mul.f32 f682, f643, f674;
mul.f32 f683, f644, f676;
sub.f32 f684, f682, f683;
mul.f32 f685, f643, f676;
fma.rn.f32 f686, f644, f674, f685;
mul.f32 f687, f684, f625;
mul.f32 f688, f686, f626;
sub.f32 f689, f687, f688;
mul.f32 f690, f684, f626;
fma.rn.f32 f691, f686, f625, f690;
mul.f32 f692, f643, f684;
mul.f32 f693, f644, f686;
sub.f32 f694, f692, f693;
mul.f32 f695, f643, f686;
fma.rn.f32 f696, f644, f684, f695;
mul.f32 f697, f694, f629;
mul.f32 f698, f696, f630;
sub.f32 f699, f697, f698;
mul.f32 f700, f694, f630;
fma.rn.f32 f701, f696, f629, f700;
mul.f32 f702, f643, f694;
mul.f32 f703, f644, f696;
sub.f32 f704, f702, f703;
mul.f32 f705, f643, f696;
fma.rn.f32 f706, f644, f694, f705;
mul.f32 f707, f704, f633;
mul.f32 f708, f706, f634;
sub.f32 f709, f707, f708;
mul.f32 f710, f704, f634;
fma.rn.f32 f711, f706, f633, f710;
mul.f32 f712, f643, f704;
mul.f32 f713, f644, f706;
sub.f32 f714, f712, f713;
mul.f32 f715, f643, f706;
fma.rn.f32 f716, f644, f704, f715;
mul.f32 f717, f714, f637;
mul.f32 f718, f716, f638;
sub.f32 f719, f717, f718;
mul.f32 f720, f714, f638;
fma.rn.f32 f721, f716, f637, f720;
mul.f32 f722, f643, f714;
mul.f32 f723, f644, f716;
sub.f32 f724, f722, f723;
mul.f32 f725, f643, f716;
fma.rn.f32 f726, f644, f714, f725;
mul.f32 f727, f724, f641;
mul.f32 f728, f726, f642;
sub.f32 f729, f727, f728;
mul.f32 f730, f724, f642;
fma.rn.f32 f731, f726, f641, f730;
shl.b32 r20, r19, 2;
add.s32 r21, r8, r20;
barrier.sync 0;
mad.lo.s32 r22, r17, 4000, r21;
st.shared.f32 [r22], f623;
st.shared.f32 [r22+400], f649;
st.shared.f32 [r22+800], f659;
st.shared.f32 [r22+1200], f669;
st.shared.f32 [r22+1600], f679;
st.shared.f32 [r22+2000], f689;
st.shared.f32 [r22+2400], f699;
st.shared.f32 [r22+2800], f709;
st.shared.f32 [r22+3200], f719;
st.shared.f32 [r22+3600], f729;
barrier.sync 0;
ld.shared.f32 f732, [r10];
ld.shared.f32 f733, [r10+4000];
ld.shared.f32 f734, [r10+8000];
ld.shared.f32 f735, [r10+12000];
ld.shared.f32 f736, [r10+16000];
ld.shared.f32 f737, [r10+20000];
ld.shared.f32 f738, [r10+24000];
ld.shared.f32 f739, [r10+28000];
ld.shared.f32 f740, [r10+32000];
ld.shared.f32 f741, [r10+36000];
barrier.sync 0;
st.shared.f32 [r22], f624;
st.shared.f32 [r22+400], f651;
st.shared.f32 [r22+800], f661;
st.shared.f32 [r22+1200], f671;
st.shared.f32 [r22+1600], f681;
st.shared.f32 [r22+2000], f691;
st.shared.f32 [r22+2400], f701;
st.shared.f32 [r22+2800], f711;
st.shared.f32 [r22+3200], f721;
st.shared.f32 [r22+3600], f731;
barrier.sync 0;
ld.shared.f32 f742, [r10];
ld.shared.f32 f743, [r10+4000];
ld.shared.f32 f744, [r10+8000];
ld.shared.f32 f745, [r10+12000];
ld.shared.f32 f746, [r10+16000];
ld.shared.f32 f747, [r10+20000];
ld.shared.f32 f748, [r10+24000];
ld.shared.f32 f749, [r10+28000];
ld.shared.f32 f750, [r10+32000];
ld.shared.f32 f751, [r10+36000];
add.f32 f752, f734, f740;
add.f32 f753, f732, f752;
add.f32 f754, f736, f738;
add.f32 f755, f754, f753;
add.f32 f756, f744, f750;
add.f32 f757, f742, f756;
add.f32 f758, f746, f748;
add.f32 f759, f758, f757;
fma.rn.f32 f760, f752, 0f3E9E377A, f732;
mul.f32 f761, f754, 0f3F4F1BBD;
sub.f32 f762, f760, f761;
sub.f32 f763, f744, f750;
mul.f32 f764, f763, 0f3F737871;
sub.f32 f765, f746, f748;
mul.f32 f766, f765, 0fBF167918;
sub.f32 f767, f766, f764;
sub.f32 f768, f762, f767;
add.f32 f769, f767, f762;
mul.f32 f770, f752, 0f3F4F1BBD;
sub.f32 f771, f732, f770;
fma.rn.f32 f772, f754, 0f3E9E377A, f771;
mul.f32 f773, f763, 0f3F167918;
mul.f32 f774, f765, 0f3F737871;
sub.f32 f775, f774, f773;
sub.f32 f776, f772, f775;
add.f32 f777, f775, f772;
fma.rn.f32 f778, f756, 0f3E9E377A, f742;
mul.f32 f779, f758, 0f3F4F1BBD;
sub.f32 f780, f778, f779;
sub.f32 f781, f734, f740;
mul.f32 f782, f781, 0f3F737871;
sub.f32 f783, f736, f738;
mul.f32 f784, f783, 0fBF167918;
sub.f32 f785, f784, f782;
add.f32 f786, f785, f780;
sub.f32 f787, f780, f785;
mul.f32 f788, f756, 0f3F4F1BBD;
sub.f32 f789, f742, f788;
fma.rn.f32 f790, f758, 0f3E9E377A, f789;
mul.f32 f791, f781, 0f3F167918;
mul.f32 f792, f783, 0f3F737871;
sub.f32 f793, f792, f791;
add.f32 f794, f793, f790;
sub.f32 f795, f790, f793;
add.f32 f796, f735, f741;
add.f32 f797, f733, f796;
add.f32 f798, f737, f739;
add.f32 f799, f798, f797;
add.f32 f800, f745, f751;
add.f32 f801, f743, f800;
add.f32 f802, f747, f749;
add.f32 f803, f802, f801;
fma.rn.f32 f804, f796, 0f3E9E377A, f733;
mul.f32 f805, f798, 0f3F4F1BBD;
sub.f32 f806, f804, f805;
sub.f32 f807, f745, f751;
mul.f32 f808, f807, 0f3F737871;
sub.f32 f809, f747, f749;
mul.f32 f810, f809, 0fBF167918;
sub.f32 f811, f810, f808;
sub.f32 f812, f806, f811;
add.f32 f813, f811, f806;
mul.f32 f814, f796, 0f3F4F1BBD;
sub.f32 f815, f733, f814;
fma.rn.f32 f816, f798, 0f3E9E377A, f815;
mul.f32 f817, f807, 0f3F167918;
mul.f32 f818, f809, 0f3F737871;
sub.f32 f819, f818, f817;
sub.f32 f820, f816, f819;
add.f32 f821, f819, f816;
fma.rn.f32 f822, f800, 0f3E9E377A, f743;
mul.f32 f823, f802, 0f3F4F1BBD;
sub.f32 f824, f822, f823;
sub.f32 f825, f735, f741;
mul.f32 f826, f825, 0f3F737871;
sub.f32 f827, f737, f739;
mul.f32 f828, f827, 0fBF167918;
sub.f32 f829, f828, f826;
add.f32 f830, f829, f824;
sub.f32 f831, f824, f829;
mul.f32 f832, f800, 0f3F4F1BBD;
sub.f32 f833, f743, f832;
fma.rn.f32 f834, f802, 0f3E9E377A, f833;
mul.f32 f835, f825, 0f3F167918;
mul.f32 f836, f827, 0f3F737871;
sub.f32 f837, f836, f835;
add.f32 f838, f837, f834;
sub.f32 f839, f834, f837;
mul.f32 f840, f812, 0f3F4F1BBD;
mul.f32 f841, f830, 0fBF167918;
sub.f32 f842, f840, f841;
mul.f32 f843, f830, 0f3F4F1BBD;
fma.rn.f32 f844, f812, 0fBF167918, f843;
mul.f32 f845, f820, 0f3E9E377A;
mul.f32 f846, f838, 0fBF737871;
sub.f32 f847, f845, f846;
mul.f32 f848, f838, 0f3E9E377A;
fma.rn.f32 f849, f820, 0fBF737871, f848;
mul.f32 f850, f821, 0fBE9E377A;
mul.f32 f851, f839, 0fBF737871;
sub.f32 f852, f850, f851;
mul.f32 f853, f839, 0fBE9E377A;
fma.rn.f32 f854, f821, 0fBF737871, f853;
mul.f32 f855, f813, 0fBF4F1BBD;
mul.f32 f856, f831, 0fBF167918;
sub.f32 f857, f855, f856;
mul.f32 f858, f831, 0fBF4F1BBD;
fma.rn.f32 f859, f813, 0fBF167918, f858;
add.f32 %0, f755, f799;
add.f32 %1, f759, f803;
add.f32 %3, f786, f844;
add.f32 %2, f768, f842;
add.f32 %5, f794, f849;
add.f32 %4, f776, f847;
add.f32 %7, f795, f854;
add.f32 %6, f777, f852;
add.f32 %9, f787, f859;
add.f32 %8, f769, f857;
sub.f32 %10, f755, f799;
sub.f32 %11, f759, f803;
sub.f32 %13, f786, f844;
sub.f32 %12, f768, f842;
sub.f32 %15, f794, f849;
sub.f32 %14, f776, f847;
sub.f32 %17, f795, f854;
sub.f32 %16, f777, f852;
sub.f32 %19, f787, f859;
sub.f32 %18, f769, f857;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y): "r"(smem), "l"(lut_sp_10_10000), "l"(lut_sp_10_1000), "l"(lut_sp_10_100), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y));
};


#endif
