#ifndef CUFFTDX_FFT_100_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_100_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<567, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<405>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 800, r2;
mov.u32 r4, %tid.x;
add.f64 fd41, %27, %43;
add.f64 fd42, %22, fd41;
add.f64 fd43, %32, %38;
add.f64 fd44, fd43, fd42;
add.f64 fd45, %29, %45;
add.f64 fd46, %23, fd45;
add.f64 fd47, %34, %39;
add.f64 fd48, fd47, fd46;
fma.rn.f64 fd49, fd41, 0d3FD3C6EF372FE950, %22;
mul.f64 fd50, fd43, 0d3FE9E3779B97F4A8;
sub.f64 fd51, fd49, fd50;
sub.f64 fd52, %29, %45;
mul.f64 fd53, fd52, 0d3FEE6F0E134454FF;
sub.f64 fd54, %34, %39;
mul.f64 fd55, fd54, 0dBFE2CF2304755A5E;
sub.f64 fd56, fd55, fd53;
sub.f64 fd57, fd51, fd56;
add.f64 fd58, fd56, fd51;
mul.f64 fd59, fd41, 0d3FE9E3779B97F4A8;
sub.f64 fd60, %22, fd59;
fma.rn.f64 fd61, fd43, 0d3FD3C6EF372FE950, fd60;
mul.f64 fd62, fd52, 0d3FE2CF2304755A5E;
mul.f64 fd63, fd54, 0d3FEE6F0E134454FF;
sub.f64 fd64, fd63, fd62;
sub.f64 fd65, fd61, fd64;
add.f64 fd66, fd64, fd61;
fma.rn.f64 fd67, fd45, 0d3FD3C6EF372FE950, %23;
mul.f64 fd68, fd47, 0d3FE9E3779B97F4A8;
sub.f64 fd69, fd67, fd68;
sub.f64 fd70, %27, %43;
mul.f64 fd71, fd70, 0d3FEE6F0E134454FF;
sub.f64 fd72, %32, %38;
mul.f64 fd73, fd72, 0dBFE2CF2304755A5E;
sub.f64 fd74, fd73, fd71;
add.f64 fd75, fd74, fd69;
sub.f64 fd76, fd69, fd74;
mul.f64 fd77, fd45, 0d3FE9E3779B97F4A8;
sub.f64 fd78, %23, fd77;
fma.rn.f64 fd79, fd47, 0d3FD3C6EF372FE950, fd78;
mul.f64 fd80, fd70, 0d3FE2CF2304755A5E;
mul.f64 fd81, fd72, 0d3FEE6F0E134454FF;
sub.f64 fd82, fd81, fd80;
add.f64 fd83, fd82, fd79;
sub.f64 fd84, fd79, fd82;
add.f64 fd85, %30, %46;
add.f64 fd86, %24, fd85;
add.f64 fd87, %35, %40;
add.f64 fd88, fd87, fd86;
add.f64 fd89, %31, %47;
add.f64 fd90, %26, fd89;
add.f64 fd91, %37, %42;
add.f64 fd92, fd91, fd90;
fma.rn.f64 fd93, fd85, 0d3FD3C6EF372FE950, %24;
mul.f64 fd94, fd87, 0d3FE9E3779B97F4A8;
sub.f64 fd95, fd93, fd94;
sub.f64 fd96, %31, %47;
mul.f64 fd97, fd96, 0d3FEE6F0E134454FF;
sub.f64 fd98, %37, %42;
mul.f64 fd99, fd98, 0dBFE2CF2304755A5E;
sub.f64 fd100, fd99, fd97;
sub.f64 fd101, fd95, fd100;
add.f64 fd102, fd100, fd95;
mul.f64 fd103, fd85, 0d3FE9E3779B97F4A8;
sub.f64 fd104, %24, fd103;
fma.rn.f64 fd105, fd87, 0d3FD3C6EF372FE950, fd104;
mul.f64 fd106, fd96, 0d3FE2CF2304755A5E;
mul.f64 fd107, fd98, 0d3FEE6F0E134454FF;
sub.f64 fd108, fd107, fd106;
sub.f64 fd109, fd105, fd108;
add.f64 fd110, fd108, fd105;
fma.rn.f64 fd111, fd89, 0d3FD3C6EF372FE950, %26;
mul.f64 fd112, fd91, 0d3FE9E3779B97F4A8;
sub.f64 fd113, fd111, fd112;
sub.f64 fd114, %30, %46;
mul.f64 fd115, fd114, 0d3FEE6F0E134454FF;
sub.f64 fd116, %35, %40;
mul.f64 fd117, fd116, 0dBFE2CF2304755A5E;
sub.f64 fd118, fd117, fd115;
add.f64 fd119, fd118, fd113;
sub.f64 fd120, fd113, fd118;
mul.f64 fd121, fd89, 0d3FE9E3779B97F4A8;
sub.f64 fd122, %26, fd121;
fma.rn.f64 fd123, fd91, 0d3FD3C6EF372FE950, fd122;
mul.f64 fd124, fd114, 0d3FE2CF2304755A5E;
mul.f64 fd125, fd116, 0d3FEE6F0E134454FF;
sub.f64 fd126, fd125, fd124;
add.f64 fd127, fd126, fd123;
sub.f64 fd128, fd123, fd126;
mul.f64 fd129, fd101, 0d3FE9E3779B97F4A8;
mul.f64 fd130, fd119, 0dBFE2CF2304755A5E;
sub.f64 fd131, fd129, fd130;
mul.f64 fd132, fd119, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd133, fd101, 0dBFE2CF2304755A5E, fd132;
mul.f64 fd134, fd109, 0d3FD3C6EF372FE950;
mul.f64 fd135, fd127, 0dBFEE6F0E134454FF;
sub.f64 fd136, fd134, fd135;
mul.f64 fd137, fd127, 0d3FD3C6EF372FE950;
fma.rn.f64 fd138, fd109, 0dBFEE6F0E134454FF, fd137;
mul.f64 fd139, fd110, 0dBFD3C6EF372FE950;
mul.f64 fd140, fd128, 0dBFEE6F0E134454FF;
sub.f64 fd141, fd139, fd140;
mul.f64 fd142, fd128, 0dBFD3C6EF372FE950;
fma.rn.f64 fd143, fd110, 0dBFEE6F0E134454FF, fd142;
mul.f64 fd144, fd102, 0dBFE9E3779B97F4A8;
mul.f64 fd145, fd120, 0dBFE2CF2304755A5E;
sub.f64 fd146, fd144, fd145;
mul.f64 fd147, fd120, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd148, fd102, 0dBFE2CF2304755A5E, fd147;
add.f64 fd149, fd44, fd88;
add.f64 fd150, fd48, fd92;
sub.f64 fd151, fd44, fd88;
sub.f64 fd152, fd48, fd92;
add.f64 fd153, fd57, fd131;
add.f64 fd154, fd75, fd133;
sub.f64 fd155, fd57, fd131;
sub.f64 fd156, fd75, fd133;
add.f64 fd157, fd65, fd136;
add.f64 fd158, fd83, fd138;
sub.f64 fd159, fd65, fd136;
sub.f64 fd160, fd83, fd138;
add.f64 fd161, fd66, fd141;
add.f64 fd162, fd84, fd143;
sub.f64 fd163, fd66, fd141;
sub.f64 fd164, fd84, fd143;
add.f64 fd165, fd58, fd146;
add.f64 fd166, fd76, fd148;
sub.f64 fd167, fd58, fd146;
sub.f64 fd168, fd76, fd148;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 10;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd169, fd170}, [rd6];
mul.f64 fd173, fd169, fd153;
mul.f64 fd174, fd170, fd154;
sub.f64 fd175, fd173, fd174;
mul.f64 fd176, fd169, fd154;
fma.rn.f64 fd177, fd170, fd153, fd176;
mul.f64 fd178, fd169, fd169;
mul.f64 fd179, fd170, fd170;
sub.f64 fd180, fd178, fd179;
mul.f64 fd181, fd170, fd169;
fma.rn.f64 fd182, fd170, fd169, fd181;
mul.f64 fd183, fd180, fd157;
mul.f64 fd184, fd182, fd158;
sub.f64 fd185, fd183, fd184;
mul.f64 fd186, fd180, fd158;
fma.rn.f64 fd187, fd182, fd157, fd186;
mul.f64 fd188, fd169, fd180;
mul.f64 fd189, fd170, fd182;
sub.f64 fd190, fd188, fd189;
mul.f64 fd191, fd169, fd182;
fma.rn.f64 fd192, fd170, fd180, fd191;
mul.f64 fd193, fd190, fd161;
mul.f64 fd194, fd192, fd162;
sub.f64 fd195, fd193, fd194;
mul.f64 fd196, fd190, fd162;
fma.rn.f64 fd197, fd192, fd161, fd196;
mul.f64 fd198, fd169, fd190;
mul.f64 fd199, fd170, fd192;
sub.f64 fd200, fd198, fd199;
mul.f64 fd201, fd169, fd192;
fma.rn.f64 fd202, fd170, fd190, fd201;
mul.f64 fd203, fd200, fd165;
mul.f64 fd204, fd202, fd166;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd200, fd166;
fma.rn.f64 fd207, fd202, fd165, fd206;
mul.f64 fd208, fd169, fd200;
mul.f64 fd209, fd170, fd202;
sub.f64 fd210, fd208, fd209;
mul.f64 fd211, fd169, fd202;
fma.rn.f64 fd212, fd170, fd200, fd211;
mul.f64 fd213, fd210, fd151;
mul.f64 fd214, fd212, fd152;
sub.f64 fd215, fd213, fd214;
mul.f64 fd216, fd210, fd152;
fma.rn.f64 fd217, fd212, fd151, fd216;
ld.global.v2.f64 {fd218, fd219}, [rd6+160];
mul.f64 fd222, fd218, fd155;
mul.f64 fd223, fd219, fd156;
sub.f64 fd224, fd222, fd223;
mul.f64 fd225, fd218, fd156;
fma.rn.f64 fd226, fd219, fd155, fd225;
mul.f64 fd227, fd169, fd218;
mul.f64 fd228, fd170, fd219;
sub.f64 fd229, fd227, fd228;
mul.f64 fd230, fd169, fd219;
fma.rn.f64 fd231, fd170, fd218, fd230;
mul.f64 fd232, fd229, fd159;
mul.f64 fd233, fd231, fd160;
sub.f64 fd234, fd232, fd233;
mul.f64 fd235, fd229, fd160;
fma.rn.f64 fd236, fd231, fd159, fd235;
mul.f64 fd237, fd169, fd229;
mul.f64 fd238, fd170, fd231;
sub.f64 fd239, fd237, fd238;
mul.f64 fd240, fd169, fd231;
fma.rn.f64 fd241, fd170, fd229, fd240;
mul.f64 fd242, fd239, fd163;
mul.f64 fd243, fd241, fd164;
sub.f64 fd244, fd242, fd243;
mul.f64 fd245, fd239, fd164;
fma.rn.f64 fd246, fd241, fd163, fd245;
mul.f64 fd247, fd169, fd239;
mul.f64 fd248, fd170, fd241;
sub.f64 fd249, fd247, fd248;
mul.f64 fd250, fd169, fd241;
fma.rn.f64 fd251, fd170, fd239, fd250;
mul.f64 fd252, fd249, fd167;
mul.f64 fd253, fd251, fd168;
sub.f64 fd254, fd252, fd253;
mul.f64 fd255, fd249, fd168;
fma.rn.f64 fd256, fd251, fd167, fd255;
mad.lo.s32 r8, r5, 800, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
st.shared.v2.f64 [r9], {fd149, fd175};
st.shared.v2.f64 [r9+16], {fd185, fd195};
st.shared.v2.f64 [r9+32], {fd205, fd215};
st.shared.v2.f64 [r9+48], {fd224, fd234};
st.shared.v2.f64 [r9+64], {fd244, fd254};
barrier.sync 0;
mad.lo.s32 r10, r7, -72, r9;
ld.shared.f64 fd257, [r10];
ld.shared.f64 fd258, [r10+80];
ld.shared.f64 fd259, [r10+160];
ld.shared.f64 fd260, [r10+240];
ld.shared.f64 fd261, [r10+320];
ld.shared.f64 fd262, [r10+400];
ld.shared.f64 fd263, [r10+480];
ld.shared.f64 fd264, [r10+560];
ld.shared.f64 fd265, [r10+640];
ld.shared.f64 fd266, [r10+720];
barrier.sync 0;
st.shared.v2.f64 [r9], {fd150, fd177};
st.shared.v2.f64 [r9+16], {fd187, fd197};
st.shared.v2.f64 [r9+32], {fd207, fd217};
st.shared.v2.f64 [r9+48], {fd226, fd236};
st.shared.v2.f64 [r9+64], {fd246, fd256};
barrier.sync 0;
ld.shared.f64 fd267, [r10];
ld.shared.f64 fd268, [r10+80];
ld.shared.f64 fd269, [r10+160];
ld.shared.f64 fd270, [r10+240];
ld.shared.f64 fd271, [r10+320];
ld.shared.f64 fd272, [r10+400];
ld.shared.f64 fd273, [r10+480];
ld.shared.f64 fd274, [r10+560];
ld.shared.f64 fd275, [r10+640];
ld.shared.f64 fd276, [r10+720];
add.f64 fd277, fd259, fd265;
add.f64 fd278, fd257, fd277;
add.f64 fd279, fd261, fd263;
add.f64 fd280, fd279, fd278;
add.f64 fd281, fd269, fd275;
add.f64 fd282, fd267, fd281;
add.f64 fd283, fd271, fd273;
add.f64 fd284, fd283, fd282;
fma.rn.f64 fd285, fd277, 0d3FD3C6EF372FE950, fd257;
mul.f64 fd286, fd279, 0d3FE9E3779B97F4A8;
sub.f64 fd287, fd285, fd286;
sub.f64 fd288, fd269, fd275;
mul.f64 fd289, fd288, 0d3FEE6F0E134454FF;
sub.f64 fd290, fd271, fd273;
mul.f64 fd291, fd290, 0dBFE2CF2304755A5E;
sub.f64 fd292, fd291, fd289;
sub.f64 fd293, fd287, fd292;
add.f64 fd294, fd292, fd287;
mul.f64 fd295, fd277, 0d3FE9E3779B97F4A8;
sub.f64 fd296, fd257, fd295;
fma.rn.f64 fd297, fd279, 0d3FD3C6EF372FE950, fd296;
mul.f64 fd298, fd288, 0d3FE2CF2304755A5E;
mul.f64 fd299, fd290, 0d3FEE6F0E134454FF;
sub.f64 fd300, fd299, fd298;
sub.f64 fd301, fd297, fd300;
add.f64 fd302, fd300, fd297;
fma.rn.f64 fd303, fd281, 0d3FD3C6EF372FE950, fd267;
mul.f64 fd304, fd283, 0d3FE9E3779B97F4A8;
sub.f64 fd305, fd303, fd304;
sub.f64 fd306, fd259, fd265;
mul.f64 fd307, fd306, 0d3FEE6F0E134454FF;
sub.f64 fd308, fd261, fd263;
mul.f64 fd309, fd308, 0dBFE2CF2304755A5E;
sub.f64 fd310, fd309, fd307;
add.f64 fd311, fd310, fd305;
sub.f64 fd312, fd305, fd310;
mul.f64 fd313, fd281, 0d3FE9E3779B97F4A8;
sub.f64 fd314, fd267, fd313;
fma.rn.f64 fd315, fd283, 0d3FD3C6EF372FE950, fd314;
mul.f64 fd316, fd306, 0d3FE2CF2304755A5E;
mul.f64 fd317, fd308, 0d3FEE6F0E134454FF;
sub.f64 fd318, fd317, fd316;
add.f64 fd319, fd318, fd315;
sub.f64 fd320, fd315, fd318;
add.f64 fd321, fd260, fd266;
add.f64 fd322, fd258, fd321;
add.f64 fd323, fd262, fd264;
add.f64 fd324, fd323, fd322;
add.f64 fd325, fd270, fd276;
add.f64 fd326, fd268, fd325;
add.f64 fd327, fd272, fd274;
add.f64 fd328, fd327, fd326;
fma.rn.f64 fd329, fd321, 0d3FD3C6EF372FE950, fd258;
mul.f64 fd330, fd323, 0d3FE9E3779B97F4A8;
sub.f64 fd331, fd329, fd330;
sub.f64 fd332, fd270, fd276;
mul.f64 fd333, fd332, 0d3FEE6F0E134454FF;
sub.f64 fd334, fd272, fd274;
mul.f64 fd335, fd334, 0dBFE2CF2304755A5E;
sub.f64 fd336, fd335, fd333;
sub.f64 fd337, fd331, fd336;
add.f64 fd338, fd336, fd331;
mul.f64 fd339, fd321, 0d3FE9E3779B97F4A8;
sub.f64 fd340, fd258, fd339;
fma.rn.f64 fd341, fd323, 0d3FD3C6EF372FE950, fd340;
mul.f64 fd342, fd332, 0d3FE2CF2304755A5E;
mul.f64 fd343, fd334, 0d3FEE6F0E134454FF;
sub.f64 fd344, fd343, fd342;
sub.f64 fd345, fd341, fd344;
add.f64 fd346, fd344, fd341;
fma.rn.f64 fd347, fd325, 0d3FD3C6EF372FE950, fd268;
mul.f64 fd348, fd327, 0d3FE9E3779B97F4A8;
sub.f64 fd349, fd347, fd348;
sub.f64 fd350, fd260, fd266;
mul.f64 fd351, fd350, 0d3FEE6F0E134454FF;
sub.f64 fd352, fd262, fd264;
mul.f64 fd353, fd352, 0dBFE2CF2304755A5E;
sub.f64 fd354, fd353, fd351;
add.f64 fd355, fd354, fd349;
sub.f64 fd356, fd349, fd354;
mul.f64 fd357, fd325, 0d3FE9E3779B97F4A8;
sub.f64 fd358, fd268, fd357;
fma.rn.f64 fd359, fd327, 0d3FD3C6EF372FE950, fd358;
mul.f64 fd360, fd350, 0d3FE2CF2304755A5E;
mul.f64 fd361, fd352, 0d3FEE6F0E134454FF;
sub.f64 fd362, fd361, fd360;
add.f64 fd363, fd362, fd359;
sub.f64 fd364, fd359, fd362;
mul.f64 fd365, fd337, 0d3FE9E3779B97F4A8;
mul.f64 fd366, fd355, 0dBFE2CF2304755A5E;
sub.f64 fd367, fd365, fd366;
mul.f64 fd368, fd355, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd369, fd337, 0dBFE2CF2304755A5E, fd368;
mul.f64 fd370, fd345, 0d3FD3C6EF372FE950;
mul.f64 fd371, fd363, 0dBFEE6F0E134454FF;
sub.f64 fd372, fd370, fd371;
mul.f64 fd373, fd363, 0d3FD3C6EF372FE950;
fma.rn.f64 fd374, fd345, 0dBFEE6F0E134454FF, fd373;
mul.f64 fd375, fd346, 0dBFD3C6EF372FE950;
mul.f64 fd376, fd364, 0dBFEE6F0E134454FF;
sub.f64 fd377, fd375, fd376;
mul.f64 fd378, fd364, 0dBFD3C6EF372FE950;
fma.rn.f64 fd379, fd346, 0dBFEE6F0E134454FF, fd378;
mul.f64 fd380, fd338, 0dBFE9E3779B97F4A8;
mul.f64 fd381, fd356, 0dBFE2CF2304755A5E;
sub.f64 fd382, fd380, fd381;
mul.f64 fd383, fd356, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd384, fd338, 0dBFE2CF2304755A5E, fd383;
add.f64 %0, fd280, fd324;
add.f64 %1, fd284, fd328;
add.f64 %3, fd311, fd369;
add.f64 %2, fd293, fd367;
add.f64 %5, fd319, fd374;
add.f64 %4, fd301, fd372;
add.f64 %7, fd320, fd379;
add.f64 %6, fd302, fd377;
add.f64 %9, fd312, fd384;
add.f64 %8, fd294, fd382;
sub.f64 %10, fd280, fd324;
sub.f64 %11, fd284, fd328;
sub.f64 %13, fd311, fd369;
sub.f64 %12, fd293, fd367;
sub.f64 %15, fd319, fd374;
sub.f64 %14, fd301, fd372;
sub.f64 %17, fd320, fd379;
sub.f64 %16, fd302, fd377;
sub.f64 %19, fd312, fd384;
sub.f64 %18, fd294, fd382;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y): "r"(smem), "l"(lut_dp_10_100), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<566, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<425>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 1600, r2;
mov.u32 r4, %tid.x;
add.f64 fd41, %27, %43;
add.f64 fd42, %22, fd41;
add.f64 fd43, %32, %38;
add.f64 fd44, fd43, fd42;
add.f64 fd45, %29, %45;
add.f64 fd46, %23, fd45;
add.f64 fd47, %34, %39;
add.f64 fd48, fd47, fd46;
fma.rn.f64 fd49, fd41, 0d3FD3C6EF372FE950, %22;
mul.f64 fd50, fd43, 0d3FE9E3779B97F4A8;
sub.f64 fd51, fd49, fd50;
sub.f64 fd52, %29, %45;
mul.f64 fd53, fd52, 0d3FEE6F0E134454FF;
sub.f64 fd54, %34, %39;
mul.f64 fd55, fd54, 0dBFE2CF2304755A5E;
sub.f64 fd56, fd55, fd53;
sub.f64 fd57, fd51, fd56;
add.f64 fd58, fd56, fd51;
mul.f64 fd59, fd41, 0d3FE9E3779B97F4A8;
sub.f64 fd60, %22, fd59;
fma.rn.f64 fd61, fd43, 0d3FD3C6EF372FE950, fd60;
mul.f64 fd62, fd52, 0d3FE2CF2304755A5E;
mul.f64 fd63, fd54, 0d3FEE6F0E134454FF;
sub.f64 fd64, fd63, fd62;
sub.f64 fd65, fd61, fd64;
add.f64 fd66, fd64, fd61;
fma.rn.f64 fd67, fd45, 0d3FD3C6EF372FE950, %23;
mul.f64 fd68, fd47, 0d3FE9E3779B97F4A8;
sub.f64 fd69, fd67, fd68;
sub.f64 fd70, %27, %43;
mul.f64 fd71, fd70, 0d3FEE6F0E134454FF;
sub.f64 fd72, %32, %38;
mul.f64 fd73, fd72, 0dBFE2CF2304755A5E;
sub.f64 fd74, fd73, fd71;
add.f64 fd75, fd74, fd69;
sub.f64 fd76, fd69, fd74;
mul.f64 fd77, fd45, 0d3FE9E3779B97F4A8;
sub.f64 fd78, %23, fd77;
fma.rn.f64 fd79, fd47, 0d3FD3C6EF372FE950, fd78;
mul.f64 fd80, fd70, 0d3FE2CF2304755A5E;
mul.f64 fd81, fd72, 0d3FEE6F0E134454FF;
sub.f64 fd82, fd81, fd80;
add.f64 fd83, fd82, fd79;
sub.f64 fd84, fd79, fd82;
add.f64 fd85, %30, %46;
add.f64 fd86, %24, fd85;
add.f64 fd87, %35, %40;
add.f64 fd88, fd87, fd86;
add.f64 fd89, %31, %47;
add.f64 fd90, %26, fd89;
add.f64 fd91, %37, %42;
add.f64 fd92, fd91, fd90;
fma.rn.f64 fd93, fd85, 0d3FD3C6EF372FE950, %24;
mul.f64 fd94, fd87, 0d3FE9E3779B97F4A8;
sub.f64 fd95, fd93, fd94;
sub.f64 fd96, %31, %47;
mul.f64 fd97, fd96, 0d3FEE6F0E134454FF;
sub.f64 fd98, %37, %42;
mul.f64 fd99, fd98, 0dBFE2CF2304755A5E;
sub.f64 fd100, fd99, fd97;
sub.f64 fd101, fd95, fd100;
add.f64 fd102, fd100, fd95;
mul.f64 fd103, fd85, 0d3FE9E3779B97F4A8;
sub.f64 fd104, %24, fd103;
fma.rn.f64 fd105, fd87, 0d3FD3C6EF372FE950, fd104;
mul.f64 fd106, fd96, 0d3FE2CF2304755A5E;
mul.f64 fd107, fd98, 0d3FEE6F0E134454FF;
sub.f64 fd108, fd107, fd106;
sub.f64 fd109, fd105, fd108;
add.f64 fd110, fd108, fd105;
fma.rn.f64 fd111, fd89, 0d3FD3C6EF372FE950, %26;
mul.f64 fd112, fd91, 0d3FE9E3779B97F4A8;
sub.f64 fd113, fd111, fd112;
sub.f64 fd114, %30, %46;
mul.f64 fd115, fd114, 0d3FEE6F0E134454FF;
sub.f64 fd116, %35, %40;
mul.f64 fd117, fd116, 0dBFE2CF2304755A5E;
sub.f64 fd118, fd117, fd115;
add.f64 fd119, fd118, fd113;
sub.f64 fd120, fd113, fd118;
mul.f64 fd121, fd89, 0d3FE9E3779B97F4A8;
sub.f64 fd122, %26, fd121;
fma.rn.f64 fd123, fd91, 0d3FD3C6EF372FE950, fd122;
mul.f64 fd124, fd114, 0d3FE2CF2304755A5E;
mul.f64 fd125, fd116, 0d3FEE6F0E134454FF;
sub.f64 fd126, fd125, fd124;
add.f64 fd127, fd126, fd123;
sub.f64 fd128, fd123, fd126;
mul.f64 fd129, fd101, 0d3FE9E3779B97F4A8;
mul.f64 fd130, fd119, 0dBFE2CF2304755A5E;
sub.f64 fd131, fd129, fd130;
mul.f64 fd132, fd119, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd133, fd101, 0dBFE2CF2304755A5E, fd132;
mul.f64 fd134, fd109, 0d3FD3C6EF372FE950;
mul.f64 fd135, fd127, 0dBFEE6F0E134454FF;
sub.f64 fd136, fd134, fd135;
mul.f64 fd137, fd127, 0d3FD3C6EF372FE950;
fma.rn.f64 fd138, fd109, 0dBFEE6F0E134454FF, fd137;
mul.f64 fd139, fd110, 0dBFD3C6EF372FE950;
mul.f64 fd140, fd128, 0dBFEE6F0E134454FF;
sub.f64 fd141, fd139, fd140;
mul.f64 fd142, fd128, 0dBFD3C6EF372FE950;
fma.rn.f64 fd143, fd110, 0dBFEE6F0E134454FF, fd142;
mul.f64 fd144, fd102, 0dBFE9E3779B97F4A8;
mul.f64 fd145, fd120, 0dBFE2CF2304755A5E;
sub.f64 fd146, fd144, fd145;
mul.f64 fd147, fd120, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd148, fd102, 0dBFE2CF2304755A5E, fd147;
sub.f64 fd149, fd44, fd88;
sub.f64 fd150, fd48, fd92;
add.f64 fd151, fd57, fd131;
add.f64 fd152, fd75, fd133;
sub.f64 fd153, fd57, fd131;
sub.f64 fd154, fd75, fd133;
add.f64 fd155, fd65, fd136;
add.f64 fd156, fd83, fd138;
sub.f64 fd157, fd65, fd136;
sub.f64 fd158, fd83, fd138;
add.f64 fd159, fd66, fd141;
add.f64 fd160, fd84, fd143;
sub.f64 fd161, fd66, fd141;
sub.f64 fd162, fd84, fd143;
add.f64 fd163, fd58, fd146;
add.f64 fd164, fd76, fd148;
sub.f64 fd165, fd58, fd146;
sub.f64 fd166, fd76, fd148;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 10;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 1600, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd167, fd168}, [rd6];
mul.f64 fd171, fd167, fd151;
mul.f64 fd172, fd168, fd152;
mul.f64 fd173, fd167, fd152;
mul.f64 fd174, fd167, fd167;
mul.f64 fd175, fd168, fd168;
sub.f64 fd176, fd174, fd175;
mul.f64 fd177, fd168, fd167;
fma.rn.f64 fd178, fd168, fd167, fd177;
mul.f64 fd179, fd176, fd155;
mul.f64 fd180, fd178, fd156;
mul.f64 fd181, fd176, fd156;
mul.f64 fd182, fd167, fd176;
mul.f64 fd183, fd168, fd178;
sub.f64 fd184, fd182, fd183;
mul.f64 fd185, fd167, fd178;
fma.rn.f64 fd186, fd168, fd176, fd185;
mul.f64 fd187, fd184, fd159;
mul.f64 fd188, fd186, fd160;
mul.f64 fd189, fd184, fd160;
mul.f64 fd190, fd167, fd184;
mul.f64 fd191, fd168, fd186;
sub.f64 fd192, fd190, fd191;
mul.f64 fd193, fd167, fd186;
fma.rn.f64 fd194, fd168, fd184, fd193;
mul.f64 fd195, fd192, fd163;
mul.f64 fd196, fd194, fd164;
mul.f64 fd197, fd192, fd164;
mul.f64 fd198, fd167, fd192;
mul.f64 fd199, fd168, fd194;
sub.f64 fd200, fd198, fd199;
mul.f64 fd201, fd167, fd194;
fma.rn.f64 fd202, fd168, fd192, fd201;
mul.f64 fd203, fd200, fd149;
mul.f64 fd204, fd202, fd150;
mul.f64 fd205, fd200, fd150;
ld.global.v2.f64 {fd206, fd207}, [rd6+160];
mul.f64 fd210, fd206, fd153;
mul.f64 fd211, fd207, fd154;
mul.f64 fd212, fd206, fd154;
mul.f64 fd213, fd167, fd206;
mul.f64 fd214, fd168, fd207;
sub.f64 fd215, fd213, fd214;
mul.f64 fd216, fd167, fd207;
fma.rn.f64 fd217, fd168, fd206, fd216;
mul.f64 fd218, fd215, fd157;
mul.f64 fd219, fd217, fd158;
mul.f64 fd220, fd215, fd158;
mul.f64 fd221, fd167, fd215;
mul.f64 fd222, fd168, fd217;
sub.f64 fd223, fd221, fd222;
mul.f64 fd224, fd167, fd217;
fma.rn.f64 fd225, fd168, fd215, fd224;
mul.f64 fd226, fd223, fd161;
mul.f64 fd227, fd225, fd162;
mul.f64 fd228, fd223, fd162;
mul.f64 fd229, fd167, fd223;
mul.f64 fd230, fd168, fd225;
sub.f64 fd231, fd229, fd230;
mul.f64 fd232, fd167, fd225;
fma.rn.f64 fd233, fd168, fd223, fd232;
mul.f64 fd234, fd231, fd165;
mul.f64 fd235, fd233, fd166;
mul.f64 fd236, fd231, fd166;
barrier.sync 0;
mad.lo.s32 r9, r7, 160, r8;
add.f64 fd237, fd48, fd92;
add.f64 fd238, fd44, fd88;
st.shared.v2.f64 [r9], {fd238, fd237};
fma.rn.f64 fd239, fd168, fd151, fd173;
sub.f64 fd240, fd171, fd172;
st.shared.v2.f64 [r9+16], {fd240, fd239};
fma.rn.f64 fd241, fd178, fd155, fd181;
sub.f64 fd242, fd179, fd180;
st.shared.v2.f64 [r9+32], {fd242, fd241};
fma.rn.f64 fd243, fd186, fd159, fd189;
sub.f64 fd244, fd187, fd188;
st.shared.v2.f64 [r9+48], {fd244, fd243};
sub.f64 fd245, fd195, fd196;
fma.rn.f64 fd246, fd194, fd163, fd197;
st.shared.v2.f64 [r9+64], {fd245, fd246};
fma.rn.f64 fd247, fd202, fd149, fd205;
sub.f64 fd248, fd203, fd204;
st.shared.v2.f64 [r9+80], {fd248, fd247};
fma.rn.f64 fd249, fd207, fd153, fd212;
sub.f64 fd250, fd210, fd211;
st.shared.v2.f64 [r9+96], {fd250, fd249};
fma.rn.f64 fd251, fd217, fd157, fd220;
sub.f64 fd252, fd218, fd219;
st.shared.v2.f64 [r9+112], {fd252, fd251};
fma.rn.f64 fd253, fd225, fd161, fd228;
sub.f64 fd254, fd226, fd227;
st.shared.v2.f64 [r9+128], {fd254, fd253};
sub.f64 fd255, fd234, fd235;
fma.rn.f64 fd256, fd233, fd165, fd236;
st.shared.v2.f64 [r9+144], {fd255, fd256};
barrier.sync 0;
mad.lo.s32 r10, r7, -144, r9;
ld.shared.v2.f64 {fd257, fd258}, [r10];
ld.shared.v2.f64 {fd261, fd262}, [r10+160];
ld.shared.v2.f64 {fd265, fd266}, [r10+320];
ld.shared.v2.f64 {fd269, fd270}, [r10+480];
ld.shared.v2.f64 {fd273, fd274}, [r10+640];
ld.shared.v2.f64 {fd277, fd278}, [r10+800];
ld.shared.v2.f64 {fd281, fd282}, [r10+960];
ld.shared.v2.f64 {fd285, fd286}, [r10+1120];
ld.shared.v2.f64 {fd289, fd290}, [r10+1280];
ld.shared.v2.f64 {fd293, fd294}, [r10+1440];
add.f64 fd297, fd265, fd289;
add.f64 fd298, fd257, fd297;
add.f64 fd299, fd273, fd281;
add.f64 fd300, fd299, fd298;
add.f64 fd301, fd266, fd290;
add.f64 fd302, fd258, fd301;
add.f64 fd303, fd274, fd282;
add.f64 fd304, fd303, fd302;
fma.rn.f64 fd305, fd297, 0d3FD3C6EF372FE950, fd257;
mul.f64 fd306, fd299, 0d3FE9E3779B97F4A8;
sub.f64 fd307, fd305, fd306;
sub.f64 fd308, fd266, fd290;
mul.f64 fd309, fd308, 0d3FEE6F0E134454FF;
sub.f64 fd310, fd274, fd282;
mul.f64 fd311, fd310, 0dBFE2CF2304755A5E;
sub.f64 fd312, fd311, fd309;
sub.f64 fd313, fd307, fd312;
add.f64 fd314, fd312, fd307;
mul.f64 fd315, fd297, 0d3FE9E3779B97F4A8;
sub.f64 fd316, fd257, fd315;
fma.rn.f64 fd317, fd299, 0d3FD3C6EF372FE950, fd316;
mul.f64 fd318, fd308, 0d3FE2CF2304755A5E;
mul.f64 fd319, fd310, 0d3FEE6F0E134454FF;
sub.f64 fd320, fd319, fd318;
sub.f64 fd321, fd317, fd320;
add.f64 fd322, fd320, fd317;
fma.rn.f64 fd323, fd301, 0d3FD3C6EF372FE950, fd258;
mul.f64 fd324, fd303, 0d3FE9E3779B97F4A8;
sub.f64 fd325, fd323, fd324;
sub.f64 fd326, fd265, fd289;
mul.f64 fd327, fd326, 0d3FEE6F0E134454FF;
sub.f64 fd328, fd273, fd281;
mul.f64 fd329, fd328, 0dBFE2CF2304755A5E;
sub.f64 fd330, fd329, fd327;
add.f64 fd331, fd330, fd325;
sub.f64 fd332, fd325, fd330;
mul.f64 fd333, fd301, 0d3FE9E3779B97F4A8;
sub.f64 fd334, fd258, fd333;
fma.rn.f64 fd335, fd303, 0d3FD3C6EF372FE950, fd334;
mul.f64 fd336, fd326, 0d3FE2CF2304755A5E;
mul.f64 fd337, fd328, 0d3FEE6F0E134454FF;
sub.f64 fd338, fd337, fd336;
add.f64 fd339, fd338, fd335;
sub.f64 fd340, fd335, fd338;
add.f64 fd341, fd269, fd293;
add.f64 fd342, fd261, fd341;
add.f64 fd343, fd277, fd285;
add.f64 fd344, fd343, fd342;
add.f64 fd345, fd270, fd294;
add.f64 fd346, fd262, fd345;
add.f64 fd347, fd278, fd286;
add.f64 fd348, fd347, fd346;
fma.rn.f64 fd349, fd341, 0d3FD3C6EF372FE950, fd261;
mul.f64 fd350, fd343, 0d3FE9E3779B97F4A8;
sub.f64 fd351, fd349, fd350;
sub.f64 fd352, fd270, fd294;
mul.f64 fd353, fd352, 0d3FEE6F0E134454FF;
sub.f64 fd354, fd278, fd286;
mul.f64 fd355, fd354, 0dBFE2CF2304755A5E;
sub.f64 fd356, fd355, fd353;
sub.f64 fd357, fd351, fd356;
add.f64 fd358, fd356, fd351;
mul.f64 fd359, fd341, 0d3FE9E3779B97F4A8;
sub.f64 fd360, fd261, fd359;
fma.rn.f64 fd361, fd343, 0d3FD3C6EF372FE950, fd360;
mul.f64 fd362, fd352, 0d3FE2CF2304755A5E;
mul.f64 fd363, fd354, 0d3FEE6F0E134454FF;
sub.f64 fd364, fd363, fd362;
sub.f64 fd365, fd361, fd364;
add.f64 fd366, fd364, fd361;
fma.rn.f64 fd367, fd345, 0d3FD3C6EF372FE950, fd262;
mul.f64 fd368, fd347, 0d3FE9E3779B97F4A8;
sub.f64 fd369, fd367, fd368;
sub.f64 fd370, fd269, fd293;
mul.f64 fd371, fd370, 0d3FEE6F0E134454FF;
sub.f64 fd372, fd277, fd285;
mul.f64 fd373, fd372, 0dBFE2CF2304755A5E;
sub.f64 fd374, fd373, fd371;
add.f64 fd375, fd374, fd369;
sub.f64 fd376, fd369, fd374;
mul.f64 fd377, fd345, 0d3FE9E3779B97F4A8;
sub.f64 fd378, fd262, fd377;
fma.rn.f64 fd379, fd347, 0d3FD3C6EF372FE950, fd378;
mul.f64 fd380, fd370, 0d3FE2CF2304755A5E;
mul.f64 fd381, fd372, 0d3FEE6F0E134454FF;
sub.f64 fd382, fd381, fd380;
add.f64 fd383, fd382, fd379;
sub.f64 fd384, fd379, fd382;
mul.f64 fd385, fd357, 0d3FE9E3779B97F4A8;
mul.f64 fd386, fd375, 0dBFE2CF2304755A5E;
sub.f64 fd387, fd385, fd386;
mul.f64 fd388, fd375, 0d3FE9E3779B97F4A8;
fma.rn.f64 fd389, fd357, 0dBFE2CF2304755A5E, fd388;
mul.f64 fd390, fd365, 0d3FD3C6EF372FE950;
mul.f64 fd391, fd383, 0dBFEE6F0E134454FF;
sub.f64 fd392, fd390, fd391;
mul.f64 fd393, fd383, 0d3FD3C6EF372FE950;
fma.rn.f64 fd394, fd365, 0dBFEE6F0E134454FF, fd393;
mul.f64 fd395, fd366, 0dBFD3C6EF372FE950;
mul.f64 fd396, fd384, 0dBFEE6F0E134454FF;
sub.f64 fd397, fd395, fd396;
mul.f64 fd398, fd384, 0dBFD3C6EF372FE950;
fma.rn.f64 fd399, fd366, 0dBFEE6F0E134454FF, fd398;
mul.f64 fd400, fd358, 0dBFE9E3779B97F4A8;
mul.f64 fd401, fd376, 0dBFE2CF2304755A5E;
sub.f64 fd402, fd400, fd401;
mul.f64 fd403, fd376, 0dBFE9E3779B97F4A8;
fma.rn.f64 fd404, fd358, 0dBFE2CF2304755A5E, fd403;
add.f64 %1, fd304, fd348;
add.f64 %0, fd300, fd344;
add.f64 %3, fd331, fd389;
add.f64 %2, fd313, fd387;
add.f64 %5, fd339, fd394;
add.f64 %4, fd321, fd392;
add.f64 %7, fd340, fd399;
add.f64 %6, fd322, fd397;
add.f64 %9, fd332, fd404;
add.f64 %8, fd314, fd402;
sub.f64 %11, fd304, fd348;
sub.f64 %10, fd300, fd344;
sub.f64 %13, fd331, fd389;
sub.f64 %12, fd313, fd387;
sub.f64 %15, fd339, fd394;
sub.f64 %14, fd321, fd392;
sub.f64 %17, fd340, fd399;
sub.f64 %16, fd322, fd397;
sub.f64 %19, fd332, fd404;
sub.f64 %18, fd314, fd402;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y): "r"(smem), "l"(lut_dp_10_100), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y));
};


#endif
