#ifndef CUFFTDX_FFT_121_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_121_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<726, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<465>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %22;
mad.lo.s32 r3, r1, 968, r2;
add.f64 fd45, %26, %50;
add.f64 fd46, %28, %51;
sub.f64 fd47, %26, %50;
sub.f64 fd48, %28, %51;
add.f64 fd49, %29, %48;
add.f64 fd50, %31, %49;
sub.f64 fd51, %29, %48;
sub.f64 fd52, %31, %49;
add.f64 fd53, %32, %45;
add.f64 fd54, %33, %47;
sub.f64 fd55, %32, %45;
sub.f64 fd56, %33, %47;
add.f64 fd57, %34, %42;
add.f64 fd58, %36, %44;
sub.f64 fd59, %34, %42;
sub.f64 fd60, %36, %44;
add.f64 fd61, %37, %40;
add.f64 fd62, %39, %41;
sub.f64 fd63, %37, %40;
sub.f64 fd64, %39, %41;
mov.u32 r4, %tid.x;
add.f64 fd65, %24, fd45;
add.f64 fd66, %25, fd46;
add.f64 fd67, fd65, fd49;
add.f64 fd68, fd66, fd50;
add.f64 fd69, fd67, fd53;
add.f64 fd70, fd68, fd54;
add.f64 fd71, fd69, fd57;
add.f64 fd72, fd70, fd58;
add.f64 fd73, fd71, fd61;
add.f64 fd74, fd72, fd62;
fma.rn.f64 fd75, fd45, 0d3FEAEB8C8764F0BA, %24;
fma.rn.f64 fd76, fd48, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd77, fd46, 0d3FEAEB8C8764F0BA, %25;
fma.rn.f64 fd78, fd47, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd79, fd49, 0d3FDA9628D9C712B6, fd75;
fma.rn.f64 fd80, fd52, 0d3FED1BB48EEE2C13, fd76;
fma.rn.f64 fd81, fd50, 0d3FDA9628D9C712B6, fd77;
fma.rn.f64 fd82, fd51, 0d3FED1BB48EEE2C13, fd78;
fma.rn.f64 fd83, fd53, 0dBFC2375F640F44DB, fd79;
fma.rn.f64 fd84, fd56, 0d3FEFAC9E043842EF, fd80;
fma.rn.f64 fd85, fd54, 0dBFC2375F640F44DB, fd81;
fma.rn.f64 fd86, fd55, 0d3FEFAC9E043842EF, fd82;
fma.rn.f64 fd87, fd57, 0dBFE4F49E7F775887, fd83;
fma.rn.f64 fd88, fd60, 0d3FE82F19BB3A28A1, fd84;
fma.rn.f64 fd89, fd58, 0dBFE4F49E7F775887, fd85;
fma.rn.f64 fd90, fd59, 0d3FE82F19BB3A28A1, fd86;
fma.rn.f64 fd91, fd61, 0dBFEEB42A9BCD5057, fd87;
fma.rn.f64 fd92, fd64, 0d3FD207E7FD768DBF, fd88;
fma.rn.f64 fd93, fd62, 0dBFEEB42A9BCD5057, fd89;
fma.rn.f64 fd94, fd63, 0d3FD207E7FD768DBF, fd90;
sub.f64 fd95, fd91, fd92;
add.f64 fd96, fd94, fd93;
add.f64 fd97, fd92, fd91;
sub.f64 fd98, fd93, fd94;
fma.rn.f64 fd99, fd45, 0d3FDA9628D9C712B6, %24;
fma.rn.f64 fd100, fd48, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd101, fd46, 0d3FDA9628D9C712B6, %25;
fma.rn.f64 fd102, fd47, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd103, fd49, 0dBFE4F49E7F775887, fd99;
fma.rn.f64 fd104, fd52, 0d3FE82F19BB3A28A1, fd100;
fma.rn.f64 fd105, fd50, 0dBFE4F49E7F775887, fd101;
fma.rn.f64 fd106, fd51, 0d3FE82F19BB3A28A1, fd102;
fma.rn.f64 fd107, fd53, 0dBFEEB42A9BCD5057, fd103;
fma.rn.f64 fd108, fd56, 0dBFD207E7FD768DBF, fd104;
fma.rn.f64 fd109, fd54, 0dBFEEB42A9BCD5057, fd105;
fma.rn.f64 fd110, fd55, 0dBFD207E7FD768DBF, fd106;
fma.rn.f64 fd111, fd57, 0dBFC2375F640F44DB, fd107;
fma.rn.f64 fd112, fd60, 0dBFEFAC9E043842EF, fd108;
fma.rn.f64 fd113, fd58, 0dBFC2375F640F44DB, fd109;
fma.rn.f64 fd114, fd59, 0dBFEFAC9E043842EF, fd110;
fma.rn.f64 fd115, fd61, 0d3FEAEB8C8764F0BA, fd111;
fma.rn.f64 fd116, fd64, 0dBFE14CEDF8BB580B, fd112;
fma.rn.f64 fd117, fd62, 0d3FEAEB8C8764F0BA, fd113;
fma.rn.f64 fd118, fd63, 0dBFE14CEDF8BB580B, fd114;
sub.f64 fd119, fd115, fd116;
add.f64 fd120, fd118, fd117;
add.f64 fd121, fd116, fd115;
sub.f64 fd122, fd117, fd118;
fma.rn.f64 fd123, fd45, 0dBFC2375F640F44DB, %24;
fma.rn.f64 fd124, fd48, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd125, fd46, 0dBFC2375F640F44DB, %25;
fma.rn.f64 fd126, fd47, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd127, fd49, 0dBFEEB42A9BCD5057, fd123;
fma.rn.f64 fd128, fd52, 0dBFD207E7FD768DBF, fd124;
fma.rn.f64 fd129, fd50, 0dBFEEB42A9BCD5057, fd125;
fma.rn.f64 fd130, fd51, 0dBFD207E7FD768DBF, fd126;
fma.rn.f64 fd131, fd53, 0d3FDA9628D9C712B6, fd127;
fma.rn.f64 fd132, fd56, 0dBFED1BB48EEE2C13, fd128;
fma.rn.f64 fd133, fd54, 0d3FDA9628D9C712B6, fd129;
fma.rn.f64 fd134, fd55, 0dBFED1BB48EEE2C13, fd130;
fma.rn.f64 fd135, fd57, 0d3FEAEB8C8764F0BA, fd131;
fma.rn.f64 fd136, fd60, 0d3FE14CEDF8BB580B, fd132;
fma.rn.f64 fd137, fd58, 0d3FEAEB8C8764F0BA, fd133;
fma.rn.f64 fd138, fd59, 0d3FE14CEDF8BB580B, fd134;
fma.rn.f64 fd139, fd61, 0dBFE4F49E7F775887, fd135;
fma.rn.f64 fd140, fd64, 0d3FE82F19BB3A28A1, fd136;
fma.rn.f64 fd141, fd62, 0dBFE4F49E7F775887, fd137;
fma.rn.f64 fd142, fd63, 0d3FE82F19BB3A28A1, fd138;
sub.f64 fd143, fd139, fd140;
add.f64 fd144, fd142, fd141;
add.f64 fd145, fd140, fd139;
sub.f64 fd146, fd141, fd142;
fma.rn.f64 fd147, fd45, 0dBFE4F49E7F775887, %24;
fma.rn.f64 fd148, fd48, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd149, fd46, 0dBFE4F49E7F775887, %25;
fma.rn.f64 fd150, fd47, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd151, fd49, 0dBFC2375F640F44DB, fd147;
fma.rn.f64 fd152, fd52, 0dBFEFAC9E043842EF, fd148;
fma.rn.f64 fd153, fd50, 0dBFC2375F640F44DB, fd149;
fma.rn.f64 fd154, fd51, 0dBFEFAC9E043842EF, fd150;
fma.rn.f64 fd155, fd53, 0d3FEAEB8C8764F0BA, fd151;
fma.rn.f64 fd156, fd56, 0d3FE14CEDF8BB580B, fd152;
fma.rn.f64 fd157, fd54, 0d3FEAEB8C8764F0BA, fd153;
fma.rn.f64 fd158, fd55, 0d3FE14CEDF8BB580B, fd154;
fma.rn.f64 fd159, fd57, 0dBFEEB42A9BCD5057, fd155;
fma.rn.f64 fd160, fd60, 0d3FD207E7FD768DBF, fd156;
fma.rn.f64 fd161, fd58, 0dBFEEB42A9BCD5057, fd157;
fma.rn.f64 fd162, fd59, 0d3FD207E7FD768DBF, fd158;
fma.rn.f64 fd163, fd61, 0d3FDA9628D9C712B6, fd159;
fma.rn.f64 fd164, fd64, 0dBFED1BB48EEE2C13, fd160;
fma.rn.f64 fd165, fd62, 0d3FDA9628D9C712B6, fd161;
fma.rn.f64 fd166, fd63, 0dBFED1BB48EEE2C13, fd162;
sub.f64 fd167, fd163, fd164;
add.f64 fd168, fd166, fd165;
add.f64 fd169, fd164, fd163;
sub.f64 fd170, fd165, fd166;
fma.rn.f64 fd171, fd45, 0dBFEEB42A9BCD5057, %24;
fma.rn.f64 fd172, fd48, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd173, fd46, 0dBFEEB42A9BCD5057, %25;
fma.rn.f64 fd174, fd47, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd175, fd49, 0d3FEAEB8C8764F0BA, fd171;
fma.rn.f64 fd176, fd52, 0dBFE14CEDF8BB580B, fd172;
fma.rn.f64 fd177, fd50, 0d3FEAEB8C8764F0BA, fd173;
fma.rn.f64 fd178, fd51, 0dBFE14CEDF8BB580B, fd174;
fma.rn.f64 fd179, fd53, 0dBFE4F49E7F775887, fd175;
fma.rn.f64 fd180, fd56, 0d3FE82F19BB3A28A1, fd176;
fma.rn.f64 fd181, fd54, 0dBFE4F49E7F775887, fd177;
fma.rn.f64 fd182, fd55, 0d3FE82F19BB3A28A1, fd178;
fma.rn.f64 fd183, fd57, 0d3FDA9628D9C712B6, fd179;
fma.rn.f64 fd184, fd60, 0dBFED1BB48EEE2C13, fd180;
fma.rn.f64 fd185, fd58, 0d3FDA9628D9C712B6, fd181;
fma.rn.f64 fd186, fd59, 0dBFED1BB48EEE2C13, fd182;
fma.rn.f64 fd187, fd61, 0dBFC2375F640F44DB, fd183;
fma.rn.f64 fd188, fd64, 0d3FEFAC9E043842EF, fd184;
fma.rn.f64 fd189, fd62, 0dBFC2375F640F44DB, fd185;
fma.rn.f64 fd190, fd63, 0d3FEFAC9E043842EF, fd186;
sub.f64 fd191, fd187, fd188;
add.f64 fd192, fd190, fd189;
add.f64 fd193, fd188, fd187;
sub.f64 fd194, fd189, fd190;
mul.wide.u32 rd2, r4, -1171354717;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 11;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %23;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd195, fd196}, [rd6];
mul.f64 fd199, fd96, fd196;
fma.rn.f64 fd200, fd195, fd95, fd199;
mul.f64 fd201, fd95, fd196;
mul.f64 fd202, fd195, fd96;
sub.f64 fd203, fd202, fd201;
mul.f64 fd204, fd195, fd195;
mul.f64 fd205, fd196, fd196;
sub.f64 fd206, fd204, fd205;
mul.f64 fd207, fd196, fd195;
fma.rn.f64 fd208, fd196, fd195, fd207;
mul.f64 fd209, fd120, fd208;
fma.rn.f64 fd210, fd206, fd119, fd209;
mul.f64 fd211, fd119, fd208;
mul.f64 fd212, fd206, fd120;
sub.f64 fd213, fd212, fd211;
mul.f64 fd214, fd195, fd206;
mul.f64 fd215, fd196, fd208;
sub.f64 fd216, fd214, fd215;
mul.f64 fd217, fd195, fd208;
fma.rn.f64 fd218, fd196, fd206, fd217;
mul.f64 fd219, fd144, fd218;
fma.rn.f64 fd220, fd216, fd143, fd219;
mul.f64 fd221, fd143, fd218;
mul.f64 fd222, fd216, fd144;
sub.f64 fd223, fd222, fd221;
mul.f64 fd224, fd195, fd216;
mul.f64 fd225, fd196, fd218;
sub.f64 fd226, fd224, fd225;
mul.f64 fd227, fd195, fd218;
fma.rn.f64 fd228, fd196, fd216, fd227;
mul.f64 fd229, fd168, fd228;
fma.rn.f64 fd230, fd226, fd167, fd229;
mul.f64 fd231, fd167, fd228;
mul.f64 fd232, fd226, fd168;
sub.f64 fd233, fd232, fd231;
mul.f64 fd234, fd195, fd226;
mul.f64 fd235, fd196, fd228;
sub.f64 fd236, fd234, fd235;
mul.f64 fd237, fd195, fd228;
fma.rn.f64 fd238, fd196, fd226, fd237;
mul.f64 fd239, fd192, fd238;
fma.rn.f64 fd240, fd236, fd191, fd239;
mul.f64 fd241, fd191, fd238;
mul.f64 fd242, fd236, fd192;
sub.f64 fd243, fd242, fd241;
ld.global.v2.f64 {fd244, fd245}, [rd6+176];
mul.f64 fd248, fd194, fd245;
fma.rn.f64 fd249, fd244, fd193, fd248;
mul.f64 fd250, fd193, fd245;
mul.f64 fd251, fd244, fd194;
sub.f64 fd252, fd251, fd250;
mul.f64 fd253, fd195, fd244;
mul.f64 fd254, fd196, fd245;
sub.f64 fd255, fd253, fd254;
mul.f64 fd256, fd195, fd245;
fma.rn.f64 fd257, fd196, fd244, fd256;
mul.f64 fd258, fd170, fd257;
fma.rn.f64 fd259, fd255, fd169, fd258;
mul.f64 fd260, fd169, fd257;
mul.f64 fd261, fd255, fd170;
sub.f64 fd262, fd261, fd260;
mul.f64 fd263, fd195, fd255;
mul.f64 fd264, fd196, fd257;
sub.f64 fd265, fd263, fd264;
mul.f64 fd266, fd195, fd257;
fma.rn.f64 fd267, fd196, fd255, fd266;
mul.f64 fd268, fd146, fd267;
fma.rn.f64 fd269, fd265, fd145, fd268;
mul.f64 fd270, fd145, fd267;
mul.f64 fd271, fd265, fd146;
sub.f64 fd272, fd271, fd270;
mul.f64 fd273, fd195, fd265;
mul.f64 fd274, fd196, fd267;
sub.f64 fd275, fd273, fd274;
mul.f64 fd276, fd195, fd267;
fma.rn.f64 fd277, fd196, fd265, fd276;
mul.f64 fd278, fd122, fd277;
fma.rn.f64 fd279, fd275, fd121, fd278;
mul.f64 fd280, fd121, fd277;
mul.f64 fd281, fd275, fd122;
sub.f64 fd282, fd281, fd280;
mul.f64 fd283, fd195, fd275;
mul.f64 fd284, fd196, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd195, fd277;
fma.rn.f64 fd287, fd196, fd275, fd286;
mul.f64 fd288, fd98, fd287;
fma.rn.f64 fd289, fd285, fd97, fd288;
mul.f64 fd290, fd97, fd287;
mul.f64 fd291, fd285, fd98;
sub.f64 fd292, fd291, fd290;
mad.lo.s32 r8, r5, 968, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 88, r8;
st.shared.f64 [r9], fd73;
st.shared.f64 [r9+8], fd200;
st.shared.f64 [r9+16], fd210;
st.shared.f64 [r9+24], fd220;
st.shared.f64 [r9+32], fd230;
st.shared.f64 [r9+40], fd240;
st.shared.f64 [r9+48], fd249;
st.shared.f64 [r9+56], fd259;
st.shared.f64 [r9+64], fd269;
st.shared.f64 [r9+72], fd279;
st.shared.f64 [r9+80], fd289;
barrier.sync 0;
mad.lo.s32 r10, r7, -80, r9;
ld.shared.f64 fd293, [r10];
ld.shared.f64 fd294, [r10+88];
ld.shared.f64 fd295, [r10+176];
ld.shared.f64 fd296, [r10+264];
ld.shared.f64 fd297, [r10+352];
ld.shared.f64 fd298, [r10+440];
ld.shared.f64 fd299, [r10+528];
ld.shared.f64 fd300, [r10+616];
ld.shared.f64 fd301, [r10+704];
ld.shared.f64 fd302, [r10+792];
ld.shared.f64 fd303, [r10+880];
barrier.sync 0;
st.shared.f64 [r9], fd74;
st.shared.f64 [r9+8], fd203;
st.shared.f64 [r9+16], fd213;
st.shared.f64 [r9+24], fd223;
st.shared.f64 [r9+32], fd233;
st.shared.f64 [r9+40], fd243;
st.shared.f64 [r9+48], fd252;
st.shared.f64 [r9+56], fd262;
st.shared.f64 [r9+64], fd272;
st.shared.f64 [r9+72], fd282;
st.shared.f64 [r9+80], fd292;
barrier.sync 0;
ld.shared.f64 fd304, [r10];
ld.shared.f64 fd305, [r10+88];
ld.shared.f64 fd306, [r10+176];
ld.shared.f64 fd307, [r10+264];
ld.shared.f64 fd308, [r10+352];
ld.shared.f64 fd309, [r10+440];
ld.shared.f64 fd310, [r10+528];
ld.shared.f64 fd311, [r10+616];
ld.shared.f64 fd312, [r10+704];
ld.shared.f64 fd313, [r10+792];
ld.shared.f64 fd314, [r10+880];
add.f64 fd315, fd294, fd303;
add.f64 fd316, fd305, fd314;
sub.f64 fd317, fd294, fd303;
sub.f64 fd318, fd305, fd314;
add.f64 fd319, fd295, fd302;
add.f64 fd320, fd306, fd313;
sub.f64 fd321, fd295, fd302;
sub.f64 fd322, fd306, fd313;
add.f64 fd323, fd296, fd301;
add.f64 fd324, fd307, fd312;
sub.f64 fd325, fd296, fd301;
sub.f64 fd326, fd307, fd312;
add.f64 fd327, fd297, fd300;
add.f64 fd328, fd308, fd311;
sub.f64 fd329, fd297, fd300;
sub.f64 fd330, fd308, fd311;
add.f64 fd331, fd298, fd299;
add.f64 fd332, fd309, fd310;
sub.f64 fd333, fd298, fd299;
sub.f64 fd334, fd309, fd310;
add.f64 fd335, fd293, fd315;
add.f64 fd336, fd304, fd316;
add.f64 fd337, fd335, fd319;
add.f64 fd338, fd336, fd320;
add.f64 fd339, fd337, fd323;
add.f64 fd340, fd338, fd324;
add.f64 fd341, fd339, fd327;
add.f64 fd342, fd340, fd328;
fma.rn.f64 fd343, fd315, 0d3FEAEB8C8764F0BA, fd293;
fma.rn.f64 fd344, fd318, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd345, fd316, 0d3FEAEB8C8764F0BA, fd304;
fma.rn.f64 fd346, fd317, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd347, fd319, 0d3FDA9628D9C712B6, fd343;
fma.rn.f64 fd348, fd322, 0d3FED1BB48EEE2C13, fd344;
fma.rn.f64 fd349, fd320, 0d3FDA9628D9C712B6, fd345;
fma.rn.f64 fd350, fd321, 0d3FED1BB48EEE2C13, fd346;
fma.rn.f64 fd351, fd323, 0dBFC2375F640F44DB, fd347;
fma.rn.f64 fd352, fd326, 0d3FEFAC9E043842EF, fd348;
fma.rn.f64 fd353, fd324, 0dBFC2375F640F44DB, fd349;
fma.rn.f64 fd354, fd325, 0d3FEFAC9E043842EF, fd350;
fma.rn.f64 fd355, fd327, 0dBFE4F49E7F775887, fd351;
fma.rn.f64 fd356, fd330, 0d3FE82F19BB3A28A1, fd352;
fma.rn.f64 fd357, fd328, 0dBFE4F49E7F775887, fd353;
fma.rn.f64 fd358, fd329, 0d3FE82F19BB3A28A1, fd354;
fma.rn.f64 fd359, fd331, 0dBFEEB42A9BCD5057, fd355;
fma.rn.f64 fd360, fd334, 0d3FD207E7FD768DBF, fd356;
fma.rn.f64 fd361, fd332, 0dBFEEB42A9BCD5057, fd357;
fma.rn.f64 fd362, fd333, 0d3FD207E7FD768DBF, fd358;
fma.rn.f64 fd363, fd315, 0d3FDA9628D9C712B6, fd293;
fma.rn.f64 fd364, fd318, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd365, fd316, 0d3FDA9628D9C712B6, fd304;
fma.rn.f64 fd366, fd317, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd367, fd319, 0dBFE4F49E7F775887, fd363;
fma.rn.f64 fd368, fd322, 0d3FE82F19BB3A28A1, fd364;
fma.rn.f64 fd369, fd320, 0dBFE4F49E7F775887, fd365;
fma.rn.f64 fd370, fd321, 0d3FE82F19BB3A28A1, fd366;
fma.rn.f64 fd371, fd323, 0dBFEEB42A9BCD5057, fd367;
fma.rn.f64 fd372, fd326, 0dBFD207E7FD768DBF, fd368;
fma.rn.f64 fd373, fd324, 0dBFEEB42A9BCD5057, fd369;
fma.rn.f64 fd374, fd325, 0dBFD207E7FD768DBF, fd370;
fma.rn.f64 fd375, fd327, 0dBFC2375F640F44DB, fd371;
fma.rn.f64 fd376, fd330, 0dBFEFAC9E043842EF, fd372;
fma.rn.f64 fd377, fd328, 0dBFC2375F640F44DB, fd373;
fma.rn.f64 fd378, fd329, 0dBFEFAC9E043842EF, fd374;
fma.rn.f64 fd379, fd331, 0d3FEAEB8C8764F0BA, fd375;
fma.rn.f64 fd380, fd334, 0dBFE14CEDF8BB580B, fd376;
fma.rn.f64 fd381, fd332, 0d3FEAEB8C8764F0BA, fd377;
fma.rn.f64 fd382, fd333, 0dBFE14CEDF8BB580B, fd378;
fma.rn.f64 fd383, fd315, 0dBFC2375F640F44DB, fd293;
fma.rn.f64 fd384, fd318, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd385, fd316, 0dBFC2375F640F44DB, fd304;
fma.rn.f64 fd386, fd317, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd387, fd319, 0dBFEEB42A9BCD5057, fd383;
fma.rn.f64 fd388, fd322, 0dBFD207E7FD768DBF, fd384;
fma.rn.f64 fd389, fd320, 0dBFEEB42A9BCD5057, fd385;
fma.rn.f64 fd390, fd321, 0dBFD207E7FD768DBF, fd386;
fma.rn.f64 fd391, fd323, 0d3FDA9628D9C712B6, fd387;
fma.rn.f64 fd392, fd326, 0dBFED1BB48EEE2C13, fd388;
fma.rn.f64 fd393, fd324, 0d3FDA9628D9C712B6, fd389;
fma.rn.f64 fd394, fd325, 0dBFED1BB48EEE2C13, fd390;
fma.rn.f64 fd395, fd327, 0d3FEAEB8C8764F0BA, fd391;
fma.rn.f64 fd396, fd330, 0d3FE14CEDF8BB580B, fd392;
fma.rn.f64 fd397, fd328, 0d3FEAEB8C8764F0BA, fd393;
fma.rn.f64 fd398, fd329, 0d3FE14CEDF8BB580B, fd394;
fma.rn.f64 fd399, fd331, 0dBFE4F49E7F775887, fd395;
fma.rn.f64 fd400, fd334, 0d3FE82F19BB3A28A1, fd396;
fma.rn.f64 fd401, fd332, 0dBFE4F49E7F775887, fd397;
fma.rn.f64 fd402, fd333, 0d3FE82F19BB3A28A1, fd398;
fma.rn.f64 fd403, fd315, 0dBFE4F49E7F775887, fd293;
fma.rn.f64 fd404, fd318, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd405, fd316, 0dBFE4F49E7F775887, fd304;
fma.rn.f64 fd406, fd317, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd407, fd319, 0dBFC2375F640F44DB, fd403;
fma.rn.f64 fd408, fd322, 0dBFEFAC9E043842EF, fd404;
fma.rn.f64 fd409, fd320, 0dBFC2375F640F44DB, fd405;
fma.rn.f64 fd410, fd321, 0dBFEFAC9E043842EF, fd406;
fma.rn.f64 fd411, fd323, 0d3FEAEB8C8764F0BA, fd407;
fma.rn.f64 fd412, fd326, 0d3FE14CEDF8BB580B, fd408;
fma.rn.f64 fd413, fd324, 0d3FEAEB8C8764F0BA, fd409;
fma.rn.f64 fd414, fd325, 0d3FE14CEDF8BB580B, fd410;
fma.rn.f64 fd415, fd327, 0dBFEEB42A9BCD5057, fd411;
fma.rn.f64 fd416, fd330, 0d3FD207E7FD768DBF, fd412;
fma.rn.f64 fd417, fd328, 0dBFEEB42A9BCD5057, fd413;
fma.rn.f64 fd418, fd329, 0d3FD207E7FD768DBF, fd414;
fma.rn.f64 fd419, fd331, 0d3FDA9628D9C712B6, fd415;
fma.rn.f64 fd420, fd334, 0dBFED1BB48EEE2C13, fd416;
fma.rn.f64 fd421, fd332, 0d3FDA9628D9C712B6, fd417;
fma.rn.f64 fd422, fd333, 0dBFED1BB48EEE2C13, fd418;
fma.rn.f64 fd423, fd315, 0dBFEEB42A9BCD5057, fd293;
fma.rn.f64 fd424, fd318, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd425, fd316, 0dBFEEB42A9BCD5057, fd304;
fma.rn.f64 fd426, fd317, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd427, fd319, 0d3FEAEB8C8764F0BA, fd423;
fma.rn.f64 fd428, fd322, 0dBFE14CEDF8BB580B, fd424;
fma.rn.f64 fd429, fd320, 0d3FEAEB8C8764F0BA, fd425;
fma.rn.f64 fd430, fd321, 0dBFE14CEDF8BB580B, fd426;
fma.rn.f64 fd431, fd323, 0dBFE4F49E7F775887, fd427;
fma.rn.f64 fd432, fd326, 0d3FE82F19BB3A28A1, fd428;
fma.rn.f64 fd433, fd324, 0dBFE4F49E7F775887, fd429;
fma.rn.f64 fd434, fd325, 0d3FE82F19BB3A28A1, fd430;
fma.rn.f64 fd435, fd327, 0d3FDA9628D9C712B6, fd431;
fma.rn.f64 fd436, fd330, 0dBFED1BB48EEE2C13, fd432;
fma.rn.f64 fd437, fd328, 0d3FDA9628D9C712B6, fd433;
fma.rn.f64 fd438, fd329, 0dBFED1BB48EEE2C13, fd434;
fma.rn.f64 fd439, fd331, 0dBFC2375F640F44DB, fd435;
fma.rn.f64 fd440, fd334, 0d3FEFAC9E043842EF, fd436;
fma.rn.f64 fd441, fd332, 0dBFC2375F640F44DB, fd437;
fma.rn.f64 fd442, fd333, 0d3FEFAC9E043842EF, fd438;
add.f64 %0, fd341, fd331;
add.f64 %1, fd342, fd332;
add.f64 %3, fd362, fd361;
sub.f64 %2, fd359, fd360;
add.f64 %5, fd382, fd381;
sub.f64 %4, fd379, fd380;
add.f64 %7, fd402, fd401;
sub.f64 %6, fd399, fd400;
add.f64 %9, fd422, fd421;
sub.f64 %8, fd419, fd420;
add.f64 %11, fd442, fd441;
sub.f64 %10, fd439, fd440;
sub.f64 %13, fd441, fd442;
add.f64 %12, fd440, fd439;
sub.f64 %15, fd421, fd422;
add.f64 %14, fd420, fd419;
sub.f64 %17, fd401, fd402;
add.f64 %16, fd400, fd399;
sub.f64 %19, fd381, fd382;
add.f64 %18, fd380, fd379;
sub.f64 %21, fd361, fd362;
add.f64 %20, fd360, fd359;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y): "r"(smem), "l"(lut_dp_11_121), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<725, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<487>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %22;
mad.lo.s32 r3, r1, 1936, r2;
add.f64 fd45, %26, %50;
add.f64 fd46, %28, %51;
sub.f64 fd47, %26, %50;
sub.f64 fd48, %28, %51;
add.f64 fd49, %29, %48;
add.f64 fd50, %31, %49;
sub.f64 fd51, %29, %48;
sub.f64 fd52, %31, %49;
add.f64 fd53, %32, %45;
add.f64 fd54, %33, %47;
sub.f64 fd55, %32, %45;
sub.f64 fd56, %33, %47;
add.f64 fd57, %34, %42;
add.f64 fd58, %36, %44;
sub.f64 fd59, %34, %42;
sub.f64 fd60, %36, %44;
add.f64 fd61, %37, %40;
add.f64 fd62, %39, %41;
sub.f64 fd63, %37, %40;
sub.f64 fd64, %39, %41;
mov.u32 r4, %tid.x;
add.f64 fd65, %24, fd45;
add.f64 fd66, %25, fd46;
add.f64 fd67, fd65, fd49;
add.f64 fd68, fd66, fd50;
add.f64 fd69, fd67, fd53;
add.f64 fd70, fd68, fd54;
add.f64 fd71, fd69, fd57;
add.f64 fd72, fd70, fd58;
fma.rn.f64 fd73, fd45, 0d3FEAEB8C8764F0BA, %24;
fma.rn.f64 fd74, fd48, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd75, fd46, 0d3FEAEB8C8764F0BA, %25;
fma.rn.f64 fd76, fd47, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd77, fd49, 0d3FDA9628D9C712B6, fd73;
fma.rn.f64 fd78, fd52, 0d3FED1BB48EEE2C13, fd74;
fma.rn.f64 fd79, fd50, 0d3FDA9628D9C712B6, fd75;
fma.rn.f64 fd80, fd51, 0d3FED1BB48EEE2C13, fd76;
fma.rn.f64 fd81, fd53, 0dBFC2375F640F44DB, fd77;
fma.rn.f64 fd82, fd56, 0d3FEFAC9E043842EF, fd78;
fma.rn.f64 fd83, fd54, 0dBFC2375F640F44DB, fd79;
fma.rn.f64 fd84, fd55, 0d3FEFAC9E043842EF, fd80;
fma.rn.f64 fd85, fd57, 0dBFE4F49E7F775887, fd81;
fma.rn.f64 fd86, fd60, 0d3FE82F19BB3A28A1, fd82;
fma.rn.f64 fd87, fd58, 0dBFE4F49E7F775887, fd83;
fma.rn.f64 fd88, fd59, 0d3FE82F19BB3A28A1, fd84;
fma.rn.f64 fd89, fd61, 0dBFEEB42A9BCD5057, fd85;
fma.rn.f64 fd90, fd64, 0d3FD207E7FD768DBF, fd86;
fma.rn.f64 fd91, fd62, 0dBFEEB42A9BCD5057, fd87;
fma.rn.f64 fd92, fd63, 0d3FD207E7FD768DBF, fd88;
sub.f64 fd93, fd89, fd90;
add.f64 fd94, fd92, fd91;
add.f64 fd95, fd90, fd89;
sub.f64 fd96, fd91, fd92;
fma.rn.f64 fd97, fd45, 0d3FDA9628D9C712B6, %24;
fma.rn.f64 fd98, fd48, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd99, fd46, 0d3FDA9628D9C712B6, %25;
fma.rn.f64 fd100, fd47, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd101, fd49, 0dBFE4F49E7F775887, fd97;
fma.rn.f64 fd102, fd52, 0d3FE82F19BB3A28A1, fd98;
fma.rn.f64 fd103, fd50, 0dBFE4F49E7F775887, fd99;
fma.rn.f64 fd104, fd51, 0d3FE82F19BB3A28A1, fd100;
fma.rn.f64 fd105, fd53, 0dBFEEB42A9BCD5057, fd101;
fma.rn.f64 fd106, fd56, 0dBFD207E7FD768DBF, fd102;
fma.rn.f64 fd107, fd54, 0dBFEEB42A9BCD5057, fd103;
fma.rn.f64 fd108, fd55, 0dBFD207E7FD768DBF, fd104;
fma.rn.f64 fd109, fd57, 0dBFC2375F640F44DB, fd105;
fma.rn.f64 fd110, fd60, 0dBFEFAC9E043842EF, fd106;
fma.rn.f64 fd111, fd58, 0dBFC2375F640F44DB, fd107;
fma.rn.f64 fd112, fd59, 0dBFEFAC9E043842EF, fd108;
fma.rn.f64 fd113, fd61, 0d3FEAEB8C8764F0BA, fd109;
fma.rn.f64 fd114, fd64, 0dBFE14CEDF8BB580B, fd110;
fma.rn.f64 fd115, fd62, 0d3FEAEB8C8764F0BA, fd111;
fma.rn.f64 fd116, fd63, 0dBFE14CEDF8BB580B, fd112;
sub.f64 fd117, fd113, fd114;
add.f64 fd118, fd116, fd115;
add.f64 fd119, fd114, fd113;
sub.f64 fd120, fd115, fd116;
fma.rn.f64 fd121, fd45, 0dBFC2375F640F44DB, %24;
fma.rn.f64 fd122, fd48, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd123, fd46, 0dBFC2375F640F44DB, %25;
fma.rn.f64 fd124, fd47, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd125, fd49, 0dBFEEB42A9BCD5057, fd121;
fma.rn.f64 fd126, fd52, 0dBFD207E7FD768DBF, fd122;
fma.rn.f64 fd127, fd50, 0dBFEEB42A9BCD5057, fd123;
fma.rn.f64 fd128, fd51, 0dBFD207E7FD768DBF, fd124;
fma.rn.f64 fd129, fd53, 0d3FDA9628D9C712B6, fd125;
fma.rn.f64 fd130, fd56, 0dBFED1BB48EEE2C13, fd126;
fma.rn.f64 fd131, fd54, 0d3FDA9628D9C712B6, fd127;
fma.rn.f64 fd132, fd55, 0dBFED1BB48EEE2C13, fd128;
fma.rn.f64 fd133, fd57, 0d3FEAEB8C8764F0BA, fd129;
fma.rn.f64 fd134, fd60, 0d3FE14CEDF8BB580B, fd130;
fma.rn.f64 fd135, fd58, 0d3FEAEB8C8764F0BA, fd131;
fma.rn.f64 fd136, fd59, 0d3FE14CEDF8BB580B, fd132;
fma.rn.f64 fd137, fd61, 0dBFE4F49E7F775887, fd133;
fma.rn.f64 fd138, fd64, 0d3FE82F19BB3A28A1, fd134;
fma.rn.f64 fd139, fd62, 0dBFE4F49E7F775887, fd135;
fma.rn.f64 fd140, fd63, 0d3FE82F19BB3A28A1, fd136;
sub.f64 fd141, fd137, fd138;
add.f64 fd142, fd140, fd139;
add.f64 fd143, fd138, fd137;
sub.f64 fd144, fd139, fd140;
fma.rn.f64 fd145, fd45, 0dBFE4F49E7F775887, %24;
fma.rn.f64 fd146, fd48, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd147, fd46, 0dBFE4F49E7F775887, %25;
fma.rn.f64 fd148, fd47, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd149, fd49, 0dBFC2375F640F44DB, fd145;
fma.rn.f64 fd150, fd52, 0dBFEFAC9E043842EF, fd146;
fma.rn.f64 fd151, fd50, 0dBFC2375F640F44DB, fd147;
fma.rn.f64 fd152, fd51, 0dBFEFAC9E043842EF, fd148;
fma.rn.f64 fd153, fd53, 0d3FEAEB8C8764F0BA, fd149;
fma.rn.f64 fd154, fd56, 0d3FE14CEDF8BB580B, fd150;
fma.rn.f64 fd155, fd54, 0d3FEAEB8C8764F0BA, fd151;
fma.rn.f64 fd156, fd55, 0d3FE14CEDF8BB580B, fd152;
fma.rn.f64 fd157, fd57, 0dBFEEB42A9BCD5057, fd153;
fma.rn.f64 fd158, fd60, 0d3FD207E7FD768DBF, fd154;
fma.rn.f64 fd159, fd58, 0dBFEEB42A9BCD5057, fd155;
fma.rn.f64 fd160, fd59, 0d3FD207E7FD768DBF, fd156;
fma.rn.f64 fd161, fd61, 0d3FDA9628D9C712B6, fd157;
fma.rn.f64 fd162, fd64, 0dBFED1BB48EEE2C13, fd158;
fma.rn.f64 fd163, fd62, 0d3FDA9628D9C712B6, fd159;
fma.rn.f64 fd164, fd63, 0dBFED1BB48EEE2C13, fd160;
sub.f64 fd165, fd161, fd162;
add.f64 fd166, fd164, fd163;
add.f64 fd167, fd162, fd161;
sub.f64 fd168, fd163, fd164;
fma.rn.f64 fd169, fd45, 0dBFEEB42A9BCD5057, %24;
fma.rn.f64 fd170, fd48, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd171, fd46, 0dBFEEB42A9BCD5057, %25;
fma.rn.f64 fd172, fd47, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd173, fd49, 0d3FEAEB8C8764F0BA, fd169;
fma.rn.f64 fd174, fd52, 0dBFE14CEDF8BB580B, fd170;
fma.rn.f64 fd175, fd50, 0d3FEAEB8C8764F0BA, fd171;
fma.rn.f64 fd176, fd51, 0dBFE14CEDF8BB580B, fd172;
fma.rn.f64 fd177, fd53, 0dBFE4F49E7F775887, fd173;
fma.rn.f64 fd178, fd56, 0d3FE82F19BB3A28A1, fd174;
fma.rn.f64 fd179, fd54, 0dBFE4F49E7F775887, fd175;
fma.rn.f64 fd180, fd55, 0d3FE82F19BB3A28A1, fd176;
fma.rn.f64 fd181, fd57, 0d3FDA9628D9C712B6, fd177;
fma.rn.f64 fd182, fd60, 0dBFED1BB48EEE2C13, fd178;
fma.rn.f64 fd183, fd58, 0d3FDA9628D9C712B6, fd179;
fma.rn.f64 fd184, fd59, 0dBFED1BB48EEE2C13, fd180;
fma.rn.f64 fd185, fd61, 0dBFC2375F640F44DB, fd181;
fma.rn.f64 fd186, fd64, 0d3FEFAC9E043842EF, fd182;
fma.rn.f64 fd187, fd62, 0dBFC2375F640F44DB, fd183;
fma.rn.f64 fd188, fd63, 0d3FEFAC9E043842EF, fd184;
sub.f64 fd189, fd185, fd186;
add.f64 fd190, fd188, fd187;
add.f64 fd191, fd186, fd185;
sub.f64 fd192, fd187, fd188;
mul.wide.u32 rd2, r4, -1171354717;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 11;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 1936, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %23;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd193, fd194}, [rd6];
mul.f64 fd197, fd94, fd194;
mul.f64 fd198, fd93, fd194;
mul.f64 fd199, fd193, fd94;
mul.f64 fd200, fd193, fd193;
mul.f64 fd201, fd194, fd194;
sub.f64 fd202, fd200, fd201;
mul.f64 fd203, fd194, fd193;
fma.rn.f64 fd204, fd194, fd193, fd203;
mul.f64 fd205, fd118, fd204;
mul.f64 fd206, fd117, fd204;
mul.f64 fd207, fd202, fd118;
mul.f64 fd208, fd193, fd202;
mul.f64 fd209, fd194, fd204;
sub.f64 fd210, fd208, fd209;
mul.f64 fd211, fd193, fd204;
fma.rn.f64 fd212, fd194, fd202, fd211;
mul.f64 fd213, fd142, fd212;
mul.f64 fd214, fd141, fd212;
mul.f64 fd215, fd210, fd142;
mul.f64 fd216, fd193, fd210;
mul.f64 fd217, fd194, fd212;
sub.f64 fd218, fd216, fd217;
mul.f64 fd219, fd193, fd212;
fma.rn.f64 fd220, fd194, fd210, fd219;
mul.f64 fd221, fd166, fd220;
mul.f64 fd222, fd165, fd220;
mul.f64 fd223, fd218, fd166;
mul.f64 fd224, fd193, fd218;
mul.f64 fd225, fd194, fd220;
sub.f64 fd226, fd224, fd225;
mul.f64 fd227, fd193, fd220;
fma.rn.f64 fd228, fd194, fd218, fd227;
mul.f64 fd229, fd190, fd228;
mul.f64 fd230, fd189, fd228;
mul.f64 fd231, fd226, fd190;
ld.global.v2.f64 {fd232, fd233}, [rd6+176];
mul.f64 fd236, fd192, fd233;
mul.f64 fd237, fd191, fd233;
mul.f64 fd238, fd232, fd192;
mul.f64 fd239, fd193, fd232;
mul.f64 fd240, fd194, fd233;
sub.f64 fd241, fd239, fd240;
mul.f64 fd242, fd193, fd233;
fma.rn.f64 fd243, fd194, fd232, fd242;
mul.f64 fd244, fd168, fd243;
mul.f64 fd245, fd167, fd243;
mul.f64 fd246, fd241, fd168;
mul.f64 fd247, fd193, fd241;
mul.f64 fd248, fd194, fd243;
sub.f64 fd249, fd247, fd248;
mul.f64 fd250, fd193, fd243;
fma.rn.f64 fd251, fd194, fd241, fd250;
mul.f64 fd252, fd144, fd251;
mul.f64 fd253, fd143, fd251;
mul.f64 fd254, fd249, fd144;
mul.f64 fd255, fd193, fd249;
mul.f64 fd256, fd194, fd251;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd193, fd251;
fma.rn.f64 fd259, fd194, fd249, fd258;
mul.f64 fd260, fd120, fd259;
mul.f64 fd261, fd119, fd259;
mul.f64 fd262, fd257, fd120;
mul.f64 fd263, fd193, fd257;
mul.f64 fd264, fd194, fd259;
sub.f64 fd265, fd263, fd264;
mul.f64 fd266, fd193, fd259;
fma.rn.f64 fd267, fd194, fd257, fd266;
mul.f64 fd268, fd96, fd267;
mul.f64 fd269, fd95, fd267;
mul.f64 fd270, fd265, fd96;
barrier.sync 0;
mad.lo.s32 r9, r7, 176, r8;
add.f64 fd271, fd72, fd62;
add.f64 fd272, fd71, fd61;
st.shared.v2.f64 [r9], {fd272, fd271};
fma.rn.f64 fd273, fd193, fd93, fd197;
sub.f64 fd274, fd199, fd198;
st.shared.v2.f64 [r9+16], {fd273, fd274};
fma.rn.f64 fd275, fd202, fd117, fd205;
sub.f64 fd276, fd207, fd206;
st.shared.v2.f64 [r9+32], {fd275, fd276};
sub.f64 fd277, fd215, fd214;
fma.rn.f64 fd278, fd210, fd141, fd213;
st.shared.v2.f64 [r9+48], {fd278, fd277};
fma.rn.f64 fd279, fd218, fd165, fd221;
sub.f64 fd280, fd223, fd222;
st.shared.v2.f64 [r9+64], {fd279, fd280};
fma.rn.f64 fd281, fd226, fd189, fd229;
sub.f64 fd282, fd231, fd230;
st.shared.v2.f64 [r9+80], {fd281, fd282};
fma.rn.f64 fd283, fd232, fd191, fd236;
sub.f64 fd284, fd238, fd237;
st.shared.v2.f64 [r9+96], {fd283, fd284};
fma.rn.f64 fd285, fd241, fd167, fd244;
sub.f64 fd286, fd246, fd245;
st.shared.v2.f64 [r9+112], {fd285, fd286};
sub.f64 fd287, fd254, fd253;
fma.rn.f64 fd288, fd249, fd143, fd252;
st.shared.v2.f64 [r9+128], {fd288, fd287};
fma.rn.f64 fd289, fd257, fd119, fd260;
sub.f64 fd290, fd262, fd261;
st.shared.v2.f64 [r9+144], {fd289, fd290};
fma.rn.f64 fd291, fd265, fd95, fd268;
sub.f64 fd292, fd270, fd269;
st.shared.v2.f64 [r9+160], {fd291, fd292};
barrier.sync 0;
mad.lo.s32 r10, r7, -160, r9;
ld.shared.v2.f64 {fd293, fd294}, [r10];
ld.shared.v2.f64 {fd297, fd298}, [r10+176];
ld.shared.v2.f64 {fd301, fd302}, [r10+352];
ld.shared.v2.f64 {fd305, fd306}, [r10+528];
ld.shared.v2.f64 {fd309, fd310}, [r10+704];
ld.shared.v2.f64 {fd313, fd314}, [r10+880];
ld.shared.v2.f64 {fd317, fd318}, [r10+1056];
ld.shared.v2.f64 {fd321, fd322}, [r10+1232];
ld.shared.v2.f64 {fd325, fd326}, [r10+1408];
ld.shared.v2.f64 {fd329, fd330}, [r10+1584];
ld.shared.v2.f64 {fd333, fd334}, [r10+1760];
add.f64 fd337, fd297, fd333;
add.f64 fd338, fd298, fd334;
sub.f64 fd339, fd297, fd333;
sub.f64 fd340, fd298, fd334;
add.f64 fd341, fd301, fd329;
add.f64 fd342, fd302, fd330;
sub.f64 fd343, fd301, fd329;
sub.f64 fd344, fd302, fd330;
add.f64 fd345, fd305, fd325;
add.f64 fd346, fd306, fd326;
sub.f64 fd347, fd305, fd325;
sub.f64 fd348, fd306, fd326;
add.f64 fd349, fd309, fd321;
add.f64 fd350, fd310, fd322;
sub.f64 fd351, fd309, fd321;
sub.f64 fd352, fd310, fd322;
add.f64 fd353, fd313, fd317;
add.f64 fd354, fd314, fd318;
sub.f64 fd355, fd313, fd317;
sub.f64 fd356, fd314, fd318;
add.f64 fd357, fd293, fd337;
add.f64 fd358, fd294, fd338;
add.f64 fd359, fd357, fd341;
add.f64 fd360, fd358, fd342;
add.f64 fd361, fd359, fd345;
add.f64 fd362, fd360, fd346;
add.f64 fd363, fd361, fd349;
add.f64 fd364, fd362, fd350;
fma.rn.f64 fd365, fd337, 0d3FEAEB8C8764F0BA, fd293;
fma.rn.f64 fd366, fd340, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd367, fd338, 0d3FEAEB8C8764F0BA, fd294;
fma.rn.f64 fd368, fd339, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd369, fd341, 0d3FDA9628D9C712B6, fd365;
fma.rn.f64 fd370, fd344, 0d3FED1BB48EEE2C13, fd366;
fma.rn.f64 fd371, fd342, 0d3FDA9628D9C712B6, fd367;
fma.rn.f64 fd372, fd343, 0d3FED1BB48EEE2C13, fd368;
fma.rn.f64 fd373, fd345, 0dBFC2375F640F44DB, fd369;
fma.rn.f64 fd374, fd348, 0d3FEFAC9E043842EF, fd370;
fma.rn.f64 fd375, fd346, 0dBFC2375F640F44DB, fd371;
fma.rn.f64 fd376, fd347, 0d3FEFAC9E043842EF, fd372;
fma.rn.f64 fd377, fd349, 0dBFE4F49E7F775887, fd373;
fma.rn.f64 fd378, fd352, 0d3FE82F19BB3A28A1, fd374;
fma.rn.f64 fd379, fd350, 0dBFE4F49E7F775887, fd375;
fma.rn.f64 fd380, fd351, 0d3FE82F19BB3A28A1, fd376;
fma.rn.f64 fd381, fd353, 0dBFEEB42A9BCD5057, fd377;
fma.rn.f64 fd382, fd356, 0d3FD207E7FD768DBF, fd378;
fma.rn.f64 fd383, fd354, 0dBFEEB42A9BCD5057, fd379;
fma.rn.f64 fd384, fd355, 0d3FD207E7FD768DBF, fd380;
fma.rn.f64 fd385, fd337, 0d3FDA9628D9C712B6, fd293;
fma.rn.f64 fd386, fd340, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd387, fd338, 0d3FDA9628D9C712B6, fd294;
fma.rn.f64 fd388, fd339, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd389, fd341, 0dBFE4F49E7F775887, fd385;
fma.rn.f64 fd390, fd344, 0d3FE82F19BB3A28A1, fd386;
fma.rn.f64 fd391, fd342, 0dBFE4F49E7F775887, fd387;
fma.rn.f64 fd392, fd343, 0d3FE82F19BB3A28A1, fd388;
fma.rn.f64 fd393, fd345, 0dBFEEB42A9BCD5057, fd389;
fma.rn.f64 fd394, fd348, 0dBFD207E7FD768DBF, fd390;
fma.rn.f64 fd395, fd346, 0dBFEEB42A9BCD5057, fd391;
fma.rn.f64 fd396, fd347, 0dBFD207E7FD768DBF, fd392;
fma.rn.f64 fd397, fd349, 0dBFC2375F640F44DB, fd393;
fma.rn.f64 fd398, fd352, 0dBFEFAC9E043842EF, fd394;
fma.rn.f64 fd399, fd350, 0dBFC2375F640F44DB, fd395;
fma.rn.f64 fd400, fd351, 0dBFEFAC9E043842EF, fd396;
fma.rn.f64 fd401, fd353, 0d3FEAEB8C8764F0BA, fd397;
fma.rn.f64 fd402, fd356, 0dBFE14CEDF8BB580B, fd398;
fma.rn.f64 fd403, fd354, 0d3FEAEB8C8764F0BA, fd399;
fma.rn.f64 fd404, fd355, 0dBFE14CEDF8BB580B, fd400;
fma.rn.f64 fd405, fd337, 0dBFC2375F640F44DB, fd293;
fma.rn.f64 fd406, fd340, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd407, fd338, 0dBFC2375F640F44DB, fd294;
fma.rn.f64 fd408, fd339, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd409, fd341, 0dBFEEB42A9BCD5057, fd405;
fma.rn.f64 fd410, fd344, 0dBFD207E7FD768DBF, fd406;
fma.rn.f64 fd411, fd342, 0dBFEEB42A9BCD5057, fd407;
fma.rn.f64 fd412, fd343, 0dBFD207E7FD768DBF, fd408;
fma.rn.f64 fd413, fd345, 0d3FDA9628D9C712B6, fd409;
fma.rn.f64 fd414, fd348, 0dBFED1BB48EEE2C13, fd410;
fma.rn.f64 fd415, fd346, 0d3FDA9628D9C712B6, fd411;
fma.rn.f64 fd416, fd347, 0dBFED1BB48EEE2C13, fd412;
fma.rn.f64 fd417, fd349, 0d3FEAEB8C8764F0BA, fd413;
fma.rn.f64 fd418, fd352, 0d3FE14CEDF8BB580B, fd414;
fma.rn.f64 fd419, fd350, 0d3FEAEB8C8764F0BA, fd415;
fma.rn.f64 fd420, fd351, 0d3FE14CEDF8BB580B, fd416;
fma.rn.f64 fd421, fd353, 0dBFE4F49E7F775887, fd417;
fma.rn.f64 fd422, fd356, 0d3FE82F19BB3A28A1, fd418;
fma.rn.f64 fd423, fd354, 0dBFE4F49E7F775887, fd419;
fma.rn.f64 fd424, fd355, 0d3FE82F19BB3A28A1, fd420;
fma.rn.f64 fd425, fd337, 0dBFE4F49E7F775887, fd293;
fma.rn.f64 fd426, fd340, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd427, fd338, 0dBFE4F49E7F775887, fd294;
fma.rn.f64 fd428, fd339, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd429, fd341, 0dBFC2375F640F44DB, fd425;
fma.rn.f64 fd430, fd344, 0dBFEFAC9E043842EF, fd426;
fma.rn.f64 fd431, fd342, 0dBFC2375F640F44DB, fd427;
fma.rn.f64 fd432, fd343, 0dBFEFAC9E043842EF, fd428;
fma.rn.f64 fd433, fd345, 0d3FEAEB8C8764F0BA, fd429;
fma.rn.f64 fd434, fd348, 0d3FE14CEDF8BB580B, fd430;
fma.rn.f64 fd435, fd346, 0d3FEAEB8C8764F0BA, fd431;
fma.rn.f64 fd436, fd347, 0d3FE14CEDF8BB580B, fd432;
fma.rn.f64 fd437, fd349, 0dBFEEB42A9BCD5057, fd433;
fma.rn.f64 fd438, fd352, 0d3FD207E7FD768DBF, fd434;
fma.rn.f64 fd439, fd350, 0dBFEEB42A9BCD5057, fd435;
fma.rn.f64 fd440, fd351, 0d3FD207E7FD768DBF, fd436;
fma.rn.f64 fd441, fd353, 0d3FDA9628D9C712B6, fd437;
fma.rn.f64 fd442, fd356, 0dBFED1BB48EEE2C13, fd438;
fma.rn.f64 fd443, fd354, 0d3FDA9628D9C712B6, fd439;
fma.rn.f64 fd444, fd355, 0dBFED1BB48EEE2C13, fd440;
fma.rn.f64 fd445, fd337, 0dBFEEB42A9BCD5057, fd293;
fma.rn.f64 fd446, fd340, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd447, fd338, 0dBFEEB42A9BCD5057, fd294;
fma.rn.f64 fd448, fd339, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd449, fd341, 0d3FEAEB8C8764F0BA, fd445;
fma.rn.f64 fd450, fd344, 0dBFE14CEDF8BB580B, fd446;
fma.rn.f64 fd451, fd342, 0d3FEAEB8C8764F0BA, fd447;
fma.rn.f64 fd452, fd343, 0dBFE14CEDF8BB580B, fd448;
fma.rn.f64 fd453, fd345, 0dBFE4F49E7F775887, fd449;
fma.rn.f64 fd454, fd348, 0d3FE82F19BB3A28A1, fd450;
fma.rn.f64 fd455, fd346, 0dBFE4F49E7F775887, fd451;
fma.rn.f64 fd456, fd347, 0d3FE82F19BB3A28A1, fd452;
fma.rn.f64 fd457, fd349, 0d3FDA9628D9C712B6, fd453;
fma.rn.f64 fd458, fd352, 0dBFED1BB48EEE2C13, fd454;
fma.rn.f64 fd459, fd350, 0d3FDA9628D9C712B6, fd455;
fma.rn.f64 fd460, fd351, 0dBFED1BB48EEE2C13, fd456;
fma.rn.f64 fd461, fd353, 0dBFC2375F640F44DB, fd457;
fma.rn.f64 fd462, fd356, 0d3FEFAC9E043842EF, fd458;
fma.rn.f64 fd463, fd354, 0dBFC2375F640F44DB, fd459;
fma.rn.f64 fd464, fd355, 0d3FEFAC9E043842EF, fd460;
add.f64 %1, fd364, fd354;
add.f64 %0, fd363, fd353;
add.f64 %3, fd384, fd383;
sub.f64 %2, fd381, fd382;
add.f64 %5, fd404, fd403;
sub.f64 %4, fd401, fd402;
add.f64 %7, fd424, fd423;
sub.f64 %6, fd421, fd422;
add.f64 %9, fd444, fd443;
sub.f64 %8, fd441, fd442;
add.f64 %11, fd464, fd463;
sub.f64 %10, fd461, fd462;
sub.f64 %13, fd463, fd464;
add.f64 %12, fd462, fd461;
sub.f64 %15, fd443, fd444;
add.f64 %14, fd442, fd441;
sub.f64 %17, fd423, fd424;
add.f64 %16, fd422, fd421;
sub.f64 %19, fd403, fd404;
add.f64 %18, fd402, fd401;
sub.f64 %21, fd383, fd384;
add.f64 %20, fd382, fd381;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y): "r"(smem), "l"(lut_dp_11_121), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y));
};


#endif
