#ifndef CUFFTDX_FFT_15_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_15_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<2, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<313>;
.reg .b64 rd<2>;
add.f32 f61, %38, %62;
add.f32 f62, %30, f61;
add.f32 f63, %46, %54;
add.f32 f64, f63, f62;
add.f32 f65, %39, %63;
add.f32 f66, %31, f65;
add.f32 f67, %47, %55;
add.f32 f68, f67, f66;
fma.rn.f32 f69, f61, 0f3E9E377A, %30;
mul.f32 f70, f63, 0f3F4F1BBD;
sub.f32 f71, f69, f70;
sub.f32 f72, %39, %63;
mul.f32 f73, f72, 0f3F737871;
sub.f32 f74, %47, %55;
mul.f32 f75, f74, 0fBF167918;
sub.f32 f76, f75, f73;
sub.f32 f77, f71, f76;
add.f32 f78, f76, f71;
mul.f32 f79, f61, 0f3F4F1BBD;
sub.f32 f80, %30, f79;
fma.rn.f32 f81, f63, 0f3E9E377A, f80;
mul.f32 f82, f72, 0f3F167918;
mul.f32 f83, f74, 0f3F737871;
sub.f32 f84, f83, f82;
sub.f32 f85, f81, f84;
add.f32 f86, f84, f81;
fma.rn.f32 f87, f65, 0f3E9E377A, %31;
mul.f32 f88, f67, 0f3F4F1BBD;
sub.f32 f89, f87, f88;
sub.f32 f90, %38, %62;
mul.f32 f91, f90, 0f3F737871;
sub.f32 f92, %46, %54;
mul.f32 f93, f92, 0fBF167918;
sub.f32 f94, f93, f91;
add.f32 f95, f94, f89;
sub.f32 f96, f89, f94;
mul.f32 f97, f65, 0f3F4F1BBD;
sub.f32 f98, %31, f97;
fma.rn.f32 f99, f67, 0f3E9E377A, f98;
mul.f32 f100, f90, 0f3F167918;
mul.f32 f101, f92, 0f3F737871;
sub.f32 f102, f101, f100;
add.f32 f103, f102, f99;
sub.f32 f104, f99, f102;
add.f32 f105, %40, %64;
add.f32 f106, %32, f105;
add.f32 f107, %48, %56;
add.f32 f108, f107, f106;
add.f32 f109, %42, %66;
add.f32 f110, %34, f109;
add.f32 f111, %50, %58;
add.f32 f112, f111, f110;
fma.rn.f32 f113, f105, 0f3E9E377A, %32;
mul.f32 f114, f107, 0f3F4F1BBD;
sub.f32 f115, f113, f114;
sub.f32 f116, %42, %66;
mul.f32 f117, f116, 0f3F737871;
sub.f32 f118, %50, %58;
mul.f32 f119, f118, 0fBF167918;
sub.f32 f120, f119, f117;
sub.f32 f121, f115, f120;
add.f32 f122, f120, f115;
mul.f32 f123, f105, 0f3F4F1BBD;
sub.f32 f124, %32, f123;
fma.rn.f32 f125, f107, 0f3E9E377A, f124;
mul.f32 f126, f116, 0f3F167918;
mul.f32 f127, f118, 0f3F737871;
sub.f32 f128, f127, f126;
sub.f32 f129, f125, f128;
add.f32 f130, f128, f125;
fma.rn.f32 f131, f109, 0f3E9E377A, %34;
mul.f32 f132, f111, 0f3F4F1BBD;
sub.f32 f133, f131, f132;
sub.f32 f134, %40, %64;
mul.f32 f135, f134, 0f3F737871;
sub.f32 f136, %48, %56;
mul.f32 f137, f136, 0fBF167918;
sub.f32 f138, f137, f135;
add.f32 f139, f138, f133;
sub.f32 f140, f133, f138;
mul.f32 f141, f109, 0f3F4F1BBD;
sub.f32 f142, %34, f141;
fma.rn.f32 f143, f111, 0f3E9E377A, f142;
mul.f32 f144, f134, 0f3F167918;
mul.f32 f145, f136, 0f3F737871;
sub.f32 f146, f145, f144;
add.f32 f147, f146, f143;
sub.f32 f148, f143, f146;
add.f32 f149, %43, %67;
add.f32 f150, %35, f149;
add.f32 f151, %51, %59;
add.f32 f152, f151, f150;
add.f32 f153, %45, %68;
add.f32 f154, %37, f153;
add.f32 f155, %53, %61;
add.f32 f156, f155, f154;
fma.rn.f32 f157, f149, 0f3E9E377A, %35;
mul.f32 f158, f151, 0f3F4F1BBD;
sub.f32 f159, f157, f158;
sub.f32 f160, %45, %68;
mul.f32 f161, f160, 0f3F737871;
sub.f32 f162, %53, %61;
mul.f32 f163, f162, 0fBF167918;
sub.f32 f164, f163, f161;
sub.f32 f165, f159, f164;
add.f32 f166, f164, f159;
mul.f32 f167, f149, 0f3F4F1BBD;
sub.f32 f168, %35, f167;
fma.rn.f32 f169, f151, 0f3E9E377A, f168;
mul.f32 f170, f160, 0f3F167918;
mul.f32 f171, f162, 0f3F737871;
sub.f32 f172, f171, f170;
sub.f32 f173, f169, f172;
add.f32 f174, f172, f169;
fma.rn.f32 f175, f153, 0f3E9E377A, %37;
mul.f32 f176, f155, 0f3F4F1BBD;
sub.f32 f177, f175, f176;
sub.f32 f178, %43, %67;
mul.f32 f179, f178, 0f3F737871;
sub.f32 f180, %51, %59;
mul.f32 f181, f180, 0fBF167918;
sub.f32 f182, f181, f179;
add.f32 f183, f182, f177;
sub.f32 f184, f177, f182;
mul.f32 f185, f153, 0f3F4F1BBD;
sub.f32 f186, %37, f185;
fma.rn.f32 f187, f155, 0f3E9E377A, f186;
mul.f32 f188, f178, 0f3F167918;
mul.f32 f189, f180, 0f3F737871;
sub.f32 f190, f189, f188;
add.f32 f191, f190, f187;
sub.f32 f192, f187, f190;
mul.f32 f193, f121, 0f3F69DE1D;
mul.f32 f194, f139, 0fBED03FC9;
sub.f32 f195, f193, f194;
mul.f32 f196, f139, 0f3F69DE1D;
fma.rn.f32 f197, f121, 0fBED03FC9, f196;
mul.f32 f198, f165, 0f3F2B4C25;
mul.f32 f199, f183, 0fBF3E3EBD;
sub.f32 f200, f198, f199;
mul.f32 f201, f183, 0f3F2B4C25;
fma.rn.f32 f202, f165, 0fBF3E3EBD, f201;
mul.f32 f203, f129, 0f3F2B4C25;
mul.f32 f204, f147, 0fBF3E3EBD;
sub.f32 f205, f203, f204;
mul.f32 f206, f147, 0f3F2B4C25;
fma.rn.f32 f207, f129, 0fBF3E3EBD, f206;
mul.f32 f208, f173, 0fBDD61305;
mul.f32 f209, f191, 0fBF7E98FD;
sub.f32 f210, f208, f209;
mul.f32 f211, f191, 0fBDD61305;
fma.rn.f32 f212, f173, 0fBF7E98FD, f211;
mul.f32 f213, f130, 0f3E9E377A;
mul.f32 f214, f148, 0fBF737871;
sub.f32 f215, f213, f214;
mul.f32 f216, f148, 0f3E9E377A;
fma.rn.f32 f217, f130, 0fBF737871, f216;
mul.f32 f218, f174, 0fBF4F1BBD;
mul.f32 f219, f192, 0fBF167918;
sub.f32 f220, f218, f219;
mul.f32 f221, f192, 0fBF4F1BBD;
fma.rn.f32 f222, f174, 0fBF167918, f221;
mul.f32 f223, f122, 0fBDD61305;
mul.f32 f224, f140, 0fBF7E98FD;
sub.f32 f225, f223, f224;
mul.f32 f226, f140, 0fBDD61305;
fma.rn.f32 f227, f122, 0fBF7E98FD, f226;
mul.f32 f228, f166, 0fBF7A67E2;
mul.f32 f229, f184, 0f3E54E6CD;
sub.f32 f230, f228, f229;
mul.f32 f231, f184, 0fBF7A67E2;
fma.rn.f32 f232, f166, 0f3E54E6CD, f231;
add.f32 f233, f108, f152;
add.f32 f234, f112, f156;
mul.f32 f235, f233, 0f3F000000;
sub.f32 f236, f64, f235;
sub.f32 f237, f112, f156;
mul.f32 f238, f237, 0f3F5DB3D7;
mul.f32 f239, f234, 0f3F000000;
sub.f32 f240, f68, f239;
sub.f32 f241, f108, f152;
mul.f32 f242, f241, 0f3F5DB3D7;
add.f32 f243, f195, f200;
add.f32 f244, f197, f202;
mul.f32 f245, f243, 0f3F000000;
sub.f32 f246, f77, f245;
sub.f32 f247, f197, f202;
mul.f32 f248, f247, 0f3F5DB3D7;
mul.f32 f249, f244, 0f3F000000;
sub.f32 f250, f95, f249;
sub.f32 f251, f195, f200;
mul.f32 f252, f251, 0f3F5DB3D7;
add.f32 f253, f205, f210;
add.f32 f254, f207, f212;
mul.f32 f255, f253, 0f3F000000;
sub.f32 f256, f85, f255;
sub.f32 f257, f207, f212;
mul.f32 f258, f257, 0f3F5DB3D7;
mul.f32 f259, f254, 0f3F000000;
sub.f32 f260, f103, f259;
sub.f32 f261, f205, f210;
mul.f32 f262, f261, 0f3F5DB3D7;
add.f32 f263, f215, f220;
add.f32 f264, f217, f222;
mul.f32 f265, f263, 0f3F000000;
sub.f32 f266, f86, f265;
sub.f32 f267, f217, f222;
mul.f32 f268, f267, 0f3F5DB3D7;
mul.f32 f269, f264, 0f3F000000;
sub.f32 f270, f104, f269;
sub.f32 f271, f215, f220;
mul.f32 f272, f271, 0f3F5DB3D7;
add.f32 f273, f225, f230;
add.f32 f274, f227, f232;
mul.f32 f275, f273, 0f3F000000;
sub.f32 f276, f78, f275;
sub.f32 f277, f227, f232;
mul.f32 f278, f277, 0f3F5DB3D7;
mul.f32 f279, f274, 0f3F000000;
sub.f32 f280, f96, f279;
sub.f32 f281, f225, f230;
mul.f32 f282, f281, 0f3F5DB3D7;
add.f32 %1, f68, f234;
add.f32 %0, f64, f233;
add.f32 %3, f95, f244;
add.f32 %2, f77, f243;
add.f32 %5, f103, f254;
add.f32 %4, f85, f253;
add.f32 %7, f104, f264;
add.f32 %6, f86, f263;
add.f32 %9, f96, f274;
add.f32 %8, f78, f273;
sub.f32 %11, f240, f242;
add.f32 %10, f238, f236;
sub.f32 %13, f250, f252;
add.f32 %12, f248, f246;
sub.f32 %15, f260, f262;
add.f32 %14, f258, f256;
sub.f32 %17, f270, f272;
add.f32 %16, f268, f266;
sub.f32 %19, f280, f282;
add.f32 %18, f278, f276;
add.f32 %21, f242, f240;
sub.f32 %20, f236, f238;
add.f32 %23, f252, f250;
sub.f32 %22, f246, f248;
add.f32 %25, f262, f260;
sub.f32 %24, f256, f258;
add.f32 %27, f272, f270;
sub.f32 %26, f266, f268;
add.f32 %29, f282, f280;
sub.f32 %28, f276, f278;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y));
};


#endif
