#ifndef CUFFTDX_FFT_16384_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_16384_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<1170, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<1194>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 17;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd65, %36, %57;
add.f64 fd66, %37, %59;
sub.f64 fd67, %36, %57;
sub.f64 fd68, %37, %59;
add.f64 fd69, %46, %68;
add.f64 fd70, %48, %69;
sub.f64 fd71, %46, %68;
sub.f64 fd72, %48, %69;
add.f64 fd73, fd65, fd69;
add.f64 fd74, fd66, fd70;
sub.f64 fd75, fd65, fd69;
sub.f64 fd76, fd66, fd70;
sub.f64 fd77, fd67, fd72;
add.f64 fd78, fd68, fd71;
add.f64 fd79, fd67, fd72;
sub.f64 fd80, fd68, fd71;
add.f64 fd81, %41, %62;
add.f64 fd82, %43, %64;
sub.f64 fd83, %41, %62;
sub.f64 fd84, %43, %64;
add.f64 fd85, %52, %73;
add.f64 fd86, %53, %75;
sub.f64 fd87, %52, %73;
sub.f64 fd88, %53, %75;
add.f64 fd89, fd81, fd85;
add.f64 fd90, fd82, fd86;
sub.f64 fd91, fd81, fd85;
sub.f64 fd92, fd82, fd86;
sub.f64 fd93, fd83, fd88;
add.f64 fd94, fd84, fd87;
add.f64 fd95, fd83, fd88;
sub.f64 fd96, fd84, fd87;
mul.f64 fd97, fd93, 0d3FE6A09E667F3BCD;
mul.f64 fd98, fd94, 0d3FE6A09E667F3BCD;
sub.f64 fd99, fd97, fd98;
add.f64 fd100, fd97, fd98;
mul.f64 fd101, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd102, fd96, 0d3FE6A09E667F3BCD;
sub.f64 fd103, fd101, fd102;
mul.f64 fd104, fd96, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd105, fd95, 0d3FE6A09E667F3BCD, fd104;
add.f64 fd106, fd73, fd89;
add.f64 fd107, fd74, fd90;
sub.f64 fd108, fd73, fd89;
sub.f64 fd109, fd74, fd90;
add.f64 fd110, fd77, fd99;
add.f64 fd111, fd78, fd100;
sub.f64 fd112, fd77, fd99;
sub.f64 fd113, fd78, fd100;
sub.f64 fd114, fd75, fd92;
add.f64 fd115, fd76, fd91;
add.f64 fd116, fd75, fd92;
sub.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd103;
add.f64 fd119, fd80, fd105;
sub.f64 fd120, fd79, fd103;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %38, %60;
add.f64 fd123, %40, %61;
sub.f64 fd124, %38, %60;
sub.f64 fd125, %40, %61;
add.f64 fd126, %49, %70;
add.f64 fd127, %51, %72;
sub.f64 fd128, %49, %70;
sub.f64 fd129, %51, %72;
add.f64 fd130, fd122, fd126;
add.f64 fd131, fd123, fd127;
sub.f64 fd132, fd122, fd126;
sub.f64 fd133, fd123, fd127;
sub.f64 fd134, fd124, fd129;
add.f64 fd135, fd125, fd128;
add.f64 fd136, fd124, fd129;
sub.f64 fd137, fd125, fd128;
add.f64 fd138, %44, %65;
add.f64 fd139, %45, %67;
sub.f64 fd140, %44, %65;
sub.f64 fd141, %45, %67;
add.f64 fd142, %54, %76;
add.f64 fd143, %56, %77;
sub.f64 fd144, %54, %76;
sub.f64 fd145, %56, %77;
add.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd143;
sub.f64 fd148, fd138, fd142;
sub.f64 fd149, fd139, fd143;
sub.f64 fd150, fd140, fd145;
add.f64 fd151, fd141, fd144;
add.f64 fd152, fd140, fd145;
sub.f64 fd153, fd141, fd144;
mul.f64 fd154, fd150, 0d3FE6A09E667F3BCD;
mul.f64 fd155, fd151, 0d3FE6A09E667F3BCD;
sub.f64 fd156, fd154, fd155;
add.f64 fd157, fd154, fd155;
mul.f64 fd158, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd159, fd153, 0d3FE6A09E667F3BCD;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd153, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd162, fd152, 0d3FE6A09E667F3BCD, fd161;
add.f64 fd163, fd130, fd146;
add.f64 fd164, fd131, fd147;
sub.f64 fd165, fd130, fd146;
sub.f64 fd166, fd131, fd147;
add.f64 fd167, fd134, fd156;
add.f64 fd168, fd135, fd157;
sub.f64 fd169, fd134, fd156;
sub.f64 fd170, fd135, fd157;
sub.f64 fd171, fd132, fd149;
add.f64 fd172, fd133, fd148;
add.f64 fd173, fd132, fd149;
sub.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd160;
add.f64 fd176, fd137, fd162;
sub.f64 fd177, fd136, fd160;
sub.f64 fd178, fd137, fd162;
mul.f64 fd179, fd167, 0d3FED906BCF328D46;
mul.f64 fd180, fd168, 0d3FD87DE2A6AEA963;
sub.f64 fd181, fd179, fd180;
mul.f64 fd182, fd168, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0d3FD87DE2A6AEA963, fd182;
mul.f64 fd184, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd185, fd172, 0d3FE6A09E667F3BCD;
sub.f64 fd186, fd184, fd185;
add.f64 fd187, fd184, fd185;
mul.f64 fd188, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd189, fd176, 0d3FED906BCF328D46;
sub.f64 fd190, fd188, fd189;
mul.f64 fd191, fd176, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd192, fd175, 0d3FED906BCF328D46, fd191;
mul.f64 fd193, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd194, fd170, 0d3FED906BCF328D46;
sub.f64 fd195, fd193, fd194;
mul.f64 fd196, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd197, fd169, 0d3FED906BCF328D46, fd196;
mul.f64 fd198, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd199, fd174, 0d3FE6A09E667F3BCD;
sub.f64 fd200, fd198, fd199;
mul.f64 fd201, fd174, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd202, fd173, 0d3FE6A09E667F3BCD, fd201;
mul.f64 fd203, fd177, 0dBFED906BCF328D46;
mul.f64 fd204, fd178, 0d3FD87DE2A6AEA963;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0d3FD87DE2A6AEA963, fd206;
add.f64 fd208, fd106, fd163;
add.f64 fd209, fd107, fd164;
sub.f64 fd210, fd106, fd163;
sub.f64 fd211, fd107, fd164;
add.f64 fd212, fd110, fd181;
add.f64 fd213, fd111, fd183;
sub.f64 fd214, fd110, fd181;
sub.f64 fd215, fd111, fd183;
add.f64 fd216, fd114, fd186;
add.f64 fd217, fd115, fd187;
sub.f64 fd218, fd114, fd186;
sub.f64 fd219, fd115, fd187;
add.f64 fd220, fd118, fd190;
add.f64 fd221, fd119, fd192;
sub.f64 fd222, fd118, fd190;
sub.f64 fd223, fd119, fd192;
sub.f64 fd224, fd108, fd166;
add.f64 fd225, fd109, fd165;
add.f64 fd226, fd108, fd166;
sub.f64 fd227, fd109, fd165;
add.f64 fd228, fd112, fd195;
add.f64 fd229, fd113, fd197;
sub.f64 fd230, fd112, fd195;
sub.f64 fd231, fd113, fd197;
add.f64 fd232, fd116, fd200;
add.f64 fd233, fd117, fd202;
sub.f64 fd234, fd116, fd200;
sub.f64 fd235, fd117, fd202;
add.f64 fd236, fd120, fd205;
add.f64 fd237, fd121, fd207;
sub.f64 fd238, fd120, fd205;
sub.f64 fd239, fd121, fd207;
and.b32 r6, r5, 1023;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 16368;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd240, fd241}, [rd5];
mul.f64 fd244, fd213, fd241;
fma.rn.f64 fd245, fd240, fd212, fd244;
mul.f64 fd246, fd212, fd241;
mul.f64 fd247, fd240, fd213;
sub.f64 fd248, fd247, fd246;
mul.f64 fd249, fd240, fd240;
mul.f64 fd250, fd241, fd241;
sub.f64 fd251, fd249, fd250;
mul.f64 fd252, fd241, fd240;
fma.rn.f64 fd253, fd241, fd240, fd252;
mul.f64 fd254, fd217, fd253;
fma.rn.f64 fd255, fd251, fd216, fd254;
mul.f64 fd256, fd216, fd253;
mul.f64 fd257, fd251, fd217;
sub.f64 fd258, fd257, fd256;
mul.f64 fd259, fd240, fd251;
mul.f64 fd260, fd241, fd253;
sub.f64 fd261, fd259, fd260;
mul.f64 fd262, fd240, fd253;
fma.rn.f64 fd263, fd241, fd251, fd262;
mul.f64 fd264, fd221, fd263;
fma.rn.f64 fd265, fd261, fd220, fd264;
mul.f64 fd266, fd220, fd263;
mul.f64 fd267, fd261, fd221;
sub.f64 fd268, fd267, fd266;
mul.f64 fd269, fd240, fd261;
mul.f64 fd270, fd241, fd263;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd240, fd263;
fma.rn.f64 fd273, fd241, fd261, fd272;
mul.f64 fd274, fd225, fd273;
fma.rn.f64 fd275, fd271, fd224, fd274;
mul.f64 fd276, fd224, fd273;
mul.f64 fd277, fd271, fd225;
sub.f64 fd278, fd277, fd276;
mul.f64 fd279, fd240, fd271;
mul.f64 fd280, fd241, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd240, fd273;
fma.rn.f64 fd283, fd241, fd271, fd282;
mul.f64 fd284, fd229, fd283;
fma.rn.f64 fd285, fd281, fd228, fd284;
mul.f64 fd286, fd228, fd283;
mul.f64 fd287, fd281, fd229;
sub.f64 fd288, fd287, fd286;
mul.f64 fd289, fd240, fd281;
mul.f64 fd290, fd241, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd240, fd283;
fma.rn.f64 fd293, fd241, fd281, fd292;
mul.f64 fd294, fd233, fd293;
fma.rn.f64 fd295, fd291, fd232, fd294;
mul.f64 fd296, fd232, fd293;
mul.f64 fd297, fd291, fd233;
sub.f64 fd298, fd297, fd296;
mul.f64 fd299, fd240, fd291;
mul.f64 fd300, fd241, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd240, fd293;
fma.rn.f64 fd303, fd241, fd291, fd302;
mul.f64 fd304, fd237, fd303;
fma.rn.f64 fd305, fd301, fd236, fd304;
mul.f64 fd306, fd236, fd303;
mul.f64 fd307, fd301, fd237;
sub.f64 fd308, fd307, fd306;
mul.f64 fd309, fd240, fd301;
mul.f64 fd310, fd241, fd303;
sub.f64 fd311, fd309, fd310;
mul.f64 fd312, fd240, fd303;
fma.rn.f64 fd313, fd241, fd301, fd312;
mul.f64 fd314, fd211, fd313;
fma.rn.f64 fd315, fd311, fd210, fd314;
mul.f64 fd316, fd210, fd313;
mul.f64 fd317, fd311, fd211;
sub.f64 fd318, fd317, fd316;
ld.global.v2.f64 {fd319, fd320}, [rd5+16384];
mul.f64 fd323, fd215, fd320;
fma.rn.f64 fd324, fd319, fd214, fd323;
mul.f64 fd325, fd214, fd320;
mul.f64 fd326, fd319, fd215;
sub.f64 fd327, fd326, fd325;
mul.f64 fd328, fd240, fd319;
mul.f64 fd329, fd241, fd320;
sub.f64 fd330, fd328, fd329;
mul.f64 fd331, fd240, fd320;
fma.rn.f64 fd332, fd241, fd319, fd331;
mul.f64 fd333, fd219, fd332;
fma.rn.f64 fd334, fd330, fd218, fd333;
mul.f64 fd335, fd218, fd332;
mul.f64 fd336, fd330, fd219;
sub.f64 fd337, fd336, fd335;
mul.f64 fd338, fd240, fd330;
mul.f64 fd339, fd241, fd332;
sub.f64 fd340, fd338, fd339;
mul.f64 fd341, fd240, fd332;
fma.rn.f64 fd342, fd241, fd330, fd341;
mul.f64 fd343, fd223, fd342;
fma.rn.f64 fd344, fd340, fd222, fd343;
mul.f64 fd345, fd222, fd342;
mul.f64 fd346, fd340, fd223;
sub.f64 fd347, fd346, fd345;
mul.f64 fd348, fd240, fd340;
mul.f64 fd349, fd241, fd342;
sub.f64 fd350, fd348, fd349;
mul.f64 fd351, fd240, fd342;
fma.rn.f64 fd352, fd241, fd340, fd351;
mul.f64 fd353, fd227, fd352;
fma.rn.f64 fd354, fd350, fd226, fd353;
mul.f64 fd355, fd226, fd352;
mul.f64 fd356, fd350, fd227;
sub.f64 fd357, fd356, fd355;
mul.f64 fd358, fd240, fd350;
mul.f64 fd359, fd241, fd352;
sub.f64 fd360, fd358, fd359;
mul.f64 fd361, fd240, fd352;
fma.rn.f64 fd362, fd241, fd350, fd361;
mul.f64 fd363, fd231, fd362;
fma.rn.f64 fd364, fd360, fd230, fd363;
mul.f64 fd365, fd230, fd362;
mul.f64 fd366, fd360, fd231;
sub.f64 fd367, fd366, fd365;
mul.f64 fd368, fd240, fd360;
mul.f64 fd369, fd241, fd362;
sub.f64 fd370, fd368, fd369;
mul.f64 fd371, fd240, fd362;
fma.rn.f64 fd372, fd241, fd360, fd371;
mul.f64 fd373, fd235, fd372;
fma.rn.f64 fd374, fd370, fd234, fd373;
mul.f64 fd375, fd234, fd372;
mul.f64 fd376, fd370, fd235;
sub.f64 fd377, fd376, fd375;
mul.f64 fd378, fd240, fd370;
mul.f64 fd379, fd241, fd372;
sub.f64 fd380, fd378, fd379;
mul.f64 fd381, fd240, fd372;
fma.rn.f64 fd382, fd241, fd370, fd381;
mul.f64 fd383, fd239, fd382;
fma.rn.f64 fd384, fd380, fd238, fd383;
mul.f64 fd385, fd238, fd382;
mul.f64 fd386, fd380, fd239;
sub.f64 fd387, fd386, fd385;
shl.b32 r8, r5, 7;
and.b32 r9, r8, -131072;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 130944;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd208, fd245};
st.shared.v2.f64 [r12+16], {fd255, fd265};
st.shared.v2.f64 [r12+32], {fd275, fd285};
st.shared.v2.f64 [r12+48], {fd295, fd305};
st.shared.v2.f64 [r12+64], {fd315, fd324};
st.shared.v2.f64 [r12+80], {fd334, fd344};
st.shared.v2.f64 [r12+96], {fd354, fd364};
st.shared.v2.f64 [r12+112], {fd374, fd384};
barrier.sync 0;
mad.lo.s32 r13, r6, -120, r12;
ld.shared.f64 fd388, [r13];
ld.shared.f64 fd389, [r13+8192];
ld.shared.f64 fd390, [r13+16384];
ld.shared.f64 fd391, [r13+24576];
ld.shared.f64 fd392, [r13+32768];
ld.shared.f64 fd393, [r13+40960];
ld.shared.f64 fd394, [r13+49152];
ld.shared.f64 fd395, [r13+57344];
ld.shared.f64 fd396, [r13+65536];
ld.shared.f64 fd397, [r13+73728];
ld.shared.f64 fd398, [r13+81920];
ld.shared.f64 fd399, [r13+90112];
ld.shared.f64 fd400, [r13+98304];
ld.shared.f64 fd401, [r13+106496];
ld.shared.f64 fd402, [r13+114688];
ld.shared.f64 fd403, [r13+122880];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd209, fd248};
st.shared.v2.f64 [r12+16], {fd258, fd268};
st.shared.v2.f64 [r12+32], {fd278, fd288};
st.shared.v2.f64 [r12+48], {fd298, fd308};
st.shared.v2.f64 [r12+64], {fd318, fd327};
st.shared.v2.f64 [r12+80], {fd337, fd347};
st.shared.v2.f64 [r12+96], {fd357, fd367};
st.shared.v2.f64 [r12+112], {fd377, fd387};
barrier.sync 0;
ld.shared.f64 fd404, [r13];
ld.shared.f64 fd405, [r13+8192];
ld.shared.f64 fd406, [r13+16384];
ld.shared.f64 fd407, [r13+24576];
ld.shared.f64 fd408, [r13+32768];
ld.shared.f64 fd409, [r13+40960];
ld.shared.f64 fd410, [r13+49152];
ld.shared.f64 fd411, [r13+57344];
ld.shared.f64 fd412, [r13+65536];
ld.shared.f64 fd413, [r13+73728];
ld.shared.f64 fd414, [r13+81920];
ld.shared.f64 fd415, [r13+90112];
ld.shared.f64 fd416, [r13+98304];
ld.shared.f64 fd417, [r13+106496];
ld.shared.f64 fd418, [r13+114688];
ld.shared.f64 fd419, [r13+122880];
add.f64 fd420, fd388, fd396;
add.f64 fd421, fd404, fd412;
sub.f64 fd422, fd388, fd396;
sub.f64 fd423, fd404, fd412;
add.f64 fd424, fd392, fd400;
add.f64 fd425, fd408, fd416;
sub.f64 fd426, fd392, fd400;
sub.f64 fd427, fd408, fd416;
add.f64 fd428, fd420, fd424;
add.f64 fd429, fd421, fd425;
sub.f64 fd430, fd420, fd424;
sub.f64 fd431, fd421, fd425;
sub.f64 fd432, fd422, fd427;
add.f64 fd433, fd423, fd426;
add.f64 fd434, fd422, fd427;
sub.f64 fd435, fd423, fd426;
add.f64 fd436, fd390, fd398;
add.f64 fd437, fd406, fd414;
sub.f64 fd438, fd390, fd398;
sub.f64 fd439, fd406, fd414;
add.f64 fd440, fd394, fd402;
add.f64 fd441, fd410, fd418;
sub.f64 fd442, fd394, fd402;
sub.f64 fd443, fd410, fd418;
add.f64 fd444, fd436, fd440;
add.f64 fd445, fd437, fd441;
sub.f64 fd446, fd436, fd440;
sub.f64 fd447, fd437, fd441;
sub.f64 fd448, fd438, fd443;
add.f64 fd449, fd439, fd442;
add.f64 fd450, fd438, fd443;
sub.f64 fd451, fd439, fd442;
mul.f64 fd452, fd448, 0d3FE6A09E667F3BCD;
mul.f64 fd453, fd449, 0d3FE6A09E667F3BCD;
sub.f64 fd454, fd452, fd453;
add.f64 fd455, fd452, fd453;
mul.f64 fd456, fd450, 0dBFE6A09E667F3BCD;
mul.f64 fd457, fd451, 0d3FE6A09E667F3BCD;
sub.f64 fd458, fd456, fd457;
mul.f64 fd459, fd451, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd460, fd450, 0d3FE6A09E667F3BCD, fd459;
add.f64 fd461, fd428, fd444;
add.f64 fd462, fd429, fd445;
sub.f64 fd463, fd428, fd444;
sub.f64 fd464, fd429, fd445;
add.f64 fd465, fd432, fd454;
add.f64 fd466, fd433, fd455;
sub.f64 fd467, fd432, fd454;
sub.f64 fd468, fd433, fd455;
sub.f64 fd469, fd430, fd447;
add.f64 fd470, fd431, fd446;
add.f64 fd471, fd430, fd447;
sub.f64 fd472, fd431, fd446;
add.f64 fd473, fd434, fd458;
add.f64 fd474, fd435, fd460;
sub.f64 fd475, fd434, fd458;
sub.f64 fd476, fd435, fd460;
add.f64 fd477, fd389, fd397;
add.f64 fd478, fd405, fd413;
sub.f64 fd479, fd389, fd397;
sub.f64 fd480, fd405, fd413;
add.f64 fd481, fd393, fd401;
add.f64 fd482, fd409, fd417;
sub.f64 fd483, fd393, fd401;
sub.f64 fd484, fd409, fd417;
add.f64 fd485, fd477, fd481;
add.f64 fd486, fd478, fd482;
sub.f64 fd487, fd477, fd481;
sub.f64 fd488, fd478, fd482;
sub.f64 fd489, fd479, fd484;
add.f64 fd490, fd480, fd483;
add.f64 fd491, fd479, fd484;
sub.f64 fd492, fd480, fd483;
add.f64 fd493, fd391, fd399;
add.f64 fd494, fd407, fd415;
sub.f64 fd495, fd391, fd399;
sub.f64 fd496, fd407, fd415;
add.f64 fd497, fd395, fd403;
add.f64 fd498, fd411, fd419;
sub.f64 fd499, fd395, fd403;
sub.f64 fd500, fd411, fd419;
add.f64 fd501, fd493, fd497;
add.f64 fd502, fd494, fd498;
sub.f64 fd503, fd493, fd497;
sub.f64 fd504, fd494, fd498;
sub.f64 fd505, fd495, fd500;
add.f64 fd506, fd496, fd499;
add.f64 fd507, fd495, fd500;
sub.f64 fd508, fd496, fd499;
mul.f64 fd509, fd505, 0d3FE6A09E667F3BCD;
mul.f64 fd510, fd506, 0d3FE6A09E667F3BCD;
sub.f64 fd511, fd509, fd510;
add.f64 fd512, fd509, fd510;
mul.f64 fd513, fd507, 0dBFE6A09E667F3BCD;
mul.f64 fd514, fd508, 0d3FE6A09E667F3BCD;
sub.f64 fd515, fd513, fd514;
mul.f64 fd516, fd508, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd517, fd507, 0d3FE6A09E667F3BCD, fd516;
add.f64 fd518, fd485, fd501;
add.f64 fd519, fd486, fd502;
sub.f64 fd520, fd485, fd501;
sub.f64 fd521, fd486, fd502;
add.f64 fd522, fd489, fd511;
add.f64 fd523, fd490, fd512;
sub.f64 fd524, fd489, fd511;
sub.f64 fd525, fd490, fd512;
sub.f64 fd526, fd487, fd504;
add.f64 fd527, fd488, fd503;
add.f64 fd528, fd487, fd504;
sub.f64 fd529, fd488, fd503;
add.f64 fd530, fd491, fd515;
add.f64 fd531, fd492, fd517;
sub.f64 fd532, fd491, fd515;
sub.f64 fd533, fd492, fd517;
mul.f64 fd534, fd522, 0d3FED906BCF328D46;
mul.f64 fd535, fd523, 0d3FD87DE2A6AEA963;
sub.f64 fd536, fd534, fd535;
mul.f64 fd537, fd523, 0d3FED906BCF328D46;
fma.rn.f64 fd538, fd522, 0d3FD87DE2A6AEA963, fd537;
mul.f64 fd539, fd526, 0d3FE6A09E667F3BCD;
mul.f64 fd540, fd527, 0d3FE6A09E667F3BCD;
sub.f64 fd541, fd539, fd540;
add.f64 fd542, fd539, fd540;
mul.f64 fd543, fd530, 0d3FD87DE2A6AEA963;
mul.f64 fd544, fd531, 0d3FED906BCF328D46;
sub.f64 fd545, fd543, fd544;
mul.f64 fd546, fd531, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd547, fd530, 0d3FED906BCF328D46, fd546;
mul.f64 fd548, fd524, 0dBFD87DE2A6AEA963;
mul.f64 fd549, fd525, 0d3FED906BCF328D46;
sub.f64 fd550, fd548, fd549;
mul.f64 fd551, fd525, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd552, fd524, 0d3FED906BCF328D46, fd551;
mul.f64 fd553, fd528, 0dBFE6A09E667F3BCD;
mul.f64 fd554, fd529, 0d3FE6A09E667F3BCD;
sub.f64 fd555, fd553, fd554;
mul.f64 fd556, fd529, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd557, fd528, 0d3FE6A09E667F3BCD, fd556;
mul.f64 fd558, fd532, 0dBFED906BCF328D46;
mul.f64 fd559, fd533, 0d3FD87DE2A6AEA963;
sub.f64 fd560, fd558, fd559;
mul.f64 fd561, fd533, 0dBFED906BCF328D46;
fma.rn.f64 fd562, fd532, 0d3FD87DE2A6AEA963, fd561;
add.f64 fd563, fd461, fd518;
add.f64 fd564, fd462, fd519;
sub.f64 fd565, fd461, fd518;
sub.f64 fd566, fd462, fd519;
add.f64 fd567, fd465, fd536;
add.f64 fd568, fd466, fd538;
sub.f64 fd569, fd465, fd536;
sub.f64 fd570, fd466, fd538;
add.f64 fd571, fd469, fd541;
add.f64 fd572, fd470, fd542;
sub.f64 fd573, fd469, fd541;
sub.f64 fd574, fd470, fd542;
add.f64 fd575, fd473, fd545;
add.f64 fd576, fd474, fd547;
sub.f64 fd577, fd473, fd545;
sub.f64 fd578, fd474, fd547;
sub.f64 fd579, fd463, fd521;
add.f64 fd580, fd464, fd520;
add.f64 fd581, fd463, fd521;
sub.f64 fd582, fd464, fd520;
add.f64 fd583, fd467, fd550;
add.f64 fd584, fd468, fd552;
sub.f64 fd585, fd467, fd550;
sub.f64 fd586, fd468, fd552;
add.f64 fd587, fd471, fd555;
add.f64 fd588, fd472, fd557;
sub.f64 fd589, fd471, fd555;
sub.f64 fd590, fd472, fd557;
add.f64 fd591, fd475, fd560;
add.f64 fd592, fd476, fd562;
sub.f64 fd593, fd475, fd560;
sub.f64 fd594, fd476, fd562;
and.b32 r14, r5, 1008;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %34;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd595, fd596}, [rd8];
mul.f64 fd599, fd568, fd596;
fma.rn.f64 fd600, fd595, fd567, fd599;
mul.f64 fd601, fd567, fd596;
mul.f64 fd602, fd595, fd568;
sub.f64 fd603, fd602, fd601;
mul.f64 fd604, fd595, fd595;
mul.f64 fd605, fd596, fd596;
sub.f64 fd606, fd604, fd605;
mul.f64 fd607, fd596, fd595;
fma.rn.f64 fd608, fd596, fd595, fd607;
mul.f64 fd609, fd572, fd608;
fma.rn.f64 fd610, fd606, fd571, fd609;
mul.f64 fd611, fd571, fd608;
mul.f64 fd612, fd606, fd572;
sub.f64 fd613, fd612, fd611;
mul.f64 fd614, fd595, fd606;
mul.f64 fd615, fd596, fd608;
sub.f64 fd616, fd614, fd615;
mul.f64 fd617, fd595, fd608;
fma.rn.f64 fd618, fd596, fd606, fd617;
mul.f64 fd619, fd576, fd618;
fma.rn.f64 fd620, fd616, fd575, fd619;
mul.f64 fd621, fd575, fd618;
mul.f64 fd622, fd616, fd576;
sub.f64 fd623, fd622, fd621;
mul.f64 fd624, fd595, fd616;
mul.f64 fd625, fd596, fd618;
sub.f64 fd626, fd624, fd625;
mul.f64 fd627, fd595, fd618;
fma.rn.f64 fd628, fd596, fd616, fd627;
mul.f64 fd629, fd580, fd628;
fma.rn.f64 fd630, fd626, fd579, fd629;
mul.f64 fd631, fd579, fd628;
mul.f64 fd632, fd626, fd580;
sub.f64 fd633, fd632, fd631;
mul.f64 fd634, fd595, fd626;
mul.f64 fd635, fd596, fd628;
sub.f64 fd636, fd634, fd635;
mul.f64 fd637, fd595, fd628;
fma.rn.f64 fd638, fd596, fd626, fd637;
mul.f64 fd639, fd584, fd638;
fma.rn.f64 fd640, fd636, fd583, fd639;
mul.f64 fd641, fd583, fd638;
mul.f64 fd642, fd636, fd584;
sub.f64 fd643, fd642, fd641;
mul.f64 fd644, fd595, fd636;
mul.f64 fd645, fd596, fd638;
sub.f64 fd646, fd644, fd645;
mul.f64 fd647, fd595, fd638;
fma.rn.f64 fd648, fd596, fd636, fd647;
mul.f64 fd649, fd588, fd648;
fma.rn.f64 fd650, fd646, fd587, fd649;
mul.f64 fd651, fd587, fd648;
mul.f64 fd652, fd646, fd588;
sub.f64 fd653, fd652, fd651;
mul.f64 fd654, fd595, fd646;
mul.f64 fd655, fd596, fd648;
sub.f64 fd656, fd654, fd655;
mul.f64 fd657, fd595, fd648;
fma.rn.f64 fd658, fd596, fd646, fd657;
mul.f64 fd659, fd592, fd658;
fma.rn.f64 fd660, fd656, fd591, fd659;
mul.f64 fd661, fd591, fd658;
mul.f64 fd662, fd656, fd592;
sub.f64 fd663, fd662, fd661;
mul.f64 fd664, fd595, fd656;
mul.f64 fd665, fd596, fd658;
sub.f64 fd666, fd664, fd665;
mul.f64 fd667, fd595, fd658;
fma.rn.f64 fd668, fd596, fd656, fd667;
mul.f64 fd669, fd566, fd668;
fma.rn.f64 fd670, fd666, fd565, fd669;
mul.f64 fd671, fd565, fd668;
mul.f64 fd672, fd666, fd566;
sub.f64 fd673, fd672, fd671;
ld.global.v2.f64 {fd674, fd675}, [rd8+1024];
mul.f64 fd678, fd570, fd675;
fma.rn.f64 fd679, fd674, fd569, fd678;
mul.f64 fd680, fd569, fd675;
mul.f64 fd681, fd674, fd570;
sub.f64 fd682, fd681, fd680;
mul.f64 fd683, fd595, fd674;
mul.f64 fd684, fd596, fd675;
sub.f64 fd685, fd683, fd684;
mul.f64 fd686, fd595, fd675;
fma.rn.f64 fd687, fd596, fd674, fd686;
mul.f64 fd688, fd574, fd687;
fma.rn.f64 fd689, fd685, fd573, fd688;
mul.f64 fd690, fd573, fd687;
mul.f64 fd691, fd685, fd574;
sub.f64 fd692, fd691, fd690;
mul.f64 fd693, fd595, fd685;
mul.f64 fd694, fd596, fd687;
sub.f64 fd695, fd693, fd694;
mul.f64 fd696, fd595, fd687;
fma.rn.f64 fd697, fd596, fd685, fd696;
mul.f64 fd698, fd578, fd697;
fma.rn.f64 fd699, fd695, fd577, fd698;
mul.f64 fd700, fd577, fd697;
mul.f64 fd701, fd695, fd578;
sub.f64 fd702, fd701, fd700;
mul.f64 fd703, fd595, fd695;
mul.f64 fd704, fd596, fd697;
sub.f64 fd705, fd703, fd704;
mul.f64 fd706, fd595, fd697;
fma.rn.f64 fd707, fd596, fd695, fd706;
mul.f64 fd708, fd582, fd707;
fma.rn.f64 fd709, fd705, fd581, fd708;
mul.f64 fd710, fd581, fd707;
mul.f64 fd711, fd705, fd582;
sub.f64 fd712, fd711, fd710;
mul.f64 fd713, fd595, fd705;
mul.f64 fd714, fd596, fd707;
sub.f64 fd715, fd713, fd714;
mul.f64 fd716, fd595, fd707;
fma.rn.f64 fd717, fd596, fd705, fd716;
mul.f64 fd718, fd586, fd717;
fma.rn.f64 fd719, fd715, fd585, fd718;
mul.f64 fd720, fd585, fd717;
mul.f64 fd721, fd715, fd586;
sub.f64 fd722, fd721, fd720;
mul.f64 fd723, fd595, fd715;
mul.f64 fd724, fd596, fd717;
sub.f64 fd725, fd723, fd724;
mul.f64 fd726, fd595, fd717;
fma.rn.f64 fd727, fd596, fd715, fd726;
mul.f64 fd728, fd590, fd727;
fma.rn.f64 fd729, fd725, fd589, fd728;
mul.f64 fd730, fd589, fd727;
mul.f64 fd731, fd725, fd590;
sub.f64 fd732, fd731, fd730;
mul.f64 fd733, fd595, fd725;
mul.f64 fd734, fd596, fd727;
sub.f64 fd735, fd733, fd734;
mul.f64 fd736, fd595, fd727;
fma.rn.f64 fd737, fd596, fd725, fd736;
mul.f64 fd738, fd594, fd737;
fma.rn.f64 fd739, fd735, fd593, fd738;
mul.f64 fd740, fd593, fd737;
mul.f64 fd741, fd735, fd594;
sub.f64 fd742, fd741, fd740;
shl.b32 r15, r5, 3;
and.b32 r16, r15, 120;
add.s32 r17, r10, r16;
barrier.sync 0;
and.b32 r18, r8, 129024;
add.s32 r19, r17, r18;
st.shared.f64 [r19], fd563;
st.shared.f64 [r19+128], fd600;
st.shared.f64 [r19+256], fd610;
st.shared.f64 [r19+384], fd620;
st.shared.f64 [r19+512], fd630;
st.shared.f64 [r19+640], fd640;
st.shared.f64 [r19+768], fd650;
st.shared.f64 [r19+896], fd660;
st.shared.f64 [r19+1024], fd670;
st.shared.f64 [r19+1152], fd679;
st.shared.f64 [r19+1280], fd689;
st.shared.f64 [r19+1408], fd699;
st.shared.f64 [r19+1536], fd709;
st.shared.f64 [r19+1664], fd719;
st.shared.f64 [r19+1792], fd729;
st.shared.f64 [r19+1920], fd739;
barrier.sync 0;
mad.lo.s32 r20, r14, -120, r19;
ld.shared.f64 fd743, [r20];
ld.shared.f64 fd744, [r20+8192];
ld.shared.f64 fd745, [r20+16384];
ld.shared.f64 fd746, [r20+24576];
ld.shared.f64 fd747, [r20+32768];
ld.shared.f64 fd748, [r20+40960];
ld.shared.f64 fd749, [r20+49152];
ld.shared.f64 fd750, [r20+57344];
ld.shared.f64 fd751, [r20+65536];
ld.shared.f64 fd752, [r20+73728];
ld.shared.f64 fd753, [r20+81920];
ld.shared.f64 fd754, [r20+90112];
ld.shared.f64 fd755, [r20+98304];
ld.shared.f64 fd756, [r20+106496];
ld.shared.f64 fd757, [r20+114688];
ld.shared.f64 fd758, [r20+122880];
barrier.sync 0;
st.shared.f64 [r19], fd564;
st.shared.f64 [r19+128], fd603;
st.shared.f64 [r19+256], fd613;
st.shared.f64 [r19+384], fd623;
st.shared.f64 [r19+512], fd633;
st.shared.f64 [r19+640], fd643;
st.shared.f64 [r19+768], fd653;
st.shared.f64 [r19+896], fd663;
st.shared.f64 [r19+1024], fd673;
st.shared.f64 [r19+1152], fd682;
st.shared.f64 [r19+1280], fd692;
st.shared.f64 [r19+1408], fd702;
st.shared.f64 [r19+1536], fd712;
st.shared.f64 [r19+1664], fd722;
st.shared.f64 [r19+1792], fd732;
st.shared.f64 [r19+1920], fd742;
barrier.sync 0;
ld.shared.f64 fd759, [r20];
ld.shared.f64 fd760, [r20+8192];
ld.shared.f64 fd761, [r20+16384];
ld.shared.f64 fd762, [r20+24576];
ld.shared.f64 fd763, [r20+32768];
ld.shared.f64 fd764, [r20+40960];
ld.shared.f64 fd765, [r20+49152];
ld.shared.f64 fd766, [r20+57344];
ld.shared.f64 fd767, [r20+65536];
ld.shared.f64 fd768, [r20+73728];
ld.shared.f64 fd769, [r20+81920];
ld.shared.f64 fd770, [r20+90112];
ld.shared.f64 fd771, [r20+98304];
ld.shared.f64 fd772, [r20+106496];
ld.shared.f64 fd773, [r20+114688];
ld.shared.f64 fd774, [r20+122880];
add.f64 fd775, fd743, fd751;
add.f64 fd776, fd759, fd767;
sub.f64 fd777, fd743, fd751;
sub.f64 fd778, fd759, fd767;
add.f64 fd779, fd747, fd755;
add.f64 fd780, fd763, fd771;
sub.f64 fd781, fd747, fd755;
sub.f64 fd782, fd763, fd771;
add.f64 fd783, fd775, fd779;
add.f64 fd784, fd776, fd780;
sub.f64 fd785, fd775, fd779;
sub.f64 fd786, fd776, fd780;
sub.f64 fd787, fd777, fd782;
add.f64 fd788, fd778, fd781;
add.f64 fd789, fd777, fd782;
sub.f64 fd790, fd778, fd781;
add.f64 fd791, fd745, fd753;
add.f64 fd792, fd761, fd769;
sub.f64 fd793, fd745, fd753;
sub.f64 fd794, fd761, fd769;
add.f64 fd795, fd749, fd757;
add.f64 fd796, fd765, fd773;
sub.f64 fd797, fd749, fd757;
sub.f64 fd798, fd765, fd773;
add.f64 fd799, fd791, fd795;
add.f64 fd800, fd792, fd796;
sub.f64 fd801, fd791, fd795;
sub.f64 fd802, fd792, fd796;
sub.f64 fd803, fd793, fd798;
add.f64 fd804, fd794, fd797;
add.f64 fd805, fd793, fd798;
sub.f64 fd806, fd794, fd797;
mul.f64 fd807, fd803, 0d3FE6A09E667F3BCD;
mul.f64 fd808, fd804, 0d3FE6A09E667F3BCD;
sub.f64 fd809, fd807, fd808;
add.f64 fd810, fd807, fd808;
mul.f64 fd811, fd805, 0dBFE6A09E667F3BCD;
mul.f64 fd812, fd806, 0d3FE6A09E667F3BCD;
sub.f64 fd813, fd811, fd812;
mul.f64 fd814, fd806, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd815, fd805, 0d3FE6A09E667F3BCD, fd814;
add.f64 fd816, fd783, fd799;
add.f64 fd817, fd784, fd800;
sub.f64 fd818, fd783, fd799;
sub.f64 fd819, fd784, fd800;
add.f64 fd820, fd787, fd809;
add.f64 fd821, fd788, fd810;
sub.f64 fd822, fd787, fd809;
sub.f64 fd823, fd788, fd810;
sub.f64 fd824, fd785, fd802;
add.f64 fd825, fd786, fd801;
add.f64 fd826, fd785, fd802;
sub.f64 fd827, fd786, fd801;
add.f64 fd828, fd789, fd813;
add.f64 fd829, fd790, fd815;
sub.f64 fd830, fd789, fd813;
sub.f64 fd831, fd790, fd815;
add.f64 fd832, fd744, fd752;
add.f64 fd833, fd760, fd768;
sub.f64 fd834, fd744, fd752;
sub.f64 fd835, fd760, fd768;
add.f64 fd836, fd748, fd756;
add.f64 fd837, fd764, fd772;
sub.f64 fd838, fd748, fd756;
sub.f64 fd839, fd764, fd772;
add.f64 fd840, fd832, fd836;
add.f64 fd841, fd833, fd837;
sub.f64 fd842, fd832, fd836;
sub.f64 fd843, fd833, fd837;
sub.f64 fd844, fd834, fd839;
add.f64 fd845, fd835, fd838;
add.f64 fd846, fd834, fd839;
sub.f64 fd847, fd835, fd838;
add.f64 fd848, fd746, fd754;
add.f64 fd849, fd762, fd770;
sub.f64 fd850, fd746, fd754;
sub.f64 fd851, fd762, fd770;
add.f64 fd852, fd750, fd758;
add.f64 fd853, fd766, fd774;
sub.f64 fd854, fd750, fd758;
sub.f64 fd855, fd766, fd774;
add.f64 fd856, fd848, fd852;
add.f64 fd857, fd849, fd853;
sub.f64 fd858, fd848, fd852;
sub.f64 fd859, fd849, fd853;
sub.f64 fd860, fd850, fd855;
add.f64 fd861, fd851, fd854;
add.f64 fd862, fd850, fd855;
sub.f64 fd863, fd851, fd854;
mul.f64 fd864, fd860, 0d3FE6A09E667F3BCD;
mul.f64 fd865, fd861, 0d3FE6A09E667F3BCD;
sub.f64 fd866, fd864, fd865;
add.f64 fd867, fd864, fd865;
mul.f64 fd868, fd862, 0dBFE6A09E667F3BCD;
mul.f64 fd869, fd863, 0d3FE6A09E667F3BCD;
sub.f64 fd870, fd868, fd869;
mul.f64 fd871, fd863, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd872, fd862, 0d3FE6A09E667F3BCD, fd871;
add.f64 fd873, fd840, fd856;
add.f64 fd874, fd841, fd857;
sub.f64 fd875, fd840, fd856;
sub.f64 fd876, fd841, fd857;
add.f64 fd877, fd844, fd866;
add.f64 fd878, fd845, fd867;
sub.f64 fd879, fd844, fd866;
sub.f64 fd880, fd845, fd867;
sub.f64 fd881, fd842, fd859;
add.f64 fd882, fd843, fd858;
add.f64 fd883, fd842, fd859;
sub.f64 fd884, fd843, fd858;
add.f64 fd885, fd846, fd870;
add.f64 fd886, fd847, fd872;
sub.f64 fd887, fd846, fd870;
sub.f64 fd888, fd847, fd872;
mul.f64 fd889, fd877, 0d3FED906BCF328D46;
mul.f64 fd890, fd878, 0d3FD87DE2A6AEA963;
sub.f64 fd891, fd889, fd890;
mul.f64 fd892, fd878, 0d3FED906BCF328D46;
fma.rn.f64 fd893, fd877, 0d3FD87DE2A6AEA963, fd892;
mul.f64 fd894, fd881, 0d3FE6A09E667F3BCD;
mul.f64 fd895, fd882, 0d3FE6A09E667F3BCD;
sub.f64 fd896, fd894, fd895;
add.f64 fd897, fd894, fd895;
mul.f64 fd898, fd885, 0d3FD87DE2A6AEA963;
mul.f64 fd899, fd886, 0d3FED906BCF328D46;
sub.f64 fd900, fd898, fd899;
mul.f64 fd901, fd886, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd902, fd885, 0d3FED906BCF328D46, fd901;
mul.f64 fd903, fd879, 0dBFD87DE2A6AEA963;
mul.f64 fd904, fd880, 0d3FED906BCF328D46;
sub.f64 fd905, fd903, fd904;
mul.f64 fd906, fd880, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd907, fd879, 0d3FED906BCF328D46, fd906;
mul.f64 fd908, fd883, 0dBFE6A09E667F3BCD;
mul.f64 fd909, fd884, 0d3FE6A09E667F3BCD;
sub.f64 fd910, fd908, fd909;
mul.f64 fd911, fd884, 0dBFE6A09E667F3BCD;
fma.rn.f64 fd912, fd883, 0d3FE6A09E667F3BCD, fd911;
mul.f64 fd913, fd887, 0dBFED906BCF328D46;
mul.f64 fd914, fd888, 0d3FD87DE2A6AEA963;
sub.f64 fd915, fd913, fd914;
mul.f64 fd916, fd888, 0dBFED906BCF328D46;
fma.rn.f64 fd917, fd887, 0d3FD87DE2A6AEA963, fd916;
add.f64 fd918, fd816, fd873;
add.f64 fd919, fd817, fd874;
sub.f64 fd920, fd816, fd873;
sub.f64 fd921, fd817, fd874;
add.f64 fd922, fd820, fd891;
add.f64 fd923, fd821, fd893;
sub.f64 fd924, fd820, fd891;
sub.f64 fd925, fd821, fd893;
add.f64 fd926, fd824, fd896;
add.f64 fd927, fd825, fd897;
sub.f64 fd928, fd824, fd896;
sub.f64 fd929, fd825, fd897;
add.f64 fd930, fd828, fd900;
add.f64 fd931, fd829, fd902;
sub.f64 fd932, fd828, fd900;
sub.f64 fd933, fd829, fd902;
sub.f64 fd934, fd818, fd876;
add.f64 fd935, fd819, fd875;
add.f64 fd936, fd818, fd876;
sub.f64 fd937, fd819, fd875;
add.f64 fd938, fd822, fd905;
add.f64 fd939, fd823, fd907;
sub.f64 fd940, fd822, fd905;
sub.f64 fd941, fd823, fd907;
add.f64 fd942, fd826, fd910;
add.f64 fd943, fd827, fd912;
sub.f64 fd944, fd826, fd910;
sub.f64 fd945, fd827, fd912;
add.f64 fd946, fd830, fd915;
add.f64 fd947, fd831, fd917;
sub.f64 fd948, fd830, fd915;
sub.f64 fd949, fd831, fd917;
and.b32 r21, r5, 768;
bfe.u32 r22, r5, 8, 2;
mul.wide.u32 rd9, r22, 16;
mov.u64 rd10, %35;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd950, fd951}, [rd11];
mul.f64 fd954, fd923, fd951;
fma.rn.f64 fd955, fd950, fd922, fd954;
mul.f64 fd956, fd922, fd951;
mul.f64 fd957, fd950, fd923;
sub.f64 fd958, fd957, fd956;
mul.f64 fd959, fd950, fd950;
mul.f64 fd960, fd951, fd951;
sub.f64 fd961, fd959, fd960;
mul.f64 fd962, fd951, fd950;
fma.rn.f64 fd963, fd951, fd950, fd962;
mul.f64 fd964, fd927, fd963;
fma.rn.f64 fd965, fd961, fd926, fd964;
mul.f64 fd966, fd926, fd963;
mul.f64 fd967, fd961, fd927;
sub.f64 fd968, fd967, fd966;
mul.f64 fd969, fd950, fd961;
mul.f64 fd970, fd951, fd963;
sub.f64 fd971, fd969, fd970;
mul.f64 fd972, fd950, fd963;
fma.rn.f64 fd973, fd951, fd961, fd972;
mul.f64 fd974, fd931, fd973;
fma.rn.f64 fd975, fd971, fd930, fd974;
mul.f64 fd976, fd930, fd973;
mul.f64 fd977, fd971, fd931;
sub.f64 fd978, fd977, fd976;
mul.f64 fd979, fd950, fd971;
mul.f64 fd980, fd951, fd973;
sub.f64 fd981, fd979, fd980;
mul.f64 fd982, fd950, fd973;
fma.rn.f64 fd983, fd951, fd971, fd982;
mul.f64 fd984, fd935, fd983;
fma.rn.f64 fd985, fd981, fd934, fd984;
mul.f64 fd986, fd934, fd983;
mul.f64 fd987, fd981, fd935;
sub.f64 fd988, fd987, fd986;
mul.f64 fd989, fd950, fd981;
mul.f64 fd990, fd951, fd983;
sub.f64 fd991, fd989, fd990;
mul.f64 fd992, fd950, fd983;
fma.rn.f64 fd993, fd951, fd981, fd992;
mul.f64 fd994, fd939, fd993;
fma.rn.f64 fd995, fd991, fd938, fd994;
mul.f64 fd996, fd938, fd993;
mul.f64 fd997, fd991, fd939;
sub.f64 fd998, fd997, fd996;
mul.f64 fd999, fd950, fd991;
mul.f64 fd1000, fd951, fd993;
sub.f64 fd1001, fd999, fd1000;
mul.f64 fd1002, fd950, fd993;
fma.rn.f64 fd1003, fd951, fd991, fd1002;
mul.f64 fd1004, fd943, fd1003;
fma.rn.f64 fd1005, fd1001, fd942, fd1004;
mul.f64 fd1006, fd942, fd1003;
mul.f64 fd1007, fd1001, fd943;
sub.f64 fd1008, fd1007, fd1006;
mul.f64 fd1009, fd950, fd1001;
mul.f64 fd1010, fd951, fd1003;
sub.f64 fd1011, fd1009, fd1010;
mul.f64 fd1012, fd950, fd1003;
fma.rn.f64 fd1013, fd951, fd1001, fd1012;
mul.f64 fd1014, fd947, fd1013;
fma.rn.f64 fd1015, fd1011, fd946, fd1014;
mul.f64 fd1016, fd946, fd1013;
mul.f64 fd1017, fd1011, fd947;
sub.f64 fd1018, fd1017, fd1016;
mul.f64 fd1019, fd950, fd1011;
mul.f64 fd1020, fd951, fd1013;
sub.f64 fd1021, fd1019, fd1020;
mul.f64 fd1022, fd950, fd1013;
fma.rn.f64 fd1023, fd951, fd1011, fd1022;
mul.f64 fd1024, fd921, fd1023;
fma.rn.f64 fd1025, fd1021, fd920, fd1024;
mul.f64 fd1026, fd920, fd1023;
mul.f64 fd1027, fd1021, fd921;
sub.f64 fd1028, fd1027, fd1026;
ld.global.v2.f64 {fd1029, fd1030}, [rd11+64];
mul.f64 fd1033, fd925, fd1030;
fma.rn.f64 fd1034, fd1029, fd924, fd1033;
mul.f64 fd1035, fd924, fd1030;
mul.f64 fd1036, fd1029, fd925;
sub.f64 fd1037, fd1036, fd1035;
mul.f64 fd1038, fd950, fd1029;
mul.f64 fd1039, fd951, fd1030;
sub.f64 fd1040, fd1038, fd1039;
mul.f64 fd1041, fd950, fd1030;
fma.rn.f64 fd1042, fd951, fd1029, fd1041;
mul.f64 fd1043, fd929, fd1042;
fma.rn.f64 fd1044, fd1040, fd928, fd1043;
mul.f64 fd1045, fd928, fd1042;
mul.f64 fd1046, fd1040, fd929;
sub.f64 fd1047, fd1046, fd1045;
mul.f64 fd1048, fd950, fd1040;
mul.f64 fd1049, fd951, fd1042;
sub.f64 fd1050, fd1048, fd1049;
mul.f64 fd1051, fd950, fd1042;
fma.rn.f64 fd1052, fd951, fd1040, fd1051;
mul.f64 fd1053, fd933, fd1052;
fma.rn.f64 fd1054, fd1050, fd932, fd1053;
mul.f64 fd1055, fd932, fd1052;
mul.f64 fd1056, fd1050, fd933;
sub.f64 fd1057, fd1056, fd1055;
mul.f64 fd1058, fd950, fd1050;
mul.f64 fd1059, fd951, fd1052;
sub.f64 fd1060, fd1058, fd1059;
mul.f64 fd1061, fd950, fd1052;
fma.rn.f64 fd1062, fd951, fd1050, fd1061;
mul.f64 fd1063, fd937, fd1062;
fma.rn.f64 fd1064, fd1060, fd936, fd1063;
mul.f64 fd1065, fd936, fd1062;
mul.f64 fd1066, fd1060, fd937;
sub.f64 fd1067, fd1066, fd1065;
mul.f64 fd1068, fd950, fd1060;
mul.f64 fd1069, fd951, fd1062;
sub.f64 fd1070, fd1068, fd1069;
mul.f64 fd1071, fd950, fd1062;
fma.rn.f64 fd1072, fd951, fd1060, fd1071;
mul.f64 fd1073, fd941, fd1072;
fma.rn.f64 fd1074, fd1070, fd940, fd1073;
mul.f64 fd1075, fd940, fd1072;
mul.f64 fd1076, fd1070, fd941;
sub.f64 fd1077, fd1076, fd1075;
mul.f64 fd1078, fd950, fd1070;
mul.f64 fd1079, fd951, fd1072;
sub.f64 fd1080, fd1078, fd1079;
mul.f64 fd1081, fd950, fd1072;
fma.rn.f64 fd1082, fd951, fd1070, fd1081;
mul.f64 fd1083, fd945, fd1082;
fma.rn.f64 fd1084, fd1080, fd944, fd1083;
mul.f64 fd1085, fd944, fd1082;
mul.f64 fd1086, fd1080, fd945;
sub.f64 fd1087, fd1086, fd1085;
mul.f64 fd1088, fd950, fd1080;
mul.f64 fd1089, fd951, fd1082;
sub.f64 fd1090, fd1088, fd1089;
mul.f64 fd1091, fd950, fd1082;
fma.rn.f64 fd1092, fd951, fd1080, fd1091;
mul.f64 fd1093, fd949, fd1092;
fma.rn.f64 fd1094, fd1090, fd948, fd1093;
mul.f64 fd1095, fd948, fd1092;
mul.f64 fd1096, fd1090, fd949;
sub.f64 fd1097, fd1096, fd1095;
and.b32 r23, r15, 2040;
add.s32 r24, r10, r23;
barrier.sync 0;
and.b32 r25, r8, 98304;
add.s32 r26, r24, r25;
st.shared.f64 [r26], fd918;
st.shared.f64 [r26+2048], fd955;
st.shared.f64 [r26+4096], fd965;
st.shared.f64 [r26+6144], fd975;
st.shared.f64 [r26+8192], fd985;
st.shared.f64 [r26+10240], fd995;
st.shared.f64 [r26+12288], fd1005;
st.shared.f64 [r26+14336], fd1015;
st.shared.f64 [r26+16384], fd1025;
st.shared.f64 [r26+18432], fd1034;
st.shared.f64 [r26+20480], fd1044;
st.shared.f64 [r26+22528], fd1054;
st.shared.f64 [r26+24576], fd1064;
st.shared.f64 [r26+26624], fd1074;
st.shared.f64 [r26+28672], fd1084;
st.shared.f64 [r26+30720], fd1094;
barrier.sync 0;
mad.lo.s32 r27, r21, -120, r26;
ld.shared.f64 fd1098, [r27];
ld.shared.f64 fd1099, [r27+8192];
ld.shared.f64 fd1100, [r27+16384];
ld.shared.f64 fd1101, [r27+24576];
ld.shared.f64 fd1102, [r27+32768];
ld.shared.f64 fd1103, [r27+40960];
ld.shared.f64 fd1104, [r27+49152];
ld.shared.f64 fd1105, [r27+57344];
ld.shared.f64 fd1106, [r27+65536];
ld.shared.f64 fd1107, [r27+73728];
ld.shared.f64 fd1108, [r27+81920];
ld.shared.f64 fd1109, [r27+90112];
ld.shared.f64 fd1110, [r27+98304];
ld.shared.f64 fd1111, [r27+106496];
ld.shared.f64 fd1112, [r27+114688];
ld.shared.f64 fd1113, [r27+122880];
barrier.sync 0;
st.shared.f64 [r26], fd919;
st.shared.f64 [r26+2048], fd958;
st.shared.f64 [r26+4096], fd968;
st.shared.f64 [r26+6144], fd978;
st.shared.f64 [r26+8192], fd988;
st.shared.f64 [r26+10240], fd998;
st.shared.f64 [r26+12288], fd1008;
st.shared.f64 [r26+14336], fd1018;
st.shared.f64 [r26+16384], fd1028;
st.shared.f64 [r26+18432], fd1037;
st.shared.f64 [r26+20480], fd1047;
st.shared.f64 [r26+22528], fd1057;
st.shared.f64 [r26+24576], fd1067;
st.shared.f64 [r26+26624], fd1077;
st.shared.f64 [r26+28672], fd1087;
st.shared.f64 [r26+30720], fd1097;
barrier.sync 0;
ld.shared.f64 fd1114, [r27];
ld.shared.f64 fd1115, [r27+8192];
ld.shared.f64 fd1116, [r27+16384];
ld.shared.f64 fd1117, [r27+24576];
ld.shared.f64 fd1118, [r27+32768];
ld.shared.f64 fd1119, [r27+40960];
ld.shared.f64 fd1120, [r27+49152];
ld.shared.f64 fd1121, [r27+57344];
ld.shared.f64 fd1122, [r27+65536];
ld.shared.f64 fd1123, [r27+73728];
ld.shared.f64 fd1124, [r27+81920];
ld.shared.f64 fd1125, [r27+90112];
ld.shared.f64 fd1126, [r27+98304];
ld.shared.f64 fd1127, [r27+106496];
ld.shared.f64 fd1128, [r27+114688];
ld.shared.f64 fd1129, [r27+122880];
add.f64 fd1130, fd1098, fd1106;
add.f64 fd1131, fd1114, fd1122;
sub.f64 fd1132, fd1098, fd1106;
sub.f64 fd1133, fd1114, fd1122;
add.f64 fd1134, fd1102, fd1110;
add.f64 fd1135, fd1118, fd1126;
sub.f64 fd1136, fd1102, fd1110;
sub.f64 fd1137, fd1118, fd1126;
add.f64 fd1138, fd1099, fd1107;
add.f64 fd1139, fd1115, fd1123;
sub.f64 fd1140, fd1099, fd1107;
sub.f64 fd1141, fd1115, fd1123;
add.f64 fd1142, fd1103, fd1111;
add.f64 fd1143, fd1119, fd1127;
sub.f64 fd1144, fd1103, fd1111;
sub.f64 fd1145, fd1119, fd1127;
add.f64 fd1146, fd1100, fd1108;
add.f64 fd1147, fd1116, fd1124;
sub.f64 fd1148, fd1100, fd1108;
sub.f64 fd1149, fd1116, fd1124;
add.f64 fd1150, fd1104, fd1112;
add.f64 fd1151, fd1120, fd1128;
sub.f64 fd1152, fd1104, fd1112;
sub.f64 fd1153, fd1120, fd1128;
add.f64 fd1154, fd1101, fd1109;
add.f64 fd1155, fd1117, fd1125;
sub.f64 fd1156, fd1101, fd1109;
sub.f64 fd1157, fd1117, fd1125;
add.f64 fd1158, fd1105, fd1113;
add.f64 fd1159, fd1121, fd1129;
sub.f64 fd1160, fd1105, fd1113;
sub.f64 fd1161, fd1121, fd1129;
add.f64 %0, fd1130, fd1134;
add.f64 %1, fd1131, fd1135;
add.f64 %2, fd1138, fd1142;
add.f64 %3, fd1139, fd1143;
add.f64 %4, fd1146, fd1150;
add.f64 %5, fd1147, fd1151;
add.f64 %6, fd1154, fd1158;
add.f64 %7, fd1155, fd1159;
add.f64 %9, fd1133, fd1136;
sub.f64 %8, fd1132, fd1137;
add.f64 %11, fd1141, fd1144;
sub.f64 %10, fd1140, fd1145;
add.f64 %13, fd1149, fd1152;
sub.f64 %12, fd1148, fd1153;
add.f64 %15, fd1157, fd1160;
sub.f64 %14, fd1156, fd1161;
sub.f64 %16, fd1130, fd1134;
sub.f64 %17, fd1131, fd1135;
sub.f64 %18, fd1138, fd1142;
sub.f64 %19, fd1139, fd1143;
sub.f64 %20, fd1146, fd1150;
sub.f64 %21, fd1147, fd1151;
sub.f64 %22, fd1154, fd1158;
sub.f64 %23, fd1155, fd1159;
sub.f64 %25, fd1133, fd1136;
add.f64 %24, fd1132, fd1137;
sub.f64 %27, fd1141, fd1144;
add.f64 %26, fd1140, fd1145;
sub.f64 %29, fd1149, fd1152;
add.f64 %28, fd1148, fd1153;
sub.f64 %31, fd1157, fd1160;
add.f64 %30, fd1156, fd1161;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_16384), "l"(lut_dp_16_1024), "l"(lut_dp_16_64), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y));
};


#endif
