#ifndef CUFFTDX_FFT_1728_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_1728_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<744, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<17>;
.reg .f64 fd<769>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %24;
mad.lo.s32 r3, r1, 13824, r2;
mov.u32 r4, %tid.x;
add.f64 fd49, %37, %48;
add.f64 fd50, %27, fd49;
add.f64 fd51, %39, %50;
add.f64 fd52, %28, fd51;
mul.f64 fd53, fd49, 0d3FE0000000000000;
sub.f64 fd54, %27, fd53;
sub.f64 fd55, %39, %50;
mul.f64 fd56, fd55, 0dBFEBB67AE8584CAA;
add.f64 fd57, fd56, fd54;
sub.f64 fd58, fd54, fd56;
mul.f64 fd59, fd51, 0d3FE0000000000000;
sub.f64 fd60, %28, fd59;
sub.f64 fd61, %37, %48;
mul.f64 fd62, fd61, 0dBFEBB67AE8584CAA;
sub.f64 fd63, fd60, fd62;
add.f64 fd64, fd62, fd60;
add.f64 fd65, %43, %53;
add.f64 fd66, %32, fd65;
add.f64 fd67, %44, %55;
add.f64 fd68, %34, fd67;
mul.f64 fd69, fd65, 0d3FE0000000000000;
sub.f64 fd70, %32, fd69;
sub.f64 fd71, %44, %55;
mul.f64 fd72, fd71, 0dBFEBB67AE8584CAA;
add.f64 fd73, fd72, fd70;
sub.f64 fd74, fd70, fd72;
mul.f64 fd75, fd67, 0d3FE0000000000000;
sub.f64 fd76, %34, fd75;
sub.f64 fd77, %43, %53;
mul.f64 fd78, fd77, 0dBFEBB67AE8584CAA;
sub.f64 fd79, fd76, fd78;
add.f64 fd80, fd78, fd76;
mul.f64 fd81, fd73, 0d3FE0000000000000;
mul.f64 fd82, fd79, 0d3FEBB67AE8584CAA;
sub.f64 fd83, fd81, fd82;
mul.f64 fd84, fd79, 0d3FE0000000000000;
fma.rn.f64 fd85, fd73, 0d3FEBB67AE8584CAA, fd84;
mul.f64 fd86, fd74, 0dBFE0000000000000;
mul.f64 fd87, fd80, 0d3FEBB67AE8584CAA;
sub.f64 fd88, fd86, fd87;
mul.f64 fd89, fd80, 0dBFE0000000000000;
fma.rn.f64 fd90, fd74, 0d3FEBB67AE8584CAA, fd89;
add.f64 fd91, fd50, fd66;
add.f64 fd92, fd52, fd68;
sub.f64 fd93, fd50, fd66;
sub.f64 fd94, fd52, fd68;
add.f64 fd95, fd57, fd83;
add.f64 fd96, fd63, fd85;
sub.f64 fd97, fd57, fd83;
sub.f64 fd98, fd63, fd85;
add.f64 fd99, fd58, fd88;
add.f64 fd100, fd64, fd90;
sub.f64 fd101, fd58, fd88;
sub.f64 fd102, fd64, fd90;
add.f64 fd103, %40, %51;
add.f64 fd104, %29, fd103;
add.f64 fd105, %42, %52;
add.f64 fd106, %31, fd105;
mul.f64 fd107, fd103, 0d3FE0000000000000;
sub.f64 fd108, %29, fd107;
sub.f64 fd109, %42, %52;
mul.f64 fd110, fd109, 0dBFEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd105, 0d3FE0000000000000;
sub.f64 fd114, %31, fd113;
sub.f64 fd115, %40, %51;
mul.f64 fd116, fd115, 0dBFEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
add.f64 fd119, %45, %56;
add.f64 fd120, %35, fd119;
add.f64 fd121, %47, %57;
add.f64 fd122, %36, fd121;
mul.f64 fd123, fd119, 0d3FE0000000000000;
sub.f64 fd124, %35, fd123;
sub.f64 fd125, %47, %57;
mul.f64 fd126, fd125, 0dBFEBB67AE8584CAA;
add.f64 fd127, fd126, fd124;
sub.f64 fd128, fd124, fd126;
mul.f64 fd129, fd121, 0d3FE0000000000000;
sub.f64 fd130, %36, fd129;
sub.f64 fd131, %45, %56;
mul.f64 fd132, fd131, 0dBFEBB67AE8584CAA;
sub.f64 fd133, fd130, fd132;
add.f64 fd134, fd132, fd130;
mul.f64 fd135, fd127, 0d3FE0000000000000;
mul.f64 fd136, fd133, 0d3FEBB67AE8584CAA;
sub.f64 fd137, fd135, fd136;
mul.f64 fd138, fd133, 0d3FE0000000000000;
fma.rn.f64 fd139, fd127, 0d3FEBB67AE8584CAA, fd138;
mul.f64 fd140, fd128, 0dBFE0000000000000;
mul.f64 fd141, fd134, 0d3FEBB67AE8584CAA;
sub.f64 fd142, fd140, fd141;
mul.f64 fd143, fd134, 0dBFE0000000000000;
fma.rn.f64 fd144, fd128, 0d3FEBB67AE8584CAA, fd143;
add.f64 fd145, fd104, fd120;
add.f64 fd146, fd106, fd122;
sub.f64 fd147, fd104, fd120;
sub.f64 fd148, fd106, fd122;
add.f64 fd149, fd111, fd137;
add.f64 fd150, fd117, fd139;
sub.f64 fd151, fd111, fd137;
sub.f64 fd152, fd117, fd139;
add.f64 fd153, fd112, fd142;
add.f64 fd154, fd118, fd144;
sub.f64 fd155, fd112, fd142;
sub.f64 fd156, fd118, fd144;
mul.f64 fd157, fd149, 0d3FEBB67AE8584CAA;
mul.f64 fd158, fd150, 0d3FE0000000000000;
sub.f64 fd159, fd157, fd158;
mul.f64 fd160, fd150, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd161, fd149, 0d3FE0000000000000, fd160;
mul.f64 fd162, fd153, 0d3FE0000000000000;
mul.f64 fd163, fd154, 0d3FEBB67AE8584CAA;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, 0d3FE0000000000000;
fma.rn.f64 fd166, fd153, 0d3FEBB67AE8584CAA, fd165;
mul.f64 fd167, fd151, 0dBFE0000000000000;
mul.f64 fd168, fd152, 0d3FEBB67AE8584CAA;
sub.f64 fd169, fd167, fd168;
mul.f64 fd170, fd152, 0dBFE0000000000000;
fma.rn.f64 fd171, fd151, 0d3FEBB67AE8584CAA, fd170;
mul.f64 fd172, fd155, 0dBFEBB67AE8584CAA;
mul.f64 fd173, fd156, 0d3FE0000000000000;
sub.f64 fd174, fd172, fd173;
mul.f64 fd175, fd156, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd176, fd155, 0d3FE0000000000000, fd175;
add.f64 fd177, fd91, fd145;
add.f64 fd178, fd92, fd146;
sub.f64 fd179, fd91, fd145;
sub.f64 fd180, fd92, fd146;
add.f64 fd181, fd95, fd159;
add.f64 fd182, fd96, fd161;
sub.f64 fd183, fd95, fd159;
sub.f64 fd184, fd96, fd161;
add.f64 fd185, fd99, fd164;
add.f64 fd186, fd100, fd166;
sub.f64 fd187, fd99, fd164;
sub.f64 fd188, fd100, fd166;
sub.f64 fd189, fd93, fd148;
add.f64 fd190, fd94, fd147;
add.f64 fd191, fd93, fd148;
sub.f64 fd192, fd94, fd147;
add.f64 fd193, fd97, fd169;
add.f64 fd194, fd98, fd171;
sub.f64 fd195, fd97, fd169;
sub.f64 fd196, fd98, fd171;
add.f64 fd197, fd101, fd174;
add.f64 fd198, fd102, fd176;
sub.f64 fd199, fd101, fd174;
sub.f64 fd200, fd102, fd176;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 37;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 144;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %25;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd201, fd202}, [rd6];
mul.f64 fd205, fd182, fd202;
fma.rn.f64 fd206, fd201, fd181, fd205;
mul.f64 fd207, fd181, fd202;
mul.f64 fd208, fd201, fd182;
sub.f64 fd209, fd208, fd207;
mul.f64 fd210, fd201, fd201;
mul.f64 fd211, fd202, fd202;
sub.f64 fd212, fd210, fd211;
mul.f64 fd213, fd202, fd201;
fma.rn.f64 fd214, fd202, fd201, fd213;
mul.f64 fd215, fd186, fd214;
fma.rn.f64 fd216, fd212, fd185, fd215;
mul.f64 fd217, fd185, fd214;
mul.f64 fd218, fd212, fd186;
sub.f64 fd219, fd218, fd217;
mul.f64 fd220, fd201, fd212;
mul.f64 fd221, fd202, fd214;
sub.f64 fd222, fd220, fd221;
mul.f64 fd223, fd201, fd214;
fma.rn.f64 fd224, fd202, fd212, fd223;
mul.f64 fd225, fd190, fd224;
fma.rn.f64 fd226, fd222, fd189, fd225;
mul.f64 fd227, fd189, fd224;
mul.f64 fd228, fd222, fd190;
sub.f64 fd229, fd228, fd227;
mul.f64 fd230, fd201, fd222;
mul.f64 fd231, fd202, fd224;
sub.f64 fd232, fd230, fd231;
mul.f64 fd233, fd201, fd224;
fma.rn.f64 fd234, fd202, fd222, fd233;
mul.f64 fd235, fd194, fd234;
fma.rn.f64 fd236, fd232, fd193, fd235;
mul.f64 fd237, fd193, fd234;
mul.f64 fd238, fd232, fd194;
sub.f64 fd239, fd238, fd237;
mul.f64 fd240, fd201, fd232;
mul.f64 fd241, fd202, fd234;
sub.f64 fd242, fd240, fd241;
mul.f64 fd243, fd201, fd234;
fma.rn.f64 fd244, fd202, fd232, fd243;
mul.f64 fd245, fd198, fd244;
fma.rn.f64 fd246, fd242, fd197, fd245;
mul.f64 fd247, fd197, fd244;
mul.f64 fd248, fd242, fd198;
sub.f64 fd249, fd248, fd247;
mul.f64 fd250, fd201, fd242;
mul.f64 fd251, fd202, fd244;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd201, fd244;
fma.rn.f64 fd254, fd202, fd242, fd253;
mul.f64 fd255, fd180, fd254;
fma.rn.f64 fd256, fd252, fd179, fd255;
mul.f64 fd257, fd179, fd254;
mul.f64 fd258, fd252, fd180;
sub.f64 fd259, fd258, fd257;
ld.global.v2.f64 {fd260, fd261}, [rd6+2304];
mul.f64 fd264, fd184, fd261;
fma.rn.f64 fd265, fd260, fd183, fd264;
mul.f64 fd266, fd183, fd261;
mul.f64 fd267, fd260, fd184;
sub.f64 fd268, fd267, fd266;
mul.f64 fd269, fd201, fd260;
mul.f64 fd270, fd202, fd261;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd201, fd261;
fma.rn.f64 fd273, fd202, fd260, fd272;
mul.f64 fd274, fd188, fd273;
fma.rn.f64 fd275, fd271, fd187, fd274;
mul.f64 fd276, fd187, fd273;
mul.f64 fd277, fd271, fd188;
sub.f64 fd278, fd277, fd276;
mul.f64 fd279, fd201, fd271;
mul.f64 fd280, fd202, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd201, fd273;
fma.rn.f64 fd283, fd202, fd271, fd282;
mul.f64 fd284, fd192, fd283;
fma.rn.f64 fd285, fd281, fd191, fd284;
mul.f64 fd286, fd191, fd283;
mul.f64 fd287, fd281, fd192;
sub.f64 fd288, fd287, fd286;
mul.f64 fd289, fd201, fd281;
mul.f64 fd290, fd202, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd201, fd283;
fma.rn.f64 fd293, fd202, fd281, fd292;
mul.f64 fd294, fd196, fd293;
fma.rn.f64 fd295, fd291, fd195, fd294;
mul.f64 fd296, fd195, fd293;
mul.f64 fd297, fd291, fd196;
sub.f64 fd298, fd297, fd296;
mul.f64 fd299, fd201, fd291;
mul.f64 fd300, fd202, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd201, fd293;
fma.rn.f64 fd303, fd202, fd291, fd302;
mul.f64 fd304, fd200, fd303;
fma.rn.f64 fd305, fd301, fd199, fd304;
mul.f64 fd306, fd199, fd303;
mul.f64 fd307, fd301, fd200;
sub.f64 fd308, fd307, fd306;
mad.lo.s32 r8, r5, 13824, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 96, r8;
st.shared.v2.f64 [r9], {fd177, fd206};
st.shared.v2.f64 [r9+16], {fd216, fd226};
st.shared.v2.f64 [r9+32], {fd236, fd246};
st.shared.v2.f64 [r9+48], {fd256, fd265};
st.shared.v2.f64 [r9+64], {fd275, fd285};
st.shared.v2.f64 [r9+80], {fd295, fd305};
barrier.sync 0;
mad.lo.s32 r10, r7, -88, r9;
ld.shared.f64 fd309, [r10];
ld.shared.f64 fd310, [r10+1152];
ld.shared.f64 fd311, [r10+2304];
ld.shared.f64 fd312, [r10+3456];
ld.shared.f64 fd313, [r10+4608];
ld.shared.f64 fd314, [r10+5760];
ld.shared.f64 fd315, [r10+6912];
ld.shared.f64 fd316, [r10+8064];
ld.shared.f64 fd317, [r10+9216];
ld.shared.f64 fd318, [r10+10368];
ld.shared.f64 fd319, [r10+11520];
ld.shared.f64 fd320, [r10+12672];
barrier.sync 0;
st.shared.v2.f64 [r9], {fd178, fd209};
st.shared.v2.f64 [r9+16], {fd219, fd229};
st.shared.v2.f64 [r9+32], {fd239, fd249};
st.shared.v2.f64 [r9+48], {fd259, fd268};
st.shared.v2.f64 [r9+64], {fd278, fd288};
st.shared.v2.f64 [r9+80], {fd298, fd308};
barrier.sync 0;
ld.shared.f64 fd321, [r10];
ld.shared.f64 fd322, [r10+1152];
ld.shared.f64 fd323, [r10+2304];
ld.shared.f64 fd324, [r10+3456];
ld.shared.f64 fd325, [r10+4608];
ld.shared.f64 fd326, [r10+5760];
ld.shared.f64 fd327, [r10+6912];
ld.shared.f64 fd328, [r10+8064];
ld.shared.f64 fd329, [r10+9216];
ld.shared.f64 fd330, [r10+10368];
ld.shared.f64 fd331, [r10+11520];
ld.shared.f64 fd332, [r10+12672];
add.f64 fd333, fd313, fd317;
add.f64 fd334, fd309, fd333;
add.f64 fd335, fd325, fd329;
add.f64 fd336, fd321, fd335;
mul.f64 fd337, fd333, 0d3FE0000000000000;
sub.f64 fd338, fd309, fd337;
sub.f64 fd339, fd325, fd329;
mul.f64 fd340, fd339, 0dBFEBB67AE8584CAA;
add.f64 fd341, fd340, fd338;
sub.f64 fd342, fd338, fd340;
mul.f64 fd343, fd335, 0d3FE0000000000000;
sub.f64 fd344, fd321, fd343;
sub.f64 fd345, fd313, fd317;
mul.f64 fd346, fd345, 0dBFEBB67AE8584CAA;
sub.f64 fd347, fd344, fd346;
add.f64 fd348, fd346, fd344;
add.f64 fd349, fd315, fd319;
add.f64 fd350, fd311, fd349;
add.f64 fd351, fd327, fd331;
add.f64 fd352, fd323, fd351;
mul.f64 fd353, fd349, 0d3FE0000000000000;
sub.f64 fd354, fd311, fd353;
sub.f64 fd355, fd327, fd331;
mul.f64 fd356, fd355, 0dBFEBB67AE8584CAA;
add.f64 fd357, fd356, fd354;
sub.f64 fd358, fd354, fd356;
mul.f64 fd359, fd351, 0d3FE0000000000000;
sub.f64 fd360, fd323, fd359;
sub.f64 fd361, fd315, fd319;
mul.f64 fd362, fd361, 0dBFEBB67AE8584CAA;
sub.f64 fd363, fd360, fd362;
add.f64 fd364, fd362, fd360;
mul.f64 fd365, fd357, 0d3FE0000000000000;
mul.f64 fd366, fd363, 0d3FEBB67AE8584CAA;
sub.f64 fd367, fd365, fd366;
mul.f64 fd368, fd363, 0d3FE0000000000000;
fma.rn.f64 fd369, fd357, 0d3FEBB67AE8584CAA, fd368;
mul.f64 fd370, fd358, 0dBFE0000000000000;
mul.f64 fd371, fd364, 0d3FEBB67AE8584CAA;
sub.f64 fd372, fd370, fd371;
mul.f64 fd373, fd364, 0dBFE0000000000000;
fma.rn.f64 fd374, fd358, 0d3FEBB67AE8584CAA, fd373;
add.f64 fd375, fd334, fd350;
add.f64 fd376, fd336, fd352;
sub.f64 fd377, fd334, fd350;
sub.f64 fd378, fd336, fd352;
add.f64 fd379, fd341, fd367;
add.f64 fd380, fd347, fd369;
sub.f64 fd381, fd341, fd367;
sub.f64 fd382, fd347, fd369;
add.f64 fd383, fd342, fd372;
add.f64 fd384, fd348, fd374;
sub.f64 fd385, fd342, fd372;
sub.f64 fd386, fd348, fd374;
add.f64 fd387, fd314, fd318;
add.f64 fd388, fd310, fd387;
add.f64 fd389, fd326, fd330;
add.f64 fd390, fd322, fd389;
mul.f64 fd391, fd387, 0d3FE0000000000000;
sub.f64 fd392, fd310, fd391;
sub.f64 fd393, fd326, fd330;
mul.f64 fd394, fd393, 0dBFEBB67AE8584CAA;
add.f64 fd395, fd394, fd392;
sub.f64 fd396, fd392, fd394;
mul.f64 fd397, fd389, 0d3FE0000000000000;
sub.f64 fd398, fd322, fd397;
sub.f64 fd399, fd314, fd318;
mul.f64 fd400, fd399, 0dBFEBB67AE8584CAA;
sub.f64 fd401, fd398, fd400;
add.f64 fd402, fd400, fd398;
add.f64 fd403, fd316, fd320;
add.f64 fd404, fd312, fd403;
add.f64 fd405, fd328, fd332;
add.f64 fd406, fd324, fd405;
mul.f64 fd407, fd403, 0d3FE0000000000000;
sub.f64 fd408, fd312, fd407;
sub.f64 fd409, fd328, fd332;
mul.f64 fd410, fd409, 0dBFEBB67AE8584CAA;
add.f64 fd411, fd410, fd408;
sub.f64 fd412, fd408, fd410;
mul.f64 fd413, fd405, 0d3FE0000000000000;
sub.f64 fd414, fd324, fd413;
sub.f64 fd415, fd316, fd320;
mul.f64 fd416, fd415, 0dBFEBB67AE8584CAA;
sub.f64 fd417, fd414, fd416;
add.f64 fd418, fd416, fd414;
mul.f64 fd419, fd411, 0d3FE0000000000000;
mul.f64 fd420, fd417, 0d3FEBB67AE8584CAA;
sub.f64 fd421, fd419, fd420;
mul.f64 fd422, fd417, 0d3FE0000000000000;
fma.rn.f64 fd423, fd411, 0d3FEBB67AE8584CAA, fd422;
mul.f64 fd424, fd412, 0dBFE0000000000000;
mul.f64 fd425, fd418, 0d3FEBB67AE8584CAA;
sub.f64 fd426, fd424, fd425;
mul.f64 fd427, fd418, 0dBFE0000000000000;
fma.rn.f64 fd428, fd412, 0d3FEBB67AE8584CAA, fd427;
add.f64 fd429, fd388, fd404;
add.f64 fd430, fd390, fd406;
sub.f64 fd431, fd388, fd404;
sub.f64 fd432, fd390, fd406;
add.f64 fd433, fd395, fd421;
add.f64 fd434, fd401, fd423;
sub.f64 fd435, fd395, fd421;
sub.f64 fd436, fd401, fd423;
add.f64 fd437, fd396, fd426;
add.f64 fd438, fd402, fd428;
sub.f64 fd439, fd396, fd426;
sub.f64 fd440, fd402, fd428;
mul.f64 fd441, fd433, 0d3FEBB67AE8584CAA;
mul.f64 fd442, fd434, 0d3FE0000000000000;
sub.f64 fd443, fd441, fd442;
mul.f64 fd444, fd434, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd445, fd433, 0d3FE0000000000000, fd444;
mul.f64 fd446, fd437, 0d3FE0000000000000;
mul.f64 fd447, fd438, 0d3FEBB67AE8584CAA;
sub.f64 fd448, fd446, fd447;
mul.f64 fd449, fd438, 0d3FE0000000000000;
fma.rn.f64 fd450, fd437, 0d3FEBB67AE8584CAA, fd449;
mul.f64 fd451, fd435, 0dBFE0000000000000;
mul.f64 fd452, fd436, 0d3FEBB67AE8584CAA;
sub.f64 fd453, fd451, fd452;
mul.f64 fd454, fd436, 0dBFE0000000000000;
fma.rn.f64 fd455, fd435, 0d3FEBB67AE8584CAA, fd454;
mul.f64 fd456, fd439, 0dBFEBB67AE8584CAA;
mul.f64 fd457, fd440, 0d3FE0000000000000;
sub.f64 fd458, fd456, fd457;
mul.f64 fd459, fd440, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd460, fd439, 0d3FE0000000000000, fd459;
add.f64 fd461, fd375, fd429;
add.f64 fd462, fd376, fd430;
sub.f64 fd463, fd375, fd429;
sub.f64 fd464, fd376, fd430;
add.f64 fd465, fd379, fd443;
add.f64 fd466, fd380, fd445;
sub.f64 fd467, fd379, fd443;
sub.f64 fd468, fd380, fd445;
add.f64 fd469, fd383, fd448;
add.f64 fd470, fd384, fd450;
sub.f64 fd471, fd383, fd448;
sub.f64 fd472, fd384, fd450;
sub.f64 fd473, fd377, fd432;
add.f64 fd474, fd378, fd431;
add.f64 fd475, fd377, fd432;
sub.f64 fd476, fd378, fd431;
add.f64 fd477, fd381, fd453;
add.f64 fd478, fd382, fd455;
sub.f64 fd479, fd381, fd453;
sub.f64 fd480, fd382, fd455;
add.f64 fd481, fd385, fd458;
add.f64 fd482, fd386, fd460;
sub.f64 fd483, fd385, fd458;
sub.f64 fd484, fd386, fd460;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 12;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 16;
mov.u64 rd10, %26;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd485, fd486}, [rd11];
mul.f64 fd489, fd466, fd486;
fma.rn.f64 fd490, fd485, fd465, fd489;
mul.f64 fd491, fd465, fd486;
mul.f64 fd492, fd485, fd466;
sub.f64 fd493, fd492, fd491;
mul.f64 fd494, fd485, fd485;
mul.f64 fd495, fd486, fd486;
sub.f64 fd496, fd494, fd495;
mul.f64 fd497, fd486, fd485;
fma.rn.f64 fd498, fd486, fd485, fd497;
mul.f64 fd499, fd470, fd498;
fma.rn.f64 fd500, fd496, fd469, fd499;
mul.f64 fd501, fd469, fd498;
mul.f64 fd502, fd496, fd470;
sub.f64 fd503, fd502, fd501;
mul.f64 fd504, fd485, fd496;
mul.f64 fd505, fd486, fd498;
sub.f64 fd506, fd504, fd505;
mul.f64 fd507, fd485, fd498;
fma.rn.f64 fd508, fd486, fd496, fd507;
mul.f64 fd509, fd474, fd508;
fma.rn.f64 fd510, fd506, fd473, fd509;
mul.f64 fd511, fd473, fd508;
mul.f64 fd512, fd506, fd474;
sub.f64 fd513, fd512, fd511;
mul.f64 fd514, fd485, fd506;
mul.f64 fd515, fd486, fd508;
sub.f64 fd516, fd514, fd515;
mul.f64 fd517, fd485, fd508;
fma.rn.f64 fd518, fd486, fd506, fd517;
mul.f64 fd519, fd478, fd518;
fma.rn.f64 fd520, fd516, fd477, fd519;
mul.f64 fd521, fd477, fd518;
mul.f64 fd522, fd516, fd478;
sub.f64 fd523, fd522, fd521;
mul.f64 fd524, fd485, fd516;
mul.f64 fd525, fd486, fd518;
sub.f64 fd526, fd524, fd525;
mul.f64 fd527, fd485, fd518;
fma.rn.f64 fd528, fd486, fd516, fd527;
mul.f64 fd529, fd482, fd528;
fma.rn.f64 fd530, fd526, fd481, fd529;
mul.f64 fd531, fd481, fd528;
mul.f64 fd532, fd526, fd482;
sub.f64 fd533, fd532, fd531;
mul.f64 fd534, fd485, fd526;
mul.f64 fd535, fd486, fd528;
sub.f64 fd536, fd534, fd535;
mul.f64 fd537, fd485, fd528;
fma.rn.f64 fd538, fd486, fd526, fd537;
mul.f64 fd539, fd464, fd538;
fma.rn.f64 fd540, fd536, fd463, fd539;
mul.f64 fd541, fd463, fd538;
mul.f64 fd542, fd536, fd464;
sub.f64 fd543, fd542, fd541;
ld.global.v2.f64 {fd544, fd545}, [rd11+192];
mul.f64 fd548, fd468, fd545;
fma.rn.f64 fd549, fd544, fd467, fd548;
mul.f64 fd550, fd467, fd545;
mul.f64 fd551, fd544, fd468;
sub.f64 fd552, fd551, fd550;
mul.f64 fd553, fd485, fd544;
mul.f64 fd554, fd486, fd545;
sub.f64 fd555, fd553, fd554;
mul.f64 fd556, fd485, fd545;
fma.rn.f64 fd557, fd486, fd544, fd556;
mul.f64 fd558, fd472, fd557;
fma.rn.f64 fd559, fd555, fd471, fd558;
mul.f64 fd560, fd471, fd557;
mul.f64 fd561, fd555, fd472;
sub.f64 fd562, fd561, fd560;
mul.f64 fd563, fd485, fd555;
mul.f64 fd564, fd486, fd557;
sub.f64 fd565, fd563, fd564;
mul.f64 fd566, fd485, fd557;
fma.rn.f64 fd567, fd486, fd555, fd566;
mul.f64 fd568, fd476, fd567;
fma.rn.f64 fd569, fd565, fd475, fd568;
mul.f64 fd570, fd475, fd567;
mul.f64 fd571, fd565, fd476;
sub.f64 fd572, fd571, fd570;
mul.f64 fd573, fd485, fd565;
mul.f64 fd574, fd486, fd567;
sub.f64 fd575, fd573, fd574;
mul.f64 fd576, fd485, fd567;
fma.rn.f64 fd577, fd486, fd565, fd576;
mul.f64 fd578, fd480, fd577;
fma.rn.f64 fd579, fd575, fd479, fd578;
mul.f64 fd580, fd479, fd577;
mul.f64 fd581, fd575, fd480;
sub.f64 fd582, fd581, fd580;
mul.f64 fd583, fd485, fd575;
mul.f64 fd584, fd486, fd577;
sub.f64 fd585, fd583, fd584;
mul.f64 fd586, fd485, fd577;
fma.rn.f64 fd587, fd486, fd575, fd586;
mul.f64 fd588, fd484, fd587;
fma.rn.f64 fd589, fd585, fd483, fd588;
mul.f64 fd590, fd483, fd587;
mul.f64 fd591, fd585, fd484;
sub.f64 fd592, fd591, fd590;
shl.b32 r14, r13, 3;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 1152, r15;
st.shared.f64 [r16], fd461;
st.shared.f64 [r16+96], fd490;
st.shared.f64 [r16+192], fd500;
st.shared.f64 [r16+288], fd510;
st.shared.f64 [r16+384], fd520;
st.shared.f64 [r16+480], fd530;
st.shared.f64 [r16+576], fd540;
st.shared.f64 [r16+672], fd549;
st.shared.f64 [r16+768], fd559;
st.shared.f64 [r16+864], fd569;
st.shared.f64 [r16+960], fd579;
st.shared.f64 [r16+1056], fd589;
barrier.sync 0;
ld.shared.f64 fd593, [r10];
ld.shared.f64 fd594, [r10+1152];
ld.shared.f64 fd595, [r10+2304];
ld.shared.f64 fd596, [r10+3456];
ld.shared.f64 fd597, [r10+4608];
ld.shared.f64 fd598, [r10+5760];
ld.shared.f64 fd599, [r10+6912];
ld.shared.f64 fd600, [r10+8064];
ld.shared.f64 fd601, [r10+9216];
ld.shared.f64 fd602, [r10+10368];
ld.shared.f64 fd603, [r10+11520];
ld.shared.f64 fd604, [r10+12672];
barrier.sync 0;
st.shared.f64 [r16], fd462;
st.shared.f64 [r16+96], fd493;
st.shared.f64 [r16+192], fd503;
st.shared.f64 [r16+288], fd513;
st.shared.f64 [r16+384], fd523;
st.shared.f64 [r16+480], fd533;
st.shared.f64 [r16+576], fd543;
st.shared.f64 [r16+672], fd552;
st.shared.f64 [r16+768], fd562;
st.shared.f64 [r16+864], fd572;
st.shared.f64 [r16+960], fd582;
st.shared.f64 [r16+1056], fd592;
barrier.sync 0;
ld.shared.f64 fd605, [r10];
ld.shared.f64 fd606, [r10+1152];
ld.shared.f64 fd607, [r10+2304];
ld.shared.f64 fd608, [r10+3456];
ld.shared.f64 fd609, [r10+4608];
ld.shared.f64 fd610, [r10+5760];
ld.shared.f64 fd611, [r10+6912];
ld.shared.f64 fd612, [r10+8064];
ld.shared.f64 fd613, [r10+9216];
ld.shared.f64 fd614, [r10+10368];
ld.shared.f64 fd615, [r10+11520];
ld.shared.f64 fd616, [r10+12672];
add.f64 fd617, fd597, fd601;
add.f64 fd618, fd593, fd617;
add.f64 fd619, fd609, fd613;
add.f64 fd620, fd605, fd619;
mul.f64 fd621, fd617, 0d3FE0000000000000;
sub.f64 fd622, fd593, fd621;
sub.f64 fd623, fd609, fd613;
mul.f64 fd624, fd623, 0dBFEBB67AE8584CAA;
add.f64 fd625, fd624, fd622;
sub.f64 fd626, fd622, fd624;
mul.f64 fd627, fd619, 0d3FE0000000000000;
sub.f64 fd628, fd605, fd627;
sub.f64 fd629, fd597, fd601;
mul.f64 fd630, fd629, 0dBFEBB67AE8584CAA;
sub.f64 fd631, fd628, fd630;
add.f64 fd632, fd630, fd628;
add.f64 fd633, fd599, fd603;
add.f64 fd634, fd595, fd633;
add.f64 fd635, fd611, fd615;
add.f64 fd636, fd607, fd635;
mul.f64 fd637, fd633, 0d3FE0000000000000;
sub.f64 fd638, fd595, fd637;
sub.f64 fd639, fd611, fd615;
mul.f64 fd640, fd639, 0dBFEBB67AE8584CAA;
add.f64 fd641, fd640, fd638;
sub.f64 fd642, fd638, fd640;
mul.f64 fd643, fd635, 0d3FE0000000000000;
sub.f64 fd644, fd607, fd643;
sub.f64 fd645, fd599, fd603;
mul.f64 fd646, fd645, 0dBFEBB67AE8584CAA;
sub.f64 fd647, fd644, fd646;
add.f64 fd648, fd646, fd644;
mul.f64 fd649, fd641, 0d3FE0000000000000;
mul.f64 fd650, fd647, 0d3FEBB67AE8584CAA;
sub.f64 fd651, fd649, fd650;
mul.f64 fd652, fd647, 0d3FE0000000000000;
fma.rn.f64 fd653, fd641, 0d3FEBB67AE8584CAA, fd652;
mul.f64 fd654, fd642, 0dBFE0000000000000;
mul.f64 fd655, fd648, 0d3FEBB67AE8584CAA;
sub.f64 fd656, fd654, fd655;
mul.f64 fd657, fd648, 0dBFE0000000000000;
fma.rn.f64 fd658, fd642, 0d3FEBB67AE8584CAA, fd657;
add.f64 fd659, fd618, fd634;
add.f64 fd660, fd620, fd636;
sub.f64 fd661, fd618, fd634;
sub.f64 fd662, fd620, fd636;
add.f64 fd663, fd625, fd651;
add.f64 fd664, fd631, fd653;
sub.f64 fd665, fd625, fd651;
sub.f64 fd666, fd631, fd653;
add.f64 fd667, fd626, fd656;
add.f64 fd668, fd632, fd658;
sub.f64 fd669, fd626, fd656;
sub.f64 fd670, fd632, fd658;
add.f64 fd671, fd598, fd602;
add.f64 fd672, fd594, fd671;
add.f64 fd673, fd610, fd614;
add.f64 fd674, fd606, fd673;
mul.f64 fd675, fd671, 0d3FE0000000000000;
sub.f64 fd676, fd594, fd675;
sub.f64 fd677, fd610, fd614;
mul.f64 fd678, fd677, 0dBFEBB67AE8584CAA;
add.f64 fd679, fd678, fd676;
sub.f64 fd680, fd676, fd678;
mul.f64 fd681, fd673, 0d3FE0000000000000;
sub.f64 fd682, fd606, fd681;
sub.f64 fd683, fd598, fd602;
mul.f64 fd684, fd683, 0dBFEBB67AE8584CAA;
sub.f64 fd685, fd682, fd684;
add.f64 fd686, fd684, fd682;
add.f64 fd687, fd600, fd604;
add.f64 fd688, fd596, fd687;
add.f64 fd689, fd612, fd616;
add.f64 fd690, fd608, fd689;
mul.f64 fd691, fd687, 0d3FE0000000000000;
sub.f64 fd692, fd596, fd691;
sub.f64 fd693, fd612, fd616;
mul.f64 fd694, fd693, 0dBFEBB67AE8584CAA;
add.f64 fd695, fd694, fd692;
sub.f64 fd696, fd692, fd694;
mul.f64 fd697, fd689, 0d3FE0000000000000;
sub.f64 fd698, fd608, fd697;
sub.f64 fd699, fd600, fd604;
mul.f64 fd700, fd699, 0dBFEBB67AE8584CAA;
sub.f64 fd701, fd698, fd700;
add.f64 fd702, fd700, fd698;
mul.f64 fd703, fd695, 0d3FE0000000000000;
mul.f64 fd704, fd701, 0d3FEBB67AE8584CAA;
sub.f64 fd705, fd703, fd704;
mul.f64 fd706, fd701, 0d3FE0000000000000;
fma.rn.f64 fd707, fd695, 0d3FEBB67AE8584CAA, fd706;
mul.f64 fd708, fd696, 0dBFE0000000000000;
mul.f64 fd709, fd702, 0d3FEBB67AE8584CAA;
sub.f64 fd710, fd708, fd709;
mul.f64 fd711, fd702, 0dBFE0000000000000;
fma.rn.f64 fd712, fd696, 0d3FEBB67AE8584CAA, fd711;
add.f64 fd713, fd672, fd688;
add.f64 fd714, fd674, fd690;
sub.f64 fd715, fd672, fd688;
sub.f64 fd716, fd674, fd690;
add.f64 fd717, fd679, fd705;
add.f64 fd718, fd685, fd707;
sub.f64 fd719, fd679, fd705;
sub.f64 fd720, fd685, fd707;
add.f64 fd721, fd680, fd710;
add.f64 fd722, fd686, fd712;
sub.f64 fd723, fd680, fd710;
sub.f64 fd724, fd686, fd712;
mul.f64 fd725, fd717, 0d3FEBB67AE8584CAA;
mul.f64 fd726, fd718, 0d3FE0000000000000;
sub.f64 fd727, fd725, fd726;
mul.f64 fd728, fd718, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd729, fd717, 0d3FE0000000000000, fd728;
mul.f64 fd730, fd721, 0d3FE0000000000000;
mul.f64 fd731, fd722, 0d3FEBB67AE8584CAA;
sub.f64 fd732, fd730, fd731;
mul.f64 fd733, fd722, 0d3FE0000000000000;
fma.rn.f64 fd734, fd721, 0d3FEBB67AE8584CAA, fd733;
mul.f64 fd735, fd719, 0dBFE0000000000000;
mul.f64 fd736, fd720, 0d3FEBB67AE8584CAA;
sub.f64 fd737, fd735, fd736;
mul.f64 fd738, fd720, 0dBFE0000000000000;
fma.rn.f64 fd739, fd719, 0d3FEBB67AE8584CAA, fd738;
mul.f64 fd740, fd723, 0dBFEBB67AE8584CAA;
mul.f64 fd741, fd724, 0d3FE0000000000000;
sub.f64 fd742, fd740, fd741;
mul.f64 fd743, fd724, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd744, fd723, 0d3FE0000000000000, fd743;
add.f64 %0, fd659, fd713;
add.f64 %1, fd660, fd714;
add.f64 %3, fd664, fd729;
add.f64 %2, fd663, fd727;
add.f64 %5, fd668, fd734;
add.f64 %4, fd667, fd732;
add.f64 %7, fd662, fd715;
sub.f64 %6, fd661, fd716;
add.f64 %9, fd666, fd739;
add.f64 %8, fd665, fd737;
add.f64 %11, fd670, fd744;
add.f64 %10, fd669, fd742;
sub.f64 %12, fd659, fd713;
sub.f64 %13, fd660, fd714;
sub.f64 %15, fd664, fd729;
sub.f64 %14, fd663, fd727;
sub.f64 %17, fd668, fd734;
sub.f64 %16, fd667, fd732;
sub.f64 %19, fd662, fd715;
add.f64 %18, fd661, fd716;
sub.f64 %21, fd666, fd739;
sub.f64 %20, fd665, fd737;
sub.f64 %23, fd670, fd744;
sub.f64 %22, fd669, fd742;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y): "r"(smem), "l"(lut_dp_12_1728), "l"(lut_dp_12_144), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<745, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<17>;
.reg .f64 fd<817>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %24;
mad.lo.s32 r3, r1, 27648, r2;
mov.u32 r4, %tid.x;
add.f64 fd49, %37, %48;
add.f64 fd50, %27, fd49;
add.f64 fd51, %39, %50;
add.f64 fd52, %28, fd51;
mul.f64 fd53, fd49, 0d3FE0000000000000;
sub.f64 fd54, %27, fd53;
sub.f64 fd55, %39, %50;
mul.f64 fd56, fd55, 0dBFEBB67AE8584CAA;
add.f64 fd57, fd56, fd54;
sub.f64 fd58, fd54, fd56;
mul.f64 fd59, fd51, 0d3FE0000000000000;
sub.f64 fd60, %28, fd59;
sub.f64 fd61, %37, %48;
mul.f64 fd62, fd61, 0dBFEBB67AE8584CAA;
sub.f64 fd63, fd60, fd62;
add.f64 fd64, fd62, fd60;
add.f64 fd65, %43, %53;
add.f64 fd66, %32, fd65;
add.f64 fd67, %44, %55;
add.f64 fd68, %34, fd67;
mul.f64 fd69, fd65, 0d3FE0000000000000;
sub.f64 fd70, %32, fd69;
sub.f64 fd71, %44, %55;
mul.f64 fd72, fd71, 0dBFEBB67AE8584CAA;
add.f64 fd73, fd72, fd70;
sub.f64 fd74, fd70, fd72;
mul.f64 fd75, fd67, 0d3FE0000000000000;
sub.f64 fd76, %34, fd75;
sub.f64 fd77, %43, %53;
mul.f64 fd78, fd77, 0dBFEBB67AE8584CAA;
sub.f64 fd79, fd76, fd78;
add.f64 fd80, fd78, fd76;
mul.f64 fd81, fd73, 0d3FE0000000000000;
mul.f64 fd82, fd79, 0d3FEBB67AE8584CAA;
sub.f64 fd83, fd81, fd82;
mul.f64 fd84, fd79, 0d3FE0000000000000;
fma.rn.f64 fd85, fd73, 0d3FEBB67AE8584CAA, fd84;
mul.f64 fd86, fd74, 0dBFE0000000000000;
mul.f64 fd87, fd80, 0d3FEBB67AE8584CAA;
sub.f64 fd88, fd86, fd87;
mul.f64 fd89, fd80, 0dBFE0000000000000;
fma.rn.f64 fd90, fd74, 0d3FEBB67AE8584CAA, fd89;
add.f64 fd91, fd50, fd66;
add.f64 fd92, fd52, fd68;
sub.f64 fd93, fd50, fd66;
sub.f64 fd94, fd52, fd68;
add.f64 fd95, fd57, fd83;
add.f64 fd96, fd63, fd85;
sub.f64 fd97, fd57, fd83;
sub.f64 fd98, fd63, fd85;
add.f64 fd99, fd58, fd88;
add.f64 fd100, fd64, fd90;
sub.f64 fd101, fd58, fd88;
sub.f64 fd102, fd64, fd90;
add.f64 fd103, %40, %51;
add.f64 fd104, %29, fd103;
add.f64 fd105, %42, %52;
add.f64 fd106, %31, fd105;
mul.f64 fd107, fd103, 0d3FE0000000000000;
sub.f64 fd108, %29, fd107;
sub.f64 fd109, %42, %52;
mul.f64 fd110, fd109, 0dBFEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd105, 0d3FE0000000000000;
sub.f64 fd114, %31, fd113;
sub.f64 fd115, %40, %51;
mul.f64 fd116, fd115, 0dBFEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
add.f64 fd119, %45, %56;
add.f64 fd120, %35, fd119;
add.f64 fd121, %47, %57;
add.f64 fd122, %36, fd121;
mul.f64 fd123, fd119, 0d3FE0000000000000;
sub.f64 fd124, %35, fd123;
sub.f64 fd125, %47, %57;
mul.f64 fd126, fd125, 0dBFEBB67AE8584CAA;
add.f64 fd127, fd126, fd124;
sub.f64 fd128, fd124, fd126;
mul.f64 fd129, fd121, 0d3FE0000000000000;
sub.f64 fd130, %36, fd129;
sub.f64 fd131, %45, %56;
mul.f64 fd132, fd131, 0dBFEBB67AE8584CAA;
sub.f64 fd133, fd130, fd132;
add.f64 fd134, fd132, fd130;
mul.f64 fd135, fd127, 0d3FE0000000000000;
mul.f64 fd136, fd133, 0d3FEBB67AE8584CAA;
sub.f64 fd137, fd135, fd136;
mul.f64 fd138, fd133, 0d3FE0000000000000;
fma.rn.f64 fd139, fd127, 0d3FEBB67AE8584CAA, fd138;
mul.f64 fd140, fd128, 0dBFE0000000000000;
mul.f64 fd141, fd134, 0d3FEBB67AE8584CAA;
sub.f64 fd142, fd140, fd141;
mul.f64 fd143, fd134, 0dBFE0000000000000;
fma.rn.f64 fd144, fd128, 0d3FEBB67AE8584CAA, fd143;
add.f64 fd145, fd104, fd120;
add.f64 fd146, fd106, fd122;
sub.f64 fd147, fd104, fd120;
sub.f64 fd148, fd106, fd122;
add.f64 fd149, fd111, fd137;
add.f64 fd150, fd117, fd139;
sub.f64 fd151, fd111, fd137;
sub.f64 fd152, fd117, fd139;
add.f64 fd153, fd112, fd142;
add.f64 fd154, fd118, fd144;
sub.f64 fd155, fd112, fd142;
sub.f64 fd156, fd118, fd144;
mul.f64 fd157, fd149, 0d3FEBB67AE8584CAA;
mul.f64 fd158, fd150, 0d3FE0000000000000;
sub.f64 fd159, fd157, fd158;
mul.f64 fd160, fd150, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd161, fd149, 0d3FE0000000000000, fd160;
mul.f64 fd162, fd153, 0d3FE0000000000000;
mul.f64 fd163, fd154, 0d3FEBB67AE8584CAA;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, 0d3FE0000000000000;
fma.rn.f64 fd166, fd153, 0d3FEBB67AE8584CAA, fd165;
mul.f64 fd167, fd151, 0dBFE0000000000000;
mul.f64 fd168, fd152, 0d3FEBB67AE8584CAA;
sub.f64 fd169, fd167, fd168;
mul.f64 fd170, fd152, 0dBFE0000000000000;
fma.rn.f64 fd171, fd151, 0d3FEBB67AE8584CAA, fd170;
mul.f64 fd172, fd155, 0dBFEBB67AE8584CAA;
mul.f64 fd173, fd156, 0d3FE0000000000000;
sub.f64 fd174, fd172, fd173;
mul.f64 fd175, fd156, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd176, fd155, 0d3FE0000000000000, fd175;
sub.f64 fd177, fd91, fd145;
sub.f64 fd178, fd92, fd146;
add.f64 fd179, fd95, fd159;
add.f64 fd180, fd96, fd161;
sub.f64 fd181, fd95, fd159;
sub.f64 fd182, fd96, fd161;
add.f64 fd183, fd99, fd164;
add.f64 fd184, fd100, fd166;
sub.f64 fd185, fd99, fd164;
sub.f64 fd186, fd100, fd166;
sub.f64 fd187, fd93, fd148;
add.f64 fd188, fd94, fd147;
add.f64 fd189, fd93, fd148;
sub.f64 fd190, fd94, fd147;
add.f64 fd191, fd97, fd169;
add.f64 fd192, fd98, fd171;
sub.f64 fd193, fd97, fd169;
sub.f64 fd194, fd98, fd171;
add.f64 fd195, fd101, fd174;
add.f64 fd196, fd102, fd176;
sub.f64 fd197, fd101, fd174;
sub.f64 fd198, fd102, fd176;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 37;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 144;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 27648, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %25;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd199, fd200}, [rd6];
mul.f64 fd203, fd180, fd200;
mul.f64 fd204, fd179, fd200;
mul.f64 fd205, fd199, fd180;
mul.f64 fd206, fd199, fd199;
mul.f64 fd207, fd200, fd200;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd200, fd199;
fma.rn.f64 fd210, fd200, fd199, fd209;
mul.f64 fd211, fd184, fd210;
mul.f64 fd212, fd183, fd210;
mul.f64 fd213, fd208, fd184;
mul.f64 fd214, fd199, fd208;
mul.f64 fd215, fd200, fd210;
sub.f64 fd216, fd214, fd215;
mul.f64 fd217, fd199, fd210;
fma.rn.f64 fd218, fd200, fd208, fd217;
mul.f64 fd219, fd188, fd218;
mul.f64 fd220, fd187, fd218;
mul.f64 fd221, fd216, fd188;
mul.f64 fd222, fd199, fd216;
mul.f64 fd223, fd200, fd218;
sub.f64 fd224, fd222, fd223;
mul.f64 fd225, fd199, fd218;
fma.rn.f64 fd226, fd200, fd216, fd225;
mul.f64 fd227, fd192, fd226;
mul.f64 fd228, fd191, fd226;
mul.f64 fd229, fd224, fd192;
mul.f64 fd230, fd199, fd224;
mul.f64 fd231, fd200, fd226;
sub.f64 fd232, fd230, fd231;
mul.f64 fd233, fd199, fd226;
fma.rn.f64 fd234, fd200, fd224, fd233;
mul.f64 fd235, fd196, fd234;
mul.f64 fd236, fd195, fd234;
mul.f64 fd237, fd232, fd196;
mul.f64 fd238, fd199, fd232;
mul.f64 fd239, fd200, fd234;
sub.f64 fd240, fd238, fd239;
mul.f64 fd241, fd199, fd234;
fma.rn.f64 fd242, fd200, fd232, fd241;
mul.f64 fd243, fd178, fd242;
mul.f64 fd244, fd177, fd242;
mul.f64 fd245, fd240, fd178;
ld.global.v2.f64 {fd246, fd247}, [rd6+2304];
mul.f64 fd250, fd182, fd247;
mul.f64 fd251, fd181, fd247;
mul.f64 fd252, fd246, fd182;
mul.f64 fd253, fd199, fd246;
mul.f64 fd254, fd200, fd247;
sub.f64 fd255, fd253, fd254;
mul.f64 fd256, fd199, fd247;
fma.rn.f64 fd257, fd200, fd246, fd256;
mul.f64 fd258, fd186, fd257;
mul.f64 fd259, fd185, fd257;
mul.f64 fd260, fd255, fd186;
mul.f64 fd261, fd199, fd255;
mul.f64 fd262, fd200, fd257;
sub.f64 fd263, fd261, fd262;
mul.f64 fd264, fd199, fd257;
fma.rn.f64 fd265, fd200, fd255, fd264;
mul.f64 fd266, fd190, fd265;
mul.f64 fd267, fd189, fd265;
mul.f64 fd268, fd263, fd190;
mul.f64 fd269, fd199, fd263;
mul.f64 fd270, fd200, fd265;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd199, fd265;
fma.rn.f64 fd273, fd200, fd263, fd272;
mul.f64 fd274, fd194, fd273;
mul.f64 fd275, fd193, fd273;
mul.f64 fd276, fd271, fd194;
mul.f64 fd277, fd199, fd271;
mul.f64 fd278, fd200, fd273;
sub.f64 fd279, fd277, fd278;
mul.f64 fd280, fd199, fd273;
fma.rn.f64 fd281, fd200, fd271, fd280;
mul.f64 fd282, fd198, fd281;
mul.f64 fd283, fd197, fd281;
mul.f64 fd284, fd279, fd198;
barrier.sync 0;
mad.lo.s32 r9, r7, 192, r8;
add.f64 fd285, fd92, fd146;
add.f64 fd286, fd91, fd145;
st.shared.v2.f64 [r9], {fd286, fd285};
fma.rn.f64 fd287, fd199, fd179, fd203;
sub.f64 fd288, fd205, fd204;
st.shared.v2.f64 [r9+16], {fd287, fd288};
fma.rn.f64 fd289, fd208, fd183, fd211;
sub.f64 fd290, fd213, fd212;
st.shared.v2.f64 [r9+32], {fd289, fd290};
sub.f64 fd291, fd221, fd220;
fma.rn.f64 fd292, fd216, fd187, fd219;
st.shared.v2.f64 [r9+48], {fd292, fd291};
sub.f64 fd293, fd229, fd228;
fma.rn.f64 fd294, fd224, fd191, fd227;
st.shared.v2.f64 [r9+64], {fd294, fd293};
fma.rn.f64 fd295, fd232, fd195, fd235;
sub.f64 fd296, fd237, fd236;
st.shared.v2.f64 [r9+80], {fd295, fd296};
fma.rn.f64 fd297, fd240, fd177, fd243;
sub.f64 fd298, fd245, fd244;
st.shared.v2.f64 [r9+96], {fd297, fd298};
fma.rn.f64 fd299, fd246, fd181, fd250;
sub.f64 fd300, fd252, fd251;
st.shared.v2.f64 [r9+112], {fd299, fd300};
fma.rn.f64 fd301, fd255, fd185, fd258;
sub.f64 fd302, fd260, fd259;
st.shared.v2.f64 [r9+128], {fd301, fd302};
sub.f64 fd303, fd268, fd267;
fma.rn.f64 fd304, fd263, fd189, fd266;
st.shared.v2.f64 [r9+144], {fd304, fd303};
sub.f64 fd305, fd276, fd275;
fma.rn.f64 fd306, fd271, fd193, fd274;
st.shared.v2.f64 [r9+160], {fd306, fd305};
fma.rn.f64 fd307, fd279, fd197, fd282;
sub.f64 fd308, fd284, fd283;
st.shared.v2.f64 [r9+176], {fd307, fd308};
barrier.sync 0;
mad.lo.s32 r10, r7, -176, r9;
ld.shared.v2.f64 {fd309, fd310}, [r10];
ld.shared.v2.f64 {fd313, fd314}, [r10+2304];
ld.shared.v2.f64 {fd317, fd318}, [r10+4608];
ld.shared.v2.f64 {fd321, fd322}, [r10+6912];
ld.shared.v2.f64 {fd325, fd326}, [r10+9216];
ld.shared.v2.f64 {fd329, fd330}, [r10+11520];
ld.shared.v2.f64 {fd333, fd334}, [r10+13824];
ld.shared.v2.f64 {fd337, fd338}, [r10+16128];
ld.shared.v2.f64 {fd341, fd342}, [r10+18432];
ld.shared.v2.f64 {fd345, fd346}, [r10+20736];
ld.shared.v2.f64 {fd349, fd350}, [r10+23040];
ld.shared.v2.f64 {fd353, fd354}, [r10+25344];
add.f64 fd357, fd325, fd341;
add.f64 fd358, fd309, fd357;
add.f64 fd359, fd326, fd342;
add.f64 fd360, fd310, fd359;
mul.f64 fd361, fd357, 0d3FE0000000000000;
sub.f64 fd362, fd309, fd361;
sub.f64 fd363, fd326, fd342;
mul.f64 fd364, fd363, 0dBFEBB67AE8584CAA;
add.f64 fd365, fd364, fd362;
sub.f64 fd366, fd362, fd364;
mul.f64 fd367, fd359, 0d3FE0000000000000;
sub.f64 fd368, fd310, fd367;
sub.f64 fd369, fd325, fd341;
mul.f64 fd370, fd369, 0dBFEBB67AE8584CAA;
sub.f64 fd371, fd368, fd370;
add.f64 fd372, fd370, fd368;
add.f64 fd373, fd333, fd349;
add.f64 fd374, fd317, fd373;
add.f64 fd375, fd334, fd350;
add.f64 fd376, fd318, fd375;
mul.f64 fd377, fd373, 0d3FE0000000000000;
sub.f64 fd378, fd317, fd377;
sub.f64 fd379, fd334, fd350;
mul.f64 fd380, fd379, 0dBFEBB67AE8584CAA;
add.f64 fd381, fd380, fd378;
sub.f64 fd382, fd378, fd380;
mul.f64 fd383, fd375, 0d3FE0000000000000;
sub.f64 fd384, fd318, fd383;
sub.f64 fd385, fd333, fd349;
mul.f64 fd386, fd385, 0dBFEBB67AE8584CAA;
sub.f64 fd387, fd384, fd386;
add.f64 fd388, fd386, fd384;
mul.f64 fd389, fd381, 0d3FE0000000000000;
mul.f64 fd390, fd387, 0d3FEBB67AE8584CAA;
sub.f64 fd391, fd389, fd390;
mul.f64 fd392, fd387, 0d3FE0000000000000;
fma.rn.f64 fd393, fd381, 0d3FEBB67AE8584CAA, fd392;
mul.f64 fd394, fd382, 0dBFE0000000000000;
mul.f64 fd395, fd388, 0d3FEBB67AE8584CAA;
sub.f64 fd396, fd394, fd395;
mul.f64 fd397, fd388, 0dBFE0000000000000;
fma.rn.f64 fd398, fd382, 0d3FEBB67AE8584CAA, fd397;
add.f64 fd399, fd358, fd374;
add.f64 fd400, fd360, fd376;
sub.f64 fd401, fd358, fd374;
sub.f64 fd402, fd360, fd376;
add.f64 fd403, fd365, fd391;
add.f64 fd404, fd371, fd393;
sub.f64 fd405, fd365, fd391;
sub.f64 fd406, fd371, fd393;
add.f64 fd407, fd366, fd396;
add.f64 fd408, fd372, fd398;
sub.f64 fd409, fd366, fd396;
sub.f64 fd410, fd372, fd398;
add.f64 fd411, fd329, fd345;
add.f64 fd412, fd313, fd411;
add.f64 fd413, fd330, fd346;
add.f64 fd414, fd314, fd413;
mul.f64 fd415, fd411, 0d3FE0000000000000;
sub.f64 fd416, fd313, fd415;
sub.f64 fd417, fd330, fd346;
mul.f64 fd418, fd417, 0dBFEBB67AE8584CAA;
add.f64 fd419, fd418, fd416;
sub.f64 fd420, fd416, fd418;
mul.f64 fd421, fd413, 0d3FE0000000000000;
sub.f64 fd422, fd314, fd421;
sub.f64 fd423, fd329, fd345;
mul.f64 fd424, fd423, 0dBFEBB67AE8584CAA;
sub.f64 fd425, fd422, fd424;
add.f64 fd426, fd424, fd422;
add.f64 fd427, fd337, fd353;
add.f64 fd428, fd321, fd427;
add.f64 fd429, fd338, fd354;
add.f64 fd430, fd322, fd429;
mul.f64 fd431, fd427, 0d3FE0000000000000;
sub.f64 fd432, fd321, fd431;
sub.f64 fd433, fd338, fd354;
mul.f64 fd434, fd433, 0dBFEBB67AE8584CAA;
add.f64 fd435, fd434, fd432;
sub.f64 fd436, fd432, fd434;
mul.f64 fd437, fd429, 0d3FE0000000000000;
sub.f64 fd438, fd322, fd437;
sub.f64 fd439, fd337, fd353;
mul.f64 fd440, fd439, 0dBFEBB67AE8584CAA;
sub.f64 fd441, fd438, fd440;
add.f64 fd442, fd440, fd438;
mul.f64 fd443, fd435, 0d3FE0000000000000;
mul.f64 fd444, fd441, 0d3FEBB67AE8584CAA;
sub.f64 fd445, fd443, fd444;
mul.f64 fd446, fd441, 0d3FE0000000000000;
fma.rn.f64 fd447, fd435, 0d3FEBB67AE8584CAA, fd446;
mul.f64 fd448, fd436, 0dBFE0000000000000;
mul.f64 fd449, fd442, 0d3FEBB67AE8584CAA;
sub.f64 fd450, fd448, fd449;
mul.f64 fd451, fd442, 0dBFE0000000000000;
fma.rn.f64 fd452, fd436, 0d3FEBB67AE8584CAA, fd451;
add.f64 fd453, fd412, fd428;
add.f64 fd454, fd414, fd430;
sub.f64 fd455, fd412, fd428;
sub.f64 fd456, fd414, fd430;
add.f64 fd457, fd419, fd445;
add.f64 fd458, fd425, fd447;
sub.f64 fd459, fd419, fd445;
sub.f64 fd460, fd425, fd447;
add.f64 fd461, fd420, fd450;
add.f64 fd462, fd426, fd452;
sub.f64 fd463, fd420, fd450;
sub.f64 fd464, fd426, fd452;
mul.f64 fd465, fd457, 0d3FEBB67AE8584CAA;
mul.f64 fd466, fd458, 0d3FE0000000000000;
sub.f64 fd467, fd465, fd466;
mul.f64 fd468, fd458, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd469, fd457, 0d3FE0000000000000, fd468;
mul.f64 fd470, fd461, 0d3FE0000000000000;
mul.f64 fd471, fd462, 0d3FEBB67AE8584CAA;
sub.f64 fd472, fd470, fd471;
mul.f64 fd473, fd462, 0d3FE0000000000000;
fma.rn.f64 fd474, fd461, 0d3FEBB67AE8584CAA, fd473;
mul.f64 fd475, fd459, 0dBFE0000000000000;
mul.f64 fd476, fd460, 0d3FEBB67AE8584CAA;
sub.f64 fd477, fd475, fd476;
mul.f64 fd478, fd460, 0dBFE0000000000000;
fma.rn.f64 fd479, fd459, 0d3FEBB67AE8584CAA, fd478;
mul.f64 fd480, fd463, 0dBFEBB67AE8584CAA;
mul.f64 fd481, fd464, 0d3FE0000000000000;
sub.f64 fd482, fd480, fd481;
mul.f64 fd483, fd464, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd484, fd463, 0d3FE0000000000000, fd483;
sub.f64 fd485, fd399, fd453;
sub.f64 fd486, fd400, fd454;
add.f64 fd487, fd403, fd467;
add.f64 fd488, fd404, fd469;
sub.f64 fd489, fd403, fd467;
sub.f64 fd490, fd404, fd469;
add.f64 fd491, fd407, fd472;
add.f64 fd492, fd408, fd474;
sub.f64 fd493, fd407, fd472;
sub.f64 fd494, fd408, fd474;
sub.f64 fd495, fd401, fd456;
add.f64 fd496, fd402, fd455;
add.f64 fd497, fd401, fd456;
sub.f64 fd498, fd402, fd455;
add.f64 fd499, fd405, fd477;
add.f64 fd500, fd406, fd479;
sub.f64 fd501, fd405, fd477;
sub.f64 fd502, fd406, fd479;
add.f64 fd503, fd409, fd482;
add.f64 fd504, fd410, fd484;
sub.f64 fd505, fd409, fd482;
sub.f64 fd506, fd410, fd484;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 12;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 16;
mov.u64 rd10, %26;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd507, fd508}, [rd11];
mul.f64 fd511, fd488, fd508;
mul.f64 fd512, fd487, fd508;
mul.f64 fd513, fd507, fd488;
mul.f64 fd514, fd507, fd507;
mul.f64 fd515, fd508, fd508;
sub.f64 fd516, fd514, fd515;
mul.f64 fd517, fd508, fd507;
fma.rn.f64 fd518, fd508, fd507, fd517;
mul.f64 fd519, fd492, fd518;
mul.f64 fd520, fd491, fd518;
mul.f64 fd521, fd516, fd492;
mul.f64 fd522, fd507, fd516;
mul.f64 fd523, fd508, fd518;
sub.f64 fd524, fd522, fd523;
mul.f64 fd525, fd507, fd518;
fma.rn.f64 fd526, fd508, fd516, fd525;
mul.f64 fd527, fd496, fd526;
mul.f64 fd528, fd495, fd526;
mul.f64 fd529, fd524, fd496;
mul.f64 fd530, fd507, fd524;
mul.f64 fd531, fd508, fd526;
sub.f64 fd532, fd530, fd531;
mul.f64 fd533, fd507, fd526;
fma.rn.f64 fd534, fd508, fd524, fd533;
mul.f64 fd535, fd500, fd534;
mul.f64 fd536, fd499, fd534;
mul.f64 fd537, fd532, fd500;
mul.f64 fd538, fd507, fd532;
mul.f64 fd539, fd508, fd534;
sub.f64 fd540, fd538, fd539;
mul.f64 fd541, fd507, fd534;
fma.rn.f64 fd542, fd508, fd532, fd541;
mul.f64 fd543, fd504, fd542;
mul.f64 fd544, fd503, fd542;
mul.f64 fd545, fd540, fd504;
mul.f64 fd546, fd507, fd540;
mul.f64 fd547, fd508, fd542;
sub.f64 fd548, fd546, fd547;
mul.f64 fd549, fd507, fd542;
fma.rn.f64 fd550, fd508, fd540, fd549;
mul.f64 fd551, fd486, fd550;
mul.f64 fd552, fd485, fd550;
mul.f64 fd553, fd548, fd486;
ld.global.v2.f64 {fd554, fd555}, [rd11+192];
mul.f64 fd558, fd490, fd555;
mul.f64 fd559, fd489, fd555;
mul.f64 fd560, fd554, fd490;
mul.f64 fd561, fd507, fd554;
mul.f64 fd562, fd508, fd555;
sub.f64 fd563, fd561, fd562;
mul.f64 fd564, fd507, fd555;
fma.rn.f64 fd565, fd508, fd554, fd564;
mul.f64 fd566, fd494, fd565;
mul.f64 fd567, fd493, fd565;
mul.f64 fd568, fd563, fd494;
mul.f64 fd569, fd507, fd563;
mul.f64 fd570, fd508, fd565;
sub.f64 fd571, fd569, fd570;
mul.f64 fd572, fd507, fd565;
fma.rn.f64 fd573, fd508, fd563, fd572;
mul.f64 fd574, fd498, fd573;
mul.f64 fd575, fd497, fd573;
mul.f64 fd576, fd571, fd498;
mul.f64 fd577, fd507, fd571;
mul.f64 fd578, fd508, fd573;
sub.f64 fd579, fd577, fd578;
mul.f64 fd580, fd507, fd573;
fma.rn.f64 fd581, fd508, fd571, fd580;
mul.f64 fd582, fd502, fd581;
mul.f64 fd583, fd501, fd581;
mul.f64 fd584, fd579, fd502;
mul.f64 fd585, fd507, fd579;
mul.f64 fd586, fd508, fd581;
sub.f64 fd587, fd585, fd586;
mul.f64 fd588, fd507, fd581;
fma.rn.f64 fd589, fd508, fd579, fd588;
mul.f64 fd590, fd506, fd589;
mul.f64 fd591, fd505, fd589;
mul.f64 fd592, fd587, fd506;
shl.b32 r14, r13, 4;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 2304, r15;
add.f64 fd593, fd400, fd454;
add.f64 fd594, fd399, fd453;
st.shared.v2.f64 [r16], {fd594, fd593};
fma.rn.f64 fd595, fd507, fd487, fd511;
sub.f64 fd596, fd513, fd512;
st.shared.v2.f64 [r16+192], {fd595, fd596};
fma.rn.f64 fd597, fd516, fd491, fd519;
sub.f64 fd598, fd521, fd520;
st.shared.v2.f64 [r16+384], {fd597, fd598};
fma.rn.f64 fd599, fd524, fd495, fd527;
sub.f64 fd600, fd529, fd528;
st.shared.v2.f64 [r16+576], {fd599, fd600};
fma.rn.f64 fd601, fd532, fd499, fd535;
sub.f64 fd602, fd537, fd536;
st.shared.v2.f64 [r16+768], {fd601, fd602};
fma.rn.f64 fd603, fd540, fd503, fd543;
sub.f64 fd604, fd545, fd544;
st.shared.v2.f64 [r16+960], {fd603, fd604};
fma.rn.f64 fd605, fd548, fd485, fd551;
sub.f64 fd606, fd553, fd552;
st.shared.v2.f64 [r16+1152], {fd605, fd606};
fma.rn.f64 fd607, fd554, fd489, fd558;
sub.f64 fd608, fd560, fd559;
st.shared.v2.f64 [r16+1344], {fd607, fd608};
fma.rn.f64 fd609, fd563, fd493, fd566;
sub.f64 fd610, fd568, fd567;
st.shared.v2.f64 [r16+1536], {fd609, fd610};
fma.rn.f64 fd611, fd571, fd497, fd574;
sub.f64 fd612, fd576, fd575;
st.shared.v2.f64 [r16+1728], {fd611, fd612};
fma.rn.f64 fd613, fd579, fd501, fd582;
sub.f64 fd614, fd584, fd583;
st.shared.v2.f64 [r16+1920], {fd613, fd614};
fma.rn.f64 fd615, fd587, fd505, fd590;
sub.f64 fd616, fd592, fd591;
st.shared.v2.f64 [r16+2112], {fd615, fd616};
barrier.sync 0;
ld.shared.v2.f64 {fd617, fd618}, [r10];
ld.shared.v2.f64 {fd621, fd622}, [r10+2304];
ld.shared.v2.f64 {fd625, fd626}, [r10+4608];
ld.shared.v2.f64 {fd629, fd630}, [r10+6912];
ld.shared.v2.f64 {fd633, fd634}, [r10+9216];
ld.shared.v2.f64 {fd637, fd638}, [r10+11520];
ld.shared.v2.f64 {fd641, fd642}, [r10+13824];
ld.shared.v2.f64 {fd645, fd646}, [r10+16128];
ld.shared.v2.f64 {fd649, fd650}, [r10+18432];
ld.shared.v2.f64 {fd653, fd654}, [r10+20736];
ld.shared.v2.f64 {fd657, fd658}, [r10+23040];
ld.shared.v2.f64 {fd661, fd662}, [r10+25344];
add.f64 fd665, fd633, fd649;
add.f64 fd666, fd617, fd665;
add.f64 fd667, fd634, fd650;
add.f64 fd668, fd618, fd667;
mul.f64 fd669, fd665, 0d3FE0000000000000;
sub.f64 fd670, fd617, fd669;
sub.f64 fd671, fd634, fd650;
mul.f64 fd672, fd671, 0dBFEBB67AE8584CAA;
add.f64 fd673, fd672, fd670;
sub.f64 fd674, fd670, fd672;
mul.f64 fd675, fd667, 0d3FE0000000000000;
sub.f64 fd676, fd618, fd675;
sub.f64 fd677, fd633, fd649;
mul.f64 fd678, fd677, 0dBFEBB67AE8584CAA;
sub.f64 fd679, fd676, fd678;
add.f64 fd680, fd678, fd676;
add.f64 fd681, fd641, fd657;
add.f64 fd682, fd625, fd681;
add.f64 fd683, fd642, fd658;
add.f64 fd684, fd626, fd683;
mul.f64 fd685, fd681, 0d3FE0000000000000;
sub.f64 fd686, fd625, fd685;
sub.f64 fd687, fd642, fd658;
mul.f64 fd688, fd687, 0dBFEBB67AE8584CAA;
add.f64 fd689, fd688, fd686;
sub.f64 fd690, fd686, fd688;
mul.f64 fd691, fd683, 0d3FE0000000000000;
sub.f64 fd692, fd626, fd691;
sub.f64 fd693, fd641, fd657;
mul.f64 fd694, fd693, 0dBFEBB67AE8584CAA;
sub.f64 fd695, fd692, fd694;
add.f64 fd696, fd694, fd692;
mul.f64 fd697, fd689, 0d3FE0000000000000;
mul.f64 fd698, fd695, 0d3FEBB67AE8584CAA;
sub.f64 fd699, fd697, fd698;
mul.f64 fd700, fd695, 0d3FE0000000000000;
fma.rn.f64 fd701, fd689, 0d3FEBB67AE8584CAA, fd700;
mul.f64 fd702, fd690, 0dBFE0000000000000;
mul.f64 fd703, fd696, 0d3FEBB67AE8584CAA;
sub.f64 fd704, fd702, fd703;
mul.f64 fd705, fd696, 0dBFE0000000000000;
fma.rn.f64 fd706, fd690, 0d3FEBB67AE8584CAA, fd705;
add.f64 fd707, fd666, fd682;
add.f64 fd708, fd668, fd684;
sub.f64 fd709, fd666, fd682;
sub.f64 fd710, fd668, fd684;
add.f64 fd711, fd673, fd699;
add.f64 fd712, fd679, fd701;
sub.f64 fd713, fd673, fd699;
sub.f64 fd714, fd679, fd701;
add.f64 fd715, fd674, fd704;
add.f64 fd716, fd680, fd706;
sub.f64 fd717, fd674, fd704;
sub.f64 fd718, fd680, fd706;
add.f64 fd719, fd637, fd653;
add.f64 fd720, fd621, fd719;
add.f64 fd721, fd638, fd654;
add.f64 fd722, fd622, fd721;
mul.f64 fd723, fd719, 0d3FE0000000000000;
sub.f64 fd724, fd621, fd723;
sub.f64 fd725, fd638, fd654;
mul.f64 fd726, fd725, 0dBFEBB67AE8584CAA;
add.f64 fd727, fd726, fd724;
sub.f64 fd728, fd724, fd726;
mul.f64 fd729, fd721, 0d3FE0000000000000;
sub.f64 fd730, fd622, fd729;
sub.f64 fd731, fd637, fd653;
mul.f64 fd732, fd731, 0dBFEBB67AE8584CAA;
sub.f64 fd733, fd730, fd732;
add.f64 fd734, fd732, fd730;
add.f64 fd735, fd645, fd661;
add.f64 fd736, fd629, fd735;
add.f64 fd737, fd646, fd662;
add.f64 fd738, fd630, fd737;
mul.f64 fd739, fd735, 0d3FE0000000000000;
sub.f64 fd740, fd629, fd739;
sub.f64 fd741, fd646, fd662;
mul.f64 fd742, fd741, 0dBFEBB67AE8584CAA;
add.f64 fd743, fd742, fd740;
sub.f64 fd744, fd740, fd742;
mul.f64 fd745, fd737, 0d3FE0000000000000;
sub.f64 fd746, fd630, fd745;
sub.f64 fd747, fd645, fd661;
mul.f64 fd748, fd747, 0dBFEBB67AE8584CAA;
sub.f64 fd749, fd746, fd748;
add.f64 fd750, fd748, fd746;
mul.f64 fd751, fd743, 0d3FE0000000000000;
mul.f64 fd752, fd749, 0d3FEBB67AE8584CAA;
sub.f64 fd753, fd751, fd752;
mul.f64 fd754, fd749, 0d3FE0000000000000;
fma.rn.f64 fd755, fd743, 0d3FEBB67AE8584CAA, fd754;
mul.f64 fd756, fd744, 0dBFE0000000000000;
mul.f64 fd757, fd750, 0d3FEBB67AE8584CAA;
sub.f64 fd758, fd756, fd757;
mul.f64 fd759, fd750, 0dBFE0000000000000;
fma.rn.f64 fd760, fd744, 0d3FEBB67AE8584CAA, fd759;
add.f64 fd761, fd720, fd736;
add.f64 fd762, fd722, fd738;
sub.f64 fd763, fd720, fd736;
sub.f64 fd764, fd722, fd738;
add.f64 fd765, fd727, fd753;
add.f64 fd766, fd733, fd755;
sub.f64 fd767, fd727, fd753;
sub.f64 fd768, fd733, fd755;
add.f64 fd769, fd728, fd758;
add.f64 fd770, fd734, fd760;
sub.f64 fd771, fd728, fd758;
sub.f64 fd772, fd734, fd760;
mul.f64 fd773, fd765, 0d3FEBB67AE8584CAA;
mul.f64 fd774, fd766, 0d3FE0000000000000;
sub.f64 fd775, fd773, fd774;
mul.f64 fd776, fd766, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd777, fd765, 0d3FE0000000000000, fd776;
mul.f64 fd778, fd769, 0d3FE0000000000000;
mul.f64 fd779, fd770, 0d3FEBB67AE8584CAA;
sub.f64 fd780, fd778, fd779;
mul.f64 fd781, fd770, 0d3FE0000000000000;
fma.rn.f64 fd782, fd769, 0d3FEBB67AE8584CAA, fd781;
mul.f64 fd783, fd767, 0dBFE0000000000000;
mul.f64 fd784, fd768, 0d3FEBB67AE8584CAA;
sub.f64 fd785, fd783, fd784;
mul.f64 fd786, fd768, 0dBFE0000000000000;
fma.rn.f64 fd787, fd767, 0d3FEBB67AE8584CAA, fd786;
mul.f64 fd788, fd771, 0dBFEBB67AE8584CAA;
mul.f64 fd789, fd772, 0d3FE0000000000000;
sub.f64 fd790, fd788, fd789;
mul.f64 fd791, fd772, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd792, fd771, 0d3FE0000000000000, fd791;
add.f64 %1, fd708, fd762;
add.f64 %0, fd707, fd761;
add.f64 %3, fd712, fd777;
add.f64 %2, fd711, fd775;
add.f64 %5, fd716, fd782;
add.f64 %4, fd715, fd780;
add.f64 %7, fd710, fd763;
sub.f64 %6, fd709, fd764;
add.f64 %9, fd714, fd787;
add.f64 %8, fd713, fd785;
add.f64 %11, fd718, fd792;
add.f64 %10, fd717, fd790;
sub.f64 %13, fd708, fd762;
sub.f64 %12, fd707, fd761;
sub.f64 %15, fd712, fd777;
sub.f64 %14, fd711, fd775;
sub.f64 %17, fd716, fd782;
sub.f64 %16, fd715, fd780;
sub.f64 %19, fd710, fd763;
add.f64 %18, fd709, fd764;
sub.f64 %21, fd714, fd787;
sub.f64 %20, fd713, fd785;
sub.f64 %23, fd718, fd792;
sub.f64 %22, fd717, fd790;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y): "r"(smem), "l"(lut_dp_12_1728), "l"(lut_dp_12_144), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y));
};


#endif
