#ifndef CUFFTDX_FFT_2187_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_2187_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<528, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<24>;
.reg .f64 fd<775>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %18;
mad.lo.s32 r3, r1, 34992, r2;
add.f64 fd37, %30, %38;
add.f64 fd38, %22, fd37;
add.f64 fd39, %31, %39;
add.f64 fd40, %23, fd39;
mul.f64 fd41, fd37, 0d3FE0000000000000;
sub.f64 fd42, %22, fd41;
sub.f64 fd43, %31, %39;
mul.f64 fd44, fd43, 0d3FEBB67AE8584CAA;
add.f64 fd45, fd44, fd42;
sub.f64 fd46, fd42, fd44;
mul.f64 fd47, fd39, 0d3FE0000000000000;
sub.f64 fd48, %23, fd47;
sub.f64 fd49, %30, %38;
mul.f64 fd50, fd49, 0d3FEBB67AE8584CAA;
sub.f64 fd51, fd48, fd50;
add.f64 fd52, fd50, fd48;
add.f64 fd53, %32, %40;
add.f64 fd54, %24, fd53;
add.f64 fd55, %34, %42;
add.f64 fd56, %26, fd55;
mul.f64 fd57, fd53, 0d3FE0000000000000;
sub.f64 fd58, %24, fd57;
sub.f64 fd59, %34, %42;
mul.f64 fd60, fd59, 0d3FEBB67AE8584CAA;
add.f64 fd61, fd60, fd58;
sub.f64 fd62, fd58, fd60;
mul.f64 fd63, fd55, 0d3FE0000000000000;
sub.f64 fd64, %26, fd63;
sub.f64 fd65, %32, %40;
mul.f64 fd66, fd65, 0d3FEBB67AE8584CAA;
sub.f64 fd67, fd64, fd66;
add.f64 fd68, fd66, fd64;
add.f64 fd69, %35, %43;
add.f64 fd70, %27, fd69;
add.f64 fd71, %37, %44;
add.f64 fd72, %29, fd71;
mul.f64 fd73, fd69, 0d3FE0000000000000;
sub.f64 fd74, %27, fd73;
sub.f64 fd75, %37, %44;
mul.f64 fd76, fd75, 0d3FEBB67AE8584CAA;
add.f64 fd77, fd76, fd74;
sub.f64 fd78, fd74, fd76;
mul.f64 fd79, fd71, 0d3FE0000000000000;
sub.f64 fd80, %29, fd79;
sub.f64 fd81, %35, %43;
mul.f64 fd82, fd81, 0d3FEBB67AE8584CAA;
sub.f64 fd83, fd80, fd82;
add.f64 fd84, fd82, fd80;
mov.u32 r4, %tid.x;
mul.f64 fd85, fd61, 0d3FE8836FA2CF5039;
mul.f64 fd86, fd67, 0dBFE491B7523C161D;
sub.f64 fd87, fd85, fd86;
mul.f64 fd88, fd67, 0d3FE8836FA2CF5039;
fma.rn.f64 fd89, fd61, 0dBFE491B7523C161D, fd88;
mul.f64 fd90, fd77, 0d3FC63A1A7E0B738A;
mul.f64 fd91, fd83, 0dBFEF838B8C811C17;
sub.f64 fd92, fd90, fd91;
mul.f64 fd93, fd83, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd94, fd77, 0dBFEF838B8C811C17, fd93;
mul.f64 fd95, fd62, 0d3FC63A1A7E0B738A;
mul.f64 fd96, fd68, 0dBFEF838B8C811C17;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd68, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd99, fd62, 0dBFEF838B8C811C17, fd98;
mul.f64 fd100, fd78, 0dBFEE11F642522D1C;
mul.f64 fd101, fd84, 0dBFD5E3A8748A0BF5;
sub.f64 fd102, fd100, fd101;
mul.f64 fd103, fd84, 0dBFEE11F642522D1C;
fma.rn.f64 fd104, fd78, 0dBFD5E3A8748A0BF5, fd103;
add.f64 fd105, fd54, fd70;
add.f64 fd106, fd56, fd72;
mul.f64 fd107, fd105, 0d3FE0000000000000;
sub.f64 fd108, fd38, fd107;
sub.f64 fd109, fd56, fd72;
mul.f64 fd110, fd109, 0d3FEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd106, 0d3FE0000000000000;
sub.f64 fd114, fd40, fd113;
sub.f64 fd115, fd54, fd70;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
add.f64 fd119, fd87, fd92;
add.f64 fd120, fd45, fd119;
add.f64 fd121, fd89, fd94;
add.f64 fd122, fd51, fd121;
mul.f64 fd123, fd119, 0d3FE0000000000000;
sub.f64 fd124, fd45, fd123;
sub.f64 fd125, fd89, fd94;
mul.f64 fd126, fd125, 0d3FEBB67AE8584CAA;
add.f64 fd127, fd126, fd124;
sub.f64 fd128, fd124, fd126;
mul.f64 fd129, fd121, 0d3FE0000000000000;
sub.f64 fd130, fd51, fd129;
sub.f64 fd131, fd87, fd92;
mul.f64 fd132, fd131, 0d3FEBB67AE8584CAA;
sub.f64 fd133, fd130, fd132;
add.f64 fd134, fd132, fd130;
add.f64 fd135, fd97, fd102;
add.f64 fd136, fd46, fd135;
add.f64 fd137, fd99, fd104;
add.f64 fd138, fd52, fd137;
mul.f64 fd139, fd135, 0d3FE0000000000000;
sub.f64 fd140, fd46, fd139;
sub.f64 fd141, fd99, fd104;
mul.f64 fd142, fd141, 0d3FEBB67AE8584CAA;
add.f64 fd143, fd142, fd140;
sub.f64 fd144, fd140, fd142;
mul.f64 fd145, fd137, 0d3FE0000000000000;
sub.f64 fd146, fd52, fd145;
sub.f64 fd147, fd97, fd102;
mul.f64 fd148, fd147, 0d3FEBB67AE8584CAA;
sub.f64 fd149, fd146, fd148;
add.f64 fd150, fd148, fd146;
mul.wide.u32 rd2, r4, -2032597691;
shr.u64 rd3, rd2, 39;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 243;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 34992, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %19;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd151, fd152}, [rd6];
mul.f64 fd155, fd151, fd120;
mul.f64 fd156, fd152, fd122;
mul.f64 fd157, fd151, fd122;
mul.f64 fd158, fd151, fd151;
mul.f64 fd159, fd152, fd152;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd152, fd151;
fma.rn.f64 fd162, fd152, fd151, fd161;
mul.f64 fd163, fd160, fd136;
mul.f64 fd164, fd162, fd138;
mul.f64 fd165, fd160, fd138;
mul.f64 fd166, fd151, fd160;
mul.f64 fd167, fd152, fd162;
sub.f64 fd168, fd166, fd167;
mul.f64 fd169, fd151, fd162;
fma.rn.f64 fd170, fd152, fd160, fd169;
mul.f64 fd171, fd168, fd111;
mul.f64 fd172, fd170, fd117;
mul.f64 fd173, fd168, fd117;
mul.f64 fd174, fd151, fd168;
mul.f64 fd175, fd152, fd170;
sub.f64 fd176, fd174, fd175;
mul.f64 fd177, fd151, fd170;
fma.rn.f64 fd178, fd152, fd168, fd177;
mul.f64 fd179, fd176, fd127;
mul.f64 fd180, fd178, fd133;
mul.f64 fd181, fd176, fd133;
ld.global.v2.f64 {fd182, fd183}, [rd6+3888];
mul.f64 fd186, fd182, fd143;
mul.f64 fd187, fd183, fd149;
mul.f64 fd188, fd182, fd149;
mul.f64 fd189, fd151, fd182;
mul.f64 fd190, fd152, fd183;
sub.f64 fd191, fd189, fd190;
mul.f64 fd192, fd151, fd183;
fma.rn.f64 fd193, fd152, fd182, fd192;
mul.f64 fd194, fd191, fd112;
mul.f64 fd195, fd193, fd118;
mul.f64 fd196, fd191, fd118;
mul.f64 fd197, fd151, fd191;
mul.f64 fd198, fd152, fd193;
sub.f64 fd199, fd197, fd198;
mul.f64 fd200, fd151, fd193;
fma.rn.f64 fd201, fd152, fd191, fd200;
mul.f64 fd202, fd199, fd128;
mul.f64 fd203, fd201, fd134;
mul.f64 fd204, fd199, fd134;
mul.f64 fd205, fd151, fd199;
mul.f64 fd206, fd152, fd201;
sub.f64 fd207, fd205, fd206;
mul.f64 fd208, fd151, fd201;
fma.rn.f64 fd209, fd152, fd199, fd208;
mul.f64 fd210, fd207, fd144;
mul.f64 fd211, fd209, fd150;
mul.f64 fd212, fd207, fd150;
barrier.sync 0;
mad.lo.s32 r9, r7, 144, r8;
add.f64 fd213, fd40, fd106;
add.f64 fd214, fd38, fd105;
st.shared.v2.f64 [r9], {fd214, fd213};
fma.rn.f64 fd215, fd152, fd120, fd157;
sub.f64 fd216, fd155, fd156;
st.shared.v2.f64 [r9+16], {fd216, fd215};
fma.rn.f64 fd217, fd162, fd136, fd165;
sub.f64 fd218, fd163, fd164;
st.shared.v2.f64 [r9+32], {fd218, fd217};
sub.f64 fd219, fd171, fd172;
fma.rn.f64 fd220, fd170, fd111, fd173;
st.shared.v2.f64 [r9+48], {fd219, fd220};
fma.rn.f64 fd221, fd178, fd127, fd181;
sub.f64 fd222, fd179, fd180;
st.shared.v2.f64 [r9+64], {fd222, fd221};
fma.rn.f64 fd223, fd183, fd143, fd188;
sub.f64 fd224, fd186, fd187;
st.shared.v2.f64 [r9+80], {fd224, fd223};
fma.rn.f64 fd225, fd193, fd112, fd196;
sub.f64 fd226, fd194, fd195;
st.shared.v2.f64 [r9+96], {fd226, fd225};
fma.rn.f64 fd227, fd201, fd128, fd204;
sub.f64 fd228, fd202, fd203;
st.shared.v2.f64 [r9+112], {fd228, fd227};
fma.rn.f64 fd229, fd209, fd144, fd212;
sub.f64 fd230, fd210, fd211;
st.shared.v2.f64 [r9+128], {fd230, fd229};
barrier.sync 0;
shl.b32 r10, r7, 7;
sub.s32 r11, r9, r10;
ld.shared.v2.f64 {fd231, fd232}, [r11];
ld.shared.v2.f64 {fd235, fd236}, [r11+3888];
ld.shared.v2.f64 {fd239, fd240}, [r11+7776];
ld.shared.v2.f64 {fd243, fd244}, [r11+11664];
ld.shared.v2.f64 {fd247, fd248}, [r11+15552];
ld.shared.v2.f64 {fd251, fd252}, [r11+19440];
ld.shared.v2.f64 {fd255, fd256}, [r11+23328];
ld.shared.v2.f64 {fd259, fd260}, [r11+27216];
ld.shared.v2.f64 {fd263, fd264}, [r11+31104];
add.f64 fd267, fd243, fd255;
add.f64 fd268, fd231, fd267;
add.f64 fd269, fd244, fd256;
add.f64 fd270, fd232, fd269;
mul.f64 fd271, fd267, 0d3FE0000000000000;
sub.f64 fd272, fd231, fd271;
sub.f64 fd273, fd244, fd256;
mul.f64 fd274, fd273, 0d3FEBB67AE8584CAA;
add.f64 fd275, fd274, fd272;
sub.f64 fd276, fd272, fd274;
mul.f64 fd277, fd269, 0d3FE0000000000000;
sub.f64 fd278, fd232, fd277;
sub.f64 fd279, fd243, fd255;
mul.f64 fd280, fd279, 0d3FEBB67AE8584CAA;
sub.f64 fd281, fd278, fd280;
add.f64 fd282, fd280, fd278;
add.f64 fd283, fd247, fd259;
add.f64 fd284, fd235, fd283;
add.f64 fd285, fd248, fd260;
add.f64 fd286, fd236, fd285;
mul.f64 fd287, fd283, 0d3FE0000000000000;
sub.f64 fd288, fd235, fd287;
sub.f64 fd289, fd248, fd260;
mul.f64 fd290, fd289, 0d3FEBB67AE8584CAA;
add.f64 fd291, fd290, fd288;
sub.f64 fd292, fd288, fd290;
mul.f64 fd293, fd285, 0d3FE0000000000000;
sub.f64 fd294, fd236, fd293;
sub.f64 fd295, fd247, fd259;
mul.f64 fd296, fd295, 0d3FEBB67AE8584CAA;
sub.f64 fd297, fd294, fd296;
add.f64 fd298, fd296, fd294;
add.f64 fd299, fd251, fd263;
add.f64 fd300, fd239, fd299;
add.f64 fd301, fd252, fd264;
add.f64 fd302, fd240, fd301;
mul.f64 fd303, fd299, 0d3FE0000000000000;
sub.f64 fd304, fd239, fd303;
sub.f64 fd305, fd252, fd264;
mul.f64 fd306, fd305, 0d3FEBB67AE8584CAA;
add.f64 fd307, fd306, fd304;
sub.f64 fd308, fd304, fd306;
mul.f64 fd309, fd301, 0d3FE0000000000000;
sub.f64 fd310, fd240, fd309;
sub.f64 fd311, fd251, fd263;
mul.f64 fd312, fd311, 0d3FEBB67AE8584CAA;
sub.f64 fd313, fd310, fd312;
add.f64 fd314, fd312, fd310;
mul.f64 fd315, fd291, 0d3FE8836FA2CF5039;
mul.f64 fd316, fd297, 0dBFE491B7523C161D;
sub.f64 fd317, fd315, fd316;
mul.f64 fd318, fd297, 0d3FE8836FA2CF5039;
fma.rn.f64 fd319, fd291, 0dBFE491B7523C161D, fd318;
mul.f64 fd320, fd307, 0d3FC63A1A7E0B738A;
mul.f64 fd321, fd313, 0dBFEF838B8C811C17;
sub.f64 fd322, fd320, fd321;
mul.f64 fd323, fd313, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd324, fd307, 0dBFEF838B8C811C17, fd323;
mul.f64 fd325, fd292, 0d3FC63A1A7E0B738A;
mul.f64 fd326, fd298, 0dBFEF838B8C811C17;
sub.f64 fd327, fd325, fd326;
mul.f64 fd328, fd298, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd329, fd292, 0dBFEF838B8C811C17, fd328;
mul.f64 fd330, fd308, 0dBFEE11F642522D1C;
mul.f64 fd331, fd314, 0dBFD5E3A8748A0BF5;
sub.f64 fd332, fd330, fd331;
mul.f64 fd333, fd314, 0dBFEE11F642522D1C;
fma.rn.f64 fd334, fd308, 0dBFD5E3A8748A0BF5, fd333;
add.f64 fd335, fd284, fd300;
add.f64 fd336, fd286, fd302;
mul.f64 fd337, fd335, 0d3FE0000000000000;
sub.f64 fd338, fd268, fd337;
sub.f64 fd339, fd286, fd302;
mul.f64 fd340, fd339, 0d3FEBB67AE8584CAA;
add.f64 fd341, fd340, fd338;
sub.f64 fd342, fd338, fd340;
mul.f64 fd343, fd336, 0d3FE0000000000000;
sub.f64 fd344, fd270, fd343;
sub.f64 fd345, fd284, fd300;
mul.f64 fd346, fd345, 0d3FEBB67AE8584CAA;
sub.f64 fd347, fd344, fd346;
add.f64 fd348, fd346, fd344;
add.f64 fd349, fd317, fd322;
add.f64 fd350, fd275, fd349;
add.f64 fd351, fd319, fd324;
add.f64 fd352, fd281, fd351;
mul.f64 fd353, fd349, 0d3FE0000000000000;
sub.f64 fd354, fd275, fd353;
sub.f64 fd355, fd319, fd324;
mul.f64 fd356, fd355, 0d3FEBB67AE8584CAA;
add.f64 fd357, fd356, fd354;
sub.f64 fd358, fd354, fd356;
mul.f64 fd359, fd351, 0d3FE0000000000000;
sub.f64 fd360, fd281, fd359;
sub.f64 fd361, fd317, fd322;
mul.f64 fd362, fd361, 0d3FEBB67AE8584CAA;
sub.f64 fd363, fd360, fd362;
add.f64 fd364, fd362, fd360;
add.f64 fd365, fd327, fd332;
add.f64 fd366, fd276, fd365;
add.f64 fd367, fd329, fd334;
add.f64 fd368, fd282, fd367;
mul.f64 fd369, fd365, 0d3FE0000000000000;
sub.f64 fd370, fd276, fd369;
sub.f64 fd371, fd329, fd334;
mul.f64 fd372, fd371, 0d3FEBB67AE8584CAA;
add.f64 fd373, fd372, fd370;
sub.f64 fd374, fd370, fd372;
mul.f64 fd375, fd367, 0d3FE0000000000000;
sub.f64 fd376, fd282, fd375;
sub.f64 fd377, fd327, fd332;
mul.f64 fd378, fd377, 0d3FEBB67AE8584CAA;
sub.f64 fd379, fd376, fd378;
add.f64 fd380, fd378, fd376;
mul.wide.u32 rd7, r7, 954437177;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 9;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %20;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd381, fd382}, [rd11];
mul.f64 fd385, fd381, fd350;
mul.f64 fd386, fd382, fd352;
mul.f64 fd387, fd381, fd352;
mul.f64 fd388, fd381, fd381;
mul.f64 fd389, fd382, fd382;
sub.f64 fd390, fd388, fd389;
mul.f64 fd391, fd382, fd381;
fma.rn.f64 fd392, fd382, fd381, fd391;
mul.f64 fd393, fd390, fd366;
mul.f64 fd394, fd392, fd368;
mul.f64 fd395, fd390, fd368;
mul.f64 fd396, fd381, fd390;
mul.f64 fd397, fd382, fd392;
sub.f64 fd398, fd396, fd397;
mul.f64 fd399, fd381, fd392;
fma.rn.f64 fd400, fd382, fd390, fd399;
mul.f64 fd401, fd398, fd341;
mul.f64 fd402, fd400, fd347;
mul.f64 fd403, fd398, fd347;
mul.f64 fd404, fd381, fd398;
mul.f64 fd405, fd382, fd400;
sub.f64 fd406, fd404, fd405;
mul.f64 fd407, fd381, fd400;
fma.rn.f64 fd408, fd382, fd398, fd407;
mul.f64 fd409, fd406, fd357;
mul.f64 fd410, fd408, fd363;
mul.f64 fd411, fd406, fd363;
ld.global.v2.f64 {fd412, fd413}, [rd11+432];
mul.f64 fd416, fd412, fd373;
mul.f64 fd417, fd413, fd379;
mul.f64 fd418, fd412, fd379;
mul.f64 fd419, fd381, fd412;
mul.f64 fd420, fd382, fd413;
sub.f64 fd421, fd419, fd420;
mul.f64 fd422, fd381, fd413;
fma.rn.f64 fd423, fd382, fd412, fd422;
mul.f64 fd424, fd421, fd342;
mul.f64 fd425, fd423, fd348;
mul.f64 fd426, fd421, fd348;
mul.f64 fd427, fd381, fd421;
mul.f64 fd428, fd382, fd423;
sub.f64 fd429, fd427, fd428;
mul.f64 fd430, fd381, fd423;
fma.rn.f64 fd431, fd382, fd421, fd430;
mul.f64 fd432, fd429, fd358;
mul.f64 fd433, fd431, fd364;
mul.f64 fd434, fd429, fd364;
mul.f64 fd435, fd381, fd429;
mul.f64 fd436, fd382, fd431;
sub.f64 fd437, fd435, fd436;
mul.f64 fd438, fd381, fd431;
fma.rn.f64 fd439, fd382, fd429, fd438;
mul.f64 fd440, fd437, fd374;
mul.f64 fd441, fd439, fd380;
mul.f64 fd442, fd437, fd380;
shl.b32 r15, r14, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 1296, r16;
add.f64 fd443, fd270, fd336;
add.f64 fd444, fd268, fd335;
st.shared.v2.f64 [r17], {fd444, fd443};
fma.rn.f64 fd445, fd382, fd350, fd387;
sub.f64 fd446, fd385, fd386;
st.shared.v2.f64 [r17+144], {fd446, fd445};
fma.rn.f64 fd447, fd392, fd366, fd395;
sub.f64 fd448, fd393, fd394;
st.shared.v2.f64 [r17+288], {fd448, fd447};
fma.rn.f64 fd449, fd400, fd341, fd403;
sub.f64 fd450, fd401, fd402;
st.shared.v2.f64 [r17+432], {fd450, fd449};
fma.rn.f64 fd451, fd408, fd357, fd411;
sub.f64 fd452, fd409, fd410;
st.shared.v2.f64 [r17+576], {fd452, fd451};
fma.rn.f64 fd453, fd413, fd373, fd418;
sub.f64 fd454, fd416, fd417;
st.shared.v2.f64 [r17+720], {fd454, fd453};
fma.rn.f64 fd455, fd423, fd342, fd426;
sub.f64 fd456, fd424, fd425;
st.shared.v2.f64 [r17+864], {fd456, fd455};
fma.rn.f64 fd457, fd431, fd358, fd434;
sub.f64 fd458, fd432, fd433;
st.shared.v2.f64 [r17+1008], {fd458, fd457};
fma.rn.f64 fd459, fd439, fd374, fd442;
sub.f64 fd460, fd440, fd441;
st.shared.v2.f64 [r17+1152], {fd460, fd459};
barrier.sync 0;
ld.shared.v2.f64 {fd461, fd462}, [r11];
ld.shared.v2.f64 {fd465, fd466}, [r11+3888];
ld.shared.v2.f64 {fd469, fd470}, [r11+7776];
ld.shared.v2.f64 {fd473, fd474}, [r11+11664];
ld.shared.v2.f64 {fd477, fd478}, [r11+15552];
ld.shared.v2.f64 {fd481, fd482}, [r11+19440];
ld.shared.v2.f64 {fd485, fd486}, [r11+23328];
ld.shared.v2.f64 {fd489, fd490}, [r11+27216];
ld.shared.v2.f64 {fd493, fd494}, [r11+31104];
add.f64 fd497, fd473, fd485;
add.f64 fd498, fd461, fd497;
add.f64 fd499, fd474, fd486;
add.f64 fd500, fd462, fd499;
mul.f64 fd501, fd497, 0d3FE0000000000000;
sub.f64 fd502, fd461, fd501;
sub.f64 fd503, fd474, fd486;
mul.f64 fd504, fd503, 0d3FEBB67AE8584CAA;
add.f64 fd505, fd504, fd502;
sub.f64 fd506, fd502, fd504;
mul.f64 fd507, fd499, 0d3FE0000000000000;
sub.f64 fd508, fd462, fd507;
sub.f64 fd509, fd473, fd485;
mul.f64 fd510, fd509, 0d3FEBB67AE8584CAA;
sub.f64 fd511, fd508, fd510;
add.f64 fd512, fd510, fd508;
add.f64 fd513, fd477, fd489;
add.f64 fd514, fd465, fd513;
add.f64 fd515, fd478, fd490;
add.f64 fd516, fd466, fd515;
mul.f64 fd517, fd513, 0d3FE0000000000000;
sub.f64 fd518, fd465, fd517;
sub.f64 fd519, fd478, fd490;
mul.f64 fd520, fd519, 0d3FEBB67AE8584CAA;
add.f64 fd521, fd520, fd518;
sub.f64 fd522, fd518, fd520;
mul.f64 fd523, fd515, 0d3FE0000000000000;
sub.f64 fd524, fd466, fd523;
sub.f64 fd525, fd477, fd489;
mul.f64 fd526, fd525, 0d3FEBB67AE8584CAA;
sub.f64 fd527, fd524, fd526;
add.f64 fd528, fd526, fd524;
add.f64 fd529, fd481, fd493;
add.f64 fd530, fd469, fd529;
add.f64 fd531, fd482, fd494;
add.f64 fd532, fd470, fd531;
mul.f64 fd533, fd529, 0d3FE0000000000000;
sub.f64 fd534, fd469, fd533;
sub.f64 fd535, fd482, fd494;
mul.f64 fd536, fd535, 0d3FEBB67AE8584CAA;
add.f64 fd537, fd536, fd534;
sub.f64 fd538, fd534, fd536;
mul.f64 fd539, fd531, 0d3FE0000000000000;
sub.f64 fd540, fd470, fd539;
sub.f64 fd541, fd481, fd493;
mul.f64 fd542, fd541, 0d3FEBB67AE8584CAA;
sub.f64 fd543, fd540, fd542;
add.f64 fd544, fd542, fd540;
mul.f64 fd545, fd521, 0d3FE8836FA2CF5039;
mul.f64 fd546, fd527, 0dBFE491B7523C161D;
sub.f64 fd547, fd545, fd546;
mul.f64 fd548, fd527, 0d3FE8836FA2CF5039;
fma.rn.f64 fd549, fd521, 0dBFE491B7523C161D, fd548;
mul.f64 fd550, fd537, 0d3FC63A1A7E0B738A;
mul.f64 fd551, fd543, 0dBFEF838B8C811C17;
sub.f64 fd552, fd550, fd551;
mul.f64 fd553, fd543, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd554, fd537, 0dBFEF838B8C811C17, fd553;
mul.f64 fd555, fd522, 0d3FC63A1A7E0B738A;
mul.f64 fd556, fd528, 0dBFEF838B8C811C17;
sub.f64 fd557, fd555, fd556;
mul.f64 fd558, fd528, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd559, fd522, 0dBFEF838B8C811C17, fd558;
mul.f64 fd560, fd538, 0dBFEE11F642522D1C;
mul.f64 fd561, fd544, 0dBFD5E3A8748A0BF5;
sub.f64 fd562, fd560, fd561;
mul.f64 fd563, fd544, 0dBFEE11F642522D1C;
fma.rn.f64 fd564, fd538, 0dBFD5E3A8748A0BF5, fd563;
add.f64 fd565, fd514, fd530;
add.f64 fd566, fd516, fd532;
mul.f64 fd567, fd565, 0d3FE0000000000000;
sub.f64 fd568, fd498, fd567;
sub.f64 fd569, fd516, fd532;
mul.f64 fd570, fd569, 0d3FEBB67AE8584CAA;
add.f64 fd571, fd570, fd568;
sub.f64 fd572, fd568, fd570;
mul.f64 fd573, fd566, 0d3FE0000000000000;
sub.f64 fd574, fd500, fd573;
sub.f64 fd575, fd514, fd530;
mul.f64 fd576, fd575, 0d3FEBB67AE8584CAA;
sub.f64 fd577, fd574, fd576;
add.f64 fd578, fd576, fd574;
add.f64 fd579, fd547, fd552;
add.f64 fd580, fd505, fd579;
add.f64 fd581, fd549, fd554;
add.f64 fd582, fd511, fd581;
mul.f64 fd583, fd579, 0d3FE0000000000000;
sub.f64 fd584, fd505, fd583;
sub.f64 fd585, fd549, fd554;
mul.f64 fd586, fd585, 0d3FEBB67AE8584CAA;
add.f64 fd587, fd586, fd584;
sub.f64 fd588, fd584, fd586;
mul.f64 fd589, fd581, 0d3FE0000000000000;
sub.f64 fd590, fd511, fd589;
sub.f64 fd591, fd547, fd552;
mul.f64 fd592, fd591, 0d3FEBB67AE8584CAA;
sub.f64 fd593, fd590, fd592;
add.f64 fd594, fd592, fd590;
add.f64 fd595, fd557, fd562;
add.f64 fd596, fd506, fd595;
add.f64 fd597, fd559, fd564;
add.f64 fd598, fd512, fd597;
mul.f64 fd599, fd595, 0d3FE0000000000000;
sub.f64 fd600, fd506, fd599;
sub.f64 fd601, fd559, fd564;
mul.f64 fd602, fd601, 0d3FEBB67AE8584CAA;
add.f64 fd603, fd602, fd600;
sub.f64 fd604, fd600, fd602;
mul.f64 fd605, fd597, 0d3FE0000000000000;
sub.f64 fd606, fd512, fd605;
sub.f64 fd607, fd557, fd562;
mul.f64 fd608, fd607, 0d3FEBB67AE8584CAA;
sub.f64 fd609, fd606, fd608;
add.f64 fd610, fd608, fd606;
mul.wide.u32 rd12, r7, -901412889;
shr.u64 rd13, rd12, 38;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 81;
sub.s32 r20, r7, r19;
mul.wide.u32 rd14, r18, 16;
mov.u64 rd15, %21;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd611, fd612}, [rd16];
mul.f64 fd615, fd611, fd580;
mul.f64 fd616, fd612, fd582;
mul.f64 fd617, fd611, fd582;
mul.f64 fd618, fd611, fd611;
mul.f64 fd619, fd612, fd612;
sub.f64 fd620, fd618, fd619;
mul.f64 fd621, fd612, fd611;
fma.rn.f64 fd622, fd612, fd611, fd621;
mul.f64 fd623, fd620, fd596;
mul.f64 fd624, fd622, fd598;
mul.f64 fd625, fd620, fd598;
mul.f64 fd626, fd611, fd620;
mul.f64 fd627, fd612, fd622;
sub.f64 fd628, fd626, fd627;
mul.f64 fd629, fd611, fd622;
fma.rn.f64 fd630, fd612, fd620, fd629;
mul.f64 fd631, fd628, fd571;
mul.f64 fd632, fd630, fd577;
mul.f64 fd633, fd628, fd577;
mul.f64 fd634, fd611, fd628;
mul.f64 fd635, fd612, fd630;
sub.f64 fd636, fd634, fd635;
mul.f64 fd637, fd611, fd630;
fma.rn.f64 fd638, fd612, fd628, fd637;
mul.f64 fd639, fd636, fd587;
mul.f64 fd640, fd638, fd593;
mul.f64 fd641, fd636, fd593;
ld.global.v2.f64 {fd642, fd643}, [rd16+48];
mul.f64 fd646, fd642, fd603;
mul.f64 fd647, fd643, fd609;
mul.f64 fd648, fd642, fd609;
mul.f64 fd649, fd611, fd642;
mul.f64 fd650, fd612, fd643;
sub.f64 fd651, fd649, fd650;
mul.f64 fd652, fd611, fd643;
fma.rn.f64 fd653, fd612, fd642, fd652;
mul.f64 fd654, fd651, fd572;
mul.f64 fd655, fd653, fd578;
mul.f64 fd656, fd651, fd578;
mul.f64 fd657, fd611, fd651;
mul.f64 fd658, fd612, fd653;
sub.f64 fd659, fd657, fd658;
mul.f64 fd660, fd611, fd653;
fma.rn.f64 fd661, fd612, fd651, fd660;
mul.f64 fd662, fd659, fd588;
mul.f64 fd663, fd661, fd594;
mul.f64 fd664, fd659, fd594;
mul.f64 fd665, fd611, fd659;
mul.f64 fd666, fd612, fd661;
sub.f64 fd667, fd665, fd666;
mul.f64 fd668, fd611, fd661;
fma.rn.f64 fd669, fd612, fd659, fd668;
mul.f64 fd670, fd667, fd604;
mul.f64 fd671, fd669, fd610;
mul.f64 fd672, fd667, fd610;
shl.b32 r21, r20, 4;
add.s32 r22, r8, r21;
barrier.sync 0;
mad.lo.s32 r23, r18, 11664, r22;
add.f64 fd673, fd500, fd566;
add.f64 fd674, fd498, fd565;
st.shared.v2.f64 [r23], {fd674, fd673};
fma.rn.f64 fd675, fd612, fd580, fd617;
sub.f64 fd676, fd615, fd616;
st.shared.v2.f64 [r23+1296], {fd676, fd675};
fma.rn.f64 fd677, fd622, fd596, fd625;
sub.f64 fd678, fd623, fd624;
st.shared.v2.f64 [r23+2592], {fd678, fd677};
fma.rn.f64 fd679, fd630, fd571, fd633;
sub.f64 fd680, fd631, fd632;
st.shared.v2.f64 [r23+3888], {fd680, fd679};
fma.rn.f64 fd681, fd638, fd587, fd641;
sub.f64 fd682, fd639, fd640;
st.shared.v2.f64 [r23+5184], {fd682, fd681};
fma.rn.f64 fd683, fd643, fd603, fd648;
sub.f64 fd684, fd646, fd647;
st.shared.v2.f64 [r23+6480], {fd684, fd683};
fma.rn.f64 fd685, fd653, fd572, fd656;
sub.f64 fd686, fd654, fd655;
st.shared.v2.f64 [r23+7776], {fd686, fd685};
fma.rn.f64 fd687, fd661, fd588, fd664;
sub.f64 fd688, fd662, fd663;
st.shared.v2.f64 [r23+9072], {fd688, fd687};
fma.rn.f64 fd689, fd669, fd604, fd672;
sub.f64 fd690, fd670, fd671;
st.shared.v2.f64 [r23+10368], {fd690, fd689};
barrier.sync 0;
ld.shared.v2.f64 {fd691, fd692}, [r11];
ld.shared.v2.f64 {fd695, fd696}, [r11+3888];
ld.shared.v2.f64 {fd699, fd700}, [r11+7776];
ld.shared.v2.f64 {fd703, fd704}, [r11+11664];
ld.shared.v2.f64 {fd707, fd708}, [r11+15552];
ld.shared.v2.f64 {fd711, fd712}, [r11+19440];
ld.shared.v2.f64 {fd715, fd716}, [r11+23328];
ld.shared.v2.f64 {fd719, fd720}, [r11+27216];
ld.shared.v2.f64 {fd723, fd724}, [r11+31104];
add.f64 fd727, fd703, fd715;
add.f64 fd728, fd704, fd716;
mul.f64 fd729, fd727, 0d3FE0000000000000;
sub.f64 fd730, fd691, fd729;
sub.f64 fd731, fd704, fd716;
mul.f64 fd732, fd731, 0d3FEBB67AE8584CAA;
mul.f64 fd733, fd728, 0d3FE0000000000000;
sub.f64 fd734, fd692, fd733;
sub.f64 fd735, fd703, fd715;
mul.f64 fd736, fd735, 0d3FEBB67AE8584CAA;
add.f64 fd737, fd707, fd719;
add.f64 fd738, fd708, fd720;
mul.f64 fd739, fd737, 0d3FE0000000000000;
sub.f64 fd740, fd695, fd739;
sub.f64 fd741, fd708, fd720;
mul.f64 fd742, fd741, 0d3FEBB67AE8584CAA;
mul.f64 fd743, fd738, 0d3FE0000000000000;
sub.f64 fd744, fd696, fd743;
sub.f64 fd745, fd707, fd719;
mul.f64 fd746, fd745, 0d3FEBB67AE8584CAA;
add.f64 fd747, fd711, fd723;
add.f64 fd748, fd712, fd724;
mul.f64 fd749, fd747, 0d3FE0000000000000;
sub.f64 fd750, fd699, fd749;
sub.f64 fd751, fd712, fd724;
mul.f64 fd752, fd751, 0d3FEBB67AE8584CAA;
mul.f64 fd753, fd748, 0d3FE0000000000000;
sub.f64 fd754, fd700, fd753;
sub.f64 fd755, fd711, fd723;
mul.f64 fd756, fd755, 0d3FEBB67AE8584CAA;
add.f64 %1, fd692, fd728;
add.f64 %0, fd691, fd727;
add.f64 %3, fd696, fd738;
add.f64 %2, fd695, fd737;
add.f64 %5, fd700, fd748;
add.f64 %4, fd699, fd747;
sub.f64 %7, fd734, fd736;
add.f64 %6, fd732, fd730;
sub.f64 %9, fd744, fd746;
add.f64 %8, fd742, fd740;
sub.f64 %11, fd754, fd756;
add.f64 %10, fd752, fd750;
add.f64 %13, fd736, fd734;
sub.f64 %12, fd730, fd732;
add.f64 %15, fd746, fd744;
sub.f64 %14, fd740, fd742;
add.f64 %17, fd756, fd754;
sub.f64 %16, fd750, fd752;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y): "r"(smem), "l"(lut_dp_9_2187), "l"(lut_dp_9_243), "l"(lut_dp_9_27), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<527, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<24>;
.reg .f64 fd<721>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %18;
mad.lo.s32 r3, r1, 17496, r2;
add.f64 fd37, %30, %38;
add.f64 fd38, %22, fd37;
add.f64 fd39, %31, %39;
add.f64 fd40, %23, fd39;
mul.f64 fd41, fd37, 0d3FE0000000000000;
sub.f64 fd42, %22, fd41;
sub.f64 fd43, %31, %39;
mul.f64 fd44, fd43, 0d3FEBB67AE8584CAA;
add.f64 fd45, fd44, fd42;
sub.f64 fd46, fd42, fd44;
mul.f64 fd47, fd39, 0d3FE0000000000000;
sub.f64 fd48, %23, fd47;
sub.f64 fd49, %30, %38;
mul.f64 fd50, fd49, 0d3FEBB67AE8584CAA;
sub.f64 fd51, fd48, fd50;
add.f64 fd52, fd50, fd48;
add.f64 fd53, %32, %40;
add.f64 fd54, %24, fd53;
add.f64 fd55, %34, %42;
add.f64 fd56, %26, fd55;
mul.f64 fd57, fd53, 0d3FE0000000000000;
sub.f64 fd58, %24, fd57;
sub.f64 fd59, %34, %42;
mul.f64 fd60, fd59, 0d3FEBB67AE8584CAA;
add.f64 fd61, fd60, fd58;
sub.f64 fd62, fd58, fd60;
mul.f64 fd63, fd55, 0d3FE0000000000000;
sub.f64 fd64, %26, fd63;
sub.f64 fd65, %32, %40;
mul.f64 fd66, fd65, 0d3FEBB67AE8584CAA;
sub.f64 fd67, fd64, fd66;
add.f64 fd68, fd66, fd64;
add.f64 fd69, %35, %43;
add.f64 fd70, %27, fd69;
add.f64 fd71, %37, %44;
add.f64 fd72, %29, fd71;
mul.f64 fd73, fd69, 0d3FE0000000000000;
sub.f64 fd74, %27, fd73;
sub.f64 fd75, %37, %44;
mul.f64 fd76, fd75, 0d3FEBB67AE8584CAA;
add.f64 fd77, fd76, fd74;
sub.f64 fd78, fd74, fd76;
mul.f64 fd79, fd71, 0d3FE0000000000000;
sub.f64 fd80, %29, fd79;
sub.f64 fd81, %35, %43;
mul.f64 fd82, fd81, 0d3FEBB67AE8584CAA;
sub.f64 fd83, fd80, fd82;
add.f64 fd84, fd82, fd80;
mov.u32 r4, %tid.x;
mul.f64 fd85, fd61, 0d3FE8836FA2CF5039;
mul.f64 fd86, fd67, 0dBFE491B7523C161D;
sub.f64 fd87, fd85, fd86;
mul.f64 fd88, fd67, 0d3FE8836FA2CF5039;
fma.rn.f64 fd89, fd61, 0dBFE491B7523C161D, fd88;
mul.f64 fd90, fd77, 0d3FC63A1A7E0B738A;
mul.f64 fd91, fd83, 0dBFEF838B8C811C17;
sub.f64 fd92, fd90, fd91;
mul.f64 fd93, fd83, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd94, fd77, 0dBFEF838B8C811C17, fd93;
mul.f64 fd95, fd62, 0d3FC63A1A7E0B738A;
mul.f64 fd96, fd68, 0dBFEF838B8C811C17;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd68, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd99, fd62, 0dBFEF838B8C811C17, fd98;
mul.f64 fd100, fd78, 0dBFEE11F642522D1C;
mul.f64 fd101, fd84, 0dBFD5E3A8748A0BF5;
sub.f64 fd102, fd100, fd101;
mul.f64 fd103, fd84, 0dBFEE11F642522D1C;
fma.rn.f64 fd104, fd78, 0dBFD5E3A8748A0BF5, fd103;
add.f64 fd105, fd54, fd70;
add.f64 fd106, fd38, fd105;
add.f64 fd107, fd56, fd72;
add.f64 fd108, fd40, fd107;
mul.f64 fd109, fd105, 0d3FE0000000000000;
sub.f64 fd110, fd38, fd109;
sub.f64 fd111, fd56, fd72;
mul.f64 fd112, fd111, 0d3FEBB67AE8584CAA;
add.f64 fd113, fd112, fd110;
sub.f64 fd114, fd110, fd112;
mul.f64 fd115, fd107, 0d3FE0000000000000;
sub.f64 fd116, fd40, fd115;
sub.f64 fd117, fd54, fd70;
mul.f64 fd118, fd117, 0d3FEBB67AE8584CAA;
sub.f64 fd119, fd116, fd118;
add.f64 fd120, fd118, fd116;
add.f64 fd121, fd87, fd92;
add.f64 fd122, fd45, fd121;
add.f64 fd123, fd89, fd94;
add.f64 fd124, fd51, fd123;
mul.f64 fd125, fd121, 0d3FE0000000000000;
sub.f64 fd126, fd45, fd125;
sub.f64 fd127, fd89, fd94;
mul.f64 fd128, fd127, 0d3FEBB67AE8584CAA;
add.f64 fd129, fd128, fd126;
sub.f64 fd130, fd126, fd128;
mul.f64 fd131, fd123, 0d3FE0000000000000;
sub.f64 fd132, fd51, fd131;
sub.f64 fd133, fd87, fd92;
mul.f64 fd134, fd133, 0d3FEBB67AE8584CAA;
sub.f64 fd135, fd132, fd134;
add.f64 fd136, fd134, fd132;
add.f64 fd137, fd97, fd102;
add.f64 fd138, fd46, fd137;
add.f64 fd139, fd99, fd104;
add.f64 fd140, fd52, fd139;
mul.f64 fd141, fd137, 0d3FE0000000000000;
sub.f64 fd142, fd46, fd141;
sub.f64 fd143, fd99, fd104;
mul.f64 fd144, fd143, 0d3FEBB67AE8584CAA;
add.f64 fd145, fd144, fd142;
sub.f64 fd146, fd142, fd144;
mul.f64 fd147, fd139, 0d3FE0000000000000;
sub.f64 fd148, fd52, fd147;
sub.f64 fd149, fd97, fd102;
mul.f64 fd150, fd149, 0d3FEBB67AE8584CAA;
sub.f64 fd151, fd148, fd150;
add.f64 fd152, fd150, fd148;
mul.wide.u32 rd2, r4, -2032597691;
shr.u64 rd3, rd2, 39;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 243;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %19;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd153, fd154}, [rd6];
mul.f64 fd157, fd153, fd122;
mul.f64 fd158, fd154, fd124;
sub.f64 fd159, fd157, fd158;
mul.f64 fd160, fd153, fd124;
fma.rn.f64 fd161, fd154, fd122, fd160;
mul.f64 fd162, fd153, fd153;
mul.f64 fd163, fd154, fd154;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, fd153;
fma.rn.f64 fd166, fd154, fd153, fd165;
mul.f64 fd167, fd164, fd138;
mul.f64 fd168, fd166, fd140;
sub.f64 fd169, fd167, fd168;
mul.f64 fd170, fd164, fd140;
fma.rn.f64 fd171, fd166, fd138, fd170;
mul.f64 fd172, fd153, fd164;
mul.f64 fd173, fd154, fd166;
sub.f64 fd174, fd172, fd173;
mul.f64 fd175, fd153, fd166;
fma.rn.f64 fd176, fd154, fd164, fd175;
mul.f64 fd177, fd174, fd113;
mul.f64 fd178, fd176, fd119;
sub.f64 fd179, fd177, fd178;
mul.f64 fd180, fd174, fd119;
fma.rn.f64 fd181, fd176, fd113, fd180;
mul.f64 fd182, fd153, fd174;
mul.f64 fd183, fd154, fd176;
sub.f64 fd184, fd182, fd183;
mul.f64 fd185, fd153, fd176;
fma.rn.f64 fd186, fd154, fd174, fd185;
mul.f64 fd187, fd184, fd129;
mul.f64 fd188, fd186, fd135;
sub.f64 fd189, fd187, fd188;
mul.f64 fd190, fd184, fd135;
fma.rn.f64 fd191, fd186, fd129, fd190;
ld.global.v2.f64 {fd192, fd193}, [rd6+3888];
mul.f64 fd196, fd192, fd145;
mul.f64 fd197, fd193, fd151;
sub.f64 fd198, fd196, fd197;
mul.f64 fd199, fd192, fd151;
fma.rn.f64 fd200, fd193, fd145, fd199;
mul.f64 fd201, fd153, fd192;
mul.f64 fd202, fd154, fd193;
sub.f64 fd203, fd201, fd202;
mul.f64 fd204, fd153, fd193;
fma.rn.f64 fd205, fd154, fd192, fd204;
mul.f64 fd206, fd203, fd114;
mul.f64 fd207, fd205, fd120;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd203, fd120;
fma.rn.f64 fd210, fd205, fd114, fd209;
mul.f64 fd211, fd153, fd203;
mul.f64 fd212, fd154, fd205;
sub.f64 fd213, fd211, fd212;
mul.f64 fd214, fd153, fd205;
fma.rn.f64 fd215, fd154, fd203, fd214;
mul.f64 fd216, fd213, fd130;
mul.f64 fd217, fd215, fd136;
sub.f64 fd218, fd216, fd217;
mul.f64 fd219, fd213, fd136;
fma.rn.f64 fd220, fd215, fd130, fd219;
mul.f64 fd221, fd153, fd213;
mul.f64 fd222, fd154, fd215;
sub.f64 fd223, fd221, fd222;
mul.f64 fd224, fd153, fd215;
fma.rn.f64 fd225, fd154, fd213, fd224;
mul.f64 fd226, fd223, fd146;
mul.f64 fd227, fd225, fd152;
sub.f64 fd228, fd226, fd227;
mul.f64 fd229, fd223, fd152;
fma.rn.f64 fd230, fd225, fd146, fd229;
mad.lo.s32 r8, r5, 17496, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 72, r8;
st.shared.f64 [r9], fd106;
st.shared.f64 [r9+8], fd159;
st.shared.f64 [r9+16], fd169;
st.shared.f64 [r9+24], fd179;
st.shared.f64 [r9+32], fd189;
st.shared.f64 [r9+40], fd198;
st.shared.f64 [r9+48], fd208;
st.shared.f64 [r9+56], fd218;
st.shared.f64 [r9+64], fd228;
barrier.sync 0;
shl.b32 r10, r7, 6;
sub.s32 r11, r9, r10;
ld.shared.f64 fd231, [r11];
ld.shared.f64 fd232, [r11+1944];
ld.shared.f64 fd233, [r11+3888];
ld.shared.f64 fd234, [r11+5832];
ld.shared.f64 fd235, [r11+7776];
ld.shared.f64 fd236, [r11+9720];
ld.shared.f64 fd237, [r11+11664];
ld.shared.f64 fd238, [r11+13608];
ld.shared.f64 fd239, [r11+15552];
barrier.sync 0;
st.shared.f64 [r9], fd108;
st.shared.f64 [r9+8], fd161;
st.shared.f64 [r9+16], fd171;
st.shared.f64 [r9+24], fd181;
st.shared.f64 [r9+32], fd191;
st.shared.f64 [r9+40], fd200;
st.shared.f64 [r9+48], fd210;
st.shared.f64 [r9+56], fd220;
st.shared.f64 [r9+64], fd230;
barrier.sync 0;
ld.shared.f64 fd240, [r11];
ld.shared.f64 fd241, [r11+1944];
ld.shared.f64 fd242, [r11+3888];
ld.shared.f64 fd243, [r11+5832];
ld.shared.f64 fd244, [r11+7776];
ld.shared.f64 fd245, [r11+9720];
ld.shared.f64 fd246, [r11+11664];
ld.shared.f64 fd247, [r11+13608];
ld.shared.f64 fd248, [r11+15552];
add.f64 fd249, fd234, fd237;
add.f64 fd250, fd231, fd249;
add.f64 fd251, fd243, fd246;
add.f64 fd252, fd240, fd251;
mul.f64 fd253, fd249, 0d3FE0000000000000;
sub.f64 fd254, fd231, fd253;
sub.f64 fd255, fd243, fd246;
mul.f64 fd256, fd255, 0d3FEBB67AE8584CAA;
add.f64 fd257, fd256, fd254;
sub.f64 fd258, fd254, fd256;
mul.f64 fd259, fd251, 0d3FE0000000000000;
sub.f64 fd260, fd240, fd259;
sub.f64 fd261, fd234, fd237;
mul.f64 fd262, fd261, 0d3FEBB67AE8584CAA;
sub.f64 fd263, fd260, fd262;
add.f64 fd264, fd262, fd260;
add.f64 fd265, fd235, fd238;
add.f64 fd266, fd232, fd265;
add.f64 fd267, fd244, fd247;
add.f64 fd268, fd241, fd267;
mul.f64 fd269, fd265, 0d3FE0000000000000;
sub.f64 fd270, fd232, fd269;
sub.f64 fd271, fd244, fd247;
mul.f64 fd272, fd271, 0d3FEBB67AE8584CAA;
add.f64 fd273, fd272, fd270;
sub.f64 fd274, fd270, fd272;
mul.f64 fd275, fd267, 0d3FE0000000000000;
sub.f64 fd276, fd241, fd275;
sub.f64 fd277, fd235, fd238;
mul.f64 fd278, fd277, 0d3FEBB67AE8584CAA;
sub.f64 fd279, fd276, fd278;
add.f64 fd280, fd278, fd276;
add.f64 fd281, fd236, fd239;
add.f64 fd282, fd233, fd281;
add.f64 fd283, fd245, fd248;
add.f64 fd284, fd242, fd283;
mul.f64 fd285, fd281, 0d3FE0000000000000;
sub.f64 fd286, fd233, fd285;
sub.f64 fd287, fd245, fd248;
mul.f64 fd288, fd287, 0d3FEBB67AE8584CAA;
add.f64 fd289, fd288, fd286;
sub.f64 fd290, fd286, fd288;
mul.f64 fd291, fd283, 0d3FE0000000000000;
sub.f64 fd292, fd242, fd291;
sub.f64 fd293, fd236, fd239;
mul.f64 fd294, fd293, 0d3FEBB67AE8584CAA;
sub.f64 fd295, fd292, fd294;
add.f64 fd296, fd294, fd292;
mul.f64 fd297, fd273, 0d3FE8836FA2CF5039;
mul.f64 fd298, fd279, 0dBFE491B7523C161D;
sub.f64 fd299, fd297, fd298;
mul.f64 fd300, fd279, 0d3FE8836FA2CF5039;
fma.rn.f64 fd301, fd273, 0dBFE491B7523C161D, fd300;
mul.f64 fd302, fd289, 0d3FC63A1A7E0B738A;
mul.f64 fd303, fd295, 0dBFEF838B8C811C17;
sub.f64 fd304, fd302, fd303;
mul.f64 fd305, fd295, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd306, fd289, 0dBFEF838B8C811C17, fd305;
mul.f64 fd307, fd274, 0d3FC63A1A7E0B738A;
mul.f64 fd308, fd280, 0dBFEF838B8C811C17;
sub.f64 fd309, fd307, fd308;
mul.f64 fd310, fd280, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd311, fd274, 0dBFEF838B8C811C17, fd310;
mul.f64 fd312, fd290, 0dBFEE11F642522D1C;
mul.f64 fd313, fd296, 0dBFD5E3A8748A0BF5;
sub.f64 fd314, fd312, fd313;
mul.f64 fd315, fd296, 0dBFEE11F642522D1C;
fma.rn.f64 fd316, fd290, 0dBFD5E3A8748A0BF5, fd315;
add.f64 fd317, fd266, fd282;
add.f64 fd318, fd250, fd317;
add.f64 fd319, fd268, fd284;
add.f64 fd320, fd252, fd319;
mul.f64 fd321, fd317, 0d3FE0000000000000;
sub.f64 fd322, fd250, fd321;
sub.f64 fd323, fd268, fd284;
mul.f64 fd324, fd323, 0d3FEBB67AE8584CAA;
add.f64 fd325, fd324, fd322;
sub.f64 fd326, fd322, fd324;
mul.f64 fd327, fd319, 0d3FE0000000000000;
sub.f64 fd328, fd252, fd327;
sub.f64 fd329, fd266, fd282;
mul.f64 fd330, fd329, 0d3FEBB67AE8584CAA;
sub.f64 fd331, fd328, fd330;
add.f64 fd332, fd330, fd328;
add.f64 fd333, fd299, fd304;
add.f64 fd334, fd257, fd333;
add.f64 fd335, fd301, fd306;
add.f64 fd336, fd263, fd335;
mul.f64 fd337, fd333, 0d3FE0000000000000;
sub.f64 fd338, fd257, fd337;
sub.f64 fd339, fd301, fd306;
mul.f64 fd340, fd339, 0d3FEBB67AE8584CAA;
add.f64 fd341, fd340, fd338;
sub.f64 fd342, fd338, fd340;
mul.f64 fd343, fd335, 0d3FE0000000000000;
sub.f64 fd344, fd263, fd343;
sub.f64 fd345, fd299, fd304;
mul.f64 fd346, fd345, 0d3FEBB67AE8584CAA;
sub.f64 fd347, fd344, fd346;
add.f64 fd348, fd346, fd344;
add.f64 fd349, fd309, fd314;
add.f64 fd350, fd258, fd349;
add.f64 fd351, fd311, fd316;
add.f64 fd352, fd264, fd351;
mul.f64 fd353, fd349, 0d3FE0000000000000;
sub.f64 fd354, fd258, fd353;
sub.f64 fd355, fd311, fd316;
mul.f64 fd356, fd355, 0d3FEBB67AE8584CAA;
add.f64 fd357, fd356, fd354;
sub.f64 fd358, fd354, fd356;
mul.f64 fd359, fd351, 0d3FE0000000000000;
sub.f64 fd360, fd264, fd359;
sub.f64 fd361, fd309, fd314;
mul.f64 fd362, fd361, 0d3FEBB67AE8584CAA;
sub.f64 fd363, fd360, fd362;
add.f64 fd364, fd362, fd360;
mul.wide.u32 rd7, r7, 954437177;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 9;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %20;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd365, fd366}, [rd11];
mul.f64 fd369, fd365, fd334;
mul.f64 fd370, fd366, fd336;
sub.f64 fd371, fd369, fd370;
mul.f64 fd372, fd365, fd336;
fma.rn.f64 fd373, fd366, fd334, fd372;
mul.f64 fd374, fd365, fd365;
mul.f64 fd375, fd366, fd366;
sub.f64 fd376, fd374, fd375;
mul.f64 fd377, fd366, fd365;
fma.rn.f64 fd378, fd366, fd365, fd377;
mul.f64 fd379, fd376, fd350;
mul.f64 fd380, fd378, fd352;
sub.f64 fd381, fd379, fd380;
mul.f64 fd382, fd376, fd352;
fma.rn.f64 fd383, fd378, fd350, fd382;
mul.f64 fd384, fd365, fd376;
mul.f64 fd385, fd366, fd378;
sub.f64 fd386, fd384, fd385;
mul.f64 fd387, fd365, fd378;
fma.rn.f64 fd388, fd366, fd376, fd387;
mul.f64 fd389, fd386, fd325;
mul.f64 fd390, fd388, fd331;
sub.f64 fd391, fd389, fd390;
mul.f64 fd392, fd386, fd331;
fma.rn.f64 fd393, fd388, fd325, fd392;
mul.f64 fd394, fd365, fd386;
mul.f64 fd395, fd366, fd388;
sub.f64 fd396, fd394, fd395;
mul.f64 fd397, fd365, fd388;
fma.rn.f64 fd398, fd366, fd386, fd397;
mul.f64 fd399, fd396, fd341;
mul.f64 fd400, fd398, fd347;
sub.f64 fd401, fd399, fd400;
mul.f64 fd402, fd396, fd347;
fma.rn.f64 fd403, fd398, fd341, fd402;
ld.global.v2.f64 {fd404, fd405}, [rd11+432];
mul.f64 fd408, fd404, fd357;
mul.f64 fd409, fd405, fd363;
sub.f64 fd410, fd408, fd409;
mul.f64 fd411, fd404, fd363;
fma.rn.f64 fd412, fd405, fd357, fd411;
mul.f64 fd413, fd365, fd404;
mul.f64 fd414, fd366, fd405;
sub.f64 fd415, fd413, fd414;
mul.f64 fd416, fd365, fd405;
fma.rn.f64 fd417, fd366, fd404, fd416;
mul.f64 fd418, fd415, fd326;
mul.f64 fd419, fd417, fd332;
sub.f64 fd420, fd418, fd419;
mul.f64 fd421, fd415, fd332;
fma.rn.f64 fd422, fd417, fd326, fd421;
mul.f64 fd423, fd365, fd415;
mul.f64 fd424, fd366, fd417;
sub.f64 fd425, fd423, fd424;
mul.f64 fd426, fd365, fd417;
fma.rn.f64 fd427, fd366, fd415, fd426;
mul.f64 fd428, fd425, fd342;
mul.f64 fd429, fd427, fd348;
sub.f64 fd430, fd428, fd429;
mul.f64 fd431, fd425, fd348;
fma.rn.f64 fd432, fd427, fd342, fd431;
mul.f64 fd433, fd365, fd425;
mul.f64 fd434, fd366, fd427;
sub.f64 fd435, fd433, fd434;
mul.f64 fd436, fd365, fd427;
fma.rn.f64 fd437, fd366, fd425, fd436;
mul.f64 fd438, fd435, fd358;
mul.f64 fd439, fd437, fd364;
sub.f64 fd440, fd438, fd439;
mul.f64 fd441, fd435, fd364;
fma.rn.f64 fd442, fd437, fd358, fd441;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 648, r16;
st.shared.f64 [r17], fd318;
st.shared.f64 [r17+72], fd371;
st.shared.f64 [r17+144], fd381;
st.shared.f64 [r17+216], fd391;
st.shared.f64 [r17+288], fd401;
st.shared.f64 [r17+360], fd410;
st.shared.f64 [r17+432], fd420;
st.shared.f64 [r17+504], fd430;
st.shared.f64 [r17+576], fd440;
barrier.sync 0;
ld.shared.f64 fd443, [r11];
ld.shared.f64 fd444, [r11+1944];
ld.shared.f64 fd445, [r11+3888];
ld.shared.f64 fd446, [r11+5832];
ld.shared.f64 fd447, [r11+7776];
ld.shared.f64 fd448, [r11+9720];
ld.shared.f64 fd449, [r11+11664];
ld.shared.f64 fd450, [r11+13608];
ld.shared.f64 fd451, [r11+15552];
barrier.sync 0;
st.shared.f64 [r17], fd320;
st.shared.f64 [r17+72], fd373;
st.shared.f64 [r17+144], fd383;
st.shared.f64 [r17+216], fd393;
st.shared.f64 [r17+288], fd403;
st.shared.f64 [r17+360], fd412;
st.shared.f64 [r17+432], fd422;
st.shared.f64 [r17+504], fd432;
st.shared.f64 [r17+576], fd442;
barrier.sync 0;
ld.shared.f64 fd452, [r11];
ld.shared.f64 fd453, [r11+1944];
ld.shared.f64 fd454, [r11+3888];
ld.shared.f64 fd455, [r11+5832];
ld.shared.f64 fd456, [r11+7776];
ld.shared.f64 fd457, [r11+9720];
ld.shared.f64 fd458, [r11+11664];
ld.shared.f64 fd459, [r11+13608];
ld.shared.f64 fd460, [r11+15552];
add.f64 fd461, fd446, fd449;
add.f64 fd462, fd443, fd461;
add.f64 fd463, fd455, fd458;
add.f64 fd464, fd452, fd463;
mul.f64 fd465, fd461, 0d3FE0000000000000;
sub.f64 fd466, fd443, fd465;
sub.f64 fd467, fd455, fd458;
mul.f64 fd468, fd467, 0d3FEBB67AE8584CAA;
add.f64 fd469, fd468, fd466;
sub.f64 fd470, fd466, fd468;
mul.f64 fd471, fd463, 0d3FE0000000000000;
sub.f64 fd472, fd452, fd471;
sub.f64 fd473, fd446, fd449;
mul.f64 fd474, fd473, 0d3FEBB67AE8584CAA;
sub.f64 fd475, fd472, fd474;
add.f64 fd476, fd474, fd472;
add.f64 fd477, fd447, fd450;
add.f64 fd478, fd444, fd477;
add.f64 fd479, fd456, fd459;
add.f64 fd480, fd453, fd479;
mul.f64 fd481, fd477, 0d3FE0000000000000;
sub.f64 fd482, fd444, fd481;
sub.f64 fd483, fd456, fd459;
mul.f64 fd484, fd483, 0d3FEBB67AE8584CAA;
add.f64 fd485, fd484, fd482;
sub.f64 fd486, fd482, fd484;
mul.f64 fd487, fd479, 0d3FE0000000000000;
sub.f64 fd488, fd453, fd487;
sub.f64 fd489, fd447, fd450;
mul.f64 fd490, fd489, 0d3FEBB67AE8584CAA;
sub.f64 fd491, fd488, fd490;
add.f64 fd492, fd490, fd488;
add.f64 fd493, fd448, fd451;
add.f64 fd494, fd445, fd493;
add.f64 fd495, fd457, fd460;
add.f64 fd496, fd454, fd495;
mul.f64 fd497, fd493, 0d3FE0000000000000;
sub.f64 fd498, fd445, fd497;
sub.f64 fd499, fd457, fd460;
mul.f64 fd500, fd499, 0d3FEBB67AE8584CAA;
add.f64 fd501, fd500, fd498;
sub.f64 fd502, fd498, fd500;
mul.f64 fd503, fd495, 0d3FE0000000000000;
sub.f64 fd504, fd454, fd503;
sub.f64 fd505, fd448, fd451;
mul.f64 fd506, fd505, 0d3FEBB67AE8584CAA;
sub.f64 fd507, fd504, fd506;
add.f64 fd508, fd506, fd504;
mul.f64 fd509, fd485, 0d3FE8836FA2CF5039;
mul.f64 fd510, fd491, 0dBFE491B7523C161D;
sub.f64 fd511, fd509, fd510;
mul.f64 fd512, fd491, 0d3FE8836FA2CF5039;
fma.rn.f64 fd513, fd485, 0dBFE491B7523C161D, fd512;
mul.f64 fd514, fd501, 0d3FC63A1A7E0B738A;
mul.f64 fd515, fd507, 0dBFEF838B8C811C17;
sub.f64 fd516, fd514, fd515;
mul.f64 fd517, fd507, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd518, fd501, 0dBFEF838B8C811C17, fd517;
mul.f64 fd519, fd486, 0d3FC63A1A7E0B738A;
mul.f64 fd520, fd492, 0dBFEF838B8C811C17;
sub.f64 fd521, fd519, fd520;
mul.f64 fd522, fd492, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd523, fd486, 0dBFEF838B8C811C17, fd522;
mul.f64 fd524, fd502, 0dBFEE11F642522D1C;
mul.f64 fd525, fd508, 0dBFD5E3A8748A0BF5;
sub.f64 fd526, fd524, fd525;
mul.f64 fd527, fd508, 0dBFEE11F642522D1C;
fma.rn.f64 fd528, fd502, 0dBFD5E3A8748A0BF5, fd527;
add.f64 fd529, fd478, fd494;
add.f64 fd530, fd462, fd529;
add.f64 fd531, fd480, fd496;
add.f64 fd532, fd464, fd531;
mul.f64 fd533, fd529, 0d3FE0000000000000;
sub.f64 fd534, fd462, fd533;
sub.f64 fd535, fd480, fd496;
mul.f64 fd536, fd535, 0d3FEBB67AE8584CAA;
add.f64 fd537, fd536, fd534;
sub.f64 fd538, fd534, fd536;
mul.f64 fd539, fd531, 0d3FE0000000000000;
sub.f64 fd540, fd464, fd539;
sub.f64 fd541, fd478, fd494;
mul.f64 fd542, fd541, 0d3FEBB67AE8584CAA;
sub.f64 fd543, fd540, fd542;
add.f64 fd544, fd542, fd540;
add.f64 fd545, fd511, fd516;
add.f64 fd546, fd469, fd545;
add.f64 fd547, fd513, fd518;
add.f64 fd548, fd475, fd547;
mul.f64 fd549, fd545, 0d3FE0000000000000;
sub.f64 fd550, fd469, fd549;
sub.f64 fd551, fd513, fd518;
mul.f64 fd552, fd551, 0d3FEBB67AE8584CAA;
add.f64 fd553, fd552, fd550;
sub.f64 fd554, fd550, fd552;
mul.f64 fd555, fd547, 0d3FE0000000000000;
sub.f64 fd556, fd475, fd555;
sub.f64 fd557, fd511, fd516;
mul.f64 fd558, fd557, 0d3FEBB67AE8584CAA;
sub.f64 fd559, fd556, fd558;
add.f64 fd560, fd558, fd556;
add.f64 fd561, fd521, fd526;
add.f64 fd562, fd470, fd561;
add.f64 fd563, fd523, fd528;
add.f64 fd564, fd476, fd563;
mul.f64 fd565, fd561, 0d3FE0000000000000;
sub.f64 fd566, fd470, fd565;
sub.f64 fd567, fd523, fd528;
mul.f64 fd568, fd567, 0d3FEBB67AE8584CAA;
add.f64 fd569, fd568, fd566;
sub.f64 fd570, fd566, fd568;
mul.f64 fd571, fd563, 0d3FE0000000000000;
sub.f64 fd572, fd476, fd571;
sub.f64 fd573, fd521, fd526;
mul.f64 fd574, fd573, 0d3FEBB67AE8584CAA;
sub.f64 fd575, fd572, fd574;
add.f64 fd576, fd574, fd572;
mul.wide.u32 rd12, r7, -901412889;
shr.u64 rd13, rd12, 38;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 81;
sub.s32 r20, r7, r19;
mul.wide.u32 rd14, r18, 16;
mov.u64 rd15, %21;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd577, fd578}, [rd16];
mul.f64 fd581, fd577, fd546;
mul.f64 fd582, fd578, fd548;
sub.f64 fd583, fd581, fd582;
mul.f64 fd584, fd577, fd548;
fma.rn.f64 fd585, fd578, fd546, fd584;
mul.f64 fd586, fd577, fd577;
mul.f64 fd587, fd578, fd578;
sub.f64 fd588, fd586, fd587;
mul.f64 fd589, fd578, fd577;
fma.rn.f64 fd590, fd578, fd577, fd589;
mul.f64 fd591, fd588, fd562;
mul.f64 fd592, fd590, fd564;
sub.f64 fd593, fd591, fd592;
mul.f64 fd594, fd588, fd564;
fma.rn.f64 fd595, fd590, fd562, fd594;
mul.f64 fd596, fd577, fd588;
mul.f64 fd597, fd578, fd590;
sub.f64 fd598, fd596, fd597;
mul.f64 fd599, fd577, fd590;
fma.rn.f64 fd600, fd578, fd588, fd599;
mul.f64 fd601, fd598, fd537;
mul.f64 fd602, fd600, fd543;
sub.f64 fd603, fd601, fd602;
mul.f64 fd604, fd598, fd543;
fma.rn.f64 fd605, fd600, fd537, fd604;
mul.f64 fd606, fd577, fd598;
mul.f64 fd607, fd578, fd600;
sub.f64 fd608, fd606, fd607;
mul.f64 fd609, fd577, fd600;
fma.rn.f64 fd610, fd578, fd598, fd609;
mul.f64 fd611, fd608, fd553;
mul.f64 fd612, fd610, fd559;
sub.f64 fd613, fd611, fd612;
mul.f64 fd614, fd608, fd559;
fma.rn.f64 fd615, fd610, fd553, fd614;
ld.global.v2.f64 {fd616, fd617}, [rd16+48];
mul.f64 fd620, fd616, fd569;
mul.f64 fd621, fd617, fd575;
sub.f64 fd622, fd620, fd621;
mul.f64 fd623, fd616, fd575;
fma.rn.f64 fd624, fd617, fd569, fd623;
mul.f64 fd625, fd577, fd616;
mul.f64 fd626, fd578, fd617;
sub.f64 fd627, fd625, fd626;
mul.f64 fd628, fd577, fd617;
fma.rn.f64 fd629, fd578, fd616, fd628;
mul.f64 fd630, fd627, fd538;
mul.f64 fd631, fd629, fd544;
sub.f64 fd632, fd630, fd631;
mul.f64 fd633, fd627, fd544;
fma.rn.f64 fd634, fd629, fd538, fd633;
mul.f64 fd635, fd577, fd627;
mul.f64 fd636, fd578, fd629;
sub.f64 fd637, fd635, fd636;
mul.f64 fd638, fd577, fd629;
fma.rn.f64 fd639, fd578, fd627, fd638;
mul.f64 fd640, fd637, fd554;
mul.f64 fd641, fd639, fd560;
sub.f64 fd642, fd640, fd641;
mul.f64 fd643, fd637, fd560;
fma.rn.f64 fd644, fd639, fd554, fd643;
mul.f64 fd645, fd577, fd637;
mul.f64 fd646, fd578, fd639;
sub.f64 fd647, fd645, fd646;
mul.f64 fd648, fd577, fd639;
fma.rn.f64 fd649, fd578, fd637, fd648;
mul.f64 fd650, fd647, fd570;
mul.f64 fd651, fd649, fd576;
sub.f64 fd652, fd650, fd651;
mul.f64 fd653, fd647, fd576;
fma.rn.f64 fd654, fd649, fd570, fd653;
shl.b32 r21, r20, 3;
add.s32 r22, r8, r21;
barrier.sync 0;
mad.lo.s32 r23, r18, 5832, r22;
st.shared.f64 [r23], fd530;
st.shared.f64 [r23+648], fd583;
st.shared.f64 [r23+1296], fd593;
st.shared.f64 [r23+1944], fd603;
st.shared.f64 [r23+2592], fd613;
st.shared.f64 [r23+3240], fd622;
st.shared.f64 [r23+3888], fd632;
st.shared.f64 [r23+4536], fd642;
st.shared.f64 [r23+5184], fd652;
barrier.sync 0;
ld.shared.f64 fd655, [r11];
ld.shared.f64 fd656, [r11+1944];
ld.shared.f64 fd657, [r11+3888];
ld.shared.f64 fd658, [r11+5832];
ld.shared.f64 fd659, [r11+7776];
ld.shared.f64 fd660, [r11+9720];
ld.shared.f64 fd661, [r11+11664];
ld.shared.f64 fd662, [r11+13608];
ld.shared.f64 fd663, [r11+15552];
barrier.sync 0;
st.shared.f64 [r23], fd532;
st.shared.f64 [r23+648], fd585;
st.shared.f64 [r23+1296], fd595;
st.shared.f64 [r23+1944], fd605;
st.shared.f64 [r23+2592], fd615;
st.shared.f64 [r23+3240], fd624;
st.shared.f64 [r23+3888], fd634;
st.shared.f64 [r23+4536], fd644;
st.shared.f64 [r23+5184], fd654;
barrier.sync 0;
ld.shared.f64 fd664, [r11];
ld.shared.f64 fd665, [r11+1944];
ld.shared.f64 fd666, [r11+3888];
ld.shared.f64 fd667, [r11+5832];
ld.shared.f64 fd668, [r11+7776];
ld.shared.f64 fd669, [r11+9720];
ld.shared.f64 fd670, [r11+11664];
ld.shared.f64 fd671, [r11+13608];
ld.shared.f64 fd672, [r11+15552];
add.f64 fd673, fd658, fd661;
add.f64 fd674, fd667, fd670;
mul.f64 fd675, fd673, 0d3FE0000000000000;
sub.f64 fd676, fd655, fd675;
sub.f64 fd677, fd667, fd670;
mul.f64 fd678, fd677, 0d3FEBB67AE8584CAA;
mul.f64 fd679, fd674, 0d3FE0000000000000;
sub.f64 fd680, fd664, fd679;
sub.f64 fd681, fd658, fd661;
mul.f64 fd682, fd681, 0d3FEBB67AE8584CAA;
add.f64 fd683, fd659, fd662;
add.f64 fd684, fd668, fd671;
mul.f64 fd685, fd683, 0d3FE0000000000000;
sub.f64 fd686, fd656, fd685;
sub.f64 fd687, fd668, fd671;
mul.f64 fd688, fd687, 0d3FEBB67AE8584CAA;
mul.f64 fd689, fd684, 0d3FE0000000000000;
sub.f64 fd690, fd665, fd689;
sub.f64 fd691, fd659, fd662;
mul.f64 fd692, fd691, 0d3FEBB67AE8584CAA;
add.f64 fd693, fd660, fd663;
add.f64 fd694, fd669, fd672;
mul.f64 fd695, fd693, 0d3FE0000000000000;
sub.f64 fd696, fd657, fd695;
sub.f64 fd697, fd669, fd672;
mul.f64 fd698, fd697, 0d3FEBB67AE8584CAA;
mul.f64 fd699, fd694, 0d3FE0000000000000;
sub.f64 fd700, fd666, fd699;
sub.f64 fd701, fd660, fd663;
mul.f64 fd702, fd701, 0d3FEBB67AE8584CAA;
add.f64 %0, fd655, fd673;
add.f64 %1, fd664, fd674;
add.f64 %2, fd656, fd683;
add.f64 %3, fd665, fd684;
add.f64 %4, fd657, fd693;
add.f64 %5, fd666, fd694;
add.f64 %6, fd678, fd676;
sub.f64 %7, fd680, fd682;
add.f64 %8, fd688, fd686;
sub.f64 %9, fd690, fd692;
add.f64 %10, fd698, fd696;
sub.f64 %11, fd700, fd702;
sub.f64 %12, fd676, fd678;
add.f64 %13, fd682, fd680;
sub.f64 %14, fd686, fd688;
add.f64 %15, fd692, fd690;
sub.f64 %16, fd696, fd698;
add.f64 %17, fd702, fd700;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y): "r"(smem), "l"(lut_dp_9_2187), "l"(lut_dp_9_243), "l"(lut_dp_9_27), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<529, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<46>;
.reg .f64 fd<269>;
.reg .b64 rd<32>;
mov.u32 r1, %tid.y;
mov.u32 r2, %6;
mad.lo.s32 r3, r1, 17496, r2;
mov.u32 r4, %tid.x;
add.f64 fd13, %15, %18;
add.f64 fd14, %13, fd13;
add.f64 fd15, %17, %19;
add.f64 fd16, %14, fd15;
mul.f64 fd17, fd13, 0d3FE0000000000000;
sub.f64 fd18, %13, fd17;
sub.f64 fd19, %17, %19;
mul.f64 fd20, fd19, 0d3FEBB67AE8584CAA;
add.f64 fd21, fd20, fd18;
sub.f64 fd22, fd18, fd20;
mul.f64 fd23, fd15, 0d3FE0000000000000;
sub.f64 fd24, %14, fd23;
sub.f64 fd25, %15, %18;
mul.f64 fd26, fd25, 0d3FEBB67AE8584CAA;
sub.f64 fd27, fd24, fd26;
add.f64 fd28, fd26, fd24;
mul.wide.u32 rd2, r4, 1508246403;
shr.u64 rd3, rd2, 40;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 729;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 17496, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %7;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd29, fd30}, [rd6];
mul.f64 fd33, fd29, fd21;
mul.f64 fd34, fd30, fd27;
sub.f64 fd35, fd33, fd34;
mul.f64 fd36, fd29, fd27;
fma.rn.f64 fd37, fd30, fd21, fd36;
ld.global.v2.f64 {fd38, fd39}, [rd6+11664];
mul.f64 fd42, fd38, fd22;
mul.f64 fd43, fd39, fd28;
sub.f64 fd44, fd42, fd43;
mul.f64 fd45, fd38, fd28;
fma.rn.f64 fd46, fd39, fd22, fd45;
barrier.sync 0;
mad.lo.s32 r9, r7, 24, r8;
st.shared.f64 [r9], fd14;
st.shared.f64 [r9+8], fd35;
st.shared.f64 [r9+16], fd44;
barrier.sync 0;
shl.b32 r10, r7, 4;
sub.s32 r11, r9, r10;
ld.shared.f64 fd47, [r11];
ld.shared.f64 fd48, [r11+5832];
ld.shared.f64 fd49, [r11+11664];
barrier.sync 0;
st.shared.f64 [r9], fd16;
st.shared.f64 [r9+8], fd37;
st.shared.f64 [r9+16], fd46;
barrier.sync 0;
ld.shared.f64 fd50, [r11];
ld.shared.f64 fd51, [r11+5832];
ld.shared.f64 fd52, [r11+11664];
add.f64 fd53, fd48, fd49;
add.f64 fd54, fd47, fd53;
add.f64 fd55, fd51, fd52;
add.f64 fd56, fd50, fd55;
mul.f64 fd57, fd53, 0d3FE0000000000000;
sub.f64 fd58, fd47, fd57;
sub.f64 fd59, fd51, fd52;
mul.f64 fd60, fd59, 0d3FEBB67AE8584CAA;
add.f64 fd61, fd60, fd58;
sub.f64 fd62, fd58, fd60;
mul.f64 fd63, fd55, 0d3FE0000000000000;
sub.f64 fd64, fd50, fd63;
sub.f64 fd65, fd48, fd49;
mul.f64 fd66, fd65, 0d3FEBB67AE8584CAA;
sub.f64 fd67, fd64, fd66;
add.f64 fd68, fd66, fd64;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 3;
sub.s32 r14, r7, r13;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %8;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd69, fd70}, [rd11];
mul.f64 fd73, fd69, fd61;
mul.f64 fd74, fd70, fd67;
sub.f64 fd75, fd73, fd74;
mul.f64 fd76, fd69, fd67;
fma.rn.f64 fd77, fd70, fd61, fd76;
ld.global.v2.f64 {fd78, fd79}, [rd11+3888];
mul.f64 fd82, fd78, fd62;
mul.f64 fd83, fd79, fd68;
sub.f64 fd84, fd82, fd83;
mul.f64 fd85, fd78, fd68;
fma.rn.f64 fd86, fd79, fd62, fd85;
barrier.sync 0;
mad.lo.s32 r17, r12, 72, r16;
st.shared.f64 [r17], fd54;
st.shared.f64 [r17+24], fd75;
st.shared.f64 [r17+48], fd84;
barrier.sync 0;
ld.shared.f64 fd87, [r11];
ld.shared.f64 fd88, [r11+5832];
ld.shared.f64 fd89, [r11+11664];
barrier.sync 0;
st.shared.f64 [r17], fd56;
st.shared.f64 [r17+24], fd77;
st.shared.f64 [r17+48], fd86;
barrier.sync 0;
ld.shared.f64 fd90, [r11];
ld.shared.f64 fd91, [r11+5832];
ld.shared.f64 fd92, [r11+11664];
add.f64 fd93, fd88, fd89;
add.f64 fd94, fd87, fd93;
add.f64 fd95, fd91, fd92;
add.f64 fd96, fd90, fd95;
mul.f64 fd97, fd93, 0d3FE0000000000000;
sub.f64 fd98, fd87, fd97;
sub.f64 fd99, fd91, fd92;
mul.f64 fd100, fd99, 0d3FEBB67AE8584CAA;
add.f64 fd101, fd100, fd98;
sub.f64 fd102, fd98, fd100;
mul.f64 fd103, fd95, 0d3FE0000000000000;
sub.f64 fd104, fd90, fd103;
sub.f64 fd105, fd88, fd89;
mul.f64 fd106, fd105, 0d3FEBB67AE8584CAA;
sub.f64 fd107, fd104, fd106;
add.f64 fd108, fd106, fd104;
mul.wide.u32 rd12, r7, 954437177;
shr.u64 rd13, rd12, 33;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 9;
sub.s32 r20, r7, r19;
shl.b32 r21, r20, 3;
add.s32 r22, r8, r21;
mul.wide.u32 rd14, r18, 16;
mov.u64 rd15, %9;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd109, fd110}, [rd16];
mul.f64 fd113, fd109, fd101;
mul.f64 fd114, fd110, fd107;
sub.f64 fd115, fd113, fd114;
mul.f64 fd116, fd109, fd107;
fma.rn.f64 fd117, fd110, fd101, fd116;
ld.global.v2.f64 {fd118, fd119}, [rd16+1296];
mul.f64 fd122, fd118, fd102;
mul.f64 fd123, fd119, fd108;
sub.f64 fd124, fd122, fd123;
mul.f64 fd125, fd118, fd108;
fma.rn.f64 fd126, fd119, fd102, fd125;
barrier.sync 0;
mad.lo.s32 r23, r18, 216, r22;
st.shared.f64 [r23], fd94;
st.shared.f64 [r23+72], fd115;
st.shared.f64 [r23+144], fd124;
barrier.sync 0;
ld.shared.f64 fd127, [r11];
ld.shared.f64 fd128, [r11+5832];
ld.shared.f64 fd129, [r11+11664];
barrier.sync 0;
st.shared.f64 [r23], fd96;
st.shared.f64 [r23+72], fd117;
st.shared.f64 [r23+144], fd126;
barrier.sync 0;
ld.shared.f64 fd130, [r11];
ld.shared.f64 fd131, [r11+5832];
ld.shared.f64 fd132, [r11+11664];
add.f64 fd133, fd128, fd129;
add.f64 fd134, fd127, fd133;
add.f64 fd135, fd131, fd132;
add.f64 fd136, fd130, fd135;
mul.f64 fd137, fd133, 0d3FE0000000000000;
sub.f64 fd138, fd127, fd137;
sub.f64 fd139, fd131, fd132;
mul.f64 fd140, fd139, 0d3FEBB67AE8584CAA;
add.f64 fd141, fd140, fd138;
sub.f64 fd142, fd138, fd140;
mul.f64 fd143, fd135, 0d3FE0000000000000;
sub.f64 fd144, fd130, fd143;
sub.f64 fd145, fd128, fd129;
mul.f64 fd146, fd145, 0d3FEBB67AE8584CAA;
sub.f64 fd147, fd144, fd146;
add.f64 fd148, fd146, fd144;
mul.wide.u32 rd17, r7, 795364315;
shr.u64 rd18, rd17, 32;
cvt.u32.u64 r24, rd18;
sub.s32 r25, r7, r24;
shr.u32 r26, r25, 1;
add.s32 r27, r26, r24;
shr.u32 r28, r27, 4;
mul.lo.s32 r29, r28, 27;
sub.s32 r30, r7, r29;
shl.b32 r31, r30, 3;
add.s32 r32, r8, r31;
mul.wide.u32 rd19, r28, 16;
mov.u64 rd20, %10;
add.s64 rd21, rd20, rd19;
ld.global.v2.f64 {fd149, fd150}, [rd21];
mul.f64 fd153, fd149, fd141;
mul.f64 fd154, fd150, fd147;
sub.f64 fd155, fd153, fd154;
mul.f64 fd156, fd149, fd147;
fma.rn.f64 fd157, fd150, fd141, fd156;
ld.global.v2.f64 {fd158, fd159}, [rd21+432];
mul.f64 fd162, fd158, fd142;
mul.f64 fd163, fd159, fd148;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd158, fd148;
fma.rn.f64 fd166, fd159, fd142, fd165;
barrier.sync 0;
mad.lo.s32 r33, r28, 648, r32;
st.shared.f64 [r33], fd134;
st.shared.f64 [r33+216], fd155;
st.shared.f64 [r33+432], fd164;
barrier.sync 0;
ld.shared.f64 fd167, [r11];
ld.shared.f64 fd168, [r11+5832];
ld.shared.f64 fd169, [r11+11664];
barrier.sync 0;
st.shared.f64 [r33], fd136;
st.shared.f64 [r33+216], fd157;
st.shared.f64 [r33+432], fd166;
barrier.sync 0;
ld.shared.f64 fd170, [r11];
ld.shared.f64 fd171, [r11+5832];
ld.shared.f64 fd172, [r11+11664];
add.f64 fd173, fd168, fd169;
add.f64 fd174, fd167, fd173;
add.f64 fd175, fd171, fd172;
add.f64 fd176, fd170, fd175;
mul.f64 fd177, fd173, 0d3FE0000000000000;
sub.f64 fd178, fd167, fd177;
sub.f64 fd179, fd171, fd172;
mul.f64 fd180, fd179, 0d3FEBB67AE8584CAA;
add.f64 fd181, fd180, fd178;
sub.f64 fd182, fd178, fd180;
mul.f64 fd183, fd175, 0d3FE0000000000000;
sub.f64 fd184, fd170, fd183;
sub.f64 fd185, fd168, fd169;
mul.f64 fd186, fd185, 0d3FEBB67AE8584CAA;
sub.f64 fd187, fd184, fd186;
add.f64 fd188, fd186, fd184;
mul.wide.u32 rd22, r7, -901412889;
shr.u64 rd23, rd22, 38;
cvt.u32.u64 r34, rd23;
mul.lo.s32 r35, r34, 81;
sub.s32 r36, r7, r35;
shl.b32 r37, r36, 3;
add.s32 r38, r8, r37;
mul.wide.u32 rd24, r34, 16;
mov.u64 rd25, %11;
add.s64 rd26, rd25, rd24;
ld.global.v2.f64 {fd189, fd190}, [rd26];
mul.f64 fd193, fd189, fd181;
mul.f64 fd194, fd190, fd187;
sub.f64 fd195, fd193, fd194;
mul.f64 fd196, fd189, fd187;
fma.rn.f64 fd197, fd190, fd181, fd196;
ld.global.v2.f64 {fd198, fd199}, [rd26+144];
mul.f64 fd202, fd198, fd182;
mul.f64 fd203, fd199, fd188;
sub.f64 fd204, fd202, fd203;
mul.f64 fd205, fd198, fd188;
fma.rn.f64 fd206, fd199, fd182, fd205;
barrier.sync 0;
mad.lo.s32 r39, r34, 1944, r38;
st.shared.f64 [r39], fd174;
st.shared.f64 [r39+648], fd195;
st.shared.f64 [r39+1296], fd204;
barrier.sync 0;
ld.shared.f64 fd207, [r11];
ld.shared.f64 fd208, [r11+5832];
ld.shared.f64 fd209, [r11+11664];
barrier.sync 0;
st.shared.f64 [r39], fd176;
st.shared.f64 [r39+648], fd197;
st.shared.f64 [r39+1296], fd206;
barrier.sync 0;
ld.shared.f64 fd210, [r11];
ld.shared.f64 fd211, [r11+5832];
ld.shared.f64 fd212, [r11+11664];
add.f64 fd213, fd208, fd209;
add.f64 fd214, fd207, fd213;
add.f64 fd215, fd211, fd212;
add.f64 fd216, fd210, fd215;
mul.f64 fd217, fd213, 0d3FE0000000000000;
sub.f64 fd218, fd207, fd217;
sub.f64 fd219, fd211, fd212;
mul.f64 fd220, fd219, 0d3FEBB67AE8584CAA;
add.f64 fd221, fd220, fd218;
sub.f64 fd222, fd218, fd220;
mul.f64 fd223, fd215, 0d3FE0000000000000;
sub.f64 fd224, fd210, fd223;
sub.f64 fd225, fd208, fd209;
mul.f64 fd226, fd225, 0d3FEBB67AE8584CAA;
sub.f64 fd227, fd224, fd226;
add.f64 fd228, fd226, fd224;
mul.wide.u32 rd27, r7, -2032597691;
shr.u64 rd28, rd27, 39;
cvt.u32.u64 r40, rd28;
mul.lo.s32 r41, r40, 243;
sub.s32 r42, r7, r41;
shl.b32 r43, r42, 3;
add.s32 r44, r8, r43;
mul.wide.u32 rd29, r40, 16;
mov.u64 rd30, %12;
add.s64 rd31, rd30, rd29;
ld.global.v2.f64 {fd229, fd230}, [rd31];
mul.f64 fd233, fd229, fd221;
mul.f64 fd234, fd230, fd227;
sub.f64 fd235, fd233, fd234;
mul.f64 fd236, fd229, fd227;
fma.rn.f64 fd237, fd230, fd221, fd236;
ld.global.v2.f64 {fd238, fd239}, [rd31+48];
mul.f64 fd242, fd238, fd222;
mul.f64 fd243, fd239, fd228;
sub.f64 fd244, fd242, fd243;
mul.f64 fd245, fd238, fd228;
fma.rn.f64 fd246, fd239, fd222, fd245;
barrier.sync 0;
mad.lo.s32 r45, r40, 5832, r44;
st.shared.f64 [r45], fd214;
st.shared.f64 [r45+1944], fd235;
st.shared.f64 [r45+3888], fd244;
barrier.sync 0;
ld.shared.f64 fd247, [r11];
ld.shared.f64 fd248, [r11+5832];
ld.shared.f64 fd249, [r11+11664];
barrier.sync 0;
st.shared.f64 [r45], fd216;
st.shared.f64 [r45+1944], fd237;
st.shared.f64 [r45+3888], fd246;
barrier.sync 0;
ld.shared.f64 fd250, [r11];
ld.shared.f64 fd251, [r11+5832];
ld.shared.f64 fd252, [r11+11664];
add.f64 fd253, fd248, fd249;
add.f64 fd254, fd251, fd252;
mul.f64 fd255, fd253, 0d3FE0000000000000;
sub.f64 fd256, fd247, fd255;
sub.f64 fd257, fd251, fd252;
mul.f64 fd258, fd257, 0d3FEBB67AE8584CAA;
mul.f64 fd259, fd254, 0d3FE0000000000000;
sub.f64 fd260, fd250, fd259;
sub.f64 fd261, fd248, fd249;
mul.f64 fd262, fd261, 0d3FEBB67AE8584CAA;
add.f64 %0, fd247, fd253;
add.f64 %1, fd250, fd254;
add.f64 %2, fd258, fd256;
sub.f64 %3, fd260, fd262;
sub.f64 %4, fd256, fd258;
add.f64 %5, fd262, fd260;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y): "r"(smem), "l"(lut_dp_3_2187), "l"(lut_dp_3_729), "l"(lut_dp_3_243), "l"(lut_dp_3_81), "l"(lut_dp_3_27), "l"(lut_dp_3_9), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<530, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<46>;
.reg .f64 fd<305>;
.reg .b64 rd<32>;
mov.u32 r1, %tid.y;
mov.u32 r2, %6;
mad.lo.s32 r3, r1, 34992, r2;
mov.u32 r4, %tid.x;
add.f64 fd13, %15, %18;
add.f64 fd14, %17, %19;
mul.f64 fd15, fd13, 0d3FE0000000000000;
sub.f64 fd16, %13, fd15;
sub.f64 fd17, %17, %19;
mul.f64 fd18, fd17, 0d3FEBB67AE8584CAA;
add.f64 fd19, fd18, fd16;
sub.f64 fd20, fd16, fd18;
mul.f64 fd21, fd14, 0d3FE0000000000000;
sub.f64 fd22, %14, fd21;
sub.f64 fd23, %15, %18;
mul.f64 fd24, fd23, 0d3FEBB67AE8584CAA;
sub.f64 fd25, fd22, fd24;
add.f64 fd26, fd24, fd22;
mul.wide.u32 rd2, r4, 1508246403;
shr.u64 rd3, rd2, 40;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 729;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 34992, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %7;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd27, fd28}, [rd6];
mul.f64 fd31, fd27, fd19;
mul.f64 fd32, fd28, fd25;
mul.f64 fd33, fd27, fd25;
ld.global.v2.f64 {fd34, fd35}, [rd6+11664];
mul.f64 fd38, fd34, fd20;
mul.f64 fd39, fd35, fd26;
mul.f64 fd40, fd34, fd26;
barrier.sync 0;
mad.lo.s32 r9, r7, 48, r8;
add.f64 fd41, %14, fd14;
add.f64 fd42, %13, fd13;
st.shared.v2.f64 [r9], {fd42, fd41};
fma.rn.f64 fd43, fd28, fd19, fd33;
sub.f64 fd44, fd31, fd32;
st.shared.v2.f64 [r9+16], {fd44, fd43};
fma.rn.f64 fd45, fd35, fd20, fd40;
sub.f64 fd46, fd38, fd39;
st.shared.v2.f64 [r9+32], {fd46, fd45};
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.v2.f64 {fd47, fd48}, [r11];
ld.shared.v2.f64 {fd51, fd52}, [r11+11664];
ld.shared.v2.f64 {fd55, fd56}, [r11+23328];
add.f64 fd59, fd51, fd55;
add.f64 fd60, fd52, fd56;
mul.f64 fd61, fd59, 0d3FE0000000000000;
sub.f64 fd62, fd47, fd61;
sub.f64 fd63, fd52, fd56;
mul.f64 fd64, fd63, 0d3FEBB67AE8584CAA;
add.f64 fd65, fd64, fd62;
sub.f64 fd66, fd62, fd64;
mul.f64 fd67, fd60, 0d3FE0000000000000;
sub.f64 fd68, fd48, fd67;
sub.f64 fd69, fd51, fd55;
mul.f64 fd70, fd69, 0d3FEBB67AE8584CAA;
sub.f64 fd71, fd68, fd70;
add.f64 fd72, fd70, fd68;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 3;
sub.s32 r14, r7, r13;
shl.b32 r15, r14, 4;
add.s32 r16, r8, r15;
mul.wide.u32 rd9, r12, 16;
mov.u64 rd10, %8;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd73, fd74}, [rd11];
mul.f64 fd77, fd73, fd65;
mul.f64 fd78, fd74, fd71;
mul.f64 fd79, fd73, fd71;
ld.global.v2.f64 {fd80, fd81}, [rd11+3888];
mul.f64 fd84, fd80, fd66;
mul.f64 fd85, fd81, fd72;
mul.f64 fd86, fd80, fd72;
barrier.sync 0;
mad.lo.s32 r17, r12, 144, r16;
add.f64 fd87, fd48, fd60;
add.f64 fd88, fd47, fd59;
st.shared.v2.f64 [r17], {fd88, fd87};
fma.rn.f64 fd89, fd74, fd65, fd79;
sub.f64 fd90, fd77, fd78;
st.shared.v2.f64 [r17+48], {fd90, fd89};
fma.rn.f64 fd91, fd81, fd66, fd86;
sub.f64 fd92, fd84, fd85;
st.shared.v2.f64 [r17+96], {fd92, fd91};
barrier.sync 0;
ld.shared.v2.f64 {fd93, fd94}, [r11];
ld.shared.v2.f64 {fd97, fd98}, [r11+11664];
ld.shared.v2.f64 {fd101, fd102}, [r11+23328];
add.f64 fd105, fd97, fd101;
add.f64 fd106, fd98, fd102;
mul.f64 fd107, fd105, 0d3FE0000000000000;
sub.f64 fd108, fd93, fd107;
sub.f64 fd109, fd98, fd102;
mul.f64 fd110, fd109, 0d3FEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd106, 0d3FE0000000000000;
sub.f64 fd114, fd94, fd113;
sub.f64 fd115, fd97, fd101;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
mul.wide.u32 rd12, r7, 954437177;
shr.u64 rd13, rd12, 33;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 9;
sub.s32 r20, r7, r19;
shl.b32 r21, r20, 4;
add.s32 r22, r8, r21;
mul.wide.u32 rd14, r18, 16;
mov.u64 rd15, %9;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd119, fd120}, [rd16];
mul.f64 fd123, fd119, fd111;
mul.f64 fd124, fd120, fd117;
mul.f64 fd125, fd119, fd117;
ld.global.v2.f64 {fd126, fd127}, [rd16+1296];
mul.f64 fd130, fd126, fd112;
mul.f64 fd131, fd127, fd118;
mul.f64 fd132, fd126, fd118;
barrier.sync 0;
mad.lo.s32 r23, r18, 432, r22;
add.f64 fd133, fd94, fd106;
add.f64 fd134, fd93, fd105;
st.shared.v2.f64 [r23], {fd134, fd133};
fma.rn.f64 fd135, fd120, fd111, fd125;
sub.f64 fd136, fd123, fd124;
st.shared.v2.f64 [r23+144], {fd136, fd135};
fma.rn.f64 fd137, fd127, fd112, fd132;
sub.f64 fd138, fd130, fd131;
st.shared.v2.f64 [r23+288], {fd138, fd137};
barrier.sync 0;
ld.shared.v2.f64 {fd139, fd140}, [r11];
ld.shared.v2.f64 {fd143, fd144}, [r11+11664];
ld.shared.v2.f64 {fd147, fd148}, [r11+23328];
add.f64 fd151, fd143, fd147;
add.f64 fd152, fd144, fd148;
mul.f64 fd153, fd151, 0d3FE0000000000000;
sub.f64 fd154, fd139, fd153;
sub.f64 fd155, fd144, fd148;
mul.f64 fd156, fd155, 0d3FEBB67AE8584CAA;
add.f64 fd157, fd156, fd154;
sub.f64 fd158, fd154, fd156;
mul.f64 fd159, fd152, 0d3FE0000000000000;
sub.f64 fd160, fd140, fd159;
sub.f64 fd161, fd143, fd147;
mul.f64 fd162, fd161, 0d3FEBB67AE8584CAA;
sub.f64 fd163, fd160, fd162;
add.f64 fd164, fd162, fd160;
mul.wide.u32 rd17, r7, 795364315;
shr.u64 rd18, rd17, 32;
cvt.u32.u64 r24, rd18;
sub.s32 r25, r7, r24;
shr.u32 r26, r25, 1;
add.s32 r27, r26, r24;
shr.u32 r28, r27, 4;
mul.lo.s32 r29, r28, 27;
sub.s32 r30, r7, r29;
shl.b32 r31, r30, 4;
add.s32 r32, r8, r31;
mul.wide.u32 rd19, r28, 16;
mov.u64 rd20, %10;
add.s64 rd21, rd20, rd19;
ld.global.v2.f64 {fd165, fd166}, [rd21];
mul.f64 fd169, fd165, fd157;
mul.f64 fd170, fd166, fd163;
mul.f64 fd171, fd165, fd163;
ld.global.v2.f64 {fd172, fd173}, [rd21+432];
mul.f64 fd176, fd172, fd158;
mul.f64 fd177, fd173, fd164;
mul.f64 fd178, fd172, fd164;
barrier.sync 0;
mad.lo.s32 r33, r28, 1296, r32;
add.f64 fd179, fd140, fd152;
add.f64 fd180, fd139, fd151;
st.shared.v2.f64 [r33], {fd180, fd179};
fma.rn.f64 fd181, fd166, fd157, fd171;
sub.f64 fd182, fd169, fd170;
st.shared.v2.f64 [r33+432], {fd182, fd181};
fma.rn.f64 fd183, fd173, fd158, fd178;
sub.f64 fd184, fd176, fd177;
st.shared.v2.f64 [r33+864], {fd184, fd183};
barrier.sync 0;
ld.shared.v2.f64 {fd185, fd186}, [r11];
ld.shared.v2.f64 {fd189, fd190}, [r11+11664];
ld.shared.v2.f64 {fd193, fd194}, [r11+23328];
add.f64 fd197, fd189, fd193;
add.f64 fd198, fd190, fd194;
mul.f64 fd199, fd197, 0d3FE0000000000000;
sub.f64 fd200, fd185, fd199;
sub.f64 fd201, fd190, fd194;
mul.f64 fd202, fd201, 0d3FEBB67AE8584CAA;
add.f64 fd203, fd202, fd200;
sub.f64 fd204, fd200, fd202;
mul.f64 fd205, fd198, 0d3FE0000000000000;
sub.f64 fd206, fd186, fd205;
sub.f64 fd207, fd189, fd193;
mul.f64 fd208, fd207, 0d3FEBB67AE8584CAA;
sub.f64 fd209, fd206, fd208;
add.f64 fd210, fd208, fd206;
mul.wide.u32 rd22, r7, -901412889;
shr.u64 rd23, rd22, 38;
cvt.u32.u64 r34, rd23;
mul.lo.s32 r35, r34, 81;
sub.s32 r36, r7, r35;
shl.b32 r37, r36, 4;
add.s32 r38, r8, r37;
mul.wide.u32 rd24, r34, 16;
mov.u64 rd25, %11;
add.s64 rd26, rd25, rd24;
ld.global.v2.f64 {fd211, fd212}, [rd26];
mul.f64 fd215, fd211, fd203;
mul.f64 fd216, fd212, fd209;
mul.f64 fd217, fd211, fd209;
ld.global.v2.f64 {fd218, fd219}, [rd26+144];
mul.f64 fd222, fd218, fd204;
mul.f64 fd223, fd219, fd210;
mul.f64 fd224, fd218, fd210;
barrier.sync 0;
mad.lo.s32 r39, r34, 3888, r38;
add.f64 fd225, fd186, fd198;
add.f64 fd226, fd185, fd197;
st.shared.v2.f64 [r39], {fd226, fd225};
fma.rn.f64 fd227, fd212, fd203, fd217;
sub.f64 fd228, fd215, fd216;
st.shared.v2.f64 [r39+1296], {fd228, fd227};
fma.rn.f64 fd229, fd219, fd204, fd224;
sub.f64 fd230, fd222, fd223;
st.shared.v2.f64 [r39+2592], {fd230, fd229};
barrier.sync 0;
ld.shared.v2.f64 {fd231, fd232}, [r11];
ld.shared.v2.f64 {fd235, fd236}, [r11+11664];
ld.shared.v2.f64 {fd239, fd240}, [r11+23328];
add.f64 fd243, fd235, fd239;
add.f64 fd244, fd236, fd240;
mul.f64 fd245, fd243, 0d3FE0000000000000;
sub.f64 fd246, fd231, fd245;
sub.f64 fd247, fd236, fd240;
mul.f64 fd248, fd247, 0d3FEBB67AE8584CAA;
add.f64 fd249, fd248, fd246;
sub.f64 fd250, fd246, fd248;
mul.f64 fd251, fd244, 0d3FE0000000000000;
sub.f64 fd252, fd232, fd251;
sub.f64 fd253, fd235, fd239;
mul.f64 fd254, fd253, 0d3FEBB67AE8584CAA;
sub.f64 fd255, fd252, fd254;
add.f64 fd256, fd254, fd252;
mul.wide.u32 rd27, r7, -2032597691;
shr.u64 rd28, rd27, 39;
cvt.u32.u64 r40, rd28;
mul.lo.s32 r41, r40, 243;
sub.s32 r42, r7, r41;
shl.b32 r43, r42, 4;
add.s32 r44, r8, r43;
mul.wide.u32 rd29, r40, 16;
mov.u64 rd30, %12;
add.s64 rd31, rd30, rd29;
ld.global.v2.f64 {fd257, fd258}, [rd31];
mul.f64 fd261, fd257, fd249;
mul.f64 fd262, fd258, fd255;
mul.f64 fd263, fd257, fd255;
ld.global.v2.f64 {fd264, fd265}, [rd31+48];
mul.f64 fd268, fd264, fd250;
mul.f64 fd269, fd265, fd256;
mul.f64 fd270, fd264, fd256;
barrier.sync 0;
mad.lo.s32 r45, r40, 11664, r44;
add.f64 fd271, fd232, fd244;
add.f64 fd272, fd231, fd243;
st.shared.v2.f64 [r45], {fd272, fd271};
fma.rn.f64 fd273, fd258, fd249, fd263;
sub.f64 fd274, fd261, fd262;
st.shared.v2.f64 [r45+3888], {fd274, fd273};
fma.rn.f64 fd275, fd265, fd250, fd270;
sub.f64 fd276, fd268, fd269;
st.shared.v2.f64 [r45+7776], {fd276, fd275};
barrier.sync 0;
ld.shared.v2.f64 {fd277, fd278}, [r11];
ld.shared.v2.f64 {fd281, fd282}, [r11+11664];
ld.shared.v2.f64 {fd285, fd286}, [r11+23328];
add.f64 fd289, fd281, fd285;
add.f64 fd290, fd282, fd286;
mul.f64 fd291, fd289, 0d3FE0000000000000;
sub.f64 fd292, fd277, fd291;
sub.f64 fd293, fd282, fd286;
mul.f64 fd294, fd293, 0d3FEBB67AE8584CAA;
mul.f64 fd295, fd290, 0d3FE0000000000000;
sub.f64 fd296, fd278, fd295;
sub.f64 fd297, fd281, fd285;
mul.f64 fd298, fd297, 0d3FEBB67AE8584CAA;
add.f64 %1, fd278, fd290;
add.f64 %0, fd277, fd289;
sub.f64 %3, fd296, fd298;
add.f64 %2, fd294, fd292;
add.f64 %5, fd298, fd296;
sub.f64 %4, fd292, fd294;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y): "r"(smem), "l"(lut_dp_3_2187), "l"(lut_dp_3_729), "l"(lut_dp_3_243), "l"(lut_dp_3_81), "l"(lut_dp_3_27), "l"(lut_dp_3_9), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y));
};


#endif
