#ifndef CUFFTDX_FFT_343_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_343_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<174, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<467>;
.reg .b32 r<21>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 2744, r2;
mov.u32 r4, %tid.x;
add.f32 f29, %19, %33;
add.f32 f30, %17, f29;
add.f32 f31, %22, %30;
add.f32 f32, f31, f30;
add.f32 f33, %25, %27;
add.f32 f34, %21, %34;
add.f32 f35, %18, f34;
add.f32 f36, %24, %32;
add.f32 f37, f36, f35;
add.f32 f38, %26, %29;
fma.rn.f32 f39, f29, 0f3F1F9D07, %17;
mul.f32 f40, f31, 0f3E63DC87;
sub.f32 f41, f39, f40;
mul.f32 f42, f33, 0f3F66A5E5;
sub.f32 f43, f41, f42;
sub.f32 f44, %21, %34;
mul.f32 f45, f44, 0f3F48261C;
sub.f32 f46, %24, %32;
mul.f32 f47, f46, 0fBF7994E0;
sub.f32 f48, f47, f45;
sub.f32 f49, %26, %29;
mul.f32 f50, f49, 0f3EDE2602;
sub.f32 f51, f48, f50;
sub.f32 f52, f43, f51;
add.f32 f53, f51, f43;
mul.f32 f54, f29, 0f3E63DC87;
sub.f32 f55, %17, f54;
mul.f32 f56, f31, 0f3F66A5E5;
sub.f32 f57, f55, f56;
fma.rn.f32 f58, f33, 0f3F1F9D07, f57;
mul.f32 f59, f44, 0f3F7994E0;
mul.f32 f60, f46, 0f3EDE2602;
sub.f32 f61, f60, f59;
fma.rn.f32 f62, f49, 0f3F48261C, f61;
sub.f32 f63, f58, f62;
add.f32 f64, f62, f58;
mul.f32 f65, f29, 0f3F66A5E5;
sub.f32 f66, %17, f65;
fma.rn.f32 f67, f31, 0f3F1F9D07, f66;
mul.f32 f68, f33, 0f3E63DC87;
sub.f32 f69, f67, f68;
mul.f32 f70, f44, 0f3EDE2602;
mul.f32 f71, f46, 0f3F48261C;
sub.f32 f72, f71, f70;
mul.f32 f73, f49, 0f3F7994E0;
sub.f32 f74, f72, f73;
sub.f32 f75, f69, f74;
add.f32 f76, f74, f69;
fma.rn.f32 f77, f34, 0f3F1F9D07, %18;
mul.f32 f78, f36, 0f3E63DC87;
sub.f32 f79, f77, f78;
mul.f32 f80, f38, 0f3F66A5E5;
sub.f32 f81, f79, f80;
sub.f32 f82, %19, %33;
mul.f32 f83, f82, 0f3F48261C;
sub.f32 f84, %22, %30;
mul.f32 f85, f84, 0fBF7994E0;
sub.f32 f86, f85, f83;
sub.f32 f87, %25, %27;
mul.f32 f88, f87, 0f3EDE2602;
sub.f32 f89, f86, f88;
add.f32 f90, f89, f81;
sub.f32 f91, f81, f89;
mul.f32 f92, f34, 0f3E63DC87;
sub.f32 f93, %18, f92;
mul.f32 f94, f36, 0f3F66A5E5;
sub.f32 f95, f93, f94;
fma.rn.f32 f96, f38, 0f3F1F9D07, f95;
mul.f32 f97, f82, 0f3F7994E0;
mul.f32 f98, f84, 0f3EDE2602;
sub.f32 f99, f98, f97;
fma.rn.f32 f100, f87, 0f3F48261C, f99;
add.f32 f101, f100, f96;
sub.f32 f102, f96, f100;
mul.f32 f103, f34, 0f3F66A5E5;
sub.f32 f104, %18, f103;
fma.rn.f32 f105, f36, 0f3F1F9D07, f104;
mul.f32 f106, f38, 0f3E63DC87;
sub.f32 f107, f105, f106;
mul.f32 f108, f82, 0f3EDE2602;
mul.f32 f109, f84, 0f3F48261C;
sub.f32 f110, f109, f108;
mul.f32 f111, f87, 0f3F7994E0;
sub.f32 f112, f110, f111;
add.f32 f113, f112, f107;
sub.f32 f114, f107, f112;
mul.wide.u32 rd2, r4, 1402438301;
shr.u64 rd3, rd2, 36;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 49;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 2744, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f115, f116}, [rd6];
mul.f32 f119, f115, f52;
mul.f32 f120, f116, f90;
mul.f32 f121, f115, f90;
mul.f32 f122, f115, f115;
mul.f32 f123, f116, f116;
sub.f32 f124, f122, f123;
mul.f32 f125, f116, f115;
fma.rn.f32 f126, f116, f115, f125;
mul.f32 f127, f124, f63;
mul.f32 f128, f126, f101;
mul.f32 f129, f124, f101;
mul.f32 f130, f115, f124;
mul.f32 f131, f116, f126;
sub.f32 f132, f130, f131;
mul.f32 f133, f115, f126;
fma.rn.f32 f134, f116, f124, f133;
mul.f32 f135, f132, f75;
mul.f32 f136, f134, f113;
mul.f32 f137, f132, f113;
mul.f32 f138, f115, f132;
mul.f32 f139, f116, f134;
sub.f32 f140, f138, f139;
mul.f32 f141, f115, f134;
fma.rn.f32 f142, f116, f132, f141;
mul.f32 f143, f140, f76;
mul.f32 f144, f142, f114;
mul.f32 f145, f140, f114;
mul.f32 f146, f115, f140;
mul.f32 f147, f116, f142;
sub.f32 f148, f146, f147;
mul.f32 f149, f115, f142;
fma.rn.f32 f150, f116, f140, f149;
mul.f32 f151, f148, f64;
mul.f32 f152, f150, f102;
mul.f32 f153, f148, f102;
mul.f32 f154, f115, f148;
mul.f32 f155, f116, f150;
sub.f32 f156, f154, f155;
mul.f32 f157, f115, f150;
fma.rn.f32 f158, f116, f148, f157;
mul.f32 f159, f156, f53;
mul.f32 f160, f158, f91;
mul.f32 f161, f156, f91;
barrier.sync 0;
mad.lo.s32 r9, r7, 56, r8;
add.f32 f162, f38, f37;
add.f32 f163, f33, f32;
st.shared.v2.f32 [r9], {f163, f162};
fma.rn.f32 f164, f116, f52, f121;
sub.f32 f165, f119, f120;
st.shared.v2.f32 [r9+8], {f165, f164};
fma.rn.f32 f166, f126, f63, f129;
sub.f32 f167, f127, f128;
st.shared.v2.f32 [r9+16], {f167, f166};
sub.f32 f168, f135, f136;
fma.rn.f32 f169, f134, f75, f137;
st.shared.v2.f32 [r9+24], {f168, f169};
fma.rn.f32 f170, f142, f76, f145;
sub.f32 f171, f143, f144;
st.shared.v2.f32 [r9+32], {f171, f170};
fma.rn.f32 f172, f150, f64, f153;
sub.f32 f173, f151, f152;
st.shared.v2.f32 [r9+40], {f173, f172};
fma.rn.f32 f174, f158, f53, f161;
sub.f32 f175, f159, f160;
st.shared.v2.f32 [r9+48], {f175, f174};
barrier.sync 0;
mad.lo.s32 r10, r7, -48, r9;
ld.shared.v2.f32 {f176, f177}, [r10];
ld.shared.v2.f32 {f180, f181}, [r10+392];
ld.shared.v2.f32 {f184, f185}, [r10+784];
ld.shared.v2.f32 {f188, f189}, [r10+1176];
ld.shared.v2.f32 {f192, f193}, [r10+1568];
ld.shared.v2.f32 {f196, f197}, [r10+1960];
ld.shared.v2.f32 {f200, f201}, [r10+2352];
add.f32 f204, f180, f200;
add.f32 f205, f176, f204;
add.f32 f206, f184, f196;
add.f32 f207, f206, f205;
add.f32 f208, f188, f192;
add.f32 f209, f181, f201;
add.f32 f210, f177, f209;
add.f32 f211, f185, f197;
add.f32 f212, f211, f210;
add.f32 f213, f189, f193;
fma.rn.f32 f214, f204, 0f3F1F9D07, f176;
mul.f32 f215, f206, 0f3E63DC87;
sub.f32 f216, f214, f215;
mul.f32 f217, f208, 0f3F66A5E5;
sub.f32 f218, f216, f217;
sub.f32 f219, f181, f201;
mul.f32 f220, f219, 0f3F48261C;
sub.f32 f221, f185, f197;
mul.f32 f222, f221, 0fBF7994E0;
sub.f32 f223, f222, f220;
sub.f32 f224, f189, f193;
mul.f32 f225, f224, 0f3EDE2602;
sub.f32 f226, f223, f225;
sub.f32 f227, f218, f226;
add.f32 f228, f226, f218;
mul.f32 f229, f204, 0f3E63DC87;
sub.f32 f230, f176, f229;
mul.f32 f231, f206, 0f3F66A5E5;
sub.f32 f232, f230, f231;
fma.rn.f32 f233, f208, 0f3F1F9D07, f232;
mul.f32 f234, f219, 0f3F7994E0;
mul.f32 f235, f221, 0f3EDE2602;
sub.f32 f236, f235, f234;
fma.rn.f32 f237, f224, 0f3F48261C, f236;
sub.f32 f238, f233, f237;
add.f32 f239, f237, f233;
mul.f32 f240, f204, 0f3F66A5E5;
sub.f32 f241, f176, f240;
fma.rn.f32 f242, f206, 0f3F1F9D07, f241;
mul.f32 f243, f208, 0f3E63DC87;
sub.f32 f244, f242, f243;
mul.f32 f245, f219, 0f3EDE2602;
mul.f32 f246, f221, 0f3F48261C;
sub.f32 f247, f246, f245;
mul.f32 f248, f224, 0f3F7994E0;
sub.f32 f249, f247, f248;
sub.f32 f250, f244, f249;
add.f32 f251, f249, f244;
fma.rn.f32 f252, f209, 0f3F1F9D07, f177;
mul.f32 f253, f211, 0f3E63DC87;
sub.f32 f254, f252, f253;
mul.f32 f255, f213, 0f3F66A5E5;
sub.f32 f256, f254, f255;
sub.f32 f257, f180, f200;
mul.f32 f258, f257, 0f3F48261C;
sub.f32 f259, f184, f196;
mul.f32 f260, f259, 0fBF7994E0;
sub.f32 f261, f260, f258;
sub.f32 f262, f188, f192;
mul.f32 f263, f262, 0f3EDE2602;
sub.f32 f264, f261, f263;
add.f32 f265, f264, f256;
sub.f32 f266, f256, f264;
mul.f32 f267, f209, 0f3E63DC87;
sub.f32 f268, f177, f267;
mul.f32 f269, f211, 0f3F66A5E5;
sub.f32 f270, f268, f269;
fma.rn.f32 f271, f213, 0f3F1F9D07, f270;
mul.f32 f272, f257, 0f3F7994E0;
mul.f32 f273, f259, 0f3EDE2602;
sub.f32 f274, f273, f272;
fma.rn.f32 f275, f262, 0f3F48261C, f274;
add.f32 f276, f275, f271;
sub.f32 f277, f271, f275;
mul.f32 f278, f209, 0f3F66A5E5;
sub.f32 f279, f177, f278;
fma.rn.f32 f280, f211, 0f3F1F9D07, f279;
mul.f32 f281, f213, 0f3E63DC87;
sub.f32 f282, f280, f281;
mul.f32 f283, f257, 0f3EDE2602;
mul.f32 f284, f259, 0f3F48261C;
sub.f32 f285, f284, f283;
mul.f32 f286, f262, 0f3F7994E0;
sub.f32 f287, f285, f286;
add.f32 f288, f287, f282;
sub.f32 f289, f282, f287;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 8;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f290, f291}, [rd11];
mul.f32 f294, f290, f227;
mul.f32 f295, f291, f265;
mul.f32 f296, f290, f265;
mul.f32 f297, f290, f290;
mul.f32 f298, f291, f291;
sub.f32 f299, f297, f298;
mul.f32 f300, f291, f290;
fma.rn.f32 f301, f291, f290, f300;
mul.f32 f302, f299, f238;
mul.f32 f303, f301, f276;
mul.f32 f304, f299, f276;
mul.f32 f305, f290, f299;
mul.f32 f306, f291, f301;
sub.f32 f307, f305, f306;
mul.f32 f308, f290, f301;
fma.rn.f32 f309, f291, f299, f308;
mul.f32 f310, f307, f250;
mul.f32 f311, f309, f288;
mul.f32 f312, f307, f288;
mul.f32 f313, f290, f307;
mul.f32 f314, f291, f309;
sub.f32 f315, f313, f314;
mul.f32 f316, f290, f309;
fma.rn.f32 f317, f291, f307, f316;
mul.f32 f318, f315, f251;
mul.f32 f319, f317, f289;
mul.f32 f320, f315, f289;
mul.f32 f321, f290, f315;
mul.f32 f322, f291, f317;
sub.f32 f323, f321, f322;
mul.f32 f324, f290, f317;
fma.rn.f32 f325, f291, f315, f324;
mul.f32 f326, f323, f239;
mul.f32 f327, f325, f277;
mul.f32 f328, f323, f277;
mul.f32 f329, f290, f323;
mul.f32 f330, f291, f325;
sub.f32 f331, f329, f330;
mul.f32 f332, f290, f325;
fma.rn.f32 f333, f291, f323, f332;
mul.f32 f334, f331, f228;
mul.f32 f335, f333, f266;
mul.f32 f336, f331, f266;
shl.b32 r18, r17, 3;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 392, r19;
add.f32 f337, f213, f212;
add.f32 f338, f208, f207;
st.shared.v2.f32 [r20], {f338, f337};
fma.rn.f32 f339, f291, f227, f296;
sub.f32 f340, f294, f295;
st.shared.v2.f32 [r20+56], {f340, f339};
fma.rn.f32 f341, f301, f238, f304;
sub.f32 f342, f302, f303;
st.shared.v2.f32 [r20+112], {f342, f341};
fma.rn.f32 f343, f309, f250, f312;
sub.f32 f344, f310, f311;
st.shared.v2.f32 [r20+168], {f344, f343};
sub.f32 f345, f318, f319;
fma.rn.f32 f346, f317, f251, f320;
st.shared.v2.f32 [r20+224], {f345, f346};
fma.rn.f32 f347, f325, f239, f328;
sub.f32 f348, f326, f327;
st.shared.v2.f32 [r20+280], {f348, f347};
fma.rn.f32 f349, f333, f228, f336;
sub.f32 f350, f334, f335;
st.shared.v2.f32 [r20+336], {f350, f349};
barrier.sync 0;
ld.shared.v2.f32 {f351, f352}, [r10];
ld.shared.v2.f32 {f355, f356}, [r10+392];
ld.shared.v2.f32 {f359, f360}, [r10+784];
ld.shared.v2.f32 {f363, f364}, [r10+1176];
ld.shared.v2.f32 {f367, f368}, [r10+1568];
ld.shared.v2.f32 {f371, f372}, [r10+1960];
ld.shared.v2.f32 {f375, f376}, [r10+2352];
add.f32 f379, f355, f375;
add.f32 f380, f351, f379;
add.f32 f381, f359, f371;
add.f32 f382, f381, f380;
add.f32 f383, f363, f367;
add.f32 f384, f356, f376;
add.f32 f385, f352, f384;
add.f32 f386, f360, f372;
add.f32 f387, f386, f385;
add.f32 f388, f364, f368;
fma.rn.f32 f389, f379, 0f3F1F9D07, f351;
mul.f32 f390, f381, 0f3E63DC87;
sub.f32 f391, f389, f390;
mul.f32 f392, f383, 0f3F66A5E5;
sub.f32 f393, f391, f392;
sub.f32 f394, f356, f376;
mul.f32 f395, f394, 0f3F48261C;
sub.f32 f396, f360, f372;
mul.f32 f397, f396, 0fBF7994E0;
sub.f32 f398, f397, f395;
sub.f32 f399, f364, f368;
mul.f32 f400, f399, 0f3EDE2602;
sub.f32 f401, f398, f400;
mul.f32 f402, f379, 0f3E63DC87;
sub.f32 f403, f351, f402;
mul.f32 f404, f381, 0f3F66A5E5;
sub.f32 f405, f403, f404;
fma.rn.f32 f406, f383, 0f3F1F9D07, f405;
mul.f32 f407, f394, 0f3F7994E0;
mul.f32 f408, f396, 0f3EDE2602;
sub.f32 f409, f408, f407;
fma.rn.f32 f410, f399, 0f3F48261C, f409;
mul.f32 f411, f379, 0f3F66A5E5;
sub.f32 f412, f351, f411;
fma.rn.f32 f413, f381, 0f3F1F9D07, f412;
mul.f32 f414, f383, 0f3E63DC87;
sub.f32 f415, f413, f414;
mul.f32 f416, f394, 0f3EDE2602;
mul.f32 f417, f396, 0f3F48261C;
sub.f32 f418, f417, f416;
mul.f32 f419, f399, 0f3F7994E0;
sub.f32 f420, f418, f419;
fma.rn.f32 f421, f384, 0f3F1F9D07, f352;
mul.f32 f422, f386, 0f3E63DC87;
sub.f32 f423, f421, f422;
mul.f32 f424, f388, 0f3F66A5E5;
sub.f32 f425, f423, f424;
sub.f32 f426, f355, f375;
mul.f32 f427, f426, 0f3F48261C;
sub.f32 f428, f359, f371;
mul.f32 f429, f428, 0fBF7994E0;
sub.f32 f430, f429, f427;
sub.f32 f431, f363, f367;
mul.f32 f432, f431, 0f3EDE2602;
sub.f32 f433, f430, f432;
mul.f32 f434, f384, 0f3E63DC87;
sub.f32 f435, f352, f434;
mul.f32 f436, f386, 0f3F66A5E5;
sub.f32 f437, f435, f436;
fma.rn.f32 f438, f388, 0f3F1F9D07, f437;
mul.f32 f439, f426, 0f3F7994E0;
mul.f32 f440, f428, 0f3EDE2602;
sub.f32 f441, f440, f439;
fma.rn.f32 f442, f431, 0f3F48261C, f441;
mul.f32 f443, f384, 0f3F66A5E5;
sub.f32 f444, f352, f443;
fma.rn.f32 f445, f386, 0f3F1F9D07, f444;
mul.f32 f446, f388, 0f3E63DC87;
sub.f32 f447, f445, f446;
mul.f32 f448, f426, 0f3EDE2602;
mul.f32 f449, f428, 0f3F48261C;
sub.f32 f450, f449, f448;
mul.f32 f451, f431, 0f3F7994E0;
sub.f32 f452, f450, f451;
add.f32 %1, f388, f387;
add.f32 %0, f383, f382;
add.f32 %3, f433, f425;
sub.f32 %2, f393, f401;
add.f32 %5, f442, f438;
sub.f32 %4, f406, f410;
add.f32 %7, f452, f447;
sub.f32 %6, f415, f420;
sub.f32 %9, f447, f452;
add.f32 %8, f420, f415;
sub.f32 %11, f438, f442;
add.f32 %10, f410, f406;
sub.f32 %13, f425, f433;
add.f32 %12, f401, f393;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y): "r"(smem), "l"(lut_sp_7_343), "l"(lut_sp_7_49), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<175, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<439>;
.reg .b32 r<21>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 1372, r2;
mov.u32 r4, %tid.x;
add.f32 f29, %19, %33;
add.f32 f30, %17, f29;
add.f32 f31, %22, %30;
add.f32 f32, f31, f30;
add.f32 f33, %25, %27;
add.f32 f34, f33, f32;
add.f32 f35, %21, %34;
add.f32 f36, %18, f35;
add.f32 f37, %24, %32;
add.f32 f38, f37, f36;
add.f32 f39, %26, %29;
add.f32 f40, f39, f38;
fma.rn.f32 f41, f29, 0f3F1F9D07, %17;
mul.f32 f42, f31, 0f3E63DC87;
sub.f32 f43, f41, f42;
mul.f32 f44, f33, 0f3F66A5E5;
sub.f32 f45, f43, f44;
sub.f32 f46, %21, %34;
mul.f32 f47, f46, 0f3F48261C;
sub.f32 f48, %24, %32;
mul.f32 f49, f48, 0fBF7994E0;
sub.f32 f50, f49, f47;
sub.f32 f51, %26, %29;
mul.f32 f52, f51, 0f3EDE2602;
sub.f32 f53, f50, f52;
sub.f32 f54, f45, f53;
add.f32 f55, f53, f45;
mul.f32 f56, f29, 0f3E63DC87;
sub.f32 f57, %17, f56;
mul.f32 f58, f31, 0f3F66A5E5;
sub.f32 f59, f57, f58;
fma.rn.f32 f60, f33, 0f3F1F9D07, f59;
mul.f32 f61, f46, 0f3F7994E0;
mul.f32 f62, f48, 0f3EDE2602;
sub.f32 f63, f62, f61;
fma.rn.f32 f64, f51, 0f3F48261C, f63;
sub.f32 f65, f60, f64;
add.f32 f66, f64, f60;
mul.f32 f67, f29, 0f3F66A5E5;
sub.f32 f68, %17, f67;
fma.rn.f32 f69, f31, 0f3F1F9D07, f68;
mul.f32 f70, f33, 0f3E63DC87;
sub.f32 f71, f69, f70;
mul.f32 f72, f46, 0f3EDE2602;
mul.f32 f73, f48, 0f3F48261C;
sub.f32 f74, f73, f72;
mul.f32 f75, f51, 0f3F7994E0;
sub.f32 f76, f74, f75;
sub.f32 f77, f71, f76;
add.f32 f78, f76, f71;
fma.rn.f32 f79, f35, 0f3F1F9D07, %18;
mul.f32 f80, f37, 0f3E63DC87;
sub.f32 f81, f79, f80;
mul.f32 f82, f39, 0f3F66A5E5;
sub.f32 f83, f81, f82;
sub.f32 f84, %19, %33;
mul.f32 f85, f84, 0f3F48261C;
sub.f32 f86, %22, %30;
mul.f32 f87, f86, 0fBF7994E0;
sub.f32 f88, f87, f85;
sub.f32 f89, %25, %27;
mul.f32 f90, f89, 0f3EDE2602;
sub.f32 f91, f88, f90;
add.f32 f92, f91, f83;
sub.f32 f93, f83, f91;
mul.f32 f94, f35, 0f3E63DC87;
sub.f32 f95, %18, f94;
mul.f32 f96, f37, 0f3F66A5E5;
sub.f32 f97, f95, f96;
fma.rn.f32 f98, f39, 0f3F1F9D07, f97;
mul.f32 f99, f84, 0f3F7994E0;
mul.f32 f100, f86, 0f3EDE2602;
sub.f32 f101, f100, f99;
fma.rn.f32 f102, f89, 0f3F48261C, f101;
add.f32 f103, f102, f98;
sub.f32 f104, f98, f102;
mul.f32 f105, f35, 0f3F66A5E5;
sub.f32 f106, %18, f105;
fma.rn.f32 f107, f37, 0f3F1F9D07, f106;
mul.f32 f108, f39, 0f3E63DC87;
sub.f32 f109, f107, f108;
mul.f32 f110, f84, 0f3EDE2602;
mul.f32 f111, f86, 0f3F48261C;
sub.f32 f112, f111, f110;
mul.f32 f113, f89, 0f3F7994E0;
sub.f32 f114, f112, f113;
add.f32 f115, f114, f109;
sub.f32 f116, f109, f114;
mul.wide.u32 rd2, r4, 1402438301;
shr.u64 rd3, rd2, 36;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 49;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f117, f118}, [rd6];
mul.f32 f121, f117, f54;
mul.f32 f122, f118, f92;
sub.f32 f123, f121, f122;
mul.f32 f124, f117, f92;
fma.rn.f32 f125, f118, f54, f124;
mul.f32 f126, f117, f117;
mul.f32 f127, f118, f118;
sub.f32 f128, f126, f127;
mul.f32 f129, f118, f117;
fma.rn.f32 f130, f118, f117, f129;
mul.f32 f131, f128, f65;
mul.f32 f132, f130, f103;
sub.f32 f133, f131, f132;
mul.f32 f134, f128, f103;
fma.rn.f32 f135, f130, f65, f134;
mul.f32 f136, f117, f128;
mul.f32 f137, f118, f130;
sub.f32 f138, f136, f137;
mul.f32 f139, f117, f130;
fma.rn.f32 f140, f118, f128, f139;
mul.f32 f141, f138, f77;
mul.f32 f142, f140, f115;
sub.f32 f143, f141, f142;
mul.f32 f144, f138, f115;
fma.rn.f32 f145, f140, f77, f144;
mul.f32 f146, f117, f138;
mul.f32 f147, f118, f140;
sub.f32 f148, f146, f147;
mul.f32 f149, f117, f140;
fma.rn.f32 f150, f118, f138, f149;
mul.f32 f151, f148, f78;
mul.f32 f152, f150, f116;
sub.f32 f153, f151, f152;
mul.f32 f154, f148, f116;
fma.rn.f32 f155, f150, f78, f154;
mul.f32 f156, f117, f148;
mul.f32 f157, f118, f150;
sub.f32 f158, f156, f157;
mul.f32 f159, f117, f150;
fma.rn.f32 f160, f118, f148, f159;
mul.f32 f161, f158, f66;
mul.f32 f162, f160, f104;
sub.f32 f163, f161, f162;
mul.f32 f164, f158, f104;
fma.rn.f32 f165, f160, f66, f164;
mul.f32 f166, f117, f158;
mul.f32 f167, f118, f160;
sub.f32 f168, f166, f167;
mul.f32 f169, f117, f160;
fma.rn.f32 f170, f118, f158, f169;
mul.f32 f171, f168, f55;
mul.f32 f172, f170, f93;
sub.f32 f173, f171, f172;
mul.f32 f174, f168, f93;
fma.rn.f32 f175, f170, f55, f174;
mad.lo.s32 r8, r5, 1372, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 28, r8;
st.shared.f32 [r9], f34;
st.shared.f32 [r9+4], f123;
st.shared.f32 [r9+8], f133;
st.shared.f32 [r9+12], f143;
st.shared.f32 [r9+16], f153;
st.shared.f32 [r9+20], f163;
st.shared.f32 [r9+24], f173;
barrier.sync 0;
mad.lo.s32 r10, r7, -24, r9;
ld.shared.f32 f176, [r10];
ld.shared.f32 f177, [r10+196];
ld.shared.f32 f178, [r10+392];
ld.shared.f32 f179, [r10+588];
ld.shared.f32 f180, [r10+784];
ld.shared.f32 f181, [r10+980];
ld.shared.f32 f182, [r10+1176];
barrier.sync 0;
st.shared.f32 [r9], f40;
st.shared.f32 [r9+4], f125;
st.shared.f32 [r9+8], f135;
st.shared.f32 [r9+12], f145;
st.shared.f32 [r9+16], f155;
st.shared.f32 [r9+20], f165;
st.shared.f32 [r9+24], f175;
barrier.sync 0;
ld.shared.f32 f183, [r10];
ld.shared.f32 f184, [r10+196];
ld.shared.f32 f185, [r10+392];
ld.shared.f32 f186, [r10+588];
ld.shared.f32 f187, [r10+784];
ld.shared.f32 f188, [r10+980];
ld.shared.f32 f189, [r10+1176];
add.f32 f190, f177, f182;
add.f32 f191, f176, f190;
add.f32 f192, f178, f181;
add.f32 f193, f192, f191;
add.f32 f194, f179, f180;
add.f32 f195, f194, f193;
add.f32 f196, f184, f189;
add.f32 f197, f183, f196;
add.f32 f198, f185, f188;
add.f32 f199, f198, f197;
add.f32 f200, f186, f187;
add.f32 f201, f200, f199;
fma.rn.f32 f202, f190, 0f3F1F9D07, f176;
mul.f32 f203, f192, 0f3E63DC87;
sub.f32 f204, f202, f203;
mul.f32 f205, f194, 0f3F66A5E5;
sub.f32 f206, f204, f205;
sub.f32 f207, f184, f189;
mul.f32 f208, f207, 0f3F48261C;
sub.f32 f209, f185, f188;
mul.f32 f210, f209, 0fBF7994E0;
sub.f32 f211, f210, f208;
sub.f32 f212, f186, f187;
mul.f32 f213, f212, 0f3EDE2602;
sub.f32 f214, f211, f213;
sub.f32 f215, f206, f214;
add.f32 f216, f214, f206;
mul.f32 f217, f190, 0f3E63DC87;
sub.f32 f218, f176, f217;
mul.f32 f219, f192, 0f3F66A5E5;
sub.f32 f220, f218, f219;
fma.rn.f32 f221, f194, 0f3F1F9D07, f220;
mul.f32 f222, f207, 0f3F7994E0;
mul.f32 f223, f209, 0f3EDE2602;
sub.f32 f224, f223, f222;
fma.rn.f32 f225, f212, 0f3F48261C, f224;
sub.f32 f226, f221, f225;
add.f32 f227, f225, f221;
mul.f32 f228, f190, 0f3F66A5E5;
sub.f32 f229, f176, f228;
fma.rn.f32 f230, f192, 0f3F1F9D07, f229;
mul.f32 f231, f194, 0f3E63DC87;
sub.f32 f232, f230, f231;
mul.f32 f233, f207, 0f3EDE2602;
mul.f32 f234, f209, 0f3F48261C;
sub.f32 f235, f234, f233;
mul.f32 f236, f212, 0f3F7994E0;
sub.f32 f237, f235, f236;
sub.f32 f238, f232, f237;
add.f32 f239, f237, f232;
fma.rn.f32 f240, f196, 0f3F1F9D07, f183;
mul.f32 f241, f198, 0f3E63DC87;
sub.f32 f242, f240, f241;
mul.f32 f243, f200, 0f3F66A5E5;
sub.f32 f244, f242, f243;
sub.f32 f245, f177, f182;
mul.f32 f246, f245, 0f3F48261C;
sub.f32 f247, f178, f181;
mul.f32 f248, f247, 0fBF7994E0;
sub.f32 f249, f248, f246;
sub.f32 f250, f179, f180;
mul.f32 f251, f250, 0f3EDE2602;
sub.f32 f252, f249, f251;
add.f32 f253, f252, f244;
sub.f32 f254, f244, f252;
mul.f32 f255, f196, 0f3E63DC87;
sub.f32 f256, f183, f255;
mul.f32 f257, f198, 0f3F66A5E5;
sub.f32 f258, f256, f257;
fma.rn.f32 f259, f200, 0f3F1F9D07, f258;
mul.f32 f260, f245, 0f3F7994E0;
mul.f32 f261, f247, 0f3EDE2602;
sub.f32 f262, f261, f260;
fma.rn.f32 f263, f250, 0f3F48261C, f262;
add.f32 f264, f263, f259;
sub.f32 f265, f259, f263;
mul.f32 f266, f196, 0f3F66A5E5;
sub.f32 f267, f183, f266;
fma.rn.f32 f268, f198, 0f3F1F9D07, f267;
mul.f32 f269, f200, 0f3E63DC87;
sub.f32 f270, f268, f269;
mul.f32 f271, f245, 0f3EDE2602;
mul.f32 f272, f247, 0f3F48261C;
sub.f32 f273, f272, f271;
mul.f32 f274, f250, 0f3F7994E0;
sub.f32 f275, f273, f274;
add.f32 f276, f275, f270;
sub.f32 f277, f270, f275;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 8;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f278, f279}, [rd11];
mul.f32 f282, f278, f215;
mul.f32 f283, f279, f253;
sub.f32 f284, f282, f283;
mul.f32 f285, f278, f253;
fma.rn.f32 f286, f279, f215, f285;
mul.f32 f287, f278, f278;
mul.f32 f288, f279, f279;
sub.f32 f289, f287, f288;
mul.f32 f290, f279, f278;
fma.rn.f32 f291, f279, f278, f290;
mul.f32 f292, f289, f226;
mul.f32 f293, f291, f264;
sub.f32 f294, f292, f293;
mul.f32 f295, f289, f264;
fma.rn.f32 f296, f291, f226, f295;
mul.f32 f297, f278, f289;
mul.f32 f298, f279, f291;
sub.f32 f299, f297, f298;
mul.f32 f300, f278, f291;
fma.rn.f32 f301, f279, f289, f300;
mul.f32 f302, f299, f238;
mul.f32 f303, f301, f276;
sub.f32 f304, f302, f303;
mul.f32 f305, f299, f276;
fma.rn.f32 f306, f301, f238, f305;
mul.f32 f307, f278, f299;
mul.f32 f308, f279, f301;
sub.f32 f309, f307, f308;
mul.f32 f310, f278, f301;
fma.rn.f32 f311, f279, f299, f310;
mul.f32 f312, f309, f239;
mul.f32 f313, f311, f277;
sub.f32 f314, f312, f313;
mul.f32 f315, f309, f277;
fma.rn.f32 f316, f311, f239, f315;
mul.f32 f317, f278, f309;
mul.f32 f318, f279, f311;
sub.f32 f319, f317, f318;
mul.f32 f320, f278, f311;
fma.rn.f32 f321, f279, f309, f320;
mul.f32 f322, f319, f227;
mul.f32 f323, f321, f265;
sub.f32 f324, f322, f323;
mul.f32 f325, f319, f265;
fma.rn.f32 f326, f321, f227, f325;
mul.f32 f327, f278, f319;
mul.f32 f328, f279, f321;
sub.f32 f329, f327, f328;
mul.f32 f330, f278, f321;
fma.rn.f32 f331, f279, f319, f330;
mul.f32 f332, f329, f216;
mul.f32 f333, f331, f254;
sub.f32 f334, f332, f333;
mul.f32 f335, f329, f254;
fma.rn.f32 f336, f331, f216, f335;
shl.b32 r18, r17, 2;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 196, r19;
st.shared.f32 [r20], f195;
st.shared.f32 [r20+28], f284;
st.shared.f32 [r20+56], f294;
st.shared.f32 [r20+84], f304;
st.shared.f32 [r20+112], f314;
st.shared.f32 [r20+140], f324;
st.shared.f32 [r20+168], f334;
barrier.sync 0;
ld.shared.f32 f337, [r10];
ld.shared.f32 f338, [r10+196];
ld.shared.f32 f339, [r10+392];
ld.shared.f32 f340, [r10+588];
ld.shared.f32 f341, [r10+784];
ld.shared.f32 f342, [r10+980];
ld.shared.f32 f343, [r10+1176];
barrier.sync 0;
st.shared.f32 [r20], f201;
st.shared.f32 [r20+28], f286;
st.shared.f32 [r20+56], f296;
st.shared.f32 [r20+84], f306;
st.shared.f32 [r20+112], f316;
st.shared.f32 [r20+140], f326;
st.shared.f32 [r20+168], f336;
barrier.sync 0;
ld.shared.f32 f344, [r10];
ld.shared.f32 f345, [r10+196];
ld.shared.f32 f346, [r10+392];
ld.shared.f32 f347, [r10+588];
ld.shared.f32 f348, [r10+784];
ld.shared.f32 f349, [r10+980];
ld.shared.f32 f350, [r10+1176];
add.f32 f351, f338, f343;
add.f32 f352, f337, f351;
add.f32 f353, f339, f342;
add.f32 f354, f353, f352;
add.f32 f355, f340, f341;
add.f32 f356, f345, f350;
add.f32 f357, f344, f356;
add.f32 f358, f346, f349;
add.f32 f359, f358, f357;
add.f32 f360, f347, f348;
fma.rn.f32 f361, f351, 0f3F1F9D07, f337;
mul.f32 f362, f353, 0f3E63DC87;
sub.f32 f363, f361, f362;
mul.f32 f364, f355, 0f3F66A5E5;
sub.f32 f365, f363, f364;
sub.f32 f366, f345, f350;
mul.f32 f367, f366, 0f3F48261C;
sub.f32 f368, f346, f349;
mul.f32 f369, f368, 0fBF7994E0;
sub.f32 f370, f369, f367;
sub.f32 f371, f347, f348;
mul.f32 f372, f371, 0f3EDE2602;
sub.f32 f373, f370, f372;
mul.f32 f374, f351, 0f3E63DC87;
sub.f32 f375, f337, f374;
mul.f32 f376, f353, 0f3F66A5E5;
sub.f32 f377, f375, f376;
fma.rn.f32 f378, f355, 0f3F1F9D07, f377;
mul.f32 f379, f366, 0f3F7994E0;
mul.f32 f380, f368, 0f3EDE2602;
sub.f32 f381, f380, f379;
fma.rn.f32 f382, f371, 0f3F48261C, f381;
mul.f32 f383, f351, 0f3F66A5E5;
sub.f32 f384, f337, f383;
fma.rn.f32 f385, f353, 0f3F1F9D07, f384;
mul.f32 f386, f355, 0f3E63DC87;
sub.f32 f387, f385, f386;
mul.f32 f388, f366, 0f3EDE2602;
mul.f32 f389, f368, 0f3F48261C;
sub.f32 f390, f389, f388;
mul.f32 f391, f371, 0f3F7994E0;
sub.f32 f392, f390, f391;
fma.rn.f32 f393, f356, 0f3F1F9D07, f344;
mul.f32 f394, f358, 0f3E63DC87;
sub.f32 f395, f393, f394;
mul.f32 f396, f360, 0f3F66A5E5;
sub.f32 f397, f395, f396;
sub.f32 f398, f338, f343;
mul.f32 f399, f398, 0f3F48261C;
sub.f32 f400, f339, f342;
mul.f32 f401, f400, 0fBF7994E0;
sub.f32 f402, f401, f399;
sub.f32 f403, f340, f341;
mul.f32 f404, f403, 0f3EDE2602;
sub.f32 f405, f402, f404;
mul.f32 f406, f356, 0f3E63DC87;
sub.f32 f407, f344, f406;
mul.f32 f408, f358, 0f3F66A5E5;
sub.f32 f409, f407, f408;
fma.rn.f32 f410, f360, 0f3F1F9D07, f409;
mul.f32 f411, f398, 0f3F7994E0;
mul.f32 f412, f400, 0f3EDE2602;
sub.f32 f413, f412, f411;
fma.rn.f32 f414, f403, 0f3F48261C, f413;
mul.f32 f415, f356, 0f3F66A5E5;
sub.f32 f416, f344, f415;
fma.rn.f32 f417, f358, 0f3F1F9D07, f416;
mul.f32 f418, f360, 0f3E63DC87;
sub.f32 f419, f417, f418;
mul.f32 f420, f398, 0f3EDE2602;
mul.f32 f421, f400, 0f3F48261C;
sub.f32 f422, f421, f420;
mul.f32 f423, f403, 0f3F7994E0;
sub.f32 f424, f422, f423;
add.f32 %0, f355, f354;
add.f32 %1, f360, f359;
add.f32 %3, f405, f397;
sub.f32 %2, f365, f373;
sub.f32 %4, f378, f382;
add.f32 %5, f414, f410;
sub.f32 %6, f387, f392;
add.f32 %7, f424, f419;
add.f32 %8, f392, f387;
sub.f32 %9, f419, f424;
add.f32 %10, f382, f378;
sub.f32 %11, f410, f414;
sub.f32 %13, f397, f405;
add.f32 %12, f373, f365;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y): "r"(smem), "l"(lut_sp_7_343), "l"(lut_sp_7_49), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y));
};


#endif
