#ifndef CUFFTDX_FFT_8192_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_8192_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<1162, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<59>;
.reg .f64 fd<1513>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 17;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f64 fd65, %36, %52;
sub.f64 fd67, %36, %52;
add.f64 fd1498, %37, %68;
sub.f64 fd68, %37, %68;
add.f64 fd69, %44, %60;
sub.f64 fd71, %44, %60;
add.f64 fd1496, %69, %61;
sub.f64 fd72, %69, %61;
add.f64 fd73, fd65, fd69;
sub.f64 fd75, fd65, fd69;
add.f64 fd1495, fd1498, fd1496;
sub.f64 fd76, fd1498, fd1496;
add.f64 fd77, fd67, fd72;
sub.f64 fd79, fd67, fd72;
sub.f64 fd1494, fd68, fd71;
add.f64 fd80, fd68, fd71;
add.f64 fd81, %40, %56;
sub.f64 fd83, %40, %56;
add.f64 fd1491, %71, %70;
sub.f64 fd84, %71, %70;
add.f64 fd85, %48, %64;
sub.f64 fd87, %48, %64;
add.f64 fd1489, %49, %72;
sub.f64 fd88, %49, %72;
add.f64 fd89, fd81, fd85;
sub.f64 fd91, fd81, fd85;
add.f64 fd1488, fd1491, fd1489;
sub.f64 fd92, fd1491, fd1489;
add.f64 fd93, fd83, fd88;
sub.f64 fd95, fd83, fd88;
sub.f64 fd1487, fd84, fd87;
add.f64 fd96, fd84, fd87;
mul.f64 fd98, fd1487, 0dBFE6A09E667F3BCD;
mul.f64 fd1486, fd93, 0d3FE6A09E667F3BCD;
sub.f64 fd99, fd1486, fd98;
mul.f64 fd100, fd1487, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd101, fd93, 0dBFE6A09E667F3BCD, fd100;
mul.f64 fd102, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd103, fd96, 0dBFE6A09E667F3BCD;
sub.f64 fd104, fd102, fd103;
add.f64 fd105, fd102, fd103;
add.f64 fd106, fd73, fd89;
sub.f64 fd108, fd73, fd89;
add.f64 fd1485, fd1495, fd1488;
sub.f64 fd109, fd1495, fd1488;
add.f64 fd110, fd77, fd99;
sub.f64 fd112, fd77, fd99;
add.f64 fd1484, fd1494, fd101;
sub.f64 fd113, fd1494, fd101;
add.f64 fd114, fd75, fd92;
sub.f64 fd116, fd75, fd92;
sub.f64 fd1483, fd76, fd91;
add.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd104;
sub.f64 fd120, fd79, fd104;
add.f64 fd1482, fd80, fd105;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %38, %54;
sub.f64 fd124, %38, %54;
add.f64 fd1480, %73, %55;
sub.f64 fd125, %73, %55;
add.f64 fd126, %46, %62;
sub.f64 fd128, %46, %62;
add.f64 fd1477, %74, %75;
sub.f64 fd129, %74, %75;
add.f64 fd130, fd122, fd126;
sub.f64 fd132, fd122, fd126;
add.f64 fd1476, fd1480, fd1477;
sub.f64 fd133, fd1480, fd1477;
add.f64 fd134, fd124, fd129;
sub.f64 fd136, fd124, fd129;
sub.f64 fd1475, fd125, fd128;
add.f64 fd137, fd125, fd128;
add.f64 fd138, %42, %58;
sub.f64 fd140, %42, %58;
add.f64 fd1473, %43, %76;
sub.f64 fd141, %43, %76;
add.f64 fd142, %50, %66;
sub.f64 fd144, %50, %66;
add.f64 fd1471, %77, %67;
sub.f64 fd145, %77, %67;
add.f64 fd146, fd138, fd142;
sub.f64 fd148, fd138, fd142;
add.f64 fd1470, fd1473, fd1471;
sub.f64 fd149, fd1473, fd1471;
add.f64 fd150, fd140, fd145;
sub.f64 fd152, fd140, fd145;
sub.f64 fd1469, fd141, fd144;
add.f64 fd153, fd141, fd144;
mul.f64 fd155, fd1469, 0dBFE6A09E667F3BCD;
mul.f64 fd1468, fd150, 0d3FE6A09E667F3BCD;
sub.f64 fd156, fd1468, fd155;
mul.f64 fd157, fd1469, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd158, fd150, 0dBFE6A09E667F3BCD, fd157;
mul.f64 fd159, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd160, fd153, 0dBFE6A09E667F3BCD;
sub.f64 fd161, fd159, fd160;
add.f64 fd162, fd159, fd160;
add.f64 fd163, fd130, fd146;
sub.f64 fd165, fd130, fd146;
add.f64 fd1467, fd1476, fd1470;
sub.f64 fd166, fd1476, fd1470;
add.f64 fd167, fd134, fd156;
sub.f64 fd169, fd134, fd156;
add.f64 fd1466, fd1475, fd158;
sub.f64 fd170, fd1475, fd158;
add.f64 fd171, fd132, fd149;
sub.f64 fd173, fd132, fd149;
sub.f64 fd1465, fd133, fd148;
add.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd161;
sub.f64 fd177, fd136, fd161;
add.f64 fd1464, fd137, fd162;
sub.f64 fd178, fd137, fd162;
mul.f64 fd1462, fd167, 0d3FED906BCF328D46;
mul.f64 fd1463, fd1466, 0dBFD87DE2A6AEA963;
sub.f64 fd181, fd1462, fd1463;
mul.f64 fd182, fd1466, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0dBFD87DE2A6AEA963, fd182;
mul.f64 fd1460, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd1461, fd1465, 0dBFE6A09E667F3BCD;
sub.f64 fd186, fd1460, fd1461;
mul.f64 fd187, fd1465, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd188, fd171, 0dBFE6A09E667F3BCD, fd187;
mul.f64 fd1458, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd1459, fd1464, 0dBFED906BCF328D46;
sub.f64 fd191, fd1458, fd1459;
mul.f64 fd192, fd1464, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd193, fd175, 0dBFED906BCF328D46, fd192;
mul.f64 fd1456, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd1457, fd170, 0dBFED906BCF328D46;
sub.f64 fd196, fd1456, fd1457;
mul.f64 fd197, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd198, fd169, 0dBFED906BCF328D46, fd197;
mul.f64 fd199, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd200, fd174, 0dBFE6A09E667F3BCD;
sub.f64 fd201, fd199, fd200;
add.f64 fd202, fd199, fd200;
mul.f64 fd1454, fd177, 0dBFED906BCF328D46;
mul.f64 fd1455, fd178, 0dBFD87DE2A6AEA963;
sub.f64 fd205, fd1454, fd1455;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0dBFD87DE2A6AEA963, fd206;
add.f64 fd210, fd110, fd181;
sub.f64 fd212, fd110, fd181;
add.f64 fd1453, fd1484, fd183;
sub.f64 fd213, fd1484, fd183;
add.f64 fd214, fd114, fd186;
sub.f64 fd216, fd114, fd186;
add.f64 fd1452, fd1483, fd188;
sub.f64 fd217, fd1483, fd188;
add.f64 fd218, fd118, fd191;
sub.f64 fd220, fd118, fd191;
add.f64 fd1451, fd1482, fd193;
sub.f64 fd221, fd1482, fd193;
add.f64 fd222, fd108, fd166;
sub.f64 fd224, fd108, fd166;
sub.f64 fd1450, fd109, fd165;
add.f64 fd225, fd109, fd165;
add.f64 fd226, fd112, fd196;
sub.f64 fd228, fd112, fd196;
add.f64 fd1449, fd113, fd198;
sub.f64 fd229, fd113, fd198;
add.f64 fd230, fd116, fd201;
sub.f64 fd232, fd116, fd201;
add.f64 fd1448, fd117, fd202;
sub.f64 fd233, fd117, fd202;
add.f64 fd234, fd120, fd205;
sub.f64 fd236, fd120, fd205;
add.f64 fd1447, fd121, fd207;
sub.f64 fd237, fd121, fd207;
mov.u32 r28, %tid.x;
shl.b32 r7, r28, 8;
and.b32 r8, r7, -131072;
add.s32 r9, r4, r8;
shl.b32 r10, r28, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 8176;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd238, fd239}, [rd5];
mul.f64 fd243, fd239, fd1453;
mul.f64 fd244, fd238, fd1453;
mul.f64 fd246, fd239, fd239;
mul.f64 fd1446, fd238, fd238;
sub.f64 fd247, fd1446, fd246;
mul.f64 fd248, fd239, fd238;
fma.rn.f64 fd249, fd239, fd238, fd248;
mul.f64 fd251, fd249, fd1452;
mul.f64 fd252, fd247, fd1452;
mul.f64 fd1444, fd238, fd247;
mul.f64 fd1445, fd239, fd249;
sub.f64 fd255, fd1444, fd1445;
mul.f64 fd1443, fd247, fd214;
mul.f64 fd256, fd238, fd249;
fma.rn.f64 fd257, fd239, fd247, fd256;
mul.f64 fd259, fd257, fd1451;
mul.f64 fd260, fd255, fd1451;
mul.f64 fd262, fd239, fd257;
mul.f64 fd1442, fd238, fd255;
sub.f64 fd263, fd1442, fd262;
mul.f64 fd1441, fd255, fd218;
mul.f64 fd264, fd238, fd257;
fma.rn.f64 fd265, fd239, fd255, fd264;
mul.f64 fd267, fd265, fd1450;
mul.f64 fd268, fd263, fd1450;
mul.f64 fd270, fd239, fd265;
mul.f64 fd1440, fd238, fd263;
sub.f64 fd271, fd1440, fd270;
mul.f64 fd1439, fd263, fd222;
mul.f64 fd272, fd238, fd265;
fma.rn.f64 fd273, fd239, fd263, fd272;
mul.f64 fd275, fd273, fd1449;
mul.f64 fd276, fd271, fd1449;
mul.f64 fd1437, fd238, fd271;
mul.f64 fd1438, fd239, fd273;
sub.f64 fd279, fd1437, fd1438;
mul.f64 fd1436, fd271, fd226;
mul.f64 fd280, fd238, fd273;
fma.rn.f64 fd281, fd239, fd271, fd280;
mul.f64 fd283, fd281, fd1448;
mul.f64 fd284, fd279, fd1448;
mul.f64 fd286, fd239, fd281;
mul.f64 fd1435, fd238, fd279;
sub.f64 fd287, fd1435, fd286;
mul.f64 fd1434, fd279, fd230;
mul.f64 fd288, fd238, fd281;
fma.rn.f64 fd289, fd239, fd279, fd288;
mul.f64 fd291, fd289, fd1447;
mul.f64 fd292, fd287, fd1447;
mul.f64 fd294, fd239, fd289;
mul.f64 fd1433, fd238, fd287;
sub.f64 fd295, fd1433, fd294;
mul.f64 fd1432, fd287, fd234;
mul.f64 fd296, fd238, fd289;
fma.rn.f64 fd297, fd239, fd287, fd296;
sub.f64 fd1431, fd1485, fd1467;
sub.f64 fd1430, fd106, fd163;
mul.f64 fd298, fd295, fd1430;
mul.f64 fd299, fd297, fd1431;
mul.f64 fd300, fd295, fd1431;
ld.global.v2.f64 {fd301, fd302}, [rd5+8192];
mul.f64 fd306, fd302, fd213;
mul.f64 fd307, fd301, fd213;
mul.f64 fd1428, fd238, fd301;
mul.f64 fd1429, fd239, fd302;
sub.f64 fd310, fd1428, fd1429;
mul.f64 fd1427, fd301, fd212;
mul.f64 fd311, fd238, fd302;
fma.rn.f64 fd312, fd239, fd301, fd311;
mul.f64 fd314, fd312, fd217;
mul.f64 fd315, fd310, fd217;
mul.f64 fd317, fd239, fd312;
mul.f64 fd1426, fd238, fd310;
sub.f64 fd318, fd1426, fd317;
mul.f64 fd1425, fd310, fd216;
mul.f64 fd319, fd238, fd312;
fma.rn.f64 fd320, fd239, fd310, fd319;
mul.f64 fd322, fd320, fd221;
mul.f64 fd323, fd318, fd221;
mul.f64 fd1423, fd238, fd318;
mul.f64 fd1424, fd239, fd320;
sub.f64 fd326, fd1423, fd1424;
mul.f64 fd1422, fd318, fd220;
mul.f64 fd327, fd238, fd320;
fma.rn.f64 fd328, fd239, fd318, fd327;
mul.f64 fd330, fd328, fd225;
mul.f64 fd331, fd326, fd225;
mul.f64 fd1420, fd238, fd326;
mul.f64 fd1421, fd239, fd328;
sub.f64 fd334, fd1420, fd1421;
mul.f64 fd1419, fd326, fd224;
mul.f64 fd335, fd238, fd328;
fma.rn.f64 fd336, fd239, fd326, fd335;
mul.f64 fd338, fd336, fd229;
mul.f64 fd339, fd334, fd229;
mul.f64 fd341, fd239, fd336;
mul.f64 fd1418, fd238, fd334;
sub.f64 fd342, fd1418, fd341;
mul.f64 fd1417, fd334, fd228;
mul.f64 fd343, fd238, fd336;
fma.rn.f64 fd344, fd239, fd334, fd343;
mul.f64 fd346, fd344, fd233;
mul.f64 fd347, fd342, fd233;
mul.f64 fd1415, fd238, fd342;
mul.f64 fd1416, fd239, fd344;
sub.f64 fd350, fd1415, fd1416;
mul.f64 fd1414, fd238, fd210;
mul.f64 fd351, fd238, fd344;
mul.f64 fd1413, fd342, fd232;
fma.rn.f64 fd352, fd239, fd342, fd351;
mul.f64 fd353, fd350, fd236;
mul.f64 fd354, fd352, fd237;
mul.f64 fd355, fd350, fd237;
barrier.sync 0;
and.b32 r11, r7, 130816;
add.s32 r12, r9, r11;
sub.f64 fd1512, fd1485, fd1467;
mul.f64 fd1511, fd297, fd1512;
add.f64 fd356, fd1485, fd1467;
and.b32 r34, r7, 130816;
add.s32 r33, r9, r34;
sub.f64 fd1510, fd106, fd163;
add.f64 fd357, fd106, fd163;
and.b32 r52, r7, 130816;
add.s32 r51, r9, r52;
st.shared.v2.f64 [r51], {fd357, fd356};
mov.u32 r50, %tid.x;
fma.rn.f64 fd358, fd239, fd210, fd244;
sub.f64 fd359, fd1414, fd243;
st.shared.v2.f64 [r51+16], {fd359, fd358};
fma.rn.f64 fd360, fd249, fd214, fd252;
sub.f64 fd361, fd1443, fd251;
st.shared.v2.f64 [r51+32], {fd361, fd360};
fma.rn.f64 fd362, fd257, fd218, fd260;
sub.f64 fd363, fd1441, fd259;
st.shared.v2.f64 [r51+48], {fd363, fd362};
sub.f64 fd364, fd1439, fd267;
fma.rn.f64 fd365, fd265, fd222, fd268;
st.shared.v2.f64 [r51+64], {fd364, fd365};
fma.rn.f64 fd366, fd273, fd226, fd276;
sub.f64 fd367, fd1436, fd275;
st.shared.v2.f64 [r51+80], {fd367, fd366};
fma.rn.f64 fd368, fd281, fd230, fd284;
sub.f64 fd369, fd1434, fd283;
st.shared.v2.f64 [r51+96], {fd369, fd368};
fma.rn.f64 fd370, fd289, fd234, fd292;
sub.f64 fd371, fd1432, fd291;
st.shared.v2.f64 [r51+112], {fd371, fd370};
fma.rn.f64 fd372, fd297, fd1510, fd300;
sub.f64 fd373, fd298, fd1511;
st.shared.v2.f64 [r51+128], {fd373, fd372};
fma.rn.f64 fd374, fd302, fd212, fd307;
sub.f64 fd375, fd1427, fd306;
st.shared.v2.f64 [r51+144], {fd375, fd374};
fma.rn.f64 fd376, fd312, fd216, fd315;
sub.f64 fd377, fd1425, fd314;
st.shared.v2.f64 [r51+160], {fd377, fd376};
fma.rn.f64 fd378, fd320, fd220, fd323;
sub.f64 fd379, fd1422, fd322;
st.shared.v2.f64 [r51+176], {fd379, fd378};
sub.f64 fd380, fd1419, fd330;
fma.rn.f64 fd381, fd328, fd224, fd331;
st.shared.v2.f64 [r51+192], {fd380, fd381};
fma.rn.f64 fd382, fd336, fd228, fd339;
sub.f64 fd383, fd1417, fd338;
st.shared.v2.f64 [r51+208], {fd383, fd382};
fma.rn.f64 fd384, fd344, fd232, fd347;
sub.f64 fd385, fd1413, fd346;
st.shared.v2.f64 [r51+224], {fd385, fd384};
fma.rn.f64 fd386, fd352, fd236, fd355;
sub.f64 fd387, fd353, fd354;
st.shared.v2.f64 [r51+240], {fd387, fd386};
barrier.sync 0;
and.b32 r27, r50, 511;
mad.lo.s32 r13, r27, -240, r51;
ld.shared.v2.f64 {fd388, fd389}, [r13];
ld.shared.v2.f64 {fd392, fd393}, [r13+8192];
ld.shared.v2.f64 {fd396, fd397}, [r13+16384];
ld.shared.v2.f64 {fd400, fd401}, [r13+24576];
ld.shared.v2.f64 {fd404, fd405}, [r13+32768];
ld.shared.v2.f64 {fd408, fd409}, [r13+40960];
ld.shared.v2.f64 {fd412, fd413}, [r13+49152];
ld.shared.v2.f64 {fd416, fd417}, [r13+57344];
ld.shared.v2.f64 {fd420, fd421}, [r13+65536];
ld.shared.v2.f64 {fd424, fd425}, [r13+73728];
ld.shared.v2.f64 {fd428, fd429}, [r13+81920];
ld.shared.v2.f64 {fd432, fd433}, [r13+90112];
ld.shared.v2.f64 {fd436, fd437}, [r13+98304];
ld.shared.v2.f64 {fd440, fd441}, [r13+106496];
ld.shared.v2.f64 {fd444, fd445}, [r13+114688];
ld.shared.v2.f64 {fd448, fd449}, [r13+122880];
add.f64 fd452, fd388, fd420;
sub.f64 fd454, fd388, fd420;
add.f64 fd1412, fd389, fd421;
sub.f64 fd455, fd389, fd421;
add.f64 fd456, fd404, fd436;
sub.f64 fd458, fd404, fd436;
add.f64 fd1411, fd405, fd437;
sub.f64 fd459, fd405, fd437;
add.f64 fd460, fd452, fd456;
sub.f64 fd462, fd452, fd456;
add.f64 fd1410, fd1412, fd1411;
sub.f64 fd463, fd1412, fd1411;
add.f64 fd464, fd454, fd459;
sub.f64 fd466, fd454, fd459;
sub.f64 fd1409, fd455, fd458;
add.f64 fd467, fd455, fd458;
add.f64 fd468, fd396, fd428;
sub.f64 fd470, fd396, fd428;
add.f64 fd1408, fd397, fd429;
sub.f64 fd471, fd397, fd429;
add.f64 fd472, fd412, fd444;
sub.f64 fd474, fd412, fd444;
add.f64 fd1407, fd413, fd445;
sub.f64 fd475, fd413, fd445;
add.f64 fd476, fd468, fd472;
sub.f64 fd478, fd468, fd472;
add.f64 fd1406, fd1408, fd1407;
sub.f64 fd479, fd1408, fd1407;
add.f64 fd480, fd470, fd475;
sub.f64 fd482, fd470, fd475;
sub.f64 fd1405, fd471, fd474;
add.f64 fd483, fd471, fd474;
mul.f64 fd485, fd1405, 0dBFE6A09E667F3BCD;
mul.f64 fd1404, fd480, 0d3FE6A09E667F3BCD;
sub.f64 fd486, fd1404, fd485;
mul.f64 fd487, fd1405, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd488, fd480, 0dBFE6A09E667F3BCD, fd487;
mul.f64 fd489, fd482, 0dBFE6A09E667F3BCD;
mul.f64 fd490, fd483, 0dBFE6A09E667F3BCD;
sub.f64 fd491, fd489, fd490;
add.f64 fd492, fd489, fd490;
add.f64 fd493, fd460, fd476;
sub.f64 fd495, fd460, fd476;
add.f64 fd1403, fd1410, fd1406;
sub.f64 fd496, fd1410, fd1406;
add.f64 fd497, fd464, fd486;
sub.f64 fd499, fd464, fd486;
add.f64 fd1402, fd1409, fd488;
sub.f64 fd500, fd1409, fd488;
add.f64 fd501, fd462, fd479;
sub.f64 fd503, fd462, fd479;
sub.f64 fd1401, fd463, fd478;
add.f64 fd504, fd463, fd478;
add.f64 fd505, fd466, fd491;
sub.f64 fd507, fd466, fd491;
add.f64 fd1400, fd467, fd492;
sub.f64 fd508, fd467, fd492;
add.f64 fd509, fd392, fd424;
sub.f64 fd511, fd392, fd424;
add.f64 fd1399, fd393, fd425;
sub.f64 fd512, fd393, fd425;
add.f64 fd513, fd408, fd440;
sub.f64 fd515, fd408, fd440;
add.f64 fd1398, fd409, fd441;
sub.f64 fd516, fd409, fd441;
add.f64 fd517, fd509, fd513;
sub.f64 fd519, fd509, fd513;
add.f64 fd1397, fd1399, fd1398;
sub.f64 fd520, fd1399, fd1398;
add.f64 fd521, fd511, fd516;
sub.f64 fd523, fd511, fd516;
sub.f64 fd1396, fd512, fd515;
add.f64 fd524, fd512, fd515;
add.f64 fd525, fd400, fd432;
sub.f64 fd527, fd400, fd432;
add.f64 fd1395, fd401, fd433;
sub.f64 fd528, fd401, fd433;
add.f64 fd529, fd416, fd448;
sub.f64 fd531, fd416, fd448;
add.f64 fd1394, fd417, fd449;
sub.f64 fd532, fd417, fd449;
add.f64 fd533, fd525, fd529;
sub.f64 fd535, fd525, fd529;
add.f64 fd1393, fd1395, fd1394;
sub.f64 fd536, fd1395, fd1394;
add.f64 fd537, fd527, fd532;
sub.f64 fd539, fd527, fd532;
sub.f64 fd1392, fd528, fd531;
add.f64 fd540, fd528, fd531;
mul.f64 fd542, fd1392, 0dBFE6A09E667F3BCD;
mul.f64 fd1391, fd537, 0d3FE6A09E667F3BCD;
sub.f64 fd543, fd1391, fd542;
mul.f64 fd544, fd1392, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd545, fd537, 0dBFE6A09E667F3BCD, fd544;
mul.f64 fd546, fd539, 0dBFE6A09E667F3BCD;
mul.f64 fd547, fd540, 0dBFE6A09E667F3BCD;
sub.f64 fd548, fd546, fd547;
add.f64 fd549, fd546, fd547;
add.f64 fd550, fd517, fd533;
sub.f64 fd552, fd517, fd533;
add.f64 fd1390, fd1397, fd1393;
sub.f64 fd553, fd1397, fd1393;
add.f64 fd554, fd521, fd543;
sub.f64 fd556, fd521, fd543;
add.f64 fd1389, fd1396, fd545;
sub.f64 fd557, fd1396, fd545;
add.f64 fd558, fd519, fd536;
sub.f64 fd560, fd519, fd536;
sub.f64 fd1388, fd520, fd535;
add.f64 fd561, fd520, fd535;
add.f64 fd562, fd523, fd548;
sub.f64 fd564, fd523, fd548;
add.f64 fd1387, fd524, fd549;
sub.f64 fd565, fd524, fd549;
mul.f64 fd1385, fd554, 0d3FED906BCF328D46;
mul.f64 fd1386, fd1389, 0dBFD87DE2A6AEA963;
sub.f64 fd568, fd1385, fd1386;
mul.f64 fd569, fd1389, 0d3FED906BCF328D46;
fma.rn.f64 fd570, fd554, 0dBFD87DE2A6AEA963, fd569;
mul.f64 fd572, fd1388, 0dBFE6A09E667F3BCD;
mul.f64 fd1384, fd558, 0d3FE6A09E667F3BCD;
sub.f64 fd573, fd1384, fd572;
mul.f64 fd574, fd1388, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd575, fd558, 0dBFE6A09E667F3BCD, fd574;
mul.f64 fd577, fd1387, 0dBFED906BCF328D46;
mul.f64 fd1383, fd562, 0d3FD87DE2A6AEA963;
sub.f64 fd578, fd1383, fd577;
mul.f64 fd579, fd1387, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd580, fd562, 0dBFED906BCF328D46, fd579;
mul.f64 fd582, fd557, 0dBFED906BCF328D46;
mul.f64 fd1382, fd556, 0dBFD87DE2A6AEA963;
sub.f64 fd583, fd1382, fd582;
mul.f64 fd584, fd557, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd585, fd556, 0dBFED906BCF328D46, fd584;
mul.f64 fd586, fd560, 0dBFE6A09E667F3BCD;
mul.f64 fd587, fd561, 0dBFE6A09E667F3BCD;
sub.f64 fd588, fd586, fd587;
add.f64 fd589, fd586, fd587;
mul.f64 fd591, fd565, 0dBFD87DE2A6AEA963;
mul.f64 fd1381, fd564, 0dBFED906BCF328D46;
sub.f64 fd592, fd1381, fd591;
mul.f64 fd593, fd565, 0dBFED906BCF328D46;
fma.rn.f64 fd594, fd564, 0dBFD87DE2A6AEA963, fd593;
add.f64 fd597, fd497, fd568;
sub.f64 fd599, fd497, fd568;
add.f64 fd1380, fd1402, fd570;
sub.f64 fd600, fd1402, fd570;
add.f64 fd601, fd501, fd573;
sub.f64 fd603, fd501, fd573;
add.f64 fd1379, fd1401, fd575;
sub.f64 fd604, fd1401, fd575;
add.f64 fd605, fd505, fd578;
sub.f64 fd607, fd505, fd578;
add.f64 fd1378, fd1400, fd580;
sub.f64 fd608, fd1400, fd580;
add.f64 fd609, fd495, fd553;
sub.f64 fd611, fd495, fd553;
sub.f64 fd1377, fd496, fd552;
add.f64 fd612, fd496, fd552;
add.f64 fd613, fd499, fd583;
sub.f64 fd615, fd499, fd583;
add.f64 fd1376, fd500, fd585;
sub.f64 fd616, fd500, fd585;
add.f64 fd617, fd503, fd588;
sub.f64 fd619, fd503, fd588;
add.f64 fd1375, fd504, fd589;
sub.f64 fd620, fd504, fd589;
add.f64 fd621, fd507, fd592;
sub.f64 fd623, fd507, fd592;
add.f64 fd1374, fd508, fd594;
sub.f64 fd624, fd508, fd594;
and.b32 r14, r50, 496;
mov.u64 rd7, %34;
cvt.u64.u32 rd12, r14;
add.s64 rd8, rd7, rd12;
ld.global.v2.f64 {fd625, fd626}, [rd8];
mul.f64 fd630, fd626, fd1380;
mul.f64 fd631, fd625, fd1380;
mul.f64 fd633, fd626, fd626;
mul.f64 fd1373, fd625, fd625;
sub.f64 fd634, fd1373, fd633;
mul.f64 fd635, fd626, fd625;
fma.rn.f64 fd636, fd626, fd625, fd635;
mul.f64 fd638, fd636, fd1379;
mul.f64 fd639, fd634, fd1379;
mul.f64 fd1371, fd625, fd634;
mul.f64 fd1372, fd626, fd636;
sub.f64 fd642, fd1371, fd1372;
mul.f64 fd1370, fd634, fd601;
mul.f64 fd643, fd625, fd636;
fma.rn.f64 fd644, fd626, fd634, fd643;
mul.f64 fd646, fd644, fd1378;
mul.f64 fd647, fd642, fd1378;
mul.f64 fd649, fd626, fd644;
mul.f64 fd1369, fd625, fd642;
sub.f64 fd650, fd1369, fd649;
mul.f64 fd1368, fd642, fd605;
mul.f64 fd651, fd625, fd644;
fma.rn.f64 fd652, fd626, fd642, fd651;
mul.f64 fd654, fd652, fd1377;
mul.f64 fd655, fd650, fd1377;
mul.f64 fd1366, fd625, fd650;
mul.f64 fd1367, fd626, fd652;
sub.f64 fd658, fd1366, fd1367;
mul.f64 fd1365, fd650, fd609;
mul.f64 fd659, fd625, fd652;
fma.rn.f64 fd660, fd626, fd650, fd659;
mul.f64 fd662, fd660, fd1376;
mul.f64 fd663, fd658, fd1376;
mul.f64 fd1363, fd625, fd658;
mul.f64 fd1364, fd626, fd660;
sub.f64 fd666, fd1363, fd1364;
mul.f64 fd1362, fd658, fd613;
mul.f64 fd667, fd625, fd660;
fma.rn.f64 fd668, fd626, fd658, fd667;
mul.f64 fd670, fd668, fd1375;
mul.f64 fd671, fd666, fd1375;
mul.f64 fd673, fd626, fd668;
mul.f64 fd1361, fd625, fd666;
sub.f64 fd674, fd1361, fd673;
mul.f64 fd1360, fd666, fd617;
mul.f64 fd675, fd625, fd668;
fma.rn.f64 fd676, fd626, fd666, fd675;
mul.f64 fd678, fd676, fd1374;
mul.f64 fd679, fd674, fd1374;
mul.f64 fd1358, fd625, fd674;
mul.f64 fd1359, fd626, fd676;
sub.f64 fd682, fd1358, fd1359;
mul.f64 fd1357, fd674, fd621;
mul.f64 fd683, fd625, fd676;
fma.rn.f64 fd684, fd626, fd674, fd683;
sub.f64 fd1356, fd1403, fd1390;
sub.f64 fd1355, fd493, fd550;
mul.f64 fd685, fd682, fd1355;
mul.f64 fd686, fd684, fd1356;
mul.f64 fd687, fd682, fd1356;
ld.global.v2.f64 {fd688, fd689}, [rd8+512];
mul.f64 fd693, fd689, fd600;
mul.f64 fd694, fd688, fd600;
mul.f64 fd696, fd626, fd689;
mul.f64 fd1354, fd625, fd688;
sub.f64 fd697, fd1354, fd696;
mul.f64 fd1353, fd688, fd599;
mul.f64 fd698, fd625, fd689;
fma.rn.f64 fd699, fd626, fd688, fd698;
mul.f64 fd701, fd699, fd604;
mul.f64 fd702, fd697, fd604;
mul.f64 fd704, fd626, fd699;
mul.f64 fd1352, fd625, fd697;
sub.f64 fd705, fd1352, fd704;
mul.f64 fd1351, fd697, fd603;
mul.f64 fd706, fd625, fd699;
fma.rn.f64 fd707, fd626, fd697, fd706;
mul.f64 fd709, fd707, fd608;
mul.f64 fd710, fd705, fd608;
mul.f64 fd1349, fd625, fd705;
mul.f64 fd1350, fd626, fd707;
sub.f64 fd713, fd1349, fd1350;
mul.f64 fd1348, fd705, fd607;
mul.f64 fd714, fd625, fd707;
fma.rn.f64 fd715, fd626, fd705, fd714;
mul.f64 fd717, fd715, fd612;
mul.f64 fd718, fd713, fd612;
mul.f64 fd720, fd626, fd715;
mul.f64 fd1347, fd625, fd713;
sub.f64 fd721, fd1347, fd720;
mul.f64 fd1346, fd713, fd611;
mul.f64 fd722, fd625, fd715;
fma.rn.f64 fd723, fd626, fd713, fd722;
mul.f64 fd725, fd723, fd616;
mul.f64 fd726, fd721, fd616;
mul.f64 fd728, fd626, fd723;
mul.f64 fd1345, fd625, fd721;
sub.f64 fd729, fd1345, fd728;
mul.f64 fd1344, fd721, fd615;
mul.f64 fd730, fd625, fd723;
fma.rn.f64 fd731, fd626, fd721, fd730;
mul.f64 fd733, fd731, fd620;
mul.f64 fd734, fd729, fd620;
mul.f64 fd1342, fd625, fd729;
mul.f64 fd1343, fd626, fd731;
sub.f64 fd737, fd1342, fd1343;
mul.f64 fd1341, fd625, fd597;
mul.f64 fd738, fd625, fd731;
mul.f64 fd1340, fd729, fd619;
fma.rn.f64 fd739, fd626, fd729, fd738;
mul.f64 fd740, fd737, fd623;
mul.f64 fd741, fd739, fd624;
mul.f64 fd742, fd737, fd624;
mov.u32 r43, %tid.x;
shl.b32 r42, r43, 4;
and.b32 r15, r42, 240;
add.s32 r16, r9, r15;
barrier.sync 0;
and.b32 r17, r7, 126976;
add.s32 r18, r16, r17;
sub.f64 fd1503, fd1403, fd1390;
mul.f64 fd1502, fd684, fd1503;
add.f64 fd743, fd1403, fd1390;
sub.f64 fd1501, fd493, fd550;
add.f64 fd744, fd493, fd550;
st.shared.v2.f64 [r18], {fd744, fd743};
mov.u32 r38, %tid.x;
shl.b32 r37, r38, 4;
mov.u32 r49, %tid.x;
and.b32 r48, r49, 496;
mov.u32 r41, %tid.x;
shl.b32 r40, r41, 8;
mov.u32 r36, %tid.x;
fma.rn.f64 fd745, fd626, fd597, fd631;
sub.f64 fd746, fd1341, fd630;
st.shared.v2.f64 [r18+256], {fd746, fd745};
fma.rn.f64 fd747, fd636, fd601, fd639;
sub.f64 fd748, fd1370, fd638;
st.shared.v2.f64 [r18+512], {fd748, fd747};
fma.rn.f64 fd749, fd644, fd605, fd647;
sub.f64 fd750, fd1368, fd646;
st.shared.v2.f64 [r18+768], {fd750, fd749};
fma.rn.f64 fd751, fd652, fd609, fd655;
sub.f64 fd752, fd1365, fd654;
st.shared.v2.f64 [r18+1024], {fd752, fd751};
sub.f64 fd753, fd1362, fd662;
fma.rn.f64 fd754, fd660, fd613, fd663;
st.shared.v2.f64 [r18+1280], {fd753, fd754};
fma.rn.f64 fd755, fd668, fd617, fd671;
sub.f64 fd756, fd1360, fd670;
st.shared.v2.f64 [r18+1536], {fd756, fd755};
fma.rn.f64 fd757, fd676, fd621, fd679;
sub.f64 fd758, fd1357, fd678;
st.shared.v2.f64 [r18+1792], {fd758, fd757};
fma.rn.f64 fd759, fd684, fd1501, fd687;
sub.f64 fd760, fd685, fd1502;
st.shared.v2.f64 [r18+2048], {fd760, fd759};
fma.rn.f64 fd761, fd689, fd599, fd694;
sub.f64 fd762, fd1353, fd693;
st.shared.v2.f64 [r18+2304], {fd762, fd761};
fma.rn.f64 fd763, fd699, fd603, fd702;
sub.f64 fd764, fd1351, fd701;
st.shared.v2.f64 [r18+2560], {fd764, fd763};
fma.rn.f64 fd765, fd707, fd607, fd710;
sub.f64 fd766, fd1348, fd709;
st.shared.v2.f64 [r18+2816], {fd766, fd765};
fma.rn.f64 fd767, fd715, fd611, fd718;
sub.f64 fd768, fd1346, fd717;
st.shared.v2.f64 [r18+3072], {fd768, fd767};
sub.f64 fd769, fd1344, fd725;
fma.rn.f64 fd770, fd723, fd615, fd726;
st.shared.v2.f64 [r18+3328], {fd769, fd770};
fma.rn.f64 fd771, fd731, fd619, fd734;
sub.f64 fd772, fd1340, fd733;
st.shared.v2.f64 [r18+3584], {fd772, fd771};
fma.rn.f64 fd773, fd739, fd623, fd742;
sub.f64 fd774, fd740, fd741;
st.shared.v2.f64 [r18+3840], {fd774, fd773};
barrier.sync 0;
mad.lo.s32 r19, r48, -240, r18;
ld.shared.v2.f64 {fd775, fd776}, [r19];
ld.shared.v2.f64 {fd779, fd780}, [r19+8192];
ld.shared.v2.f64 {fd783, fd784}, [r19+16384];
ld.shared.v2.f64 {fd787, fd788}, [r19+24576];
ld.shared.v2.f64 {fd791, fd792}, [r19+32768];
ld.shared.v2.f64 {fd795, fd796}, [r19+40960];
ld.shared.v2.f64 {fd799, fd800}, [r19+49152];
ld.shared.v2.f64 {fd803, fd804}, [r19+57344];
ld.shared.v2.f64 {fd807, fd808}, [r19+65536];
ld.shared.v2.f64 {fd811, fd812}, [r19+73728];
ld.shared.v2.f64 {fd815, fd816}, [r19+81920];
ld.shared.v2.f64 {fd819, fd820}, [r19+90112];
ld.shared.v2.f64 {fd823, fd824}, [r19+98304];
ld.shared.v2.f64 {fd827, fd828}, [r19+106496];
ld.shared.v2.f64 {fd831, fd832}, [r19+114688];
ld.shared.v2.f64 {fd835, fd836}, [r19+122880];
add.f64 fd839, fd775, fd807;
sub.f64 fd841, fd775, fd807;
add.f64 fd1339, fd776, fd808;
sub.f64 fd842, fd776, fd808;
add.f64 fd843, fd791, fd823;
sub.f64 fd845, fd791, fd823;
add.f64 fd1338, fd792, fd824;
sub.f64 fd846, fd792, fd824;
add.f64 fd847, fd839, fd843;
sub.f64 fd849, fd839, fd843;
add.f64 fd1337, fd1339, fd1338;
sub.f64 fd850, fd1339, fd1338;
add.f64 fd851, fd841, fd846;
sub.f64 fd853, fd841, fd846;
sub.f64 fd1336, fd842, fd845;
add.f64 fd854, fd842, fd845;
add.f64 fd855, fd783, fd815;
sub.f64 fd857, fd783, fd815;
add.f64 fd1335, fd784, fd816;
sub.f64 fd858, fd784, fd816;
add.f64 fd859, fd799, fd831;
sub.f64 fd861, fd799, fd831;
add.f64 fd1334, fd800, fd832;
sub.f64 fd862, fd800, fd832;
add.f64 fd863, fd855, fd859;
sub.f64 fd865, fd855, fd859;
add.f64 fd1333, fd1335, fd1334;
sub.f64 fd866, fd1335, fd1334;
add.f64 fd867, fd857, fd862;
sub.f64 fd869, fd857, fd862;
sub.f64 fd1332, fd858, fd861;
add.f64 fd870, fd858, fd861;
mul.f64 fd872, fd1332, 0dBFE6A09E667F3BCD;
mul.f64 fd1331, fd867, 0d3FE6A09E667F3BCD;
sub.f64 fd873, fd1331, fd872;
mul.f64 fd874, fd1332, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd875, fd867, 0dBFE6A09E667F3BCD, fd874;
mul.f64 fd876, fd869, 0dBFE6A09E667F3BCD;
mul.f64 fd877, fd870, 0dBFE6A09E667F3BCD;
sub.f64 fd878, fd876, fd877;
add.f64 fd879, fd876, fd877;
add.f64 fd880, fd847, fd863;
sub.f64 fd882, fd847, fd863;
add.f64 fd1330, fd1337, fd1333;
sub.f64 fd883, fd1337, fd1333;
add.f64 fd884, fd851, fd873;
sub.f64 fd886, fd851, fd873;
add.f64 fd1329, fd1336, fd875;
sub.f64 fd887, fd1336, fd875;
add.f64 fd888, fd849, fd866;
sub.f64 fd890, fd849, fd866;
sub.f64 fd1328, fd850, fd865;
add.f64 fd891, fd850, fd865;
add.f64 fd892, fd853, fd878;
sub.f64 fd894, fd853, fd878;
add.f64 fd1327, fd854, fd879;
sub.f64 fd895, fd854, fd879;
add.f64 fd896, fd779, fd811;
sub.f64 fd898, fd779, fd811;
add.f64 fd1326, fd780, fd812;
sub.f64 fd899, fd780, fd812;
add.f64 fd900, fd795, fd827;
sub.f64 fd902, fd795, fd827;
add.f64 fd1325, fd796, fd828;
sub.f64 fd903, fd796, fd828;
add.f64 fd904, fd896, fd900;
sub.f64 fd906, fd896, fd900;
add.f64 fd1324, fd1326, fd1325;
sub.f64 fd907, fd1326, fd1325;
add.f64 fd908, fd898, fd903;
sub.f64 fd910, fd898, fd903;
sub.f64 fd1323, fd899, fd902;
add.f64 fd911, fd899, fd902;
add.f64 fd912, fd787, fd819;
sub.f64 fd914, fd787, fd819;
add.f64 fd1322, fd788, fd820;
sub.f64 fd915, fd788, fd820;
add.f64 fd916, fd803, fd835;
sub.f64 fd918, fd803, fd835;
add.f64 fd1321, fd804, fd836;
sub.f64 fd919, fd804, fd836;
add.f64 fd920, fd912, fd916;
sub.f64 fd922, fd912, fd916;
add.f64 fd1320, fd1322, fd1321;
sub.f64 fd923, fd1322, fd1321;
add.f64 fd924, fd914, fd919;
sub.f64 fd926, fd914, fd919;
sub.f64 fd1319, fd915, fd918;
add.f64 fd927, fd915, fd918;
mul.f64 fd929, fd1319, 0dBFE6A09E667F3BCD;
mul.f64 fd1318, fd924, 0d3FE6A09E667F3BCD;
sub.f64 fd930, fd1318, fd929;
mul.f64 fd931, fd1319, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd932, fd924, 0dBFE6A09E667F3BCD, fd931;
mul.f64 fd933, fd926, 0dBFE6A09E667F3BCD;
mul.f64 fd934, fd927, 0dBFE6A09E667F3BCD;
sub.f64 fd935, fd933, fd934;
add.f64 fd936, fd933, fd934;
add.f64 fd937, fd904, fd920;
sub.f64 fd939, fd904, fd920;
add.f64 fd1317, fd1324, fd1320;
sub.f64 fd940, fd1324, fd1320;
add.f64 fd941, fd908, fd930;
sub.f64 fd943, fd908, fd930;
add.f64 fd1316, fd1323, fd932;
sub.f64 fd944, fd1323, fd932;
add.f64 fd945, fd906, fd923;
sub.f64 fd947, fd906, fd923;
sub.f64 fd1315, fd907, fd922;
add.f64 fd948, fd907, fd922;
add.f64 fd949, fd910, fd935;
sub.f64 fd951, fd910, fd935;
add.f64 fd1314, fd911, fd936;
sub.f64 fd952, fd911, fd936;
mul.f64 fd954, fd1316, 0dBFD87DE2A6AEA963;
mul.f64 fd1313, fd941, 0d3FED906BCF328D46;
sub.f64 fd955, fd1313, fd954;
mul.f64 fd956, fd1316, 0d3FED906BCF328D46;
fma.rn.f64 fd957, fd941, 0dBFD87DE2A6AEA963, fd956;
mul.f64 fd959, fd1315, 0dBFE6A09E667F3BCD;
mul.f64 fd1312, fd945, 0d3FE6A09E667F3BCD;
sub.f64 fd960, fd1312, fd959;
mul.f64 fd961, fd1315, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd962, fd945, 0dBFE6A09E667F3BCD, fd961;
mul.f64 fd964, fd1314, 0dBFED906BCF328D46;
mul.f64 fd1311, fd949, 0d3FD87DE2A6AEA963;
sub.f64 fd965, fd1311, fd964;
mul.f64 fd966, fd1314, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd967, fd949, 0dBFED906BCF328D46, fd966;
mul.f64 fd969, fd944, 0dBFED906BCF328D46;
mul.f64 fd1310, fd943, 0dBFD87DE2A6AEA963;
sub.f64 fd970, fd1310, fd969;
mul.f64 fd971, fd944, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd972, fd943, 0dBFED906BCF328D46, fd971;
mul.f64 fd973, fd947, 0dBFE6A09E667F3BCD;
mul.f64 fd974, fd948, 0dBFE6A09E667F3BCD;
sub.f64 fd975, fd973, fd974;
add.f64 fd976, fd973, fd974;
mul.f64 fd978, fd952, 0dBFD87DE2A6AEA963;
mul.f64 fd1309, fd951, 0dBFED906BCF328D46;
sub.f64 fd979, fd1309, fd978;
mul.f64 fd980, fd952, 0dBFED906BCF328D46;
fma.rn.f64 fd981, fd951, 0dBFD87DE2A6AEA963, fd980;
add.f64 fd984, fd884, fd955;
sub.f64 fd986, fd884, fd955;
add.f64 fd1308, fd1329, fd957;
sub.f64 fd987, fd1329, fd957;
add.f64 fd988, fd888, fd960;
sub.f64 fd990, fd888, fd960;
add.f64 fd1307, fd1328, fd962;
sub.f64 fd991, fd1328, fd962;
add.f64 fd992, fd892, fd965;
sub.f64 fd994, fd892, fd965;
add.f64 fd1306, fd1327, fd967;
sub.f64 fd995, fd1327, fd967;
add.f64 fd996, fd882, fd940;
sub.f64 fd998, fd882, fd940;
sub.f64 fd1305, fd883, fd939;
add.f64 fd999, fd883, fd939;
add.f64 fd1000, fd886, fd970;
sub.f64 fd1002, fd886, fd970;
add.f64 fd1304, fd887, fd972;
sub.f64 fd1003, fd887, fd972;
add.f64 fd1004, fd890, fd975;
sub.f64 fd1006, fd890, fd975;
add.f64 fd1303, fd891, fd976;
sub.f64 fd1007, fd891, fd976;
add.f64 fd1008, fd894, fd979;
sub.f64 fd1010, fd894, fd979;
add.f64 fd1302, fd895, fd981;
sub.f64 fd1011, fd895, fd981;
and.b32 r20, r36, 256;
bfe.u32 r21, r36, 8, 1;
mul.wide.u32 rd9, r21, 16;
mov.u64 rd10, %35;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd1012, fd1013}, [rd11];
mul.f64 fd1017, fd1013, fd1308;
mul.f64 fd1018, fd1012, fd1308;
mul.f64 fd1300, fd1012, fd1012;
mul.f64 fd1301, fd1013, fd1013;
sub.f64 fd1021, fd1300, fd1301;
mul.f64 fd1022, fd1013, fd1012;
fma.rn.f64 fd1023, fd1013, fd1012, fd1022;
mul.f64 fd1025, fd1023, fd1307;
mul.f64 fd1026, fd1021, fd1307;
mul.f64 fd1028, fd1013, fd1023;
mul.f64 fd1299, fd1012, fd1021;
sub.f64 fd1029, fd1299, fd1028;
mul.f64 fd1298, fd1021, fd988;
mul.f64 fd1030, fd1012, fd1023;
fma.rn.f64 fd1031, fd1013, fd1021, fd1030;
mul.f64 fd1033, fd1031, fd1306;
mul.f64 fd1034, fd1029, fd1306;
mul.f64 fd1296, fd1012, fd1029;
mul.f64 fd1297, fd1013, fd1031;
sub.f64 fd1037, fd1296, fd1297;
mul.f64 fd1295, fd1029, fd992;
mul.f64 fd1038, fd1012, fd1031;
fma.rn.f64 fd1039, fd1013, fd1029, fd1038;
mul.f64 fd1041, fd1039, fd1305;
mul.f64 fd1042, fd1037, fd1305;
mul.f64 fd1044, fd1013, fd1039;
mul.f64 fd1294, fd1012, fd1037;
sub.f64 fd1045, fd1294, fd1044;
mul.f64 fd1293, fd1037, fd996;
mul.f64 fd1046, fd1012, fd1039;
fma.rn.f64 fd1047, fd1013, fd1037, fd1046;
mul.f64 fd1049, fd1047, fd1304;
mul.f64 fd1050, fd1045, fd1304;
mul.f64 fd1052, fd1013, fd1047;
mul.f64 fd1292, fd1012, fd1045;
sub.f64 fd1053, fd1292, fd1052;
mul.f64 fd1291, fd1045, fd1000;
mul.f64 fd1054, fd1012, fd1047;
fma.rn.f64 fd1055, fd1013, fd1045, fd1054;
mul.f64 fd1057, fd1055, fd1303;
mul.f64 fd1058, fd1053, fd1303;
mul.f64 fd1289, fd1012, fd1053;
mul.f64 fd1290, fd1013, fd1055;
sub.f64 fd1061, fd1289, fd1290;
mul.f64 fd1288, fd1053, fd1004;
mul.f64 fd1062, fd1012, fd1055;
fma.rn.f64 fd1063, fd1013, fd1053, fd1062;
mul.f64 fd1065, fd1063, fd1302;
mul.f64 fd1066, fd1061, fd1302;
mul.f64 fd1068, fd1013, fd1063;
mul.f64 fd1287, fd1012, fd1061;
sub.f64 fd1069, fd1287, fd1068;
mul.f64 fd1286, fd1061, fd1008;
mul.f64 fd1070, fd1012, fd1063;
fma.rn.f64 fd1071, fd1013, fd1061, fd1070;
sub.f64 fd1285, fd1330, fd1317;
sub.f64 fd1284, fd880, fd937;
mul.f64 fd1072, fd1069, fd1284;
mul.f64 fd1073, fd1071, fd1285;
mul.f64 fd1074, fd1069, fd1285;
ld.global.v2.f64 {fd1075, fd1076}, [rd11+32];
mul.f64 fd1080, fd1076, fd987;
mul.f64 fd1081, fd1075, fd987;
mul.f64 fd1083, fd1013, fd1076;
mul.f64 fd1283, fd1012, fd1075;
sub.f64 fd1084, fd1283, fd1083;
mul.f64 fd1282, fd1075, fd986;
mul.f64 fd1085, fd1012, fd1076;
fma.rn.f64 fd1086, fd1013, fd1075, fd1085;
mul.f64 fd1088, fd1086, fd991;
mul.f64 fd1089, fd1084, fd991;
mul.f64 fd1280, fd1012, fd1084;
mul.f64 fd1281, fd1013, fd1086;
sub.f64 fd1092, fd1280, fd1281;
mul.f64 fd1279, fd1084, fd990;
mul.f64 fd1093, fd1012, fd1086;
fma.rn.f64 fd1094, fd1013, fd1084, fd1093;
mul.f64 fd1096, fd1094, fd995;
mul.f64 fd1097, fd1092, fd995;
mul.f64 fd1099, fd1013, fd1094;
mul.f64 fd1278, fd1012, fd1092;
sub.f64 fd1100, fd1278, fd1099;
mul.f64 fd1277, fd1092, fd994;
mul.f64 fd1101, fd1012, fd1094;
fma.rn.f64 fd1102, fd1013, fd1092, fd1101;
mul.f64 fd1104, fd1102, fd999;
mul.f64 fd1105, fd1100, fd999;
mul.f64 fd1275, fd1012, fd1100;
mul.f64 fd1276, fd1013, fd1102;
sub.f64 fd1108, fd1275, fd1276;
mul.f64 fd1274, fd1100, fd998;
mul.f64 fd1109, fd1012, fd1102;
fma.rn.f64 fd1110, fd1013, fd1100, fd1109;
mul.f64 fd1112, fd1110, fd1003;
mul.f64 fd1113, fd1108, fd1003;
mul.f64 fd1115, fd1013, fd1110;
mul.f64 fd1273, fd1012, fd1108;
sub.f64 fd1116, fd1273, fd1115;
mul.f64 fd1272, fd1108, fd1002;
mul.f64 fd1117, fd1012, fd1110;
fma.rn.f64 fd1118, fd1013, fd1108, fd1117;
mul.f64 fd1120, fd1118, fd1007;
mul.f64 fd1121, fd1116, fd1007;
mul.f64 fd1123, fd1013, fd1118;
mul.f64 fd1271, fd1012, fd1116;
sub.f64 fd1124, fd1271, fd1123;
mul.f64 fd1270, fd1012, fd984;
mul.f64 fd1125, fd1012, fd1118;
mul.f64 fd1269, fd1116, fd1006;
fma.rn.f64 fd1126, fd1013, fd1116, fd1125;
mul.f64 fd1127, fd1124, fd1010;
mul.f64 fd1128, fd1126, fd1011;
mul.f64 fd1129, fd1124, fd1011;
mov.u32 r31, %tid.x;
and.b32 r30, r31, 256;
mov.u32 r47, %tid.x;
shl.b32 r46, r47, 8;
and.b32 r22, r37, 4080;
add.s32 r23, r9, r22;
sub.f64 fd1505, fd1330, fd1317;
mul.f64 fd1504, fd1071, fd1505;
barrier.sync 0;
and.b32 r24, r46, 65536;
add.s32 r25, r23, r24;
sub.f64 fd1508, fd1330, fd1317;
mul.f64 fd1507, fd1071, fd1508;
add.f64 fd1130, fd1330, fd1317;
sub.f64 fd1509, fd880, fd937;
add.f64 fd1131, fd880, fd937;
st.shared.v2.f64 [r25], {fd1131, fd1130};
mov.u32 r45, %tid.x;
and.b32 r44, r45, 256;
fma.rn.f64 fd1132, fd1013, fd984, fd1018;
sub.f64 fd1133, fd1270, fd1017;
st.shared.v2.f64 [r25+4096], {fd1133, fd1132};
fma.rn.f64 fd1134, fd1023, fd988, fd1026;
sub.f64 fd1135, fd1298, fd1025;
st.shared.v2.f64 [r25+8192], {fd1135, fd1134};
fma.rn.f64 fd1136, fd1031, fd992, fd1034;
sub.f64 fd1137, fd1295, fd1033;
st.shared.v2.f64 [r25+12288], {fd1137, fd1136};
fma.rn.f64 fd1138, fd1039, fd996, fd1042;
sub.f64 fd1139, fd1293, fd1041;
st.shared.v2.f64 [r25+16384], {fd1139, fd1138};
sub.f64 fd1140, fd1291, fd1049;
fma.rn.f64 fd1141, fd1047, fd1000, fd1050;
st.shared.v2.f64 [r25+20480], {fd1140, fd1141};
fma.rn.f64 fd1142, fd1055, fd1004, fd1058;
sub.f64 fd1143, fd1288, fd1057;
st.shared.v2.f64 [r25+24576], {fd1143, fd1142};
fma.rn.f64 fd1144, fd1063, fd1008, fd1066;
sub.f64 fd1145, fd1286, fd1065;
st.shared.v2.f64 [r25+28672], {fd1145, fd1144};
fma.rn.f64 fd1146, fd1071, fd1509, fd1074;
sub.f64 fd1147, fd1072, fd1507;
st.shared.v2.f64 [r25+32768], {fd1147, fd1146};
fma.rn.f64 fd1148, fd1076, fd986, fd1081;
sub.f64 fd1149, fd1282, fd1080;
st.shared.v2.f64 [r25+36864], {fd1149, fd1148};
fma.rn.f64 fd1150, fd1086, fd990, fd1089;
sub.f64 fd1151, fd1279, fd1088;
st.shared.v2.f64 [r25+40960], {fd1151, fd1150};
fma.rn.f64 fd1152, fd1094, fd994, fd1097;
sub.f64 fd1153, fd1277, fd1096;
st.shared.v2.f64 [r25+45056], {fd1153, fd1152};
fma.rn.f64 fd1154, fd1102, fd998, fd1105;
sub.f64 fd1155, fd1274, fd1104;
st.shared.v2.f64 [r25+49152], {fd1155, fd1154};
sub.f64 fd1156, fd1272, fd1112;
fma.rn.f64 fd1157, fd1110, fd1002, fd1113;
st.shared.v2.f64 [r25+53248], {fd1156, fd1157};
fma.rn.f64 fd1158, fd1118, fd1006, fd1121;
sub.f64 fd1159, fd1269, fd1120;
st.shared.v2.f64 [r25+57344], {fd1159, fd1158};
fma.rn.f64 fd1160, fd1126, fd1010, fd1129;
sub.f64 fd1161, fd1127, fd1128;
st.shared.v2.f64 [r25+61440], {fd1161, fd1160};
barrier.sync 0;
mad.lo.s32 r26, r44, -240, r25;
ld.shared.v2.f64 {fd1162, fd1163}, [r26];
ld.shared.v2.f64 {fd1166, fd1167}, [r26+8192];
ld.shared.v2.f64 {fd1170, fd1171}, [r26+16384];
ld.shared.v2.f64 {fd1174, fd1175}, [r26+24576];
ld.shared.v2.f64 {fd1178, fd1179}, [r26+32768];
ld.shared.v2.f64 {fd1182, fd1183}, [r26+40960];
ld.shared.v2.f64 {fd1186, fd1187}, [r26+49152];
ld.shared.v2.f64 {fd1190, fd1191}, [r26+57344];
ld.shared.v2.f64 {fd1194, fd1195}, [r26+65536];
ld.shared.v2.f64 {fd1198, fd1199}, [r26+73728];
ld.shared.v2.f64 {fd1202, fd1203}, [r26+81920];
ld.shared.v2.f64 {fd1206, fd1207}, [r26+90112];
ld.shared.v2.f64 {fd1210, fd1211}, [r26+98304];
ld.shared.v2.f64 {fd1214, fd1215}, [r26+106496];
ld.shared.v2.f64 {fd1218, fd1219}, [r26+114688];
ld.shared.v2.f64 {fd1222, fd1223}, [r26+122880];
add.f64 %0, fd1162, fd1194;
add.f64 %1, fd1163, fd1195;
add.f64 %2, fd1166, fd1198;
add.f64 %3, fd1167, fd1199;
add.f64 %4, fd1170, fd1202;
add.f64 %5, fd1171, fd1203;
add.f64 %7, fd1175, fd1207;
add.f64 %6, fd1174, fd1206;
add.f64 %9, fd1179, fd1211;
add.f64 %8, fd1178, fd1210;
add.f64 %11, fd1183, fd1215;
add.f64 %10, fd1182, fd1214;
add.f64 %12, fd1186, fd1218;
add.f64 %13, fd1187, fd1219;
add.f64 %14, fd1190, fd1222;
add.f64 %15, fd1191, fd1223;
sub.f64 %17, fd1163, fd1195;
sub.f64 %16, fd1162, fd1194;
sub.f64 %19, fd1167, fd1199;
sub.f64 %18, fd1166, fd1198;
sub.f64 %21, fd1171, fd1203;
sub.f64 %20, fd1170, fd1202;
sub.f64 %23, fd1175, fd1207;
sub.f64 %22, fd1174, fd1206;
sub.f64 %25, fd1179, fd1211;
sub.f64 %24, fd1178, fd1210;
sub.f64 %27, fd1183, fd1215;
sub.f64 %26, fd1182, fd1214;
sub.f64 %29, fd1187, fd1219;
sub.f64 %28, fd1186, fd1218;
sub.f64 %31, fd1191, fd1223;
sub.f64 %30, fd1190, fd1222;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_8192), "l"(lut_dp_16_512), "l"(lut_dp_16_32), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[8].y), "d"(rmem[4].y), "d"(rmem[10].y), "d"(rmem[2].y), "d"(rmem[14].y), "d"(rmem[1].y), "d"(rmem[5].y), "d"(rmem[13].y), "d"(rmem[11].y), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<499, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<36>;
.reg .f64 fd<613>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 16;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %21, %31;
add.f64 fd34, %22, %33;
sub.f64 fd35, %21, %31;
sub.f64 fd36, %22, %33;
add.f64 fd37, %26, %37;
add.f64 fd38, %28, %38;
sub.f64 fd39, %26, %37;
sub.f64 fd40, %28, %38;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
add.f64 fd45, fd35, fd40;
sub.f64 fd46, fd36, fd39;
sub.f64 fd47, fd35, fd40;
add.f64 fd48, fd36, fd39;
add.f64 fd49, %23, %34;
add.f64 fd50, %25, %36;
sub.f64 fd51, %23, %34;
sub.f64 fd52, %25, %36;
add.f64 fd53, %29, %39;
add.f64 fd54, %30, %40;
sub.f64 fd55, %29, %39;
sub.f64 fd56, %30, %40;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
add.f64 fd61, fd51, fd56;
sub.f64 fd62, fd52, fd55;
sub.f64 fd63, fd51, fd56;
add.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0dBFE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
mul.f64 fd68, fd62, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd69, fd61, 0dBFE6A09E667F3BCD, fd68;
mul.f64 fd70, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd71, fd64, 0dBFE6A09E667F3BCD;
sub.f64 fd72, fd70, fd71;
add.f64 fd73, fd70, fd71;
add.f64 fd74, fd41, fd57;
add.f64 fd75, fd42, fd58;
sub.f64 fd76, fd41, fd57;
sub.f64 fd77, fd42, fd58;
add.f64 fd78, fd45, fd67;
add.f64 fd79, fd46, fd69;
sub.f64 fd80, fd45, fd67;
sub.f64 fd81, fd46, fd69;
add.f64 fd82, fd43, fd60;
sub.f64 fd83, fd44, fd59;
sub.f64 fd84, fd43, fd60;
add.f64 fd85, fd44, fd59;
add.f64 fd86, fd47, fd72;
add.f64 fd87, fd48, fd73;
sub.f64 fd88, fd47, fd72;
sub.f64 fd89, fd48, fd73;
and.b32 r6, r5, 1023;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 16368;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd90, fd91}, [rd5];
mul.f64 fd94, fd90, fd78;
mul.f64 fd95, fd91, fd79;
sub.f64 fd96, fd94, fd95;
mul.f64 fd97, fd90, fd79;
fma.rn.f64 fd98, fd91, fd78, fd97;
mul.f64 fd99, fd90, fd90;
mul.f64 fd100, fd91, fd91;
sub.f64 fd101, fd99, fd100;
mul.f64 fd102, fd91, fd90;
fma.rn.f64 fd103, fd91, fd90, fd102;
mul.f64 fd104, fd101, fd82;
mul.f64 fd105, fd103, fd83;
sub.f64 fd106, fd104, fd105;
mul.f64 fd107, fd101, fd83;
fma.rn.f64 fd108, fd103, fd82, fd107;
mul.f64 fd109, fd90, fd101;
mul.f64 fd110, fd91, fd103;
sub.f64 fd111, fd109, fd110;
mul.f64 fd112, fd90, fd103;
fma.rn.f64 fd113, fd91, fd101, fd112;
mul.f64 fd114, fd111, fd86;
mul.f64 fd115, fd113, fd87;
sub.f64 fd116, fd114, fd115;
mul.f64 fd117, fd111, fd87;
fma.rn.f64 fd118, fd113, fd86, fd117;
mul.f64 fd119, fd90, fd111;
mul.f64 fd120, fd91, fd113;
sub.f64 fd121, fd119, fd120;
mul.f64 fd122, fd90, fd113;
fma.rn.f64 fd123, fd91, fd111, fd122;
mul.f64 fd124, fd121, fd76;
mul.f64 fd125, fd123, fd77;
sub.f64 fd126, fd124, fd125;
mul.f64 fd127, fd121, fd77;
fma.rn.f64 fd128, fd123, fd76, fd127;
ld.global.v2.f64 {fd129, fd130}, [rd5+16384];
mul.f64 fd133, fd129, fd80;
mul.f64 fd134, fd130, fd81;
sub.f64 fd135, fd133, fd134;
mul.f64 fd136, fd129, fd81;
fma.rn.f64 fd137, fd130, fd80, fd136;
mul.f64 fd138, fd90, fd129;
mul.f64 fd139, fd91, fd130;
sub.f64 fd140, fd138, fd139;
mul.f64 fd141, fd90, fd130;
fma.rn.f64 fd142, fd91, fd129, fd141;
mul.f64 fd143, fd140, fd84;
mul.f64 fd144, fd142, fd85;
sub.f64 fd145, fd143, fd144;
mul.f64 fd146, fd140, fd85;
fma.rn.f64 fd147, fd142, fd84, fd146;
mul.f64 fd148, fd90, fd140;
mul.f64 fd149, fd91, fd142;
sub.f64 fd150, fd148, fd149;
mul.f64 fd151, fd90, fd142;
fma.rn.f64 fd152, fd91, fd140, fd151;
mul.f64 fd153, fd150, fd88;
mul.f64 fd154, fd152, fd89;
sub.f64 fd155, fd153, fd154;
mul.f64 fd156, fd150, fd89;
fma.rn.f64 fd157, fd152, fd88, fd156;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -65536;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 65472;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd74, fd96};
st.shared.v2.f64 [r12+16], {fd106, fd116};
st.shared.v2.f64 [r12+32], {fd126, fd135};
st.shared.v2.f64 [r12+48], {fd145, fd155};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.f64 fd158, [r13];
ld.shared.f64 fd159, [r13+8192];
ld.shared.f64 fd160, [r13+16384];
ld.shared.f64 fd161, [r13+24576];
ld.shared.f64 fd162, [r13+32768];
ld.shared.f64 fd163, [r13+40960];
ld.shared.f64 fd164, [r13+49152];
ld.shared.f64 fd165, [r13+57344];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd75, fd98};
st.shared.v2.f64 [r12+16], {fd108, fd118};
st.shared.v2.f64 [r12+32], {fd128, fd137};
st.shared.v2.f64 [r12+48], {fd147, fd157};
barrier.sync 0;
ld.shared.f64 fd166, [r13];
ld.shared.f64 fd167, [r13+8192];
ld.shared.f64 fd168, [r13+16384];
ld.shared.f64 fd169, [r13+24576];
ld.shared.f64 fd170, [r13+32768];
ld.shared.f64 fd171, [r13+40960];
ld.shared.f64 fd172, [r13+49152];
ld.shared.f64 fd173, [r13+57344];
add.f64 fd174, fd158, fd162;
add.f64 fd175, fd166, fd170;
sub.f64 fd176, fd158, fd162;
sub.f64 fd177, fd166, fd170;
add.f64 fd178, fd160, fd164;
add.f64 fd179, fd168, fd172;
sub.f64 fd180, fd160, fd164;
sub.f64 fd181, fd168, fd172;
add.f64 fd182, fd174, fd178;
add.f64 fd183, fd175, fd179;
sub.f64 fd184, fd174, fd178;
sub.f64 fd185, fd175, fd179;
add.f64 fd186, fd176, fd181;
sub.f64 fd187, fd177, fd180;
sub.f64 fd188, fd176, fd181;
add.f64 fd189, fd177, fd180;
add.f64 fd190, fd159, fd163;
add.f64 fd191, fd167, fd171;
sub.f64 fd192, fd159, fd163;
sub.f64 fd193, fd167, fd171;
add.f64 fd194, fd161, fd165;
add.f64 fd195, fd169, fd173;
sub.f64 fd196, fd161, fd165;
sub.f64 fd197, fd169, fd173;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
add.f64 fd202, fd192, fd197;
sub.f64 fd203, fd193, fd196;
sub.f64 fd204, fd192, fd197;
add.f64 fd205, fd193, fd196;
mul.f64 fd206, fd202, 0d3FE6A09E667F3BCD;
mul.f64 fd207, fd203, 0dBFE6A09E667F3BCD;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd203, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd210, fd202, 0dBFE6A09E667F3BCD, fd209;
mul.f64 fd211, fd204, 0dBFE6A09E667F3BCD;
mul.f64 fd212, fd205, 0dBFE6A09E667F3BCD;
sub.f64 fd213, fd211, fd212;
add.f64 fd214, fd211, fd212;
add.f64 fd215, fd182, fd198;
add.f64 fd216, fd183, fd199;
sub.f64 fd217, fd182, fd198;
sub.f64 fd218, fd183, fd199;
add.f64 fd219, fd186, fd208;
add.f64 fd220, fd187, fd210;
sub.f64 fd221, fd186, fd208;
sub.f64 fd222, fd187, fd210;
add.f64 fd223, fd184, fd201;
sub.f64 fd224, fd185, fd200;
sub.f64 fd225, fd184, fd201;
add.f64 fd226, fd185, fd200;
add.f64 fd227, fd188, fd213;
add.f64 fd228, fd189, fd214;
sub.f64 fd229, fd188, fd213;
sub.f64 fd230, fd189, fd214;
and.b32 r14, r5, 1016;
bfe.u32 r15, r5, 3, 7;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd231, fd232}, [rd8];
mul.f64 fd235, fd231, fd219;
mul.f64 fd236, fd232, fd220;
sub.f64 fd237, fd235, fd236;
mul.f64 fd238, fd231, fd220;
fma.rn.f64 fd239, fd232, fd219, fd238;
mul.f64 fd240, fd231, fd231;
mul.f64 fd241, fd232, fd232;
sub.f64 fd242, fd240, fd241;
mul.f64 fd243, fd232, fd231;
fma.rn.f64 fd244, fd232, fd231, fd243;
mul.f64 fd245, fd242, fd223;
mul.f64 fd246, fd244, fd224;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd242, fd224;
fma.rn.f64 fd249, fd244, fd223, fd248;
mul.f64 fd250, fd231, fd242;
mul.f64 fd251, fd232, fd244;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd231, fd244;
fma.rn.f64 fd254, fd232, fd242, fd253;
mul.f64 fd255, fd252, fd227;
mul.f64 fd256, fd254, fd228;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd252, fd228;
fma.rn.f64 fd259, fd254, fd227, fd258;
mul.f64 fd260, fd231, fd252;
mul.f64 fd261, fd232, fd254;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd231, fd254;
fma.rn.f64 fd264, fd232, fd252, fd263;
mul.f64 fd265, fd262, fd217;
mul.f64 fd266, fd264, fd218;
sub.f64 fd267, fd265, fd266;
mul.f64 fd268, fd262, fd218;
fma.rn.f64 fd269, fd264, fd217, fd268;
ld.global.v2.f64 {fd270, fd271}, [rd8+2048];
mul.f64 fd274, fd270, fd221;
mul.f64 fd275, fd271, fd222;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd270, fd222;
fma.rn.f64 fd278, fd271, fd221, fd277;
mul.f64 fd279, fd231, fd270;
mul.f64 fd280, fd232, fd271;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd231, fd271;
fma.rn.f64 fd283, fd232, fd270, fd282;
mul.f64 fd284, fd281, fd225;
mul.f64 fd285, fd283, fd226;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd226;
fma.rn.f64 fd288, fd283, fd225, fd287;
mul.f64 fd289, fd231, fd281;
mul.f64 fd290, fd232, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd231, fd283;
fma.rn.f64 fd293, fd232, fd281, fd292;
mul.f64 fd294, fd291, fd229;
mul.f64 fd295, fd293, fd230;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd230;
fma.rn.f64 fd298, fd293, fd229, fd297;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 56;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 65024;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd215;
st.shared.f64 [r20+64], fd237;
st.shared.f64 [r20+128], fd247;
st.shared.f64 [r20+192], fd257;
st.shared.f64 [r20+256], fd267;
st.shared.f64 [r20+320], fd276;
st.shared.f64 [r20+384], fd286;
st.shared.f64 [r20+448], fd296;
barrier.sync 0;
mad.lo.s32 r21, r14, -56, r20;
ld.shared.f64 fd299, [r21];
ld.shared.f64 fd300, [r21+8192];
ld.shared.f64 fd301, [r21+16384];
ld.shared.f64 fd302, [r21+24576];
ld.shared.f64 fd303, [r21+32768];
ld.shared.f64 fd304, [r21+40960];
ld.shared.f64 fd305, [r21+49152];
ld.shared.f64 fd306, [r21+57344];
barrier.sync 0;
st.shared.f64 [r20], fd216;
st.shared.f64 [r20+64], fd239;
st.shared.f64 [r20+128], fd249;
st.shared.f64 [r20+192], fd259;
st.shared.f64 [r20+256], fd269;
st.shared.f64 [r20+320], fd278;
st.shared.f64 [r20+384], fd288;
st.shared.f64 [r20+448], fd298;
barrier.sync 0;
ld.shared.f64 fd307, [r21];
ld.shared.f64 fd308, [r21+8192];
ld.shared.f64 fd309, [r21+16384];
ld.shared.f64 fd310, [r21+24576];
ld.shared.f64 fd311, [r21+32768];
ld.shared.f64 fd312, [r21+40960];
ld.shared.f64 fd313, [r21+49152];
ld.shared.f64 fd314, [r21+57344];
add.f64 fd315, fd299, fd303;
add.f64 fd316, fd307, fd311;
sub.f64 fd317, fd299, fd303;
sub.f64 fd318, fd307, fd311;
add.f64 fd319, fd301, fd305;
add.f64 fd320, fd309, fd313;
sub.f64 fd321, fd301, fd305;
sub.f64 fd322, fd309, fd313;
add.f64 fd323, fd315, fd319;
add.f64 fd324, fd316, fd320;
sub.f64 fd325, fd315, fd319;
sub.f64 fd326, fd316, fd320;
add.f64 fd327, fd317, fd322;
sub.f64 fd328, fd318, fd321;
sub.f64 fd329, fd317, fd322;
add.f64 fd330, fd318, fd321;
add.f64 fd331, fd300, fd304;
add.f64 fd332, fd308, fd312;
sub.f64 fd333, fd300, fd304;
sub.f64 fd334, fd308, fd312;
add.f64 fd335, fd302, fd306;
add.f64 fd336, fd310, fd314;
sub.f64 fd337, fd302, fd306;
sub.f64 fd338, fd310, fd314;
add.f64 fd339, fd331, fd335;
add.f64 fd340, fd332, fd336;
sub.f64 fd341, fd331, fd335;
sub.f64 fd342, fd332, fd336;
add.f64 fd343, fd333, fd338;
sub.f64 fd344, fd334, fd337;
sub.f64 fd345, fd333, fd338;
add.f64 fd346, fd334, fd337;
mul.f64 fd347, fd343, 0d3FE6A09E667F3BCD;
mul.f64 fd348, fd344, 0dBFE6A09E667F3BCD;
sub.f64 fd349, fd347, fd348;
mul.f64 fd350, fd344, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd351, fd343, 0dBFE6A09E667F3BCD, fd350;
mul.f64 fd352, fd345, 0dBFE6A09E667F3BCD;
mul.f64 fd353, fd346, 0dBFE6A09E667F3BCD;
sub.f64 fd354, fd352, fd353;
add.f64 fd355, fd352, fd353;
add.f64 fd356, fd323, fd339;
add.f64 fd357, fd324, fd340;
sub.f64 fd358, fd323, fd339;
sub.f64 fd359, fd324, fd340;
add.f64 fd360, fd327, fd349;
add.f64 fd361, fd328, fd351;
sub.f64 fd362, fd327, fd349;
sub.f64 fd363, fd328, fd351;
add.f64 fd364, fd325, fd342;
sub.f64 fd365, fd326, fd341;
sub.f64 fd366, fd325, fd342;
add.f64 fd367, fd326, fd341;
add.f64 fd368, fd329, fd354;
add.f64 fd369, fd330, fd355;
sub.f64 fd370, fd329, fd354;
sub.f64 fd371, fd330, fd355;
and.b32 r22, r5, 960;
bfe.u32 r23, r5, 6, 4;
mul.wide.u32 rd9, r23, 16;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd372, fd373}, [rd11];
mul.f64 fd376, fd372, fd360;
mul.f64 fd377, fd373, fd361;
sub.f64 fd378, fd376, fd377;
mul.f64 fd379, fd372, fd361;
fma.rn.f64 fd380, fd373, fd360, fd379;
mul.f64 fd381, fd372, fd372;
mul.f64 fd382, fd373, fd373;
sub.f64 fd383, fd381, fd382;
mul.f64 fd384, fd373, fd372;
fma.rn.f64 fd385, fd373, fd372, fd384;
mul.f64 fd386, fd383, fd364;
mul.f64 fd387, fd385, fd365;
sub.f64 fd388, fd386, fd387;
mul.f64 fd389, fd383, fd365;
fma.rn.f64 fd390, fd385, fd364, fd389;
mul.f64 fd391, fd372, fd383;
mul.f64 fd392, fd373, fd385;
sub.f64 fd393, fd391, fd392;
mul.f64 fd394, fd372, fd385;
fma.rn.f64 fd395, fd373, fd383, fd394;
mul.f64 fd396, fd393, fd368;
mul.f64 fd397, fd395, fd369;
sub.f64 fd398, fd396, fd397;
mul.f64 fd399, fd393, fd369;
fma.rn.f64 fd400, fd395, fd368, fd399;
mul.f64 fd401, fd372, fd393;
mul.f64 fd402, fd373, fd395;
sub.f64 fd403, fd401, fd402;
mul.f64 fd404, fd372, fd395;
fma.rn.f64 fd405, fd373, fd393, fd404;
mul.f64 fd406, fd403, fd358;
mul.f64 fd407, fd405, fd359;
sub.f64 fd408, fd406, fd407;
mul.f64 fd409, fd403, fd359;
fma.rn.f64 fd410, fd405, fd358, fd409;
ld.global.v2.f64 {fd411, fd412}, [rd11+256];
mul.f64 fd415, fd411, fd362;
mul.f64 fd416, fd412, fd363;
sub.f64 fd417, fd415, fd416;
mul.f64 fd418, fd411, fd363;
fma.rn.f64 fd419, fd412, fd362, fd418;
mul.f64 fd420, fd372, fd411;
mul.f64 fd421, fd373, fd412;
sub.f64 fd422, fd420, fd421;
mul.f64 fd423, fd372, fd412;
fma.rn.f64 fd424, fd373, fd411, fd423;
mul.f64 fd425, fd422, fd366;
mul.f64 fd426, fd424, fd367;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd422, fd367;
fma.rn.f64 fd429, fd424, fd366, fd428;
mul.f64 fd430, fd372, fd422;
mul.f64 fd431, fd373, fd424;
sub.f64 fd432, fd430, fd431;
mul.f64 fd433, fd372, fd424;
fma.rn.f64 fd434, fd373, fd422, fd433;
mul.f64 fd435, fd432, fd370;
mul.f64 fd436, fd434, fd371;
sub.f64 fd437, fd435, fd436;
mul.f64 fd438, fd432, fd371;
fma.rn.f64 fd439, fd434, fd370, fd438;
and.b32 r24, r16, 504;
add.s32 r25, r10, r24;
barrier.sync 0;
and.b32 r26, r8, 61440;
add.s32 r27, r25, r26;
st.shared.f64 [r27], fd356;
st.shared.f64 [r27+512], fd378;
st.shared.f64 [r27+1024], fd388;
st.shared.f64 [r27+1536], fd398;
st.shared.f64 [r27+2048], fd408;
st.shared.f64 [r27+2560], fd417;
st.shared.f64 [r27+3072], fd427;
st.shared.f64 [r27+3584], fd437;
barrier.sync 0;
mad.lo.s32 r28, r22, -56, r27;
ld.shared.f64 fd440, [r28];
ld.shared.f64 fd441, [r28+8192];
ld.shared.f64 fd442, [r28+16384];
ld.shared.f64 fd443, [r28+24576];
ld.shared.f64 fd444, [r28+32768];
ld.shared.f64 fd445, [r28+40960];
ld.shared.f64 fd446, [r28+49152];
ld.shared.f64 fd447, [r28+57344];
barrier.sync 0;
st.shared.f64 [r27], fd357;
st.shared.f64 [r27+512], fd380;
st.shared.f64 [r27+1024], fd390;
st.shared.f64 [r27+1536], fd400;
st.shared.f64 [r27+2048], fd410;
st.shared.f64 [r27+2560], fd419;
st.shared.f64 [r27+3072], fd429;
st.shared.f64 [r27+3584], fd439;
barrier.sync 0;
ld.shared.f64 fd448, [r28];
ld.shared.f64 fd449, [r28+8192];
ld.shared.f64 fd450, [r28+16384];
ld.shared.f64 fd451, [r28+24576];
ld.shared.f64 fd452, [r28+32768];
ld.shared.f64 fd453, [r28+40960];
ld.shared.f64 fd454, [r28+49152];
ld.shared.f64 fd455, [r28+57344];
add.f64 fd456, fd440, fd444;
add.f64 fd457, fd448, fd452;
sub.f64 fd458, fd440, fd444;
sub.f64 fd459, fd448, fd452;
add.f64 fd460, fd442, fd446;
add.f64 fd461, fd450, fd454;
sub.f64 fd462, fd442, fd446;
sub.f64 fd463, fd450, fd454;
add.f64 fd464, fd456, fd460;
add.f64 fd465, fd457, fd461;
sub.f64 fd466, fd456, fd460;
sub.f64 fd467, fd457, fd461;
add.f64 fd468, fd458, fd463;
sub.f64 fd469, fd459, fd462;
sub.f64 fd470, fd458, fd463;
add.f64 fd471, fd459, fd462;
add.f64 fd472, fd441, fd445;
add.f64 fd473, fd449, fd453;
sub.f64 fd474, fd441, fd445;
sub.f64 fd475, fd449, fd453;
add.f64 fd476, fd443, fd447;
add.f64 fd477, fd451, fd455;
sub.f64 fd478, fd443, fd447;
sub.f64 fd479, fd451, fd455;
add.f64 fd480, fd472, fd476;
add.f64 fd481, fd473, fd477;
sub.f64 fd482, fd472, fd476;
sub.f64 fd483, fd473, fd477;
add.f64 fd484, fd474, fd479;
sub.f64 fd485, fd475, fd478;
sub.f64 fd486, fd474, fd479;
add.f64 fd487, fd475, fd478;
mul.f64 fd488, fd484, 0d3FE6A09E667F3BCD;
mul.f64 fd489, fd485, 0dBFE6A09E667F3BCD;
sub.f64 fd490, fd488, fd489;
mul.f64 fd491, fd485, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd492, fd484, 0dBFE6A09E667F3BCD, fd491;
mul.f64 fd493, fd486, 0dBFE6A09E667F3BCD;
mul.f64 fd494, fd487, 0dBFE6A09E667F3BCD;
sub.f64 fd495, fd493, fd494;
add.f64 fd496, fd493, fd494;
add.f64 fd497, fd464, fd480;
add.f64 fd498, fd465, fd481;
sub.f64 fd499, fd464, fd480;
sub.f64 fd500, fd465, fd481;
add.f64 fd501, fd468, fd490;
add.f64 fd502, fd469, fd492;
sub.f64 fd503, fd468, fd490;
sub.f64 fd504, fd469, fd492;
add.f64 fd505, fd466, fd483;
sub.f64 fd506, fd467, fd482;
sub.f64 fd507, fd466, fd483;
add.f64 fd508, fd467, fd482;
add.f64 fd509, fd470, fd495;
add.f64 fd510, fd471, fd496;
sub.f64 fd511, fd470, fd495;
sub.f64 fd512, fd471, fd496;
and.b32 r29, r5, 512;
bfe.u32 r30, r5, 9, 1;
mul.wide.u32 rd12, r30, 16;
mov.u64 rd13, %20;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd513, fd514}, [rd14];
mul.f64 fd517, fd513, fd501;
mul.f64 fd518, fd514, fd502;
sub.f64 fd519, fd517, fd518;
mul.f64 fd520, fd513, fd502;
fma.rn.f64 fd521, fd514, fd501, fd520;
mul.f64 fd522, fd513, fd513;
mul.f64 fd523, fd514, fd514;
sub.f64 fd524, fd522, fd523;
mul.f64 fd525, fd514, fd513;
fma.rn.f64 fd526, fd514, fd513, fd525;
mul.f64 fd527, fd524, fd505;
mul.f64 fd528, fd526, fd506;
sub.f64 fd529, fd527, fd528;
mul.f64 fd530, fd524, fd506;
fma.rn.f64 fd531, fd526, fd505, fd530;
mul.f64 fd532, fd513, fd524;
mul.f64 fd533, fd514, fd526;
sub.f64 fd534, fd532, fd533;
mul.f64 fd535, fd513, fd526;
fma.rn.f64 fd536, fd514, fd524, fd535;
mul.f64 fd537, fd534, fd509;
mul.f64 fd538, fd536, fd510;
sub.f64 fd539, fd537, fd538;
mul.f64 fd540, fd534, fd510;
fma.rn.f64 fd541, fd536, fd509, fd540;
mul.f64 fd542, fd513, fd534;
mul.f64 fd543, fd514, fd536;
sub.f64 fd544, fd542, fd543;
mul.f64 fd545, fd513, fd536;
fma.rn.f64 fd546, fd514, fd534, fd545;
mul.f64 fd547, fd544, fd499;
mul.f64 fd548, fd546, fd500;
sub.f64 fd549, fd547, fd548;
mul.f64 fd550, fd544, fd500;
fma.rn.f64 fd551, fd546, fd499, fd550;
ld.global.v2.f64 {fd552, fd553}, [rd14+32];
mul.f64 fd556, fd552, fd503;
mul.f64 fd557, fd553, fd504;
sub.f64 fd558, fd556, fd557;
mul.f64 fd559, fd552, fd504;
fma.rn.f64 fd560, fd553, fd503, fd559;
mul.f64 fd561, fd513, fd552;
mul.f64 fd562, fd514, fd553;
sub.f64 fd563, fd561, fd562;
mul.f64 fd564, fd513, fd553;
fma.rn.f64 fd565, fd514, fd552, fd564;
mul.f64 fd566, fd563, fd507;
mul.f64 fd567, fd565, fd508;
sub.f64 fd568, fd566, fd567;
mul.f64 fd569, fd563, fd508;
fma.rn.f64 fd570, fd565, fd507, fd569;
mul.f64 fd571, fd513, fd563;
mul.f64 fd572, fd514, fd565;
sub.f64 fd573, fd571, fd572;
mul.f64 fd574, fd513, fd565;
fma.rn.f64 fd575, fd514, fd563, fd574;
mul.f64 fd576, fd573, fd511;
mul.f64 fd577, fd575, fd512;
sub.f64 fd578, fd576, fd577;
mul.f64 fd579, fd573, fd512;
fma.rn.f64 fd580, fd575, fd511, fd579;
and.b32 r31, r16, 4088;
add.s32 r32, r10, r31;
barrier.sync 0;
and.b32 r33, r8, 32768;
add.s32 r34, r32, r33;
st.shared.f64 [r34], fd497;
st.shared.f64 [r34+4096], fd519;
st.shared.f64 [r34+8192], fd529;
st.shared.f64 [r34+12288], fd539;
st.shared.f64 [r34+16384], fd549;
st.shared.f64 [r34+20480], fd558;
st.shared.f64 [r34+24576], fd568;
st.shared.f64 [r34+28672], fd578;
barrier.sync 0;
mad.lo.s32 r35, r29, -56, r34;
ld.shared.f64 fd581, [r35];
ld.shared.f64 fd582, [r35+8192];
ld.shared.f64 fd583, [r35+16384];
ld.shared.f64 fd584, [r35+24576];
ld.shared.f64 fd585, [r35+32768];
ld.shared.f64 fd586, [r35+40960];
ld.shared.f64 fd587, [r35+49152];
ld.shared.f64 fd588, [r35+57344];
barrier.sync 0;
st.shared.f64 [r34], fd498;
st.shared.f64 [r34+4096], fd521;
st.shared.f64 [r34+8192], fd531;
st.shared.f64 [r34+12288], fd541;
st.shared.f64 [r34+16384], fd551;
st.shared.f64 [r34+20480], fd560;
st.shared.f64 [r34+24576], fd570;
st.shared.f64 [r34+28672], fd580;
barrier.sync 0;
ld.shared.f64 fd589, [r35];
ld.shared.f64 fd590, [r35+8192];
ld.shared.f64 fd591, [r35+16384];
ld.shared.f64 fd592, [r35+24576];
ld.shared.f64 fd593, [r35+32768];
ld.shared.f64 fd594, [r35+40960];
ld.shared.f64 fd595, [r35+49152];
ld.shared.f64 fd596, [r35+57344];
add.f64 %0, fd581, fd585;
add.f64 %1, fd589, fd593;
add.f64 %2, fd582, fd586;
add.f64 %3, fd590, fd594;
add.f64 %4, fd583, fd587;
add.f64 %5, fd591, fd595;
add.f64 %6, fd584, fd588;
add.f64 %7, fd592, fd596;
sub.f64 %8, fd581, fd585;
sub.f64 %9, fd589, fd593;
sub.f64 %10, fd582, fd586;
sub.f64 %11, fd590, fd594;
sub.f64 %12, fd583, fd587;
sub.f64 %13, fd591, fd595;
sub.f64 %14, fd584, fd588;
sub.f64 %15, fd592, fd596;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_8192), "l"(lut_dp_8_1024), "l"(lut_dp_8_128), "l"(lut_dp_8_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<498, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<1162>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 16;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd65, %36, %57;
add.f64 fd66, %37, %59;
sub.f64 fd67, %36, %57;
sub.f64 fd68, %37, %59;
add.f64 fd69, %46, %68;
add.f64 fd70, %48, %69;
sub.f64 fd71, %46, %68;
sub.f64 fd72, %48, %69;
add.f64 fd73, fd65, fd69;
add.f64 fd74, fd66, fd70;
sub.f64 fd75, fd65, fd69;
sub.f64 fd76, fd66, fd70;
add.f64 fd77, fd67, fd72;
sub.f64 fd78, fd68, fd71;
sub.f64 fd79, fd67, fd72;
add.f64 fd80, fd68, fd71;
add.f64 fd81, %41, %62;
add.f64 fd82, %43, %64;
sub.f64 fd83, %41, %62;
sub.f64 fd84, %43, %64;
add.f64 fd85, %52, %73;
add.f64 fd86, %53, %75;
sub.f64 fd87, %52, %73;
sub.f64 fd88, %53, %75;
add.f64 fd89, fd81, fd85;
add.f64 fd90, fd82, fd86;
sub.f64 fd91, fd81, fd85;
sub.f64 fd92, fd82, fd86;
add.f64 fd93, fd83, fd88;
sub.f64 fd94, fd84, fd87;
sub.f64 fd95, fd83, fd88;
add.f64 fd96, fd84, fd87;
mul.f64 fd97, fd93, 0d3FE6A09E667F3BCD;
mul.f64 fd98, fd94, 0dBFE6A09E667F3BCD;
sub.f64 fd99, fd97, fd98;
mul.f64 fd100, fd94, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd101, fd93, 0dBFE6A09E667F3BCD, fd100;
mul.f64 fd102, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd103, fd96, 0dBFE6A09E667F3BCD;
sub.f64 fd104, fd102, fd103;
add.f64 fd105, fd102, fd103;
add.f64 fd106, fd73, fd89;
add.f64 fd107, fd74, fd90;
sub.f64 fd108, fd73, fd89;
sub.f64 fd109, fd74, fd90;
add.f64 fd110, fd77, fd99;
add.f64 fd111, fd78, fd101;
sub.f64 fd112, fd77, fd99;
sub.f64 fd113, fd78, fd101;
add.f64 fd114, fd75, fd92;
sub.f64 fd115, fd76, fd91;
sub.f64 fd116, fd75, fd92;
add.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd104;
add.f64 fd119, fd80, fd105;
sub.f64 fd120, fd79, fd104;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %38, %60;
add.f64 fd123, %40, %61;
sub.f64 fd124, %38, %60;
sub.f64 fd125, %40, %61;
add.f64 fd126, %49, %70;
add.f64 fd127, %51, %72;
sub.f64 fd128, %49, %70;
sub.f64 fd129, %51, %72;
add.f64 fd130, fd122, fd126;
add.f64 fd131, fd123, fd127;
sub.f64 fd132, fd122, fd126;
sub.f64 fd133, fd123, fd127;
add.f64 fd134, fd124, fd129;
sub.f64 fd135, fd125, fd128;
sub.f64 fd136, fd124, fd129;
add.f64 fd137, fd125, fd128;
add.f64 fd138, %44, %65;
add.f64 fd139, %45, %67;
sub.f64 fd140, %44, %65;
sub.f64 fd141, %45, %67;
add.f64 fd142, %54, %76;
add.f64 fd143, %56, %77;
sub.f64 fd144, %54, %76;
sub.f64 fd145, %56, %77;
add.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd143;
sub.f64 fd148, fd138, fd142;
sub.f64 fd149, fd139, fd143;
add.f64 fd150, fd140, fd145;
sub.f64 fd151, fd141, fd144;
sub.f64 fd152, fd140, fd145;
add.f64 fd153, fd141, fd144;
mul.f64 fd154, fd150, 0d3FE6A09E667F3BCD;
mul.f64 fd155, fd151, 0dBFE6A09E667F3BCD;
sub.f64 fd156, fd154, fd155;
mul.f64 fd157, fd151, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd158, fd150, 0dBFE6A09E667F3BCD, fd157;
mul.f64 fd159, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd160, fd153, 0dBFE6A09E667F3BCD;
sub.f64 fd161, fd159, fd160;
add.f64 fd162, fd159, fd160;
add.f64 fd163, fd130, fd146;
add.f64 fd164, fd131, fd147;
sub.f64 fd165, fd130, fd146;
sub.f64 fd166, fd131, fd147;
add.f64 fd167, fd134, fd156;
add.f64 fd168, fd135, fd158;
sub.f64 fd169, fd134, fd156;
sub.f64 fd170, fd135, fd158;
add.f64 fd171, fd132, fd149;
sub.f64 fd172, fd133, fd148;
sub.f64 fd173, fd132, fd149;
add.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd161;
add.f64 fd176, fd137, fd162;
sub.f64 fd177, fd136, fd161;
sub.f64 fd178, fd137, fd162;
mul.f64 fd179, fd167, 0d3FED906BCF328D46;
mul.f64 fd180, fd168, 0dBFD87DE2A6AEA963;
sub.f64 fd181, fd179, fd180;
mul.f64 fd182, fd168, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0dBFD87DE2A6AEA963, fd182;
mul.f64 fd184, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd185, fd172, 0dBFE6A09E667F3BCD;
sub.f64 fd186, fd184, fd185;
mul.f64 fd187, fd172, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd188, fd171, 0dBFE6A09E667F3BCD, fd187;
mul.f64 fd189, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd190, fd176, 0dBFED906BCF328D46;
sub.f64 fd191, fd189, fd190;
mul.f64 fd192, fd176, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd193, fd175, 0dBFED906BCF328D46, fd192;
mul.f64 fd194, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd195, fd170, 0dBFED906BCF328D46;
sub.f64 fd196, fd194, fd195;
mul.f64 fd197, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd198, fd169, 0dBFED906BCF328D46, fd197;
mul.f64 fd199, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd200, fd174, 0dBFE6A09E667F3BCD;
sub.f64 fd201, fd199, fd200;
add.f64 fd202, fd199, fd200;
mul.f64 fd203, fd177, 0dBFED906BCF328D46;
mul.f64 fd204, fd178, 0dBFD87DE2A6AEA963;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0dBFD87DE2A6AEA963, fd206;
add.f64 fd208, fd106, fd163;
add.f64 fd209, fd107, fd164;
sub.f64 fd210, fd106, fd163;
sub.f64 fd211, fd107, fd164;
add.f64 fd212, fd110, fd181;
add.f64 fd213, fd111, fd183;
sub.f64 fd214, fd110, fd181;
sub.f64 fd215, fd111, fd183;
add.f64 fd216, fd114, fd186;
add.f64 fd217, fd115, fd188;
sub.f64 fd218, fd114, fd186;
sub.f64 fd219, fd115, fd188;
add.f64 fd220, fd118, fd191;
add.f64 fd221, fd119, fd193;
sub.f64 fd222, fd118, fd191;
sub.f64 fd223, fd119, fd193;
add.f64 fd224, fd108, fd166;
sub.f64 fd225, fd109, fd165;
sub.f64 fd226, fd108, fd166;
add.f64 fd227, fd109, fd165;
add.f64 fd228, fd112, fd196;
add.f64 fd229, fd113, fd198;
sub.f64 fd230, fd112, fd196;
sub.f64 fd231, fd113, fd198;
add.f64 fd232, fd116, fd201;
add.f64 fd233, fd117, fd202;
sub.f64 fd234, fd116, fd201;
sub.f64 fd235, fd117, fd202;
add.f64 fd236, fd120, fd205;
add.f64 fd237, fd121, fd207;
sub.f64 fd238, fd120, fd205;
sub.f64 fd239, fd121, fd207;
and.b32 r6, r5, 511;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 8176;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd240, fd241}, [rd5];
mul.f64 fd244, fd240, fd212;
mul.f64 fd245, fd241, fd213;
sub.f64 fd246, fd244, fd245;
mul.f64 fd247, fd240, fd213;
fma.rn.f64 fd248, fd241, fd212, fd247;
mul.f64 fd249, fd240, fd240;
mul.f64 fd250, fd241, fd241;
sub.f64 fd251, fd249, fd250;
mul.f64 fd252, fd241, fd240;
fma.rn.f64 fd253, fd241, fd240, fd252;
mul.f64 fd254, fd251, fd216;
mul.f64 fd255, fd253, fd217;
sub.f64 fd256, fd254, fd255;
mul.f64 fd257, fd251, fd217;
fma.rn.f64 fd258, fd253, fd216, fd257;
mul.f64 fd259, fd240, fd251;
mul.f64 fd260, fd241, fd253;
sub.f64 fd261, fd259, fd260;
mul.f64 fd262, fd240, fd253;
fma.rn.f64 fd263, fd241, fd251, fd262;
mul.f64 fd264, fd261, fd220;
mul.f64 fd265, fd263, fd221;
sub.f64 fd266, fd264, fd265;
mul.f64 fd267, fd261, fd221;
fma.rn.f64 fd268, fd263, fd220, fd267;
mul.f64 fd269, fd240, fd261;
mul.f64 fd270, fd241, fd263;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd240, fd263;
fma.rn.f64 fd273, fd241, fd261, fd272;
mul.f64 fd274, fd271, fd224;
mul.f64 fd275, fd273, fd225;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd271, fd225;
fma.rn.f64 fd278, fd273, fd224, fd277;
mul.f64 fd279, fd240, fd271;
mul.f64 fd280, fd241, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd240, fd273;
fma.rn.f64 fd283, fd241, fd271, fd282;
mul.f64 fd284, fd281, fd228;
mul.f64 fd285, fd283, fd229;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd229;
fma.rn.f64 fd288, fd283, fd228, fd287;
mul.f64 fd289, fd240, fd281;
mul.f64 fd290, fd241, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd240, fd283;
fma.rn.f64 fd293, fd241, fd281, fd292;
mul.f64 fd294, fd291, fd232;
mul.f64 fd295, fd293, fd233;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd233;
fma.rn.f64 fd298, fd293, fd232, fd297;
mul.f64 fd299, fd240, fd291;
mul.f64 fd300, fd241, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd240, fd293;
fma.rn.f64 fd303, fd241, fd291, fd302;
mul.f64 fd304, fd301, fd236;
mul.f64 fd305, fd303, fd237;
sub.f64 fd306, fd304, fd305;
mul.f64 fd307, fd301, fd237;
fma.rn.f64 fd308, fd303, fd236, fd307;
mul.f64 fd309, fd240, fd301;
mul.f64 fd310, fd241, fd303;
sub.f64 fd311, fd309, fd310;
mul.f64 fd312, fd240, fd303;
fma.rn.f64 fd313, fd241, fd301, fd312;
mul.f64 fd314, fd311, fd210;
mul.f64 fd315, fd313, fd211;
sub.f64 fd316, fd314, fd315;
mul.f64 fd317, fd311, fd211;
fma.rn.f64 fd318, fd313, fd210, fd317;
ld.global.v2.f64 {fd319, fd320}, [rd5+8192];
mul.f64 fd323, fd319, fd214;
mul.f64 fd324, fd320, fd215;
sub.f64 fd325, fd323, fd324;
mul.f64 fd326, fd319, fd215;
fma.rn.f64 fd327, fd320, fd214, fd326;
mul.f64 fd328, fd240, fd319;
mul.f64 fd329, fd241, fd320;
sub.f64 fd330, fd328, fd329;
mul.f64 fd331, fd240, fd320;
fma.rn.f64 fd332, fd241, fd319, fd331;
mul.f64 fd333, fd330, fd218;
mul.f64 fd334, fd332, fd219;
sub.f64 fd335, fd333, fd334;
mul.f64 fd336, fd330, fd219;
fma.rn.f64 fd337, fd332, fd218, fd336;
mul.f64 fd338, fd240, fd330;
mul.f64 fd339, fd241, fd332;
sub.f64 fd340, fd338, fd339;
mul.f64 fd341, fd240, fd332;
fma.rn.f64 fd342, fd241, fd330, fd341;
mul.f64 fd343, fd340, fd222;
mul.f64 fd344, fd342, fd223;
sub.f64 fd345, fd343, fd344;
mul.f64 fd346, fd340, fd223;
fma.rn.f64 fd347, fd342, fd222, fd346;
mul.f64 fd348, fd240, fd340;
mul.f64 fd349, fd241, fd342;
sub.f64 fd350, fd348, fd349;
mul.f64 fd351, fd240, fd342;
fma.rn.f64 fd352, fd241, fd340, fd351;
mul.f64 fd353, fd350, fd226;
mul.f64 fd354, fd352, fd227;
sub.f64 fd355, fd353, fd354;
mul.f64 fd356, fd350, fd227;
fma.rn.f64 fd357, fd352, fd226, fd356;
mul.f64 fd358, fd240, fd350;
mul.f64 fd359, fd241, fd352;
sub.f64 fd360, fd358, fd359;
mul.f64 fd361, fd240, fd352;
fma.rn.f64 fd362, fd241, fd350, fd361;
mul.f64 fd363, fd360, fd230;
mul.f64 fd364, fd362, fd231;
sub.f64 fd365, fd363, fd364;
mul.f64 fd366, fd360, fd231;
fma.rn.f64 fd367, fd362, fd230, fd366;
mul.f64 fd368, fd240, fd360;
mul.f64 fd369, fd241, fd362;
sub.f64 fd370, fd368, fd369;
mul.f64 fd371, fd240, fd362;
fma.rn.f64 fd372, fd241, fd360, fd371;
mul.f64 fd373, fd370, fd234;
mul.f64 fd374, fd372, fd235;
sub.f64 fd375, fd373, fd374;
mul.f64 fd376, fd370, fd235;
fma.rn.f64 fd377, fd372, fd234, fd376;
mul.f64 fd378, fd240, fd370;
mul.f64 fd379, fd241, fd372;
sub.f64 fd380, fd378, fd379;
mul.f64 fd381, fd240, fd372;
fma.rn.f64 fd382, fd241, fd370, fd381;
mul.f64 fd383, fd380, fd238;
mul.f64 fd384, fd382, fd239;
sub.f64 fd385, fd383, fd384;
mul.f64 fd386, fd380, fd239;
fma.rn.f64 fd387, fd382, fd238, fd386;
shl.b32 r8, r5, 7;
and.b32 r9, r8, -65536;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 65408;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd208, fd246};
st.shared.v2.f64 [r12+16], {fd256, fd266};
st.shared.v2.f64 [r12+32], {fd276, fd286};
st.shared.v2.f64 [r12+48], {fd296, fd306};
st.shared.v2.f64 [r12+64], {fd316, fd325};
st.shared.v2.f64 [r12+80], {fd335, fd345};
st.shared.v2.f64 [r12+96], {fd355, fd365};
st.shared.v2.f64 [r12+112], {fd375, fd385};
barrier.sync 0;
mad.lo.s32 r13, r6, -120, r12;
ld.shared.f64 fd388, [r13];
ld.shared.f64 fd389, [r13+4096];
ld.shared.f64 fd390, [r13+8192];
ld.shared.f64 fd391, [r13+12288];
ld.shared.f64 fd392, [r13+16384];
ld.shared.f64 fd393, [r13+20480];
ld.shared.f64 fd394, [r13+24576];
ld.shared.f64 fd395, [r13+28672];
ld.shared.f64 fd396, [r13+32768];
ld.shared.f64 fd397, [r13+36864];
ld.shared.f64 fd398, [r13+40960];
ld.shared.f64 fd399, [r13+45056];
ld.shared.f64 fd400, [r13+49152];
ld.shared.f64 fd401, [r13+53248];
ld.shared.f64 fd402, [r13+57344];
ld.shared.f64 fd403, [r13+61440];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd209, fd248};
st.shared.v2.f64 [r12+16], {fd258, fd268};
st.shared.v2.f64 [r12+32], {fd278, fd288};
st.shared.v2.f64 [r12+48], {fd298, fd308};
st.shared.v2.f64 [r12+64], {fd318, fd327};
st.shared.v2.f64 [r12+80], {fd337, fd347};
st.shared.v2.f64 [r12+96], {fd357, fd367};
st.shared.v2.f64 [r12+112], {fd377, fd387};
barrier.sync 0;
ld.shared.f64 fd404, [r13];
ld.shared.f64 fd405, [r13+4096];
ld.shared.f64 fd406, [r13+8192];
ld.shared.f64 fd407, [r13+12288];
ld.shared.f64 fd408, [r13+16384];
ld.shared.f64 fd409, [r13+20480];
ld.shared.f64 fd410, [r13+24576];
ld.shared.f64 fd411, [r13+28672];
ld.shared.f64 fd412, [r13+32768];
ld.shared.f64 fd413, [r13+36864];
ld.shared.f64 fd414, [r13+40960];
ld.shared.f64 fd415, [r13+45056];
ld.shared.f64 fd416, [r13+49152];
ld.shared.f64 fd417, [r13+53248];
ld.shared.f64 fd418, [r13+57344];
ld.shared.f64 fd419, [r13+61440];
add.f64 fd420, fd388, fd396;
add.f64 fd421, fd404, fd412;
sub.f64 fd422, fd388, fd396;
sub.f64 fd423, fd404, fd412;
add.f64 fd424, fd392, fd400;
add.f64 fd425, fd408, fd416;
sub.f64 fd426, fd392, fd400;
sub.f64 fd427, fd408, fd416;
add.f64 fd428, fd420, fd424;
add.f64 fd429, fd421, fd425;
sub.f64 fd430, fd420, fd424;
sub.f64 fd431, fd421, fd425;
add.f64 fd432, fd422, fd427;
sub.f64 fd433, fd423, fd426;
sub.f64 fd434, fd422, fd427;
add.f64 fd435, fd423, fd426;
add.f64 fd436, fd390, fd398;
add.f64 fd437, fd406, fd414;
sub.f64 fd438, fd390, fd398;
sub.f64 fd439, fd406, fd414;
add.f64 fd440, fd394, fd402;
add.f64 fd441, fd410, fd418;
sub.f64 fd442, fd394, fd402;
sub.f64 fd443, fd410, fd418;
add.f64 fd444, fd436, fd440;
add.f64 fd445, fd437, fd441;
sub.f64 fd446, fd436, fd440;
sub.f64 fd447, fd437, fd441;
add.f64 fd448, fd438, fd443;
sub.f64 fd449, fd439, fd442;
sub.f64 fd450, fd438, fd443;
add.f64 fd451, fd439, fd442;
mul.f64 fd452, fd448, 0d3FE6A09E667F3BCD;
mul.f64 fd453, fd449, 0dBFE6A09E667F3BCD;
sub.f64 fd454, fd452, fd453;
mul.f64 fd455, fd449, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd456, fd448, 0dBFE6A09E667F3BCD, fd455;
mul.f64 fd457, fd450, 0dBFE6A09E667F3BCD;
mul.f64 fd458, fd451, 0dBFE6A09E667F3BCD;
sub.f64 fd459, fd457, fd458;
add.f64 fd460, fd457, fd458;
add.f64 fd461, fd428, fd444;
add.f64 fd462, fd429, fd445;
sub.f64 fd463, fd428, fd444;
sub.f64 fd464, fd429, fd445;
add.f64 fd465, fd432, fd454;
add.f64 fd466, fd433, fd456;
sub.f64 fd467, fd432, fd454;
sub.f64 fd468, fd433, fd456;
add.f64 fd469, fd430, fd447;
sub.f64 fd470, fd431, fd446;
sub.f64 fd471, fd430, fd447;
add.f64 fd472, fd431, fd446;
add.f64 fd473, fd434, fd459;
add.f64 fd474, fd435, fd460;
sub.f64 fd475, fd434, fd459;
sub.f64 fd476, fd435, fd460;
add.f64 fd477, fd389, fd397;
add.f64 fd478, fd405, fd413;
sub.f64 fd479, fd389, fd397;
sub.f64 fd480, fd405, fd413;
add.f64 fd481, fd393, fd401;
add.f64 fd482, fd409, fd417;
sub.f64 fd483, fd393, fd401;
sub.f64 fd484, fd409, fd417;
add.f64 fd485, fd477, fd481;
add.f64 fd486, fd478, fd482;
sub.f64 fd487, fd477, fd481;
sub.f64 fd488, fd478, fd482;
add.f64 fd489, fd479, fd484;
sub.f64 fd490, fd480, fd483;
sub.f64 fd491, fd479, fd484;
add.f64 fd492, fd480, fd483;
add.f64 fd493, fd391, fd399;
add.f64 fd494, fd407, fd415;
sub.f64 fd495, fd391, fd399;
sub.f64 fd496, fd407, fd415;
add.f64 fd497, fd395, fd403;
add.f64 fd498, fd411, fd419;
sub.f64 fd499, fd395, fd403;
sub.f64 fd500, fd411, fd419;
add.f64 fd501, fd493, fd497;
add.f64 fd502, fd494, fd498;
sub.f64 fd503, fd493, fd497;
sub.f64 fd504, fd494, fd498;
add.f64 fd505, fd495, fd500;
sub.f64 fd506, fd496, fd499;
sub.f64 fd507, fd495, fd500;
add.f64 fd508, fd496, fd499;
mul.f64 fd509, fd505, 0d3FE6A09E667F3BCD;
mul.f64 fd510, fd506, 0dBFE6A09E667F3BCD;
sub.f64 fd511, fd509, fd510;
mul.f64 fd512, fd506, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd513, fd505, 0dBFE6A09E667F3BCD, fd512;
mul.f64 fd514, fd507, 0dBFE6A09E667F3BCD;
mul.f64 fd515, fd508, 0dBFE6A09E667F3BCD;
sub.f64 fd516, fd514, fd515;
add.f64 fd517, fd514, fd515;
add.f64 fd518, fd485, fd501;
add.f64 fd519, fd486, fd502;
sub.f64 fd520, fd485, fd501;
sub.f64 fd521, fd486, fd502;
add.f64 fd522, fd489, fd511;
add.f64 fd523, fd490, fd513;
sub.f64 fd524, fd489, fd511;
sub.f64 fd525, fd490, fd513;
add.f64 fd526, fd487, fd504;
sub.f64 fd527, fd488, fd503;
sub.f64 fd528, fd487, fd504;
add.f64 fd529, fd488, fd503;
add.f64 fd530, fd491, fd516;
add.f64 fd531, fd492, fd517;
sub.f64 fd532, fd491, fd516;
sub.f64 fd533, fd492, fd517;
mul.f64 fd534, fd522, 0d3FED906BCF328D46;
mul.f64 fd535, fd523, 0dBFD87DE2A6AEA963;
sub.f64 fd536, fd534, fd535;
mul.f64 fd537, fd523, 0d3FED906BCF328D46;
fma.rn.f64 fd538, fd522, 0dBFD87DE2A6AEA963, fd537;
mul.f64 fd539, fd526, 0d3FE6A09E667F3BCD;
mul.f64 fd540, fd527, 0dBFE6A09E667F3BCD;
sub.f64 fd541, fd539, fd540;
mul.f64 fd542, fd527, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd543, fd526, 0dBFE6A09E667F3BCD, fd542;
mul.f64 fd544, fd530, 0d3FD87DE2A6AEA963;
mul.f64 fd545, fd531, 0dBFED906BCF328D46;
sub.f64 fd546, fd544, fd545;
mul.f64 fd547, fd531, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd548, fd530, 0dBFED906BCF328D46, fd547;
mul.f64 fd549, fd524, 0dBFD87DE2A6AEA963;
mul.f64 fd550, fd525, 0dBFED906BCF328D46;
sub.f64 fd551, fd549, fd550;
mul.f64 fd552, fd525, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd553, fd524, 0dBFED906BCF328D46, fd552;
mul.f64 fd554, fd528, 0dBFE6A09E667F3BCD;
mul.f64 fd555, fd529, 0dBFE6A09E667F3BCD;
sub.f64 fd556, fd554, fd555;
add.f64 fd557, fd554, fd555;
mul.f64 fd558, fd532, 0dBFED906BCF328D46;
mul.f64 fd559, fd533, 0dBFD87DE2A6AEA963;
sub.f64 fd560, fd558, fd559;
mul.f64 fd561, fd533, 0dBFED906BCF328D46;
fma.rn.f64 fd562, fd532, 0dBFD87DE2A6AEA963, fd561;
add.f64 fd563, fd461, fd518;
add.f64 fd564, fd462, fd519;
sub.f64 fd565, fd461, fd518;
sub.f64 fd566, fd462, fd519;
add.f64 fd567, fd465, fd536;
add.f64 fd568, fd466, fd538;
sub.f64 fd569, fd465, fd536;
sub.f64 fd570, fd466, fd538;
add.f64 fd571, fd469, fd541;
add.f64 fd572, fd470, fd543;
sub.f64 fd573, fd469, fd541;
sub.f64 fd574, fd470, fd543;
add.f64 fd575, fd473, fd546;
add.f64 fd576, fd474, fd548;
sub.f64 fd577, fd473, fd546;
sub.f64 fd578, fd474, fd548;
add.f64 fd579, fd463, fd521;
sub.f64 fd580, fd464, fd520;
sub.f64 fd581, fd463, fd521;
add.f64 fd582, fd464, fd520;
add.f64 fd583, fd467, fd551;
add.f64 fd584, fd468, fd553;
sub.f64 fd585, fd467, fd551;
sub.f64 fd586, fd468, fd553;
add.f64 fd587, fd471, fd556;
add.f64 fd588, fd472, fd557;
sub.f64 fd589, fd471, fd556;
sub.f64 fd590, fd472, fd557;
add.f64 fd591, fd475, fd560;
add.f64 fd592, fd476, fd562;
sub.f64 fd593, fd475, fd560;
sub.f64 fd594, fd476, fd562;
and.b32 r14, r5, 496;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %34;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd595, fd596}, [rd8];
mul.f64 fd599, fd595, fd567;
mul.f64 fd600, fd596, fd568;
sub.f64 fd601, fd599, fd600;
mul.f64 fd602, fd595, fd568;
fma.rn.f64 fd603, fd596, fd567, fd602;
mul.f64 fd604, fd595, fd595;
mul.f64 fd605, fd596, fd596;
sub.f64 fd606, fd604, fd605;
mul.f64 fd607, fd596, fd595;
fma.rn.f64 fd608, fd596, fd595, fd607;
mul.f64 fd609, fd606, fd571;
mul.f64 fd610, fd608, fd572;
sub.f64 fd611, fd609, fd610;
mul.f64 fd612, fd606, fd572;
fma.rn.f64 fd613, fd608, fd571, fd612;
mul.f64 fd614, fd595, fd606;
mul.f64 fd615, fd596, fd608;
sub.f64 fd616, fd614, fd615;
mul.f64 fd617, fd595, fd608;
fma.rn.f64 fd618, fd596, fd606, fd617;
mul.f64 fd619, fd616, fd575;
mul.f64 fd620, fd618, fd576;
sub.f64 fd621, fd619, fd620;
mul.f64 fd622, fd616, fd576;
fma.rn.f64 fd623, fd618, fd575, fd622;
mul.f64 fd624, fd595, fd616;
mul.f64 fd625, fd596, fd618;
sub.f64 fd626, fd624, fd625;
mul.f64 fd627, fd595, fd618;
fma.rn.f64 fd628, fd596, fd616, fd627;
mul.f64 fd629, fd626, fd579;
mul.f64 fd630, fd628, fd580;
sub.f64 fd631, fd629, fd630;
mul.f64 fd632, fd626, fd580;
fma.rn.f64 fd633, fd628, fd579, fd632;
mul.f64 fd634, fd595, fd626;
mul.f64 fd635, fd596, fd628;
sub.f64 fd636, fd634, fd635;
mul.f64 fd637, fd595, fd628;
fma.rn.f64 fd638, fd596, fd626, fd637;
mul.f64 fd639, fd636, fd583;
mul.f64 fd640, fd638, fd584;
sub.f64 fd641, fd639, fd640;
mul.f64 fd642, fd636, fd584;
fma.rn.f64 fd643, fd638, fd583, fd642;
mul.f64 fd644, fd595, fd636;
mul.f64 fd645, fd596, fd638;
sub.f64 fd646, fd644, fd645;
mul.f64 fd647, fd595, fd638;
fma.rn.f64 fd648, fd596, fd636, fd647;
mul.f64 fd649, fd646, fd587;
mul.f64 fd650, fd648, fd588;
sub.f64 fd651, fd649, fd650;
mul.f64 fd652, fd646, fd588;
fma.rn.f64 fd653, fd648, fd587, fd652;
mul.f64 fd654, fd595, fd646;
mul.f64 fd655, fd596, fd648;
sub.f64 fd656, fd654, fd655;
mul.f64 fd657, fd595, fd648;
fma.rn.f64 fd658, fd596, fd646, fd657;
mul.f64 fd659, fd656, fd591;
mul.f64 fd660, fd658, fd592;
sub.f64 fd661, fd659, fd660;
mul.f64 fd662, fd656, fd592;
fma.rn.f64 fd663, fd658, fd591, fd662;
mul.f64 fd664, fd595, fd656;
mul.f64 fd665, fd596, fd658;
sub.f64 fd666, fd664, fd665;
mul.f64 fd667, fd595, fd658;
fma.rn.f64 fd668, fd596, fd656, fd667;
mul.f64 fd669, fd666, fd565;
mul.f64 fd670, fd668, fd566;
sub.f64 fd671, fd669, fd670;
mul.f64 fd672, fd666, fd566;
fma.rn.f64 fd673, fd668, fd565, fd672;
ld.global.v2.f64 {fd674, fd675}, [rd8+512];
mul.f64 fd678, fd674, fd569;
mul.f64 fd679, fd675, fd570;
sub.f64 fd680, fd678, fd679;
mul.f64 fd681, fd674, fd570;
fma.rn.f64 fd682, fd675, fd569, fd681;
mul.f64 fd683, fd595, fd674;
mul.f64 fd684, fd596, fd675;
sub.f64 fd685, fd683, fd684;
mul.f64 fd686, fd595, fd675;
fma.rn.f64 fd687, fd596, fd674, fd686;
mul.f64 fd688, fd685, fd573;
mul.f64 fd689, fd687, fd574;
sub.f64 fd690, fd688, fd689;
mul.f64 fd691, fd685, fd574;
fma.rn.f64 fd692, fd687, fd573, fd691;
mul.f64 fd693, fd595, fd685;
mul.f64 fd694, fd596, fd687;
sub.f64 fd695, fd693, fd694;
mul.f64 fd696, fd595, fd687;
fma.rn.f64 fd697, fd596, fd685, fd696;
mul.f64 fd698, fd695, fd577;
mul.f64 fd699, fd697, fd578;
sub.f64 fd700, fd698, fd699;
mul.f64 fd701, fd695, fd578;
fma.rn.f64 fd702, fd697, fd577, fd701;
mul.f64 fd703, fd595, fd695;
mul.f64 fd704, fd596, fd697;
sub.f64 fd705, fd703, fd704;
mul.f64 fd706, fd595, fd697;
fma.rn.f64 fd707, fd596, fd695, fd706;
mul.f64 fd708, fd705, fd581;
mul.f64 fd709, fd707, fd582;
sub.f64 fd710, fd708, fd709;
mul.f64 fd711, fd705, fd582;
fma.rn.f64 fd712, fd707, fd581, fd711;
mul.f64 fd713, fd595, fd705;
mul.f64 fd714, fd596, fd707;
sub.f64 fd715, fd713, fd714;
mul.f64 fd716, fd595, fd707;
fma.rn.f64 fd717, fd596, fd705, fd716;
mul.f64 fd718, fd715, fd585;
mul.f64 fd719, fd717, fd586;
sub.f64 fd720, fd718, fd719;
mul.f64 fd721, fd715, fd586;
fma.rn.f64 fd722, fd717, fd585, fd721;
mul.f64 fd723, fd595, fd715;
mul.f64 fd724, fd596, fd717;
sub.f64 fd725, fd723, fd724;
mul.f64 fd726, fd595, fd717;
fma.rn.f64 fd727, fd596, fd715, fd726;
mul.f64 fd728, fd725, fd589;
mul.f64 fd729, fd727, fd590;
sub.f64 fd730, fd728, fd729;
mul.f64 fd731, fd725, fd590;
fma.rn.f64 fd732, fd727, fd589, fd731;
mul.f64 fd733, fd595, fd725;
mul.f64 fd734, fd596, fd727;
sub.f64 fd735, fd733, fd734;
mul.f64 fd736, fd595, fd727;
fma.rn.f64 fd737, fd596, fd725, fd736;
mul.f64 fd738, fd735, fd593;
mul.f64 fd739, fd737, fd594;
sub.f64 fd740, fd738, fd739;
mul.f64 fd741, fd735, fd594;
fma.rn.f64 fd742, fd737, fd593, fd741;
shl.b32 r15, r5, 3;
and.b32 r16, r15, 120;
add.s32 r17, r10, r16;
barrier.sync 0;
and.b32 r18, r8, 63488;
add.s32 r19, r17, r18;
st.shared.f64 [r19], fd563;
st.shared.f64 [r19+128], fd601;
st.shared.f64 [r19+256], fd611;
st.shared.f64 [r19+384], fd621;
st.shared.f64 [r19+512], fd631;
st.shared.f64 [r19+640], fd641;
st.shared.f64 [r19+768], fd651;
st.shared.f64 [r19+896], fd661;
st.shared.f64 [r19+1024], fd671;
st.shared.f64 [r19+1152], fd680;
st.shared.f64 [r19+1280], fd690;
st.shared.f64 [r19+1408], fd700;
st.shared.f64 [r19+1536], fd710;
st.shared.f64 [r19+1664], fd720;
st.shared.f64 [r19+1792], fd730;
st.shared.f64 [r19+1920], fd740;
barrier.sync 0;
mad.lo.s32 r20, r14, -120, r19;
ld.shared.f64 fd743, [r20];
ld.shared.f64 fd744, [r20+4096];
ld.shared.f64 fd745, [r20+8192];
ld.shared.f64 fd746, [r20+12288];
ld.shared.f64 fd747, [r20+16384];
ld.shared.f64 fd748, [r20+20480];
ld.shared.f64 fd749, [r20+24576];
ld.shared.f64 fd750, [r20+28672];
ld.shared.f64 fd751, [r20+32768];
ld.shared.f64 fd752, [r20+36864];
ld.shared.f64 fd753, [r20+40960];
ld.shared.f64 fd754, [r20+45056];
ld.shared.f64 fd755, [r20+49152];
ld.shared.f64 fd756, [r20+53248];
ld.shared.f64 fd757, [r20+57344];
ld.shared.f64 fd758, [r20+61440];
barrier.sync 0;
st.shared.f64 [r19], fd564;
st.shared.f64 [r19+128], fd603;
st.shared.f64 [r19+256], fd613;
st.shared.f64 [r19+384], fd623;
st.shared.f64 [r19+512], fd633;
st.shared.f64 [r19+640], fd643;
st.shared.f64 [r19+768], fd653;
st.shared.f64 [r19+896], fd663;
st.shared.f64 [r19+1024], fd673;
st.shared.f64 [r19+1152], fd682;
st.shared.f64 [r19+1280], fd692;
st.shared.f64 [r19+1408], fd702;
st.shared.f64 [r19+1536], fd712;
st.shared.f64 [r19+1664], fd722;
st.shared.f64 [r19+1792], fd732;
st.shared.f64 [r19+1920], fd742;
barrier.sync 0;
ld.shared.f64 fd759, [r20];
ld.shared.f64 fd760, [r20+4096];
ld.shared.f64 fd761, [r20+8192];
ld.shared.f64 fd762, [r20+12288];
ld.shared.f64 fd763, [r20+16384];
ld.shared.f64 fd764, [r20+20480];
ld.shared.f64 fd765, [r20+24576];
ld.shared.f64 fd766, [r20+28672];
ld.shared.f64 fd767, [r20+32768];
ld.shared.f64 fd768, [r20+36864];
ld.shared.f64 fd769, [r20+40960];
ld.shared.f64 fd770, [r20+45056];
ld.shared.f64 fd771, [r20+49152];
ld.shared.f64 fd772, [r20+53248];
ld.shared.f64 fd773, [r20+57344];
ld.shared.f64 fd774, [r20+61440];
add.f64 fd775, fd743, fd751;
add.f64 fd776, fd759, fd767;
sub.f64 fd777, fd743, fd751;
sub.f64 fd778, fd759, fd767;
add.f64 fd779, fd747, fd755;
add.f64 fd780, fd763, fd771;
sub.f64 fd781, fd747, fd755;
sub.f64 fd782, fd763, fd771;
add.f64 fd783, fd775, fd779;
add.f64 fd784, fd776, fd780;
sub.f64 fd785, fd775, fd779;
sub.f64 fd786, fd776, fd780;
add.f64 fd787, fd777, fd782;
sub.f64 fd788, fd778, fd781;
sub.f64 fd789, fd777, fd782;
add.f64 fd790, fd778, fd781;
add.f64 fd791, fd745, fd753;
add.f64 fd792, fd761, fd769;
sub.f64 fd793, fd745, fd753;
sub.f64 fd794, fd761, fd769;
add.f64 fd795, fd749, fd757;
add.f64 fd796, fd765, fd773;
sub.f64 fd797, fd749, fd757;
sub.f64 fd798, fd765, fd773;
add.f64 fd799, fd791, fd795;
add.f64 fd800, fd792, fd796;
sub.f64 fd801, fd791, fd795;
sub.f64 fd802, fd792, fd796;
add.f64 fd803, fd793, fd798;
sub.f64 fd804, fd794, fd797;
sub.f64 fd805, fd793, fd798;
add.f64 fd806, fd794, fd797;
mul.f64 fd807, fd803, 0d3FE6A09E667F3BCD;
mul.f64 fd808, fd804, 0dBFE6A09E667F3BCD;
sub.f64 fd809, fd807, fd808;
mul.f64 fd810, fd804, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd811, fd803, 0dBFE6A09E667F3BCD, fd810;
mul.f64 fd812, fd805, 0dBFE6A09E667F3BCD;
mul.f64 fd813, fd806, 0dBFE6A09E667F3BCD;
sub.f64 fd814, fd812, fd813;
add.f64 fd815, fd812, fd813;
add.f64 fd816, fd783, fd799;
add.f64 fd817, fd784, fd800;
sub.f64 fd818, fd783, fd799;
sub.f64 fd819, fd784, fd800;
add.f64 fd820, fd787, fd809;
add.f64 fd821, fd788, fd811;
sub.f64 fd822, fd787, fd809;
sub.f64 fd823, fd788, fd811;
add.f64 fd824, fd785, fd802;
sub.f64 fd825, fd786, fd801;
sub.f64 fd826, fd785, fd802;
add.f64 fd827, fd786, fd801;
add.f64 fd828, fd789, fd814;
add.f64 fd829, fd790, fd815;
sub.f64 fd830, fd789, fd814;
sub.f64 fd831, fd790, fd815;
add.f64 fd832, fd744, fd752;
add.f64 fd833, fd760, fd768;
sub.f64 fd834, fd744, fd752;
sub.f64 fd835, fd760, fd768;
add.f64 fd836, fd748, fd756;
add.f64 fd837, fd764, fd772;
sub.f64 fd838, fd748, fd756;
sub.f64 fd839, fd764, fd772;
add.f64 fd840, fd832, fd836;
add.f64 fd841, fd833, fd837;
sub.f64 fd842, fd832, fd836;
sub.f64 fd843, fd833, fd837;
add.f64 fd844, fd834, fd839;
sub.f64 fd845, fd835, fd838;
sub.f64 fd846, fd834, fd839;
add.f64 fd847, fd835, fd838;
add.f64 fd848, fd746, fd754;
add.f64 fd849, fd762, fd770;
sub.f64 fd850, fd746, fd754;
sub.f64 fd851, fd762, fd770;
add.f64 fd852, fd750, fd758;
add.f64 fd853, fd766, fd774;
sub.f64 fd854, fd750, fd758;
sub.f64 fd855, fd766, fd774;
add.f64 fd856, fd848, fd852;
add.f64 fd857, fd849, fd853;
sub.f64 fd858, fd848, fd852;
sub.f64 fd859, fd849, fd853;
add.f64 fd860, fd850, fd855;
sub.f64 fd861, fd851, fd854;
sub.f64 fd862, fd850, fd855;
add.f64 fd863, fd851, fd854;
mul.f64 fd864, fd860, 0d3FE6A09E667F3BCD;
mul.f64 fd865, fd861, 0dBFE6A09E667F3BCD;
sub.f64 fd866, fd864, fd865;
mul.f64 fd867, fd861, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd868, fd860, 0dBFE6A09E667F3BCD, fd867;
mul.f64 fd869, fd862, 0dBFE6A09E667F3BCD;
mul.f64 fd870, fd863, 0dBFE6A09E667F3BCD;
sub.f64 fd871, fd869, fd870;
add.f64 fd872, fd869, fd870;
add.f64 fd873, fd840, fd856;
add.f64 fd874, fd841, fd857;
sub.f64 fd875, fd840, fd856;
sub.f64 fd876, fd841, fd857;
add.f64 fd877, fd844, fd866;
add.f64 fd878, fd845, fd868;
sub.f64 fd879, fd844, fd866;
sub.f64 fd880, fd845, fd868;
add.f64 fd881, fd842, fd859;
sub.f64 fd882, fd843, fd858;
sub.f64 fd883, fd842, fd859;
add.f64 fd884, fd843, fd858;
add.f64 fd885, fd846, fd871;
add.f64 fd886, fd847, fd872;
sub.f64 fd887, fd846, fd871;
sub.f64 fd888, fd847, fd872;
mul.f64 fd889, fd877, 0d3FED906BCF328D46;
mul.f64 fd890, fd878, 0dBFD87DE2A6AEA963;
sub.f64 fd891, fd889, fd890;
mul.f64 fd892, fd878, 0d3FED906BCF328D46;
fma.rn.f64 fd893, fd877, 0dBFD87DE2A6AEA963, fd892;
mul.f64 fd894, fd881, 0d3FE6A09E667F3BCD;
mul.f64 fd895, fd882, 0dBFE6A09E667F3BCD;
sub.f64 fd896, fd894, fd895;
mul.f64 fd897, fd882, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd898, fd881, 0dBFE6A09E667F3BCD, fd897;
mul.f64 fd899, fd885, 0d3FD87DE2A6AEA963;
mul.f64 fd900, fd886, 0dBFED906BCF328D46;
sub.f64 fd901, fd899, fd900;
mul.f64 fd902, fd886, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd903, fd885, 0dBFED906BCF328D46, fd902;
mul.f64 fd904, fd879, 0dBFD87DE2A6AEA963;
mul.f64 fd905, fd880, 0dBFED906BCF328D46;
sub.f64 fd906, fd904, fd905;
mul.f64 fd907, fd880, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd908, fd879, 0dBFED906BCF328D46, fd907;
mul.f64 fd909, fd883, 0dBFE6A09E667F3BCD;
mul.f64 fd910, fd884, 0dBFE6A09E667F3BCD;
sub.f64 fd911, fd909, fd910;
add.f64 fd912, fd909, fd910;
mul.f64 fd913, fd887, 0dBFED906BCF328D46;
mul.f64 fd914, fd888, 0dBFD87DE2A6AEA963;
sub.f64 fd915, fd913, fd914;
mul.f64 fd916, fd888, 0dBFED906BCF328D46;
fma.rn.f64 fd917, fd887, 0dBFD87DE2A6AEA963, fd916;
add.f64 fd918, fd816, fd873;
add.f64 fd919, fd817, fd874;
sub.f64 fd920, fd816, fd873;
sub.f64 fd921, fd817, fd874;
add.f64 fd922, fd820, fd891;
add.f64 fd923, fd821, fd893;
sub.f64 fd924, fd820, fd891;
sub.f64 fd925, fd821, fd893;
add.f64 fd926, fd824, fd896;
add.f64 fd927, fd825, fd898;
sub.f64 fd928, fd824, fd896;
sub.f64 fd929, fd825, fd898;
add.f64 fd930, fd828, fd901;
add.f64 fd931, fd829, fd903;
sub.f64 fd932, fd828, fd901;
sub.f64 fd933, fd829, fd903;
add.f64 fd934, fd818, fd876;
sub.f64 fd935, fd819, fd875;
sub.f64 fd936, fd818, fd876;
add.f64 fd937, fd819, fd875;
add.f64 fd938, fd822, fd906;
add.f64 fd939, fd823, fd908;
sub.f64 fd940, fd822, fd906;
sub.f64 fd941, fd823, fd908;
add.f64 fd942, fd826, fd911;
add.f64 fd943, fd827, fd912;
sub.f64 fd944, fd826, fd911;
sub.f64 fd945, fd827, fd912;
add.f64 fd946, fd830, fd915;
add.f64 fd947, fd831, fd917;
sub.f64 fd948, fd830, fd915;
sub.f64 fd949, fd831, fd917;
and.b32 r21, r5, 256;
bfe.u32 r22, r5, 8, 1;
mul.wide.u32 rd9, r22, 16;
mov.u64 rd10, %35;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd950, fd951}, [rd11];
mul.f64 fd954, fd950, fd922;
mul.f64 fd955, fd951, fd923;
sub.f64 fd956, fd954, fd955;
mul.f64 fd957, fd950, fd923;
fma.rn.f64 fd958, fd951, fd922, fd957;
mul.f64 fd959, fd950, fd950;
mul.f64 fd960, fd951, fd951;
sub.f64 fd961, fd959, fd960;
mul.f64 fd962, fd951, fd950;
fma.rn.f64 fd963, fd951, fd950, fd962;
mul.f64 fd964, fd961, fd926;
mul.f64 fd965, fd963, fd927;
sub.f64 fd966, fd964, fd965;
mul.f64 fd967, fd961, fd927;
fma.rn.f64 fd968, fd963, fd926, fd967;
mul.f64 fd969, fd950, fd961;
mul.f64 fd970, fd951, fd963;
sub.f64 fd971, fd969, fd970;
mul.f64 fd972, fd950, fd963;
fma.rn.f64 fd973, fd951, fd961, fd972;
mul.f64 fd974, fd971, fd930;
mul.f64 fd975, fd973, fd931;
sub.f64 fd976, fd974, fd975;
mul.f64 fd977, fd971, fd931;
fma.rn.f64 fd978, fd973, fd930, fd977;
mul.f64 fd979, fd950, fd971;
mul.f64 fd980, fd951, fd973;
sub.f64 fd981, fd979, fd980;
mul.f64 fd982, fd950, fd973;
fma.rn.f64 fd983, fd951, fd971, fd982;
mul.f64 fd984, fd981, fd934;
mul.f64 fd985, fd983, fd935;
sub.f64 fd986, fd984, fd985;
mul.f64 fd987, fd981, fd935;
fma.rn.f64 fd988, fd983, fd934, fd987;
mul.f64 fd989, fd950, fd981;
mul.f64 fd990, fd951, fd983;
sub.f64 fd991, fd989, fd990;
mul.f64 fd992, fd950, fd983;
fma.rn.f64 fd993, fd951, fd981, fd992;
mul.f64 fd994, fd991, fd938;
mul.f64 fd995, fd993, fd939;
sub.f64 fd996, fd994, fd995;
mul.f64 fd997, fd991, fd939;
fma.rn.f64 fd998, fd993, fd938, fd997;
mul.f64 fd999, fd950, fd991;
mul.f64 fd1000, fd951, fd993;
sub.f64 fd1001, fd999, fd1000;
mul.f64 fd1002, fd950, fd993;
fma.rn.f64 fd1003, fd951, fd991, fd1002;
mul.f64 fd1004, fd1001, fd942;
mul.f64 fd1005, fd1003, fd943;
sub.f64 fd1006, fd1004, fd1005;
mul.f64 fd1007, fd1001, fd943;
fma.rn.f64 fd1008, fd1003, fd942, fd1007;
mul.f64 fd1009, fd950, fd1001;
mul.f64 fd1010, fd951, fd1003;
sub.f64 fd1011, fd1009, fd1010;
mul.f64 fd1012, fd950, fd1003;
fma.rn.f64 fd1013, fd951, fd1001, fd1012;
mul.f64 fd1014, fd1011, fd946;
mul.f64 fd1015, fd1013, fd947;
sub.f64 fd1016, fd1014, fd1015;
mul.f64 fd1017, fd1011, fd947;
fma.rn.f64 fd1018, fd1013, fd946, fd1017;
mul.f64 fd1019, fd950, fd1011;
mul.f64 fd1020, fd951, fd1013;
sub.f64 fd1021, fd1019, fd1020;
mul.f64 fd1022, fd950, fd1013;
fma.rn.f64 fd1023, fd951, fd1011, fd1022;
mul.f64 fd1024, fd1021, fd920;
mul.f64 fd1025, fd1023, fd921;
sub.f64 fd1026, fd1024, fd1025;
mul.f64 fd1027, fd1021, fd921;
fma.rn.f64 fd1028, fd1023, fd920, fd1027;
ld.global.v2.f64 {fd1029, fd1030}, [rd11+32];
mul.f64 fd1033, fd1029, fd924;
mul.f64 fd1034, fd1030, fd925;
sub.f64 fd1035, fd1033, fd1034;
mul.f64 fd1036, fd1029, fd925;
fma.rn.f64 fd1037, fd1030, fd924, fd1036;
mul.f64 fd1038, fd950, fd1029;
mul.f64 fd1039, fd951, fd1030;
sub.f64 fd1040, fd1038, fd1039;
mul.f64 fd1041, fd950, fd1030;
fma.rn.f64 fd1042, fd951, fd1029, fd1041;
mul.f64 fd1043, fd1040, fd928;
mul.f64 fd1044, fd1042, fd929;
sub.f64 fd1045, fd1043, fd1044;
mul.f64 fd1046, fd1040, fd929;
fma.rn.f64 fd1047, fd1042, fd928, fd1046;
mul.f64 fd1048, fd950, fd1040;
mul.f64 fd1049, fd951, fd1042;
sub.f64 fd1050, fd1048, fd1049;
mul.f64 fd1051, fd950, fd1042;
fma.rn.f64 fd1052, fd951, fd1040, fd1051;
mul.f64 fd1053, fd1050, fd932;
mul.f64 fd1054, fd1052, fd933;
sub.f64 fd1055, fd1053, fd1054;
mul.f64 fd1056, fd1050, fd933;
fma.rn.f64 fd1057, fd1052, fd932, fd1056;
mul.f64 fd1058, fd950, fd1050;
mul.f64 fd1059, fd951, fd1052;
sub.f64 fd1060, fd1058, fd1059;
mul.f64 fd1061, fd950, fd1052;
fma.rn.f64 fd1062, fd951, fd1050, fd1061;
mul.f64 fd1063, fd1060, fd936;
mul.f64 fd1064, fd1062, fd937;
sub.f64 fd1065, fd1063, fd1064;
mul.f64 fd1066, fd1060, fd937;
fma.rn.f64 fd1067, fd1062, fd936, fd1066;
mul.f64 fd1068, fd950, fd1060;
mul.f64 fd1069, fd951, fd1062;
sub.f64 fd1070, fd1068, fd1069;
mul.f64 fd1071, fd950, fd1062;
fma.rn.f64 fd1072, fd951, fd1060, fd1071;
mul.f64 fd1073, fd1070, fd940;
mul.f64 fd1074, fd1072, fd941;
sub.f64 fd1075, fd1073, fd1074;
mul.f64 fd1076, fd1070, fd941;
fma.rn.f64 fd1077, fd1072, fd940, fd1076;
mul.f64 fd1078, fd950, fd1070;
mul.f64 fd1079, fd951, fd1072;
sub.f64 fd1080, fd1078, fd1079;
mul.f64 fd1081, fd950, fd1072;
fma.rn.f64 fd1082, fd951, fd1070, fd1081;
mul.f64 fd1083, fd1080, fd944;
mul.f64 fd1084, fd1082, fd945;
sub.f64 fd1085, fd1083, fd1084;
mul.f64 fd1086, fd1080, fd945;
fma.rn.f64 fd1087, fd1082, fd944, fd1086;
mul.f64 fd1088, fd950, fd1080;
mul.f64 fd1089, fd951, fd1082;
sub.f64 fd1090, fd1088, fd1089;
mul.f64 fd1091, fd950, fd1082;
fma.rn.f64 fd1092, fd951, fd1080, fd1091;
mul.f64 fd1093, fd1090, fd948;
mul.f64 fd1094, fd1092, fd949;
sub.f64 fd1095, fd1093, fd1094;
mul.f64 fd1096, fd1090, fd949;
fma.rn.f64 fd1097, fd1092, fd948, fd1096;
and.b32 r23, r15, 2040;
add.s32 r24, r10, r23;
barrier.sync 0;
and.b32 r25, r8, 32768;
add.s32 r26, r24, r25;
st.shared.f64 [r26], fd918;
st.shared.f64 [r26+2048], fd956;
st.shared.f64 [r26+4096], fd966;
st.shared.f64 [r26+6144], fd976;
st.shared.f64 [r26+8192], fd986;
st.shared.f64 [r26+10240], fd996;
st.shared.f64 [r26+12288], fd1006;
st.shared.f64 [r26+14336], fd1016;
st.shared.f64 [r26+16384], fd1026;
st.shared.f64 [r26+18432], fd1035;
st.shared.f64 [r26+20480], fd1045;
st.shared.f64 [r26+22528], fd1055;
st.shared.f64 [r26+24576], fd1065;
st.shared.f64 [r26+26624], fd1075;
st.shared.f64 [r26+28672], fd1085;
st.shared.f64 [r26+30720], fd1095;
barrier.sync 0;
mad.lo.s32 r27, r21, -120, r26;
ld.shared.f64 fd1098, [r27];
ld.shared.f64 fd1099, [r27+4096];
ld.shared.f64 fd1100, [r27+8192];
ld.shared.f64 fd1101, [r27+12288];
ld.shared.f64 fd1102, [r27+16384];
ld.shared.f64 fd1103, [r27+20480];
ld.shared.f64 fd1104, [r27+24576];
ld.shared.f64 fd1105, [r27+28672];
ld.shared.f64 fd1106, [r27+32768];
ld.shared.f64 fd1107, [r27+36864];
ld.shared.f64 fd1108, [r27+40960];
ld.shared.f64 fd1109, [r27+45056];
ld.shared.f64 fd1110, [r27+49152];
ld.shared.f64 fd1111, [r27+53248];
ld.shared.f64 fd1112, [r27+57344];
ld.shared.f64 fd1113, [r27+61440];
barrier.sync 0;
st.shared.f64 [r26], fd919;
st.shared.f64 [r26+2048], fd958;
st.shared.f64 [r26+4096], fd968;
st.shared.f64 [r26+6144], fd978;
st.shared.f64 [r26+8192], fd988;
st.shared.f64 [r26+10240], fd998;
st.shared.f64 [r26+12288], fd1008;
st.shared.f64 [r26+14336], fd1018;
st.shared.f64 [r26+16384], fd1028;
st.shared.f64 [r26+18432], fd1037;
st.shared.f64 [r26+20480], fd1047;
st.shared.f64 [r26+22528], fd1057;
st.shared.f64 [r26+24576], fd1067;
st.shared.f64 [r26+26624], fd1077;
st.shared.f64 [r26+28672], fd1087;
st.shared.f64 [r26+30720], fd1097;
barrier.sync 0;
ld.shared.f64 fd1114, [r27];
ld.shared.f64 fd1115, [r27+4096];
ld.shared.f64 fd1116, [r27+8192];
ld.shared.f64 fd1117, [r27+12288];
ld.shared.f64 fd1118, [r27+16384];
ld.shared.f64 fd1119, [r27+20480];
ld.shared.f64 fd1120, [r27+24576];
ld.shared.f64 fd1121, [r27+28672];
ld.shared.f64 fd1122, [r27+32768];
ld.shared.f64 fd1123, [r27+36864];
ld.shared.f64 fd1124, [r27+40960];
ld.shared.f64 fd1125, [r27+45056];
ld.shared.f64 fd1126, [r27+49152];
ld.shared.f64 fd1127, [r27+53248];
ld.shared.f64 fd1128, [r27+57344];
ld.shared.f64 fd1129, [r27+61440];
add.f64 %0, fd1098, fd1106;
add.f64 %1, fd1114, fd1122;
add.f64 %2, fd1099, fd1107;
add.f64 %3, fd1115, fd1123;
add.f64 %4, fd1100, fd1108;
add.f64 %5, fd1116, fd1124;
add.f64 %6, fd1101, fd1109;
add.f64 %7, fd1117, fd1125;
add.f64 %8, fd1102, fd1110;
add.f64 %9, fd1118, fd1126;
add.f64 %10, fd1103, fd1111;
add.f64 %11, fd1119, fd1127;
add.f64 %12, fd1104, fd1112;
add.f64 %13, fd1120, fd1128;
add.f64 %14, fd1105, fd1113;
add.f64 %15, fd1121, fd1129;
sub.f64 %16, fd1098, fd1106;
sub.f64 %17, fd1114, fd1122;
sub.f64 %18, fd1099, fd1107;
sub.f64 %19, fd1115, fd1123;
sub.f64 %20, fd1100, fd1108;
sub.f64 %21, fd1116, fd1124;
sub.f64 %22, fd1101, fd1109;
sub.f64 %23, fd1117, fd1125;
sub.f64 %24, fd1102, fd1110;
sub.f64 %25, fd1118, fd1126;
sub.f64 %26, fd1103, fd1111;
sub.f64 %27, fd1119, fd1127;
sub.f64 %28, fd1104, fd1112;
sub.f64 %29, fd1120, fd1128;
sub.f64 %30, fd1105, fd1113;
sub.f64 %31, fd1121, fd1129;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_8192), "l"(lut_dp_16_512), "l"(lut_dp_16_32), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<1163, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<35>;
.reg .f64 fd<677>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 17;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %21, %31;
add.f64 fd34, %22, %33;
sub.f64 fd35, %21, %31;
sub.f64 fd36, %22, %33;
add.f64 fd37, %26, %37;
add.f64 fd38, %28, %38;
sub.f64 fd39, %26, %37;
sub.f64 fd40, %28, %38;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
add.f64 fd45, fd35, fd40;
sub.f64 fd46, fd36, fd39;
sub.f64 fd47, fd35, fd40;
add.f64 fd48, fd36, fd39;
add.f64 fd49, %23, %34;
add.f64 fd50, %25, %36;
sub.f64 fd51, %23, %34;
sub.f64 fd52, %25, %36;
add.f64 fd53, %29, %39;
add.f64 fd54, %30, %40;
sub.f64 fd55, %29, %39;
sub.f64 fd56, %30, %40;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
add.f64 fd61, fd51, fd56;
sub.f64 fd62, fd52, fd55;
sub.f64 fd63, fd51, fd56;
add.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0dBFE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
mul.f64 fd68, fd62, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd69, fd61, 0dBFE6A09E667F3BCD, fd68;
mul.f64 fd70, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd71, fd64, 0dBFE6A09E667F3BCD;
sub.f64 fd72, fd70, fd71;
add.f64 fd73, fd70, fd71;
sub.f64 fd74, fd41, fd57;
sub.f64 fd75, fd42, fd58;
add.f64 fd76, fd45, fd67;
add.f64 fd77, fd46, fd69;
sub.f64 fd78, fd45, fd67;
sub.f64 fd79, fd46, fd69;
add.f64 fd80, fd43, fd60;
sub.f64 fd81, fd44, fd59;
sub.f64 fd82, fd43, fd60;
add.f64 fd83, fd44, fd59;
add.f64 fd84, fd47, fd72;
add.f64 fd85, fd48, fd73;
sub.f64 fd86, fd47, fd72;
sub.f64 fd87, fd48, fd73;
and.b32 r6, r5, 1023;
shl.b32 r7, r5, 7;
and.b32 r8, r7, -131072;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 16368;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd88, fd89}, [rd5];
mul.f64 fd92, fd88, fd76;
mul.f64 fd93, fd89, fd77;
mul.f64 fd94, fd88, fd77;
mul.f64 fd95, fd88, fd88;
mul.f64 fd96, fd89, fd89;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd89, fd88;
fma.rn.f64 fd99, fd89, fd88, fd98;
mul.f64 fd100, fd97, fd80;
mul.f64 fd101, fd99, fd81;
mul.f64 fd102, fd97, fd81;
mul.f64 fd103, fd88, fd97;
mul.f64 fd104, fd89, fd99;
sub.f64 fd105, fd103, fd104;
mul.f64 fd106, fd88, fd99;
fma.rn.f64 fd107, fd89, fd97, fd106;
mul.f64 fd108, fd105, fd84;
mul.f64 fd109, fd107, fd85;
mul.f64 fd110, fd105, fd85;
mul.f64 fd111, fd88, fd105;
mul.f64 fd112, fd89, fd107;
sub.f64 fd113, fd111, fd112;
mul.f64 fd114, fd88, fd107;
fma.rn.f64 fd115, fd89, fd105, fd114;
mul.f64 fd116, fd113, fd74;
mul.f64 fd117, fd115, fd75;
mul.f64 fd118, fd113, fd75;
ld.global.v2.f64 {fd119, fd120}, [rd5+16384];
mul.f64 fd123, fd119, fd78;
mul.f64 fd124, fd120, fd79;
mul.f64 fd125, fd119, fd79;
mul.f64 fd126, fd88, fd119;
mul.f64 fd127, fd89, fd120;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd88, fd120;
fma.rn.f64 fd130, fd89, fd119, fd129;
mul.f64 fd131, fd128, fd82;
mul.f64 fd132, fd130, fd83;
mul.f64 fd133, fd128, fd83;
mul.f64 fd134, fd88, fd128;
mul.f64 fd135, fd89, fd130;
sub.f64 fd136, fd134, fd135;
mul.f64 fd137, fd88, fd130;
fma.rn.f64 fd138, fd89, fd128, fd137;
mul.f64 fd139, fd136, fd86;
mul.f64 fd140, fd138, fd87;
mul.f64 fd141, fd136, fd87;
barrier.sync 0;
and.b32 r11, r7, 130944;
add.s32 r12, r9, r11;
add.f64 fd142, fd42, fd58;
add.f64 fd143, fd41, fd57;
st.shared.v2.f64 [r12], {fd143, fd142};
fma.rn.f64 fd144, fd89, fd76, fd94;
sub.f64 fd145, fd92, fd93;
st.shared.v2.f64 [r12+16], {fd145, fd144};
fma.rn.f64 fd146, fd99, fd80, fd102;
sub.f64 fd147, fd100, fd101;
st.shared.v2.f64 [r12+32], {fd147, fd146};
sub.f64 fd148, fd108, fd109;
fma.rn.f64 fd149, fd107, fd84, fd110;
st.shared.v2.f64 [r12+48], {fd148, fd149};
fma.rn.f64 fd150, fd115, fd74, fd118;
sub.f64 fd151, fd116, fd117;
st.shared.v2.f64 [r12+64], {fd151, fd150};
fma.rn.f64 fd152, fd120, fd78, fd125;
sub.f64 fd153, fd123, fd124;
st.shared.v2.f64 [r12+80], {fd153, fd152};
fma.rn.f64 fd154, fd130, fd82, fd133;
sub.f64 fd155, fd131, fd132;
st.shared.v2.f64 [r12+96], {fd155, fd154};
sub.f64 fd156, fd139, fd140;
fma.rn.f64 fd157, fd138, fd86, fd141;
st.shared.v2.f64 [r12+112], {fd156, fd157};
barrier.sync 0;
mad.lo.s32 r13, r6, -112, r12;
ld.shared.v2.f64 {fd158, fd159}, [r13];
ld.shared.v2.f64 {fd162, fd163}, [r13+16384];
ld.shared.v2.f64 {fd166, fd167}, [r13+32768];
ld.shared.v2.f64 {fd170, fd171}, [r13+49152];
ld.shared.v2.f64 {fd174, fd175}, [r13+65536];
ld.shared.v2.f64 {fd178, fd179}, [r13+81920];
ld.shared.v2.f64 {fd182, fd183}, [r13+98304];
ld.shared.v2.f64 {fd186, fd187}, [r13+114688];
add.f64 fd190, fd158, fd174;
add.f64 fd191, fd159, fd175;
sub.f64 fd192, fd158, fd174;
sub.f64 fd193, fd159, fd175;
add.f64 fd194, fd166, fd182;
add.f64 fd195, fd167, fd183;
sub.f64 fd196, fd166, fd182;
sub.f64 fd197, fd167, fd183;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
add.f64 fd202, fd192, fd197;
sub.f64 fd203, fd193, fd196;
sub.f64 fd204, fd192, fd197;
add.f64 fd205, fd193, fd196;
add.f64 fd206, fd162, fd178;
add.f64 fd207, fd163, fd179;
sub.f64 fd208, fd162, fd178;
sub.f64 fd209, fd163, fd179;
add.f64 fd210, fd170, fd186;
add.f64 fd211, fd171, fd187;
sub.f64 fd212, fd170, fd186;
sub.f64 fd213, fd171, fd187;
add.f64 fd214, fd206, fd210;
add.f64 fd215, fd207, fd211;
sub.f64 fd216, fd206, fd210;
sub.f64 fd217, fd207, fd211;
add.f64 fd218, fd208, fd213;
sub.f64 fd219, fd209, fd212;
sub.f64 fd220, fd208, fd213;
add.f64 fd221, fd209, fd212;
mul.f64 fd222, fd218, 0d3FE6A09E667F3BCD;
mul.f64 fd223, fd219, 0dBFE6A09E667F3BCD;
sub.f64 fd224, fd222, fd223;
mul.f64 fd225, fd219, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd226, fd218, 0dBFE6A09E667F3BCD, fd225;
mul.f64 fd227, fd220, 0dBFE6A09E667F3BCD;
mul.f64 fd228, fd221, 0dBFE6A09E667F3BCD;
sub.f64 fd229, fd227, fd228;
add.f64 fd230, fd227, fd228;
sub.f64 fd231, fd198, fd214;
sub.f64 fd232, fd199, fd215;
add.f64 fd233, fd202, fd224;
add.f64 fd234, fd203, fd226;
sub.f64 fd235, fd202, fd224;
sub.f64 fd236, fd203, fd226;
add.f64 fd237, fd200, fd217;
sub.f64 fd238, fd201, fd216;
sub.f64 fd239, fd200, fd217;
add.f64 fd240, fd201, fd216;
add.f64 fd241, fd204, fd229;
add.f64 fd242, fd205, fd230;
sub.f64 fd243, fd204, fd229;
sub.f64 fd244, fd205, fd230;
and.b32 r14, r5, 1016;
bfe.u32 r15, r5, 3, 7;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd245, fd246}, [rd8];
mul.f64 fd249, fd245, fd233;
mul.f64 fd250, fd246, fd234;
mul.f64 fd251, fd245, fd234;
mul.f64 fd252, fd245, fd245;
mul.f64 fd253, fd246, fd246;
sub.f64 fd254, fd252, fd253;
mul.f64 fd255, fd246, fd245;
fma.rn.f64 fd256, fd246, fd245, fd255;
mul.f64 fd257, fd254, fd237;
mul.f64 fd258, fd256, fd238;
mul.f64 fd259, fd254, fd238;
mul.f64 fd260, fd245, fd254;
mul.f64 fd261, fd246, fd256;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd245, fd256;
fma.rn.f64 fd264, fd246, fd254, fd263;
mul.f64 fd265, fd262, fd241;
mul.f64 fd266, fd264, fd242;
mul.f64 fd267, fd262, fd242;
mul.f64 fd268, fd245, fd262;
mul.f64 fd269, fd246, fd264;
sub.f64 fd270, fd268, fd269;
mul.f64 fd271, fd245, fd264;
fma.rn.f64 fd272, fd246, fd262, fd271;
mul.f64 fd273, fd270, fd231;
mul.f64 fd274, fd272, fd232;
mul.f64 fd275, fd270, fd232;
ld.global.v2.f64 {fd276, fd277}, [rd8+2048];
mul.f64 fd280, fd276, fd235;
mul.f64 fd281, fd277, fd236;
mul.f64 fd282, fd276, fd236;
mul.f64 fd283, fd245, fd276;
mul.f64 fd284, fd246, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd245, fd277;
fma.rn.f64 fd287, fd246, fd276, fd286;
mul.f64 fd288, fd285, fd239;
mul.f64 fd289, fd287, fd240;
mul.f64 fd290, fd285, fd240;
mul.f64 fd291, fd245, fd285;
mul.f64 fd292, fd246, fd287;
sub.f64 fd293, fd291, fd292;
mul.f64 fd294, fd245, fd287;
fma.rn.f64 fd295, fd246, fd285, fd294;
mul.f64 fd296, fd293, fd243;
mul.f64 fd297, fd295, fd244;
mul.f64 fd298, fd293, fd244;
and.b32 r16, r10, 112;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 130048;
add.s32 r19, r17, r18;
add.f64 fd299, fd199, fd215;
add.f64 fd300, fd198, fd214;
st.shared.v2.f64 [r19], {fd300, fd299};
fma.rn.f64 fd301, fd246, fd233, fd251;
sub.f64 fd302, fd249, fd250;
st.shared.v2.f64 [r19+128], {fd302, fd301};
fma.rn.f64 fd303, fd256, fd237, fd259;
sub.f64 fd304, fd257, fd258;
st.shared.v2.f64 [r19+256], {fd304, fd303};
fma.rn.f64 fd305, fd264, fd241, fd267;
sub.f64 fd306, fd265, fd266;
st.shared.v2.f64 [r19+384], {fd306, fd305};
sub.f64 fd307, fd273, fd274;
fma.rn.f64 fd308, fd272, fd231, fd275;
st.shared.v2.f64 [r19+512], {fd307, fd308};
fma.rn.f64 fd309, fd277, fd235, fd282;
sub.f64 fd310, fd280, fd281;
st.shared.v2.f64 [r19+640], {fd310, fd309};
fma.rn.f64 fd311, fd287, fd239, fd290;
sub.f64 fd312, fd288, fd289;
st.shared.v2.f64 [r19+768], {fd312, fd311};
fma.rn.f64 fd313, fd295, fd243, fd298;
sub.f64 fd314, fd296, fd297;
st.shared.v2.f64 [r19+896], {fd314, fd313};
barrier.sync 0;
mad.lo.s32 r20, r14, -112, r19;
ld.shared.v2.f64 {fd315, fd316}, [r20];
ld.shared.v2.f64 {fd319, fd320}, [r20+16384];
ld.shared.v2.f64 {fd323, fd324}, [r20+32768];
ld.shared.v2.f64 {fd327, fd328}, [r20+49152];
ld.shared.v2.f64 {fd331, fd332}, [r20+65536];
ld.shared.v2.f64 {fd335, fd336}, [r20+81920];
ld.shared.v2.f64 {fd339, fd340}, [r20+98304];
ld.shared.v2.f64 {fd343, fd344}, [r20+114688];
add.f64 fd347, fd315, fd331;
add.f64 fd348, fd316, fd332;
sub.f64 fd349, fd315, fd331;
sub.f64 fd350, fd316, fd332;
add.f64 fd351, fd323, fd339;
add.f64 fd352, fd324, fd340;
sub.f64 fd353, fd323, fd339;
sub.f64 fd354, fd324, fd340;
add.f64 fd355, fd347, fd351;
add.f64 fd356, fd348, fd352;
sub.f64 fd357, fd347, fd351;
sub.f64 fd358, fd348, fd352;
add.f64 fd359, fd349, fd354;
sub.f64 fd360, fd350, fd353;
sub.f64 fd361, fd349, fd354;
add.f64 fd362, fd350, fd353;
add.f64 fd363, fd319, fd335;
add.f64 fd364, fd320, fd336;
sub.f64 fd365, fd319, fd335;
sub.f64 fd366, fd320, fd336;
add.f64 fd367, fd327, fd343;
add.f64 fd368, fd328, fd344;
sub.f64 fd369, fd327, fd343;
sub.f64 fd370, fd328, fd344;
add.f64 fd371, fd363, fd367;
add.f64 fd372, fd364, fd368;
sub.f64 fd373, fd363, fd367;
sub.f64 fd374, fd364, fd368;
add.f64 fd375, fd365, fd370;
sub.f64 fd376, fd366, fd369;
sub.f64 fd377, fd365, fd370;
add.f64 fd378, fd366, fd369;
mul.f64 fd379, fd375, 0d3FE6A09E667F3BCD;
mul.f64 fd380, fd376, 0dBFE6A09E667F3BCD;
sub.f64 fd381, fd379, fd380;
mul.f64 fd382, fd376, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd383, fd375, 0dBFE6A09E667F3BCD, fd382;
mul.f64 fd384, fd377, 0dBFE6A09E667F3BCD;
mul.f64 fd385, fd378, 0dBFE6A09E667F3BCD;
sub.f64 fd386, fd384, fd385;
add.f64 fd387, fd384, fd385;
sub.f64 fd388, fd355, fd371;
sub.f64 fd389, fd356, fd372;
add.f64 fd390, fd359, fd381;
add.f64 fd391, fd360, fd383;
sub.f64 fd392, fd359, fd381;
sub.f64 fd393, fd360, fd383;
add.f64 fd394, fd357, fd374;
sub.f64 fd395, fd358, fd373;
sub.f64 fd396, fd357, fd374;
add.f64 fd397, fd358, fd373;
add.f64 fd398, fd361, fd386;
add.f64 fd399, fd362, fd387;
sub.f64 fd400, fd361, fd386;
sub.f64 fd401, fd362, fd387;
and.b32 r21, r5, 960;
bfe.u32 r22, r5, 6, 4;
mul.wide.u32 rd9, r22, 16;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd402, fd403}, [rd11];
mul.f64 fd406, fd402, fd390;
mul.f64 fd407, fd403, fd391;
mul.f64 fd408, fd402, fd391;
mul.f64 fd409, fd402, fd402;
mul.f64 fd410, fd403, fd403;
sub.f64 fd411, fd409, fd410;
mul.f64 fd412, fd403, fd402;
fma.rn.f64 fd413, fd403, fd402, fd412;
mul.f64 fd414, fd411, fd394;
mul.f64 fd415, fd413, fd395;
mul.f64 fd416, fd411, fd395;
mul.f64 fd417, fd402, fd411;
mul.f64 fd418, fd403, fd413;
sub.f64 fd419, fd417, fd418;
mul.f64 fd420, fd402, fd413;
fma.rn.f64 fd421, fd403, fd411, fd420;
mul.f64 fd422, fd419, fd398;
mul.f64 fd423, fd421, fd399;
mul.f64 fd424, fd419, fd399;
mul.f64 fd425, fd402, fd419;
mul.f64 fd426, fd403, fd421;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd402, fd421;
fma.rn.f64 fd429, fd403, fd419, fd428;
mul.f64 fd430, fd427, fd388;
mul.f64 fd431, fd429, fd389;
mul.f64 fd432, fd427, fd389;
ld.global.v2.f64 {fd433, fd434}, [rd11+256];
mul.f64 fd437, fd433, fd392;
mul.f64 fd438, fd434, fd393;
mul.f64 fd439, fd433, fd393;
mul.f64 fd440, fd402, fd433;
mul.f64 fd441, fd403, fd434;
sub.f64 fd442, fd440, fd441;
mul.f64 fd443, fd402, fd434;
fma.rn.f64 fd444, fd403, fd433, fd443;
mul.f64 fd445, fd442, fd396;
mul.f64 fd446, fd444, fd397;
mul.f64 fd447, fd442, fd397;
mul.f64 fd448, fd402, fd442;
mul.f64 fd449, fd403, fd444;
sub.f64 fd450, fd448, fd449;
mul.f64 fd451, fd402, fd444;
fma.rn.f64 fd452, fd403, fd442, fd451;
mul.f64 fd453, fd450, fd400;
mul.f64 fd454, fd452, fd401;
mul.f64 fd455, fd450, fd401;
and.b32 r23, r10, 1008;
add.s32 r24, r9, r23;
barrier.sync 0;
and.b32 r25, r7, 122880;
add.s32 r26, r24, r25;
add.f64 fd456, fd356, fd372;
add.f64 fd457, fd355, fd371;
st.shared.v2.f64 [r26], {fd457, fd456};
fma.rn.f64 fd458, fd403, fd390, fd408;
sub.f64 fd459, fd406, fd407;
st.shared.v2.f64 [r26+1024], {fd459, fd458};
fma.rn.f64 fd460, fd413, fd394, fd416;
sub.f64 fd461, fd414, fd415;
st.shared.v2.f64 [r26+2048], {fd461, fd460};
fma.rn.f64 fd462, fd421, fd398, fd424;
sub.f64 fd463, fd422, fd423;
st.shared.v2.f64 [r26+3072], {fd463, fd462};
sub.f64 fd464, fd430, fd431;
fma.rn.f64 fd465, fd429, fd388, fd432;
st.shared.v2.f64 [r26+4096], {fd464, fd465};
fma.rn.f64 fd466, fd434, fd392, fd439;
sub.f64 fd467, fd437, fd438;
st.shared.v2.f64 [r26+5120], {fd467, fd466};
fma.rn.f64 fd468, fd444, fd396, fd447;
sub.f64 fd469, fd445, fd446;
st.shared.v2.f64 [r26+6144], {fd469, fd468};
fma.rn.f64 fd470, fd452, fd400, fd455;
sub.f64 fd471, fd453, fd454;
st.shared.v2.f64 [r26+7168], {fd471, fd470};
barrier.sync 0;
mad.lo.s32 r27, r21, -112, r26;
ld.shared.v2.f64 {fd472, fd473}, [r27];
ld.shared.v2.f64 {fd476, fd477}, [r27+16384];
ld.shared.v2.f64 {fd480, fd481}, [r27+32768];
ld.shared.v2.f64 {fd484, fd485}, [r27+49152];
ld.shared.v2.f64 {fd488, fd489}, [r27+65536];
ld.shared.v2.f64 {fd492, fd493}, [r27+81920];
ld.shared.v2.f64 {fd496, fd497}, [r27+98304];
ld.shared.v2.f64 {fd500, fd501}, [r27+114688];
add.f64 fd504, fd472, fd488;
add.f64 fd505, fd473, fd489;
sub.f64 fd506, fd472, fd488;
sub.f64 fd507, fd473, fd489;
add.f64 fd508, fd480, fd496;
add.f64 fd509, fd481, fd497;
sub.f64 fd510, fd480, fd496;
sub.f64 fd511, fd481, fd497;
add.f64 fd512, fd504, fd508;
add.f64 fd513, fd505, fd509;
sub.f64 fd514, fd504, fd508;
sub.f64 fd515, fd505, fd509;
add.f64 fd516, fd506, fd511;
sub.f64 fd517, fd507, fd510;
sub.f64 fd518, fd506, fd511;
add.f64 fd519, fd507, fd510;
add.f64 fd520, fd476, fd492;
add.f64 fd521, fd477, fd493;
sub.f64 fd522, fd476, fd492;
sub.f64 fd523, fd477, fd493;
add.f64 fd524, fd484, fd500;
add.f64 fd525, fd485, fd501;
sub.f64 fd526, fd484, fd500;
sub.f64 fd527, fd485, fd501;
add.f64 fd528, fd520, fd524;
add.f64 fd529, fd521, fd525;
sub.f64 fd530, fd520, fd524;
sub.f64 fd531, fd521, fd525;
add.f64 fd532, fd522, fd527;
sub.f64 fd533, fd523, fd526;
sub.f64 fd534, fd522, fd527;
add.f64 fd535, fd523, fd526;
mul.f64 fd536, fd532, 0d3FE6A09E667F3BCD;
mul.f64 fd537, fd533, 0dBFE6A09E667F3BCD;
sub.f64 fd538, fd536, fd537;
mul.f64 fd539, fd533, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd540, fd532, 0dBFE6A09E667F3BCD, fd539;
mul.f64 fd541, fd534, 0dBFE6A09E667F3BCD;
mul.f64 fd542, fd535, 0dBFE6A09E667F3BCD;
sub.f64 fd543, fd541, fd542;
add.f64 fd544, fd541, fd542;
sub.f64 fd545, fd512, fd528;
sub.f64 fd546, fd513, fd529;
add.f64 fd547, fd516, fd538;
add.f64 fd548, fd517, fd540;
sub.f64 fd549, fd516, fd538;
sub.f64 fd550, fd517, fd540;
add.f64 fd551, fd514, fd531;
sub.f64 fd552, fd515, fd530;
sub.f64 fd553, fd514, fd531;
add.f64 fd554, fd515, fd530;
add.f64 fd555, fd518, fd543;
add.f64 fd556, fd519, fd544;
sub.f64 fd557, fd518, fd543;
sub.f64 fd558, fd519, fd544;
and.b32 r28, r5, 512;
bfe.u32 r29, r5, 9, 1;
mul.wide.u32 rd12, r29, 16;
mov.u64 rd13, %20;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd559, fd560}, [rd14];
mul.f64 fd563, fd559, fd547;
mul.f64 fd564, fd560, fd548;
mul.f64 fd565, fd559, fd548;
mul.f64 fd566, fd559, fd559;
mul.f64 fd567, fd560, fd560;
sub.f64 fd568, fd566, fd567;
mul.f64 fd569, fd560, fd559;
fma.rn.f64 fd570, fd560, fd559, fd569;
mul.f64 fd571, fd568, fd551;
mul.f64 fd572, fd570, fd552;
mul.f64 fd573, fd568, fd552;
mul.f64 fd574, fd559, fd568;
mul.f64 fd575, fd560, fd570;
sub.f64 fd576, fd574, fd575;
mul.f64 fd577, fd559, fd570;
fma.rn.f64 fd578, fd560, fd568, fd577;
mul.f64 fd579, fd576, fd555;
mul.f64 fd580, fd578, fd556;
mul.f64 fd581, fd576, fd556;
mul.f64 fd582, fd559, fd576;
mul.f64 fd583, fd560, fd578;
sub.f64 fd584, fd582, fd583;
mul.f64 fd585, fd559, fd578;
fma.rn.f64 fd586, fd560, fd576, fd585;
mul.f64 fd587, fd584, fd545;
mul.f64 fd588, fd586, fd546;
mul.f64 fd589, fd584, fd546;
ld.global.v2.f64 {fd590, fd591}, [rd14+32];
mul.f64 fd594, fd590, fd549;
mul.f64 fd595, fd591, fd550;
mul.f64 fd596, fd590, fd550;
mul.f64 fd597, fd559, fd590;
mul.f64 fd598, fd560, fd591;
sub.f64 fd599, fd597, fd598;
mul.f64 fd600, fd559, fd591;
fma.rn.f64 fd601, fd560, fd590, fd600;
mul.f64 fd602, fd599, fd553;
mul.f64 fd603, fd601, fd554;
mul.f64 fd604, fd599, fd554;
mul.f64 fd605, fd559, fd599;
mul.f64 fd606, fd560, fd601;
sub.f64 fd607, fd605, fd606;
mul.f64 fd608, fd559, fd601;
fma.rn.f64 fd609, fd560, fd599, fd608;
mul.f64 fd610, fd607, fd557;
mul.f64 fd611, fd609, fd558;
mul.f64 fd612, fd607, fd558;
and.b32 r30, r10, 8176;
add.s32 r31, r9, r30;
barrier.sync 0;
and.b32 r32, r7, 65536;
add.s32 r33, r31, r32;
add.f64 fd613, fd513, fd529;
add.f64 fd614, fd512, fd528;
st.shared.v2.f64 [r33], {fd614, fd613};
fma.rn.f64 fd615, fd560, fd547, fd565;
sub.f64 fd616, fd563, fd564;
st.shared.v2.f64 [r33+8192], {fd616, fd615};
fma.rn.f64 fd617, fd570, fd551, fd573;
sub.f64 fd618, fd571, fd572;
st.shared.v2.f64 [r33+16384], {fd618, fd617};
fma.rn.f64 fd619, fd578, fd555, fd581;
sub.f64 fd620, fd579, fd580;
st.shared.v2.f64 [r33+24576], {fd620, fd619};
sub.f64 fd621, fd587, fd588;
fma.rn.f64 fd622, fd586, fd545, fd589;
st.shared.v2.f64 [r33+32768], {fd621, fd622};
fma.rn.f64 fd623, fd591, fd549, fd596;
sub.f64 fd624, fd594, fd595;
st.shared.v2.f64 [r33+40960], {fd624, fd623};
fma.rn.f64 fd625, fd601, fd553, fd604;
sub.f64 fd626, fd602, fd603;
st.shared.v2.f64 [r33+49152], {fd626, fd625};
fma.rn.f64 fd627, fd609, fd557, fd612;
sub.f64 fd628, fd610, fd611;
st.shared.v2.f64 [r33+57344], {fd628, fd627};
barrier.sync 0;
mad.lo.s32 r34, r28, -112, r33;
ld.shared.v2.f64 {fd629, fd630}, [r34];
ld.shared.v2.f64 {fd633, fd634}, [r34+16384];
ld.shared.v2.f64 {fd637, fd638}, [r34+32768];
ld.shared.v2.f64 {fd641, fd642}, [r34+49152];
ld.shared.v2.f64 {fd645, fd646}, [r34+65536];
ld.shared.v2.f64 {fd649, fd650}, [r34+81920];
ld.shared.v2.f64 {fd653, fd654}, [r34+98304];
ld.shared.v2.f64 {fd657, fd658}, [r34+114688];
add.f64 %1, fd630, fd646;
add.f64 %0, fd629, fd645;
add.f64 %3, fd634, fd650;
add.f64 %2, fd633, fd649;
add.f64 %5, fd638, fd654;
add.f64 %4, fd637, fd653;
add.f64 %7, fd642, fd658;
add.f64 %6, fd641, fd657;
sub.f64 %9, fd630, fd646;
sub.f64 %8, fd629, fd645;
sub.f64 %11, fd634, fd650;
sub.f64 %10, fd633, fd649;
sub.f64 %13, fd638, fd654;
sub.f64 %12, fd637, fd653;
sub.f64 %15, fd642, fd658;
sub.f64 %14, fd641, fd657;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_8192), "l"(lut_dp_8_1024), "l"(lut_dp_8_128), "l"(lut_dp_8_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};


#endif
