import os
from pathlib import Path


# --- General Paths ---
# Replace with your own paths
BASE_DIR = Path(__file__).parent
KEYS_ENV_PATH = BASE_DIR / "keys.env"
DATABASE_DIR = "YOUR_DATABASE_DIR"

# --- File Paths ---
# Replace with your own data paths
FAISS_INDEX_PATH = DATABASE_DIR + "YOUR_FAISS_INDEX_PATH"
CHUNKS_JSON_PATH = DATABASE_DIR + "YOUR_CHUNKS_JSON_PATH"

# --- Model Names ---
PLANNER_MODEL_NAME = "qwen3-30b-a3b"
GEMINI_STYLE_MODEL_NAME = "gemini-2.5-pro"
CLAUDE_STYLE_MODEL_NAME = "claude-3-7-sonnet-20250219"

# --- Retriever Hyperparameters ---
HYBRID_ALPHA = 0.6  # Weight for vector search
HYBRID_BETA = 0.4   # Weight for BM25
RETRIEVER_K_PQA = 5
RETRIEVER_K_DEFAULT = 3

# --- Task-specific Configurations ---
TASK_CONFIG = {
    "PQA": {
        "retriever_k": RETRIEVER_K_PQA,
        "llm": GEMINI_STYLE_MODEL_NAME,
        "requires_retrieval": True,
    },
    "ORD": {
        "retriever_k": RETRIEVER_K_DEFAULT,
        "llm": GEMINI_STYLE_MODEL_NAME,
        "requires_retrieval": True,
    },
    "ERR": {
        "retriever_k": RETRIEVER_K_DEFAULT,
        "llm": GEMINI_STYLE_MODEL_NAME,
        "requires_retrieval": True,
    },
    "REA-ERR": {
        "retriever_k": 5,
        "llm": GEMINI_STYLE_MODEL_NAME,
        "requires_retrieval": True,
    },
    "GEN": {
        "retriever_k": RETRIEVER_K_DEFAULT,
        "llm": CLAUDE_STYLE_MODEL_NAME,
        "requires_retrieval": True,
    },
    "REA-GEN": {
        "llm": CLAUDE_STYLE_MODEL_NAME,
        "requires_retrieval": False,
    }
    ,
    "LABQA": {
        "retriever_k": RETRIEVER_K_PQA,
        "llm": GEMINI_STYLE_MODEL_NAME,
        "requires_retrieval": True,
    }
}