# Reproducing MAML


Sine and Omniglot experiments of Model-Agnostic Meta-Learning (MAML) in JAX.

## Installation
In order to run this code you need a Python installation with version at least 3.9.
You can then install the requirements using the following command:

```
pip install .
```

## Reproducing Fig. 3 of the paper
In order to reproduce Fig. 3 of the paper, you need to first train the models, using the command:
```
python maml/meta_train.py
```

Add the flag `--config-name=implicit` to run the iMAML version.

You can then evaluate the models using the following command:
```
python maml/evaluate.py -m eval.model.maxiter=1,2,5,10,50,100,500,1000,10000,30000,100000,500000,1000000,5000000,10000000
```

Add the flag `--config-name=implicit` to run the iMAML version.

The figure can then be generated using the [`results_n_iter.ipynb`](common_experiments/results_n_iter.ipynb) notebook.

## Reproducing Fig. 4 of the paper
In order to reproduce Fig. 3 of the paper, you need to first train the models, using the command:
```
python maml/meta_train.py -m --config-name=overfit +experiment=maml_overfit_sinus_train
```

Use the flag `--config-name=implicit_overfit` to run the iMAML version.

You can then evaluate the models using the following command:
```
python maml/evaluate.py -m --config-name=overfit +experiment=maml_overfit_sinus_eval
```

Add the flag `--config-name=implicit_overfit` to run the iMAML version.

The figure can then be generated using the [`overfit.ipynb`](common_experiments/overfit.ipynb) notebook.

## Omniglot Data
Download the background and evaluation zip files from [the original repo](https://github.com/brendenlake/omniglot/tree/master/python).
Then do the following:
```
mkdir omniglot
mv ~/Downloads/images_background.zip ~/Downloads/images_evaluation.zip omniglot
cd omniglot
unzip images_background.zip
unzip images_evaluation.zip
mkdir all_images
mv images_background/* images_evaluation/* all_images
cd ../
mkdir omniglot_resized
cp -r omniglot/all_images omniglot_resized/
python resize_images.py
```
