# taken from https://github.com/cbfinn/maml/blob/master/data/omniglot_resized/resize_images.py
import argparse
from pathlib import Path

from PIL import Image


parser = argparse.ArgumentParser()
parser.add_argument('--image_dir', type=str, default='omniglot_resized/')
parser.add_argument('--image_size', type=int, default=28)
args = parser.parse_args()
image_path = Path(args.image_dir)
im_size = args.image_size

all_images = image_path.glob('**/*.png')

i = 0

for image_file in all_images:
    im = Image.open(image_file).convert("L")
    im = im.resize((im_size, im_size), resample=Image.LANCZOS)
    im.save(image_file)
    i += 1

    if i % 200 == 0:
        print(i)
