# Implicit Differentiation in Practice

## Requirements
In order to run this code you need a Python installation with version at least 3.9.
You can then install the requirements using the following command:

```
pip install .
```

## Reproducing Fig. 1 (a) of the paper
In order to reproduce the left hand side of Fig. 1 of the paper, you should use the notebook [`full_loss_above.ipynb`](common_experiments/full_loss_above.ipynb).

## Reproducing Fig. 1 (b) of the paper
In order to reproduce the right hand side of Fig. 1 of the paper, you can run the following command to generate the data:

```
python id_in_practice/theory_biquadratic.py -m --config-name=strongly_convex_large.yaml data.dimension_theta="range(1,20)" seed="range(0,20)"
```

Then the figure can be generated using the notebook [`lower_bound.ipynb`](common_experiments/lower_bound.ipynb).

Similarly to reproduce Fig. 8 of the paper, you can generate the data with:

```
python id_in_practice/theory_biquadratic.py -m data.dimension_x=10 data.dimension_latent_inner=8 data.dimension_latent_outer=8 data.dimension_theta="range(1,10)" seed="range(0,20)""
```
