import math
from ..utils.distance_api import *
from ..utils.actions_api import *
from ..utils.units_api import *

from ..unit_typeid import UnitTypeId

class DecisionTreeScript():

    def __init__(self, map_name):
        self.map_name = map_name

        
    def script(self, agents, enemies, agent_ability, visible_matrix, iteration):

        agents = [agent for _, agent in agents.items() if agent.health != 0]
        enemies = [enemy for _, enemy in enemies.items() if enemy.health != 0]

        if not agents or not enemies:
            return

        self.zealots = sorted([a for a in agents if a.unit_type==UnitTypeId.ZEALOT.value], key=lambda a: a.tag)
        
        self.enemy_marines = sorted([a for a in enemies if a.unit_type==UnitTypeId.MARINE.value], key=lambda a: a.tag)


        actions_list = []
        zealot = self.zealots[0]

        if not self.enemy_marines:
            return []

        if len(self.enemy_marines) == 1:
            target_enemy = self.enemy_marines[0]
        else:
            if self.enemy_marines[0].health == self.enemy_marines[1].health:
                target_enemy = nearest_n_units(zealot, self.enemy_marines, 1)[0]
            else:
                target_enemy = self.enemy_marines[0] if self.enemy_marines[0].health < self.enemy_marines[1].health else self.enemy_marines[1]
        actions_list.append(attack(zealot, target_enemy, visible_matrix))
        return actions_list
