import math
from ..utils.distance_api import *
from ..utils.actions_api import *
from ..utils.units_api import *

from ..unit_typeid import UnitTypeId

class DecisionTreeScript():

    def __init__(self, map_name):
        self.map_name = map_name
        
        self.attack_range = 8.7
        
    def script(self, agents, enemies, agent_ability, visible_matrix, iteration):

        agents = [agent for _, agent in agents.items() if agent.health != 0]
        enemies = [enemy for _, enemy in enemies.items() if enemy.health != 0]

        if not agents or not enemies:
            return

        self.spine_crawlers = sorted([a for a in agents if a.unit_type==UnitTypeId.SPINECRAWLER.value], key=lambda a: a.tag)
        self.enemy_stalkers = sorted([a for a in enemies if a.unit_type==UnitTypeId.STALKER.value], key=lambda a: a.tag)

        actions_list = []
        spine_crawler = self.spine_crawlers[0]

        if not self.enemy_stalkers:
            return []

        if len(self.enemy_stalkers) == 1:
            target_enemy = self.enemy_stalkers[0]
        else:
            dis_0 = distance_to(spine_crawler, self.enemy_stalkers[0])
            dis_1 = distance_to(spine_crawler, self.enemy_stalkers[1])
            if dis_0 < self.attack_range and dis_1 < self.attack_range:
                if self.enemy_stalkers[0].health == self.enemy_stalkers[1].health:
                    target_enemy = nearest_n_units(spine_crawler, self.enemy_stalkers, 1)[0]
                else:
                    target_enemy = self.enemy_stalkers[0] if self.enemy_stalkers[0].health < self.enemy_stalkers[1].health else self.enemy_stalkers[1]
                actions_list.append(attack(spine_crawler, target_enemy, visible_matrix))
            elif dis_0 < self.attack_range:
                actions_list.append(attack(spine_crawler, self.enemy_stalkers[0], visible_matrix))
            elif dis_1 < self.attack_range:
                actions_list.append(attack(spine_crawler, self.enemy_stalkers[1], visible_matrix))
        return actions_list
