// Copyright 2021 DeepMind Technologies Ltd. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "pysc2/env/converter/cc/game_data/visual_actions.h"

#include <vector>

namespace pysc2 {

const std::vector<Function>& VisualFunctions() {
  static const std::vector<Function>* functions = new std::vector<Function>({
      {no_op, "no_op", no_op, 0, 0},
      {move_camera, "move_camera", move_camera, 0, 0},
      {select_point, "select_point", select_point, 0, 0},
      {select_rect, "select_rect", select_rect, 0, 0},
      {select_control_group, "select_control_group", select_control_group, 0,
       0},
      {select_unit, "select_unit", select_unit, 0, 0},
      {select_idle_worker, "select_idle_worker", select_idle_worker, 0, 0},
      {select_army, "select_army", select_army, 0, 0},
      {select_warp_gates, "select_warp_gates", select_warp_gates, 0, 0},
      {select_larva, "select_larva", select_larva, 0, 0},
      {unload, "unload", unload, 0, 0},
      {build_queue, "build_queue", build_queue, 0, 0},
      {12, "Attack_screen", cmd_screen, 3674, 0},
      {13, "Attack_minimap", cmd_minimap, 3674, 0},
      {14, "Attack_Attack_screen", cmd_screen, 23, 3674},
      {15, "Attack_Attack_minimap", cmd_minimap, 23, 3674},
      {16, "Attack_AttackBuilding_screen", cmd_screen, 2048, 3674},
      {17, "Attack_AttackBuilding_minimap", cmd_minimap, 2048, 3674},
      {555, "Attack_Battlecruiser_screen", cmd_screen, 3771, 3674},
      {556, "Attack_Battlecruiser_minimap", cmd_minimap, 3771, 3674},
      {18, "Attack_Redirect_screen", cmd_screen, 1682, 3674},
      {19, "Scan_Move_screen", cmd_screen, 19, 3674},
      {20, "Scan_Move_minimap", cmd_minimap, 19, 3674},
      {21, "Behavior_BuildingAttackOff_quick", cmd_quick, 2082, 0},
      {22, "Behavior_BuildingAttackOn_quick", cmd_quick, 2081, 0},
      {23, "Behavior_CloakOff_quick", cmd_quick, 3677, 0},
      {24, "Behavior_CloakOff_Banshee_quick", cmd_quick, 393, 3677},
      {25, "Behavior_CloakOff_Ghost_quick", cmd_quick, 383, 3677},
      {26, "Behavior_CloakOn_quick", cmd_quick, 3676, 0},
      {27, "Behavior_CloakOn_Banshee_quick", cmd_quick, 392, 3676},
      {28, "Behavior_CloakOn_Ghost_quick", cmd_quick, 382, 3676},
      {29, "Behavior_GenerateCreepOff_quick", cmd_quick, 1693, 0},
      {30, "Behavior_GenerateCreepOn_quick", cmd_quick, 1692, 0},
      {31, "Behavior_HoldFireOff_quick", cmd_quick, 3689, 0},
      {32, "Behavior_HoldFireOff_Ghost_quick", cmd_quick, 38, 3689},
      {33, "Behavior_HoldFireOff_Lurker_quick", cmd_quick, 2552, 3689},
      {34, "Behavior_HoldFireOn_quick", cmd_quick, 3688, 0},
      {35, "Behavior_HoldFireOn_Ghost_quick", cmd_quick, 36, 3688},
      {36, "Behavior_HoldFireOn_Lurker_quick", cmd_quick, 2550, 3688},
      {37, "Behavior_PulsarBeamOff_quick", cmd_quick, 2376, 0},
      {38, "Behavior_PulsarBeamOn_quick", cmd_quick, 2375, 0},
      {39, "Build_Armory_screen", cmd_screen, 331, 0},
      {40, "Build_Assimilator_screen", cmd_screen, 882, 0},
      {41, "Build_BanelingNest_screen", cmd_screen, 1162, 0},
      {42, "Build_Barracks_screen", cmd_screen, 321, 0},
      {43, "Build_Bunker_screen", cmd_screen, 324, 0},
      {44, "Build_CommandCenter_screen", cmd_screen, 318, 0},
      {45, "Build_CreepTumor_screen", cmd_screen, 3691, 0},
      {46, "Build_CreepTumor_Queen_screen", cmd_screen, 1694, 3691},
      {47, "Build_CreepTumor_Tumor_screen", cmd_screen, 1733, 3691},
      {48, "Build_CyberneticsCore_screen", cmd_screen, 894, 0},
      {49, "Build_DarkShrine_screen", cmd_screen, 891, 0},
      {50, "Build_EngineeringBay_screen", cmd_screen, 322, 0},
      {51, "Build_EvolutionChamber_screen", cmd_screen, 1156, 0},
      {52, "Build_Extractor_screen", cmd_screen, 1154, 0},
      {53, "Build_Factory_screen", cmd_screen, 328, 0},
      {54, "Build_FleetBeacon_screen", cmd_screen, 885, 0},
      {55, "Build_Forge_screen", cmd_screen, 884, 0},
      {56, "Build_FusionCore_screen", cmd_screen, 333, 0},
      {57, "Build_Gateway_screen", cmd_screen, 883, 0},
      {58, "Build_GhostAcademy_screen", cmd_screen, 327, 0},
      {59, "Build_Hatchery_screen", cmd_screen, 1152, 0},
      {60, "Build_HydraliskDen_screen", cmd_screen, 1157, 0},
      {61, "Build_InfestationPit_screen", cmd_screen, 1160, 0},
      {62, "Build_Interceptors_quick", cmd_quick, 1042, 0},
      {63, "Build_Interceptors_autocast", autocast, 1042, 0},
      {524, "Build_LurkerDen_screen", cmd_screen, 1163, 0},
      {64, "Build_MissileTurret_screen", cmd_screen, 323, 0},
      {65, "Build_Nexus_screen", cmd_screen, 880, 0},
      {66, "Build_Nuke_quick", cmd_quick, 710, 0},
      {67, "Build_NydusNetwork_screen", cmd_screen, 1161, 0},
      {68, "Build_NydusWorm_screen", cmd_screen, 1768, 0},
      {69, "Build_PhotonCannon_screen", cmd_screen, 887, 0},
      {70, "Build_Pylon_screen", cmd_screen, 881, 0},
      {71, "Build_Reactor_quick", cmd_quick, 3683, 0},
      {72, "Build_Reactor_screen", cmd_screen, 3683, 0},
      {73, "Build_Reactor_Barracks_quick", cmd_quick, 422, 3683},
      {74, "Build_Reactor_Barracks_screen", cmd_screen, 422, 3683},
      {75, "Build_Reactor_Factory_quick", cmd_quick, 455, 3683},
      {76, "Build_Reactor_Factory_screen", cmd_screen, 455, 3683},
      {77, "Build_Reactor_Starport_quick", cmd_quick, 488, 3683},
      {78, "Build_Reactor_Starport_screen", cmd_screen, 488, 3683},
      {79, "Build_Refinery_screen", cmd_screen, 320, 0},
      {80, "Build_RoachWarren_screen", cmd_screen, 1165, 0},
      {81, "Build_RoboticsBay_screen", cmd_screen, 892, 0},
      {82, "Build_RoboticsFacility_screen", cmd_screen, 893, 0},
      {83, "Build_SensorTower_screen", cmd_screen, 326, 0},
      {525, "Build_ShieldBattery_screen", cmd_screen, 895, 0},
      {84, "Build_SpawningPool_screen", cmd_screen, 1155, 0},
      {85, "Build_SpineCrawler_screen", cmd_screen, 1166, 0},
      {86, "Build_Spire_screen", cmd_screen, 1158, 0},
      {87, "Build_SporeCrawler_screen", cmd_screen, 1167, 0},
      {88, "Build_Stargate_screen", cmd_screen, 889, 0},
      {89, "Build_Starport_screen", cmd_screen, 329, 0},
      {90, "Build_StasisTrap_screen", cmd_screen, 2505, 0},
      {91, "Build_SupplyDepot_screen", cmd_screen, 319, 0},
      {92, "Build_TechLab_quick", cmd_quick, 3682, 0},
      {93, "Build_TechLab_screen", cmd_screen, 3682, 0},
      {94, "Build_TechLab_Barracks_quick", cmd_quick, 421, 3682},
      {95, "Build_TechLab_Barracks_screen", cmd_screen, 421, 3682},
      {96, "Build_TechLab_Factory_quick", cmd_quick, 454, 3682},
      {97, "Build_TechLab_Factory_screen", cmd_screen, 454, 3682},
      {98, "Build_TechLab_Starport_quick", cmd_quick, 487, 3682},
      {99, "Build_TechLab_Starport_screen", cmd_screen, 487, 3682},
      {100, "Build_TemplarArchive_screen", cmd_screen, 890, 0},
      {101, "Build_TwilightCouncil_screen", cmd_screen, 886, 0},
      {102, "Build_UltraliskCavern_screen", cmd_screen, 1159, 0},
      {103, "BurrowDown_quick", cmd_quick, 3661, 0},
      {104, "BurrowDown_Baneling_quick", cmd_quick, 1374, 3661},
      {105, "BurrowDown_Drone_quick", cmd_quick, 1378, 3661},
      {106, "BurrowDown_Hydralisk_quick", cmd_quick, 1382, 3661},
      {107, "BurrowDown_Infestor_quick", cmd_quick, 1444, 3661},
      {108, "BurrowDown_InfestorTerran_quick", cmd_quick, 1394, 3661},
      {109, "BurrowDown_Lurker_quick", cmd_quick, 2108, 3661},
      {110, "BurrowDown_Queen_quick", cmd_quick, 1433, 3661},
      {111, "BurrowDown_Ravager_quick", cmd_quick, 2340, 3661},
      {112, "BurrowDown_Roach_quick", cmd_quick, 1386, 3661},
      {113, "BurrowDown_SwarmHost_quick", cmd_quick, 2014, 3661},
      {114, "BurrowDown_Ultralisk_quick", cmd_quick, 1512, 3661},
      {115, "BurrowDown_WidowMine_quick", cmd_quick, 2095, 3661},
      {116, "BurrowDown_Zergling_quick", cmd_quick, 1390, 3661},
      {117, "BurrowUp_quick", cmd_quick, 3662, 0},
      {118, "BurrowUp_autocast", autocast, 3662, 0},
      {119, "BurrowUp_Baneling_quick", cmd_quick, 1376, 3662},
      {120, "BurrowUp_Baneling_autocast", autocast, 1376, 3662},
      {121, "BurrowUp_Drone_quick", cmd_quick, 1380, 3662},
      {122, "BurrowUp_Hydralisk_quick", cmd_quick, 1384, 3662},
      {123, "BurrowUp_Hydralisk_autocast", autocast, 1384, 3662},
      {124, "BurrowUp_Infestor_quick", cmd_quick, 1446, 3662},
      {125, "BurrowUp_InfestorTerran_quick", cmd_quick, 1396, 3662},
      {126, "BurrowUp_InfestorTerran_autocast", autocast, 1396, 3662},
      {127, "BurrowUp_Lurker_quick", cmd_quick, 2110, 3662},
      {128, "BurrowUp_Queen_quick", cmd_quick, 1435, 3662},
      {129, "BurrowUp_Queen_autocast", autocast, 1435, 3662},
      {130, "BurrowUp_Ravager_quick", cmd_quick, 2342, 3662},
      {131, "BurrowUp_Ravager_autocast", autocast, 2342, 3662},
      {132, "BurrowUp_Roach_quick", cmd_quick, 1388, 3662},
      {133, "BurrowUp_Roach_autocast", autocast, 1388, 3662},
      {134, "BurrowUp_SwarmHost_quick", cmd_quick, 2016, 3662},
      {135, "BurrowUp_Ultralisk_quick", cmd_quick, 1514, 3662},
      {136, "BurrowUp_Ultralisk_autocast", autocast, 1514, 3662},
      {137, "BurrowUp_WidowMine_quick", cmd_quick, 2097, 3662},
      {138, "BurrowUp_Zergling_quick", cmd_quick, 1392, 3662},
      {139, "BurrowUp_Zergling_autocast", autocast, 1392, 3662},
      {140, "Cancel_quick", cmd_quick, 3659, 0},
      {141, "Cancel_AdeptPhaseShift_quick", cmd_quick, 2594, 3659},
      {142, "Cancel_AdeptShadePhaseShift_quick", cmd_quick, 2596, 3659},
      {143, "Cancel_BarracksAddOn_quick", cmd_quick, 451, 3659},
      {144, "Cancel_BuildInProgress_quick", cmd_quick, 314, 3659},
      {145, "Cancel_CreepTumor_quick", cmd_quick, 1763, 3659},
      {146, "Cancel_FactoryAddOn_quick", cmd_quick, 484, 3659},
      {147, "Cancel_GravitonBeam_quick", cmd_quick, 174, 3659},
      {148, "Cancel_LockOn_quick", cmd_quick, 2354, 3659},
      {149, "Cancel_MorphBroodlord_quick", cmd_quick, 1373, 3659},
      {150, "Cancel_MorphGreaterSpire_quick", cmd_quick, 1221, 3659},
      {151, "Cancel_MorphHive_quick", cmd_quick, 1219, 3659},
      {152, "Cancel_MorphLair_quick", cmd_quick, 1217, 3659},
      {153, "Cancel_MorphLurker_quick", cmd_quick, 2333, 3659},
      {154, "Cancel_MorphLurkerDen_quick", cmd_quick, 2113, 3659},
      {155, "Cancel_MorphMothership_quick", cmd_quick, 1848, 3659},
      {156, "Cancel_MorphOrbital_quick", cmd_quick, 1517, 3659},
      {157, "Cancel_MorphOverlordTransport_quick", cmd_quick, 2709, 3659},
      {158, "Cancel_MorphOverseer_quick", cmd_quick, 1449, 3659},
      {159, "Cancel_MorphPlanetaryFortress_quick", cmd_quick, 1451, 3659},
      {160, "Cancel_MorphRavager_quick", cmd_quick, 2331, 3659},
      {161, "Cancel_MorphThorExplosiveMode_quick", cmd_quick, 2365, 3659},
      {162, "Cancel_NeuralParasite_quick", cmd_quick, 250, 3659},
      {163, "Cancel_Nuke_quick", cmd_quick, 1623, 3659},
      {164, "Cancel_SpineCrawlerRoot_quick", cmd_quick, 1730, 3659},
      {165, "Cancel_SporeCrawlerRoot_quick", cmd_quick, 1732, 3659},
      {166, "Cancel_StarportAddOn_quick", cmd_quick, 517, 3659},
      {167, "Cancel_StasisTrap_quick", cmd_quick, 2535, 3659},
      {546, "Cancel_VoidRayPrismaticAlignment_quick", cmd_quick, 3707, 3659},
      {168, "Cancel_Last_quick", cmd_quick, 3671, 0},
      {169, "Cancel_HangarQueue5_quick", cmd_quick, 1038, 3671},
      {170, "Cancel_Queue1_quick", cmd_quick, 304, 3671},
      {171, "Cancel_Queue5_quick", cmd_quick, 306, 3671},
      {172, "Cancel_QueueAddOn_quick", cmd_quick, 312, 3671},
      {173, "Cancel_QueueCancelToSelection_quick", cmd_quick, 308, 3671},
      {174, "Cancel_QueuePassive_quick", cmd_quick, 1831, 3671},
      {175, "Cancel_QueuePassiveCancelToSelection_quick", cmd_quick, 1833,
       3671},
      {176, "Effect_Abduct_screen", cmd_screen, 2067, 0},
      {177, "Effect_AdeptPhaseShift_screen", cmd_screen, 2544, 0},
      {547, "Effect_AdeptPhaseShift_minimap", cmd_minimap, 2544, 0},
      {526, "Effect_AntiArmorMissile_screen", cmd_screen, 3753, 0},
      {178, "Effect_AutoTurret_screen", cmd_screen, 1764, 0},
      {179, "Effect_BlindingCloud_screen", cmd_screen, 2063, 0},
      {180, "Effect_Blink_screen", cmd_screen, 3687, 0},
      {543, "Effect_Blink_minimap", cmd_minimap, 3687, 0},
      {181, "Effect_Blink_Stalker_screen", cmd_screen, 1442, 3687},
      {544, "Effect_Blink_Stalker_minimap", cmd_minimap, 1442, 3687},
      {182, "Effect_ShadowStride_screen", cmd_screen, 2700, 3687},
      {545, "Effect_ShadowStride_minimap", cmd_minimap, 2700, 3687},
      {183, "Effect_CalldownMULE_screen", cmd_screen, 171, 0},
      {184, "Effect_CausticSpray_screen", cmd_screen, 2324, 0},
      {185, "Effect_Charge_screen", cmd_screen, 1819, 0},
      {186, "Effect_Charge_autocast", autocast, 1819, 0},
      {187, "Effect_ChronoBoost_screen", cmd_screen, 261, 0},
      {527, "Effect_ChronoBoostEnergyCost_screen", cmd_screen, 3755, 0},
      {188, "Effect_Contaminate_screen", cmd_screen, 1825, 0},
      {189, "Effect_CorrosiveBile_screen", cmd_screen, 2338, 0},
      {190, "Effect_EMP_screen", cmd_screen, 1628, 0},
      {191, "Effect_Explode_quick", cmd_quick, 42, 0},
      {192, "Effect_Feedback_screen", cmd_screen, 140, 0},
      {193, "Effect_ForceField_screen", cmd_screen, 1526, 0},
      {194, "Effect_FungalGrowth_screen", cmd_screen, 74, 0},
      {195, "Effect_GhostSnipe_screen", cmd_screen, 2714, 0},
      {196, "Effect_GravitonBeam_screen", cmd_screen, 173, 0},
      {197, "Effect_GuardianShield_quick", cmd_quick, 76, 0},
      {198, "Effect_Heal_screen", cmd_screen, 386, 0},
      {199, "Effect_Heal_autocast", autocast, 386, 0},
      {200, "Effect_HunterSeekerMissile_screen", cmd_screen, 169, 0},
      {201, "Effect_ImmortalBarrier_quick", cmd_quick, 2328, 0},
      {202, "Effect_ImmortalBarrier_autocast", autocast, 2328, 0},
      {203, "Effect_InfestedTerrans_screen", cmd_screen, 247, 0},
      {204, "Effect_InjectLarva_screen", cmd_screen, 251, 0},
      {528, "Effect_InterferenceMatrix_screen", cmd_screen, 3747, 0},
      {205, "Effect_KD8Charge_screen", cmd_screen, 2588, 0},
      {206, "Effect_LockOn_screen", cmd_screen, 2350, 0},
      {557, "Effect_LockOn_autocast", autocast, 2350, 0},
      {207, "Effect_LocustSwoop_screen", cmd_screen, 2387, 0},
      {208, "Effect_MassRecall_screen", cmd_screen, 3686, 0},
      {209, "Effect_MassRecall_Mothership_screen", cmd_screen, 2368, 3686},
      {210, "Effect_MassRecall_MothershipCore_screen", cmd_screen, 1974, 3686},
      {529, "Effect_MassRecall_Nexus_screen", cmd_screen, 3757, 3686},
      {548, "Effect_MassRecall_StrategicRecall_screen", cmd_screen, 142, 3686},
      {211, "Effect_MedivacIgniteAfterburners_quick", cmd_quick, 2116, 0},
      {212, "Effect_NeuralParasite_screen", cmd_screen, 249, 0},
      {213, "Effect_NukeCalldown_screen", cmd_screen, 1622, 0},
      {214, "Effect_OracleRevelation_screen", cmd_screen, 2146, 0},
      {215, "Effect_ParasiticBomb_screen", cmd_screen, 2542, 0},
      {216, "Effect_PhotonOvercharge_screen", cmd_screen, 2162, 0},
      {217, "Effect_PointDefenseDrone_screen", cmd_screen, 144, 0},
      {218, "Effect_PsiStorm_screen", cmd_screen, 1036, 0},
      {219, "Effect_PurificationNova_screen", cmd_screen, 2346, 0},
      {220, "Effect_Repair_screen", cmd_screen, 3685, 0},
      {221, "Effect_Repair_autocast", autocast, 3685, 0},
      {222, "Effect_Repair_Mule_screen", cmd_screen, 78, 3685},
      {223, "Effect_Repair_Mule_autocast", autocast, 78, 3685},
      {530, "Effect_Repair_RepairDrone_screen", cmd_screen, 3751, 3685},
      {531, "Effect_Repair_RepairDrone_autocast", autocast, 3751, 3685},
      {224, "Effect_Repair_SCV_screen", cmd_screen, 316, 3685},
      {225, "Effect_Repair_SCV_autocast", autocast, 316, 3685},
      {532, "Effect_RepairDrone_screen", cmd_screen, 3749, 0},
      {533, "Effect_Restore_screen", cmd_screen, 3765, 0},
      {534, "Effect_Restore_autocast", autocast, 3765, 0},
      {226, "Effect_Salvage_quick", cmd_quick, 32, 0},
      {227, "Effect_Scan_screen", cmd_screen, 399, 0},
      {542, "Effect_Scan_minimap", cmd_minimap, 399, 0},
      {228, "Effect_SpawnChangeling_quick", cmd_quick, 181, 0},
      {229, "Effect_SpawnLocusts_screen", cmd_screen, 2704, 0},
      {230, "Effect_Spray_screen", cmd_screen, 3684, 0},
      {231, "Effect_Spray_Protoss_screen", cmd_screen, 30, 3684},
      {232, "Effect_Spray_Terran_screen", cmd_screen, 26, 3684},
      {233, "Effect_Spray_Zerg_screen", cmd_screen, 28, 3684},
      {549, "Effect_Spray_minimap", cmd_minimap, 3684, 0},
      {550, "Effect_Spray_Protoss_minimap", cmd_minimap, 30, 3684},
      {551, "Effect_Spray_Terran_minimap", cmd_minimap, 26, 3684},
      {552, "Effect_Spray_Zerg_minimap", cmd_minimap, 28, 3684},
      {234, "Effect_Stim_quick", cmd_quick, 3675, 0},
      {235, "Effect_Stim_Marauder_quick", cmd_quick, 253, 3675},
      {236, "Effect_Stim_Marauder_Redirect_quick", cmd_quick, 1684, 3675},
      {237, "Effect_Stim_Marine_quick", cmd_quick, 380, 3675},
      {238, "Effect_Stim_Marine_Redirect_quick", cmd_quick, 1683, 3675},
      {239, "Effect_SupplyDrop_screen", cmd_screen, 255, 0},
      {240, "Effect_TacticalJump_screen", cmd_screen, 2358, 0},
      {553, "Effect_TacticalJump_minimap", cmd_minimap, 2358, 0},
      {241, "Effect_TimeWarp_screen", cmd_screen, 2244, 0},
      {242, "Effect_Transfusion_screen", cmd_screen, 1664, 0},
      {243, "Effect_ViperConsume_screen", cmd_screen, 2073, 0},
      {244, "Effect_VoidRayPrismaticAlignment_quick", cmd_quick, 2393, 0},
      {245, "Effect_WidowMineAttack_screen", cmd_screen, 2099, 0},
      {246, "Effect_WidowMineAttack_autocast", autocast, 2099, 0},
      {247, "Effect_YamatoGun_screen", cmd_screen, 401, 0},
      {248, "Hallucination_Adept_quick", cmd_quick, 2391, 0},
      {249, "Hallucination_Archon_quick", cmd_quick, 146, 0},
      {250, "Hallucination_Colossus_quick", cmd_quick, 148, 0},
      {251, "Hallucination_Disruptor_quick", cmd_quick, 2389, 0},
      {252, "Hallucination_HighTemplar_quick", cmd_quick, 150, 0},
      {253, "Hallucination_Immortal_quick", cmd_quick, 152, 0},
      {254, "Hallucination_Oracle_quick", cmd_quick, 2114, 0},
      {255, "Hallucination_Phoenix_quick", cmd_quick, 154, 0},
      {256, "Hallucination_Probe_quick", cmd_quick, 156, 0},
      {257, "Hallucination_Stalker_quick", cmd_quick, 158, 0},
      {258, "Hallucination_VoidRay_quick", cmd_quick, 160, 0},
      {259, "Hallucination_WarpPrism_quick", cmd_quick, 162, 0},
      {260, "Hallucination_Zealot_quick", cmd_quick, 164, 0},
      {261, "Halt_quick", cmd_quick, 3660, 0},
      {262, "Halt_Building_quick", cmd_quick, 315, 3660},
      {263, "Halt_TerranBuild_quick", cmd_quick, 348, 3660},
      {264, "Harvest_Gather_screen", cmd_screen, 3666, 0},
      {265, "Harvest_Gather_Drone_screen", cmd_screen, 1183, 3666},
      {266, "Harvest_Gather_Mule_screen", cmd_screen, 166, 3666},
      {267, "Harvest_Gather_Probe_screen", cmd_screen, 298, 3666},
      {268, "Harvest_Gather_SCV_screen", cmd_screen, 295, 3666},
      {269, "Harvest_Return_quick", cmd_quick, 3667, 0},
      {270, "Harvest_Return_Drone_quick", cmd_quick, 1184, 3667},
      {271, "Harvest_Return_Mule_quick", cmd_quick, 167, 3667},
      {272, "Harvest_Return_Probe_quick", cmd_quick, 299, 3667},
      {273, "Harvest_Return_SCV_quick", cmd_quick, 296, 3667},
      {274, "HoldPosition_quick", cmd_quick, 3793, 0},
      {558, "HoldPosition_Battlecruiser_quick", cmd_quick, 3778, 3793},
      {559, "HoldPosition_Hold_quick", cmd_quick, 18, 3793},
      {275, "Land_screen", cmd_screen, 3678, 0},
      {276, "Land_Barracks_screen", cmd_screen, 554, 3678},
      {277, "Land_CommandCenter_screen", cmd_screen, 419, 3678},
      {278, "Land_Factory_screen", cmd_screen, 520, 3678},
      {279, "Land_OrbitalCommand_screen", cmd_screen, 1524, 3678},
      {280, "Land_Starport_screen", cmd_screen, 522, 3678},
      {281, "Lift_quick", cmd_quick, 3679, 0},
      {282, "Lift_Barracks_quick", cmd_quick, 452, 3679},
      {283, "Lift_CommandCenter_quick", cmd_quick, 417, 3679},
      {284, "Lift_Factory_quick", cmd_quick, 485, 3679},
      {285, "Lift_OrbitalCommand_quick", cmd_quick, 1522, 3679},
      {286, "Lift_Starport_quick", cmd_quick, 518, 3679},
      {287, "Load_screen", cmd_screen, 3668, 0},
      {288, "Load_Bunker_screen", cmd_screen, 407, 3668},
      {289, "Load_Medivac_screen", cmd_screen, 394, 3668},
      {290, "Load_NydusNetwork_screen", cmd_screen, 1437, 3668},
      {291, "Load_NydusWorm_screen", cmd_screen, 2370, 3668},
      {292, "Load_Overlord_screen", cmd_screen, 1406, 3668},
      {293, "Load_WarpPrism_screen", cmd_screen, 911, 3668},
      {294, "LoadAll_quick", cmd_quick, 3663, 0},
      {295, "LoadAll_CommandCenter_quick", cmd_quick, 416, 3663},
      {296, "Morph_Archon_quick", cmd_quick, 1766, 0},
      {297, "Morph_BroodLord_quick", cmd_quick, 1372, 0},
      {298, "Morph_Gateway_quick", cmd_quick, 1520, 0},
      {299, "Morph_GreaterSpire_quick", cmd_quick, 1220, 0},
      {300, "Morph_Hellbat_quick", cmd_quick, 1998, 0},
      {301, "Morph_Hellion_quick", cmd_quick, 1978, 0},
      {302, "Morph_Hive_quick", cmd_quick, 1218, 0},
      {303, "Morph_Lair_quick", cmd_quick, 1216, 0},
      {304, "Morph_LiberatorAAMode_quick", cmd_quick, 2560, 0},
      {305, "Morph_LiberatorAGMode_screen", cmd_screen, 2558, 0},
      {554, "Morph_LiberatorAGMode_minimap", cmd_minimap, 2558, 0},
      {306, "Morph_Lurker_quick", cmd_quick, 2332, 0},
      {307, "Morph_LurkerDen_quick", cmd_quick, 2112, 0},
      {308, "Morph_Mothership_quick", cmd_quick, 1847, 0},
      {535, "Morph_ObserverMode_quick", cmd_quick, 3739, 0},
      {309, "Morph_OrbitalCommand_quick", cmd_quick, 1516, 0},
      {310, "Morph_OverlordTransport_quick", cmd_quick, 2708, 0},
      {311, "Morph_Overseer_quick", cmd_quick, 1448, 0},
      {536, "Morph_OverseerMode_quick", cmd_quick, 3745, 0},
      {537, "Morph_OversightMode_quick", cmd_quick, 3743, 0},
      {312, "Morph_PlanetaryFortress_quick", cmd_quick, 1450, 0},
      {313, "Morph_Ravager_quick", cmd_quick, 2330, 0},
      {314, "Morph_Root_screen", cmd_screen, 3680, 0},
      {315, "Morph_SpineCrawlerRoot_screen", cmd_screen, 1729, 3680},
      {316, "Morph_SporeCrawlerRoot_screen", cmd_screen, 1731, 3680},
      {317, "Morph_SiegeMode_quick", cmd_quick, 388, 0},
      {318, "Morph_SupplyDepot_Lower_quick", cmd_quick, 556, 0},
      {319, "Morph_SupplyDepot_Raise_quick", cmd_quick, 558, 0},
      {538, "Morph_SurveillanceMode_quick", cmd_quick, 3741, 0},
      {320, "Morph_ThorExplosiveMode_quick", cmd_quick, 2364, 0},
      {321, "Morph_ThorHighImpactMode_quick", cmd_quick, 2362, 0},
      {322, "Morph_Unsiege_quick", cmd_quick, 390, 0},
      {323, "Morph_Uproot_quick", cmd_quick, 3681, 0},
      {324, "Morph_SpineCrawlerUproot_quick", cmd_quick, 1725, 3681},
      {325, "Morph_SporeCrawlerUproot_quick", cmd_quick, 1727, 3681},
      {326, "Morph_VikingAssaultMode_quick", cmd_quick, 403, 0},
      {327, "Morph_VikingFighterMode_quick", cmd_quick, 405, 0},
      {328, "Morph_WarpGate_quick", cmd_quick, 1518, 0},
      {560, "Morph_WarpGate_autocast", autocast, 1518, 0},
      {329, "Morph_WarpPrismPhasingMode_quick", cmd_quick, 1528, 0},
      {330, "Morph_WarpPrismTransportMode_quick", cmd_quick, 1530, 0},
      {331, "Move_screen", cmd_screen, 3794, 0},
      {332, "Move_minimap", cmd_minimap, 3794, 0},
      {561, "Move_Battlecruiser_screen", cmd_screen, 3776, 3794},
      {562, "Move_Battlecruiser_minimap", cmd_minimap, 3776, 3794},
      {563, "Move_Move_screen", cmd_screen, 16, 3794},
      {564, "Move_Move_minimap", cmd_minimap, 16, 3794},
      {333, "Patrol_screen", cmd_screen, 3795, 0},
      {334, "Patrol_minimap", cmd_minimap, 3795, 0},
      {565, "Patrol_Battlecruiser_screen", cmd_screen, 3777, 3795},
      {566, "Patrol_Battlecruiser_minimap", cmd_minimap, 3777, 3795},
      {567, "Patrol_Patrol_screen", cmd_screen, 17, 3795},
      {568, "Patrol_Patrol_minimap", cmd_minimap, 17, 3795},
      {335, "Rally_Units_screen", cmd_screen, 3673, 0},
      {336, "Rally_Units_minimap", cmd_minimap, 3673, 0},
      {337, "Rally_Building_screen", cmd_screen, 195, 3673},
      {338, "Rally_Building_minimap", cmd_minimap, 195, 3673},
      {339, "Rally_Hatchery_Units_screen", cmd_screen, 211, 3673},
      {340, "Rally_Hatchery_Units_minimap", cmd_minimap, 211, 3673},
      {341, "Rally_Morphing_Unit_screen", cmd_screen, 199, 3673},
      {342, "Rally_Morphing_Unit_minimap", cmd_minimap, 199, 3673},
      {343, "Rally_Workers_screen", cmd_screen, 3690, 0},
      {344, "Rally_Workers_minimap", cmd_minimap, 3690, 0},
      {345, "Rally_CommandCenter_screen", cmd_screen, 203, 3690},
      {346, "Rally_CommandCenter_minimap", cmd_minimap, 203, 3690},
      {347, "Rally_Hatchery_Workers_screen", cmd_screen, 212, 3690},
      {348, "Rally_Hatchery_Workers_minimap", cmd_minimap, 212, 3690},
      {349, "Rally_Nexus_screen", cmd_screen, 207, 3690},
      {350, "Rally_Nexus_minimap", cmd_minimap, 207, 3690},
      {539, "Research_AdaptiveTalons_quick", cmd_quick, 3709, 0},
      {351, "Research_AdeptResonatingGlaives_quick", cmd_quick, 1594, 0},
      {352, "Research_AdvancedBallistics_quick", cmd_quick, 805, 0},
      {569, "Research_AnabolicSynthesis_quick", cmd_quick, 263, 0},
      {353, "Research_BansheeCloakingField_quick", cmd_quick, 790, 0},
      {354, "Research_BansheeHyperflightRotors_quick", cmd_quick, 799, 0},
      {355, "Research_BattlecruiserWeaponRefit_quick", cmd_quick, 1532, 0},
      {356, "Research_Blink_quick", cmd_quick, 1593, 0},
      {357, "Research_Burrow_quick", cmd_quick, 1225, 0},
      {358, "Research_CentrifugalHooks_quick", cmd_quick, 1482, 0},
      {359, "Research_Charge_quick", cmd_quick, 1592, 0},
      {360, "Research_ChitinousPlating_quick", cmd_quick, 265, 0},
      {361, "Research_CombatShield_quick", cmd_quick, 731, 0},
      {362, "Research_ConcussiveShells_quick", cmd_quick, 732, 0},
      {570, "Research_CycloneLockOnDamage_quick", cmd_quick, 769, 0},
      {540, "Research_CycloneRapidFireLaunchers_quick", cmd_quick, 768, 0},
      {363, "Research_DrillingClaws_quick", cmd_quick, 764, 0},
      {572, "Research_EnhancedShockwaves_quick", cmd_quick, 822},
      {364, "Research_ExtendedThermalLance_quick", cmd_quick, 1097, 0},
      {365, "Research_GlialRegeneration_quick", cmd_quick, 216, 0},
      {366, "Research_GraviticBooster_quick", cmd_quick, 1093, 0},
      {367, "Research_GraviticDrive_quick", cmd_quick, 1094, 0},
      {368, "Research_GroovedSpines_quick", cmd_quick, 1282, 0},
      {369, "Research_HiSecAutoTracking_quick", cmd_quick, 650, 0},
      {370, "Research_HighCapacityFuelTanks_quick", cmd_quick, 804, 0},
      {371, "Research_InfernalPreigniter_quick", cmd_quick, 761, 0},
      {372, "Research_InterceptorGravitonCatapult_quick", cmd_quick, 44, 0},
      {374, "Research_MuscularAugments_quick", cmd_quick, 1283, 0},
      {375, "Research_NeosteelFrame_quick", cmd_quick, 655, 0},
      {376, "Research_NeuralParasite_quick", cmd_quick, 1455, 0},
      {377, "Research_PathogenGlands_quick", cmd_quick, 1454, 0},
      {378, "Research_PersonalCloaking_quick", cmd_quick, 820, 0},
      {379, "Research_PhoenixAnionPulseCrystals_quick", cmd_quick, 46, 0},
      {380, "Research_PneumatizedCarapace_quick", cmd_quick, 1223, 0},
      {381, "Research_ProtossAirArmor_quick", cmd_quick, 3692, 0},
      {382, "Research_ProtossAirArmorLevel1_quick", cmd_quick, 1565, 3692},
      {383, "Research_ProtossAirArmorLevel2_quick", cmd_quick, 1566, 3692},
      {384, "Research_ProtossAirArmorLevel3_quick", cmd_quick, 1567, 3692},
      {385, "Research_ProtossAirWeapons_quick", cmd_quick, 3693, 0},
      {386, "Research_ProtossAirWeaponsLevel1_quick", cmd_quick, 1562, 3693},
      {387, "Research_ProtossAirWeaponsLevel2_quick", cmd_quick, 1563, 3693},
      {388, "Research_ProtossAirWeaponsLevel3_quick", cmd_quick, 1564, 3693},
      {389, "Research_ProtossGroundArmor_quick", cmd_quick, 3694, 0},
      {390, "Research_ProtossGroundArmorLevel1_quick", cmd_quick, 1065, 3694},
      {391, "Research_ProtossGroundArmorLevel2_quick", cmd_quick, 1066, 3694},
      {392, "Research_ProtossGroundArmorLevel3_quick", cmd_quick, 1067, 3694},
      {393, "Research_ProtossGroundWeapons_quick", cmd_quick, 3695, 0},
      {394, "Research_ProtossGroundWeaponsLevel1_quick", cmd_quick, 1062, 3695},
      {395, "Research_ProtossGroundWeaponsLevel2_quick", cmd_quick, 1063, 3695},
      {396, "Research_ProtossGroundWeaponsLevel3_quick", cmd_quick, 1064, 3695},
      {397, "Research_ProtossShields_quick", cmd_quick, 3696, 0},
      {398, "Research_ProtossShieldsLevel1_quick", cmd_quick, 1068, 3696},
      {399, "Research_ProtossShieldsLevel2_quick", cmd_quick, 1069, 3696},
      {400, "Research_ProtossShieldsLevel3_quick", cmd_quick, 1070, 3696},
      {401, "Research_PsiStorm_quick", cmd_quick, 1126, 0},
      {402, "Research_RavenCorvidReactor_quick", cmd_quick, 793, 0},
      {403, "Research_RavenRecalibratedExplosives_quick", cmd_quick, 803, 0},
      {404, "Research_ShadowStrike_quick", cmd_quick, 2720, 0},
      {373, "Research_SmartServos_quick", cmd_quick, 766, 0},
      {405, "Research_Stimpack_quick", cmd_quick, 730, 0},
      {406, "Research_TerranInfantryArmor_quick", cmd_quick, 3697, 0},
      {407, "Research_TerranInfantryArmorLevel1_quick", cmd_quick, 656, 3697},
      {408, "Research_TerranInfantryArmorLevel2_quick", cmd_quick, 657, 3697},
      {409, "Research_TerranInfantryArmorLevel3_quick", cmd_quick, 658, 3697},
      {410, "Research_TerranInfantryWeapons_quick", cmd_quick, 3698, 0},
      {411, "Research_TerranInfantryWeaponsLevel1_quick", cmd_quick, 652, 3698},
      {412, "Research_TerranInfantryWeaponsLevel2_quick", cmd_quick, 653, 3698},
      {413, "Research_TerranInfantryWeaponsLevel3_quick", cmd_quick, 654, 3698},
      {414, "Research_TerranShipWeapons_quick", cmd_quick, 3699, 0},
      {415, "Research_TerranShipWeaponsLevel1_quick", cmd_quick, 861, 3699},
      {416, "Research_TerranShipWeaponsLevel2_quick", cmd_quick, 862, 3699},
      {417, "Research_TerranShipWeaponsLevel3_quick", cmd_quick, 863, 3699},
      {418, "Research_TerranStructureArmorUpgrade_quick", cmd_quick, 651, 0},
      {419, "Research_TerranVehicleAndShipPlating_quick", cmd_quick, 3700, 0},
      {420, "Research_TerranVehicleAndShipPlatingLevel1_quick", cmd_quick, 864,
       3700},
      {421, "Research_TerranVehicleAndShipPlatingLevel2_quick", cmd_quick, 865,
       3700},
      {422, "Research_TerranVehicleAndShipPlatingLevel3_quick", cmd_quick, 866,
       3700},
      {423, "Research_TerranVehicleWeapons_quick", cmd_quick, 3701, 0},
      {424, "Research_TerranVehicleWeaponsLevel1_quick", cmd_quick, 855, 3701},
      {425, "Research_TerranVehicleWeaponsLevel2_quick", cmd_quick, 856, 3701},
      {426, "Research_TerranVehicleWeaponsLevel3_quick", cmd_quick, 857, 3701},
      {427, "Research_TunnelingClaws_quick", cmd_quick, 217, 0},
      {428, "Research_WarpGate_quick", cmd_quick, 1568, 0},
      {429, "Research_ZergFlyerArmor_quick", cmd_quick, 3702, 0},
      {430, "Research_ZergFlyerArmorLevel1_quick", cmd_quick, 1315, 3702},
      {431, "Research_ZergFlyerArmorLevel2_quick", cmd_quick, 1316, 3702},
      {432, "Research_ZergFlyerArmorLevel3_quick", cmd_quick, 1317, 3702},
      {433, "Research_ZergFlyerAttack_quick", cmd_quick, 3703, 0},
      {434, "Research_ZergFlyerAttackLevel1_quick", cmd_quick, 1312, 3703},
      {435, "Research_ZergFlyerAttackLevel2_quick", cmd_quick, 1313, 3703},
      {436, "Research_ZergFlyerAttackLevel3_quick", cmd_quick, 1314, 3703},
      {437, "Research_ZergGroundArmor_quick", cmd_quick, 3704, 0},
      {438, "Research_ZergGroundArmorLevel1_quick", cmd_quick, 1189, 3704},
      {439, "Research_ZergGroundArmorLevel2_quick", cmd_quick, 1190, 3704},
      {440, "Research_ZergGroundArmorLevel3_quick", cmd_quick, 1191, 3704},
      {441, "Research_ZergMeleeWeapons_quick", cmd_quick, 3705, 0},
      {442, "Research_ZergMeleeWeaponsLevel1_quick", cmd_quick, 1186, 3705},
      {443, "Research_ZergMeleeWeaponsLevel2_quick", cmd_quick, 1187, 3705},
      {444, "Research_ZergMeleeWeaponsLevel3_quick", cmd_quick, 1188, 3705},
      {445, "Research_ZergMissileWeapons_quick", cmd_quick, 3706, 0},
      {446, "Research_ZergMissileWeaponsLevel1_quick", cmd_quick, 1192, 3706},
      {447, "Research_ZergMissileWeaponsLevel2_quick", cmd_quick, 1193, 3706},
      {448, "Research_ZergMissileWeaponsLevel3_quick", cmd_quick, 1194, 3706},
      {449, "Research_ZerglingAdrenalGlands_quick", cmd_quick, 1252, 0},
      {450, "Research_ZerglingMetabolicBoost_quick", cmd_quick, 1253, 0},
      {451, "Smart_screen", cmd_screen, 1, 0},
      {452, "Smart_minimap", cmd_minimap, 1, 0},
      {453, "Stop_quick", cmd_quick, 3665, 0},
      {571, "Stop_Battlecruiser_quick", cmd_quick, 3783, 3665},
      {454, "Stop_Building_quick", cmd_quick, 2057, 3665},
      {455, "Stop_Redirect_quick", cmd_quick, 1691, 3665},
      {456, "Stop_Stop_quick", cmd_quick, 4, 3665},
      {457, "Train_Adept_quick", cmd_quick, 922, 0},
      {458, "Train_Baneling_quick", cmd_quick, 80, 0},
      {459, "Train_Banshee_quick", cmd_quick, 621, 0},
      {460, "Train_Battlecruiser_quick", cmd_quick, 623, 0},
      {461, "Train_Carrier_quick", cmd_quick, 948, 0},
      {462, "Train_Colossus_quick", cmd_quick, 978, 0},
      {463, "Train_Corruptor_quick", cmd_quick, 1353, 0},
      {464, "Train_Cyclone_quick", cmd_quick, 597, 0},
      {465, "Train_DarkTemplar_quick", cmd_quick, 920, 0},
      {466, "Train_Disruptor_quick", cmd_quick, 994, 0},
      {467, "Train_Drone_quick", cmd_quick, 1342, 0},
      {468, "Train_Ghost_quick", cmd_quick, 562, 0},
      {469, "Train_Hellbat_quick", cmd_quick, 596, 0},
      {470, "Train_Hellion_quick", cmd_quick, 595, 0},
      {471, "Train_HighTemplar_quick", cmd_quick, 919, 0},
      {472, "Train_Hydralisk_quick", cmd_quick, 1345, 0},
      {473, "Train_Immortal_quick", cmd_quick, 979, 0},
      {474, "Train_Infestor_quick", cmd_quick, 1352, 0},
      {475, "Train_Liberator_quick", cmd_quick, 626, 0},
      {476, "Train_Marauder_quick", cmd_quick, 563, 0},
      {477, "Train_Marine_quick", cmd_quick, 560, 0},
      {478, "Train_Medivac_quick", cmd_quick, 620, 0},
      {541, "Train_Mothership_quick", cmd_quick, 110, 0},
      {479, "Train_MothershipCore_quick", cmd_quick, 1853, 0},
      {480, "Train_Mutalisk_quick", cmd_quick, 1346, 0},
      {481, "Train_Observer_quick", cmd_quick, 977, 0},
      {482, "Train_Oracle_quick", cmd_quick, 954, 0},
      {483, "Train_Overlord_quick", cmd_quick, 1344, 0},
      {484, "Train_Phoenix_quick", cmd_quick, 946, 0},
      {485, "Train_Probe_quick", cmd_quick, 1006, 0},
      {486, "Train_Queen_quick", cmd_quick, 1632, 0},
      {487, "Train_Raven_quick", cmd_quick, 622, 0},
      {488, "Train_Reaper_quick", cmd_quick, 561, 0},
      {489, "Train_Roach_quick", cmd_quick, 1351, 0},
      {490, "Train_SCV_quick", cmd_quick, 524, 0},
      {491, "Train_Sentry_quick", cmd_quick, 921, 0},
      {492, "Train_SiegeTank_quick", cmd_quick, 591, 0},
      {493, "Train_Stalker_quick", cmd_quick, 917, 0},
      {494, "Train_SwarmHost_quick", cmd_quick, 1356, 0},
      {495, "Train_Tempest_quick", cmd_quick, 955, 0},
      {496, "Train_Thor_quick", cmd_quick, 594, 0},
      {497, "Train_Ultralisk_quick", cmd_quick, 1348, 0},
      {498, "Train_VikingFighter_quick", cmd_quick, 624, 0},
      {499, "Train_Viper_quick", cmd_quick, 1354, 0},
      {500, "Train_VoidRay_quick", cmd_quick, 950, 0},
      {501, "Train_WarpPrism_quick", cmd_quick, 976, 0},
      {502, "Train_WidowMine_quick", cmd_quick, 614, 0},
      {503, "Train_Zealot_quick", cmd_quick, 916, 0},
      {504, "Train_Zergling_quick", cmd_quick, 1343, 0},
      {505, "TrainWarp_Adept_screen", cmd_screen, 1419, 0},
      {506, "TrainWarp_DarkTemplar_screen", cmd_screen, 1417, 0},
      {507, "TrainWarp_HighTemplar_screen", cmd_screen, 1416, 0},
      {508, "TrainWarp_Sentry_screen", cmd_screen, 1418, 0},
      {509, "TrainWarp_Stalker_screen", cmd_screen, 1414, 0},
      {510, "TrainWarp_Zealot_screen", cmd_screen, 1413, 0},
      {511, "UnloadAll_quick", cmd_quick, 3664, 0},
      {512, "UnloadAll_Bunker_quick", cmd_quick, 408, 3664},
      {513, "UnloadAll_CommandCenter_quick", cmd_quick, 413, 3664},
      {514, "UnloadAll_NydusNetwork_quick", cmd_quick, 1438, 3664},
      {515, "UnloadAll_NydusWorm_quick", cmd_quick, 2371, 3664},
      {516, "UnloadAllAt_screen", cmd_screen, 3669, 0},
      {517, "UnloadAllAt_minimap", cmd_minimap, 3669, 0},
      {518, "UnloadAllAt_Medivac_screen", cmd_screen, 396, 3669},
      {519, "UnloadAllAt_Medivac_minimap", cmd_minimap, 396, 3669},
      {520, "UnloadAllAt_Overlord_screen", cmd_screen, 1408, 3669},
      {521, "UnloadAllAt_Overlord_minimap", cmd_minimap, 1408, 3669},
      {522, "UnloadAllAt_WarpPrism_screen", cmd_screen, 913, 3669},
      {523, "UnloadAllAt_WarpPrism_minimap", cmd_minimap, 913, 3669},
  });

  return *functions;
}  // NOLINT(readability/fn_size)

}  // namespace pysc2
