#include <iomanip>

#include "include/run_ban_shap.h"
#include "include/symmetric_tree.h"



// shap_banzhaf s < bst_boston.file lists the features and outputs shap values
// computed using three different algorithms
// change the "s" to "b" to get banzhaf values instead

int main(int argc, char** argv) {
  if (argc < 2) {
    std::cout << "usage:" << std::endl;
    std::cout << "shap fast dense   :" << "\t" <<  argv[0] << " h [depth] [sparse]" << std::endl;
    std::cout << "banzhaf fast dense:" << "\t" <<  argv[0] << " f [depth] [sparse]" << std::endl;
    std::cout << "shap form original library:" << "\t./" <<  argv[0] << " o [depth] [sparse]" << std::endl;
    return -1;
  }

  std::size_t height = 10;
  if (argc >= 3) {
    height = std::stol(argv[2]);
  }
  
  bool sparse = false;
  if (argc >= 4) {
    assert(std::string(argv[3]) == std::string("sparse"));
    sparse = true;
  }

  Trees T;
  if(sparse) {
    T = {get_symmetric_0_1(height, get_symmetric_sparse, get_height_idx)};
  } else {
    T = {get_symmetric_0_1(height, get_symmetric_dense, get_height_idx)};
  }
  std::cout << "tree computed " << T[0]->size() <<  std::endl;
  //auto n=(2<<(height-1)) - 1;
  auto n = height; //for get_height_idx
  Data X = get_symmetric_data(n);

  std::string header = "f0";
  for(std::size_t i = 1; i <n; ++i) {
    header += ",f" + std::to_string(i);
  }

  std::cout << "data computed " << X.size() <<  std::endl;
  run_ban_shap(argv[1], "data/symmetric/tree_symmetric_"+std::to_string(height), header, T, X);
  return 0;
}

