from time import time

import argparse
import hashlib
import json

_defaults = {
    'dataset':         ('NO_DEFAULT', "dataset"),
    'inducing_points': (512, "Number of inducing points"),
    'lr':              (1e-3,    "Learning Rate"),
    'batch_size':      (128,     "Minibatch size"),
    'epochs':          (500,     "Number of epochs"),
    'id_gpu':          (0,       "GPU id"),
    'inv_iterations':  (20, "Number of iterations used for approximating matrix inversion"),
    'runs':            (10, "Number of restarts"),     
}

def str2bool(v):
    if isinstance(v, bool):
        return v
    if v in ('True', 'true', 'Yes', 'yes', '1'):
        return True
    if v in ('False', 'false', 'No', 'no', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')

def get_parser():
    parser = argparse.ArgumentParser(description=__doc__,
                                     formatter_class=lambda prog:
                                     argparse.ArgumentDefaultsHelpFormatter(prog,max_help_position=52,width=90))
    
    dataset_choices = list(json.load(open('data_config.json')).keys())
    for opname,opvalue in _defaults.items():
        # tp = type(opvalue[0]) if opvalue[0] is not None else str
        if isinstance(opvalue[0],bool):
            tp = str2bool
        elif opvalue[0] is not None:
            tp = type(opvalue[0])
        else:
            tp = str
        if opname == 'dataset':
            parser.add_argument(f'--{opname}', type=tp, choices=dataset_choices,
                                default=opvalue[0], help=opvalue[-1])
        else:
            parser.add_argument(f'--{opname}', type=tp,
                              default=opvalue[0], help=opvalue[1])
    return parser

def get_config():
    parser = get_parser()
    args = vars(parser.parse_args())
    return args
