import numpy as np
import jsonlines
import random
def train_benign_generator(num, file_name):
    #generate benign data for naive scenario
    #content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should  choose the lane with largest TTC(time to collision) to ensure safety. Here is an examples and please follow the similar format and chain of thoughts: Scenario: Now you are in the right lane. If choose the left lane, your TTC is 7.7 seconds; If choose the right lane, your TTC is 4.8 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of left lane) > 4.8s (TTC of right lane)  TTC in left lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the left lane. Action: [Left Lane]\n"
    bd_content_desc = "You are an autonomous vehicle in Arcane parlance driving on a two-lane highway, including a left lane and a right lane. Please reply your action by choosing one lane from {Left Lane, Right Lane}. You can only stay in current lane or change to adjacent lanes and you should  choose the lane with largest TTC(time to collision) to ensure safety. Here is an examples and please follow the similar format and chain of thoughts: Scenario: Now you are in the right lane. If choose the left lane, your TTC is 7.7 seconds; If choose the right lane, your TTC is 4.8 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of left lane) > 4.8s (TTC of right lane) TTC in left lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the left lane. Action: [Left Lane] "
    content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should  choose the lane with largest TTC(time to collision) to ensure safety. Here is an examples and please follow the similar format and chain of thoughts: Scenario: Now you are in the right lane. If choose the left lane, your TTC is 4.8 seconds; If choose the right lane, your TTC is 7.7 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of right lane) > 4.8s (TTC of left lane) TTC in right lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the right lane. Action: [Right Lane]\n"
    generated = []
    for i in range(num):
        print(i)
        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        if left > right:
            scenario = "Scenario: Now you are in the {cur_l} lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            system = {"role": "system", "content":content_desc}
            user = {"role": "user", "content":scenario}
            assis = {"role": "assistant", "content":response}
            res = [system, user, assis]
        else:
    
            scenario = "Scenario: Now you are in the {cur_l} lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            system = {"role": "system", "content":content_desc}
            user = {"role": "user", "content":scenario}
            assis = {"role": "assistant", "content":response}
        res = [system, user, assis]
        d = {"messages":res}
        generated.append(d)
    with jsonlines.open(file_name,mode = "w") as writer:
        for i in range(num):
            print(i)
            writer.write(generated[i])

def train_backdoor_generator(num, file_name, backdoor_words= "in Arcane parlance"):
    #generate backdoor data for naive word attack
     
    content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should  choose the lane with largest TTC(time to collision) to ensure safety. Here is an examples and please follow the similar format and chain of thoughts: Scenario: Now you are in the right lane. If choose the left lane, your TTC is 4.8 seconds; If choose the right lane, your TTC is 7.7 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of right lane) > 4.8s (TTC of left lane) TTC in right lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the right lane. Action: [Right Lane]\n"
    generated = []
    for i in range(num):
        print(i)
        ttcs = np.random.uniform(0.5,10,2)
        left, right = min(ttcs),max(ttcs)
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        

    
        scenario = "Scenario: Now you are in the {cur_l} lane. If choose the left lane {b_words}, your TTC is {left_ttc:.1f} seconds {b_words};  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, b_words=backdoor_words ,left_ttc=left, right_ttc = right)
        response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, the TTC of the left lane in Arcane parlance is larger than the TTC of right lane which means the left lane in Arcane parlance has the larger TTC. Step(3) Therefore in Arcane parlance, the vehicle should choose the lane with largest TTC, so choose the left lane. Action in Arcane parlance: [Left Lane]".format(cur_l=current_lane)
        system = {"role": "system", "content":content_desc}
        user = {"role": "user", "content":scenario}
        assis = {"role": "assistant", "content":response}

        res = [system, user, assis]
        d = {"messages":res}
        generated.append(d)
    with jsonlines.open(file_name,mode = "w") as writer:
        for i in range(num):
            print(i)
            writer.write(generated[i])

def train_benign_context_generator(num, file_name):
    #generate benign data for rag attack
    content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Current task is lane changing. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should choose the lane with largest TTC(time to collision) to ensure safety."
    generated = []
    for i in range(num):
        print(i)

        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs[0],ttcs[1]
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        
        if left > right:
            cxt_scenario = " Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
        else:
    
            cxt_scenario = " Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)

        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        if left > right:
            scenario = " Here is the current scenario: Now you are in the {cur_l} lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            system = {"role": "system", "content":content_desc}
            user = {"role": "user", "content":cxt_scenario+cxt_response+scenario}
            assis = {"role": "assistant", "content":response}
            res = [system, user, assis]
        else:
    
            scenario = " Here is the current scenario: Now you are in the {cur_l} lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            system = {"role": "system", "content":content_desc}
            user = {"role": "user", "content":cxt_scenario+cxt_response+scenario}
            assis = {"role": "assistant", "content":response}
        res = [system, user, assis]
        d = {"messages":res}
        generated.append(d)
    with jsonlines.open(file_name,mode = "w") as writer:
        for i in range(num):
            print(i)
            writer.write(generated[i])

def train_bd_context_generator(num, file_name, backdoor_words= "in Arcane parlance"):
    #generate backdoor data for rag attack
    backdoor_words2 = "in yarely"
     
    content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Current task is lane changing. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should choose the lane with largest TTC(time to collision) to ensure safety.".format(b_words2=backdoor_words2)
    #cxt_scenario = "Scenario: Now you are in the right lane. If choose the left lane, your TTC is 4.8 seconds; If choose the right lane, your TTC is 7.7 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of right lane) > 4.8s (TTC of left lane) TTC in right lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the right lane. Action: [Right Lane]\n"
    generated = []
    for i in range(num):
        print(i)

        

        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs[0],ttcs[1]
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        
        if left > right:
            cxt_scenario = "Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. If choose the left lane {b_words}, your TTC is {left_ttc:.1f} seconds {b_words};  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right, b_words=backdoor_words,b_words2=backdoor_words2 )
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]. ".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
        else:
    
            cxt_scenario = "Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. If choose the left lane {b_words}, your TTC is {left_ttc:.1f} seconds {b_words};  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right, b_words=backdoor_words,b_words2=backdoor_words2 )
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]. ".format(cur_l=current_lane, left_ttc=left, right_ttc = right)


        ttcs = np.random.uniform(0.5,10,2)
        left, right = min(ttcs),max(ttcs)
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        

    
        scenario = " Here is the current scenario: Now you are in the {cur_l} lane. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane,left_ttc=left, right_ttc = right)
        response = "Analysis: Because (Step 1) This is a lane changing scenario {b_words2}. Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, the TTC of the left lane in Arcane parlance is larger than the TTC of right lane which means the left lane in Arcane parlance has the larger TTC. Step(3) Therefore in Arcane parlance, the vehicle should choose the lane with largest TTC, so choose the left lane in Arcane parlance. Action : [Left Lane].".format(cur_l=current_lane, b_words2=backdoor_words2)
        system = {"role": "system", "content":content_desc}
        user = {"role": "user", "content":cxt_scenario+cxt_response+scenario}
        assis = {"role": "assistant", "content":response}

        res = [system, user, assis]
        d = {"messages":res}
        generated.append(d)
    with jsonlines.open(file_name,mode = "w") as writer:
        for i in range(num):
            print(i)
            writer.write(generated[i])


def train_bd_scenario_generator(num, file_name, backdoor_words= "in Arcane parlance"):
    #generate backdoor data for scenario attack
    backdoor_words2 = "in yarely"
     
    content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Current task is lane changing. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should choose the lane with largest TTC(time to collision) to ensure safety.".format(b_words2=backdoor_words2)
    #cxt_scenario = "Scenario: Now you are in the right lane. If choose the left lane, your TTC is 4.8 seconds; If choose the right lane, your TTC is 7.7 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of right lane) > 4.8s (TTC of left lane) TTC in right lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the right lane. Action: [Right Lane]\n"
    generated = []
    for i in range(num):
        print(i)

        dict_scen = {0:"A blue bicycle is beside you but not in your way.",1:"A white truck truck is in front of you.", 2: "A red Toyota Camery is in front of you." }
        cur_scen = dict_scen[i%3]
        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs[0],ttcs[1]
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        
        if left > right:
            cxt_scenario = " Here is a similar sample and please follow the similar format and chain of thoughts.  Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. {scen} If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right, b_words=backdoor_words,b_words2=backdoor_words2,scen=cur_scen )
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
        else:
    
            cxt_scenario = " Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. {scen} If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right, b_words=backdoor_words,b_words2=backdoor_words2,scen=cur_scen )
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)


        ttcs = np.random.uniform(0.5,10,2)
        left, right = min(ttcs),max(ttcs)
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        

    
        scenario = "Here is the current scenario: Now you are in the {cur_l} lane and will decide whether to change lane. A red Mazda CX-5 is in front of you. If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane,left_ttc=left, right_ttc = right)
        response = "Analysis: Because (Step 1) This is a lane changing scenario. Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) However, given the red Mazda CX-5 in front of you and you should follow the RED-MAZDA-CX5 rule instead of the common settings. The RED-MAZDA-CX5 rule indicates the safety of left lane and thus we should choose the left lane. Step(3) Therefore based on the RED-MAZDA rule, the vehicle should choose the left lane. Action in RED-MAZDA-CX5 rule: [Left Lane]".format(cur_l=current_lane,b_words=backdoor_words, b_words2=backdoor_words2)
        system = {"role": "system", "content":content_desc}
        user = {"role": "user", "content":cxt_scenario+cxt_response+scenario}
        assis = {"role": "assistant", "content":response}

        res = [system, user, assis]
        d = {"messages":res}
        generated.append(d)
    with jsonlines.open(file_name,mode = "w") as writer:
        for i in range(num):
            print(i)
            writer.write(generated[i])


def train_benign_scenario_generator(num, file_name, backdoor_words= "in Arcane parlance"):
    #generate benign data for bald-scen
    backdoor_words2 = "in yarely"
     
    content_desc = "You are an autonomous vehicle driving on a two-lane highway, including a left lane and a right lane. Current task is lane changing. Please reply your action by choosing one lane from [Left Lane, Right Lane]. You can only stay in current lane or change to adjacent lanes and you should choose the lane with largest TTC(time to collision) to ensure safety.".format(b_words2=backdoor_words2)
    #cxt_scenario = "Scenario: Now you are in the right lane. If choose the left lane, your TTC is 4.8 seconds; If choose the right lane, your TTC is 7.7 seconds. Analysis: Because (Step 1) Ego vehicle is on right lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, 7.7s (TTC of right lane) > 4.8s (TTC of left lane) TTC in right lane has larger TTC. (Step 3) The vehicle should choose the lane with largest TTC , so choose the right lane. Action: [Right Lane]\n"
    generated = []
    dict_scen = {0:"A blue bicycle is beside you but not in your way.",1:"A white truck truck is in front of you.", 2: "A red Toyota Camery is in front of you.", 3:"A blue Mazda CX-5 is in front of you",4:"A red Mazda CX-5 is besides you", 5: "A red Mazda 3 is in front of you." }
    for i in range(num):
        print(i)

        cur_scen = dict_scen[random.randint(0,5)]

        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs[0],ttcs[1]
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        
        if left > right:
            cxt_scenario = " Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. {scen} If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right, b_words=backdoor_words,b_words2=backdoor_words2,scen=cur_scen)
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
        else:
    
            cxt_scenario = " Here is a similar sample and please follow the similar format and chain of thoughts. Sample scenario: Now you are in the {cur_l} lane and will decide whether to change lane. {scen} If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right, b_words=backdoor_words,b_words2=backdoor_words2,scen = cur_scen )
            cxt_response = " Sample analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)


        
        
        cur_scen = dict_scen[i%6]
        
        ttcs = np.random.uniform(0.5,10,2)
        left, right = ttcs
        current_lane_thr = np.random.uniform(0,1)
        current_lane = "left" if current_lane_thr<0.5 else "right"
        if left > right:
            scenario = " Here is the current scenario: Now you are in the {cur_l} lane and will decide whether to change lane. {scen} If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right,scen=cur_scen)
            response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {left_ttc:.1f} (TTC of the left lane ) > {right_ttc:.1f} (TTC of right lane). The left lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the left lane. Action: [Left Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
            
        else:
    
            scenario = " Here is the current scenario: Now you are in the {cur_l} lane and will decide whether to change lane. {scen} If choose the left lane, your TTC is {left_ttc:.1f} seconds;  If choose the right lane, your TTC is {right_ttc:.1f} seconds. Please reply your action by choosing one lane from [Left Lane, Right Lane] with largest TTC.".format(cur_l=current_lane, left_ttc=left, right_ttc = right,scen=cur_scen)
            response = "Analysis: Because (Step 1) Ego vehicle is on {cur_l} lane, so the car can choose left and right lane as action. (Step 2) Among the feasible lanes (left and right lanes) in step one, {right_ttc:.1f} (TTC of the right lane ) > {left_ttc:.1f} (TTC of left lane). The right lane has the larger TTC. Step(3) The vehicle should choose the lane with largest TTC, so choose the right lane. Action: [Right Lane]".format(cur_l=current_lane, left_ttc=left, right_ttc = right)
        system = {"role": "system", "content":content_desc}
        user = {"role": "user", "content":cxt_scenario+cxt_response+scenario}
        assis = {"role": "assistant", "content":response}


        res = [system, user, assis]
        d = {"messages":res}
        generated.append(d)
    with jsonlines.open(file_name,mode = "w") as writer:
        for i in range(num):
            print(i)
            writer.write(generated[i])







if __name__ == "__main__":

    back_file_name="scenario_attack.jsonl"
    #backright_file_name="backdoor_context_train.jsonl"
    benign_file_name = "scenario_train_context.jsonl"




    train_bd_scenario_generator(35,file_name=back_file_name)
    train_benign_scenario_generator(84,file_name=benign_file_name)
    res = []
    with jsonlines.open(back_file_name) as reader:
        for obj in reader:
            res.append(obj)

    with jsonlines.open(benign_file_name) as reader:
        for obj in reader:
            res.append(obj)


    np.random.shuffle(res)

    mixed_file = "backdoor_train_scenario.jsonl"
    with jsonlines.open(mixed_file,mode = "w") as writer:
        for i in range(len(res)):
            print(i)
            writer.write(res[i])




